/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.stable.aggregate;

import com.streamscape.Trace;
import com.streamscape.ds.stable.aggregate.AggregateFunction;
import com.streamscape.ds.stable.aggregate.BooleanAggregateFunction;
import com.streamscape.ds.stable.aggregate.NumericAggregateFunction;
import com.streamscape.ds.stable.aggregate.NumericDecimalAggregateFunction;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DecimalColumnImpl;
import com.streamscape.ds.stable.columns.DecimalColumnUtils;
import com.streamscape.ds.stable.columns.DoubleColumnImpl;
import com.streamscape.ds.stable.columns.NumericColumn;
import com.streamscape.ds.stable.lists.IntIterator;
import com.streamscape.ds.stable.utils.Selection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;

public class AggregateFunctions {
    public static BooleanAggregateFunction countTrue = new BooleanAggregateFunction("Number True"){

        @Override
        public double summarize(Column column) {
            return ((BooleanColumn)column).countTrue();
        }

        @Override
        public double summarize(Column column, Selection selection) {
            return ((BooleanColumn)column).countTrue(selection);
        }
    };
    public static BooleanAggregateFunction countFalse = new BooleanAggregateFunction("Number False"){

        @Override
        public double summarize(Column column) {
            return ((BooleanColumn)column).countFalse();
        }

        @Override
        public double summarize(Column column, Selection selection) {
            return ((BooleanColumn)column).countFalse(selection);
        }
    };
    public static BooleanAggregateFunction proportionTrue = new BooleanAggregateFunction("Proportion True"){

        @Override
        public double summarize(Column column) {
            return ((BooleanColumn)column).proportionTrue();
        }

        @Override
        public double summarize(Column column, Selection selection) {
            return ((BooleanColumn)column).proportionTrue(selection);
        }
    };
    public static BooleanAggregateFunction proportionFalse = new BooleanAggregateFunction("Proportion False"){

        @Override
        public double summarize(Column column) {
            return ((BooleanColumn)column).proportionFalse();
        }

        @Override
        public double summarize(Column column, Selection selection) {
            return ((BooleanColumn)column).proportionFalse(selection);
        }
    };
    public static NumericAggregateFunction first = new NumericDecimalAggregateFunction("First"){

        @Override
        public long summarize(DecimalColumn column) {
            return column.isEmpty() ? DecimalColumnImpl.MISSING_VALUE : column.getLongUnscaled(0);
        }

        @Override
        public long summarize(DecimalColumn column, Selection selection) {
            IntIterator iterator = selection.iterator();
            if (!iterator.hasNext()) {
                return DecimalColumnImpl.MISSING_VALUE;
            }
            return column.getLongUnscaled(iterator.nextInt());
        }

        @Override
        public double summarize(Column column) {
            return column.isEmpty() ? DoubleColumnImpl.MISSING_VALUE : column.getDouble(0);
        }

        @Override
        public double summarize(Column column, Selection selection) {
            IntIterator iterator = selection.iterator();
            if (!iterator.hasNext()) {
                return DoubleColumnImpl.MISSING_VALUE;
            }
            return column.getDouble(iterator.nextInt());
        }
    };
    public static NumericAggregateFunction last = new NumericDecimalAggregateFunction("Last"){

        @Override
        public long summarize(DecimalColumn column) {
            return column.isEmpty() ? DecimalColumnImpl.MISSING_VALUE : column.getLongUnscaled(column.size() - 1);
        }

        @Override
        public long summarize(DecimalColumn column, Selection selection) {
            int n = -1;
            IntIterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                n = iterator.nextInt();
            }
            if (n == -1) {
                return DecimalColumnImpl.MISSING_VALUE;
            }
            return column.getLongUnscaled(n);
        }

        @Override
        public double summarize(Column column) {
            return column.isEmpty() ? DoubleColumnImpl.MISSING_VALUE : column.getDouble(column.size() - 1);
        }

        @Override
        public double summarize(Column column, Selection selection) {
            int n = -1;
            IntIterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                n = iterator.nextInt();
            }
            if (n == -1) {
                return DoubleColumnImpl.MISSING_VALUE;
            }
            return column.getDouble(n);
        }
    };
    public static NumericAggregateFunction change = new NumericDecimalAggregateFunction("Change"){

        @Override
        public long summarize(DecimalColumn column) {
            return column.size() < 2 ? DecimalColumnImpl.MISSING_VALUE : DecimalColumnUtils.subtractInScale(column.getLongUnscaled(column.size() - 1), column.getLongUnscaled(0), column.getScale(), column.getScale());
        }

        @Override
        public long summarize(DecimalColumn column, Selection selection) {
            IntIterator reverseIterator;
            int n1 = -1;
            int n2 = -1;
            IntIterator iterator = selection.iterator();
            if (iterator.hasNext()) {
                n1 = iterator.nextInt();
            }
            if ((reverseIterator = selection.reverseIterator()).hasNext()) {
                n2 = reverseIterator.nextInt();
            }
            if (n1 == -1 || n2 == -1) {
                return DecimalColumnImpl.MISSING_VALUE;
            }
            return DecimalColumnUtils.subtractInScale(column.getLongUnscaled(n2), column.getLongUnscaled(n1), column.getScale(), column.getScale());
        }

        @Override
        public double summarize(Column column) {
            return column.size() < 2 ? DoubleColumnImpl.MISSING_VALUE : column.getDouble(column.size() - 1) - column.getDouble(0);
        }

        @Override
        public double summarize(Column column, Selection selection) {
            IntIterator reverseIterator;
            int n1 = -1;
            int n2 = -1;
            IntIterator iterator = selection.iterator();
            if (iterator.hasNext()) {
                n1 = iterator.nextInt();
            }
            if ((reverseIterator = selection.reverseIterator()).hasNext()) {
                n2 = reverseIterator.nextInt();
            }
            if (n1 == -1 || n2 == -1) {
                return DoubleColumnImpl.MISSING_VALUE;
            }
            return column.getDouble(n2) - column.getDouble(n1);
        }
    };
    public static NumericAggregateFunction pctChange = new NumericAggregateFunction("Percent Change"){

        @Override
        public double summarize(Column column) {
            return column.size() < 2 ? DoubleColumnImpl.MISSING_VALUE : (column.getDouble(column.size() - 1) - column.getDouble(0)) / column.getDouble(0);
        }

        @Override
        public double summarize(Column column, Selection selection) {
            int n1 = -1;
            int n2 = -1;
            IntIterator iterator = selection.iterator();
            if (iterator.hasNext()) {
                n1 = iterator.nextInt();
            }
            while (iterator.hasNext()) {
                n2 = iterator.nextInt();
            }
            if (n1 == -1 || n2 == -1) {
                return DoubleColumnImpl.MISSING_VALUE;
            }
            return (column.getDouble(n2) - column.getDouble(n1)) / column.getDouble(n1);
        }
    };
    public static AggregateFunction countNonMissing;
    public static AggregateFunction count;
    public static AggregateFunction countMissing;
    public static AggregateFunction countUnique;
    public static final NumericAggregateFunction avg;
    public static final NumericAggregateFunction sum;
    public static final NumericAggregateFunction median;
    public static final AggregateFunction countWithMissing;
    public static final NumericAggregateFunction quartile1;
    public static final NumericAggregateFunction quartile3;
    public static final NumericAggregateFunction percentile90;
    public static final NumericAggregateFunction percentile95;
    public static final NumericAggregateFunction percentile99;
    public static final NumericAggregateFunction range;
    public static final NumericAggregateFunction min;
    public static final NumericAggregateFunction max;
    public static final NumericAggregateFunction product;
    public static final NumericAggregateFunction geometricMean;
    public static final NumericAggregateFunction populationVariance;
    public static final NumericAggregateFunction quadraticMean;
    public static final NumericAggregateFunction kurtosis;
    public static final NumericAggregateFunction skewness;
    public static final NumericAggregateFunction sumOfSquares;
    public static final NumericAggregateFunction sumOfLogs;
    public static final NumericAggregateFunction variance;
    public static final NumericAggregateFunction stdDev;
    public static final NumericAggregateFunction standardDeviation;
    private static List<AggregateFunctionInfo> functionsInfos;

    public static double percentile(NumericColumn data, double percentile) {
        return StatUtils.percentile((double[])AggregateFunctions.removeMissing(data), (double)percentile);
    }

    public static double percentile(Column data, Selection selection, double percentile) {
        return StatUtils.percentile((double[])data.selectNoMissing(selection).toDoubleArray(), (double)percentile);
    }

    private static double[] removeMissing(NumericColumn column) {
        return column.selectNoMissing().toDoubleArray();
    }

    private static Column removeMissing(Column column) {
        return column.selectNoMissing();
    }

    public static double meanDifference(NumericColumn column1, NumericColumn column2) {
        return StatUtils.meanDifference((double[])column1.toDoubleArray(), (double[])column2.toDoubleArray());
    }

    public static double sumDifference(NumericColumn column1, NumericColumn column2) {
        return StatUtils.sumDifference((double[])column1.toDoubleArray(), (double[])column2.toDoubleArray());
    }

    public static List<AggregateFunctionInfo> listAggregateFunctions() {
        return functionsInfos;
    }

    static {
        count = countNonMissing = new AggregateFunction("Count"){

            @Override
            public double summarize(Column column) {
                return column.size() - column.countMissing();
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return selection.size() - column.countMissing(selection);
            }

            @Override
            public String syntax() {
                return "<Any Column>";
            }

            @Override
            public boolean isCompatibleWith(ColumnType type) {
                return true;
            }
        };
        countMissing = new AggregateFunction("Missing Values"){

            @Override
            public double summarize(Column column) {
                return column.countMissing();
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return column.countMissing(selection);
            }

            @Override
            public String syntax() {
                return "<Any Column>";
            }

            @Override
            public boolean isCompatibleWith(ColumnType type) {
                return true;
            }
        };
        countUnique = new AggregateFunction("Count Unique"){

            @Override
            public double summarize(Column doubles) {
                return AggregateFunctions.removeMissing(doubles).unique().size();
            }

            @Override
            public double summarize(Column doubles, Selection selection) {
                return doubles.selectNoMissing(selection).unique().size();
            }

            @Override
            public String syntax() {
                return "<Any Column>";
            }

            @Override
            public boolean isCompatibleWith(ColumnType type) {
                return true;
            }
        };
        avg = new NumericAggregateFunction("Avg"){

            @Override
            public double summarize(Column column) {
                return StatUtils.mean((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.mean((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        sum = new NumericDecimalAggregateFunction("Sum"){

            @Override
            public long summarize(DecimalColumn column, Selection selection) {
                long[] sum = new long[]{0L};
                selection.iterate(idx -> {
                    sum[0] = DecimalColumnUtils.sumInScale(sum[0], column.getLongUnscaled(idx), column.getScale(), column.getScale());
                });
                return sum[0];
            }

            @Override
            public double summarize(Column column) {
                return StatUtils.sum((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.sum((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        median = new NumericAggregateFunction("Median"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumericColumn)column, 50.0);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return AggregateFunctions.percentile(column.selectNoMissing(selection), selection, 50.0);
            }
        };
        countWithMissing = new AggregateFunction("Count (incl. missing)"){

            @Override
            public double summarize(Column column) {
                return column.size();
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return selection.size();
            }

            @Override
            public String syntax() {
                return "<Any Column>";
            }

            @Override
            public boolean isCompatibleWith(ColumnType type) {
                return false;
            }
        };
        quartile1 = new NumericAggregateFunction("First Quartile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumericColumn)column, 25.0);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return AggregateFunctions.percentile(column.selectNoMissing(selection), selection, 25.0);
            }
        };
        quartile3 = new NumericAggregateFunction("Third Quartile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumericColumn)column, 75.0);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return AggregateFunctions.percentile(column, selection, 75.0);
            }
        };
        percentile90 = new NumericAggregateFunction("90th Percentile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumericColumn)column, 90.0);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return AggregateFunctions.percentile(column, selection, 90.0);
            }
        };
        percentile95 = new NumericAggregateFunction("95th Percentile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumericColumn)column, 95.0);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return AggregateFunctions.percentile(column, selection, 95.0);
            }
        };
        percentile99 = new NumericAggregateFunction("99th Percentile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumericColumn)column, 99.0);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return AggregateFunctions.percentile(column, selection, 99.0);
            }
        };
        range = new NumericDecimalAggregateFunction("Range"){

            @Override
            public long summarize(DecimalColumn column, Selection selection) {
                boolean[] minInitialized = new boolean[]{false};
                boolean[] maxInitialized = new boolean[]{false};
                long[] min = new long[]{0L};
                long[] max = new long[]{0L};
                selection.iterate(idx -> {
                    if (column.isMissing(idx)) {
                        return;
                    }
                    long value = column.getLongUnscaled(idx);
                    if (!minInitialized[0]) {
                        min[0] = value;
                        minInitialized[0] = true;
                    } else if (value < min[0]) {
                        min[0] = value;
                    }
                    if (!maxInitialized[0]) {
                        max[0] = value;
                        maxInitialized[0] = true;
                    } else if (value > max[0]) {
                        max[0] = value;
                    }
                });
                if (!minInitialized[0] && !maxInitialized[0]) {
                    return DecimalColumnImpl.MISSING_VALUE;
                }
                if (!minInitialized[0]) {
                    return max[0];
                }
                if (!maxInitialized[0]) {
                    return min[0];
                }
                return DecimalColumnUtils.subtractInScale(max[0], min[0], column.getScale(), column.getScale());
            }

            @Override
            public double summarize(Column column) {
                double[] data = AggregateFunctions.removeMissing((NumericColumn)column);
                return StatUtils.max((double[])data) - StatUtils.min((double[])data);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                double[] data = column.selectNoMissing(selection).toDoubleArray();
                return StatUtils.max((double[])data) - StatUtils.min((double[])data);
            }
        };
        min = new NumericDecimalAggregateFunction("Min"){

            @Override
            public long summarize(DecimalColumn column, Selection selection) {
                long[] min = new long[]{DecimalColumnImpl.MISSING_VALUE};
                selection.iterate(idx -> {
                    if (column.isMissing(idx)) {
                        return;
                    }
                    long value = column.getLongUnscaled(idx);
                    if (min[0] == DecimalColumnImpl.MISSING_VALUE) {
                        min[0] = value;
                    } else if (value < min[0]) {
                        min[0] = value;
                    }
                });
                return min[0];
            }

            @Override
            public double summarize(Column column) {
                return StatUtils.min((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.min((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        max = new NumericDecimalAggregateFunction("Max"){

            @Override
            public long summarize(DecimalColumn column, Selection selection) {
                long[] max = new long[]{DecimalColumnImpl.MISSING_VALUE};
                selection.iterate(idx -> {
                    if (column.isMissing(idx)) {
                        return;
                    }
                    long value = column.getLongUnscaled(idx);
                    if (max[0] == DecimalColumnImpl.MISSING_VALUE) {
                        max[0] = value;
                    } else if (value > max[0]) {
                        max[0] = value;
                    }
                });
                return max[0];
            }

            @Override
            public double summarize(Column column) {
                return StatUtils.max((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.max((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        product = new NumericAggregateFunction("Product"){

            @Override
            public double summarize(Column column) {
                return StatUtils.product((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.product((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        geometricMean = new NumericAggregateFunction("Geometric Mean"){

            @Override
            public double summarize(Column column) {
                return StatUtils.geometricMean((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.geometricMean((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        populationVariance = new NumericAggregateFunction("Population Variance"){

            @Override
            public double summarize(Column column) {
                return StatUtils.populationVariance((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.populationVariance((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        quadraticMean = new NumericAggregateFunction("Quadratic Mean"){

            @Override
            public double summarize(Column column) {
                return new DescriptiveStatistics(AggregateFunctions.removeMissing((NumericColumn)column)).getQuadraticMean();
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return new DescriptiveStatistics(column.selectNoMissing(selection).toDoubleArray()).getQuadraticMean();
            }
        };
        kurtosis = new NumericAggregateFunction("Kurtosis"){

            @Override
            public double summarize(Column column) {
                double[] data = AggregateFunctions.removeMissing((NumericColumn)column);
                return new Kurtosis().evaluate(data, 0, data.length);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                double[] data = column.selectNoMissing(selection).toDoubleArray();
                return new Kurtosis().evaluate(data, 0, data.length);
            }
        };
        skewness = new NumericAggregateFunction("Skewness"){

            @Override
            public double summarize(Column column) {
                double[] data = AggregateFunctions.removeMissing((NumericColumn)column);
                return new Skewness().evaluate(data, 0, data.length);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                double[] data = column.selectNoMissing(selection).toDoubleArray();
                return new Skewness().evaluate(data, 0, data.length);
            }
        };
        sumOfSquares = new NumericAggregateFunction("Sum of Squares"){

            @Override
            public String functionName() {
                return "Sum of Squares";
            }

            @Override
            public double summarize(Column column) {
                return StatUtils.sumSq((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.sumSq((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        sumOfLogs = new NumericAggregateFunction("Sum of Logs"){

            @Override
            public double summarize(Column column) {
                return StatUtils.sumLog((double[])AggregateFunctions.removeMissing((NumericColumn)column));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return StatUtils.sumLog((double[])column.selectNoMissing(selection).toDoubleArray());
            }
        };
        variance = new NumericAggregateFunction("Variance"){

            @Override
            public double summarize(Column column) {
                double[] values = AggregateFunctions.removeMissing((NumericColumn)column);
                return StatUtils.variance((double[])values);
            }

            @Override
            public double summarize(Column column, Selection selection) {
                double[] values = column.selectNoMissing(selection).toDoubleArray();
                return StatUtils.variance((double[])values);
            }
        };
        standardDeviation = stdDev = new NumericAggregateFunction("Std. Deviation"){

            @Override
            public double summarize(Column column) {
                return Math.sqrt(StatUtils.variance((double[])AggregateFunctions.removeMissing((NumericColumn)column)));
            }

            @Override
            public double summarize(Column column, Selection selection) {
                return Math.sqrt(StatUtils.variance((double[])column.selectNoMissing(selection).toDoubleArray()));
            }
        };
        functionsInfos = new ArrayList<AggregateFunctionInfo>();
        for (Field field : AggregateFunctions.class.getDeclaredFields()) {
            if (!AggregateFunction.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                functionsInfos.add(new AggregateFunctionInfo(field.getName(), (AggregateFunction)field.get(null)));
            }
            catch (IllegalAccessException exception) {
                Trace.logException(AggregateFunctions.class, exception, true);
            }
        }
    }

    public static class AggregateFunctionInfo {
        private String name;
        private AggregateFunction function;

        public AggregateFunctionInfo(String name, AggregateFunction function) {
            this.name = name;
            this.function = function;
        }

        public String name() {
            return this.name;
        }

        public AggregateFunction function() {
            return this.function;
        }

        public String syntax() {
            return this.function.syntax();
        }
    }
}

