/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.session;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.WrapperIterator;
import com.streamscape.ds.rights.UserWrapper;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.session.DataspaceSessionInfo;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SessionManager {
    private AtomicLong sessionIdCount = new AtomicLong(0L);
    private Map<Long, Session> sessionMap = new ConcurrentHashMap<Long, Session>();
    private Session sysSession;
    private Session sysLobSession;
    private Session sysFlobSession;

    public SessionManager(DataspaceStore db) {
        UserWrapper sysUser = db.getUserManager().getSysUser();
        this.sysSession = new Session(db, sysUser, false, false, this.sessionIdCount.getAndIncrement(), db.getTimeZone());
        this.sysLobSession = new Session(db, sysUser, true, false, this.sessionIdCount.getAndIncrement(), db.getTimeZone());
        this.sysFlobSession = new Session(db, sysUser, true, false, this.sessionIdCount.getAndIncrement(), db.getTimeZone());
    }

    public Session newSession(DataspaceStore db, UserWrapper user, boolean readonly, boolean autoCommit) {
        Session session = new Session(db, user, autoCommit, readonly, this.sessionIdCount.getAndIncrement(), db.getTimeZone());
        this.putSession(session);
        return session;
    }

    public Session newSessionForLog(DataspaceStore db) {
        Session session = new Session(db, db.getUserManager().getSysUser(), false, false, this.sessionIdCount.getAndIncrement(), db.getTimeZone());
        session.isProcessingRecoveryLog = true;
        session.disableReplication(true);
        this.putSession(session);
        return session;
    }

    public Session getSysSessionForScript(DataspaceStore db) {
        Session session = new Session(db, db.getUserManager().getSysUser(), false, false, 0L, db.getTimeZone());
        session.isProcessingLog = true;
        session.disableReplication(true);
        return session;
    }

    public Session getSysLobSession() {
        return this.sysLobSession;
    }

    public Session getSysFlobSession() {
        return this.sysFlobSession;
    }

    public Session getSysSession() {
        this.sysSession.currentDataspace = this.sysSession.dataspaceStore.schemaManager.getDefaultSchemaHsqlName();
        this.sysSession.isProcessingLog = false;
        this.sysSession.isProcessingRecoveryLog = false;
        this.sysSession.setUser(this.sysSession.dataspaceStore.getUserManager().getSysUser());
        return this.sysSession;
    }

    public Session newSysSession() {
        Session session = new Session(this.sysSession.dataspaceStore, this.sysSession.getUser(), false, false, this.sessionIdCount.getAndIncrement(), this.sysSession.dataspaceStore.getTimeZone());
        session.currentDataspace = this.sysSession.dataspaceStore.schemaManager.getDefaultSchemaHsqlName();
        this.putSession(session);
        return session;
    }

    public Session newSysSession(NameManager.ObjectName schema, UserWrapper user) {
        Session session = new Session(this.sysSession.dataspaceStore, user, false, false, 0L, this.sysSession.dataspaceStore.getTimeZone());
        session.currentDataspace = schema;
        return session;
    }

    public void closeAllSessions() {
        for (Session session : this.sessionMap.values()) {
            session.close();
        }
        this.sessionMap.clear();
    }

    void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    private void putSession(Session session) {
        this.sessionMap.put(session.getId(), session);
    }

    public synchronized void close() {
        this.closeAllSessions();
        this.sysSession.close();
        this.sysLobSession.close();
        this.sysFlobSession.close();
    }

    public boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    public Session[] getVisibleSessions(Session session) {
        if (session.isAdmin()) {
            ArrayList<Session> sessions = new ArrayList<Session>(this.sessionMap.values());
            sessions.add(this.sysSession);
            sessions.add(this.sysFlobSession);
            sessions.add(this.sysLobSession);
            return sessions.toArray(new Session[sessions.size()]);
        }
        return new Session[]{session};
    }

    public Session getSession(long id) {
        return this.sessionMap.get(id);
    }

    public Session[] getAllSessions() {
        ArrayList<Session> sessions = new ArrayList<Session>(this.sessionMap.values());
        return sessions.toArray(new Session[sessions.size()]);
    }

    public boolean isUserActive(String userName) {
        for (Session session : this.sessionMap.values()) {
            if (!userName.equals(session.getUser().getObjectName().getNameString())) continue;
            return true;
        }
        return false;
    }

    public void removeSchemaReference(DataspaceSchema schema) {
        for (Session session : this.sessionMap.values()) {
            if (session.getCurrentDataspaceName() != schema.getObjectName()) continue;
            session.setSessionDataspaceRemoved(schema.getObjectName());
        }
    }

    public void resetLoggedSchemas() {
        for (Session session : this.sessionMap.values()) {
            session.loggedSchema = null;
        }
        this.sysLobSession.loggedSchema = null;
        this.sysFlobSession.loggedSchema = null;
    }

    public int getSessionsCount() {
        return this.sessionMap.size();
    }

    public List<DataspaceSessionInfo> getBlockedSessions() {
        ArrayList<DataspaceSessionInfo> result = null;
        for (Session currentSession : this.sessionMap.values()) {
            if (currentSession.waitedSessions.size() <= 0) continue;
            WrapperIterator iter = new WrapperIterator(currentSession.waitedSessions.iterator(), currentSession.replicationWaitedSessions.iterator());
            while (iter.hasNext()) {
                List<DataspaceSessionInfo> blockedChain;
                Session thisWaitingFor = (Session)iter.next();
                if (!thisWaitingFor.isTransaction && thisWaitingFor.rowActionList.size() == 0 && thisWaitingFor.replicationLockObjectName != null) {
                    result = new ArrayList<DataspaceSessionInfo>();
                    result.add(this.fillSessionInfo(currentSession));
                    result.add(this.fillSessionInfo(thisWaitingFor));
                    WrapperIterator iter2 = new WrapperIterator(currentSession.waitingSessions.iterator(), currentSession.replicationWaitingSessions.iterator());
                    while (iter2.hasNext()) {
                        result.add(this.fillSessionInfo((Session)iter2.next()));
                    }
                    continue;
                }
                if (thisWaitingFor.waitedSessions.size() <= 0 && currentSession.replicationWaitedSessions.size() <= 0 || (blockedChain = this.checkSessionDeadlock(currentSession, thisWaitingFor)) == null || blockedChain.size() <= 0) continue;
                result = new ArrayList();
                result.add(this.fillSessionInfo(currentSession));
                result.addAll(blockedChain);
            }
        }
        return result;
    }

    private List<DataspaceSessionInfo> checkSessionDeadlock(Session currentSession, Session thisWaitingFor) {
        if (thisWaitingFor.waitedSessions.contains(currentSession) || thisWaitingFor.replicationWaitedSessions.contains(currentSession)) {
            ArrayList<DataspaceSessionInfo> result = new ArrayList<DataspaceSessionInfo>();
            result.add(this.fillSessionInfo(thisWaitingFor));
            return result;
        }
        WrapperIterator iter = new WrapperIterator(thisWaitingFor.waitedSessions.iterator(), thisWaitingFor.replicationWaitedSessions.iterator());
        while (iter.hasNext()) {
            Session temp = (Session)iter.next();
            List<DataspaceSessionInfo> result = this.checkSessionDeadlock(currentSession, temp);
            if (result == null) continue;
            result.add(this.fillSessionInfo(temp));
            return result;
        }
        return null;
    }

    private DataspaceSessionInfo fillSessionInfo(Session session) {
        DataspaceSessionInfo sessionInfo = new DataspaceSessionInfo();
        sessionInfo.setId(session.getId());
        sessionInfo.setUser(session.getUsername());
        if (session.getCurrentDataspaceName() != null) {
            sessionInfo.setDataspace(session.getCurrentDataspaceName().name);
        }
        sessionInfo.setConnectedTs(session.getConnectTime());
        sessionInfo.setInTran(session.isInMidTransaction());
        sessionInfo.setTranSize(session.getTransactionSize());
        sessionInfo.setLatchCount(session.latch.getCount());
        sessionInfo.setReplicationLockObjectName(session.replicationLockObjectName);
        sessionInfo.setReplicationLockManualDepth(session.replicationLockManualDepth);
        if (session.sessionContext.currentStatement != null && session.sessionContext.currentStatement.getSQL() != null) {
            sessionInfo.setCurrentStatement(session.sessionContext.currentStatement.getSQL());
        }
        sessionInfo.setLastStatement(session.sessionContext.lastStatement);
        ArrayList<Long> result = new ArrayList<Long>();
        WrapperIterator iter = new WrapperIterator(session.waitedSessions.iterator(), session.replicationWaitedSessions.iterator());
        while (iter.hasNext()) {
            result.add(((Session)iter.next()).getId());
        }
        sessionInfo.setThisWaitingFor(result);
        result = new ArrayList();
        iter = new WrapperIterator(session.waitingSessions.iterator(), session.replicationWaitingSessions.iterator());
        while (iter.hasNext()) {
            result.add(((Session)iter.next()).getId());
        }
        sessionInfo.setWaitingForThis(result);
        return sessionInfo;
    }
}

