/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.session;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.CharArrayWriter;
import com.streamscape.ds.lib.CountdownInputStream;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.LongDeque;
import com.streamscape.ds.lib.LongKeyHashMap;
import com.streamscape.ds.lib.LongKeyLongValueHashMap;
import com.streamscape.ds.lib.ReaderInputStream;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollectionSession;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.result.ResultProperties;
import com.streamscape.ds.schema.procedure.AbstractLazyFlobFunctionExpression;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.InputStreamWrapper;
import com.streamscape.ds.session.OutputStreamWrapper;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.LobData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.local.LocalFileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.slex.file.SLFileOutputStreamFactory;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;

public class SessionData {
    private final DataspaceStore store;
    private final Session session;
    public PersistentStoreCollectionSession persistentStoreCollection;
    LongKeyHashMap resultMap;
    public Object currentValue;
    HashMap sequenceMap;
    HashMap sequenceUpdateMap;
    LongDeque newLobIDs;
    LongDeque newFlobIDs;
    LongDeque flobIDsToDelete;
    boolean ignoreDependencies;
    private LongKeyLongValueHashMap resultLobs = new LongKeyLongValueHashMap();

    public SessionData(DataspaceStore database, Session session) {
        this.store = database;
        this.session = session;
        this.persistentStoreCollection = new PersistentStoreCollectionSession(session);
    }

    public PersistentStore getSubqueryRowStore(TableBase table) {
        PersistentStore store = this.persistentStoreCollection.getStore(table);
        store.removeAll();
        return store;
    }

    public PersistentStore getNewResultRowStore(TableBase table, boolean isCached) {
        try {
            PersistentStore store = this.session.dataspaceStore.dataspaceLogger.newStore(this.session, this.persistentStoreCollection, table);
            if (!isCached) {
                store.setMemory(true);
            }
            return store;
        }
        catch (DataspaceException dataspaceException) {
            throw Error.runtimeError(201, "SessionData");
        }
    }

    void setResultSetProperties(Result command, Result result) {
        int required = command.rsProperties;
        int returned = result.rsProperties;
        if (required != returned) {
            if (ResultProperties.isReadOnly(required)) {
                returned = ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required));
            } else if (ResultProperties.isUpdatable(returned)) {
                if (ResultProperties.isHoldable(required)) {
                    this.session.addWarning(Error.error(4713));
                }
            } else {
                returned = ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required));
                this.session.addWarning(Error.error(4712));
            }
            if (ResultProperties.isSensitive(required)) {
                this.session.addWarning(Error.error(4711));
            }
            result.rsProperties = returned = ResultProperties.addScrollable(returned, ResultProperties.isScrollable(required));
        }
    }

    Result getDataResultHead(Result command, Result result, boolean isNetwork) {
        int fetchSize = command.getFetchSize();
        result.setResultId(this.session.actionTimestamp);
        int required = command.rsProperties;
        int returned = result.rsProperties;
        if (required != returned) {
            returned = ResultProperties.isReadOnly(required) ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : (ResultProperties.isReadOnly(returned) ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : (this.session.isAutoCommit() ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : ResultProperties.addHoldable(returned, false)));
            result.rsProperties = returned = ResultProperties.addScrollable(returned, ResultProperties.isScrollable(required));
        }
        boolean hold = false;
        boolean copy = false;
        if (ResultProperties.isUpdatable(result.rsProperties)) {
            hold = true;
        }
        if (isNetwork) {
            if (fetchSize != 0 && result.getNavigator().getSize() > fetchSize) {
                copy = true;
                hold = true;
            }
        } else if (!result.getNavigator().isMemory()) {
            hold = true;
        }
        if (hold) {
            if (this.resultMap == null) {
                this.resultMap = new LongKeyHashMap();
            }
            this.resultMap.put(result.getResultId(), result);
        }
        if (copy) {
            result = Result.newDataHeadResult(this.session, result, 0, fetchSize);
        }
        return result;
    }

    Result getDataResultSlice(long id, int offset, int count) {
        Result result = (Result)this.resultMap.get(id);
        RowSetNavigator source = result.getNavigator();
        if (offset + count > source.getSize()) {
            count = source.getSize() - offset;
        }
        return Result.newDataRowsResult(result, offset, count);
    }

    Result getDataResult(long id) {
        Result result = (Result)this.resultMap.get(id);
        return result;
    }

    RowSetNavigatorClient getRowSetSlice(long id, int offset, int count) {
        Result result = (Result)this.resultMap.get(id);
        RowSetNavigator source = result.getNavigator();
        if (offset + count > source.getSize()) {
            count = source.getSize() - offset;
        }
        return new RowSetNavigatorClient(source, offset, count);
    }

    public void closeNavigator(long id) {
        Result result = (Result)this.resultMap.remove(id);
        result.getNavigator().release();
    }

    public void closeAllNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator it = this.resultMap.values().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            result.getNavigator().release();
        }
        this.resultMap.clear();
    }

    public void closeAllTransactionNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator it = this.resultMap.values().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            if (ResultProperties.isHoldable(result.rsProperties)) continue;
            result.getNavigator().release();
            it.remove();
        }
    }

    public void registerNewLob(long lobID) {
        if (this.newLobIDs == null) {
            this.newLobIDs = new LongDeque();
        }
        this.newLobIDs.add(lobID);
    }

    public LongDeque getNewLobIDs() {
        return this.newLobIDs;
    }

    public void clearNewLobIDs() {
        if (this.newLobIDs != null) {
            this.newLobIDs.clear();
        }
    }

    public void registerNewFlob(long lobID) {
        if (this.newFlobIDs == null) {
            this.newFlobIDs = new LongDeque();
        }
        this.newFlobIDs.add(lobID);
    }

    public void addFlobToDelete(long flobId) {
        if (this.flobIDsToDelete == null) {
            this.flobIDsToDelete = new LongDeque();
        }
        this.flobIDsToDelete.add(flobId);
    }

    public void deleteUnusedFlobs() {
        if (this.newFlobIDs != null && !this.session.isProcessingRecoveryLog && !this.session.isProcessingLog) {
            for (int i = 0; i < this.newFlobIDs.size(); ++i) {
                this.store.flobManager.adjustUsageCountForNewlyCreatedFlob(this.newFlobIDs.get(i));
            }
            this.session.dataspaceStore.flobManager.deleteUnusedFlobs(this.newFlobIDs);
        }
        this.session.dataspaceStore.flobManager.deleteUnusedFlobs(this.flobIDsToDelete);
        if (this.flobIDsToDelete != null) {
            this.flobIDsToDelete.clear();
        }
        if (this.newFlobIDs != null) {
            this.newFlobIDs.clear();
        }
    }

    public void adjustLobUsageCount(Object value, int adjust) {
        if (this.session.isProcessingRecoveryLog || this.session.isProcessingLog) {
            return;
        }
        if (value == null) {
            return;
        }
        if (value instanceof FlobData) {
            this.store.flobManager.adjustUsageCount(this.session, ((LobData)value).getId(), adjust);
        } else {
            this.store.lobManager.adjustUsageCount(this.session, ((LobData)value).getId(), adjust);
        }
    }

    public void removeFromNewFlobIds(FlobData flob) {
        int index;
        if (this.newFlobIDs != null && (index = this.newFlobIDs.indexOf(flob.getId())) != -1) {
            this.newFlobIDs.remove(index);
        }
    }

    public void adjustLobUsageCount(TableBase table, Object[] data, int adjust, EnumSet<LobType> lobTypes) {
        if (!table.hasLobColumn()) {
            return;
        }
        if (table.isTemp) {
            return;
        }
        if (this.session.isProcessingRecoveryLog || this.session.isProcessingLog) {
            return;
        }
        for (int j = 0; j < table.columnCount; ++j) {
            if (data[j] instanceof FlobData) {
                this.removeFromNewFlobIds((FlobData)data[j]);
            }
            if ((!lobTypes.contains((Object)LobType.LOB) || !table.colTypes[j].isLobType()) && (!lobTypes.contains((Object)LobType.FLOB) || !table.colTypes[j].isFlobType())) continue;
            this.adjustLobUsageCount(data[j], adjust);
        }
    }

    public void allocateLobForResult(ResultLob result, InputStream inputStream) {
        try {
            switch (result.getSubType()) {
                case 7: {
                    long blobId;
                    long blobLength = result.getBlockLength();
                    if (blobLength < 0L) {
                        this.allocateBlobSegments(result, result.getInputStream());
                        break;
                    }
                    if (inputStream == null) {
                        blobId = result.getLobID();
                        inputStream = result.getInputStream();
                    } else {
                        BlobDataID blob = this.session.createBlob(blobLength);
                        blobId = blob.getId();
                        this.resultLobs.put(result.getLobID(), blobId);
                    }
                    CountdownInputStream countStream = new CountdownInputStream(inputStream);
                    countStream.setCount(blobLength);
                    Result actionResult = this.store.lobManager.setBytesForNewBlob(blobId, countStream, result.getBlockLength());
                    if (!actionResult.isError()) break;
                    Trace.logError(this, "ALLOCATE BYTES for blob operation failed. Retrying...");
                    actionResult = this.store.lobManager.setBytesForNewBlob(blobId, countStream, result.getBlockLength());
                    if (!actionResult.isError()) break;
                    throw new DataspaceException(actionResult);
                }
                case 8: {
                    long clobId;
                    long clobLength = result.getBlockLength();
                    if (clobLength < 0L) {
                        this.allocateClobSegments(result, result.getReader());
                        break;
                    }
                    if (inputStream == null) {
                        clobId = result.getLobID();
                        inputStream = result.getReader() != null ? new ReaderInputStream(result.getReader()) : result.getInputStream();
                    } else {
                        ClobDataID clob = this.session.createClob(clobLength);
                        clobId = clob.getId();
                        this.resultLobs.put(result.getLobID(), clobId);
                    }
                    CountdownInputStream countStream = new CountdownInputStream(inputStream);
                    countStream.setCount(clobLength * 2L);
                    Result actionResult = this.store.lobManager.setCharsForNewClob(clobId, countStream, result.getBlockLength(), false);
                    if (!actionResult.isError()) break;
                    Trace.logError(this, "ALLOCATE CHARS for clob operation failed. Retrying...");
                    actionResult = this.store.lobManager.setCharsForNewClob(clobId, countStream, result.getBlockLength(), false);
                    if (!actionResult.isError()) break;
                    throw new DataspaceException(actionResult);
                }
                case 2: {
                    long blobId = this.resultLobs.get(result.getLobID());
                    long dataLength = result.getBlockLength();
                    byte[] byteArray = result.getByteArray();
                    Result actionResult = this.store.lobManager.setBytes(blobId, result.getOffset(), byteArray, (int)dataLength);
                    if (!actionResult.isError()) break;
                    Trace.logError(this, "SET BYTES for blob operation failed. Retrying...");
                    actionResult = this.store.lobManager.setBytes(blobId, result.getOffset(), byteArray, (int)dataLength);
                    if (!actionResult.isError()) break;
                    throw new DataspaceException(actionResult);
                }
                case 4: {
                    long clobId = this.resultLobs.get(result.getLobID());
                    char[] charArray = result.getCharArray();
                    Result actionResult = this.store.lobManager.setChars(clobId, result.getOffset(), charArray);
                    if (!actionResult.isError()) break;
                    Trace.logError(this, "SET CHARS for clob operation failed. Retrying...");
                    actionResult = this.store.lobManager.setChars(clobId, result.getOffset(), charArray);
                    if (!actionResult.isError()) break;
                    throw new DataspaceException(actionResult);
                }
            }
        }
        catch (Throwable e) {
            this.resultLobs.clear();
            throw Error.error(458, e);
        }
    }

    private void allocateBlobSegments(ResultLob result, InputStream stream) throws IOException {
        long currentOffset = result.getOffset();
        int bufferLength = this.session.getStreamBlockSize();
        HsqlByteArrayOutputStream byteArrayOS = new HsqlByteArrayOutputStream(bufferLength);
        do {
            byteArrayOS.reset();
            byteArrayOS.write(stream, bufferLength);
            byte[] byteArray = byteArrayOS.getBuffer();
            Result actionResult = this.store.lobManager.setBytes(result.getLobID(), currentOffset, byteArray, byteArrayOS.size());
            if (actionResult.isError() && (actionResult = this.store.lobManager.setBytes(result.getLobID(), currentOffset, byteArray, byteArrayOS.size())).isError()) {
                throw new DataspaceException(actionResult);
            }
            currentOffset += (long)byteArrayOS.size();
        } while (byteArrayOS.size() >= bufferLength);
    }

    private void allocateClobSegments(ResultLob result, Reader reader) throws IOException {
        long currentOffset = result.getOffset();
        int bufferLength = this.session.getStreamBlockSize();
        CharArrayWriter charWriter = new CharArrayWriter(bufferLength);
        do {
            Result actionResult;
            charWriter.reset();
            charWriter.write(reader, bufferLength);
            char[] charArray = charWriter.getBuffer();
            if (charWriter.size() < bufferLength) {
                charArray = charWriter.toCharArray();
            }
            if ((actionResult = this.store.lobManager.setChars(result.getLobID(), currentOffset, charArray)).isError()) {
                throw new DataspaceException(actionResult);
            }
            currentOffset += (long)charWriter.size();
        } while (charWriter.size() >= bufferLength);
    }

    public void registerLobForResult(Result result) {
        RowSetNavigator navigator = result.getNavigator();
        if (navigator == null) {
            this.registerLobsForRow((Object[])result.valueData);
        } else {
            while (navigator.next()) {
                Object[] data = navigator.getCurrent();
                this.registerLobsForRow(data);
            }
            navigator.reset();
        }
        this.resultLobs.clear();
    }

    private void registerLobsForRow(Object[] data) {
        for (int i = 0; i < data.length; ++i) {
            long id;
            if (data[i] instanceof BlobDataID) {
                BlobDataID blob = (BlobDataID)data[i];
                id = blob.getId();
                if (id < 0L) {
                    id = this.resultLobs.get(id);
                }
                data[i] = this.store.lobManager.getBlob(id);
                continue;
            }
            if (!(data[i] instanceof ClobDataID)) continue;
            ClobDataID clob = (ClobDataID)data[i];
            id = clob.getId();
            if (id < 0L) {
                id = this.resultLobs.get(id);
            }
            data[i] = this.store.lobManager.getClob(id);
        }
    }

    public long getFilelLength(String filename) throws IOException {
        if (this.session.isSLFileStreamNeeded()) {
            SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(this.session, filename);
            if (utils.supportsExistsOperation() && !utils.exists()) {
                throw Error.error(452, "file '" + filename + "' doesn't exist.");
            }
            try (SLFileInputStream inputStream = utils.createSLFileInputStream();){
                inputStream.open();
                long l = inputStream.getFileLength();
                return l;
            }
        }
        File file = new File(filename);
        if (!file.exists()) {
            throw Error.error(452, "file '" + filename + "' doesn't exist.");
        }
        return file.length();
    }

    public Object createLobOrStringOrBinaryFromFile(String filename, String charset, long offset, long length, Type type, boolean fromFlob, String newFileName, String newCharset) {
        InputStream inputStream = null;
        long fileLength = -1L;
        if (newFileName == null) {
            newFileName = filename;
        }
        try {
            List<String> lob;
            long[] lengthArray = new long[1];
            inputStream = SessionData.createFileInputStream(this.session, filename, fromFlob, true, lengthArray);
            inputStream = new BufferedInputStream(inputStream, this.session.getTransferBufferSize());
            fileLength = lengthArray[0];
            if (offset < 0L) {
                offset = fileLength + offset;
            }
            if (offset < 0L || offset > fileLength) {
                throw Error.error(452);
            }
            if (length == -1L || offset + length > fileLength) {
                length = fileLength - offset;
            }
            Result result = null;
            if (type.typeCode == 40) {
                if (charset == null) {
                    charset = this.session.getSessionCCSID().toString();
                }
                lob = this.session.createClob(length);
                InputStreamReader reader = new InputStreamReader(inputStream, charset);
                readerInputStream = new ReaderInputStream(reader);
                if (fromFlob) {
                    reader.skip(offset);
                } else {
                    readerInputStream.skip(offset * 2L);
                }
                result = this.store.lobManager.setCharsForNewClob(((LobData)((Object)lob)).getId(), readerInputStream, length, true);
            } else if (type.typeCode == 30) {
                lob = this.session.createBlob(length);
                inputStream.skip(offset);
                result = this.store.lobManager.setBytesForNewBlob(((LobData)((Object)lob)).getId(), inputStream, length);
            } else if (type.typeCode == 1119) {
                if (newCharset == null) {
                    newCharset = charset;
                }
                lob = this.session.createFlob(type, newFileName, newCharset, false, true);
                if (charset != null) {
                    InputStreamReader reader = new InputStreamReader(inputStream, charset);
                    reader.skip(offset);
                    result = this.store.flobManager.setChars((FlobData)((Object)lob), reader, length, newCharset);
                } else {
                    inputStream.skip(offset);
                    result = this.store.flobManager.setBytes((FlobData)((Object)lob), inputStream, length);
                }
            } else if (type.typeCode == -2 || type.typeCode == -3 || type.typeCode == 60 || type.typeCode == 61) {
                int c;
                inputStream.skip(offset);
                int read = 0;
                byte[] buffer = new byte[4096];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((long)read < length && (c = inputStream.read(buffer, 0, (int)Math.min(length - (long)read, (long)buffer.length))) > 0) {
                    byteArrayOutputStream.write(buffer, 0, c);
                    read += c;
                }
                lob = (List<String>)byteArrayOutputStream.toByteArray();
                lob = new BinaryData((byte[])lob, false);
                result = Result.updateNoResult;
            } else {
                int c;
                if (charset == null) {
                    charset = this.session.getSessionCCSID().toString();
                }
                InputStreamReader reader = new InputStreamReader(inputStream, charset);
                readerInputStream = new ReaderInputStream(reader);
                if (fromFlob) {
                    reader.skip(offset);
                } else {
                    readerInputStream.skip(offset * 2L);
                }
                int read = 0;
                char[] buffer = new char[4096];
                StringBuilder builder = new StringBuilder();
                while ((long)read < length && (c = ((Reader)reader).read(buffer, 0, (int)Math.min(length - (long)read, (long)buffer.length))) > 0) {
                    builder.append(buffer, 0, c);
                    read += c;
                }
                lob = builder.toString();
                if ("list".equalsIgnoreCase(type.getNameString())) {
                    lob = StringUtils.split((String)((Object)lob), '\n');
                }
                result = Result.updateNoResult;
            }
            if (result.isError()) {
                Trace.logError(this, "Writing data for lob " + ((LobData)((Object)lob)).getId() + " filename '" + filename + "' failed. Cause: " + result.getMainString());
                throw new DataspaceException(result.getException(), result.getMainString(), result.getSubString(), result.getErrorCode());
            }
            LobData lobData = lob;
            return lobData;
        }
        catch (IOException e) {
            throw Error.error(452, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                Trace.logError(this, "Closing input stream for file '" + filename + "' failed.");
                Trace.logException(this, exception, true);
            }
        }
    }

    public void writeFile(String filename, Object data, boolean append, String charset) {
        OutputStream outputStream = null;
        try {
            outputStream = SessionData.createFileOutputStream(this.session, filename, true, append);
            outputStream = new BufferedOutputStream(outputStream, this.session.getTransferBufferSize());
            this.writeData(outputStream, data, charset);
        }
        catch (IOException e) {
            throw Error.error(452, e.toString());
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void writeData(OutputStream outputStream, Object data, String charset) {
        block13: {
            try {
                data = OtherTypeWrapper.unwrap(data);
                if (data == null) break block13;
                if (data instanceof ClobDataID) {
                    if (charset == null) {
                        charset = this.session.getSessionCCSID().toString();
                    }
                    FileIOUtils.copy(((ClobDataID)data).getCharacterStream(this.session), outputStream, charset);
                    break block13;
                }
                if (data instanceof BlobDataID) {
                    FileIOUtils.copy(((BlobDataID)data).getBinaryStream(this.session), outputStream);
                    break block13;
                }
                if (data instanceof FlobDataID) {
                    if (charset == null) {
                        FileIOUtils.copy(((FlobDataID)data).getBlobAdapter().getBinaryStream(this.session), outputStream);
                    } else {
                        FileIOUtils.copy(((FlobDataID)data).getClobAdapter().getCharacterStream(this.session), outputStream, charset);
                    }
                    break block13;
                }
                if (data instanceof String) {
                    if (charset == null) {
                        charset = this.session.getSessionCCSID().toString();
                    }
                    byte[] bytes = ((String)data).getBytes(charset);
                    outputStream.write(bytes);
                    break block13;
                }
                if (data instanceof BinaryData) {
                    outputStream.write(((BinaryData)data).getBytes());
                    break block13;
                }
                if (data instanceof byte[]) {
                    outputStream.write((byte[])data);
                    break block13;
                }
                throw new DataspaceException("Incompatible data type. Write from BLOB, CLOB, Character or Binary types allowed only.");
            }
            catch (IOException e) {
                throw Error.error(452, e.toString());
            }
            catch (UtilitiesException e) {
                throw Error.error(452, e.toString());
            }
        }
    }

    private String resolveFlobPath(FlobData a, Type type) throws IOException {
        FlobType flobType = (FlobType)type;
        if (Paths.get(a.getFilename(), new String[0]).isAbsolute()) {
            throw new DataspaceException("linkFile accepts file names and relative paths only.");
        }
        String location = this.session.dataspaceStore.flobManager.getLocationPath(flobType.getLocation());
        String filepath = this.session.dataspaceStore.flobManager.getFlobFileManager().getAbsoluteFilePath(location, a.getFilename());
        this.session.dataspaceStore.flobManager.getFlobFileManager().checkFileExists(filepath);
        return filepath;
    }

    public String readFlobString(FlobData a, Type type) {
        if (a.getLinked()) {
            try {
                String filepath = this.resolveFlobPath(a, type);
                return new String(this.session.dataspaceStore.flobManager.getFlobFileManager().getChars(this.session, new File(filepath).getName(), a.getCharset(), new File(filepath).getParent(), 0L, (int)new File(filepath).length()));
            }
            catch (IOException exception) {
                throw new DataspaceException(exception);
            }
        }
        return (String)this.createLobOrStringOrBinaryFromFile(a.getFilename(), a.getCharset(), 0L, -1L, Type.STRING, false, null, null);
    }

    public byte[] readFlobBytes(FlobData a, Type type) {
        if (a.getLinked()) {
            try {
                String filepath = this.resolveFlobPath(a, type);
                return this.session.dataspaceStore.flobManager.getFlobFileManager().getBytes(new File(filepath).getName(), new File(filepath).getParent(), 0L, (int)new File(filepath).length());
            }
            catch (IOException exception) {
                throw new DataspaceException(exception);
            }
        }
        return BinaryData.unwrap(this.createLobOrStringOrBinaryFromFile(a.getFilename(), null, 0L, -1L, Type.SQL_VARBINARY, false, null, null));
    }

    public FlobData linkFlob(String filename, String charset, Type type, boolean isManaged, boolean ignore) {
        if (!(type instanceof FlobType)) {
            throw new DataspaceException("linkFile can be assigned to FLOB variable or column only.");
        }
        if (((FlobType)type).getAutotag() == null && ((FlobType)type).getAutotag().booleanValue()) {
            throw new DataspaceException("linkFile can be assigned to not autotag FLOB variable or column only.");
        }
        if (Paths.get(filename, new String[0]).isAbsolute()) {
            throw new DataspaceException("linkFile accepts file names and relative paths only.");
        }
        FlobType flobType = (FlobType)type;
        String location = this.session.dataspaceStore.flobManager.getLocationPath(flobType.getLocation());
        String filepath = this.session.dataspaceStore.flobManager.getFlobFileManager().getAbsoluteFilePath(location, filename);
        if (!ignore) {
            try {
                this.session.dataspaceStore.flobManager.getFlobFileManager().checkFileExists(filepath);
            }
            catch (IOException e) {
                throw new DataspaceException(e);
            }
        }
        return this.session.createFlob(type, filename, charset, true, isManaged, ignore);
    }

    public FlobData toFlob(String filename, Object data, String charset, Type type) {
        if (!(type instanceof FlobType)) {
            throw new DataspaceException("toFlob can be assigned to FLOB variable or column only.");
        }
        if (Paths.get(filename, new String[0]).normalize().getNameCount() != 1) {
            throw new DataspaceException("toFlob accepts file names only.");
        }
        FlobData flobData = this.session.createFlob(type, filename, charset, false, true);
        Reader reader = null;
        InputStream inputStream = null;
        if (data != null) {
            if (data instanceof ClobDataID) {
                reader = ((ClobDataID)data).getCharacterStream(this.session);
            } else if (data instanceof BlobData) {
                inputStream = ((BlobData)data).getBinaryStream(this.session);
            } else if (data instanceof FlobDataID) {
                if (charset == null) {
                    inputStream = ((FlobDataID)data).getBlobAdapter().getBinaryStream(this.session);
                } else {
                    reader = ((FlobDataID)data).getClobAdapter().getCharacterStream(this.session);
                }
            } else if (data instanceof String) {
                reader = new StringReader((String)data);
            } else if (data instanceof BinaryData) {
                inputStream = ((BinaryData)data).getBinaryStream(this.session);
            } else {
                throw new DataspaceException("Incompatible data type. Write from BLOB, CLOB, Character or Binary types allowed only.");
            }
        }
        Result result = null;
        result = reader != null ? this.store.flobManager.setChars(flobData, reader, -1L, charset) : this.store.flobManager.setBytes(flobData, inputStream, -1L);
        if (result != null && result.isError()) {
            Trace.logError(this, "Writing data for flob " + flobData.getId() + " filename '" + filename + "' failed. Cause: " + result.getMainString());
            throw new DataspaceException(result);
        }
        return flobData;
    }

    public void startRowProcessing() {
        if (this.sequenceMap != null) {
            this.sequenceMap.clear();
        }
    }

    public Object getSequenceValue(NumberSequence sequence) {
        NameManager.ObjectName key;
        Object value;
        if (this.sequenceMap == null) {
            this.sequenceMap = new HashMap();
            this.sequenceUpdateMap = new HashMap();
        }
        if ((value = this.sequenceMap.get(key = sequence.getObjectName())) == null) {
            value = sequence.getValueObject();
            this.sequenceMap.put(key, value);
            this.sequenceUpdateMap.put(sequence, value);
        }
        return value;
    }

    public Object getSequenceCurrent(NumberSequence sequence) {
        return this.sequenceUpdateMap == null ? null : this.sequenceUpdateMap.get(sequence);
    }

    public static String checkDataspaceFileAccess(Session session, String filename) {
        if (!DropBoxUtils.isDropBoxURL(filename) && session.getSLFileSessionContext() == SLFileSessionContext.SERVER) {
            session.checkAdmin();
            String secureFilename = session.dataspaceStore.dataspaceLogger.getSecurePath(filename);
            if (secureFilename == null) {
                throw Error.error(471, new Object[]{"Path '" + filename + "' is external"});
            }
            return secureFilename;
        }
        return filename;
    }

    public static InputStream createFileInputStream(Session session, String filename, boolean local, boolean checkExists, long[] length) throws IOException {
        InputStream inputStream;
        if (DropBoxUtils.isDropBoxURL(filename)) {
            return SessionData.createDropBoxInputStream(session, filename, checkExists, length);
        }
        filename = SessionData.checkDataspaceFileAccess(session, filename);
        if (session.isSLFileStreamNeeded() && !local) {
            SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(session, filename);
            if (checkExists && utils.supportsExistsOperation() && !utils.exists()) {
                throw Error.error(452, "file '" + filename + "' doesn't exist.");
            }
            inputStream = utils.createSLFileInputStream();
            ((SLFileInputStream)inputStream).open();
            if (length != null) {
                length[0] = ((SLFileInputStream)inputStream).getFileLength();
            }
        } else {
            if (checkExists) {
                File file = new File(filename);
                if (!file.exists()) {
                    throw Error.error(452, "file '" + filename + "' doesn't exist.");
                }
                if (length != null) {
                    length[0] = file.length();
                }
            }
            inputStream = new FileInputStream(new File(filename));
        }
        return inputStream;
    }

    public static OutputStream createFileOutputStream(Session session, String filename, boolean overwrite, boolean append) throws IOException {
        OutputStream outputStream;
        if (DropBoxUtils.isDropBoxURL(filename)) {
            return SessionData.createDropBoxOutputStream(session, filename, overwrite, append);
        }
        filename = SessionData.checkDataspaceFileAccess(session, filename);
        if (session.isSLFileStreamNeeded()) {
            outputStream = (OutputStream)new SLFileOutputStreamFactory().create(session, filename);
            if (append) {
                ((SLFileOutputStream)outputStream).openForAppend();
            } else if (overwrite) {
                ((SLFileOutputStream)outputStream).open();
            } else {
                ((SLFileOutputStream)outputStream).create();
            }
        } else {
            if (new File(filename).exists() && !overwrite && !append) {
                throw new DataspaceException("Local file already exists. Specify overwrite or append parameter to overwrite/append existing file.");
            }
            outputStream = new FileOutputStream(new File(filename), append);
        }
        return outputStream;
    }

    public static long getFileSize(Session session, String filename) throws IOException {
        if (DropBoxUtils.isDropBoxURL(filename)) {
            return SessionData.getDropBoxFileSize(session, filename);
        }
        filename = SessionData.checkDataspaceFileAccess(session, filename);
        if (session.isSLFileStreamNeeded()) {
            SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(session, filename);
            try (SLFileInputStream inputStream = utils.createSLFileInputStream();){
                inputStream.open();
                long l = inputStream.getFileLength();
                return l;
            }
        }
        File file = new File(filename);
        return file.length();
    }

    private static InputStream createDropBoxInputStream(Session session, String url, boolean checkExists, long[] length) throws IOException {
        String dropBoxName = DropBoxUtils.getDropBoxNameFromURL(url);
        String dropBoxPath = DropBoxUtils.getDropBoxPathFromURL(url);
        final DropBoxAccessor accessor = DataspaceStoreManager.getRuntimeContext().getDropBoxManagerRemote().createDropBoxAccessor(dropBoxName);
        try {
            final FileSystem filesystem = accessor.createFileSystem(session.getUsername(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);
            try {
                if (checkExists && !filesystem.exists(dropBoxPath)) {
                    throw Error.error(452, "file '" + url + "' doesn't exist.");
                }
                if (length != null) {
                    length[0] = filesystem.getInfo(dropBoxPath).getSize();
                }
            }
            catch (Throwable t) {
                filesystem.close();
                throw t;
            }
            InputStream inputStream = filesystem.open(dropBoxPath, session.getTransferBufferSize());
            return new InputStreamWrapper(inputStream){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            filesystem.close();
                        }
                        finally {
                            accessor.close();
                        }
                    }
                }
            };
        }
        catch (Exception exception) {
            if (accessor != null) {
                accessor.close();
            }
            throw exception;
        }
    }

    private static OutputStream createDropBoxOutputStream(Session session, String url, boolean overwrite, boolean append) throws IOException {
        String dropBoxName = DropBoxUtils.getDropBoxNameFromURL(url);
        String dropBoxPath = DropBoxUtils.getDropBoxPathFromURL(url);
        final DropBoxAccessor accessor = DataspaceStoreManager.getRuntimeContext().getDropBoxManagerRemote().createDropBoxAccessor(dropBoxName);
        try {
            final FileSystem filesystem = accessor.createFileSystem(session.getUsername(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);
            OutputStream outputStream = filesystem.exists(dropBoxPath) && append ? filesystem.append(dropBoxPath) : filesystem.create(dropBoxPath, overwrite);
            return new OutputStreamWrapper(outputStream){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            filesystem.close();
                        }
                        finally {
                            accessor.close();
                        }
                    }
                }
            };
        }
        catch (Exception exception) {
            if (accessor != null) {
                accessor.close();
            }
            throw exception;
        }
    }

    private static long getDropBoxFileSize(Session session, String url) throws IOException {
        String dropBoxName = DropBoxUtils.getDropBoxNameFromURL(url);
        String dropBoxPath = DropBoxUtils.getDropBoxPathFromURL(url);
        try (DropBoxAccessor accessor = DataspaceStoreManager.getRuntimeContext().getDropBoxManagerRemote().createDropBoxAccessor(dropBoxName);){
            long l;
            block13: {
                FileInfo info;
                FileSystem filesystem;
                block11: {
                    long l2;
                    block12: {
                        filesystem = accessor.createFileSystem(session.getUsername(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);
                        try {
                            info = filesystem.getInfo(dropBoxPath);
                            if (info != null) break block11;
                            l2 = -1L;
                            if (filesystem == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (filesystem != null) {
                                try {
                                    filesystem.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        filesystem.close();
                    }
                    return l2;
                }
                l = info.getSize();
                if (filesystem == null) break block13;
                filesystem.close();
            }
            return l;
        }
    }

    public static FileSystem createFileSystem(Session session, String[] url) {
        if (DropBoxUtils.isDropBoxURL(url[0])) {
            return SessionData.createDropBoxFileSystem(session, url);
        }
        url[0] = SessionData.checkDataspaceFileAccess(session, url[0]);
        return new LocalFileSystem();
    }

    public static DropBoxFileSystem createDropBoxFileSystem(Session session, String[] url) {
        String dropBoxName = DropBoxUtils.getDropBoxNameFromURL(url[0]);
        String dropBoxPath = DropBoxUtils.getDropBoxPathFromURL(url[0]);
        DropBoxAccessor accessor = DataspaceStoreManager.getRuntimeContext().getDropBoxManagerRemote().createDropBoxAccessor(dropBoxName);
        url[0] = dropBoxPath;
        return (DropBoxFileSystem)accessor.createFileSystem(session.getUsername(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);
    }

    public static Pair<byte[], String> getBinaryOrString(Session session, Object data, Type dataType) {
        try {
            Pair<Object, Object> result = new Pair<Object, Object>(null, null);
            if (data instanceof BinaryData) {
                result.first = ((BinaryData)data).getBytes();
            } else if (data instanceof byte[]) {
                result.first = (byte[])data;
            } else if (data instanceof String) {
                result.second = (String)data;
            } else if (data instanceof BlobDataID) {
                result.first = SqlUtils.extractBlob(session, (BlobDataID)data);
            } else if (data instanceof ClobDataID) {
                result.second = new String(SqlUtils.extractClob(session, (ClobDataID)data));
            } else if (data instanceof FlobData) {
                result.second = new String(SqlUtils.extractClob(session, ((FlobData)data).getClobAdapter()));
            } else if (data instanceof AbstractLazyFlobFunctionExpression) {
                FlobData flobData = ((AbstractLazyFlobFunctionExpression)data).getLazyFlobData(session);
                result.second = session.sessionData.readFlobString(flobData, dataType);
            } else {
                if (data == null) {
                    return null;
                }
                throw new DataspaceException("Incompatible value type. Character or binary types are allowed only.");
            }
            return result;
        }
        catch (SQLException exception) {
            throw new DataspaceException(exception);
        }
    }

    public boolean isIgnoreDependencies() {
        return this.ignoreDependencies;
    }

    public void setIgnoreDependencies(boolean ignoreDependencies) {
        this.ignoreDependencies = ignoreDependencies;
    }

    public static enum LobType {
        LOB,
        FLOB;

    }
}

