/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.session;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.LongDeque;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RangeIterator;
import com.streamscape.ds.navigator.RowSetNavigatorDataChange;
import com.streamscape.ds.navigator.RowSetNavigatorDataChangeMemory;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCompound;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.parser.statement.StatementResultUpdate;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.CloseableWrapper;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.AdvisoryDatagramFactory;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.excp.ExceptionDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionContext {
    public RplScript currentRoutine;
    public StatementCompound currentCompoundStatement;
    Session session;
    public ReferencePathManager sdrManager = DataspaceManager.getContext().getSDRManagerFactory().createManager();
    public TypeAnalyzer typeAnalyzer = TypeAnalyzerFactory.getInstance().createTypeAnalyzer();
    public DatagramPrototypeCache datagramPrototypeCache = DataspaceManager.getContext().getDatagramPrototypeCache();
    public EventDatagramFactory eventDatagramFactory = DataspaceManager.getContext().getEventDatagramFactory();
    public ExceptionDatagramFactory exceptionDatagramFactory = DataspaceManager.getContext().getExceptionDatagramFactory();
    public AdvisoryDatagramFactory advisoryDatagramFactory = DataspaceManager.getContext().getAdvisoryDatagramFactory();
    public OpaqueDatagramFactory opaqueDatagramFactory = DataspaceManager.getContext().getOpaqueDatagramFactory();
    public Boolean isAutoCommit;
    public Boolean isReadOnly;
    Boolean noSQL;
    int currentMaxRows;
    HashMappedList sessionVariables;
    HashMappedList sessionVariablesBkp;
    Object[] routineVariablesBkp;
    public RangeVariable[] sessionVariablesRange;
    private HsqlArrayList stack;
    public Object[] diagnosticsVariables = ValuePool.emptyObjectArray;
    public Object[] rplArguments = ValuePool.emptyObjectArray;
    public Object[] routineVariables = ValuePool.emptyObjectArray;
    public Object[] dynamicArguments = ValuePool.emptyObjectArray;
    public Object[][] triggerArguments = null;
    public int depth;
    public ImmutableEventDatagram rplBlockCurrentEvent = null;
    public EventTriggerDefinition triggerDefinition = null;
    public ImmutableEventDatagram currentCollectionEventForTrigger = null;
    Number lastIdentity = ValuePool.INTEGER_0;
    public HashMappedList savepoints;
    public LongDeque savepointTimestamps;
    public RangeIterator[] rangeIterators;
    HashMappedList sessionCollections;
    HashMappedList popSessionCollections;
    HashMappedList transactionSchemaObjects;
    public Statement currentStatement;
    public String lastStatement;
    public StatementCompound compoundStatementContext;
    public List<String> lastStatementsInTransaction = new ArrayList<String>();
    public Map<String, Map<String, Expression>> virtualTableParameters = new HashMap<String, Map<String, Expression>>();
    public List<String> raisedEventIds = null;
    public String triggerEventId = null;
    public EventScope eventScope = null;
    public RplSchemaObject rplObject = null;
    public ArrayList<Object> futureParams = null;
    public transient ArrayList<Statement> postponedStatements = null;
    public int rownum;
    HashSet constraintPath;
    StatementResultUpdate rowUpdateStatement = new StatementResultUpdate();
    public boolean routineIsInTransaction = false;
    public Throwable onCommitException;
    public Throwable onCommitFireTriggersException;
    public int rowActionListStartIndex = 0;

    SessionContext(Session session) {
        this.session = session;
        this.diagnosticsVariables = new Object[ExpressionColumn.diagnosticsVariableTokens.length];
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new HashMappedList(4);
        this.savepointTimestamps = new LongDeque();
        this.sessionVariables = new HashMappedList();
        this.sessionVariablesRange = new RangeVariable[1];
        this.sessionVariablesRange[0] = new RangeVariable(this.sessionVariables, null, true, 4);
        this.isAutoCommit = Boolean.FALSE;
        this.isReadOnly = Boolean.FALSE;
        this.noSQL = Boolean.FALSE;
        this.onCommitException = null;
        this.onCommitFireTriggersException = null;
    }

    public void push() {
        if (this.session.sessionContext.depth > 256) {
            throw Error.error(458);
        }
        this.session.sessionData.persistentStoreCollection.push();
        if (this.stack == null) {
            this.stack = new HsqlArrayList(8, true);
        }
        this.stack.add(this.diagnosticsVariables);
        this.stack.add(this.dynamicArguments);
        this.stack.add(this.rplArguments);
        this.stack.add(this.triggerArguments);
        this.stack.add(this.routineVariables);
        this.stack.add(this.rangeIterators);
        this.stack.add(this.savepoints);
        this.stack.add(this.savepointTimestamps);
        this.stack.add(this.lastIdentity);
        this.stack.add(this.isAutoCommit);
        this.stack.add(this.isReadOnly);
        this.stack.add(this.noSQL);
        this.stack.add(ValuePool.getInt(this.currentMaxRows));
        this.stack.add(ValuePool.getInt(this.rownum));
        this.diagnosticsVariables = new Object[ExpressionColumn.diagnosticsVariableTokens.length];
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new HashMappedList(4);
        this.savepointTimestamps = new LongDeque();
        this.isAutoCommit = Boolean.FALSE;
        this.currentMaxRows = 0;
        ++this.depth;
    }

    public void pop() {
        this.session.sessionData.persistentStoreCollection.pop();
        this.rownum = (Integer)this.stack.remove(this.stack.size() - 1);
        this.currentMaxRows = (Integer)this.stack.remove(this.stack.size() - 1);
        this.noSQL = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isReadOnly = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isAutoCommit = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.lastIdentity = (Number)this.stack.remove(this.stack.size() - 1);
        this.savepointTimestamps = (LongDeque)this.stack.remove(this.stack.size() - 1);
        this.savepoints = (HashMappedList)this.stack.remove(this.stack.size() - 1);
        this.rangeIterators = (RangeIterator[])this.stack.remove(this.stack.size() - 1);
        this.routineVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        this.triggerArguments = (Object[][])this.stack.remove(this.stack.size() - 1);
        this.rplArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.dynamicArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.diagnosticsVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        --this.depth;
    }

    public void pushWithWithRowActionList() {
        this.push();
        this.stack.add(this.rowActionListStartIndex);
        this.rowActionListStartIndex = this.session.rowActionList.size();
    }

    public void popWithWithRowActionList() {
        this.rowActionListStartIndex = (Integer)this.stack.remove(this.stack.size() - 1);
        this.pop();
    }

    public void pushDynamicArguments(Object[] args) {
        this.push();
        this.dynamicArguments = args;
    }

    public void pushDynamicArgumentsWithRowActionList(Object[] args) {
        this.pushWithWithRowActionList();
        this.dynamicArguments = args;
    }

    public void setDynamicArguments(Object[] args) {
        this.dynamicArguments = args;
    }

    public RowSetNavigatorDataChange getRowSetDataChange() {
        return new RowSetNavigatorDataChangeMemory(this.session);
    }

    public void clearStructures(StatementDMQL cs) {
        int count = cs.rangeIteratorCount;
        if (count > this.rangeIterators.length) {
            count = this.rangeIterators.length;
        }
        for (int i = 0; i < count; ++i) {
            if (this.rangeIterators[i] == null) continue;
            this.rangeIterators[i].reset();
            this.rangeIterators[i] = null;
        }
    }

    public RangeVariable.RangeIteratorBase getCheckIterator(RangeVariable rangeVariable) {
        RangeIterator it = this.rangeIterators[0];
        if (it == null) {
            this.rangeIterators[0] = it = rangeVariable.getIterator(this.session);
        }
        return (RangeVariable.RangeIteratorBase)it;
    }

    public void setRangeIterator(RangeIterator iterator) {
        int position = iterator.getRangePosition();
        if (position >= this.rangeIterators.length) {
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, position + 4);
        }
        this.rangeIterators[iterator.getRangePosition()] = iterator;
    }

    public HashSet getConstraintPath() {
        if (this.constraintPath == null) {
            this.constraintPath = new HashSet();
        } else {
            this.constraintPath.clear();
        }
        return this.constraintPath;
    }

    public void addSessionVariable(ColumnSchema variable) {
        int index = this.sessionVariables.size();
        if (!this.sessionVariables.add(variable.getObjectName().name, variable)) {
            throw Error.error(5504);
        }
        Object[] vars = new Object[this.sessionVariables.size()];
        ArrayUtil.copyArray(this.routineVariables, vars, this.routineVariables.length);
        this.routineVariables = vars;
        this.routineVariables[index] = variable.getDefaultValue(this.session);
    }

    public void backupVariablesBeforeComplete() {
        this.sessionVariablesBkp = new HashMappedList();
        if (this.sessionVariables != null) {
            Iterator iterator = this.sessionVariables.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.sessionVariablesBkp.put(key, this.sessionVariables.get(key));
            }
        }
        if (this.routineVariables != null) {
            this.routineVariablesBkp = Arrays.copyOf(this.routineVariables, this.routineVariables.length);
        }
    }

    public void restoreVariablesAfterComplete() {
        if (this.sessionVariablesBkp != null) {
            this.sessionVariables.clear();
            Iterator iterator = this.sessionVariablesBkp.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.sessionVariables.put(key, this.sessionVariablesBkp.get(key));
            }
            this.sessionVariablesBkp = null;
        }
        if (this.routineVariablesBkp != null) {
            this.routineVariables = this.routineVariablesBkp;
            this.routineVariablesBkp = null;
        }
    }

    public void removeSessionVariables(NameManager.ObjectName[] names) {
        this.removeSessionVariables((String[])Arrays.stream(names).map(NameManager.SimpleName::getNameString).toArray(String[]::new));
    }

    public void removeSessionVariables(String[] names) {
        if ((names = (String[])Arrays.stream(names).filter(name -> this.hasVariable((String)name)).toArray(String[]::new)).length > 0) {
            if (names.length == this.sessionVariables.size()) {
                this.sessionVariables.clear();
                this.routineVariables = ValuePool.emptyObjectArray;
            } else {
                for (int i = 0; i < names.length; ++i) {
                    int removedIndex = this.sessionVariables.getIndex(names[i]);
                    this.sessionVariables.remove(removedIndex);
                    Object[] routineVariablesOld = this.routineVariables;
                    this.routineVariables = new Object[this.routineVariables.length - 1];
                    if (removedIndex > 0) {
                        System.arraycopy(routineVariablesOld, 0, this.routineVariables, 0, removedIndex);
                    }
                    if (removedIndex + 1 >= routineVariablesOld.length) continue;
                    System.arraycopy(routineVariablesOld, removedIndex + 1, this.routineVariables, removedIndex, routineVariablesOld.length - removedIndex - 1);
                }
            }
        }
    }

    public void removeSessionVariablesLast(int lastCount) {
        if (lastCount <= 0) {
            return;
        }
        int removedCount = 0;
        while (lastCount > 0 && this.sessionVariables.size() > 0) {
            this.sessionVariables.remove(this.sessionVariables.size() - 1);
            --lastCount;
            ++removedCount;
        }
        this.routineVariables = this.routineVariables.length - removedCount > 0 ? Arrays.copyOf(this.routineVariables, this.routineVariables.length - removedCount) : ValuePool.emptyObjectArray;
    }

    public boolean hasVariable(String varName) {
        return this.sessionVariables.keySet().contains(varName);
    }

    public HashMappedList getSessionVariables() {
        return this.sessionVariables;
    }

    public void pushRoutineCollections(HashMappedList map) {
        this.popSessionCollections = this.sessionCollections;
        this.sessionCollections = map;
    }

    public void popRoutineCollections() {
        this.sessionCollections = this.popSessionCollections;
    }

    public void addSessionCollection(Collection collection) {
        if (this.sessionCollections == null) {
            this.sessionCollections = new HashMappedList();
        }
        if (this.sessionCollections.containsKey(collection.getObjectName().name)) {
            throw Error.error(5504);
        }
        this.sessionCollections.add(collection.getObjectName().name, collection);
    }

    public void setSessionTables(Table[] tables) {
    }

    public Collection findSessionCollection(String name) {
        if (this.sessionCollections == null) {
            return null;
        }
        return (Collection)this.sessionCollections.get(name);
    }

    public void dropSchemaObjectInTransaction(String name) {
        this.transactionSchemaObjects.remove(name);
    }

    public void dropSessionCollection(String name) {
        this.sessionCollections.remove(name);
    }

    public HashMappedList getSessionCollections() {
        return this.sessionCollections;
    }

    public void addSchemaObjectInTransaction(SchemaObject object) {
        if (this.transactionSchemaObjects == null) {
            this.transactionSchemaObjects = new HashMappedList();
        }
        if (this.transactionSchemaObjects.containsKey(object.getObjectName().name)) {
            throw Error.error(5504);
        }
        this.transactionSchemaObjects.add(object.getObjectName().name, object);
    }

    public SchemaObject findSchemaObjectInTransaction(String name) {
        if (this.transactionSchemaObjects == null) {
            return null;
        }
        return (SchemaObject)this.transactionSchemaObjects.get(name);
    }

    public void setVtableParameter(String table, String parameter, Expression expr) {
        Map<String, Expression> params = this.virtualTableParameters.get(table);
        if (params == null) {
            params = new HashMap<String, Expression>();
            this.virtualTableParameters.put(table, params);
        }
        params.put(parameter, expr);
    }

    public Expression getVtableParameter(NameManager.ObjectName table, String parameter) {
        Map<String, Expression> params = this.virtualTableParameters.get(table.getSchemaQualifiedStatementName());
        if (params != null) {
            return params.get(parameter);
        }
        return null;
    }

    public void closeRoutineVariables() {
        SessionContext.closeVariables(this.session.sessionContext.routineVariables);
    }

    public static void closeVariables(Object[] vars) {
        if (vars != null) {
            for (Object var : vars) {
                if (var instanceof OtherTypeWrapper && ((OtherTypeWrapper)var).getObject() instanceof CloseableWrapper) {
                    ((CloseableWrapper)((OtherTypeWrapper)var).getObject()).close();
                    continue;
                }
                if (!(var instanceof CloseableWrapper)) continue;
                ((CloseableWrapper)var).close();
            }
        }
    }
}

