/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.session;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.DataspaceCompleteException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.JDBCDriver;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.CountUpDownLatch;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.HsqlDeque;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.parser.statement.StatementExpression;
import com.streamscape.ds.parser.statement.StatementManager;
import com.streamscape.ds.parser.statement.StatementQuery;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.parser.statement.StatementSession;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.rights.UserWrapper;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.server.AbstractVirtualClientServerObject;
import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.SessionContext;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.transaction.TransactionManagerMVCC;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.CloseableWrapper;
import com.streamscape.ds.types.DataspaceTypeWrapper;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.Utils;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.tools.lexer.BufferUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class Session
implements SessionInterface,
Closeable {
    private volatile boolean isClosed;
    public DataspaceStore dataspaceStore;
    private final UserWrapper sessionUser;
    private UserWrapper user;
    private Grantee role;
    public boolean isReadOnlyDefault;
    public int isolationLevelDefault = 2;
    public int isolationLevel = 2;
    boolean isReadOnlyIsolation;
    public int actionIndex;
    public long actionTimestamp;
    public long transactionTimestamp;
    public long transactionEndTimestamp;
    public long statementStartSCN;
    public boolean txConflictRollback;
    public boolean isPreTransaction;
    public boolean isTransaction;
    boolean isBatch;
    public volatile boolean abortTransaction;
    public volatile boolean redoAction;
    public volatile int sessionRedoCount;
    public HsqlArrayList rowActionList;
    public volatile boolean tempUnlocked;
    public OrderedHashSet waitedSessions;
    public OrderedHashSet waitingSessions;
    public OrderedHashSet tempSet;
    public CountUpDownLatch latch = new CountUpDownLatch();
    public Statement lockStatement;
    public TimeZone sessionTimeZone;
    private TimeZone timeZone;
    public boolean isNetwork;
    private int sessionMaxRows;
    private final long sessionId;
    int sessionTxId = -1;
    private boolean script;
    public boolean ignoreCase;
    private JDBCConnection intConnection;
    private JDBCConnection extConnection;
    public NameManager.ObjectName currentDataspace;
    public NameManager.ObjectName loggedSchema;
    public ParserCommand parser;
    public boolean isProcessingLog;
    public boolean isProcessingRecoveryLog;
    public SessionContext sessionContext;
    public int resultMaxMemoryRows;
    public boolean isCreatingDataspaceLike;
    private boolean disableReplication = false;
    private boolean isInteractive = false;
    private MFSession mfSession;
    private String componentName;
    private String slSessionName;
    private int transferBufferSize = 0x500000;
    private SLFileSessionContext slFileSessionContext = SLFileSessionContext.SERVER;
    private SLFileSessionContext statementSlFileSessionContext = null;
    private SLSessionData slSessionData;
    private int fetchSize = 0;
    private long requestTimeout = 0L;
    private int statementFetchSize = -1;
    private String slResourceName;
    public SessionData sessionData;
    public StatementManager statementManager;
    private volatile long currentThread = -1L;
    private volatile long lastThread = -1L;
    private final ReentrantLock currentThreadLock = new ReentrantLock();
    private int currentStatementCounter = 0;
    private boolean isCompleteMode = false;
    private boolean sdsRuntimeSession = false;
    public final boolean replicationIn2PCCommit = true;
    private long parentSessionId = -1L;
    private volatile NameManager.ObjectName sessionDataspaceRemoved;
    public boolean executingReplication = false;
    public NameManager.ObjectName replicationLockObjectName;
    public OrderedHashSet replicationWaitedSessions;
    public OrderedHashSet replicationWaitingSessions;
    public int replicationLockManualDepth;
    private final StatementDML dummyStatement;
    public AbstractVirtualClientServerObject serverContext;
    private boolean autoCommitVtables = true;
    private Map<VirtualServerObject, Pair<DatabaseConnection, Boolean>> vtableConnections = new java.util.HashMap<VirtualServerObject, Pair<DatabaseConnection, Boolean>>();
    public boolean insideTryCatchScript = false;
    private Charset ccsid = null;
    public Map<String, DataspaceTypeWrapper> dataspaceTypeWrappers = new java.util.HashMap<String, DataspaceTypeWrapper>();
    public final Map<String, FileSystem> dropBoxFileSystems = new ConcurrentHashMap<String, FileSystem>();
    public static final ThreadLocal<Session> sessionThreadLocal = new ThreadLocal();
    private boolean useCurrentDataspaceSessionInSysQuery = false;
    public SLSession slSessionForSysQuery = null;
    private final long connectTime = System.currentTimeMillis();
    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    long currentDateSCN;
    long currentTimestampSCN;
    long currentMillis;
    private TimestampData currentDate;
    private TimestampData currentTimestamp;
    private TimestampData localTimestamp;
    private TimeData currentTime;
    private TimeData localTime;
    HsqlDeque sqlWarnings;
    Calendar calendar;
    Type.TypedComparator typedComparator;
    Scanner secondaryScanner;
    SimpleDateFormat simpleDateFormat;
    SimpleDateFormat simpleDateFormatGMT;
    Random randomGenerator = new Random();
    long seed = -1L;
    BaseStoreProperties clientProperties;
    private boolean isTypesCheck;

    Session(DataspaceStore db, UserWrapper user, boolean autocommit, boolean readonly, long id, TimeZone timeZone) {
        this.sessionId = id;
        this.dataspaceStore = db;
        this.user = user;
        this.sessionUser = user;
        this.timeZone = timeZone;
        this.sessionTimeZone = timeZone;
        this.rowActionList = new HsqlArrayList(32, true);
        this.waitedSessions = new OrderedHashSet();
        this.waitingSessions = new OrderedHashSet();
        this.tempSet = new OrderedHashSet();
        this.isolationLevel = this.isolationLevelDefault = this.dataspaceStore.defaultIsolationLevel;
        this.txConflictRollback = this.dataspaceStore.txConflictRollback;
        this.isReadOnlyDefault = readonly;
        this.isReadOnlyIsolation = this.isolationLevel == 1;
        this.sessionContext = new SessionContext(this);
        this.sessionContext.isAutoCommit = autocommit ? Boolean.TRUE : Boolean.FALSE;
        this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
        this.parser = new ParserCommand(this, new Scanner());
        this.parser.initInternalParser();
        this.setResultMemoryRowCount(this.dataspaceStore.getResultMaxMemoryRows());
        this.resetSchema();
        this.sessionData = new SessionData(this.dataspaceStore, this);
        this.statementManager = new StatementManager(this.dataspaceStore);
        this.replicationWaitedSessions = new OrderedHashSet();
        this.replicationWaitingSessions = new OrderedHashSet();
        this.replicationLockObjectName = null;
        this.replicationLockManualDepth = 0;
        this.dummyStatement = new StatementDML(81, 2004, null);
        this.dummyStatement.setCompileTimestamp(Long.MAX_VALUE);
    }

    public synchronized void resetSchema() {
        this.loggedSchema = null;
        this.currentDataspace = this.user != null ? this.user.getInitialOrDefaultSchema() : (this.dataspaceStore != null && this.dataspaceStore.schemaManager != null ? this.dataspaceStore.schemaManager.getDefaultSchemaHsqlName() : null);
    }

    @Override
    public long getId() {
        return this.sessionId;
    }

    public int getCurrentStatementCounter() {
        return this.currentStatementCounter;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.rollback(false);
        try {
            this.dataspaceStore.dataspaceLogger.writeOtherStatement(this, LogRecordType.DISCONNECT, "DISCONNECT", this.getCurrentDataspaceName());
        }
        catch (DataspaceException dataspaceException) {
            // empty catch block
        }
        final ArrayList<CloseableWrapper> accessors = new ArrayList<CloseableWrapper>();
        for (Object var : this.sessionContext.routineVariables) {
            if (!((var = OtherTypeWrapper.unwrap(var)) instanceof CloseableWrapper)) continue;
            accessors.add((CloseableWrapper)var);
        }
        accessors.addAll(this.dataspaceTypeWrappers.values());
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.clearAllTables();
        this.statementManager.reset();
        this.dataspaceStore.collectionSessionManager.removeSession(this);
        this.rowActionList.clear();
        this.dataspaceStore = null;
        this.user = null;
        this.sessionContext.savepoints = null;
        this.sessionContext.lastIdentity = null;
        this.intConnection = null;
        this.isClosed = true;
        this.sessionContext.routineVariables = null;
        if (accessors.size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        for (CloseableWrapper accessor : accessors) {
                            accessor.close();
                        }
                        accessors.clear();
                    }
                    catch (Exception error) {
                        Trace.logError(Session.this, "Unable to close closeable wrapper. " + error.getMessage());
                    }
                }
            };
            FabricThread accessorCleanUpThread = FabricThreadManager.getInstance().createThread("DSYS:Accessor.Cleaner", "Closes any accessors opened inside of the session.", runnable);
            accessorCleanUpThread.start();
        }
        this.dropBoxFileSystems.values().forEach(f -> {
            try {
                f.close();
            }
            catch (IOException e) {
                Trace.logException(this, e, true);
            }
        });
        this.dropBoxFileSystems.clear();
        if (this.slSessionForSysQuery != null) {
            this.slSessionForSysQuery.close();
            this.slSessionForSysQuery = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void setIsolationDefault(int level) {
        if (level == 1) {
            level = 2;
        }
        if (level == this.isolationLevelDefault) {
            return;
        }
        this.isolationLevelDefault = level;
        if (!this.isInMidTransaction()) {
            this.isolationLevel = this.isolationLevelDefault;
            this.isReadOnlyIsolation = level == 1;
        }
    }

    public int getIsolationDefault() {
        return this.isolationLevelDefault;
    }

    public void setIsolation(int level) {
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        if (level == 1) {
            level = 2;
        }
        if (this.isolationLevel != level) {
            this.isolationLevel = level;
            this.isReadOnlyIsolation = level == 1;
        }
    }

    @Override
    public synchronized int getIsolation() {
        return this.isolationLevel;
    }

    public void setLastIdentity(Number i) {
        this.sessionContext.lastIdentity = i;
    }

    public Number getLastIdentity() {
        return this.sessionContext.lastIdentity;
    }

    public DataspaceStore getDataspaceStore() {
        return this.dataspaceStore;
    }

    public String getUsername() {
        return this.user.getObjectName().getNameString();
    }

    public UserWrapper getUser() {
        return this.user;
    }

    public Grantee getGrantee() {
        return this.user;
    }

    public Grantee getRole() {
        return this.role;
    }

    public void setUser(UserWrapper user) {
        this.user = user;
    }

    public void setRole(Grantee role) {
        this.role = role;
    }

    public int getMaxRows() {
        return this.sessionContext.currentMaxRows;
    }

    public void setSQLMaxRows(int rows) {
        this.sessionMaxRows = rows;
    }

    public int getSQLMaxRows() {
        return this.sessionMaxRows;
    }

    public void checkAdmin() {
        this.user.checkAdmin();
    }

    public void checkReadWrite() {
        if (this.sessionContext.isReadOnly.booleanValue() || this.isReadOnlyIsolation) {
            throw Error.error(3706);
        }
    }

    public void checkDDLWrite() {
        if (this.isProcessingLog || this.isProcessingRecoveryLog) {
            return;
        }
        this.checkReadWrite();
    }

    public long getActionTimestamp() {
        return this.actionTimestamp;
    }

    public void addDeleteAction(Table table, Row row, int[] colMap) {
        this.dataspaceStore.txManager.addDeleteAction(this, table, row, colMap, false);
    }

    public void addDeleteActionForUpdate(Table table, Row row, int[] colMap) {
        this.dataspaceStore.txManager.addDeleteAction(this, table, row, colMap, true);
    }

    public void addInsertAction(Table table, PersistentStore store, Row row, int[] changedColumns) {
        this.dataspaceStore.txManager.addInsertAction(this, table, store, row, changedColumns, false);
    }

    public void addInsertActionForUpdate(Table table, PersistentStore store, Row row, int[] changedColumns) {
        this.dataspaceStore.txManager.addInsertAction(this, table, store, row, changedColumns, true);
    }

    @Override
    public synchronized void setAutoCommit(boolean autocommit) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.isAutoCommit != autocommit) {
            this.commit(false);
            this.sessionContext.isAutoCommit = ValuePool.getBoolean(autocommit);
        }
    }

    public void beginAction(Statement cs) {
        this.actionIndex = this.rowActionList.size();
        this.dataspaceStore.txManager.beginAction(this, cs);
        this.dataspaceStore.txManager.beginActionResume(this);
    }

    public void endAction(Result result) {
        this.endAction(result, true);
    }

    public void endAction(Result result, boolean clearStatementTables) {
        if (clearStatementTables) {
            this.sessionData.persistentStoreCollection.clearStatementTables();
        }
        if (result.mode == 2) {
            this.sessionData.persistentStoreCollection.clearResultTables(this.actionTimestamp);
            this.dataspaceStore.txManager.rollbackAction(this);
        } else {
            this.sessionContext.diagnosticsVariables[2] = result.mode == 1 ? Integer.valueOf(result.getUpdateCount()) : ValuePool.INTEGER_0;
            this.dataspaceStore.txManager.completeActions(this);
        }
        this.sessionContext.virtualTableParameters.clear();
    }

    public boolean hasLocks(Statement statement) {
        if (this.lockStatement == statement) {
            if (this.isolationLevel == 4 || this.isolationLevel == 8) {
                return true;
            }
            if (statement.getTableNamesForRead().length == 0) {
                return true;
            }
        }
        return false;
    }

    public void startTransaction() {
        this.sessionRedoCount = 0;
        this.dataspaceStore.txManager.beginTransaction(this);
    }

    public void startTransactionWithWait(boolean withResume) {
        this.startTransactionWithWait(this.dummyStatement, withResume);
    }

    public void startTransactionWithWait(Statement statement, boolean withResume) {
        this.setCurrentThreadIdWithLock(Thread.currentThread().getId());
        if (this.abortTransaction) {
            this.rollback(false);
            this.setCurrentThreadIdWithLock(-1L);
            throw Error.error(4861);
        }
        ++this.currentStatementCounter;
        this.sessionContext.currentStatement = statement;
        this.actionIndex = this.rowActionList.size();
        this.dataspaceStore.txManager.beginAction(this, statement);
        statement = this.sessionContext.currentStatement;
        if (statement == null) {
            throw Error.error(1252);
        }
        if (this.abortTransaction) {
            this.rollback(false);
            this.sessionContext.currentStatement = null;
            this.setCurrentThreadIdWithLock(-1L);
            throw Error.error(4861);
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException exception) {
            this.setCurrentThreadIdWithLock(-1L);
            Trace.logError(this, "startTransactionWithWait interrupted.");
            Trace.logException(this, exception, true);
            Thread.interrupted();
            this.abortTransaction = true;
        }
        if (this.abortTransaction) {
            this.rollback(false);
            this.sessionContext.currentStatement = null;
            this.setCurrentThreadIdWithLock(-1L);
            throw Error.error(4861);
        }
        if (withResume) {
            this.dataspaceStore.txManager.beginActionResume(this);
        }
    }

    public void rollbackTransactionWithAction(boolean chain) {
        --this.currentStatementCounter;
        this.endAction(Result.newErrorResult(new Exception()));
        this.rollback(chain);
    }

    public void commitTransactionWithAction(boolean chain) {
        --this.currentStatementCounter;
        this.endAction(Result.updateOneResult, true);
        if (this.abortTransaction) {
            this.rollback(false);
            this.sessionContext.currentStatement = null;
            this.setCurrentThreadIdWithLock(-1L);
            throw Error.error(4861, "aborted");
        }
        if (this.redoAction) {
            this.redoAction = false;
            this.abortTransaction = true;
        }
        this.commit(chain);
    }

    @Override
    public synchronized void startPhasedTransaction() {
    }

    @Override
    public synchronized void prepareCommit() {
        if (this.isClosed) {
            throw Error.error(1303);
        }
        if (!this.dataspaceStore.txManager.prepareCommitActions(this)) {
            this.rollback(false);
            throw Error.error(4861);
        }
    }

    @Override
    public synchronized void commit(boolean chain) {
        boolean commitVtables;
        block14: {
            this.sessionContext.lastStatementsInTransaction.clear();
            if (this.isClosed) {
                return;
            }
            if (this.sessionContext.depth > 0) {
                return;
            }
            if (!this.isTransaction && this.rowActionList.size() == 0) {
                this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
                this.setIsolation(this.isolationLevelDefault);
                return;
            }
            commitVtables = true;
            try {
                this.commitVtables();
            }
            catch (Exception exception) {
                this.sessionContext.onCommitException = exception;
                commitVtables = false;
            }
            try {
                this.dataspaceStore.getFullTextManager().commit(this);
            }
            catch (Exception e) {
                boolean txSync = this.dataspaceStore.getFullTextManager().txSyncEnable();
                if (txSync) {
                    this.dataspaceStore.getFullTextManager().setTxTextIndexSuspectState(this);
                    this.rollback(chain);
                    throw new DataspaceException("Full-text commit operation failed");
                }
                Trace.logException(this, e, true);
                String stringToLog = this.dataspaceStore.getFullTextManager().getRowActionListToLog(this);
                if (stringToLog == null) break block14;
                Trace.logInfo(this, stringToLog);
            }
        }
        if (!commitVtables || !this.dataspaceStore.txManager.commitTransaction(this)) {
            Throwable throwable;
            try {
                if (!this.dataspaceStore.getFullTextManager().txSyncEnable()) {
                    this.dataspaceStore.getFullTextManager().setTxCollectionSuspectState(this);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.rollback(chain);
            Throwable throwable2 = throwable = this.sessionContext.onCommitFireTriggersException != null ? this.sessionContext.onCommitFireTriggersException : this.sessionContext.onCommitException;
            if (throwable != null) {
                DataspaceException exception = throwable instanceof DataspaceException ? (DataspaceException)throwable : new DataspaceException(throwable.getMessage(), throwable);
                this.sessionContext.onCommitFireTriggersException = null;
                this.sessionContext.onCommitException = null;
                if (exception.getErrorCode() == -7101) {
                    return;
                }
                throw exception;
            }
            throw Error.error(4861);
        }
        this.endTransaction(true, chain);
    }

    @Override
    public synchronized void rollback(boolean chain) {
        this.sessionContext.lastStatementsInTransaction.clear();
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.depth > 0) {
            return;
        }
        try {
            this.rollbackVtables();
            this.dataspaceStore.getFullTextManager().rollback(this);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        this.dataspaceStore.txManager.rollback(this);
        this.endTransaction(false, chain);
    }

    private void endTransaction(boolean commit, boolean chain) {
        StatementSession endTX;
        this.sessionContext.savepoints.clear();
        this.sessionContext.savepointTimestamps.clear();
        this.rowActionList.clear();
        this.sessionData.persistentStoreCollection.clearTransactionTables();
        this.sessionData.closeAllTransactionNavigators();
        this.sessionData.clearNewLobIDs();
        this.lockStatement = null;
        this.logSequences();
        if (!chain) {
            this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
            this.setIsolation(this.isolationLevelDefault);
        }
        StatementSession statementSession = endTX = commit ? StatementSession.commitNoChainStatement : StatementSession.rollbackNoChainStatement;
        if (this.dataspaceStore.dataspaceLogger.getSqlEventLogLevel() > 0) {
            this.dataspaceStore.dataspaceLogger.logStatementEvent(this, endTX, null, 2);
        }
        this.sessionData.deleteUnusedFlobs();
    }

    @Override
    public synchronized void resetSession() {
        if (this.isClosed) {
            return;
        }
        this.rollback(false);
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.clearAllTables();
        this.sessionData.clearNewLobIDs();
        this.statementManager.reset();
        this.sessionContext.lastIdentity = ValuePool.INTEGER_0;
        this.setResultMemoryRowCount(this.dataspaceStore.getResultMaxMemoryRows());
        this.user = this.sessionUser;
        this.resetSchema();
        this.setZoneSeconds(-1);
        this.sessionMaxRows = 0;
        this.ignoreCase = false;
        this.setIsolation(this.isolationLevelDefault);
        this.txConflictRollback = this.dataspaceStore.txConflictRollback;
        this.sessionRedoCount = 0;
    }

    @Override
    public synchronized void savepoint(String name) {
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index != -1) {
            this.sessionContext.savepoints.remove(name);
            this.sessionContext.savepointTimestamps.remove(index);
        }
        this.sessionContext.savepoints.add(name, ValuePool.getInt(this.rowActionList.size()));
        this.sessionContext.savepointTimestamps.addLast(this.actionTimestamp);
    }

    @Override
    public synchronized void rollbackToSavepoint(String name) {
        if (this.isClosed) {
            return;
        }
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index < 0) {
            throw Error.error(4821, name);
        }
        this.dataspaceStore.txManager.rollbackSavepoint(this, index);
    }

    public synchronized void rollbackToSavepoint() {
        if (this.isClosed) {
            return;
        }
        String name = (String)this.sessionContext.savepoints.getKey(0);
        this.dataspaceStore.txManager.rollbackSavepoint(this, 0);
    }

    @Override
    public synchronized void releaseSavepoint(String name) {
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index < 0) {
            throw Error.error(4821, name);
        }
        while (this.sessionContext.savepoints.size() > index) {
            this.sessionContext.savepoints.remove(this.sessionContext.savepoints.size() - 1);
            this.sessionContext.savepointTimestamps.removeLast();
        }
    }

    public boolean isInMidTransaction() {
        return this.isTransaction;
    }

    public void setNoSQL() {
        this.sessionContext.noSQL = Boolean.TRUE;
    }

    public void setIgnoreCase(boolean mode) {
        this.ignoreCase = mode;
    }

    public boolean isIgnorecase() {
        return this.ignoreCase;
    }

    public void setReadOnly(boolean readonly) {
        if (!readonly && this.dataspaceStore.isReadOnly()) {
            throw Error.error(455);
        }
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        this.sessionContext.isReadOnly = readonly ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public synchronized void setReadOnlyDefault(boolean readonly) {
        if (!readonly && this.dataspaceStore.isReadOnly()) {
            throw Error.error(455);
        }
        this.isReadOnlyDefault = readonly;
        if (!this.isInMidTransaction()) {
            this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public boolean isReadOnly() {
        return this.sessionContext.isReadOnly != false || this.isReadOnlyIsolation;
    }

    @Override
    public synchronized boolean isReadOnlyDefault() {
        return this.isReadOnlyDefault;
    }

    @Override
    public synchronized boolean isAutoCommit() {
        return this.sessionContext.isAutoCommit;
    }

    @Override
    public synchronized int getStreamBlockSize() {
        return 524288;
    }

    public void setScripting(boolean script) {
        this.script = script;
    }

    boolean isScripting() {
        return this.script;
    }

    public JDBCConnection getInternalConnection() {
        if (this.intConnection == null) {
            this.intConnection = new JDBCConnection(this);
        }
        JDBCDriver.driverInstance.threadConnection.set(this.intConnection);
        return this.intConnection;
    }

    public void releaseInternalConnection() {
        if (this.sessionContext.depth == 0) {
            JDBCDriver.driverInstance.threadConnection.set(null);
        }
    }

    @Override
    public JDBCConnection getJDBCConnection() {
        return this.extConnection;
    }

    @Override
    public void setJDBCConnection(JDBCConnection connection) {
        this.extConnection = connection;
    }

    @Override
    public String getStoreUniqueName() {
        return this.dataspaceStore.getUniqueName();
    }

    public boolean isAdmin() {
        return this.user.isAdmin();
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public int getTransactionSize() {
        return this.rowActionList.size();
    }

    public long getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public Statement compileStatement(String sql, int props) {
        this.parser.reset(sql);
        Statement cs = this.parser.compileStatement(props);
        return cs;
    }

    public Statement compileStatement(String sql) {
        this.parser.reset(sql);
        Statement cs = this.parser.compileStatement(0);
        cs.setCompileTimestamp(Long.MAX_VALUE);
        if (this.sessionContext.transactionSchemaObjects != null) {
            this.sessionContext.transactionSchemaObjects.clear();
            this.sessionContext.transactionSchemaObjects = null;
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Result execute(Result cmd) {
        Session sessionThreadLocalOld = sessionThreadLocal.get();
        sessionThreadLocal.set(this);
        try {
            Result result = this.executeInternal(cmd);
            return result;
        }
        finally {
            sessionThreadLocal.set(sessionThreadLocalOld);
            if (!this.isInteractive()) {
                this.resetStatementFetchSize();
                this.resetStatementSLFileSessionContext();
            }
        }
    }

    private synchronized Result executeInternal(Result cmd) {
        if (this.isClosed) {
            return Result.newErrorResult(Error.error(1353));
        }
        this.sessionContext.currentMaxRows = 0;
        this.isBatch = false;
        JavaSystem.gc();
        switch (cmd.mode) {
            case 18: {
                return this.performLOBOperation((ResultLob)cmd);
            }
            case 35: {
                int maxRows = cmd.getUpdateCount();
                this.sessionContext.currentMaxRows = maxRows == -1 ? 0 : maxRows;
                Statement cs = cmd.statement;
                if (cs == null || cs.compileTimestamp < this.dataspaceStore.schemaManager.schemaChangeTimestamp) {
                    long csid = cmd.getStatementID();
                    cs = this.statementManager.getStatement(this, csid);
                    cmd.setStatement(cs);
                    if (cs == null) {
                        return Result.newErrorResult(Error.error(1252));
                    }
                }
                Object[] pvals = (Object[])cmd.valueData;
                Result result = this.executeCompiledStatement(cs, pvals);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 9: {
                this.isBatch = true;
                Result result = this.executeCompiledBatchStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 34: {
                Result result = this.executeDirectStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 8: {
                this.isBatch = true;
                Result result = this.executeDirectBatchStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 37: {
                Statement cs;
                try {
                    cs = this.statementManager.compile(this, cmd);
                }
                catch (Throwable t) {
                    String errorString = cmd.getMainString();
                    if (this.dataspaceStore.getDataspaceStoreProperties().getErrorLevel() == 1) {
                        errorString = null;
                    }
                    return Result.newErrorResult(t, errorString);
                }
                Result result = Result.newPrepareResponse(cs);
                if (cs.getType() == 85 || cs.getType() == 7 || cs.getType() == 100 || cs.getType() == 101) {
                    this.sessionData.setResultSetProperties(cmd, result);
                }
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 40: {
                this.closeNavigator(cmd.getResultId());
                return Result.updateZeroResult;
            }
            case 41: {
                Result result = this.executeResultUpdate(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 36: {
                this.statementManager.freeStatement(cmd.getStatementID());
                return Result.updateZeroResult;
            }
            case 7: {
                int id = cmd.getStatementType();
                return this.getAttributesResult(id);
            }
            case 6: {
                return this.setAttributes(cmd);
            }
            case 33: {
                switch (cmd.getActionType()) {
                    case 0: {
                        try {
                            this.commit(false);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 6: {
                        try {
                            this.commit(true);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 1: {
                        this.rollback(false);
                        break;
                    }
                    case 7: {
                        this.rollback(true);
                        break;
                    }
                    case 4: {
                        try {
                            String name = cmd.getMainString();
                            this.releaseSavepoint(name);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 2: {
                        try {
                            this.rollbackToSavepoint(cmd.getMainString());
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 38: {
                switch (cmd.getConnectionAttrType()) {
                    case 10027: {
                        try {
                            this.savepoint(cmd.getMainString());
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 13: {
                return this.sessionData.getDataResultSlice(cmd.getResultId(), cmd.getUpdateCount(), cmd.getFetchSize());
            }
            case 32: {
                this.close();
                return Result.updateZeroResult;
            }
        }
        return Result.newErrorResult(Error.runtimeError(201, "Session"));
    }

    private Result performPostExecute(Result command, Result result) {
        if (command != null) {
            command.setFetchSize(this.getFetchSize());
        }
        if (result.mode == 3) {
            result = this.sessionData.getDataResultHead(command, result, this.isNetwork);
        }
        if (this.sqlWarnings != null && this.sqlWarnings.size() > 0) {
            if (result.mode == 1) {
                result = new Result(1, result.getUpdateCount());
            }
            DataspaceException[] warnings = this.getAndClearWarnings();
            result.addWarnings(warnings);
        }
        return result;
    }

    @Override
    public RowSetNavigatorClient getRows(long navigatorId, int offset, int blockSize) {
        return this.sessionData.getRowSetSlice(navigatorId, offset, blockSize);
    }

    @Override
    public synchronized void closeNavigator(long id) {
        this.sessionData.closeNavigator(id);
    }

    public synchronized Result executeDirectStatement(Result cmd) {
        HsqlArrayList list;
        int maxRows;
        String sql = cmd.getMainString();
        boolean isDebugEnaled = Trace.isDebugEnabled(Session.class);
        long startTime = 0L;
        if (isDebugEnaled) {
            Trace.logDebug(Session.class, "[executeDirectStatement] Session: " + this.sessionId + " SQL: " + sql);
            startTime = System.currentTimeMillis();
        }
        if ((maxRows = cmd.getUpdateCount()) == -1) {
            this.sessionContext.currentMaxRows = 0;
        } else if (this.sessionMaxRows == 0) {
            this.sessionContext.currentMaxRows = maxRows;
        } else {
            this.sessionContext.currentMaxRows = this.sessionMaxRows;
            this.sessionMaxRows = 0;
        }
        try {
            list = this.parser.compileStatements(sql, cmd);
        }
        catch (Exception e) {
            return Result.newErrorResult(e);
        }
        Result result = null;
        for (int i = 0; i < list.size(); ++i) {
            Statement cs = (Statement)list.get(i);
            cs.setGeneratedColumnInfo(cmd.getGeneratedResultType(), cmd.getGeneratedResultMetaData());
            result = this.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
            if (result.mode == 2) break;
        }
        if (isDebugEnaled) {
            Trace.logDebug(Session.class, "[executeDirectStatement] Session: " + this.sessionId + " SQL execution time " + (System.currentTimeMillis() - startTime) + " ms.");
        }
        return result;
    }

    public synchronized Result executeDirectStatement(String sql) {
        try {
            Statement cs = this.compileStatement(sql);
            Result result = this.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
            return result;
        }
        catch (DataspaceException e) {
            return Result.newErrorResult(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSLCompletion complete(String sql) {
        try {
            this.setCompleteMode(true);
            this.parser.reset(sql);
            this.parser.setCompleteMode(true);
            this.sessionContext.backupVariablesBeforeComplete();
            this.parser.compileStatement(0);
        }
        catch (DataspaceCompleteException e) {
            DSLCompletion dSLCompletion = e.getCompletion();
            return dSLCompletion;
        }
        catch (Exception exception) {
            if (exception instanceof DataspaceException) {
                if ("42590".equals(((DataspaceException)exception).getSQLState())) {
                    DSLCompletion dSLCompletion = null;
                    return dSLCompletion;
                }
                if ("Syntax Error: Unsupported language request.".equals(exception.getMessage())) {
                    DSLCompletion dSLCompletion = null;
                    return dSLCompletion;
                }
            }
            DSLCompletion dSLCompletion = new DSLCompletion(exception);
            return dSLCompletion;
        }
        finally {
            this.sessionContext.restoreVariablesAfterComplete();
            this.parser.setCompleteMode(false);
            this.setCompleteMode(false);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public synchronized Result executeCompiledStatement(Statement cs, Object[] pvals) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeTryCatchScript(Statement cs, Object[] pvals) {
        Result result;
        block15: {
            List tryLines = (List)((StatementSchema)cs).arguments[0];
            String exceptionName = (String)((StatementSchema)cs).arguments[1];
            List catchLines = (List)((StatementSchema)cs).arguments[2];
            result = Result.updateNoResult;
            NameManager.ObjectName dataspaceName = this.currentDataspace;
            boolean isSDSRuntimeSession = this.isSDSRuntimeSession();
            boolean insideTryCatchScriptOrig = this.insideTryCatchScript;
            try {
                this.insideTryCatchScript = true;
                int sessionVariablesCount = this.sessionContext.sessionVariables.size();
                try {
                    for (Pair line : tryLines) {
                        result = this.executeDirectStatement((String)line.second);
                        if (!result.isError()) continue;
                        this.updateExceptionPositions(result.getException(), cs.sql, line);
                        break;
                    }
                }
                catch (Exception exception) {
                    result = Result.newErrorResult(exception);
                }
                finally {
                    this.sessionContext.removeSessionVariablesLast(this.sessionContext.sessionVariables.size() - sessionVariablesCount);
                }
                if (!result.isError()) break block15;
                NameManager.ObjectName exceptionVariable = NameManager.newSystemObjectName(exceptionName, 23);
                ColumnSchema variable = new ColumnSchema(exceptionVariable, new OtherType(DataspaceException.class.getSimpleName(), DataspaceException.class), true, false, null);
                variable.setParameterMode((byte)2);
                this.sessionContext.addSessionVariable(variable);
                this.sessionContext.routineVariables[this.sessionContext.sessionVariables.size() - 1] = result.getException();
                result = Result.updateNoResult;
                sessionVariablesCount = this.sessionContext.sessionVariables.size();
                try {
                    for (Pair line : catchLines) {
                        result = this.executeDirectStatement((String)line.second);
                        if (!result.isError()) continue;
                        this.updateExceptionPositions(result.getException(), cs.sql, line);
                        Trace.logError(this, "Catch execution error: " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
                        break;
                    }
                    this.sessionContext.removeSessionVariablesLast(this.sessionContext.sessionVariables.size() - sessionVariablesCount);
                }
                catch (Throwable throwable) {
                    this.sessionContext.removeSessionVariablesLast(this.sessionContext.sessionVariables.size() - sessionVariablesCount);
                    this.sessionContext.removeSessionVariables(new NameManager.ObjectName[]{exceptionVariable});
                    throw throwable;
                }
                this.sessionContext.removeSessionVariables(new NameManager.ObjectName[]{exceptionVariable});
            }
            catch (Exception exception) {
                result = Result.newErrorResult(exception);
            }
            finally {
                this.insideTryCatchScript = insideTryCatchScriptOrig;
                this.setCurrentDataspaceName(dataspaceName);
                this.setSDSRuntimeSession(isSDSRuntimeSession);
            }
        }
        return result;
    }

    private void updateExceptionPositions(DataspaceException exception, String sql, Pair<Integer, String> line) {
        if (exception == null || line == null) {
            return;
        }
        if (exception.getLineNumber() <= 0) {
            return;
        }
        int position = BufferUtils.getAbsolutePosition((String)line.second, exception.getLineNumber(), exception.getPositionInLine());
        BufferUtils.setLineAndPositions(exception, sql, position += ((Integer)line.first).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeIfScript(Statement cs, Object[] pvals) {
        block15: {
            List conditions = (List)((StatementSchema)cs).arguments[0];
            List blocks = (List)((StatementSchema)cs).arguments[1];
            NameManager.ObjectName dataspaceName = this.currentDataspace;
            boolean isSDSRuntimeSession = this.isSDSRuntimeSession();
            boolean insideTryCatchScriptOrig = this.insideTryCatchScript;
            try {
                this.insideTryCatchScript = true;
                for (int i = 0; i < conditions.size(); ++i) {
                    StatementExpression condition = (StatementExpression)conditions.get(i);
                    List block = (List)blocks.get(i);
                    Result result = condition.execute(this);
                    if (result.isError()) {
                        Result result2 = result;
                        return result2;
                    }
                    Boolean resultValue = (Boolean)result.getValueObject();
                    if (!resultValue.booleanValue()) continue;
                    int sessionVariablesCount = this.sessionContext.sessionVariables.size();
                    try {
                        Iterator iterator = block.iterator();
                        while (true) {
                            if (iterator.hasNext()) {
                                Pair line = (Pair)iterator.next();
                                result = this.executeDirectStatement((String)line.second);
                                if (!result.isError()) continue;
                                this.updateExceptionPositions(result.getException(), cs.sql, line);
                                Result result3 = result;
                                return result3;
                                continue;
                            }
                            break block15;
                            break;
                        }
                    }
                    finally {
                        this.sessionContext.removeSessionVariablesLast(this.sessionContext.sessionVariables.size() - sessionVariablesCount);
                    }
                }
            }
            catch (Exception exception) {
                Result result = Result.newErrorResult(exception);
                return result;
            }
            finally {
                this.insideTryCatchScript = insideTryCatchScriptOrig;
                this.setCurrentDataspaceName(dataspaceName);
                this.setSDSRuntimeSession(isSDSRuntimeSession);
            }
        }
        return Result.updateNoResult;
    }

    private Result executeCompiledBatchStatement(Result cmd) {
        long csid;
        Statement cs = cmd.statement;
        if ((cs == null || cs.compileTimestamp < this.dataspaceStore.schemaManager.schemaChangeTimestamp) && (cs = this.statementManager.getStatement(this, csid = cmd.getStatementID())) == null) {
            return Result.newErrorResult(Error.error(1252));
        }
        int count = 0;
        RowSetNavigator nav = cmd.initialiseNavigator();
        int[] updateCounts = new int[nav.getSize()];
        Result generatedResult = null;
        if (cs.hasGeneratedColumns()) {
            generatedResult = Result.newGeneratedDataResult(cs.generatedResultMetaData());
        }
        Result error = null;
        while (nav.hasNext()) {
            Object[] pvals = nav.getNext();
            Result in = this.executeCompiledStatement(cs, pvals);
            if (in.isUpdateCount()) {
                if (cs.hasGeneratedColumns()) {
                    RowSetNavigator navgen = in.getChainedResult().getNavigator();
                    while (navgen.hasNext()) {
                        Object[] generatedRow = navgen.getNext();
                        generatedResult.getNavigator().add(generatedRow);
                    }
                }
                updateCounts[count++] = in.getUpdateCount();
                continue;
            }
            if (in.isData()) {
                updateCounts[count++] = -2;
                continue;
            }
            if (in.mode == 2) {
                updateCounts = ArrayUtil.arraySlice(updateCounts, 0, count);
                error = in;
                break;
            }
            throw Error.runtimeError(201, "Session");
        }
        return Result.newBatchedExecuteResponse(updateCounts, generatedResult, error);
    }

    private Result executeDirectBatchStatement(Result cmd) {
        int count = 0;
        RowSetNavigator nav = cmd.initialiseNavigator();
        int[] updateCounts = new int[nav.getSize()];
        Result error = null;
        while (nav.hasNext()) {
            Result in;
            Object[] data = nav.getNext();
            String sql = (String)data[0];
            try {
                in = this.executeDirectStatement(sql);
            }
            catch (Throwable t) {
                in = Result.newErrorResult(t);
            }
            if (in.isUpdateCount()) {
                updateCounts[count++] = in.getUpdateCount();
                continue;
            }
            if (in.isData()) {
                updateCounts[count++] = -2;
                continue;
            }
            if (in.mode == 2) {
                updateCounts = ArrayUtil.arraySlice(updateCounts, 0, count);
                error = in;
                break;
            }
            throw Error.runtimeError(201, "Session");
        }
        return Result.newBatchedExecuteResponse(updateCounts, null, error);
    }

    private Result executeResultUpdate(Result cmd) {
        long id = cmd.getResultId();
        int actionType = cmd.getActionType();
        Result result = this.sessionData.getDataResult(id);
        if (result == null) {
            return Result.newErrorResult(Error.error(3601));
        }
        Object[] pvals = (Object[])cmd.valueData;
        Type[] types = cmd.metaData.columnTypes;
        StatementQuery statement = (StatementQuery)result.getStatement();
        QueryExpression qe = statement.queryExpression;
        Table baseTable = qe.getBaseTable();
        int[] columnMap = qe.getBaseTableColumnMap();
        this.sessionContext.rowUpdateStatement.setRowActionProperties(result, actionType, baseTable, types, columnMap);
        Result resultOut = this.executeCompiledStatement(this.sessionContext.rowUpdateStatement, pvals);
        return resultOut;
    }

    @Override
    public synchronized TimestampData getCurrentDate() {
        this.resetCurrentTimestamp();
        if (this.currentDate == null) {
            this.currentDate = (TimestampData)Type.SQL_DATE.getValue(this.currentMillis / 1000L, 0, this.getZoneSeconds());
        }
        return this.currentDate;
    }

    public synchronized TimeData getCurrentTime(boolean withZone) {
        this.resetCurrentTimestamp();
        if (withZone) {
            if (this.currentTime == null) {
                int seconds = (int)DataspaceDateTime.getNormalisedTime(this.currentMillis) / 1000;
                int nanos = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTime = new TimeData(seconds, nanos, this.getZoneSeconds());
            }
            return this.currentTime;
        }
        if (this.localTime == null) {
            int seconds = (int)DataspaceDateTime.getNormalisedTime(this.currentMillis + (long)(this.getZoneSeconds() * 1000)) / 1000;
            int nanos = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTime = new TimeData(seconds, nanos, 0);
        }
        return this.localTime;
    }

    public synchronized TimestampData getCurrentTimestamp(boolean withZone) {
        this.resetCurrentTimestamp();
        if (withZone) {
            if (this.currentTimestamp == null) {
                int nanos = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTimestamp = new TimestampData(this.currentMillis, nanos, this.getZoneSeconds());
            }
            return this.currentTimestamp;
        }
        if (this.localTimestamp == null) {
            int nanos = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTimestamp = new TimestampData(this.currentMillis + (long)(this.getZoneSeconds() * 1000), nanos, 0);
        }
        return this.localTimestamp;
    }

    public synchronized TimestampData getCurrentSqlTimestamp() {
        return this.getSqlTimestamp(System.currentTimeMillis());
    }

    public synchronized TimestampData getSqlTimestamp(long millis) {
        int nanos = (int)(millis % 1000L) * 1000000;
        return new TimestampData(millis + (long)(this.getZoneSeconds() * 1000), nanos, 0);
    }

    public synchronized TimeData getSqlTime(long millis) {
        int nanos = (int)(millis % 1000L) * 1000000;
        return new TimeData((int)(millis / 1000L + (long)this.getZoneSeconds()), nanos);
    }

    private void resetCurrentTimestamp() {
        if (this.currentTimestampSCN != this.actionTimestamp) {
            this.currentTimestampSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTimestamp = null;
            this.localTimestamp = null;
            this.currentTime = null;
            this.localTime = null;
        }
    }

    @Override
    public int getZoneSeconds() {
        return this.timeZone.getOffset(System.currentTimeMillis()) / 1000;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setSessionTimeZone(TimeZone timeZone) {
        this.setZoneSeconds(-1);
        this.sessionTimeZone = timeZone;
        this.timeZone = timeZone;
    }

    public void setZoneSeconds(int seconds) {
        if (seconds == -1) {
            this.calendar = null;
            this.timeZone = this.sessionTimeZone;
        } else {
            this.timeZone = TimeZone.getDefault();
            this.timeZone.setRawOffset(seconds * 1000);
            this.calendar = new GregorianCalendar(this.timeZone);
        }
    }

    private Result getAttributesResult(int id) {
        Result r = Result.newSessionAttributesResult();
        Object[] data = r.getSingleRowData();
        data[0] = ValuePool.getInt(id);
        switch (id) {
            case 0: {
                data[1] = ValuePool.getInt(this.isolationLevel);
                break;
            }
            case 1: {
                data[2] = this.sessionContext.isAutoCommit;
                break;
            }
            case 2: {
                data[2] = this.sessionContext.isReadOnly;
                break;
            }
            case 3: {
                data[3] = this.dataspaceStore.getCatalogName().name;
            }
        }
        return r;
    }

    private Result setAttributes(Result r) {
        Object[] row = r.getSessionAttributes();
        int id = (Integer)row[0];
        try {
            switch (id) {
                case 1: {
                    boolean value = (Boolean)row[2];
                    this.setAutoCommit(value);
                    break;
                }
                case 2: {
                    boolean value = (Boolean)row[2];
                    this.setReadOnlyDefault(value);
                    break;
                }
                case 0: {
                    int value = (Integer)row[1];
                    this.setIsolationDefault(value);
                    break;
                }
                case 3: {
                    String value = (String)row[3];
                    this.setCatalog(value);
                }
            }
        }
        catch (DataspaceException e) {
            return Result.newErrorResult(e);
        }
        return Result.updateZeroResult;
    }

    @Override
    public synchronized Object getAttribute(int id) {
        switch (id) {
            case 0: {
                return ValuePool.getInt(this.isolationLevel);
            }
            case 1: {
                return this.sessionContext.isAutoCommit;
            }
            case 2: {
                return this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.dataspaceStore.getCatalogName().name;
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(int id, Object object) {
        switch (id) {
            case 1: {
                boolean value = (Boolean)object;
                this.setAutoCommit(value);
                break;
            }
            case 2: {
                boolean value = (Boolean)object;
                this.setReadOnlyDefault(value);
                break;
            }
            case 0: {
                int value = (Integer)object;
                this.setIsolationDefault(value);
                break;
            }
            case 3: {
                String value = (String)object;
                this.setCatalog(value);
            }
        }
    }

    @Override
    public BlobDataID createBlob(long length) {
        long lobID = this.dataspaceStore.lobManager.createBlob(this, length);
        if (lobID == 0L) {
            throw Error.error(3474);
        }
        this.sessionData.registerNewLob(lobID);
        return new BlobDataID(lobID);
    }

    @Override
    public ClobDataID createClob(long length) {
        long lobID = this.dataspaceStore.lobManager.createClob(this, length);
        if (lobID == 0L) {
            throw Error.error(3474);
        }
        this.sessionData.registerNewLob(lobID);
        return new ClobDataID(lobID);
    }

    public void registerResultLobs(Result result) {
        this.sessionData.registerLobForResult(result);
    }

    @Override
    public void allocateResultLob(ResultLob result, InputStream inputStream) {
        this.sessionData.allocateLobForResult(result, inputStream);
    }

    Result performLOBOperation(ResultLob cmd) {
        long id = cmd.getLobID();
        int operation = cmd.getSubType();
        switch (operation) {
            case 11: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.getFlob(id, cmd.getOffset(), cmd.getBlockLength());
                }
                return this.dataspaceStore.lobManager.getLob(id, cmd.getOffset(), cmd.getBlockLength());
            }
            case 10: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.getLengthResult(id);
                }
                return this.dataspaceStore.lobManager.getLength(id);
            }
            case 1: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.getBytes(id, cmd.getOffset(), (int)cmd.getBlockLength());
                }
                return this.dataspaceStore.lobManager.getBytes(id, cmd.getOffset(), (int)cmd.getBlockLength());
            }
            case 2: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.setBytes(id, cmd.getOffset(), cmd.getByteArray(), (int)cmd.getBlockLength());
                }
                return this.dataspaceStore.lobManager.setBytes(id, cmd.getOffset(), cmd.getByteArray(), (int)cmd.getBlockLength());
            }
            case 3: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.getChars(this, id, cmd.getOffset(), (int)cmd.getBlockLength());
                }
                return this.dataspaceStore.lobManager.getChars(id, cmd.getOffset(), (int)cmd.getBlockLength());
            }
            case 4: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.setChars(id, cmd.getOffset(), cmd.getCharArray());
                }
                return this.dataspaceStore.lobManager.setChars(id, cmd.getOffset(), cmd.getCharArray());
            }
            case 9: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.truncate(id, cmd.getOffset());
                }
                return this.dataspaceStore.lobManager.truncate(id, cmd.getOffset());
            }
            case 12: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.createDuplicateLob(id);
                }
                return this.dataspaceStore.lobManager.createDuplicateLob(id);
            }
            case 7: 
            case 8: {
                throw Error.error(1551);
            }
            case 5: {
                if (cmd.isFlob() && cmd.getByteArray() != null) {
                    return this.dataspaceStore.flobManager.position(cmd.getLobID(), cmd.getOffset(), cmd.getByteArray());
                }
                throw Error.error(1551);
            }
            case 6: {
                if (cmd.isFlob() && cmd.getCharArray() != null) {
                    return this.dataspaceStore.flobManager.position(cmd.getLobID(), cmd.getOffset(), cmd.getCharArray());
                }
                throw Error.error(1551);
            }
            case 13: {
                if (cmd.isFlob()) {
                    return this.dataspaceStore.flobManager.getLengthResult(id);
                }
                return this.dataspaceStore.lobManager.getTruncateLength(id);
            }
        }
        throw Error.runtimeError(201, "Session");
    }

    public FlobData createFlob(Type type, String filename, String charset, boolean isLinked, boolean isManaged) {
        return this.createFlob(type, filename, charset, isLinked, isManaged, false);
    }

    public FlobData createFlob(Type type, String filename, String charset, boolean isLinked, boolean isManaged, boolean allowInvalidLocation) {
        FlobDataID flob = this.dataspaceStore.flobManager.createFlob(type, filename, charset, isLinked, isManaged, allowInvalidLocation);
        this.sessionData.registerNewFlob(flob.getId());
        return flob;
    }

    @Override
    public String getInternalConnectionURL() {
        return "jdbc:streamscape:dataspace:" + this.dataspaceStore.getURI();
    }

    public boolean isProcessingLog() {
        return this.isProcessingLog;
    }

    public boolean isProcessingRecoveryLog() {
        return this.isProcessingRecoveryLog;
    }

    public void setDataspace(String schema) {
        this.currentDataspace = this.dataspaceStore.schemaManager.getSchemaHsqlName(schema);
    }

    public void setCatalog(String catalog) {
        if (this.dataspaceStore.getCatalogName().name.equals(catalog)) {
            return;
        }
        throw Error.error(4840);
    }

    public NameManager.ObjectName getSchemaHsqlName(String name) {
        return name == null ? this.currentDataspace : this.dataspaceStore.schemaManager.getSchemaHsqlName(name);
    }

    public NameManager.ObjectName getSchemaHsqlName(String name, DataspaceType type) {
        return name == null ? this.currentDataspace : this.dataspaceStore.schemaManager.getSchemaHsqlName(name, type);
    }

    public String getSchemaName(String name) {
        return name == null ? this.currentDataspace.name : this.dataspaceStore.schemaManager.getSchemaName(name);
    }

    public void setCurrentDataspaceName(NameManager.ObjectName name) {
        this.currentDataspace = name;
    }

    public NameManager.ObjectName getCurrentDataspaceName() {
        return this.currentDataspace;
    }

    public int getResultMemoryRowCount() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMemoryRowCount(int count) {
        if (this.dataspaceStore.dataspaceLogger.getTempDirectoryPath() != null) {
            if (count < 0) {
                count = 0;
            }
            this.resultMaxMemoryRows = count;
        }
    }

    @Override
    public void addWarning(DataspaceException warning) {
        int index;
        if (this.sqlWarnings == null) {
            this.sqlWarnings = new HsqlDeque();
        }
        if (this.sqlWarnings.size() > 9) {
            this.sqlWarnings.removeFirst();
        }
        if ((index = this.sqlWarnings.indexOf(warning)) >= 0) {
            this.sqlWarnings.remove(index);
        }
        this.sqlWarnings.add(warning);
    }

    public DataspaceException[] getAndClearWarnings() {
        if (this.sqlWarnings == null) {
            return DataspaceException.emptyArray;
        }
        Object[] array = new DataspaceException[this.sqlWarnings.size()];
        this.sqlWarnings.toArray(array);
        this.sqlWarnings.clear();
        return array;
    }

    public DataspaceException getLastWarning() {
        if (this.sqlWarnings == null || this.sqlWarnings.size() == 0) {
            return null;
        }
        return (DataspaceException)this.sqlWarnings.getLast();
    }

    public void clearWarnings() {
        if (this.sqlWarnings != null) {
            this.sqlWarnings.clear();
        }
    }

    @Override
    public Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar(this.timeZone);
        }
        return this.calendar;
    }

    public Type.TypedComparator getComparator() {
        if (this.typedComparator == null) {
            this.typedComparator = Type.newComparator(this);
        }
        return this.typedComparator;
    }

    public double random(long seed) {
        if (this.seed != seed) {
            this.randomGenerator.setSeed(seed);
            this.seed = seed;
        }
        return this.randomGenerator.nextDouble();
    }

    public double random() {
        return this.randomGenerator.nextDouble();
    }

    @Override
    public Scanner getScanner() {
        if (this.secondaryScanner == null) {
            this.secondaryScanner = new Scanner();
        }
        return this.secondaryScanner;
    }

    @Override
    public BaseStoreProperties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new BaseStoreProperties();
            this.clientProperties.setProperty("jdbc.translate_tti_types", this.dataspaceStore.sqlTranslateTTI);
        }
        return this.clientProperties;
    }

    public SimpleDateFormat getSimpleDateFormatGMT() {
        if (this.simpleDateFormatGMT == null) {
            this.simpleDateFormatGMT = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            this.simpleDateFormatGMT.setCalendar(cal);
        }
        return this.simpleDateFormatGMT;
    }

    public void logSequences() {
        HashMap map = this.sessionData.sequenceUpdateMap;
        if (map == null || map.isEmpty()) {
            return;
        }
        com.streamscape.ds.lib.Iterator it = map.keySet().iterator();
        int size = map.size();
        for (int i = 0; i < size; ++i) {
            NumberSequence sequence = (NumberSequence)it.next();
            this.dataspaceStore.dataspaceLogger.writeSequenceStatement(this, sequence);
        }
        this.sessionData.sequenceUpdateMap.clear();
    }

    String getStartTransactionSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("START").append(' ').append("TRANSACTION");
        if (this.isolationLevel != this.isolationLevelDefault) {
            sb.append(' ');
            Session.appendIsolationSQL(sb, this.isolationLevel);
        }
        return sb.toString();
    }

    String getTransactionIsolationSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ').append("TRANSACTION");
        sb.append(' ');
        Session.appendIsolationSQL(sb, this.isolationLevel);
        return sb.toString();
    }

    static void appendIsolationSQL(StringBuffer sb, int isolationLevel) {
        sb.append("ISOLATION").append(' ');
        sb.append("LEVEL").append(' ');
        sb.append(Session.getIsolationString(isolationLevel));
    }

    public static String getIsolationString(int isolationLevel) {
        switch (isolationLevel) {
            case 1: 
            case 2: {
                StringBuffer sb = new StringBuffer();
                sb.append("READ").append(' ');
                sb.append("COMMITTED");
                return sb.toString();
            }
        }
        return "SERIALIZABLE";
    }

    public void disableReplication(boolean value) {
        this.disableReplication = value;
    }

    public boolean isReplicationDisabled() {
        return this.disableReplication;
    }

    public void setInteractive(boolean value) {
        this.isInteractive = value;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    String getSetDataspaceStatement() {
        return "SET DATASPACE " + this.currentDataspace.statementName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
        if (componentName != null) {
            this.setSLFileSessionContext(SLFileSessionContext.CLIENT);
        }
    }

    public String getSLSessionName() {
        return this.slSessionName;
    }

    public void setSLSessionName(String slSessionName) {
        this.slSessionName = slSessionName;
    }

    public MFSession getMFSession() {
        return this.mfSession;
    }

    public void setMFSession(MFSession mfSession) {
        this.mfSession = mfSession;
    }

    public String getSLResourceName() {
        return this.slResourceName;
    }

    public void setSLResourceName(String slResourceName) {
        this.slResourceName = slResourceName;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        this.statementFetchSize = -1;
    }

    public int getFetchSize() {
        if (this.statementFetchSize >= 0) {
            return this.statementFetchSize;
        }
        return this.fetchSize;
    }

    public void setStatementFetchSize(int statementFetchSize) {
        this.statementFetchSize = statementFetchSize;
    }

    public void resetStatementFetchSize() {
        this.statementFetchSize = -1;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    private void setCurrentThreadIdWithLock(long currentThread) {
        this.currentThreadLock.lock();
        try {
            if (this.currentThread != -1L) {
                this.lastThread = this.currentThread;
            }
            this.currentThread = currentThread;
        }
        finally {
            this.currentThreadLock.unlock();
        }
    }

    public void interruptCurrentProcessing() {
        this.currentThreadLock.lock();
        try {
            if (this.currentThread != -1L) {
                Trace.logError(this, "Interrupting thread processing '" + this.currentThread + "' and current session(" + this.sessionId + ") (by timeout or manually) ...");
                FabricThreadManager.getInstance().interruptThread(this.currentThread);
            }
        }
        finally {
            this.currentThreadLock.unlock();
        }
    }

    public long getCurrentThreadId() {
        return this.currentThread;
    }

    public long getLastThreadId() {
        return this.lastThread;
    }

    public boolean isCompleteMode() {
        return this.isCompleteMode;
    }

    public void setCompleteMode(boolean isCompleteMode) {
        this.isCompleteMode = isCompleteMode;
    }

    public void setSLFileSessionContext(SLFileSessionContext slFileSessionContext) {
        if (slFileSessionContext == SLFileSessionContext.CLIENT && this.componentName == null) {
            throw new DataspaceException("Session context cannot be set to client for this session. Component name not set.");
        }
        this.slFileSessionContext = slFileSessionContext;
        this.statementSlFileSessionContext = null;
    }

    public SLFileSessionContext getSLFileSessionContext() {
        if (this.statementSlFileSessionContext != null) {
            return this.statementSlFileSessionContext;
        }
        return this.slFileSessionContext;
    }

    public void setStatementSLFileSessionContext(SLFileSessionContext slFileSessionContext) {
        if (slFileSessionContext == SLFileSessionContext.CLIENT && this.componentName == null) {
            throw new DataspaceException("Session context cannot be set to client for this session. Component name not set.");
        }
        this.statementSlFileSessionContext = slFileSessionContext;
    }

    public void resetStatementSLFileSessionContext() {
        this.statementSlFileSessionContext = null;
    }

    public boolean isSLFileStreamNeeded() {
        return this.getComponentName() != null && this.getSLFileSessionContext() == SLFileSessionContext.CLIENT;
    }

    public void setTransferBufferSize(int transferBufferSize) {
        this.transferBufferSize = transferBufferSize;
    }

    public int getTransferBufferSize() {
        return this.transferBufferSize;
    }

    public void setSLSessionData(SLSessionData slSessionData) {
        this.slSessionData = slSessionData;
    }

    public SLSessionData getSLSessionData() {
        return this.slSessionData;
    }

    public boolean isTypesCheck() {
        return this.isTypesCheck;
    }

    public void setTypesCheck(boolean isTypesCheck) {
        this.isTypesCheck = isTypesCheck;
    }

    public void setSDSRuntimeSession(boolean sdsRuntimeSession) {
        this.sdsRuntimeSession = sdsRuntimeSession;
    }

    public boolean isSDSRuntimeSession() {
        return this.sdsRuntimeSession;
    }

    public void setParentSessionId(long parentSessionId) {
        this.parentSessionId = parentSessionId;
    }

    public long getParentSessionId() {
        return this.parentSessionId;
    }

    public void setSessionDataspaceRemoved(NameManager.ObjectName sessionDataspaceRemoved) {
        this.sessionDataspaceRemoved = sessionDataspaceRemoved;
    }

    public NameManager.ObjectName getSessionDataspaceRemoved() {
        return this.sessionDataspaceRemoved;
    }

    private void checkIfDataspaceRemovedAndResetSchema() {
        NameManager.ObjectName sessionDataspaceRemovedCopy = this.sessionDataspaceRemoved;
        if (this.currentStatementCounter == 0 && sessionDataspaceRemovedCopy != null && sessionDataspaceRemovedCopy == this.currentDataspace) {
            this.resetSchema();
            this.sessionDataspaceRemoved = null;
        }
    }

    public boolean lockReplicationManual(NameManager.ObjectName replicaObjectName) {
        return ((TransactionManagerMVCC)this.dataspaceStore.txManager).lockReplicationManual(this, replicaObjectName);
    }

    public void unlockReplicationManual(NameManager.ObjectName replicaObjectName) {
        ((TransactionManagerMVCC)this.dataspaceStore.txManager).unlockReplicationManual(this, replicaObjectName);
    }

    public void setAutoCommitVtables(boolean autoCommitVtables) {
        this.autoCommitVtables = autoCommitVtables;
    }

    public boolean isAutoCommitVtables() {
        return this.autoCommitVtables;
    }

    public void commitVtables() throws SQLException {
        this.finishVtables(true);
    }

    public void rollbackVtables() throws SQLException {
        this.finishVtables(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishVtables(boolean commit) throws SQLException {
        Exception exception = null;
        for (Map.Entry<VirtualServerObject, Pair<DatabaseConnection, Boolean>> entry : this.vtableConnections.entrySet()) {
            try {
                if (commit && exception == null) {
                    ((DatabaseConnection)entry.getValue().first).commit();
                    continue;
                }
                ((DatabaseConnection)entry.getValue().first).rollback();
            }
            catch (Exception e) {
                if (exception != null) continue;
                exception = e;
            }
            finally {
                try {
                    ((DatabaseConnection)entry.getValue().first).setAutoCommit((Boolean)entry.getValue().second);
                }
                catch (Exception exception2) {}
                entry.getKey().releaseConnection((DatabaseConnection)entry.getValue().first);
            }
        }
        this.vtableConnections.clear();
        if (exception instanceof SQLException) {
            throw (SQLException)exception;
        }
        if (exception != null) {
            throw new SQLException(exception.getMessage(), exception);
        }
    }

    public DatabaseConnection getVirtualConnectionFor(VirtualServerObject server) {
        Pair<DatabaseConnection, Boolean> pair = this.vtableConnections.get(server);
        if (pair != null) {
            return (DatabaseConnection)pair.first;
        }
        return null;
    }

    public void putVirtualConnection(VirtualServerObject server, Pair<DatabaseConnection, Boolean> pair) {
        this.vtableConnections.put(server, pair);
    }

    public Charset getSessionCCSID() {
        return this.ccsid != null ? this.ccsid : this.dataspaceStore.getCCSID();
    }

    public void setSessionCCSID(String ccsid) {
        this.ccsid = Charset.forName(ccsid);
    }

    public boolean setUseCurrentDataspaceSessionInSysQuery(boolean value) {
        boolean oldValue = this.useCurrentDataspaceSessionInSysQuery;
        this.useCurrentDataspaceSessionInSysQuery = value;
        return oldValue;
    }

    public boolean isUseCurrentDataspaceSessionInSysQuery() {
        return this.useCurrentDataspaceSessionInSysQuery;
    }

    public static void checkIfThreadIsInterrupted() {
        if (Thread.interrupted()) {
            throw new DataspaceException("Statement execution has been interrupted.");
        }
    }

    private static /* synthetic */ String lambda$executeCompiledStatement$6(Object s) {
        return ((Session)s).getId() + ":" + ((Session)s).sessionContext.lastStatementsInTransaction.stream().collect(Collectors.joining(","));
    }

    private static /* synthetic */ String lambda$executeCompiledStatement$5(Object s) {
        return ((Session)s).getId() + ":" + ((Session)s).sessionContext.lastStatementsInTransaction.stream().collect(Collectors.joining(","));
    }

    private static /* synthetic */ String lambda$executeCompiledStatement$4(Object s) {
        return ((Session)s).getId() + ":" + ((Session)s).sessionContext.lastStatement;
    }

    private static /* synthetic */ String lambda$executeCompiledStatement$3(Object s) {
        return ((Session)s).getId() + ":" + ((Session)s).sessionContext.lastStatement;
    }

    private static /* synthetic */ String lambda$executeCompiledStatement$2(Object s) {
        return ((Session)s).getId() + ":" + (((Session)s).sessionContext.currentStatement != null ? ((Session)s).sessionContext.currentStatement.getSQL() : "");
    }

    private static /* synthetic */ String lambda$executeCompiledStatement$1(Object s) {
        return ((Session)s).getId() + ":" + (((Session)s).sessionContext.currentStatement != null ? ((Session)s).sessionContext.currentStatement.getSQL() : "");
    }
}

