/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.timer;

import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TimerObject
implements SchemaObject {
    protected DataspaceStore store = null;
    protected AbstractDataspace dataspace = null;
    protected Session session = null;
    protected NameManager.ObjectName name = null;
    protected String timerGroup = null;
    protected long interval = 0L;
    protected TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    protected int repeatCount = 1;
    protected Map<String, Expression> params = null;
    protected int identity;
    protected String[] columnNames = null;
    protected Statement insertStat = null;

    public TimerObject(DataspaceStore store, NameManager.ObjectName name) {
        this.name = name;
        this.store = store;
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(name.schema.name);
    }

    public int getIdentity() {
        return this.identity;
    }

    public void setIdentity(int identity) {
        this.identity = identity;
    }

    public void destroy() {
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public int getObjectType() {
        return 30;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.store.getCatalogName();
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return new OrderedHashSet();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getTimerGroup() {
        return this.timerGroup;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setRepeatCount(int count) {
        this.repeatCount = count;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setParams(Map<String, Expression> params) {
        this.params = params;
    }

    public Map<String, Expression> getParams() {
        return this.params;
    }

    public void setTimerGroup(String group) {
        this.timerGroup = group;
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        sb.append("TIMER").append(' ');
        sb.append(name).append(' ');
        sb.append("FOR").append(' ');
        sb.append("INTERVAL").append(' ');
        sb.append(this.interval).append(' ');
        switch (this.timeUnit) {
            case SECONDS: {
                sb.append("SEC");
                break;
            }
            case MINUTES: {
                sb.append("MIN");
                break;
            }
            case HOURS: {
                sb.append("HR");
                break;
            }
            default: {
                sb.append("MS");
            }
        }
        sb.append(' ');
        sb.append("REPEAT").append(' ').append(this.repeatCount).append(' ').append("TIMES");
        sb.append(' ').append("GROUP").append(' ').append(this.timerGroup);
        if (this.params != null) {
            boolean first = true;
            sb.append(' ').append("MAP").append("(");
            for (Map.Entry<String, Expression> param : this.params.entrySet()) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append(param.getKey()).append("=").append(param.getValue().getSQL());
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

