/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.timer;

import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.timer.TimerObject;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerState;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TimerMetaData {
    private TimerObject timerObject;
    private FabricTimer timer;

    public TimerMetaData(TimerObject timerObject) {
        this.timerObject = timerObject;
        this.timer = FabricTimerManager.getInstance().getTimer(this.getTimerGroup(), this.getName());
    }

    public String getName() {
        return this.timerObject.getObjectName().name;
    }

    public String getTimerGroup() {
        return this.timerObject.getTimerGroup();
    }

    public FabricTimerState getState() {
        return this.timer != null ? this.timer.getState() : FabricTimerState.EXPIRED;
    }

    public long getInterval() {
        return this.timerObject.getInterval();
    }

    public TimeUnit getTimeUnit() {
        return this.timerObject.getTimeUnit();
    }

    public int getRepeatCount() {
        return this.timer != null ? this.timer.getRepeatCount() : this.timerObject.getRepeatCount();
    }

    public long getDuration() {
        return this.timer != null ? this.timer.getDuration() : 0L;
    }

    public long getRemainingTime() {
        return this.timer != null ? this.timer.getRemainingTime() : 0L;
    }

    public int getRemainingRepeatCount() {
        return this.timer != null ? this.timer.getRemainingRepeatCount() : 0;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, Expression> entry : this.timerObject.getParams().entrySet()) {
            parameters.put(entry.getKey(), entry.getValue().getSQL());
        }
        return parameters;
    }
}

