/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;

public class VirtualTable
extends Table {
    public VirtualTableHelper helper = null;
    private CollectionType collectionType = CollectionType.TABLE;

    public VirtualTable(DataspaceStore database, NameManager.ObjectName name, VirtualTableHelper helper, int storeType) {
        super(database, name, storeType);
        this.helper = helper;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
    }

    public void insertIntoExternal(Session session, Object[] data, int[] jdbcTypes) {
        if (this.isReadOnly) {
            throw new DataspaceException("Virtual query table does not support update operations.");
        }
        this.helper.insertIntoExternal(session, data, jdbcTypes);
    }

    public Result executeExternalUpdate(Session session, String sql, Object[] data, int[] jdbcTypes) {
        if (this.isReadOnly) {
            throw new DataspaceException("Virtual query table does not support update operations.");
        }
        return this.helper.executeExternalUpdate(session, sql, data, jdbcTypes);
    }

    @Override
    public PersistentStore getRowStore(Session session) {
        if (this.getTableType() == 2) {
            return session.sessionData.persistentStoreCollection.getStore(this);
        }
        return super.getRowStore(session);
    }

    public void materialize(Session session) {
        this.helper.materialize(session);
    }

    public boolean hasParameter(String name) {
        return this.helper.hasParameter(name);
    }

    @Override
    public void setDataReadOnly(boolean value) {
        this.isReadOnly = value;
    }

    @Override
    public int findColumn(String name) {
        return super.findColumn(name);
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(CollectionType directoryTable) {
        this.collectionType = directoryTable;
    }

    public static interface VirtualTableHelper {
        public void insertIntoExternal(Session var1, Object[] var2, int[] var3);

        public Result executeExternalUpdate(Session var1, String var2, Object[] var3, int[] var4);

        public void materialize(Session var1);

        public boolean hasParameter(String var1);
    }
}

