/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArraySort;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.lib.utils.Utils;

public class View
extends TableDerived {
    SubQuery viewSubQuery;
    private String statement;
    private NameManager.ObjectName[] columnNames;
    SubQuery[] viewSubqueries;
    private OrderedHashSet schemaObjectNames;
    private int check;
    private Table baseTable;
    Expression checkExpression;
    boolean isTriggerInsertable;
    boolean isTriggerUpdatable;
    boolean isTriggerDeletable;
    private DataspaceStateHolder stateHolder = new DataspaceStateHolder();

    public View(DataspaceStore db, NameManager.ObjectName name, NameManager.ObjectName[] columnNames, int check) {
        super(db, name, 9);
        this.columnNames = columnNames;
        this.check = check;
    }

    @Override
    public int getObjectType() {
        return 5;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.schemaObjectNames;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        OrderedHashSet set;
        ParserDQL p = new ParserDQL(session, new Scanner(this.statement));
        p.read();
        try {
            this.viewSubQuery = p.XreadViewSubquery(this);
        }
        catch (Exception exception) {
            if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
                this.columnNames = null;
                this.viewSubqueries = new SubQuery[0];
                this.schemaObjectNames = new OrderedHashSet();
                Trace.logError(this, "Unable to compile view. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, exception);
                return;
            }
            throw exception;
        }
        this.queryExpression = this.viewSubQuery.queryExpression;
        if (this.getColumnCount() == 0) {
            if (this.columnNames == null) {
                this.columnNames = this.viewSubQuery.queryExpression.getResultColumnNames();
            }
            if (this.columnNames.length != this.viewSubQuery.queryExpression.getColumnCount()) {
                throw Error.error(5593, this.getObjectName().statementName);
            }
            TableUtil.setColumnsInSchemaTable(this, this.columnNames, this.queryExpression.getColumnTypes());
        }
        if ((set = this.queryExpression.getSubqueries()) == null) {
            this.viewSubqueries = new SubQuery[]{this.viewSubQuery};
        } else {
            set.add(this.viewSubQuery);
            this.viewSubqueries = new SubQuery[set.size()];
            set.toArray(this.viewSubqueries);
            ArraySort.sort(this.viewSubqueries, 0, this.viewSubqueries.length, this.viewSubqueries[0]);
        }
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            if (this.viewSubqueries[i].parentView == null) {
                this.viewSubqueries[i].parentView = this;
            }
            this.viewSubqueries[i].prepareTable(session);
        }
        this.viewSubQuery.getTable().view = this;
        this.viewSubQuery.getTable().columnList = this.columnList;
        this.schemaObjectNames = p.compileContext.getSchemaObjectNames();
        this.baseTable = this.queryExpression.getBaseTable();
        if (this.baseTable == null) {
            this.stateHolder = new DataspaceStateHolder();
            return;
        }
        switch (this.check) {
            case 0: {
                break;
            }
            case 1: {
                this.checkExpression = this.queryExpression.getCheckCondition();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        this.stateHolder = new DataspaceStateHolder();
    }

    public DataspaceStateHolder aggregateStateHolder() {
        DataspaceStateHolder state = (DataspaceStateHolder)this.getStateHolder().clone();
        if (this.database != null) {
            DataspaceStateHolder.aggregateState(state, this.getReferences(), this.database.schemaManager);
        } else {
            state.setRecoveryFailedState();
        }
        return state;
    }

    public DataspaceStateHolder getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ').append("VIEW");
        sb.append(' ');
        sb.append(name).append(' ');
        if (this.subQuery != null) {
            sb.append('(');
            int count = this.getColumnCount();
            for (int j = 0; j < count; ++j) {
                sb.append(this.getColumn((int)j).getObjectName().statementName);
                if (j >= count - 1) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        sb.append(' ').append("AS").append(' ');
        sb.append(this.getStatement());
        return sb.toString();
    }

    @Override
    public int[] getUpdatableColumns() {
        return this.queryExpression.getBaseTableColumnMap();
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    @Override
    public boolean isTriggerInsertable() {
        return this.isTriggerInsertable;
    }

    @Override
    public boolean isTriggerUpdatable() {
        return this.isTriggerUpdatable;
    }

    @Override
    public boolean isTriggerDeletable() {
        return this.isTriggerDeletable;
    }

    @Override
    public boolean isInsertable() {
        return this.isTriggerInsertable ? false : super.isInsertable();
    }

    @Override
    public boolean isUpdatable() {
        return this.isTriggerUpdatable ? false : super.isUpdatable();
    }

    @Override
    public void removeTrigger(TriggerDef td) {
        switch (td.operationType) {
            case 50: {
                this.isTriggerInsertable = false;
                break;
            }
            case 19: {
                this.isTriggerDeletable = false;
                break;
            }
            case 82: {
                this.isTriggerUpdatable = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.removeTrigger(td);
    }

    public int getCheckOption() {
        return this.check;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String sql) {
        this.statement = sql;
    }

    @Override
    public void setDataReadOnly(boolean value) {
        throw Error.error(4000);
    }

    public void collectAllFunctionExpressions(OrderedHashSet collector) {
    }

    public Table getSubqueryTable() {
        return this.viewSubQuery.getTable();
    }

    public SubQuery[] getSubqueries() {
        return this.viewSubqueries;
    }

    public void recompileView(Session session) {
        try {
            this.viewSubQuery = null;
            this.queryExpression = null;
            this.columnNames = null;
            this.viewSubqueries = new SubQuery[0];
            this.schemaObjectNames = new OrderedHashSet();
            this.baseTable = null;
            this.checkExpression = null;
            this.columnList.clear();
            this.identityColumn = -1;
            this.identitySequence = null;
            this.columnCount = 0;
            this.constraintList = Constraint.emptyArray;
            this.fkConstraints = Constraint.emptyArray;
            this.fkMainConstraints = Constraint.emptyArray;
            this.checkConstraints = Constraint.emptyArray;
            this.colDefaults = new Expression[this.columnCount];
            this.hasDefaultValues = false;
            this.colGenerated = new boolean[this.columnCount];
            this.hasGeneratedValues = false;
            this.colRefFK = new boolean[this.columnCount];
            this.colMainFK = new boolean[this.columnCount];
            this.hasReferentialAction = false;
            this.hasDomainColumns = false;
            this.hasNotNullColumns = false;
            this.defaultColumnMap = new int[this.columnCount];
            this.defaultRanges = null;
            this.primaryKeyCols = null;
            this.primaryKeyTypes = null;
            this.primaryKeyColsSequence = new int[0];
            this.indexList = new Index[0];
            this.bestRowIdentifierCols = null;
            this.bestRowIdentifierStrict = false;
            this.bestIndexForColumn = new int[0];
            this.bestIndex = null;
            this.fullIndex = null;
            this.colNotNull = new boolean[this.columnCount];
            this.colTypes = null;
            NameManager.ObjectName currentDataspaceName = session.getCurrentDataspaceName();
            try {
                session.setCurrentDataspaceName(this.getObjectName().schema);
                this.compile(session, null);
            }
            finally {
                session.setCurrentDataspaceName(currentDataspaceName);
            }
            session.dataspaceStore.schemaManager.replaceReferences(this, this);
        }
        catch (Exception exception) {
            Trace.logError(this, "Unable to recompile view " + this.getObjectName().getSchemaQualifiedStatementName() + ". " + Utils.formatExceptionWithUnrepeatedCauses(exception));
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, exception);
        }
    }
}

