/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.IndexSnapshot;
import com.streamscape.ds.replication.ReplicationManager;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.types.Type;

public class TableWorks {
    OrderedHashSet emptySet = new OrderedHashSet();
    private DataspaceStore database;
    private Table table;
    private Session session;

    public TableWorks(Session session, Table table) {
        this.database = table.database;
        this.table = table;
        this.session = session;
    }

    public Table getTable() {
        return this.table;
    }

    public void checkCreateForeignKey(Constraint c) {
        ColumnSchema col;
        int i;
        boolean check;
        boolean bl = check = c.core.updateAction == 4 || c.core.updateAction == 2 || c.core.updateAction == 0 || c.core.deleteAction == 4 || c.core.deleteAction == 2;
        if (check) {
            for (i = 0; i < c.core.refCols.length; ++i) {
                col = this.table.getColumn(c.core.refCols[i]);
                if (!col.isGenerated()) continue;
                throw Error.error(5524, col.getNameString());
            }
        }
        if (c.core.mainName == this.table.getObjectName() && ArrayUtil.haveCommonElement(c.core.refCols, c.core.mainCols)) {
            throw Error.error(5527);
        }
        boolean bl2 = check = c.core.updateAction == 4 || c.core.deleteAction == 4;
        if (check) {
            for (i = 0; i < c.core.refCols.length; ++i) {
                col = this.table.getColumn(c.core.refCols[i]);
                Expression defExpr = col.getDefaultExpression();
                if (defExpr != null) continue;
                String columnName = col.getObjectName().statementName;
                throw Error.error(5521, columnName);
            }
        }
        boolean bl3 = check = c.core.updateAction == 2 || c.core.deleteAction == 2;
        if (check && !this.session.isProcessingLog) {
            for (i = 0; i < c.core.refCols.length; ++i) {
                col = this.table.getColumn(c.core.refCols[i]);
                if (col.isNullable()) continue;
                String columnName = col.getObjectName().statementName;
                throw Error.error(5520, columnName);
            }
        }
        this.database.schemaManager.checkSchemaObjectNotExists(c.getObjectName());
        if (this.table.getConstraint(c.getObjectName().name) != null) {
            throw Error.error(5504, c.getObjectName().statementName);
        }
        if (this.table.getFKConstraintForColumns(c.core.mainTable, c.core.mainCols, c.core.refCols) != null) {
            throw Error.error(5528, c.getObjectName().statementName);
        }
        if (c.core.mainTable.isTemp() != this.table.isTemp()) {
            throw Error.error(5524, c.getObjectName().statementName);
        }
        Constraint unique = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
        if (unique == null) {
            throw Error.error(5529, c.getMain().getObjectName().statementName);
        }
        c.core.mainTable.checkColumnsMatch(c.core.mainCols, this.table, c.core.refCols);
        ArrayUtil.reorderMaps(unique.getMainColumns(), c.getMainColumns(), c.getRefColumns());
        boolean[] checkList = c.core.mainTable.getColumnCheckList(c.core.mainCols);
        Grantee grantee = this.session.getGrantee();
        grantee.checkReferences(c.core.mainTable, checkList);
    }

    public void addForeignKey(Constraint c) {
        this.checkModifyTable();
        this.checkCreateForeignKey(c);
        Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
        Index mainIndex = uniqueConstraint.getMainIndex();
        uniqueConstraint.checkReferencedRows(this.session, this.table);
        boolean isForward = false;
        if (c.core.mainTable.getSchemaName() == this.table.getSchemaName()) {
            int offset = this.database.schemaManager.getTableIndex(this.table);
            if (offset != -1 && offset < this.database.schemaManager.getTableIndex(c.core.mainTable)) {
                isForward = true;
            }
        } else {
            isForward = true;
        }
        NameManager.ObjectName indexName = this.database.nameManager.newAutoName("IDX", this.table.getSchemaName(), this.table.getObjectName(), 21);
        Index refIndex = this.table.createIndexStructure(indexName, c.core.refCols, null, null, false, true, isForward, null);
        NameManager.ObjectName mainName = this.database.nameManager.newAutoName("REF", c.getObjectName().name, this.table.getSchemaName(), this.table.getObjectName(), 21);
        c.core.uniqueName = uniqueConstraint.getObjectName();
        c.core.mainName = mainName;
        c.core.mainIndex = mainIndex;
        c.core.refTable = this.table;
        c.core.refName = c.getObjectName();
        c.core.refIndex = refIndex;
        c.isForward = isForward;
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, c, refIndex, -1, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, -1, 0);
        this.database.schemaManager.addSchemaObject(c);
        this.setNewTableInSchema(tn);
        Table mainTable = this.database.schemaManager.getTable(this.session, c.core.mainTable.getObjectName().name, c.core.mainTable.getSchemaName().name);
        mainTable.addConstraint(new Constraint(mainName, c));
        this.updateConstraints(tn, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(tn);
        this.table = tn;
        this.onTableChange(tn);
    }

    void checkAddColumn(ColumnSchema col) {
        this.checkModifyTable();
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Error.error(320);
        }
        if (this.table.findColumn(col.getObjectName().name) != -1) {
            throw Error.error(5504);
        }
        if (col.isPrimaryKey() && this.table.hasPrimaryKey()) {
            throw Error.error(5530);
        }
        if (col.isIdentity() && this.table.hasIdentityColumn()) {
            throw Error.error(5525);
        }
        if (!(this.table.isEmpty(this.session) || col.hasDefault() || col.isNullable() && !col.isPrimaryKey() || col.isIdentity())) {
            throw Error.error(5531);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(ColumnSchema column, int colIndex, HsqlArrayList constraints) {
        Index index = null;
        Constraint mainConstraint = null;
        boolean addFK = false;
        boolean addUnique = false;
        boolean addCheck = false;
        this.checkAddColumn(column);
        Constraint c = (Constraint)constraints.get(0);
        if (c.getConstraintType() == 4) {
            if (column.getDataType().isLobType()) {
                throw Error.error(5534);
            }
            c.core.mainCols = new int[]{colIndex};
            this.database.schemaManager.checkSchemaObjectNotExists(c.getObjectName());
            if (this.table.hasPrimaryKey()) {
                throw Error.error(5530);
            }
            addUnique = true;
        } else {
            c = null;
        }
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, column, c, null, colIndex, 1, this.emptySet, this.emptySet);
        block10: for (int i = 1; i < constraints.size(); ++i) {
            c = (Constraint)constraints.get(i);
            switch (c.constType) {
                case 2: {
                    if (addUnique) {
                        throw Error.error(5522);
                    }
                    if (column.getDataType().isLobType()) {
                        throw Error.error(5534);
                    }
                    addUnique = true;
                    c.core.mainCols = new int[]{colIndex};
                    this.database.schemaManager.checkSchemaObjectNotExists(c.getObjectName());
                    NameManager.ObjectName indexName = this.database.nameManager.newAutoName("IDX", c.getObjectName().name, this.table.getSchemaName(), this.table.getObjectName(), 21);
                    index = tn.createAndAddIndexStructure(indexName, c.getMainColumns(), null, null, true, true, false, null);
                    c.core.mainTable = tn;
                    c.core.mainIndex = index;
                    tn.addConstraint(c);
                    continue block10;
                }
                case 0: {
                    boolean isSelf;
                    if (addFK) {
                        throw Error.error(5528);
                    }
                    addFK = true;
                    c.core.refCols = new int[]{colIndex};
                    c.core.mainTable = this.database.schemaManager.getUserTable(this.session, c.getMainTableName());
                    c.core.refTable = tn;
                    c.core.refName = c.getObjectName();
                    boolean bl = isSelf = this.table == c.core.mainTable;
                    if (isSelf) {
                        c.core.mainTable = tn;
                    }
                    c.setColumnsIndexes(tn);
                    this.checkCreateForeignKey(c);
                    Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
                    boolean isForward = c.core.mainTable.getSchemaName() != this.table.getSchemaName();
                    int offset = this.database.schemaManager.getTableIndex(this.table);
                    if (!isSelf && offset < this.database.schemaManager.getTableIndex(c.core.mainTable)) {
                        isForward = true;
                    }
                    NameManager.ObjectName indexName = this.database.nameManager.newAutoName("IDX", c.getObjectName().name, this.table.getSchemaName(), this.table.getObjectName(), 21);
                    index = tn.createAndAddIndexStructure(indexName, c.getRefColumns(), null, null, false, true, isForward, null);
                    c.core.uniqueName = uniqueConstraint.getObjectName();
                    c.core.mainName = this.database.nameManager.newAutoName("REF", c.core.refName.name, this.table.getSchemaName(), this.table.getObjectName(), 21);
                    c.core.mainIndex = uniqueConstraint.getMainIndex();
                    c.core.refIndex = index;
                    c.isForward = isForward;
                    tn.addConstraint(c);
                    mainConstraint = new Constraint(c.core.mainName, c);
                    continue block10;
                }
                case 3: {
                    if (addCheck) {
                        throw Error.error(5528);
                    }
                    addCheck = true;
                    c.prepareCheckConstraint(this.session, tn, false);
                    tn.addConstraint(c);
                    if (!c.isNotNull()) continue block10;
                    column.setNullable(false);
                    tn.setColumnTypeVars(colIndex);
                    if (this.table.isEmpty(this.session) || column.hasDefault()) continue block10;
                    throw Error.error(5531);
                }
            }
        }
        column.compile(this.session, tn);
        this.moveData(this.table, tn, colIndex, 1);
        if (mainConstraint != null) {
            mainConstraint.getMain().addConstraint(mainConstraint);
        }
        this.registerConstraintNames(constraints);
        this.setNewTableInSchema(tn);
        this.updateConstraints(tn, this.emptySet);
        this.database.schemaManager.addSchemaObject(column);
        try {
            this.database.schemaManager.recompileDependentObjects(tn);
        }
        catch (Exception exception) {
            Trace.logError(this, "Recompilation of dependent objects failed.");
            Trace.logException(this, exception, true);
        }
        finally {
            tn.compile(this.session, null);
            this.table = tn;
            this.onTableChange(tn);
        }
    }

    public void updateConstraints(OrderedHashSet tableSet, OrderedHashSet dropConstraints) {
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            this.updateConstraints(t, dropConstraints);
        }
    }

    void updateConstraints(Table t, OrderedHashSet dropConstraints) {
        for (int i = t.constraintList.length - 1; i >= 0; --i) {
            Table mainT;
            Constraint c = t.constraintList[i];
            if (dropConstraints.contains(c.getObjectName())) {
                t.removeConstraint(i);
                continue;
            }
            if (c.getConstraintType() == 0) {
                Table refT;
                c.core.refTable = refT = this.database.schemaManager.getUserTable(this.session, c.core.refTable.getObjectName());
                Table mainT2 = this.database.schemaManager.getUserTable(this.session, c.core.mainTable.getObjectName());
                Constraint mainC = mainT2.getConstraint(c.getMainName().name);
                mainC.core = c.core;
                continue;
            }
            if (c.getConstraintType() != 1) continue;
            c.core.mainTable = mainT = this.database.schemaManager.getUserTable(this.session, c.core.mainTable.getObjectName());
            Table refT = this.database.schemaManager.getUserTable(this.session, c.core.refTable.getObjectName());
            Constraint refC = refT.getConstraint(c.getRefName().name);
            refC.core = c.core;
        }
    }

    public OrderedHashSet makeNewTables(OrderedHashSet tableSet, OrderedHashSet dropConstraintSet, OrderedHashSet dropIndexSet) {
        OrderedHashSet newSet = new OrderedHashSet();
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            TableWorks tw = new TableWorks(this.session, t);
            tw.makeNewTable(dropConstraintSet, dropIndexSet);
            newSet.add(tw.getTable());
        }
        return newSet;
    }

    void makeNewTable(OrderedHashSet dropConstraintSet, OrderedHashSet dropIndexSet) {
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, dropConstraintSet, dropIndexSet);
        if (tn.indexList.length == this.table.indexList.length) {
            this.database.persistentStoreCollection.releaseStore(tn);
            return;
        }
        this.moveData(this.table, tn, -1, 0);
        this.table = tn;
        this.onTableChange(tn);
    }

    public void alterIndex(Index index, int[] cols) {
        Index newIndex = this.database.dataspaceLogger.newIndex(this.table, index, cols, index instanceof IndexSnapshot ? ((IndexSnapshot)index).getSIndexType() : null);
        int position = index.getPosition();
        PersistentStore store = this.database.persistentStoreCollection.getStore(this.table);
        Index[] indexes = store.getAccessorKeys();
        newIndex.setPosition(position);
        this.table.getIndexList()[position] = newIndex;
        this.table.setBestRowIdentifiers();
        indexes[position] = newIndex;
        store.reindex(this.session, newIndex);
    }

    public Index addIndex(int[] col, NameManager.ObjectName name, boolean unique, SIndexType sIndexType) {
        Index newindex;
        this.checkModifyTable();
        if (this.table.isEmpty(this.session) || this.table.isIndexingMutable() || this.table.isSnapshot()) {
            newindex = this.table.createIndex(this.session, name, col, null, null, unique, false, false, sIndexType);
        } else {
            newindex = this.table.createIndexStructure(name, col, null, null, unique, false, false, sIndexType);
            Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, newindex, -1, 0, this.emptySet, this.emptySet);
            this.moveData(this.table, tn, -1, 0);
            this.table = tn;
            this.onTableChange(tn);
            this.setNewTableInSchema(this.table);
            this.updateConstraints(this.table, this.emptySet);
        }
        this.database.schemaManager.addSchemaObject(newindex);
        this.database.schemaManager.recompileDependentObjects(this.table);
        SchemaObject queue = this.database.schemaManager.findSchemaObject(this.table.getObjectName().name, this.table.getObjectName().schema.name, 4);
        if (queue instanceof AbstractCollection) {
            ((AbstractCollection)queue).compileInternalStatements(this.session);
        }
        return newindex;
    }

    public Table addPrimaryKey(Constraint constraint) {
        this.checkModifyTable();
        if (this.table.hasPrimaryKey()) {
            throw Error.error(5532);
        }
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getObjectName());
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, null, -1, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, -1, 0);
        this.table = tn;
        this.onTableChange(tn);
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
        return tn;
    }

    void addUniqueConstraint(int[] cols, NameManager.ObjectName name) {
        this.checkModifyTable();
        this.database.schemaManager.checkSchemaObjectNotExists(name);
        if (this.table.getUniqueConstraintForColumns(cols) != null) {
            throw Error.error(5522);
        }
        NameManager.ObjectName indexname = this.database.nameManager.newAutoName("IDX", name.name, this.table.getSchemaName(), this.table.getObjectName(), 21);
        Index index = this.table.createIndexStructure(indexname, cols, null, null, true, true, false, null);
        Constraint constraint = new Constraint(name, this.table, index, 2);
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, index, -1, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, -1, 0);
        this.table = tn;
        this.onTableChange(tn);
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    public void addUniqueConstraint(Constraint constraint) {
        this.checkModifyTable();
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getObjectName());
        if (this.table.getUniqueConstraintForColumns(constraint.getMainColumns()) != null) {
            throw Error.error(5522);
        }
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, constraint.getMainIndex(), -1, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, -1, 0);
        this.table = tn;
        this.onTableChange(tn);
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    public void addCheckConstraint(Constraint c) {
        this.checkModifyTable();
        this.database.schemaManager.checkSchemaObjectNotExists(c.getObjectName());
        c.prepareCheckConstraint(this.session, this.table, true);
        this.table.addConstraint(c);
        if (c.isNotNull()) {
            ColumnSchema column = this.table.getColumn(c.notNullColumnIndex);
            column.setNullable(false);
            this.table.setColumnTypeVars(c.notNullColumnIndex);
        }
        this.database.schemaManager.addSchemaObject(c);
    }

    public void dropIndex(String indexName) {
        this.checkModifyTable();
        Index index = this.table.getIndex(indexName);
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(index.getPosition());
        } else {
            OrderedHashSet indexSet = new OrderedHashSet();
            indexSet.add(this.table.getIndex(indexName).getObjectName());
            Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, this.emptySet, indexSet);
            this.moveData(this.table, tn, -1, 0);
            this.setNewTableInSchema(tn);
            this.updateConstraints(tn, this.emptySet);
            this.table = tn;
            this.onTableChange(tn);
        }
        if (!index.isConstraint()) {
            this.database.schemaManager.removeSchemaObject(index.getObjectName());
        }
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    public void dropColumn(int colIndex, boolean cascade) {
        OrderedHashSet constraintNameSet = new OrderedHashSet();
        OrderedHashSet dependentConstraints = this.table.getDependentConstraints(colIndex);
        OrderedHashSet cascadingConstraints = this.table.getContainingConstraints(colIndex);
        OrderedHashSet indexNameSet = this.table.getContainingIndexNames(colIndex);
        ColumnSchema column = this.table.getColumn(colIndex);
        NameManager.ObjectName columnName = column.getObjectName();
        OrderedHashSet referencingObjects = this.database.schemaManager.getReferencesTo(this.table.getObjectName(), columnName);
        this.checkModifyTable();
        if (!cascade) {
            if (!cascadingConstraints.isEmpty()) {
                Constraint c = (Constraint)cascadingConstraints.get(0);
                NameManager.ObjectName name = c.getObjectName();
                throw Error.error(5536, name.getSchemaQualifiedStatementName());
            }
            if (!referencingObjects.isEmpty()) {
                block0: for (int i = 0; i < referencingObjects.size(); ++i) {
                    NameManager.ObjectName name = (NameManager.ObjectName)referencingObjects.get(i);
                    if (name == columnName) continue;
                    for (int j = 0; j < dependentConstraints.size(); ++j) {
                        Constraint c = (Constraint)dependentConstraints.get(j);
                        if (c.getObjectName() == name) continue block0;
                    }
                    throw Error.error(5536, name.getSchemaQualifiedStatementName());
                }
            }
        }
        dependentConstraints.addAll(cascadingConstraints);
        cascadingConstraints.clear();
        OrderedHashSet tableSet = new OrderedHashSet();
        for (int i = 0; i < dependentConstraints.size(); ++i) {
            Constraint c = (Constraint)dependentConstraints.get(i);
            if (c.constType == 0) {
                tableSet.add(c.getMain());
                constraintNameSet.add(c.getMainName());
                constraintNameSet.add(c.getRefName());
                indexNameSet.add(c.getRefIndex().getObjectName());
            }
            if (c.constType == 1) {
                tableSet.add(c.getRef());
                constraintNameSet.add(c.getMainName());
                constraintNameSet.add(c.getRefName());
                indexNameSet.add(c.getRefIndex().getObjectName());
            }
            constraintNameSet.add(c.getObjectName());
        }
        tableSet = this.makeNewTables(tableSet, constraintNameSet, indexNameSet);
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, colIndex, -1, constraintNameSet, indexNameSet);
        this.moveData(this.table, tn, colIndex, -1);
        this.database.schemaManager.removeSchemaObjects(referencingObjects);
        this.database.schemaManager.removeSchemaObjects(constraintNameSet);
        this.database.schemaManager.removeSchemaObject(columnName);
        this.setNewTableInSchema(tn);
        this.setNewTablesInSchema(tableSet);
        this.updateConstraints(tn, this.emptySet);
        this.updateConstraints(tableSet, constraintNameSet);
        this.database.schemaManager.recompileDependentObjects(tableSet);
        this.database.schemaManager.recompileDependentObjects(tn);
        tn.compile(this.session, null);
        this.table = tn;
        this.onTableChange(tn);
    }

    void registerConstraintNames(HsqlArrayList constraints) {
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint c = (Constraint)constraints.get(i);
            switch (c.constType) {
                case 2: 
                case 3: 
                case 4: {
                    this.database.schemaManager.addSchemaObject(c);
                }
            }
        }
    }

    public void dropConstraint(String name, boolean cascade) {
        Constraint constraint = this.table.getConstraint(name);
        if (constraint == null) {
            throw Error.error(5501, name);
        }
        switch (constraint.getConstraintType()) {
            case 1: {
                throw Error.error(4002);
            }
            case 2: 
            case 4: {
                this.checkModifyTable();
                OrderedHashSet dependentConstraints = this.table.getDependentConstraints(constraint);
                if (!cascade && !dependentConstraints.isEmpty()) {
                    Constraint c = (Constraint)dependentConstraints.get(0);
                    throw Error.error(5533, c.getObjectName().getSchemaQualifiedStatementName());
                }
                OrderedHashSet tableSet = new OrderedHashSet();
                OrderedHashSet constraintNameSet = new OrderedHashSet();
                OrderedHashSet indexNameSet = new OrderedHashSet();
                for (int i = 0; i < dependentConstraints.size(); ++i) {
                    Constraint c = (Constraint)dependentConstraints.get(i);
                    Table t = c.getMain();
                    if (t != this.table) {
                        tableSet.add(t);
                    }
                    if ((t = c.getRef()) != this.table) {
                        tableSet.add(t);
                    }
                    constraintNameSet.add(c.getMainName());
                    constraintNameSet.add(c.getRefName());
                    indexNameSet.add(c.getRefIndex().getObjectName());
                }
                constraintNameSet.add(constraint.getObjectName());
                if (constraint.getConstraintType() == 2) {
                    indexNameSet.add(constraint.getMainIndex().getObjectName());
                }
                Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, constraintNameSet, indexNameSet);
                this.moveData(this.table, tn, -1, 0);
                tableSet = this.makeNewTables(tableSet, constraintNameSet, indexNameSet);
                if (constraint.getConstraintType() == 4) {
                    int[] cols = constraint.getMainColumns();
                    for (int i = 0; i < cols.length; ++i) {
                        tn.getColumn(cols[i]).setPrimaryKey(false);
                        tn.setColumnTypeVars(cols[i]);
                    }
                }
                this.database.schemaManager.removeSchemaObjects(constraintNameSet);
                this.setNewTableInSchema(tn);
                this.setNewTablesInSchema(tableSet);
                this.updateConstraints(tn, this.emptySet);
                this.updateConstraints(tableSet, constraintNameSet);
                this.database.schemaManager.recompileDependentObjects(tableSet);
                this.database.schemaManager.recompileDependentObjects(tn);
                this.table = tn;
                this.onTableChange(tn);
                break;
            }
            case 0: {
                this.checkModifyTable();
                OrderedHashSet constraints = new OrderedHashSet();
                Table mainTable = constraint.getMain();
                NameManager.ObjectName mainName = constraint.getMainName();
                constraints.add(mainName);
                constraints.add(constraint.getRefName());
                OrderedHashSet indexes = new OrderedHashSet();
                indexes.add(constraint.getRefIndex().getObjectName());
                Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, constraints, indexes);
                this.moveData(this.table, tn, -1, 0);
                this.database.schemaManager.removeSchemaObject(constraint.getObjectName());
                this.setNewTableInSchema(tn);
                mainTable.removeConstraint(mainName.name);
                this.updateConstraints(tn, this.emptySet);
                this.database.schemaManager.recompileDependentObjects(this.table);
                this.table = tn;
                break;
            }
            case 3: {
                this.database.schemaManager.removeSchemaObject(constraint.getObjectName());
                if (!constraint.isNotNull()) break;
                ColumnSchema column = this.table.getColumn(constraint.notNullColumnIndex);
                column.setNullable(false);
                this.table.setColumnTypeVars(constraint.notNullColumnIndex);
            }
        }
    }

    public void retypeColumn(ColumnSchema oldCol, ColumnSchema newCol) {
        Type oldType = oldCol.getDataType();
        Type newType = newCol.getDataType();
        this.checkModifyTable();
        if (oldType.equals(newType) && oldCol.getIdentitySequence() == newCol.getIdentitySequence()) {
            return;
        }
        if (!this.table.isEmpty(this.session) && oldType.typeCode == 1119 && newType.typeCode == 1119) {
            throw new DataspaceException("File references exist. Altering FLOB Location will invalidate reference paths.");
        }
        if (!this.table.isEmpty(this.session) && oldType.typeCode != newType.typeCode) {
            boolean allowed = newCol.getDataType().canConvertFrom(oldCol.getDataType());
            switch (oldType.typeCode) {
                case 1111: 
                case 1119: 
                case 1122: 
                case 1123: 
                case 2000: {
                    allowed = false;
                }
            }
            if (!allowed) {
                throw Error.error(5561);
            }
        }
        int colIndex = this.table.getColumnIndex(oldCol.getObjectName().name);
        int checkData = newType.canMoveFrom(oldType);
        if (checkData == 0 && newCol.isIdentity() && !oldCol.isIdentity() && oldCol.isNullable() && !oldCol.isPrimaryKey()) {
            checkData = 1;
        }
        if (checkData == 1) {
            this.checkConvertColDataType(oldCol, newCol);
            checkData = 0;
        }
        if (checkData == 0) {
            oldCol.setType(newCol);
            oldCol.setDefaultExpression(newCol.getDefaultExpression());
            oldCol.setIdentity(newCol.getIdentitySequence());
            this.table.setColumnTypeVars(colIndex);
            this.table.resetDefaultsFlag();
            return;
        }
        this.database.schemaManager.checkColumnIsReferenced(this.table.getObjectName(), this.table.getColumn(colIndex).getObjectName());
        this.table.checkColumnInCheckConstraint(colIndex);
        this.table.checkColumnInFKConstraint(colIndex);
        this.checkConvertColDataType(oldCol, newCol);
        this.retypeColumn(newCol, colIndex);
    }

    void checkConvertColDataType(ColumnSchema oldCol, ColumnSchema newCol) {
        int colIndex = this.table.getColumnIndex(oldCol.getObjectName().name);
        RowIterator it = this.table.rowIterator(this.session);
        while (it.hasNext()) {
            Row row = it.getNextRow();
            Object o = row.getData()[colIndex];
            if (!newCol.isNullable() && o == null) {
                throw Error.error(10);
            }
            newCol.getDataType().convertToType(this.session, o, oldCol.getDataType());
        }
    }

    private void retypeColumn(ColumnSchema column, int colIndex) {
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, column, null, null, colIndex, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, tn, colIndex, 0);
        this.setNewTableInSchema(tn);
        this.updateConstraints(tn, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
        this.table = tn;
        this.onTableChange(tn);
    }

    public void setColNullability(ColumnSchema column, boolean nullable) {
        Constraint c = null;
        int colIndex = this.table.getColumnIndex(column.getObjectName().name);
        if (column.isNullable() == nullable) {
            return;
        }
        if (nullable) {
            if (column.isPrimaryKey()) {
                throw Error.error(5526);
            }
            this.table.checkColumnInFKConstraint(colIndex, 2);
            this.removeColumnNotNullConstraints(colIndex);
        } else {
            NameManager.ObjectName constName = this.database.nameManager.newAutoName("CT", this.table.getSchemaName(), this.table.getObjectName(), 6);
            c = new Constraint(constName, null, 3);
            c.check = new ExpressionLogical(column);
            c.prepareCheckConstraint(this.session, this.table, true);
            column.setNullable(false);
            this.table.addConstraint(c);
            this.table.setColumnTypeVars(colIndex);
            this.database.schemaManager.addSchemaObject(c);
        }
    }

    public void setColDefaultExpression(int colIndex, Expression def) {
        if (def == null) {
            this.table.checkColumnInFKConstraint(colIndex, 4);
        }
        ColumnSchema column = this.table.getColumn(colIndex);
        column.setDefaultExpression(def);
        this.table.setColumnTypeVars(colIndex);
    }

    public boolean setTableType(Session session, int newType) {
        Table tn;
        int currentType = this.table.getTableType();
        if (currentType == newType) {
            return false;
        }
        switch (newType) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        try {
            tn = this.table.moveDefinition(session, newType, null, null, null, -1, 0, this.emptySet, this.emptySet);
            this.moveData(this.table, tn, -1, 0);
        }
        catch (DataspaceException e) {
            return false;
        }
        this.setNewTableInSchema(tn);
        this.updateConstraints(tn, this.emptySet);
        this.table = tn;
        this.onTableChange(tn);
        SchemaObject collection = this.database.schemaManager.getSchemaObject(this.table.getObjectName().name, this.table.getObjectName().schema.name, 4);
        if (collection != null) {
            ((Collection)collection).resetBaseTable(this.table);
            collection.compile(session, null);
        }
        this.database.schemaManager.recompileDependentObjects(this.table);
        return true;
    }

    public void setNewTablesInSchema(OrderedHashSet tableSet) {
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            this.setNewTableInSchema(t);
        }
    }

    void setNewTableInSchema(Table newTable) {
        int i = this.database.schemaManager.getTableIndex(newTable);
        if (i != -1) {
            this.database.schemaManager.setTable(i, newTable);
        }
    }

    void removeColumnNotNullConstraints(int colIndex) {
        for (int i = this.table.constraintList.length - 1; i >= 0; --i) {
            Constraint c = this.table.constraintList[i];
            if (!c.isNotNull() || c.notNullColumnIndex != colIndex) continue;
            this.database.schemaManager.removeSchemaObject(c.getObjectName());
        }
        ColumnSchema column = this.table.getColumn(colIndex);
        column.setNullable(true);
        this.table.setColumnTypeVars(colIndex);
    }

    private void checkModifyTable() {
        if (this.session.getUser().isSystem()) {
            return;
        }
        if (this.session.isProcessingLog) {
            return;
        }
        if (this.database.isFilesReadOnly() || this.table.isReadOnly()) {
            throw Error.error(456);
        }
        if (this.table.isText() && this.table.isConnected()) {
            throw Error.error(320);
        }
    }

    void moveData(Table oldTable, Table newTable, int colIndex, int adjust) {
        int tableType = oldTable.getTableType();
        if (tableType == 3) {
            Session[] sessions = this.database.collectionSessionManager.getAllSessions();
            for (int i = 0; i < sessions.length; ++i) {
                sessions[i].sessionData.persistentStoreCollection.moveData(oldTable, newTable, colIndex, adjust);
            }
        } else {
            PersistentStore oldStore = this.database.persistentStoreCollection.getStore(oldTable);
            PersistentStore newStore = this.database.persistentStoreCollection.getStore(newTable);
            try {
                newStore.moveData(this.session, oldStore, colIndex, adjust);
            }
            catch (DataspaceException e) {
                newStore.release();
                this.database.persistentStoreCollection.setStore(newTable, null);
                throw e;
            }
            this.database.persistentStoreCollection.releaseStore(oldTable);
        }
    }

    private void onTableChange(Table tn) {
        AbstractCollection collection = (AbstractCollection)this.session.dataspaceStore.schemaManager.findSchemaObject(tn.getObjectName().name, tn.getObjectName().schema.name, 4);
        if (collection != null) {
            collection.updateBaseTable(tn);
        }
        if (collection != null && collection.isTriggerEventAutogenerated()) {
            for (TriggerDef trigger : tn.triggerList) {
                trigger.validateActionableEventPrototype();
            }
        }
        tn.tableSchemaChangeTimestamp = System.currentTimeMillis();
        if (!this.session.isProcessingLog() && !this.session.isProcessingRecoveryLog()) {
            ReplicationSource replicationSource = tn.getReplicationSource();
            if (replicationSource != null) {
                replicationSource.enqueueMonitorAction(new ReplicationManager.SendSourceUpdatedForPairedReplicasAction(replicationSource));
            }
            Iterator iterator = this.session.dataspaceStore.schemaManager.dataspaceObjectIterator(tn.getObjectName().schema.name, 29);
            while (iterator.hasNext()) {
                ReplicationTarget replica = (ReplicationTarget)iterator.next();
                if (!tn.getObjectName().name.equals(replica.getTargetCollectionName())) continue;
                replica.enqueueReattachAction();
            }
        }
        if (collection instanceof TableCollection) {
            ((TableCollection)collection).compileColumnNames();
            ((TableCollection)collection).compileInternalStatements(this.session);
        }
    }
}

