/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.JournalFileQueueTable;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.types.Type;

public class TableUtil {
    public static Table newSingleColumnTable(DataspaceStore database, NameManager.ObjectName tableName, int tableType, NameManager.ObjectName colName, Type colType) {
        TableDerived table = new TableDerived(database, tableName, tableType);
        ColumnSchema column = new ColumnSchema(colName, colType, false, true, null);
        table.addColumn(column);
        table.createPrimaryKeyConstraint(table.getObjectName(), new int[]{0}, true);
        return table;
    }

    public static Table newTable(DataspaceStore database, int type, NameManager.ObjectName tableHsqlName) {
        switch (type) {
            case 7: 
            case 8: {
                return new FileTable(database, tableHsqlName, type);
            }
            case 15: {
                return new JournalFileQueueTable(database, tableHsqlName, null);
            }
            case 16: {
                return new SnapshotDataspaceTable(database, tableHsqlName, null);
            }
        }
        return new Table(database, tableHsqlName, type);
    }

    public static Table newVirtualTable(DataspaceStore database, NameManager.ObjectName tableHsqlName, VirtualTable.VirtualTableHelper helper, int dataCacheModel) {
        return new VirtualTable(database, tableHsqlName, helper, dataCacheModel);
    }

    public static void setTableIndexesForSubquery(Table table, boolean fullIndex, boolean uniqueRows) {
        int[] cols = null;
        if (fullIndex) {
            cols = new int[table.getColumnCount()];
            ArrayUtil.fillSequence(cols);
        }
        table.createPrimaryKey(null, (int[])(uniqueRows ? cols : null), false);
        if (uniqueRows) {
            table.fullIndex = table.getPrimaryIndex();
        } else if (fullIndex) {
            table.fullIndex = table.createIndexForColumns(null, cols);
        }
    }

    public static void addAutoColumns(Table table, Type[] colTypes) {
        for (int i = 0; i < colTypes.length; ++i) {
            ColumnSchema column = new ColumnSchema(NameManager.getAutoColumnName(i), colTypes[i], true, false, null);
            table.addColumnNoCheck(column);
        }
    }

    public static void setColumnsInSchemaTable(Table table, NameManager.ObjectName[] columnNames, Type[] columnTypes) {
        for (int i = 0; i < columnNames.length; ++i) {
            NameManager.ObjectName columnName = columnNames[i];
            columnName = table.database.nameManager.newColumnSchemaHsqlName(table.getObjectName(), columnName);
            ColumnSchema column = new ColumnSchema(columnName, columnTypes[i], true, false, null);
            table.addColumn(column);
        }
        table.setColumnStructures();
    }

    public static void addColumn(Table t, String name, Type type) {
        TableUtil.addColumn(t, name, type, true);
    }

    public static void addColumn(Table t, String name, Type type, boolean nullable) {
        NameManager.ObjectName cn = NameManager.newInfoSchemaColumnName(name, t.getObjectName());
        ColumnSchema c = new ColumnSchema(cn, type, nullable, false, null);
        t.addColumn(c);
    }

    public static void addIdentityColumn(Table t, String name, Type type) {
        NameManager.ObjectName cn = NameManager.newInfoSchemaColumnName(name, t.getObjectName());
        ColumnSchema c = new ColumnSchema(cn, type, true, false, null);
        NumberSequence sequence = new NumberSequence(null, 0L, 1L, type);
        c.setIdentity(sequence);
        t.addColumn(c);
    }
}

