/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.types.Type;

public class TableBase {
    public static final int INFO_SCHEMA_TABLE = 1;
    public static final int SYSTEM_SUBQUERY = 2;
    public static final int TRANSIENT_TABLE = 3;
    public static final int MEMORY_TABLE = 4;
    public static final int LOGGED_TABLE = 5;
    public static final int PERSISTENT_TABLE = 6;
    public static final int TEMP_TEXT_TABLE = 7;
    public static final int TEXT_TABLE = 8;
    public static final int VIEW_TABLE = 9;
    public static final int RESULT_TABLE = 10;
    public static final int TRANSITION_TABLE = 11;
    public static final int FUNCTION_TABLE = 12;
    public static final int SYSTEM_TABLE = 13;
    public static final int CHANGE_SET_TABLE = 14;
    public static final int JOURNAL_FILE_QUEUE = 15;
    public static final int SNAPSHOT = 16;
    public static final int SEMAGRAPH = 17;
    public static final int SCOPE_STATEMENT = 21;
    public static final int SCOPE_TRANSACTION = 22;
    public static final int SCOPE_SESSION = 23;
    public static final int SCOPE_FULL = 24;
    public PersistentStore store;
    public int persistenceScope;
    public long persistenceId;
    int[] primaryKeyCols;
    Type[] primaryKeyTypes;
    int[] primaryKeyColsSequence;
    Index[] indexList;
    public DataspaceStore database;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    public Index fullIndex;
    boolean[] colNotNull;
    public Type[] colTypes;
    public int columnCount;
    int tableType;
    protected boolean isReadOnly;
    public boolean isTemp;
    protected boolean isCached;
    protected boolean isMemory;
    protected boolean isText;
    public boolean isView;
    public boolean isSessionBased;
    protected boolean isSchemaBased;
    protected boolean isLogged;
    private boolean isTransactional = true;
    private boolean hasLobColumn;
    private boolean isDropped = false;

    TableBase() {
    }

    public TableBase(Session session, DataspaceStore database, int scope, int type, Type[] colTypes) {
        this.tableType = type;
        this.persistenceScope = scope;
        this.isSessionBased = true;
        this.persistenceId = database.persistentStoreCollection.getNextId();
        this.database = database;
        this.colTypes = colTypes;
        this.columnCount = colTypes.length;
        this.primaryKeyCols = new int[0];
        this.primaryKeyTypes = new Type[0];
        this.indexList = new Index[0];
        this.createPrimaryIndex(this.primaryKeyCols, this.primaryKeyTypes, null);
    }

    public TableBase duplicate() {
        TableBase copy = new TableBase();
        copy.tableType = this.tableType;
        copy.persistenceScope = this.persistenceScope;
        copy.isSessionBased = this.isSessionBased;
        copy.persistenceId = this.database.persistentStoreCollection.getNextId();
        copy.database = this.database;
        copy.colTypes = this.colTypes;
        copy.columnCount = this.colTypes.length;
        copy.primaryKeyCols = this.primaryKeyCols;
        copy.primaryKeyTypes = this.primaryKeyTypes;
        copy.indexList = this.indexList;
        return copy;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public long getPersistenceId() {
        return this.persistenceId;
    }

    public int getId() {
        return 0;
    }

    public final boolean onCommitPreserve() {
        return this.persistenceScope == 23;
    }

    public final RowIterator rowIterator(Session session) {
        PersistentStore store = this.getRowStore(session);
        return this.getPrimaryIndex().firstRow(session, store);
    }

    public final RowIterator rowIterator(PersistentStore store) {
        return this.getPrimaryIndex().firstRow(store);
    }

    public final int getIndexCount() {
        return this.indexList.length;
    }

    public final Index getPrimaryIndex() {
        return this.indexList.length > 0 ? this.indexList[0] : null;
    }

    public final Type[] getPrimaryKeyTypes() {
        return this.primaryKeyTypes;
    }

    public final boolean hasPrimaryKey() {
        return this.primaryKeyCols != null && this.primaryKeyCols.length != 0;
    }

    public final int[] getPrimaryKey() {
        return this.primaryKeyCols;
    }

    public boolean hasLobColumn() {
        return this.hasLobColumn;
    }

    public void setHasLobColumn(boolean hasLobColumn) {
        this.hasLobColumn = hasLobColumn;
    }

    public final Type[] getColumnTypes() {
        return this.colTypes;
    }

    public Index getFullIndex() {
        return this.fullIndex;
    }

    public final Index getIndex(int i) {
        return this.indexList[i];
    }

    public final Index[] getIndexList() {
        return this.indexList;
    }

    public final boolean[] getNewColumnCheckList() {
        return new boolean[this.getColumnCount()];
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public final int getDataColumnCount() {
        if (this.colTypes != null) {
            return this.colTypes.length;
        }
        return 0;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void setTransactional(boolean value) {
        this.isTransactional = value;
    }

    public final void setBestRowIdentifiers() {
        int[] briCols = null;
        int briColsCount = 0;
        boolean isStrict = false;
        int nNullCount = 0;
        if (this.colNotNull == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.colTypes.length];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            Index index = this.indexList[i];
            int[] cols = index.getColumns();
            int colsCount = index.getVisibleColumns();
            if (colsCount == 0) continue;
            if (i == 0) {
                isStrict = true;
            }
            if (this.bestIndexForColumn[cols[0]] == -1) {
                this.bestIndexForColumn[cols[0]] = i;
            } else {
                Index existing = this.indexList[this.bestIndexForColumn[cols[0]]];
                if (colsCount > existing.getColumns().length) {
                    this.bestIndexForColumn[cols[0]] = i;
                }
            }
            if (!index.isUnique()) {
                if (this.bestIndex != null) continue;
                this.bestIndex = index;
                continue;
            }
            int nnullc = 0;
            for (int j = 0; j < colsCount; ++j) {
                if (!this.colNotNull[cols[j]]) continue;
                ++nnullc;
            }
            if (this.bestIndex != null) {
                this.bestIndex = index;
            }
            if (nnullc == colsCount) {
                if (briCols != null && briColsCount == nNullCount && colsCount >= briColsCount) continue;
                briCols = cols;
                briColsCount = colsCount;
                nNullCount = colsCount;
                isStrict = true;
                continue;
            }
            if (isStrict || briCols != null && colsCount >= briColsCount && nnullc <= nNullCount) continue;
            briCols = cols;
            briColsCount = colsCount;
            nNullCount = nnullc;
        }
        this.bestRowIdentifierCols = briCols == null || briColsCount == briCols.length ? briCols : ArrayUtil.arraySlice(briCols, 0, briColsCount);
        this.bestRowIdentifierStrict = isStrict;
        if (this.indexList[0].getColumnCount() > 0) {
            this.bestIndex = this.indexList[0];
        }
    }

    public final void createPrimaryIndex(int[] pkcols, Type[] pktypes, NameManager.ObjectName name) {
        long id = this.database.persistentStoreCollection.getNextId();
        Index newIndex = this.database.dataspaceLogger.newIndex(name, id, this, pkcols, null, null, pktypes, true, pkcols.length > 0, pkcols.length > 0, false, null);
        try {
            this.addIndex(newIndex);
        }
        catch (DataspaceException dataspaceException) {
            // empty catch block
        }
    }

    public final Index createAndAddIndexStructure(NameManager.ObjectName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean unique, boolean constraint, boolean forward, SIndexType sIndexType) {
        Index newindex = this.createIndexStructure(name, columns, descending, nullsLast, unique, constraint, forward, sIndexType);
        this.addIndex(newindex);
        return newindex;
    }

    public final Index createIndexStructure(NameManager.ObjectName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean unique, boolean constraint, boolean forward, SIndexType sIndexType) {
        if (this.primaryKeyCols == null) {
            throw Error.runtimeError(201, "createIndex");
        }
        int s = columns.length;
        int[] cols = new int[s];
        Type[] types = new Type[s];
        for (int j = 0; j < s; ++j) {
            cols[j] = columns[j];
            types[j] = this.colTypes[cols[j]];
        }
        long id = this.database.persistentStoreCollection.getNextId();
        Index newIndex = this.database.dataspaceLogger.newIndex(name, id, this, cols, descending, nullsLast, types, false, unique, constraint, forward, sIndexType);
        return newIndex;
    }

    public Index dropIndex(int todrop) {
        Index droppedIndex = this.indexList[todrop];
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, todrop, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].setPosition(i);
        }
        this.setBestRowIdentifiers();
        if (this.store != null) {
            this.store.resetAccessorKeys(this.indexList);
        }
        return droppedIndex;
    }

    final void addIndex(Index index) {
        int i;
        for (i = 0; i < this.indexList.length; ++i) {
            Index current = this.indexList[i];
            int order = index.getIndexOrderValue() - current.getIndexOrderValue();
            if (order < 0) break;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, index, i, 1);
        for (i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].setPosition(i);
        }
        if (this.store != null) {
            try {
                this.store.resetAccessorKeys(this.indexList);
            }
            catch (DataspaceException e) {
                this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, index.getPosition(), -1);
                for (i = 0; i < this.indexList.length; ++i) {
                    this.indexList[i].setPosition(i);
                }
                throw e;
            }
        }
        this.setBestRowIdentifiers();
    }

    final void removeIndex(int position) {
        this.setBestRowIdentifiers();
    }

    public final void setIndexes(Index[] indexes) {
        this.indexList = indexes;
    }

    public final Object[] getEmptyRowData() {
        return new Object[this.getDataColumnCount()];
    }

    public final Index createIndex(Session session, NameManager.ObjectName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean unique, boolean constraint, boolean forward, SIndexType sIndexType) {
        Index newIndex = this.createAndAddIndexStructure(name, columns, descending, nullsLast, unique, constraint, forward, sIndexType);
        return newIndex;
    }

    public void clearAllData(Session session) {
        PersistentStore store = this.getRowStore(session);
        store.removeAll();
    }

    public void clearAllData(PersistentStore store) {
        store.removeAll();
    }

    public final boolean isEmpty(Session session) {
        if (this.indexList.length == 0) {
            return true;
        }
        PersistentStore store = this.getRowStore(session);
        return this.indexList[0].isEmpty(store);
    }

    public PersistentStore getRowStore(Session session) {
        return this.store == null ? session.sessionData.persistentStoreCollection.getStore(this) : this.store;
    }

    public void releaseRowStore(Session session) {
        if (this.store != null) {
            session.sessionData.persistentStoreCollection.setStore(this, null);
            this.store = null;
        }
    }

    public boolean isLogged() {
        return this.isLogged;
    }

    public boolean isDropped() {
        return this.isDropped;
    }

    public void setDropped(boolean isDropped) {
        this.isDropped = isDropped;
    }

    public String getSampleCountAsString(Session session) {
        PersistentStore localStore;
        long count;
        Object scount = "n/a";
        if (this.store != null) {
            long count2 = this.store.elementCountGetOnly();
            if (count2 >= 0L) {
                scount = "" + count2;
            }
        } else if (this.tableType == 3 && (count = (localStore = this.getRowStore(session)).elementCountGetOnly()) >= 0L) {
            scount = "" + count;
        }
        return scount;
    }

    public long getSampleCount() {
        return this.store != null ? Math.max(0L, this.store.elementCountGetOnly()) : 0L;
    }

    public String getDataScopeString() {
        switch (this.persistenceScope) {
            case 21: 
            case 22: {
                return "TRANSIENT";
            }
            case 23: {
                return "SESSION";
            }
            case 24: {
                return "DATASPACE";
            }
        }
        return "UNKNOWN";
    }
}

