/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceURL;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorDataChange;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreTypesCheckDelegate;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.IndexSnapshot;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.DataspaceTypeToSQLTypeConverter;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.DfetchMonitor;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.trigger.TriggerDefSQL;
import com.streamscape.ds.trigger.WindowTriggerDefSQL;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.Collation;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.RowMetaData;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Table
extends TableBase
implements SchemaObject {
    public static final Table[] emptyArray = new Table[0];
    public static final Collection[] emptyCollectionArray = new Collection[0];
    protected NameManager.ObjectName tableName;
    protected long changeTimestamp;
    public HashMappedList columnList;
    public int identityColumn;
    public NumberSequence identitySequence;
    Constraint[] constraintList;
    public Constraint[] fkConstraints;
    public Constraint[] fkMainConstraints;
    public Constraint[] checkConstraints;
    public TriggerDef[] triggerList;
    public TriggerDef[][] triggerLists;
    public Expression[] colDefaults;
    boolean hasDefaultValues;
    public boolean[] colGenerated;
    boolean hasGeneratedValues;
    boolean[] colRefFK;
    boolean[] colMainFK;
    boolean hasReferentialAction;
    boolean hasDomainColumns;
    boolean hasNotNullColumns;
    int[] defaultColumnMap;
    public RangeVariable[] defaultRanges;
    public DfetchMonitor dfetchMonitor;
    private ReplicationSource replicationSource;
    private List<FullTextIndex> fullTextIndexes;
    public long tableSchemaChangeTimestamp;

    public Table(DataspaceStore database, NameManager.ObjectName name, int type) {
        this.database = database;
        this.tableName = name;
        this.persistenceId = database.persistentStoreCollection.getNextId();
        this.dfetchMonitor = new DfetchMonitor(this);
        this.tableSchemaChangeTimestamp = System.currentTimeMillis();
        switch (type) {
            case 14: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            case 2: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            case 1: {
                this.isSessionBased = true;
            }
            case 13: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                break;
            }
            case 6: {
                if (DataspaceURL.isFileBasedDatabaseType(database.getModel())) {
                    this.persistenceScope = 24;
                    this.isSchemaBased = true;
                    this.isCached = true;
                    this.isLogged = !database.isFilesReadOnly();
                    break;
                }
                type = 5;
            }
            case 5: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                this.isLogged = !database.isFilesReadOnly();
                break;
            }
            case 4: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                this.isLogged = false;
                this.isMemory = true;
                break;
            }
            case 3: {
                this.persistenceScope = 22;
                this.isTemp = true;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                break;
            }
            case 7: {
                this.persistenceScope = 23;
                if (!DataspaceURL.isFileBasedDatabaseType(database.getModel())) {
                    throw Error.error(459);
                }
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                break;
            }
            case 8: {
                this.persistenceScope = 24;
                if (!DataspaceURL.isFileBasedDatabaseType(database.getModel())) {
                    throw Error.error(459);
                }
                this.isSchemaBased = true;
                this.isText = true;
                break;
            }
            case 15: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                this.isText = false;
                this.isLogged = false;
                break;
            }
            case 16: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                this.isText = false;
                this.isLogged = false;
                break;
            }
            case 9: {
                this.persistenceScope = 21;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isView = true;
                break;
            }
            case 10: {
                this.persistenceScope = 23;
                this.isSessionBased = true;
                break;
            }
            case 12: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                this.isLogged = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
        this.tableType = type;
        this.primaryKeyCols = null;
        this.primaryKeyTypes = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.fkConstraints = Constraint.emptyArray;
        this.fkMainConstraints = Constraint.emptyArray;
        this.checkConstraints = Constraint.emptyArray;
        this.triggerList = TriggerDef.emptyArray;
        this.triggerLists = new TriggerDef[Trigger.Type.values().length][];
        for (int i = 0; i < Trigger.Type.values().length; ++i) {
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        if (database.isFilesReadOnly() && this.isFileBased()) {
            this.isReadOnly = true;
        }
        if (!this.isSessionBased) {
            this.store = database.dataspaceLogger.newStore(null, database.persistentStoreCollection, this);
        }
    }

    public Table(Table table, NameManager.ObjectName name) {
        this.persistenceScope = 21;
        name.schema = SqlInvariants.SYSTEM_SCHEMA_NAME;
        this.tableName = name;
        this.database = table.database;
        this.tableType = 10;
        this.columnList = table.columnList;
        this.columnCount = table.columnCount;
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.dfetchMonitor = new DfetchMonitor(this);
        this.createPrimaryKey();
    }

    @Override
    public int getObjectType() {
        return 3;
    }

    public void setReplicationSource(ReplicationSource replicationSource) {
        this.replicationSource = replicationSource;
    }

    @Override
    public final NameManager.ObjectName getObjectName() {
        return this.tableName;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.database.getCatalogName();
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.tableName.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.tableName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.identitySequence != null && this.identitySequence.getObjectName() != null) {
            set.add(this.identitySequence.getObjectName());
        }
        return set;
    }

    public OrderedHashSet getReferencesForDependents() {
        int i;
        OrderedHashSet set = new OrderedHashSet();
        if (this.colTypes != null) {
            for (i = 0; i < this.colTypes.length; ++i) {
                ColumnSchema column = this.getColumn(i);
                OrderedHashSet refs = column.getReferences();
                if (refs.isEmpty()) continue;
                set.add(column.getObjectName());
            }
        }
        for (i = 0; i < this.fkConstraints.length; ++i) {
            if (this.fkConstraints[i].getMainTableName() == this.getObjectName()) continue;
            set.add(this.fkConstraints[i].getObjectName());
        }
        for (i = 0; i < this.triggerList.length; ++i) {
            set.add(this.triggerList[i].getObjectName());
        }
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        OrderedHashSet set = new OrderedHashSet();
        set.addAll(this.constraintList);
        set.addAll(this.triggerList);
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint()) continue;
            set.add(this.indexList[i]);
        }
        return set;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema column = this.getColumn(i);
            column.compile(session, this);
        }
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        if (this.isTemp()) {
            sb.append("TRANSIENT").append(' ');
        } else if (this.isText()) {
            sb.append("FILE").append(' ');
        } else if (this.isCached()) {
            sb.append("PERSISTENT").append(' ');
        } else if (this.isMemory()) {
            sb.append("MEMORY").append(' ');
        } else if (this.isMemory()) {
            sb.append("MEMORY").append(' ');
        } else if (this.isSnapshot()) {
            if (((SnapshotDataspaceTable)this).getParent().getMemoryModel() == MemoryModel.PERSISTENT) {
                sb.append("PERSISTENT").append(' ');
            }
            sb.append("SNAPSHOT").append(' ');
        } else {
            sb.append("LOGGED").append(' ');
        }
        sb.append("TABLE").append(' ');
        sb.append(name);
        this.appendExternalServerInfo(sb);
        sb.append('(');
        int[] pk = this.getPrimaryKey();
        Constraint pkConst = this.getPrimaryConstraint();
        for (int j = 0; j < this.columnCount; ++j) {
            String defaultString;
            Collation collation;
            ColumnSchema column = this.getColumn(j);
            String colname = column.getObjectName().statementName;
            Type type = column.getDataType();
            if (j > 0) {
                sb.append(',');
            }
            sb.append(colname);
            sb.append(' ');
            sb.append(type.getTypeDefinition());
            if (type.isCharacterType() && (collation = ((CharacterType)type).getCollation()).isObjectCollation()) {
                sb.append(' ').append("COLLATE").append(' ');
                sb.append(collation.getObjectName().statementName);
            }
            if ((defaultString = column.getDefaultSQL()) != null) {
                sb.append(' ').append("DEFAULT").append(' ');
                sb.append(defaultString);
            }
            if (column.isIdentity()) {
                sb.append(' ').append(column.getIdentitySequence().getSQLColumnDefinition());
            }
            if (column.isGenerated()) {
                sb.append(' ').append("GENERATED").append(' ');
                sb.append("ALWAYS").append(' ').append("AS").append("(");
                sb.append(column.getGeneratingExpression().getSQL());
                sb.append(")");
            }
            if (!column.isNullable()) {
                Constraint c = this.getNotNullConstraintForColumn(j);
                if (c != null && !c.getObjectName().isReservedName()) {
                    sb.append(' ').append("CONSTRAINT").append(' ').append(c.getObjectName().statementName);
                }
                sb.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (pk == null || pk.length != 1 || j != pk[0] || !pkConst.getObjectName().isReservedName()) continue;
            sb.append(' ').append("PRIMARY").append(' ').append("KEY");
        }
        for (Constraint c : this.getConstraints()) {
            String d;
            if (c.isForward || (d = c.getSQL()).length() <= 0) continue;
            sb.append(',');
            sb.append(d);
        }
        sb.append(')');
        if (this.onCommitPreserve()) {
            sb.append(' ').append("ON").append(' ');
            sb.append("COMMIT").append(' ').append("PRESERVE");
            sb.append(' ').append("ROWS");
        }
        return sb.toString();
    }

    protected void appendExternalServerInfo(StringBuffer sb) {
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public final void setName(NameManager.ObjectName name) {
        this.tableName = name;
    }

    public String[] getSQL(OrderedHashSet resolved, OrderedHashSet unresolved) {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (c.isForward) {
                unresolved.add(c);
                continue;
            }
            if (c.getConstraintType() != 2 && c.getConstraintType() != 4) continue;
            resolved.add(c.getObjectName());
        }
        HsqlArrayList list = new HsqlArrayList();
        list.add(this.getSQL());
        if (!this.isTemp && !this.isText && this.hasIdentityColumn()) {
            list.add(NumberSequence.getRestartSQL(this));
        }
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint() || this.indexList[i].getColumnCount() <= 0) continue;
            list.add(this.indexList[i].getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getSQLForCollection(Collection collection, OrderedHashSet resolved, OrderedHashSet unresolved) {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (c.isForward) {
                unresolved.add(c);
                continue;
            }
            if (c.getConstraintType() != 2 && c.getConstraintType() != 4) continue;
            resolved.add(c.getObjectName());
        }
        HsqlArrayList list = new HsqlArrayList();
        list.add(collection.getSQL());
        if (!this.isTemp && !this.isText && this.hasIdentityColumn()) {
            list.add(NumberSequence.getRestartSQL(this));
        }
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint() || this.indexList[i].getColumnCount() <= 0) continue;
            list.add(this.indexList[i].getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String getSQLForReadOnly() {
        if (this.isReadOnly && !this.isSnapshot()) {
            StringBuffer sb = new StringBuffer(64);
            sb.append("SET").append(' ').append("COLLECTION").append(' ');
            sb.append(this.getObjectName().getSchemaQualifiedStatementName());
            sb.append(' ').append("READ").append(' ');
            sb.append("ONLY");
            return sb.toString();
        }
        return null;
    }

    public String[] getSQLForTextSource(boolean withHeader) {
        if (this.isText()) {
            String dataSource;
            HsqlArrayList list = new HsqlArrayList();
            if (this.isReadOnly) {
                list.add(this.getSQLForReadOnly());
            }
            if ((dataSource = ((FileTable)this).getDataSourceDDL()) != null) {
                list.add(dataSource);
            }
            String header = ((FileTable)this).getDataSourceHeader();
            if (withHeader && header != null && !this.isReadOnly) {
                list.add(header);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            return array;
        }
        return null;
    }

    public String getSQLForClustered() {
        if (!this.isCached() && !this.isText()) {
            return null;
        }
        Index index = this.getClusteredIndex();
        if (index == null) {
            return null;
        }
        String colList = this.getColumnListSQL(index.getColumns(), index.getColumnCount());
        StringBuffer sb = new StringBuffer(64);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getObjectName().getSchemaQualifiedStatementName());
        sb.append(' ').append("CLUSTERED").append(' ');
        sb.append("ON").append(' ').append(colList);
        return sb.toString();
    }

    public void addTriggerSQL(List<String> list, DataspaceStore store) {
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (this.triggerList[i].isSystem()) continue;
            list.add(this.triggerList[i].getSQL());
            DataspaceStore.DDLRecordNode node = new DataspaceStore.DDLRecordNode();
            node.objectName = this.triggerList[i].getObjectName().getSchemaQualifiedStatementName();
            node.dataspaceId = this.triggerList[i].getObjectName().schema.getId();
            node.objectId = this.triggerList[i].getObjectName().getId();
            node.type = LogRecordType.CREATE;
            store.logIndexBuilder.put(list.size() - 1, node);
        }
        if (this.replicationSource != null) {
            list.add(this.replicationSource.getSQL());
            DataspaceStore.DDLRecordNode node = new DataspaceStore.DDLRecordNode();
            node.objectName = this.getObjectName().getSchemaQualifiedStatementName();
            node.dataspaceId = this.getObjectName().schema.getId();
            node.objectId = -1;
            node.type = LogRecordType.OTHER;
            store.logIndexBuilder.put(list.size() - 1, node);
            if (!this.replicationSource.isEnabled()) {
                list.add("DISABLE REPLICATION SOURCE " + this.replicationSource.getReplicationEntityName().getFullNameNoDataspaceTypeNoNodeName());
                node = new DataspaceStore.DDLRecordNode();
                node.objectName = this.getObjectName().getSchemaQualifiedStatementName();
                node.dataspaceId = this.getObjectName().schema.getId();
                node.objectId = -1;
                node.type = LogRecordType.OTHER;
                store.logIndexBuilder.put(list.size() - 1, node);
            }
        }
    }

    public String getIndexRootsSQL(long[] roots) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("SET").append(' ').append("COLLECTION").append(' ');
        sb.append(this.getObjectName().getSchemaQualifiedStatementName());
        sb.append(' ').append("INDEX").append(' ').append('\'');
        sb.append(StringUtil.getList(roots, " ", ""));
        sb.append('\'');
        return sb.toString();
    }

    public String getColumnListSQL(int[] col, int len) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < len; ++i) {
            sb.append(this.getColumn((int)col[i]).getObjectName().statementName);
            if (i >= len - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    public String[] getCommentsSQL() {
        int colCount = this.getColumnCount();
        StringBuffer sb = new StringBuffer();
        LinkedList<String> list = new LinkedList<String>();
        for (int j = 0; j < colCount; ++j) {
            ColumnSchema column = this.getColumn(j);
            if (column.getObjectName().comment == null) continue;
            sb.setLength(0);
            sb.append("COMMENT").append(' ').append("ON");
            sb.append(' ').append("TUPLE").append(' ');
            sb.append(this.getObjectName().getSchemaQualifiedStatementName());
            sb.append('.').append(column.getObjectName().statementName);
            sb.append(' ').append("IS").append(' ');
            sb.append(StringConverter.toQuotedString(column.getObjectName().comment, '\'', true));
            list.add(sb.toString());
        }
        if (this.getObjectName().comment != null) {
            sb.setLength(0);
            sb.append("COMMENT").append(' ').append("ON");
            sb.append(' ').append("COLLECTION").append(' ');
            sb.append(this.getObjectName().getSchemaQualifiedStatementName());
            sb.append(' ').append("IS").append(' ');
            sb.append(StringConverter.toQuotedString(this.getObjectName().comment, '\'', true));
            list.add(sb.toString());
        }
        return list.toArray(new String[0]);
    }

    public String getColumnListWithTypeSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int j = 0; j < this.columnCount; ++j) {
            ColumnSchema column = this.getColumn(j);
            String colname = column.getObjectName().statementName;
            Type type = column.getDataType();
            if (j > 0) {
                sb.append(',');
            }
            sb.append(colname);
            sb.append(' ');
            sb.append(type.getTypeDefinition());
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean isConnected() {
        return true;
    }

    public static int compareRows(Session session, Object[] a, Object[] b, int[] cols, Type[] coltypes) {
        int fieldcount = cols.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = coltypes[cols[j]].compare(session, a[cols[j]], b[cols[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getId() {
        return this.tableName.hashCode();
    }

    public final boolean isSchemaBaseTable() {
        switch (this.tableType) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final boolean isView() {
        return this.isView;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    final boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    public void checkDataReadOnly() {
        if (this.isReadOnly) {
            throw Error.error(456);
        }
    }

    public void setDataReadOnly(boolean value) {
        if (!value) {
            if (this.database.isFilesReadOnly() && this.isFileBased()) {
                throw Error.error(456);
            }
            if (this.database.getModel().equals("mem://") && this.isText) {
                throw Error.error(456);
            }
        }
        this.isReadOnly = value;
    }

    public boolean isFileBased() {
        return this.isCached || this.isText;
    }

    public void addConstraint(Constraint c) {
        int index = c.getConstraintType() == 4 ? 0 : this.constraintList.length;
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, c, index, 1);
        this.updateConstraintLists();
    }

    void updateConstraintLists() {
        int i;
        int fkCount = 0;
        int mainCount = 0;
        int checkCount = 0;
        this.hasReferentialAction = false;
        block10: for (i = 0; i < this.constraintList.length; ++i) {
            switch (this.constraintList[i].getConstraintType()) {
                case 0: {
                    ++fkCount;
                    continue block10;
                }
                case 1: {
                    ++mainCount;
                    continue block10;
                }
                case 3: {
                    if (this.constraintList[i].isNotNull()) continue block10;
                    ++checkCount;
                }
            }
        }
        this.fkConstraints = fkCount == 0 ? Constraint.emptyArray : new Constraint[fkCount];
        fkCount = 0;
        this.fkMainConstraints = mainCount == 0 ? Constraint.emptyArray : new Constraint[mainCount];
        mainCount = 0;
        this.checkConstraints = checkCount == 0 ? Constraint.emptyArray : new Constraint[checkCount];
        checkCount = 0;
        this.colRefFK = new boolean[this.columnCount];
        this.colMainFK = new boolean[this.columnCount];
        block11: for (i = 0; i < this.constraintList.length; ++i) {
            switch (this.constraintList[i].getConstraintType()) {
                case 0: {
                    this.fkConstraints[fkCount] = this.constraintList[i];
                    ArrayUtil.intIndexesToBooleanArray(this.constraintList[i].getRefColumns(), this.colRefFK);
                    ++fkCount;
                    continue block11;
                }
                case 1: {
                    this.fkMainConstraints[mainCount] = this.constraintList[i];
                    ArrayUtil.intIndexesToBooleanArray(this.constraintList[i].getMainColumns(), this.colMainFK);
                    if (this.constraintList[i].hasTriggeredAction()) {
                        this.hasReferentialAction = true;
                    }
                    ++mainCount;
                    continue block11;
                }
                case 3: {
                    if (this.constraintList[i].isNotNull()) continue block11;
                    this.checkConstraints[checkCount] = this.constraintList[i];
                    ++checkCount;
                }
            }
        }
    }

    public void verifyConstraintsIntegrity() {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getConstraintType() != 0 && c.getConstraintType() != 1) continue;
            if (c.getMain() != this.database.schemaManager.findUserTable(null, c.getMain().getObjectName().name, c.getMain().getObjectName().schema.name)) {
                throw Error.runtimeError(201, "FK mismatch : " + c.getObjectName().name);
            }
            if (c.getRef() == this.database.schemaManager.findUserTable(null, c.getRef().getObjectName().name, c.getRef().getObjectName().schema.name)) continue;
            throw Error.runtimeError(201, "FK mismatch : " + c.getObjectName().name);
        }
    }

    public Constraint[] getConstraints() {
        return this.constraintList;
    }

    public Constraint[] getFKConstraints() {
        return this.fkConstraints;
    }

    public Constraint getPrimaryConstraint() {
        return this.primaryKeyCols == null || this.primaryKeyCols.length == 0 ? null : this.constraintList[0];
    }

    public void collectFKReadLocks(int[] columnMap, OrderedHashSet set) {
        for (int i = 0; i < this.fkMainConstraints.length; ++i) {
            Constraint constraint = this.fkMainConstraints[i];
            Table ref = constraint.getRef();
            int[] mainColumns = constraint.getMainColumns();
            if (ref == this) continue;
            if (columnMap == null) {
                int[] cols;
                if (!constraint.core.hasDeleteAction) continue;
                int[] nArray = cols = constraint.core.deleteAction == 0 ? null : constraint.getRefColumns();
                if (!set.add(ref.getObjectName())) continue;
                ref.collectFKReadLocks(cols, set);
                continue;
            }
            if (!ArrayUtil.haveCommonElement(columnMap, mainColumns) || !set.add(ref.getObjectName())) continue;
            ref.collectFKReadLocks(constraint.getRefColumns(), set);
        }
    }

    public void collectFKWriteLocks(int[] columnMap, OrderedHashSet set) {
        for (int i = 0; i < this.fkMainConstraints.length; ++i) {
            Constraint constraint = this.fkMainConstraints[i];
            Table ref = constraint.getRef();
            int[] mainColumns = constraint.getMainColumns();
            if (ref == this) continue;
            if (columnMap == null) {
                int[] cols;
                if (!constraint.core.hasDeleteAction) continue;
                int[] nArray = cols = constraint.core.deleteAction == 0 ? null : constraint.getRefColumns();
                if (!set.add(ref.getObjectName())) continue;
                ref.collectFKWriteLocks(cols, set);
                continue;
            }
            if (!ArrayUtil.haveCommonElement(columnMap, mainColumns) || !constraint.core.hasUpdateAction || !set.add(ref.getObjectName())) continue;
            ref.collectFKWriteLocks(constraint.getRefColumns(), set);
        }
    }

    public Constraint getNotNullConstraintForColumn(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (!c.isNotNull() || c.notNullColumnIndex != colIndex) continue;
            return c;
        }
        return null;
    }

    public Constraint getUniqueConstraintForColumns(int[] cols) {
        for (Constraint c : this.constraintList) {
            if (!c.isUniqueWithColumns(cols)) continue;
            return c;
        }
        return null;
    }

    Constraint getFKConstraintForColumns(Table tableMain, int[] mainCols, int[] refCols) {
        for (Constraint c : this.constraintList) {
            if (!c.isEquivalent(tableMain, mainCols, this, refCols)) continue;
            return c;
        }
        return null;
    }

    public Constraint getUniqueOrPKConstraintForIndex(Index index) {
        for (Constraint c : this.constraintList) {
            if (c.getMainIndex() != index || c.getConstraintType() != 2 && c.getConstraintType() != 4) continue;
            return c;
        }
        return null;
    }

    int getNextConstraintIndex(int from, int type) {
        int size = this.constraintList.length;
        for (int i = from; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getConstraintType() != type) continue;
            return i;
        }
        return -1;
    }

    public void addColumn(ColumnSchema column) {
        String name = column.getObjectName().name;
        if (this.findColumn(name) >= 0) {
            throw Error.error(5504, name);
        }
        if (column.isIdentity()) {
            if (this.identityColumn != -1) {
                throw Error.error(5525, name);
            }
            this.identityColumn = this.columnCount;
            this.identitySequence = column.getIdentitySequence();
        }
        this.addColumnNoCheck(column);
    }

    public void addColumnNoCheck(ColumnSchema column) {
        if (this.primaryKeyCols != null) {
            throw Error.runtimeError(201, "Table");
        }
        this.columnList.add(column.getObjectName().name, column);
        ++this.columnCount;
    }

    public boolean hasGeneratedColumn() {
        return this.hasGeneratedValues;
    }

    public boolean hasIdentityColumn() {
        return this.identityColumn != -1;
    }

    public long getNextIdentity() {
        return this.identitySequence.peek();
    }

    void checkColumnsMatch(int[] col, Table other, int[] othercol) {
        for (int i = 0; i < col.length; ++i) {
            Type type = this.colTypes[col[i]];
            Type otherType = other.colTypes[othercol[i]];
            if (type.typeComparisonGroup == otherType.typeComparisonGroup) continue;
            throw Error.error(5562);
        }
    }

    void checkColumnsMatch(ColumnSchema column, int colIndex) {
        Type type = this.colTypes[colIndex];
        Type otherType = column.getDataType();
        if (type.typeComparisonGroup != otherType.typeComparisonGroup) {
            throw Error.error(5562);
        }
    }

    Table moveDefinition(Session session, int newType, ColumnSchema column, Constraint constraint, Index index, int colIndex, int adjust, OrderedHashSet dropConstraints, OrderedHashSet dropIndexes) {
        int i;
        Table tn;
        boolean newPK = false;
        if (constraint != null && constraint.constType == 4) {
            newPK = true;
        }
        if (this.isText) {
            tn = new FileTable(this.database, this.tableName, newType);
            ((FileTable)tn).dataSource = ((FileTable)this).dataSource;
            ((FileTable)tn).isConnected = ((FileTable)this).isConnected;
            ((FileTable)tn).setFileDescriptorName(((FileTable)this).getFileDescriptorName());
            ((FileTable)tn).setTypesOnly(((FileTable)this).getTypesOnly());
            ((FileTable)tn).setRecordTypes(((FileTable)this).getRecordTypes());
        } else if (this.isSnapshot()) {
            tn = new SnapshotDataspaceTable(this.database, this.tableName, ((SnapshotDataspaceTable)this).getParent());
            ((SnapshotDataspaceTable)tn).setsTable(((SnapshotDataspaceTable)this).getSTable());
        } else {
            tn = new Table(this.database, this.tableName, newType);
        }
        if (this.tableType == 3) {
            tn.persistenceScope = this.persistenceScope;
        }
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            ColumnSchema col = (ColumnSchema)this.columnList.get(i2);
            if (i2 == colIndex) {
                if (column != null) {
                    tn.addColumn(column);
                }
                if (adjust <= 0) continue;
            }
            tn.addColumn(col);
        }
        if (this.columnCount == colIndex) {
            tn.addColumn(column);
        }
        int[] pkCols = null;
        if (this.hasPrimaryKey() && !dropConstraints.contains(this.getPrimaryConstraint().getObjectName())) {
            pkCols = this.primaryKeyCols;
            pkCols = ArrayUtil.toAdjustedColumnArray(pkCols, colIndex, adjust);
        } else if (newPK) {
            pkCols = constraint.getMainColumns();
        }
        tn.createPrimaryKey(this.getIndex(0).getObjectName(), pkCols, false);
        for (int i3 = 1; i3 < this.indexList.length; ++i3) {
            Index idx = this.indexList[i3];
            if (dropIndexes.contains(idx.getObjectName())) continue;
            int[] colarr = ArrayUtil.toAdjustedColumnArray(idx.getColumns(), colIndex, adjust);
            Index newIdx = tn.createIndexStructure(idx.getObjectName(), colarr, idx.getColumnDesc(), null, idx.isUnique(), idx.isConstraint(), idx.isForward(), idx instanceof IndexSnapshot ? ((IndexSnapshot)idx).getSIndexType() : null);
            newIdx.setClustered(idx.isClustered());
            tn.addIndex(newIdx);
        }
        if (index != null) {
            tn.addIndex(index);
        }
        HsqlArrayList newList = new HsqlArrayList();
        if (newPK) {
            constraint.core.mainIndex = tn.indexList[0];
            constraint.core.mainTable = tn;
            constraint.core.mainTableName = tn.tableName;
            newList.add(constraint);
        }
        for (i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (dropConstraints.contains(c.getObjectName())) continue;
            c = c.duplicate();
            c.updateTable(session, this, tn, colIndex, adjust);
            newList.add(c);
        }
        if (!newPK && constraint != null) {
            constraint.updateTable(session, this, tn, -1, 0);
            newList.add(constraint);
        }
        tn.constraintList = new Constraint[newList.size()];
        newList.toArray(tn.constraintList);
        tn.updateConstraintLists();
        tn.setBestRowIdentifiers();
        tn.triggerList = this.triggerList;
        tn.triggerLists = this.triggerLists;
        for (i = 0; i < tn.constraintList.length; ++i) {
            tn.constraintList[i].compile(session, tn);
        }
        for (i = 0; i < tn.columnCount; ++i) {
            tn.getColumn(i).compile(session, tn);
        }
        tn.setReplicationSource(this.replicationSource);
        return tn;
    }

    void checkColumnInCheckConstraint(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (c.constType != 3 || c.isNotNull() || !c.hasColumn(colIndex)) continue;
            NameManager.ObjectName name = c.getObjectName();
            throw Error.error(5502, name.getSchemaQualifiedStatementName());
        }
    }

    void checkColumnInFKConstraint(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (!c.hasColumn(colIndex) || c.getConstraintType() != 1 && c.getConstraintType() != 0) continue;
            NameManager.ObjectName name = c.getObjectName();
            throw Error.error(5533, name.getSchemaQualifiedStatementName());
        }
    }

    OrderedHashSet getDependentConstraints(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (!c.hasColumnOnly(colIndex)) continue;
            set.add(c);
        }
        return set;
    }

    OrderedHashSet getContainingConstraints(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (!c.hasColumnPlus(colIndex)) continue;
            set.add(c);
        }
        return set;
    }

    OrderedHashSet getContainingIndexNames(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Index index : this.indexList) {
            if (ArrayUtil.find(index.getColumns(), colIndex) == -1) continue;
            set.add(index.getObjectName());
        }
        return set;
    }

    OrderedHashSet getDependentConstraints(Constraint constraint) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.fkMainConstraints) {
            if (c.core.uniqueName != constraint.getObjectName()) continue;
            set.add(c);
        }
        return set;
    }

    public OrderedHashSet getDependentExternalConstraints() {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 1 && c.getConstraintType() != 0 || c.core.mainTable == c.core.refTable) continue;
            set.add(c);
        }
        return set;
    }

    public OrderedHashSet getUniquePKConstraintNames() {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (c.constType != 2 && c.constType != 4) continue;
            set.add(c.getObjectName());
        }
        return set;
    }

    void checkColumnInFKConstraint(int colIndex, int actionType) {
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 0 || !c.hasColumn(colIndex) || actionType != c.getUpdateAction() && actionType != c.getDeleteAction()) continue;
            NameManager.ObjectName name = c.getObjectName();
            throw Error.error(5533, name.getSchemaQualifiedStatementName());
        }
    }

    public int getIdentityColumnIndex() {
        return this.identityColumn;
    }

    public int getColumnIndex(String name) {
        int i = this.findColumn(name);
        if (i == -1) {
            throw Error.error(5501, name);
        }
        return i;
    }

    public int findColumn(String name) {
        int index = this.columnList.getIndex(name);
        return index;
    }

    public ColumnSchema getColumn(String name) {
        int i = this.findColumn(name);
        if (i != -1) {
            return this.getColumn(i);
        }
        return null;
    }

    void resetDefaultsFlag() {
        int i;
        this.hasDefaultValues = false;
        for (i = 0; i < this.colDefaults.length; ++i) {
            this.hasDefaultValues |= this.colDefaults[i] != null;
        }
        this.hasGeneratedValues = false;
        for (i = 0; i < this.colGenerated.length; ++i) {
            this.hasGeneratedValues |= this.colGenerated[i];
        }
        this.hasNotNullColumns = false;
        for (i = 0; i < this.colNotNull.length; ++i) {
            this.hasNotNullColumns |= this.colNotNull[i];
        }
    }

    public int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    public boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    public Index getClusteredIndex() {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            return this.indexList[i];
        }
        return null;
    }

    public synchronized Index getIndexForColumn(Session session, int col) {
        int i = this.bestIndexForColumn[col];
        if (i > -1 && this.indexList[i].isBuilt()) {
            return this.indexList[i];
        }
        if (this instanceof VirtualTable) {
            return null;
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                Index index = this.createIndexForColumns(session, new int[]{col});
                return index;
            }
        }
        return null;
    }

    boolean isIndexed(int colIndex) {
        return this.bestIndexForColumn[colIndex] != -1;
    }

    public int[] getUniqueNotNullColumnGroup(boolean[] usedColumns) {
        for (Constraint constraint : this.constraintList) {
            int[] indexCols;
            if (!(constraint.constType == 2 ? ArrayUtil.areAllIntIndexesInBooleanArray(indexCols = constraint.getMainColumns(), this.colNotNull) && ArrayUtil.areAllIntIndexesInBooleanArray(indexCols, usedColumns) : constraint.constType == 4 && ArrayUtil.areAllIntIndexesInBooleanArray(indexCols = constraint.getMainColumns(), usedColumns))) continue;
            return indexCols;
        }
        return null;
    }

    boolean areColumnsNotNull(int[] indexes) {
        return ArrayUtil.areAllIntIndexesInBooleanArray(indexes, this.colNotNull);
    }

    public void createPrimaryKey() {
        this.createPrimaryKey(null, null, false);
    }

    public void createPrimaryKey(NameManager.ObjectName indexName, int[] columns, boolean columnsNotNull) {
        if (this.primaryKeyCols != null) {
            throw Error.runtimeError(201, "Table");
        }
        if (columns == null || columns.length == 0) {
            columns = ValuePool.emptyIntArray;
            indexName = SqlInvariants.SYSTEM_INDEX_NAME;
        } else {
            for (int i = 0; i < columns.length; ++i) {
                this.getColumn(columns[i]).setPrimaryKey(true);
            }
        }
        this.primaryKeyCols = columns;
        this.setColumnStructures();
        this.primaryKeyTypes = new Type[this.primaryKeyCols.length];
        ArrayUtil.projectRow(this.colTypes, this.primaryKeyCols, this.primaryKeyTypes);
        this.primaryKeyColsSequence = new int[this.primaryKeyCols.length];
        ArrayUtil.fillSequence(this.primaryKeyColsSequence);
        NameManager.ObjectName name = indexName;
        if (name == null) {
            name = this.database.nameManager.newAutoName("IDX", this.getSchemaName(), this.getObjectName(), 21);
        }
        this.createPrimaryIndex(this.primaryKeyCols, this.primaryKeyTypes, name);
        this.setBestRowIdentifiers();
    }

    public void createPrimaryKeyConstraint(NameManager.ObjectName indexName, int[] columns, boolean columnsNotNull) {
        this.createPrimaryKey(indexName, columns, columnsNotNull);
        Constraint c = new Constraint(indexName, this, this.getPrimaryIndex(), 4);
        this.addConstraint(c);
    }

    public void setColumnStructures() {
        if (this.colTypes == null) {
            this.colTypes = new Type[this.columnCount];
        }
        this.colDefaults = new Expression[this.columnCount];
        this.colNotNull = new boolean[this.columnCount];
        this.colGenerated = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        this.hasDomainColumns = false;
        for (int i = 0; i < this.columnCount; ++i) {
            this.setColumnTypeVars(i);
        }
        this.resetDefaultsFlag();
        this.defaultRanges = new RangeVariable[]{new RangeVariable(this, 0)};
    }

    public void setColumnTypeVars(int i) {
        ColumnSchema column = this.getColumn(i);
        Type dataType = column.getDataType();
        if (dataType.isDomainType() || dataType.isDistinctType()) {
            this.hasDomainColumns = true;
        }
        if (dataType.isLobType() || dataType.isFlobType()) {
            this.setHasLobColumn(true);
        }
        this.colTypes[i] = dataType;
        this.colNotNull[i] = column.isPrimaryKey() || !column.isNullable();
        this.defaultColumnMap[i] = i;
        if (column.isIdentity()) {
            this.identitySequence = column.getIdentitySequence();
            this.identityColumn = i;
        } else if (this.identityColumn == i) {
            this.identityColumn = -1;
        }
        this.colDefaults[i] = column.getDefaultExpression();
        this.colGenerated[i] = column.isGenerated();
        this.resetDefaultsFlag();
    }

    public int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.columnCount];
    }

    public boolean[] getColumnCheckList(int[] columnIndexes) {
        boolean[] columnCheckList = new boolean[this.columnCount];
        for (int i = 0; i < columnIndexes.length; ++i) {
            int index = columnIndexes[i];
            if (index <= -1) continue;
            columnCheckList[index] = true;
        }
        return columnCheckList;
    }

    public int[] getColumnIndexes(String[] list) {
        int[] cols = new int[list.length];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.getColumnIndex(list[i]);
        }
        return cols;
    }

    public int[] getColumnIndexes(OrderedHashSet set) {
        int[] cols = new int[set.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.getColumnIndex((String)set.get(i));
            if (cols[i] != -1) continue;
            throw Error.error(5501, (String)set.get(i));
        }
        return cols;
    }

    int[] getColumnIndexes(HashMappedList list) {
        int[] cols = new int[list.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = (Integer)list.get(i);
        }
        return cols;
    }

    public ColumnSchema getColumn(int i) {
        return (ColumnSchema)this.columnList.get(i);
    }

    public OrderedHashSet getColumnNameSet(int[] columnIndexes) {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < columnIndexes.length; ++i) {
            set.add(((ColumnSchema)this.columnList.get(i)).getObjectName());
        }
        return set;
    }

    public List<NameManager.ObjectName> getColumnNameList(int[] columnIndexes) {
        ArrayList<NameManager.ObjectName> list = new ArrayList<NameManager.ObjectName>();
        for (int i = 0; i < columnIndexes.length; ++i) {
            NameManager.ObjectName name = ((ColumnSchema)this.columnList.get(columnIndexes[i])).getObjectName();
            list.add(name);
        }
        return list;
    }

    public OrderedHashSet getColumnNameSet(boolean[] columnCheckList) {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < columnCheckList.length; ++i) {
            if (!columnCheckList[i]) continue;
            set.add(this.columnList.get(i));
        }
        return set;
    }

    public void getColumnNames(boolean[] columnCheckList, Set set) {
        for (int i = 0; i < columnCheckList.length; ++i) {
            if (!columnCheckList[i]) continue;
            set.add(((ColumnSchema)this.columnList.get(i)).getObjectName());
        }
    }

    public OrderedHashSet getColumnNameSet() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.columnCount; ++i) {
            set.add(((ColumnSchema)this.columnList.get(i)).getObjectName());
        }
        return set;
    }

    public Object[] getNewRowData(Session session) {
        Object[] data = new Object[this.columnCount];
        if (this.hasDefaultValues) {
            for (int i = 0; i < this.columnCount; ++i) {
                Expression def = this.colDefaults[i];
                if (def == null) continue;
                data[i] = def.getValue(session, this.colTypes[i]);
            }
        }
        return data;
    }

    public void addTrigger(Session session, TriggerDef td, NameManager.ObjectName otherName, int triggerOrder) {
        int pos;
        int index = this.triggerList.length;
        if (otherName != null && (pos = this.getTriggerIndex(otherName.name)) != -1) {
            index = pos + 1;
        }
        this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, td, index, 1);
        this.addTriggerByType(session, td, otherName, td.triggerType, triggerOrder);
        if (td.operationType == 3001 && td.triggerType == Trigger.Type.INSERT_AFTER) {
            if (td.triggerType == Trigger.Type.INSERT_AFTER) {
                this.addTriggerByType(session, td, otherName, Trigger.Type.UPDATE_AFTER, triggerOrder);
            } else if (td.triggerType == Trigger.Type.INSERT_AFTER_ROW) {
                this.addTriggerByType(session, td, otherName, Trigger.Type.UPDATE_AFTER_ROW, triggerOrder);
            }
        }
    }

    protected void addTriggerByType(Session session, TriggerDef td, NameManager.ObjectName otherName, Trigger.Type type, int triggerOrder) {
        TriggerDef[] list;
        block16: {
            int index;
            block19: {
                block21: {
                    block17: {
                        block20: {
                            block18: {
                                block15: {
                                    list = this.triggerLists[type.ordinal()];
                                    if (!session.isProcessingLog()) break block15;
                                    int index2 = list.length;
                                    if (triggerOrder != 0) {
                                        if (triggerOrder == Integer.MIN_VALUE) {
                                            index2 = 0;
                                            td.triggerOrder = Integer.MIN_VALUE;
                                        } else if (triggerOrder == Integer.MAX_VALUE) {
                                            index2 = list.length;
                                            td.triggerOrder = Integer.MAX_VALUE;
                                        } else {
                                            index2 = triggerOrder - 1;
                                        }
                                    } else if (otherName != null && otherName != null) {
                                        for (int i = 0; i < list.length; ++i) {
                                            if (list[i] == null || !list[i].getObjectName().name.equals(otherName.name)) continue;
                                            index2 = i + 1;
                                            break;
                                        }
                                    }
                                    if (index2 < list.length && list[index2] == null) {
                                        list[index2] = td;
                                    } else {
                                        while (index2 > list.length) {
                                            list = (TriggerDef[])ArrayUtil.toAdjustedArray(list, null, list.length, 1);
                                        }
                                        list = (TriggerDef[])ArrayUtil.toAdjustedArray(list, td, index2, 1);
                                    }
                                    break block16;
                                }
                                index = list.length;
                                if (triggerOrder == 0) break block17;
                                if (triggerOrder != Integer.MIN_VALUE) break block18;
                                index = 0;
                                td.triggerOrder = Integer.MIN_VALUE;
                                if (list.length <= 0 || list[0] == null || list[0].triggerOrder != Integer.MIN_VALUE) break block19;
                                list[0].triggerOrder = 1;
                                break block19;
                            }
                            if (triggerOrder != Integer.MAX_VALUE) break block20;
                            index = list.length;
                            td.triggerOrder = Integer.MAX_VALUE;
                            if (list.length <= 0 || list[list.length - 1] == null || list[list.length - 1].triggerOrder != Integer.MAX_VALUE) break block19;
                            list[list.length - 1].triggerOrder = list.length;
                            break block19;
                        }
                        index = triggerOrder - 1;
                        if (index > list.length) {
                            index = list.length;
                        }
                        if (index == 0 && list.length > 0 && list[0] != null && list[0].triggerOrder == Integer.MIN_VALUE) {
                            index = 1;
                        }
                        if (index != list.length || list.length <= 0 || list[list.length - 1] == null || list[list.length - 1].triggerOrder != Integer.MAX_VALUE) break block19;
                        index = list.length - 1;
                        break block19;
                    }
                    if (otherName != null) break block21;
                    index = list.length;
                    if (list.length <= 0 || list[list.length - 1] == null || list[list.length - 1].triggerOrder != Integer.MAX_VALUE) break block19;
                    index = list.length - 1;
                    break block19;
                }
                if (otherName != null) {
                    for (int i = 0; i < list.length; ++i) {
                        if (!list[i].getObjectName().name.equals(otherName.name)) continue;
                        index = i + 1;
                        break;
                    }
                }
            }
            list = (TriggerDef[])ArrayUtil.toAdjustedArray(list, td, index, 1);
        }
        this.triggerLists[type.ordinal()] = list;
        this.updateTriggersOrder();
    }

    private void updateTriggersOrder() {
        for (TriggerDef[] list : this.triggerLists) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null || list[i].triggerOrder == Integer.MIN_VALUE || list[i].triggerOrder == Integer.MAX_VALUE) continue;
                list[i].triggerOrder = i + 1;
            }
        }
    }

    public void updateTriggersOrderAndRemoveNulls() {
        for (int i = 0; i < this.triggerLists.length; ++i) {
            TriggerDef[] list = this.triggerLists[i];
            TriggerDef[] newList = new TriggerDef[]{};
            for (TriggerDef triggerDef : list) {
                if (triggerDef == null) continue;
                newList = (TriggerDef[])ArrayUtil.toAdjustedArray(newList, triggerDef, newList.length, 1);
            }
            this.triggerLists[i] = newList;
        }
        this.updateTriggersOrder();
    }

    public TriggerDef getTrigger(String name) {
        for (int i = this.triggerList.length - 1; i >= 0; --i) {
            if (!this.triggerList[i].getObjectName().name.equals(name)) continue;
            return this.triggerList[i];
        }
        return null;
    }

    public int getTriggerIndex(String name) {
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (!this.triggerList[i].getObjectName().name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void removeTrigger(TriggerDef trigger) {
        TriggerDef td = null;
        for (int i = 0; i < this.triggerList.length; ++i) {
            td = this.triggerList[i];
            if (!td.getObjectName().name.equals(trigger.getObjectName().name)) continue;
            td.terminate();
            this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, null, i, -1);
            break;
        }
        this.updateTriggersOrder();
        if (td == null) {
            return;
        }
        int index = td.triggerType.ordinal();
        for (int j = 0; j < this.triggerLists[index].length; ++j) {
            td = this.triggerLists[index][j];
            if (td == null || !td.getObjectName().name.equals(trigger.getObjectName().name)) continue;
            this.triggerLists[index] = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerLists[index], null, j, -1);
            break;
        }
        this.updateTriggersOrder();
    }

    public void releaseTriggers() {
        for (int i = 0; i < Trigger.Type.values().length; ++i) {
            for (int j = 0; j < this.triggerLists[i].length; ++j) {
                if (this.triggerLists[i][j] == null) continue;
                this.triggerLists[i][j].terminate();
            }
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        this.triggerList = TriggerDef.emptyArray;
    }

    int getIndexIndex(String indexName) {
        Index[] indexes = this.indexList;
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexName.equals(indexes[i].getObjectName().name)) continue;
            return i;
        }
        return -1;
    }

    public Index getIndex(String indexName) {
        Index[] indexes = this.indexList;
        int i = this.getIndexIndex(indexName);
        return i == -1 ? null : indexes[i];
    }

    int getConstraintIndex(String constraintName) {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            if (!this.constraintList[i].getObjectName().name.equals(constraintName)) continue;
            return i;
        }
        return -1;
    }

    public Constraint getConstraint(String constraintName) {
        int i = this.getConstraintIndex(constraintName);
        return i < 0 ? null : this.constraintList[i];
    }

    public Constraint getUniqueConstraintForIndex(Index index) {
        for (Constraint c : this.constraintList) {
            if (c.getMainIndex() != index || c.getConstraintType() != 4 && c.getConstraintType() != 2) continue;
            return c;
        }
        return null;
    }

    public void removeConstraint(String name) {
        int index = this.getConstraintIndex(name);
        if (index != -1) {
            this.removeConstraint(index);
        }
    }

    public void removeConstraint(int index) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, null, index, -1);
        this.updateConstraintLists();
    }

    void renameColumn(ColumnSchema column, String newName, boolean isquoted) {
        String oldname = column.getObjectName().name;
        int i = this.getColumnIndex(oldname);
        this.columnList.setKey(i, newName);
        column.getObjectName().rename(newName, isquoted);
    }

    public void renameColumn(ColumnSchema column, NameManager.ObjectName newName) {
        String oldname = column.getObjectName().name;
        int i = this.getColumnIndex(oldname);
        if (this.findColumn(newName.name) != -1) {
            throw Error.error(5504);
        }
        this.columnList.setKey(i, newName.name);
        column.getObjectName().rename(newName);
    }

    public TriggerDef[] getTriggers() {
        return this.triggerList;
    }

    public boolean isWritable() {
        return !this.isReadOnly && !this.database.isReadOnly() && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    public boolean isInsertable() {
        return this.isWritable();
    }

    public boolean isUpdatable() {
        return this.isWritable();
    }

    public boolean isTriggerInsertable() {
        return false;
    }

    public boolean isTriggerUpdatable() {
        return false;
    }

    public boolean isTriggerDeletable() {
        return false;
    }

    public int[] getUpdatableColumns() {
        return this.defaultColumnMap;
    }

    public Table getBaseTable() {
        return this;
    }

    public int[] getBaseTableColumnMap() {
        return this.defaultColumnMap;
    }

    public Index createIndexForColumns(Session session, int[] columns) {
        Index index = null;
        NameManager.ObjectName indexName = this.database.nameManager.newAutoName("IDX_T", this.getSchemaName(), this.getObjectName(), 21);
        try {
            index = this.createAndAddIndexStructure(indexName, columns, null, null, false, false, false, null);
        }
        catch (Throwable t) {
            return null;
        }
        switch (this.tableType) {
            case 1: 
            case 3: {
                session.sessionData.persistentStoreCollection.registerIndex(this);
                break;
            }
        }
        return index;
    }

    public void fireTriggers(Session session, Trigger.Type triggerType, RowSetNavigatorDataChange rowSet) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef td : this.triggerLists[triggerType.ordinal()]) {
            if (td == null) continue;
            if (td.hasOldTable()) {
                // empty if block
            }
            td.pushPair(session, null, null);
        }
    }

    public void fireTriggers(Session session, Trigger.Type triggerType, RowSetNavigator rowSet) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef td : this.triggerLists[triggerType.ordinal()]) {
            if (td == null) continue;
            if (td.hasOldTable()) {
                // empty if block
            }
            if (!td.isEnabled()) continue;
            td.pushPair(session, null, null);
        }
    }

    public void fireTriggers(Session session, Trigger.Type triggerType, Object[] oldData, Object[] newData, int[] cols) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef td : this.triggerLists[triggerType.ordinal()]) {
            if (td == null) continue;
            boolean sqlTrigger = td instanceof TriggerDefSQL;
            if (cols != null && td.getUpdateColumnIndexes() != null && !ArrayUtil.haveCommonElement(td.getUpdateColumnIndexes(), cols)) continue;
            if (td.isForEachRow()) {
                if (!td.isEnabled()) continue;
                switch (td.triggerType) {
                    case INSERT_BEFORE_ROW: {
                        break;
                    }
                    case INSERT_AFTER_ROW: 
                    case INSERT_AFTER_ROW_COMMIT: {
                        newData = (Object[])ArrayUtil.deepDuplicateArray(newData);
                        break;
                    }
                    case UPDATE_AFTER_ROW: 
                    case UPDATE_AFTER_ROW_COMMIT: {
                        oldData = (Object[])ArrayUtil.deepDuplicateArray(oldData);
                        newData = (Object[])ArrayUtil.deepDuplicateArray(newData);
                        break;
                    }
                    case UPDATE_BEFORE_ROW: 
                    case DELETE_BEFORE_ROW: 
                    case DELETE_AFTER_ROW: 
                    case DELETE_AFTER_ROW_COMMIT: {
                        if (sqlTrigger) break;
                        oldData = (Object[])ArrayUtil.duplicateArray(oldData);
                    }
                }
                td.pushPair(session, oldData, newData);
                continue;
            }
            if (!td.isEnabled()) continue;
            td.pushPair(session, null, null);
        }
    }

    public void fireWindowTriggers(Session session, Object oldData, Object newData) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        TriggerDef[] trigVec = this.triggerLists[Trigger.Type.WINDOW_CHANGE.ordinal()];
        int size = trigVec.length;
        for (int i = 0; i < size; ++i) {
            if (trigVec[i] == null) continue;
            WindowTriggerDefSQL td = (WindowTriggerDefSQL)trigVec[i];
            td.processWindowChange(session, oldData, newData);
        }
    }

    public void enforceRowConstraints(Session session, Object[] data) {
        for (int i = 0; i < this.columnCount; ++i) {
            Type type = this.colTypes[i];
            if (type.isDomainType() || type.isDistinctType()) {
                Class<?> unwrappedDataClass;
                Class<?> clazz;
                Object unwrappedData;
                if (type.isDistinctType() && data[i] != null && (unwrappedData = OtherTypeWrapper.unwrap(data[i])) != null && (clazz = type.getInternalClass(session)) != null && !clazz.isAssignableFrom(unwrappedDataClass = unwrappedData.getClass())) {
                    Object[] info = new String[]{type.userTypeModifier.getName().name, this.tableName.statementName, this.getColumn((int)i).getObjectName().statementName};
                    throw Error.error(null, 3501, 3, info);
                }
                Constraint[] constraints = type.userTypeModifier.getConstraints();
                for (int j = 0; j < constraints.length; ++j) {
                    constraints[j].checkCheckConstraint(session, this, this.getColumn(i), data[i]);
                }
            }
            if (!this.colNotNull[i] || data[i] != null) continue;
            Constraint c = this.getNotNullConstraintForColumn(i);
            if (c == null && ArrayUtil.find(this.primaryKeyCols, i) > -1) {
                c = this.getPrimaryConstraint();
            }
            String constraintName = c == null ? "" : c.getObjectName().name;
            Object[] info = new String[]{constraintName, this.tableName.statementName, this.getColumn((int)i).getObjectName().statementName};
            throw Error.error(null, 10, 3, info);
        }
    }

    public void enforceTypeLimits(Session session, Object[] data) {
        for (int i = 0; i < this.columnCount; ++i) {
            data[i] = this.colTypes[i].convertToTypeLimits(session, data[i]);
        }
    }

    public int indexTypeForColumn(Session session, int col) {
        int i = this.bestIndexForColumn[col];
        if (i > -1) {
            return this.indexList[i].isUnique() ? 2 : 1;
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                return 1;
            }
        }
        return 0;
    }

    public Index getIndexForColumns(Session session, int[] cols) {
        int i = this.bestIndexForColumn[cols[0]];
        if (i > -1 && this.indexList[i].isBuilt()) {
            return this.indexList[i];
        }
        if (this instanceof VirtualTable) {
            return null;
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                Index index = this.createIndexForColumns(session, cols);
                return index;
            }
        }
        return null;
    }

    public Index getFullIndexForColumns(int[] cols) {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!ArrayUtil.haveEqualArrays(this.indexList[i].getColumns(), cols, cols.length) || !this.indexList[i].isBuilt()) continue;
            return this.indexList[i];
        }
        return null;
    }

    public synchronized Index getIndexForColumns(Session session, OrderedIntHashSet set, boolean ordered) {
        int maxMatchCount = 0;
        Index selected = null;
        if (set.isEmpty()) {
            return null;
        }
        int count = this.indexList.length;
        for (int i = 0; i < count; ++i) {
            int matchCount;
            Index currentindex = this.getIndex(i);
            int[] indexcols = currentindex.getColumns();
            int n = matchCount = ordered ? set.getOrderedStartMatchCount(indexcols) : set.getStartMatchCount(indexcols);
            if (matchCount == 0) continue;
            if (matchCount == set.size()) {
                return currentindex;
            }
            if (matchCount <= maxMatchCount) continue;
            maxMatchCount = matchCount;
            selected = currentindex;
        }
        if (this instanceof VirtualTable) {
            return selected;
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                selected = this.createIndexForColumns(session, set.toArray());
            }
        }
        return selected;
    }

    public final long[] getIndexRootsArray() {
        int index;
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        long[] roots = new long[this.indexList.length * 2 + 1];
        int i = 0;
        for (index = 0; index < this.indexList.length; ++index) {
            CachedObject accessor = store.getAccessor(this.indexList[index]);
            roots[i++] = accessor == null ? -1L : (long)accessor.getPos();
        }
        for (index = 0; index < this.indexList.length; ++index) {
            roots[i++] = this.indexList[index].sizeUnique(store);
        }
        roots[i] = this.indexList[0].size(null, store);
        return roots;
    }

    public void setIndexRoots(long[] roots) {
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        int i = 0;
        for (int index = 0; index < this.indexList.length; ++index) {
            store.setAccessor(this.indexList[index], (int)roots[i++]);
        }
        long size = roots[this.indexList.length * 2];
        for (int index = 0; index < this.indexList.length; ++index) {
            store.setElementCount(this.indexList[index], size, roots[i++]);
        }
    }

    public void setIndexRoots(Session session, String s) {
        long v;
        int index;
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        ParserDQL p = new ParserDQL(session, new Scanner(s));
        long[] roots = new long[this.getIndexCount() * 2 + 1];
        p.read();
        int i = 0;
        for (index = 0; index < this.getIndexCount(); ++index) {
            v = p.readLong();
            roots[i++] = v;
        }
        try {
            for (index = 0; index < this.getIndexCount() + 1; ++index) {
                v = p.readLong();
                roots[i++] = v;
            }
        }
        catch (Exception e) {
            for (i = this.getIndexCount(); i < roots.length; ++i) {
                roots[i] = -1L;
            }
        }
        this.setIndexRoots(roots);
    }

    public Row insertSingleRow(Session session, PersistentStore store, Object[] data, int[] changedCols) {
        return this.insertSingleRow(session, store, data, changedCols, false);
    }

    public Row insertSingleRowForUpdate(Session session, PersistentStore store, Object[] data, int[] changedCols) {
        return this.insertSingleRow(session, store, data, changedCols, true);
    }

    protected Row insertSingleRow(Session session, PersistentStore store, Object[] data, int[] changedCols, boolean forUpdate) {
        if (this.identityColumn != -1) {
            this.setIdentityColumn(session, data);
        }
        if (this.hasGeneratedValues) {
            this.setGeneratedColumns(session, data);
        }
        if (this.hasDomainColumns || this.hasNotNullColumns) {
            this.enforceRowConstraints(session, data);
        }
        if (this.isView) {
            return null;
        }
        if (forUpdate && changedCols != null) {
            for (int i : changedCols) {
                if (!(data[i] instanceof OtherTypeWrapper)) continue;
                try {
                    data[i] = ((OtherTypeWrapper)data[i]).cloneForInsert(this.isMemory());
                }
                catch (JSerializerException exception) {
                    Trace.logException(this, exception, true);
                }
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                if (!(data[i] instanceof OtherTypeWrapper)) continue;
                try {
                    data[i] = ((OtherTypeWrapper)data[i]).cloneForInsert(this.isMemory());
                    continue;
                }
                catch (JSerializerException exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
        Row row = (Row)store.getNewCachedObject(session, data, true);
        if (forUpdate) {
            session.addInsertActionForUpdate(this, store, row, changedCols);
        } else {
            session.addInsertAction(this, store, row, changedCols);
        }
        return row;
    }

    public void insertIntoTable(Session session, Result result) {
        PersistentStore store = this.getRowStore(session);
        RowSetNavigator nav = result.initialiseNavigator();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            Object[] newData = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.columnCount);
            this.insertData(session, store, newData);
        }
    }

    public void insertNoCheckFromLog(Session session, Object[] data) {
        this.systemUpdateIdentityValue(data);
        PersistentStore store = this.getRowStore(session);
        Row row = (Row)store.getNewCachedObject(session, data, true);
        session.addInsertAction(this, store, row, null);
    }

    public int insertSys(Session session, PersistentStore store, Result ins) {
        RowSetNavigator nav = ins.getNavigator();
        int count = 0;
        while (nav.hasNext()) {
            this.insertSys(session, store, nav.getNext());
            ++count;
        }
        return count;
    }

    public void insertResult(Session session, PersistentStore store, Result ins) {
        RowSetNavigator nav = ins.initialiseNavigator();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            Object[] newData = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.columnCount);
            this.insertData(session, store, newData);
        }
    }

    public void insertFromScript(Session session, PersistentStore store, Object[] data) {
        this.systemUpdateIdentityValue(data);
        this.insertData(session, store, data);
    }

    public Row insertData(Session session, PersistentStore store, Object[] data) {
        Row row = (Row)store.getNewCachedObject(session, data, false);
        store.indexRow(session, row);
        return row;
    }

    public void insertSys(Session session, PersistentStore store, Object[] data) {
        Row row = (Row)store.getNewCachedObject(session, data, false);
        store.indexRow(session, row);
    }

    public void setIdentityColumn(Session session, Object[] data) {
        if (this.identityColumn != -1) {
            Number id = (Number)data[this.identityColumn];
            if (this.identitySequence.getObjectName() == null) {
                if (id == null) {
                    id = (Number)this.identitySequence.getValueObject();
                    data[this.identityColumn] = id;
                } else {
                    this.identitySequence.userUpdate(id.longValue());
                }
            } else if (id == null) {
                id = (Number)session.sessionData.getSequenceValue(this.identitySequence);
                data[this.identityColumn] = id;
            }
            if (session != null) {
                session.setLastIdentity(id);
            }
        }
    }

    public void setGeneratedColumns(Session session, Object[] data) {
        if (this.hasGeneratedValues) {
            for (int i = 0; i < this.colGenerated.length; ++i) {
                if (!this.colGenerated[i]) continue;
                Expression e = this.getColumn(i).getGeneratingExpression();
                RangeVariable.RangeIteratorBase range = session.sessionContext.getCheckIterator(this.defaultRanges[0]);
                range.currentData = data;
                data[i] = e.getValue(session, this.colTypes[i]);
            }
        }
    }

    public void systemSetIdentityColumn(Session session, Object[] data) {
        if (this.identityColumn != -1) {
            Number id = (Number)data[this.identityColumn];
            if (id == null) {
                id = (Number)this.identitySequence.getValueObject();
                data[this.identityColumn] = id;
            } else {
                this.identitySequence.userUpdate(id.longValue());
            }
        }
    }

    protected void systemUpdateIdentityValue(Object[] data) {
        Number id;
        if (this.identityColumn != -1 && (id = (Number)data[this.identityColumn]) != null) {
            this.identitySequence.systemUpdate(id.longValue());
        }
    }

    public Row getDeleteRowFromLog(Session session, Object[] data) {
        Row row = null;
        PersistentStore store = this.getRowStore(session);
        if (this.hasPrimaryKey()) {
            RowIterator it = this.getPrimaryIndex().findFirstRow(session, store, data, this.primaryKeyColsSequence);
            row = it.getNextRow();
            it.release();
        } else if (this.bestIndex == null || !this.bestIndex.isBuilt()) {
            RowIterator it = this.rowIterator(session);
            while ((row = it.getNextRow()) != null && Table.compareRows(session, row.getData(), data, this.defaultColumnMap, this.colTypes) != 0) {
            }
            it.release();
        } else {
            RowIterator it = this.bestIndex.findFirstRow(session, store, data);
            while ((row = it.getNextRow()) != null) {
                Object[] rowdata = row.getData();
                if (this.bestIndex.compareRowNonUnique(session, rowdata, data, this.bestIndex.getColumns()) != 0) {
                    row = null;
                    break;
                }
                if (Table.compareRows(session, rowdata, data, this.defaultColumnMap, this.colTypes) != 0) continue;
                break;
            }
            it.release();
        }
        return row;
    }

    public RowIterator rowIteratorClustered(Session session) {
        PersistentStore store = this.getRowStore(session);
        Index index = this.getClusteredIndex();
        if (index == null) {
            index = this.getPrimaryIndex();
        }
        return index.firstRow(session, store);
    }

    public RowIterator rowIteratorClustered(PersistentStore store) {
        Index index = this.getClusteredIndex();
        if (index == null) {
            index = this.getPrimaryIndex();
        }
        return index.firstRow(store);
    }

    @Override
    public void clearAllData(Session session) {
        super.clearAllData(session);
        if (this.identitySequence != null) {
            this.identitySequence.reset();
        }
    }

    @Override
    public void clearAllData(PersistentStore store) {
        super.clearAllData(store);
        if (this.identitySequence != null) {
            this.identitySequence.reset();
        }
    }

    @Override
    public PersistentStore getRowStore(Session session) {
        PersistentStore result = this.store;
        if (result == null) {
            result = this.isSessionBased ? session.sessionData.persistentStoreCollection.getStore(this) : this.database.persistentStoreCollection.getStore(this);
        }
        if (session.isTypesCheck()) {
            result = new PersistentStoreTypesCheckDelegate(result);
        }
        return result;
    }

    public SubQuery getSubQuery() {
        return null;
    }

    public QueryExpression getQueryExpression() {
        return null;
    }

    public final boolean hasForeignKey() {
        return this.colRefFK != null && this.colRefFK.length > 0;
    }

    public boolean isMemory() {
        return this.isMemory;
    }

    public boolean isSnapshot() {
        return this.getTableType() == 16;
    }

    public ReplicationSource getReplicationSource() {
        return this.replicationSource;
    }

    public void dropReplicationSource() {
        this.replicationSource = null;
    }

    public boolean isReplicated() {
        return this.replicationSource != null && this.replicationSource.isEnabled();
    }

    public RowMetaData getRowMetaData() {
        return Table.convertColumnListToRowMetaData(this.columnList);
    }

    public static RowMetaData convertColumnListToRowMetaData(HashMappedList columnList) {
        RowMetaData rowMetaData = new RowMetaData();
        for (int i = 0; i < columnList.size(); ++i) {
            ColumnSchema columnSchema = (ColumnSchema)columnList.get(i);
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(columnSchema.getNameString(), DataspaceTypeToSQLTypeConverter.convert(columnSchema.getDataType()), columnSchema.isNullable(), columnSchema.getDataType().getJDBCPrecision(), columnSchema.getDataType().getJDBCScale());
            columnDescriptor.setTypeName(columnSchema.getDataType().getNameString());
            rowMetaData.addColumn(columnDescriptor);
        }
        return rowMetaData;
    }

    public void addFullTextIndex(FullTextIndex index) {
        if (this.fullTextIndexes == null) {
            this.fullTextIndexes = new ArrayList<FullTextIndex>();
        }
        this.fullTextIndexes.add(index);
    }

    public void removeFullTextIndex(FullTextIndex index) {
        if (this.fullTextIndexes != null) {
            this.fullTextIndexes.remove(index);
        }
    }

    public List<FullTextIndex> getFullTextIndexes() {
        return this.fullTextIndexes;
    }
}

