/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.IndexSnapshot;
import com.streamscape.ds.persist.snapshot.RowStoreSnapshot;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.tspace.table.SnapshotCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.columns.TimeColumn;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.table.StorageManager;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileLinesReader;
import com.streamscape.lib.file.FileRecordsReader;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.local.LocalFileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;

public class SnapshotDataspaceTable
extends Table {
    private final SnapshotCollection parent;
    private SnapshotTable sTable;
    private String lastLoadedFrom;
    private String lastSavedTo;

    public SnapshotDataspaceTable(DataspaceStore database, NameManager.ObjectName name, SnapshotCollection parent) {
        super(database, name, 16);
        this.parent = parent;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        if (this.sTable == null) {
            this.compileSTable();
        }
    }

    public void compileSTable() {
        this.sTable = SnapshotTable.create(this.getObjectName().getSchemaQualifiedStatementName());
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema column = this.getColumn(i);
            this.sTable.addColumn(this.jdbcColumnToJColumn(column));
        }
        if (this.getPrimaryIndex() != null) {
            ((IndexSnapshot)this.getPrimaryIndex()).initSIndex();
            if (((IndexSnapshot)this.getPrimaryIndex()).getSIndex() != null) {
                ((IndexSnapshot)this.getPrimaryIndex()).getSIndex().build(((IndexSnapshot)this.getPrimaryIndex()).getTable().getSTable().getSelection());
            }
        }
    }

    @Override
    protected Row insertSingleRow(Session session, PersistentStore store, Object[] data, int[] changedCols, boolean forUpdate) {
        if (forUpdate) {
            throw new DataspaceException("Updates on snapshot table are not allowed.");
        }
        return this.insertData(session, store, data);
    }

    @Override
    public Row insertData(Session session, PersistentStore store, Object[] data) {
        ((RowStoreSnapshot)store).indexRowData(session, data);
        return null;
    }

    public void close() {
        this.sTable = null;
    }

    public void destroy() {
        this.sTable = null;
    }

    public Column jdbcColumnToJColumn(ColumnSchema column) {
        Column jcolumn = null;
        String columnName = column.getNameString();
        switch (column.getDataType().typeCode) {
            case 16: {
                jcolumn = BooleanColumn.create(columnName);
                break;
            }
            case 1: 
            case 12: 
            case 1112: {
                jcolumn = StringColumn.create(columnName);
                break;
            }
            case 1121: {
                jcolumn = CategoryColumn.create(columnName);
                break;
            }
            case -6: 
            case 5: {
                jcolumn = ShortColumn.create(columnName);
                break;
            }
            case 4: {
                jcolumn = IntColumn.create(columnName);
                break;
            }
            case 2: 
            case 25: 
            case 1117: {
                jcolumn = LongColumn.create(columnName);
                break;
            }
            case 3: {
                jcolumn = DecimalColumn.create(columnName, column.getDataType().getJDBCPrecision(), column.getDataType().getJDBCScale());
                break;
            }
            case 6: {
                jcolumn = FloatColumn.create(columnName);
                break;
            }
            case 7: 
            case 8: {
                jcolumn = DoubleColumn.create(columnName);
                break;
            }
            case 91: {
                jcolumn = DateColumn.create(columnName);
                break;
            }
            case 92: {
                jcolumn = TimeColumn.create(columnName);
                break;
            }
            case 93: {
                jcolumn = DateTimeColumn.create(columnName);
                break;
            }
            default: {
                throw new DataspaceException("Type '" + column.getDataType().getNameString() + "' is not supported by snapshot table. Only primitive types are supported.");
            }
        }
        return jcolumn;
    }

    public SnapshotTable getSTable() {
        return this.sTable;
    }

    public void materializeFrom(Session session, String filepath, boolean fromDelimitedFile, boolean force, boolean merge) {
        if (fromDelimitedFile && this.parent.getFileDescriptor() == null) {
            throw new DataspaceException("Snapshot from delimited file is allowed for file descriptor based snapshot tables.");
        }
        String[] filepathTmp = new String[]{filepath};
        try (FileSystem fileSystem = SessionData.createFileSystem(session, filepathTmp);){
            String filepathDirectory;
            String string = filepathDirectory = force ? filepathTmp[0] : StorageManager.buildDirectoryPath(fileSystem, filepathTmp[0], this.sTable.name());
            if (this.parent.getFileDescriptor() != null) {
                if (fileSystem.exists(filepathDirectory) && fileSystem.isDirectory(filepathDirectory) || !fromDelimitedFile) {
                    this.materializeFromSnap(fileSystem, filepathDirectory, force, merge);
                } else {
                    this.materializeFromFileDescriptor(fileSystem, session, filepath);
                }
            } else {
                this.materializeFromSnap(fileSystem, filepathDirectory, force, merge);
            }
            this.lastLoadedFrom = filepath;
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to load snap table '" + this.getObjectName().getSchemaQualifiedStatementName() + "' from folder '" + filepath + "'.", exception);
        }
    }

    private void materializeFromFileDescriptor(FileSystem fileSystem, Session session, String filepath) {
        this.materializeFromFileDescriptor(fileSystem, session, filepath, this.parent.getFileDescriptor());
    }

    private void materializeFromFileDescriptor(FileSystem fileSystem, final Session session, String filepath, FileDescriptor fileDescriptor) {
        try {
            if (!fileSystem.exists(filepath)) {
                throw new DataspaceException("File on specified path '" + filepath + "' doesn't exist.");
            }
            if (!fileSystem.isFile(filepath)) {
                throw new DataspaceException("File on specified path '" + filepath + "' is not a file.");
            }
        }
        catch (Throwable e2) {
            throw Error.error(467, e2.toString());
        }
        FileDescriptorFactory factory = new FileDescriptorFactory();
        factory.init(fileDescriptor, DataspaceStoreManager.getRuntimeContext().getSystemClassLoaderChain(), DataspaceStoreManager.getRuntimeContext());
        FileRecordsReader reader = factory.createFileRecordsReader();
        reader.setRecordListener(new FileDescriptorFactory.RecordListener(){

            @Override
            public void onRecord(Object recordObject, AbstractRecordTypeDefinition recordDefinition) {
                ArrayList row = (ArrayList)recordObject;
                if (row.size() != SnapshotDataspaceTable.this.sTable.columnCount()) {
                    throw new DataspaceException("Column count mismatch. Expected '" + SnapshotDataspaceTable.this.sTable.columnCount() + "' but received '" + row.size() + "'.");
                }
                block5: for (int i = 0; i < row.size(); ++i) {
                    Object value = row.get(i);
                    Column column = SnapshotDataspaceTable.this.sTable.column(i);
                    if (value == null || value instanceof String) {
                        column.appendObject((String)value);
                        continue;
                    }
                    switch (column.type()) {
                        case LOCAL_DATE: {
                            long millis;
                            if (value instanceof Date) {
                                millis = ((TimestampData)Type.SQL_DATE.convertJavaToSQL(session, value)).getMilliseconds();
                                ((DateColumn)column).append(millis);
                                continue block5;
                            }
                            column.appendObject(String.valueOf(value));
                            continue block5;
                        }
                        case LOCAL_DATE_TIME: {
                            long millis;
                            if (value instanceof Timestamp) {
                                millis = ((TimestampData)Type.SQL_TIMESTAMP.convertJavaToSQL(session, value)).getMilliseconds();
                                ((DateTimeColumn)column).append(millis);
                                continue block5;
                            }
                            column.appendObject(String.valueOf(value));
                            continue block5;
                        }
                        case LOCAL_TIME: {
                            long millis;
                            if (value instanceof Time) {
                                millis = ((TimestampData)Type.SQL_TIME.convertJavaToSQL(session, value)).getMilliseconds();
                                ((TimeColumn)column).append(millis);
                                continue block5;
                            }
                            column.appendObject(String.valueOf(value));
                        }
                    }
                }
            }

            @Override
            public void onGroupRecord(Object recordObject, String type, String key) {
            }
        });
        reader.setExceptionStrategy(e -> {
            throw Error.error(467, e.toString());
        });
        try (InputStream inputStream = fileSystem.open(filepath);){
            FileLinesReader fileLinesReader = factory.createFileLinesReader(new BufferedInputStream(inputStream), null, true);
            reader.readSingleFile(fileLinesReader);
        }
        catch (Throwable e3) {
            throw Error.error(467, e3.toString());
        }
    }

    private void materializeFromSnap(FileSystem fileSystem, String filepath, boolean force, boolean merge) {
        try {
            SnapshotTable readTable = StorageManager.readTable(fileSystem, filepath, this.sTable, force);
            if (merge && this.sTable != null) {
                this.sTable.appendWithRollback(readTable);
            } else {
                this.sTable = readTable;
            }
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to read snap table '" + this.getObjectName().getSchemaQualifiedStatementName() + "' from folder '" + filepath + "'.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void materializeFrom(Session session, Collection collection) {
        Table table = collection.getBaseTable();
        if (table.columnCount != this.columnCount) {
            throw Error.error(3201, new Object[]{"snapshot expects '" + this.columnCount + "', but from table has '" + table.columnCount + "' columns."});
        }
        if (table instanceof FileTable && table.isConnected() && ((FileTable)table).getDataSource() != null && ((FileTable)table).getFileServer() == null) {
            String fileName = ((FileTable)table).getFileTableSettings(((FileTable)table).getDataSource()).getFileName();
            if (this.parent.getFileDescriptor() != null) {
                this.materializeFromFileDescriptor(new LocalFileSystem(), session, fileName);
                return;
            }
            if (((FileTable)table).getFileDescriptor() != null) {
                this.materializeFromFileDescriptor(new LocalFileSystem(), session, fileName, ((FileTable)table).getFileDescriptor());
                return;
            }
        }
        RowIterator iterator = table.rowIterator(session);
        this.store.writeLock();
        try {
            while (iterator.hasNext()) {
                Object[] row = iterator.getNext();
                ((RowStoreSnapshot)this.store).appendRowDataNoLock(session, row);
            }
        }
        finally {
            this.store.writeUnlock();
        }
    }

    public void materializeTo(Session session, String filepath, int generation) {
        String[] filepathTmp = new String[]{filepath};
        try (FileSystem fileSystem = SessionData.createFileSystem(session, filepathTmp);){
            filepath = filepathTmp[0];
            String directoryPath = StorageManager.buildDirectoryPath(fileSystem, filepath, this.sTable.name());
            String directoryPathTmp = directoryPath + "." + UUID.randomUUID().toString();
            StorageManager.saveTable(fileSystem, directoryPathTmp, this.sTable);
            if (fileSystem.exists(directoryPath)) {
                if (generation > 0) {
                    int maxGeneration = fileSystem.list(filepath).stream().filter(i -> i.isDirectory()).map(i -> {
                        try {
                            return Integer.valueOf(i.getName().substring(i.getName().lastIndexOf(".") + 1));
                        }
                        catch (Exception exception) {
                            return 0;
                        }
                    }).max(Integer::compare).orElse(0);
                    int nextGeneration = maxGeneration + generation;
                    FileIOUtils.renameDirectory(fileSystem, directoryPath, directoryPath + "." + nextGeneration);
                } else {
                    fileSystem.delete(directoryPath, true);
                }
            }
            FileIOUtils.renameDirectory(fileSystem, directoryPathTmp, directoryPath);
            this.lastSavedTo = filepath;
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed to store snap table '" + this.getObjectName().getSchemaQualifiedStatementName() + "' to folder '" + filepath + "'.", exception);
        }
    }

    @Override
    public Index dropIndex(int todrop) {
        Index index = super.dropIndex(todrop);
        if (index != null) {
            this.sTable.removeSIndex(index.getObjectName().getNameString());
        }
        return index;
    }

    public String getLastLoadedFrom() {
        return this.lastLoadedFrom;
    }

    public String getLastSavedTo() {
        return this.lastSavedTo;
    }

    public SnapshotCollection getParent() {
        return this.parent;
    }

    public void setsTable(SnapshotTable sTable) {
        this.sTable = sTable;
    }

    @Override
    public void setDataReadOnly(boolean value) {
        super.setDataReadOnly(value);
        if (value && this.sTable != null) {
            this.sTable.trimToSize();
        }
    }
}

