/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.jfq.FileQueueFilenameProvider;
import com.streamscape.ds.persist.jfq.FileQueueFilesDirectoryProvider;
import com.streamscape.ds.persist.jfq.FileQueueFilesManager;
import com.streamscape.ds.persist.jfq.FileQueueRowTypesKeysHolder;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistent;
import com.streamscape.ds.persist.jfq.IndexJFQ;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileQueueCollection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.utils.Utils;
import java.util.regex.Pattern;

public class JournalFileQueueTable
extends Table {
    private final JournalFileQueueCollection parent;
    private String fileDirectoryPath = "jfq";
    private long maxFileSizeBytes;
    private long writeFlushTimeout = 1000L;
    private long writeBufferSizeBytes = 16384L;
    private FileQueueTransactionFilePersistent.TransactionPersistentType transactionPersistentType = FileQueueTransactionFilePersistent.TransactionPersistentType.NONE;
    private FileQueueFilenameProvider filenameProvider;
    private FileQueueFilesManager filesManager;

    public JournalFileQueueTable(DataspaceStore database, NameManager.ObjectName name, JournalFileQueueCollection parent) {
        super(database, name, 15);
        this.parent = parent;
        this.isReadOnly = true;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        try {
            FileQueueFilesDirectoryProvider fileQueueFilesDirectoryProvider = new FileQueueFilesDirectoryProvider(session.dataspaceStore.dataspaceLocation, this.fileDirectoryPath + "/" + FileQueueFilenameProvider.escapeFilename(this.getObjectName().schema.getStatementName()));
            fileQueueFilesDirectoryProvider.init();
            FileQueueRowTypesKeysHolder typesKeyHolder = new FileQueueRowTypesKeysHolder(this.getColumnTypes());
            for (Index index : this.indexList) {
                typesKeyHolder.addKey(index.getColumns(), index.isUnique());
            }
            this.filesManager = new FileQueueFilesManager(fileQueueFilesDirectoryProvider, this.filenameProvider != null ? this.filenameProvider : new JournalFileQueueTableFilenameProvider(this.getObjectName()), typesKeyHolder);
            this.filesManager.setMaxFileSizeBytes(this.maxFileSizeBytes);
            this.filesManager.setTransactionPersistentType(this.transactionPersistentType);
            this.filesManager.setFlushTimeout(this.writeFlushTimeout);
            this.filesManager.setWriteBufferSizeBytes(this.writeBufferSizeBytes);
            this.filesManager.init();
            for (Index index : this.indexList) {
                ((IndexJFQ)index).init(this.filesManager);
            }
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed to initialize queue files manager. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    public void close() {
        if (this.filesManager != null) {
            this.filesManager.close();
        }
    }

    public void destroy() {
        if (this.filesManager != null) {
            this.filesManager.deleteAll();
        }
    }

    public String getFileDirectoryPath() {
        return this.fileDirectoryPath;
    }

    public void setFileDirectoryPath(String fileDirectoryPath) {
        this.fileDirectoryPath = fileDirectoryPath;
    }

    public long getMaxFileSizeBytes() {
        return this.maxFileSizeBytes;
    }

    public void setMaxFileSizeBytes(long maxFileSizeBytes) {
        this.maxFileSizeBytes = maxFileSizeBytes;
    }

    public long getWriteFlushTimeout() {
        return this.writeFlushTimeout;
    }

    public void setWriteFlushTimeout(long flushTimeout) {
        this.writeFlushTimeout = flushTimeout;
    }

    public long getWriteBufferSizeBytes() {
        return this.writeBufferSizeBytes;
    }

    public void setWriteBufferSizeBytes(long writeBufferSizeBytes) {
        this.writeBufferSizeBytes = writeBufferSizeBytes;
    }

    public FileQueueTransactionFilePersistent.TransactionPersistentType getTransactionPersistentType() {
        return this.transactionPersistentType;
    }

    public void setTransactionPersistentType(FileQueueTransactionFilePersistent.TransactionPersistentType transactionPersistentType) {
        this.transactionPersistentType = transactionPersistentType;
    }

    public FileQueueFilenameProvider getFilenameProvider() {
        return this.filenameProvider;
    }

    public void setFilenameProvider(FileQueueFilenameProvider filenameProvider) {
        this.filenameProvider = filenameProvider;
    }

    public FileQueueFilesManager getFilesManager() {
        return this.filesManager;
    }

    public static class JournalFileQueueTableFilenameProvider
    implements FileQueueFilenameProvider {
        private final String baseFilename;
        private final String filenamePattern;
        private static final String FILE_EXTENSION = "jfq";

        public JournalFileQueueTableFilenameProvider(NameManager.ObjectName name) {
            this(name.name);
        }

        public JournalFileQueueTableFilenameProvider(String name) {
            this.baseFilename = FileQueueFilenameProvider.escapeFilename(name) + "_";
            this.filenamePattern = Pattern.quote(this.baseFilename) + "(\\d*)\\.jfq";
        }

        @Override
        public String buildBaseFilename() {
            return this.baseFilename;
        }

        @Override
        public String getNextFilename() {
            return this.baseFilename + System.currentTimeMillis() + ".jfq";
        }

        @Override
        public String getFilenamePattern() {
            return this.filenamePattern;
        }
    }
}

