/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.persist.ExternalFileTableIOManager;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.FileTableIOManager;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAVLDiskData;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableCollection;
import com.streamscape.ds.schema.collection.stream.SourceStreamProvider;
import com.streamscape.ds.schema.server.FileServerObject;
import com.streamscape.ds.schema.table.AppendableFileTableReader;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.advisory.JournalFileTableStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.tools.lexer.BufferUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class FileTable
extends Table
implements SourceStreamProvider {
    String dataSource = "";
    boolean isConnected = false;
    boolean isForStream = false;
    boolean isCompressed = false;
    boolean isForAppend = false;
    long checkInterval = -1L;
    private boolean suspendOnFail;
    int ignoreFirstLines = 0;
    private FileDescriptor fileDescriptor;
    private FileDescriptor fileDescriptorOrig;
    private String fileDescriptorName;
    private boolean typesOnly;
    private List<String> recordTypes;
    private FileTableIOManager ioManager = null;
    private long nextPosForStream = 0L;
    private FileTableCollection parent = null;
    private FileServerObject fileServer = null;
    private AppendableFileTableReader appendableFileTableReader;
    private final ReentrantLock appendableFileTableReaderLock = new ReentrantLock();
    private AppendableFileTableReader.AppendableFileTableReaderReplicationListener appendableFileTableReaderReplicationListener;

    public FileTable(DataspaceStore db, NameManager.ObjectName name, int type) {
        this(db, name, type, null);
    }

    public FileTable(DataspaceStore db, NameManager.ObjectName name, int type, FileTableCollection parent) {
        super(db, name, type);
        this.parent = parent;
    }

    public boolean isForAppend() {
        return this.isForAppend;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void connect(Session session) {
        this.connect(session, this.isReadOnly);
    }

    public void connect(Session session, boolean readOnly) {
        this.connect(session, readOnly, false);
    }

    public void connect(Session session, boolean readOnly, boolean isForStream) {
        this.connect(session, readOnly, isForStream, this.isForAppend, this.checkInterval);
    }

    public void connect(Session session, boolean isReadOnly, boolean isForStream, boolean isForAppend) {
        this.connect(session, isReadOnly, isForStream, isForAppend, this.checkInterval);
    }

    public void connect(Session session, boolean isReadOnly, boolean isForStream, boolean isForAppend, long checkInterval) {
        PersistentStore store;
        if (this.isConnected) {
            throw new DataspaceException("File table already linked. Unlink first.");
        }
        if (this.dataSource.length() == 0) {
            return;
        }
        if (isForStream && isForAppend) {
            throw new DataspaceException("File table can not be linked in 'for stream' and 'for append' mode simultaneously.");
        }
        this.store = store = this.database.persistentStoreCollection.getStore(this);
        this.store.resetAccessorKeys(this.indexList);
        FileTableCache cache = null;
        try {
            String realSource = new MacroProcessor().process(this.dataSource);
            cache = (FileTableCache)this.database.dataspaceLogger.openTextFilePersistence(this, realSource, isReadOnly, this.fileServer, isForAppend);
            store.setCache(cache);
            this.isCompressed = cache.isFileCompressed();
            this.ioManager = cache.getIOManager();
            this.ioManager.reset();
            this.ioManager.setForStream(isForStream ? true : this.isForStream);
            long nextpos = this.ioManager.readMagic();
            this.ignoreFirstLines = cache.getIgnoreFirstLines();
            if (this.ignoreFirstLines <= 0 && cache.isIgnoreFirstLine()) {
                this.ignoreFirstLines = 1;
            }
            if (this.ignoreFirstLines > 0) {
                nextpos += (long)this.ioManager.readHeaderLines(this.ignoreFirstLines);
                cache.setHeaderInitialise(this.ioManager.getHeaderLine());
            }
            this.isConnected = true;
            if (isForStream) {
                this.nextPosForStream = nextpos;
            } else if (isForAppend) {
                if (checkInterval <= 0L) {
                    checkInterval = 500L;
                }
                this.appendableFileTableReader = new AppendableFileTableReader(this.parent, this.ioManager, nextpos, store, checkInterval, this.suspendOnFail);
                if (!session.isProcessingLog() && !session.isProcessingRecoveryLog()) {
                    this.isForAppend = isForAppend;
                    this.startAppendableFileTableReader(session);
                }
            } else {
                while (true) {
                    Row row;
                    Session.checkIfThreadIsInterrupted();
                    RowInputInterface rowIn = this.ioManager.readNextRow(nextpos);
                    nextpos = this.ioManager.getLastPos();
                    if (rowIn == null || (row = (Row)store.get(rowIn)) == null) break;
                    Object[] data = row.getData();
                    nextpos += (long)row.getStorageSize();
                    this.systemUpdateIdentityValue(data);
                    this.enforceRowConstraints(session, data);
                    store.indexRow(session, row);
                    try {
                        this.fireTriggers(session, Trigger.Type.INSERT_AFTER_ROW, null, data, null);
                        session.commit(true);
                    }
                    catch (Exception exception) {}
                }
                this.ioManager.setFileFreePosition(nextpos);
            }
        }
        catch (Throwable exception) {
            this.logError("Connection to source failed.");
            Trace.logException(this, exception, false);
            this.isConnected = false;
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            if (this.appendableFileTableReader != null) {
                this.appendableFileTableReader.stop();
            }
            int linenumber = this.ioManager == null ? 0 : this.ioManager.getLineNumber();
            this.clearAllData(session);
            if (cache != null) {
                this.database.dataspaceLogger.closeTextCache(this);
                store.release();
            }
            throw Error.error(exception, 483, 0, new Object[]{new Integer(linenumber), exception.getMessage()});
        }
        this.isForAppend = isForAppend;
        this.checkInterval = checkInterval;
        this.isForStream = isForStream;
        this.isReadOnly = isReadOnly;
        if (this.parent != null && !this.isReadOnly) {
            this.parent.checkStatements(session);
        }
    }

    public void startAppendableFileTableReader(Session session) {
        block12: {
            this.appendableFileTableReaderLock.lock();
            try {
                if (!this.isForAppend) {
                    return;
                }
                if (!this.isConnected()) {
                    return;
                }
                if (this.appendableFileTableReader.isStarted()) break block12;
                if (this.parent instanceof JournalFileTableCollection) {
                    ((JournalFileTableCollection)this.parent).initSeqId(session);
                    if (((JournalFileTableCollection)this.parent).getProcessingStrategy(session) == JournalFileTableCollection.ProcessingStrategy.NO_RECOVERY) {
                        try {
                            this.appendableFileTableReader.setSkipSize(this.ioManager.getFileLength());
                            this.logInfo("Staring JFT from end of file, position " + this.appendableFileTableReader.getStatistics().getSkipSize() + ".");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                Session session1 = this.database.getSessionManager().newSession(this.database, session.getUser(), false, true);
                session1.dataspaceStore = this.database;
                session1.setCurrentDataspaceName(this.getObjectName().schema);
                this.appendableFileTableReader.setSession(session1);
                this.appendableFileTableReader.start();
                if (this.parent instanceof JournalFileTableCollection) {
                    this.logInfo("Journal file table has been started.");
                    ((JournalFileTableCollection)this.parent).raiseJournalFileTableStateChangeAdvisory(JournalFileTableStateChangeAdvisory.JFTState.STARTED, null);
                }
            }
            finally {
                this.appendableFileTableReaderLock.unlock();
            }
        }
    }

    public void compress(Session session) {
        if (!this.isConnected) {
            throw new DataspaceException("File table is not connected to its source.");
        }
        if (this.isCompressed) {
            throw new DataspaceException("Collection already compressed.");
        }
        FileTableCache cache = (FileTableCache)this.store.getCache();
        String convertedFileName = cache.getConvertedFileName();
        cache.getIOManager().convert(convertedFileName, cache);
        this.disconnect();
        cache.replaceDataFile(convertedFileName);
        this.connect(session);
        this.isCompressed = true;
    }

    public void decompress(Session session) {
        if (!this.isConnected) {
            throw new DataspaceException("File table is not connected to its source.");
        }
        if (!this.isCompressed) {
            throw new DataspaceException("Collection is not compressed.");
        }
        FileTableCache cache = (FileTableCache)this.store.getCache();
        String convertedFileName = cache.getConvertedFileName();
        cache.getIOManager().convert(convertedFileName, cache);
        this.disconnect();
        cache.replaceDataFile(convertedFileName);
        this.connect(session);
        this.isCompressed = false;
    }

    public void disconnect() {
        this.appendableFileTableReaderLock.lock();
        try {
            if (this.appendableFileTableReader != null) {
                this.appendableFileTableReader.stop();
            }
            this.store = null;
            PersistentStore store = this.database.persistentStoreCollection.getStore(this);
            if (store != null) {
                if (store.getCache() != null) {
                    store.getCache().close(true);
                }
                store.removeAll();
                store.release();
            }
            if (this.ioManager != null) {
                this.ioManager = null;
            }
            this.isConnected = false;
        }
        finally {
            this.appendableFileTableReaderLock.unlock();
        }
    }

    public void setDataSource(Session session, String dataSource) {
        if (this.getTableType() != 7) {
            session.getGrantee().checkSchemaUpdateOrGrantRights(this.getSchemaName().name);
        }
        String string = dataSource = dataSource != null ? dataSource.trim() : "";
        if (this.dataSource.equals(dataSource) && this.isConnected) {
            return;
        }
        if (this.isConnected) {
            throw new DataspaceException("Table is linked. Unlink first.");
        }
        this.dataSource = dataSource;
        this.dataSource = BufferUtils.replaceSpecialCharsBackward(dataSource);
    }

    public void setFileServer(FileServerObject fileServer) {
        this.fileServer = fileServer;
    }

    public FileServerObject getFileServer() {
        return this.fileServer;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setHeader(String header) {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        FileTableCache cache = (FileTableCache)store.getCache();
        if (cache != null && cache.isIgnoreFirstLine()) {
            cache.setHeader(header);
            return;
        }
        throw Error.error(486);
    }

    public String getHeader() {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        FileTableCache cache = (FileTableCache)store.getCache();
        String header = cache == null ? null : cache.getHeader();
        return header == null ? null : StringConverter.toQuotedString(header, '\'', true);
    }

    @Override
    public void checkDataReadOnly() {
        if (this.dataSource.length() == 0) {
            throw Error.error(481);
        }
        if (this.isReadOnly) {
            throw Error.error(456);
        }
    }

    @Override
    public boolean isDataReadOnly() {
        return !this.isConnected() || super.isDataReadOnly() || this.store.getCache().isDataReadOnly();
    }

    @Override
    public void setDataReadOnly(boolean value) {
        if (!value) {
            if (this.database.isFilesReadOnly()) {
                throw Error.error(455);
            }
            if (this.isConnected()) {
                this.store.getCache().close(true);
                this.store.getCache().open(value);
            }
        }
        this.isReadOnly = value;
    }

    @Override
    boolean isIndexCached() {
        return false;
    }

    void setIndexRoots(String s) {
    }

    public String getDataSourceDDL() {
        String dataSource = this.getDataSource();
        if (dataSource == null) {
            return null;
        }
        if (this.parent instanceof JournalFileTableCollection) {
            if (this.isConnected) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("START").append(' ').append("JOURNAL").append(' ').append("FILE").append(' ').append("TABLE");
                buffer.append(' ').append(this.getObjectName().getSchemaQualifiedStatementName());
                if (this.parent instanceof JournalFileTableCollection && this.appendableFileTableReader != null && ((JournalFileTableCollection)this.parent).isSuspendOnFail()) {
                    buffer.append(" SUSPEND ON FAIL");
                }
                return buffer.toString();
            }
            return null;
        }
        StringBuilder builder = new StringBuilder(128);
        builder.append("LINK").append(' ').append("FILE").append(' ').append("TABLE").append(' ');
        builder.append(this.getObjectName().getSchemaQualifiedStatementName());
        builder.append(' ').append("SOURCE").append(' ').append('\'');
        builder.append(dataSource);
        builder.append('\'');
        if (this.isForStream) {
            builder.append(' ').append("FOR").append(' ').append("STREAM");
        }
        if (this.isForAppend) {
            builder.append(' ').append("FOR").append(' ').append("APPEND");
            if (this.checkInterval > 0L) {
                builder.append(' ').append("WITH").append(' ').append("CHECK").append(' ').append("INTERVAL").append(' ').append(this.checkInterval);
            }
        }
        return builder.toString();
    }

    @Override
    public void initForStreaming() {
        if (this.ioManager == null) {
            throw new DataspaceException("Unable to stream unlinked file table.");
        }
        try {
            this.ioManager.reset();
            this.nextPosForStream = this.ioManager.readMagic();
            if (this.ignoreFirstLines > 0) {
                this.nextPosForStream += (long)this.ioManager.readHeaderLines(this.ignoreFirstLines);
            }
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed to read header. Cause: " + exception.getMessage());
        }
    }

    @Override
    public Object getNextRowForStream() {
        try {
            RowInputInterface rowIn = this.ioManager.readNextRow(this.nextPosForStream);
            this.nextPosForStream = this.ioManager.getLastPos();
            if (rowIn != null) {
                this.nextPosForStream += (long)rowIn.getSize();
            }
            return rowIn;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            return null;
        }
    }

    @Override
    public Object[] materializeRowForStream(Session session, Object rowParser, Object row) {
        try {
            Object[] data = RowAVLDiskData.getRowData(this, (RowInputInterface)rowParser);
            return SqlUtils.convertSqlToJava(session, data, this.getColumnTypes());
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            return null;
        }
    }

    @Override
    public Object createRowParser() {
        if (this.store != null) {
            FileTableCache cache = (FileTableCache)this.store.getCache();
            return cache.createRowInputObject();
        }
        return null;
    }

    @Override
    public void initParserWithRow(Object parser, Object row) {
        AbstractRowInputText rowObject = (AbstractRowInputText)row;
        ((AbstractRowInputText)parser).setSource(rowObject.getText(), rowObject.getPos(), rowObject.getSize());
    }

    String getDataSourceHeader() {
        String header = this.getHeader();
        if (header == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(128);
        builder.append("SET").append(' ').append("TABLE").append(' ');
        builder.append(this.getObjectName().getSchemaQualifiedStatementName());
        builder.append(' ').append("SOURCE").append(' ');
        builder.append("HEADER").append(' ');
        builder.append(header);
        return builder.toString();
    }

    @Override
    public Row insertData(Session session, PersistentStore store, Object[] data) {
        if (!this.isConnected) {
            throw new DataspaceException("File table is not linked.");
        }
        Row row = (Row)store.getNewCachedObject(session, data, false);
        store.indexRow(session, row);
        store.commitPersistence(row);
        return row;
    }

    public boolean existsDataSource() {
        block5: {
            if (this.dataSource == null || this.dataSource.length() == 0) {
                return true;
            }
            String resolvedDataSource = new MacroProcessor().process(this.dataSource);
            if (this.fileServer == null) {
                resolvedDataSource = this.getFileTableSettings(null).getFileName();
                Path resolvedDataSourcePath = Paths.get(resolvedDataSource, new String[0]);
                return Files.isRegularFile(resolvedDataSourcePath, new LinkOption[0]) && Files.isReadable(resolvedDataSourcePath) && Files.exists(resolvedDataSourcePath, new LinkOption[0]);
            }
            if ((ExternalFileTableIOManager)this.ioManager != null && ((ExternalFileTableIOManager)this.ioManager).getExternalFileTableCache() != null) {
                FileSystem fs = ((ExternalFileTableIOManager)this.ioManager).getExternalFileTableCache().getFileSystem();
                try {
                    resolvedDataSource = this.getFileTableSettings(null).getFileName();
                    return fs != null && fs.exists(resolvedDataSource);
                }
                catch (IOException exception) {
                    Trace.logException(this, exception, false);
                    if (!Trace.isDebugEnabled(this.getClass())) break block5;
                    Trace.logException(this, exception, true);
                }
            }
        }
        return false;
    }

    public ConnectionState getConnectionState() {
        if (this.fileServer != null) {
            ClientConnection connection;
            if ((ExternalFileTableIOManager)this.ioManager != null && ((ExternalFileTableIOManager)this.ioManager).getExternalFileTableCache() != null && (connection = ((ExternalFileTableIOManager)this.ioManager).getExternalFileTableCache().getConnection()) != null) {
                return connection.getState();
            }
            return ConnectionState.CLOSED;
        }
        return ConnectionState.OPEN;
    }

    public void setFileDescriptorName(String fileDescriptorName) {
        this.fileDescriptorName = fileDescriptorName;
        this.fileDescriptor = null;
        this.fileDescriptorOrig = null;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public String getFileDescriptorName() {
        return this.fileDescriptorName;
    }

    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    public void setRecordTypes(List<String> recordTypes) {
        this.recordTypes = recordTypes;
    }

    public List<String> getRecordTypes() {
        return this.recordTypes;
    }

    public FileDescriptor getFileDescriptor() {
        if (this.fileDescriptorName == null) {
            return null;
        }
        if (this.fileDescriptor != null) {
            return this.fileDescriptor;
        }
        this.fileDescriptor = FileTable.getFileDescriptor(this.fileDescriptorName);
        this.fileDescriptorOrig = FileTable.getFileDescriptor(this.fileDescriptorName);
        return this.fileDescriptor;
    }

    public FileDescriptor getFileDescriptorOrig() {
        this.getFileDescriptor();
        return this.fileDescriptorOrig;
    }

    public static FileDescriptor getFileDescriptor(String fileDescriptorName) {
        try {
            FileDescriptor fileDescriptor = FileDescriptorRepositoryUtils.lookupFileDescriptor(fileDescriptorName);
            if (fileDescriptor == null) {
                throw new DataspaceException("File descriptor '" + fileDescriptorName + "' doesn't exist.");
            }
            return fileDescriptor;
        }
        catch (ObjectConfigurationException exception) {
            throw new DataspaceException("Failed to access repository. Cause: " + exception.getMessage());
        }
    }

    public FileDescriptorFactory getFileDescriptorProcessorFactory() {
        if (this.getFileDescriptor() != null) {
            FileDescriptorFactory factory = new FileDescriptorFactory();
            FileTableSettings settings = this.getFileTableSettings(null);
            factory.getFormatterFactory().setDateFormat(settings.dateFormat);
            factory.getFormatterFactory().setSqlDateFormat(settings.sqlDateFormat);
            factory.getFormatterFactory().setSqlTimeFormat(settings.sqlTimeFormat);
            factory.getFormatterFactory().setSqlTimestampFormat(settings.sqlTimestampFormat);
            factory.init(this.getFileDescriptor(), DataspaceStoreManager.getRuntimeContext().getSystemClassLoaderChain(), DataspaceStoreManager.getRuntimeContext());
            if (this.recordTypes != null && this.recordTypes.size() > 0) {
                factory.setObservableRecordTypes(this.recordTypes);
            } else if (!this.typesOnly) {
                String key = this.fileDescriptor.getRecords().get(0).getTypeKey();
                if (key == null) {
                    key = "";
                }
                factory.setObservableRecordType(key);
            }
            return factory;
        }
        throw new DataspaceException("File table is not constrained by file descriptor.");
    }

    @Override
    public String getSQL() {
        return super.getSQL();
    }

    @Override
    protected void appendExternalServerInfo(StringBuffer sb) {
        if (this.fileServer != null) {
            sb.append(' ').append("AT").append(' ').append(this.fileServer.getObjectName().getSchemaQualifiedStatementName()).append(' ');
        }
    }

    public void checkOperation(int type) {
        if (this.fileServer != null && type != 50 && type != 85) {
            throw new DataspaceException("External file table read and insert to the end operations only.");
        }
    }

    public AppendableFileTableReader.Statistics getAppendableStatistics() {
        return this.appendableFileTableReader != null ? this.appendableFileTableReader.getStatistics() : null;
    }

    public void fireMalformedDataTrigger(Session session, String rowText, Object[] data, Exception exception) {
        this.fireTriggers(session, Trigger.Type.AFTER_MALFORMED_DATA, new Object[]{rowText}, data, null);
    }

    public void setCheckInterval(Session session, Long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setForAppend(boolean forAppend) {
        this.isForAppend = forAppend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void truncate(Session session, boolean force) {
        if (this.isForAppend()) {
            this.appendableFileTableReaderLock.lock();
            try {
                if (this.appendableFileTableReader != null) {
                    this.appendableFileTableReader.truncateLock();
                }
                try {
                    if (this.appendableFileTableReader != null) {
                        this.appendableFileTableReader.truncate(force);
                    }
                    if (!(this.parent instanceof JournalFileTableCollection)) return;
                    ((JournalFileTableCollection)this.parent).onTruncate(session);
                    return;
                }
                finally {
                    if (this.appendableFileTableReader != null) {
                        this.appendableFileTableReader.truncateUnlock();
                    }
                }
            }
            finally {
                this.appendableFileTableReaderLock.unlock();
            }
        } else {
            if (this.isConnected) {
                if (this.ioManager != null) {
                    this.ioManager.truncate();
                }
                if (this.store != null) {
                    this.store.removeAll();
                    this.store.getCache().clear();
                }
            }
            if (!(this.parent instanceof JournalFileTableCollection)) return;
            ((JournalFileTableCollection)this.parent).onTruncate(session);
        }
    }

    public FileTableCollection getParent() {
        return this.parent;
    }

    public FileTableSettings getFileTableSettings(String fileName) {
        if (fileName == null) {
            fileName = this.dataSource;
            if (fileName == null) {
                fileName = "";
            }
            fileName = new MacroProcessor().process(fileName);
        }
        return new FileTableSettings(this.database, fileName, this.getFileDescriptor());
    }

    public void setSuspendOnFail(boolean suspendOnFail) {
        this.suspendOnFail = suspendOnFail;
    }

    public boolean isSuspendOnFail() {
        return this.suspendOnFail;
    }

    public void setAppendableReaderListener(AppendableFileTableReader.AppendableFileTableReaderReplicationListener appendableFileTableReaderReplicationListener) {
        this.appendableFileTableReaderReplicationListener = appendableFileTableReaderReplicationListener;
    }

    public AppendableFileTableReader.AppendableFileTableReaderReplicationListener getAppendableReaderListener() {
        return this.appendableFileTableReaderReplicationListener;
    }

    public void removeAppendableReaderListener() {
        this.appendableFileTableReaderReplicationListener = null;
    }

    public void resume(Session session) {
        this.appendableFileTableReaderLock.lock();
        try {
            if (this.appendableFileTableReader != null) {
                this.appendableFileTableReader.resume();
            }
        }
        finally {
            this.appendableFileTableReaderLock.unlock();
        }
    }

    public void logInfo(String message) {
        this.log(Trace.Level.INFO, message);
    }

    public void logError(String message) {
        this.log(Trace.Level.ERROR, message);
    }

    public void logDebug(String message) {
        this.log(Trace.Level.DEBUG, message);
    }

    private void log(Trace.Level info, String message) {
        if (this.database != null) {
            FileTable.log(info, (AbstractDataspace)this.database.schemaManager.findSchema(this.getObjectName().schema.name), this.getObjectName(), message);
        } else {
            FileTable.log(info, null, this.getObjectName(), message);
        }
    }

    public static void log(Trace.Level level, AbstractDataspace dataspace, NameManager.ObjectName objectName, String message) {
        AbstractDataspace.log(FileTable.class, level, dataspace, objectName, message);
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        if (this.fileDescriptorName != null) {
            set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetFileDescriptorObjectName(this.fileDescriptorName));
        }
        return set;
    }
}

