/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.ds.navigator.RangeIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.navigator.RowSetNavigatorDataChange;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class DfetchMonitor {
    private ReentrantLock takeLock;
    private Condition takeCondition;
    private AtomicInteger takesCount = new AtomicInteger(0);
    private List<Expression> whereConditions = new ArrayList<Expression>();
    private int trueConditionsCount = 0;
    private Table parentTable;

    public DfetchMonitor(Table parentTable) {
        this.parentTable = parentTable;
        this.takeLock = new ReentrantLock();
        this.takeCondition = this.takeLock.newCondition();
    }

    public void beginTake() {
        this.takesCount.incrementAndGet();
        this.takeLock.lock();
    }

    public void endTake() {
        this.takesCount.decrementAndGet();
        this.takeLock.unlock();
    }

    public void waitMillis(long millis) throws InterruptedException {
        this.takeCondition.await(millis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowsInserted(Session session, List<Object[]> rows) {
        if (this.takesCount.get() == 0) {
            return false;
        }
        this.takeLock.lock();
        try {
            if (this.takesCount.get() == 0) {
                boolean bl = false;
                return bl;
            }
            for (Object[] row : rows) {
                if (!this.rowInserted(session, row)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowsInserted(Session session, RowSetNavigator rowsNavigator) {
        if (this.takesCount.get() == 0) {
            return false;
        }
        this.takeLock.lock();
        try {
            if (this.takesCount.get() == 0) {
                boolean bl = false;
                return bl;
            }
            rowsNavigator.beforeFirst();
            while (rowsNavigator.hasNext()) {
                if (!this.rowInserted(session, rowsNavigator.getNext())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowsInserted(Session session, RowSetNavigatorDataChange rowsNavigator) {
        if (this.takesCount.get() == 0) {
            return false;
        }
        this.takeLock.lock();
        try {
            if (this.takesCount.get() == 0) {
                boolean bl = false;
                return bl;
            }
            rowsNavigator.beforeFirst();
            while (rowsNavigator.next()) {
                if (!this.rowInserted(session, rowsNavigator.getCurrentChangedData())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowInserted(Session session, Object[] row) {
        if (row == null) {
            return false;
        }
        if (this.takesCount.get() == 0) {
            return false;
        }
        this.takeLock.lock();
        try {
            if (this.takesCount.get() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean conditionIsOk = true;
            if (this.trueConditionsCount == 0) {
                conditionIsOk = false;
                for (Expression whereCondition : this.whereConditions) {
                    RowSetNavigatorData rowRangeIterator = new RowSetNavigatorData(session);
                    rowRangeIterator.add(row);
                    rowRangeIterator.next();
                    RangeVariable rangeVariable = new RangeVariable(this.parentTable, rowRangeIterator.getRangePosition());
                    Queue<RangeVariable> updatedRangeVariables = null;
                    RangeIterator updatedRangeIterator = null;
                    try {
                        updatedRangeVariables = this.updateExpressionRangeVariables(whereCondition, rangeVariable);
                        updatedRangeIterator = session.sessionContext.rangeIterators[rowRangeIterator.getRangePosition()];
                        session.sessionContext.setRangeIterator(rowRangeIterator);
                        if (!whereCondition.testCondition(session)) continue;
                        conditionIsOk = true;
                        break;
                    }
                    finally {
                        if (updatedRangeVariables != null) {
                            this.revertExpressionRangeVariables(whereCondition, updatedRangeVariables);
                        }
                        session.sessionContext.rangeIterators[rowRangeIterator.getRangePosition()] = updatedRangeIterator;
                    }
                }
            }
            if (!conditionIsOk) {
                boolean bl = false;
                return bl;
            }
            this.takeCondition.signalAll();
            boolean bl = true;
            return bl;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    private Queue<RangeVariable> updateExpressionRangeVariables(Expression expression, RangeVariable rangeVariable) {
        ArrayDeque<RangeVariable> rangeVariables = new ArrayDeque<RangeVariable>();
        this.updateExpressionRangeVariables(expression, rangeVariable, rangeVariables);
        return rangeVariables;
    }

    private void updateExpressionRangeVariables(Expression expression, RangeVariable rangeVariable, Queue<RangeVariable> rangeVariables) {
        if (expression instanceof ExpressionColumn && ((ExpressionColumn)expression).rangeVariable != null) {
            rangeVariables.add(((ExpressionColumn)expression).rangeVariable);
            ((ExpressionColumn)expression).rangeVariable = rangeVariable;
        }
        for (Expression node : expression.nodes) {
            this.updateExpressionRangeVariables(node, rangeVariable, rangeVariables);
        }
    }

    private void revertExpressionRangeVariables(Expression expression, Queue<RangeVariable> rangeVariables) {
        if (expression instanceof ExpressionColumn && ((ExpressionColumn)expression).rangeVariable != null) {
            ((ExpressionColumn)expression).rangeVariable = rangeVariables.remove();
        }
        for (Expression node : expression.nodes) {
            this.revertExpressionRangeVariables(node, rangeVariables);
        }
    }

    public void addWhereCondition(Expression whereCondition) {
        if (whereCondition == null || whereCondition == Expression.EXPR_TRUE) {
            ++this.trueConditionsCount;
        } else {
            this.whereConditions.add(whereCondition);
        }
    }

    public void removeWhereCondition(Expression whereCondition) {
        if (whereCondition == null || whereCondition == Expression.EXPR_TRUE) {
            --this.trueConditionsCount;
        } else {
            this.whereConditions.remove(whereCondition);
        }
    }
}

