/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.table;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.persist.FileTableIOManager;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableCollection;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.concurrent.worker.MonitorDaemonWorker;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.advisory.JournalFileTableStateChangeAdvisory;
import com.streamscape.sef.FabricException;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public class AppendableFileTableReader
extends MonitorDaemonWorker {
    public static final long CHECK_INTERVAL_DEFAULT = 500L;
    private final FileTable fileTable;
    private final FileTableCollection fileTableCollection;
    private final FileTableIOManager ioManager;
    private final PersistentStore store;
    private Session session;
    private long previousNotZeroPosition = 0L;
    private Statistics statistics = new Statistics();
    private final ReentrantLock truncateLock = new ReentrantLock();

    public AppendableFileTableReader(FileTableCollection fileTableCollection, FileTableIOManager ioManager, long position, PersistentStore store) throws FabricException {
        this(fileTableCollection, ioManager, position, store, 500L, false);
    }

    public AppendableFileTableReader(FileTableCollection fileTableCollection, FileTableIOManager ioManager, long position, PersistentStore store, long checkInterval, boolean suspendOnFail) throws FabricException {
        super("DSYS:FileTablePoller." + fileTableCollection.getObjectName().getSchemaQualifiedStatementName(), "Reads newly appended records from file and adds to file table index.", checkInterval > 0L ? checkInterval : 500L);
        this.fileTableCollection = fileTableCollection;
        this.fileTable = fileTableCollection.getFileTable();
        this.ioManager = ioManager;
        this.store = store;
        this.statistics = new Statistics();
        this.statistics.currentPosition = position;
        this.statistics.checkInterval = this.getTimeout();
        this.statistics.suspendOnFail = suspendOnFail;
    }

    public void setSession(Session session) {
        this.session = session;
        session.setAutoCommit(true);
    }

    public void setSkipSize(long skipSize) {
        this.statistics.skipSize = skipSize;
    }

    public void truncate(boolean force) {
        try {
            if (this.ioManager != null) {
                if (!force && this.ioManager.getFileLength() > this.statistics.currentPosition) {
                    throw new DataspaceException("JFT cannot be truncated while there are some unhandled rows.");
                }
                this.ioManager.truncate();
            }
            this.logFile(Trace.Level.DEBUG, " has been truncated by user.", new Object[0]);
            this.clearCacheAndResetPosition();
        }
        catch (IOException exception) {
            throw new DataspaceException(exception);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void doExecute() throws FabricException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void suspend(int rowInSize, Exception exception) {
        if (this.statistics.suspendOnFail) {
            this.statistics.suspendTime = System.currentTimeMillis();
            this.statistics.currentPosition -= (long)rowInSize;
            this.fileTableCollection.logInfo("JFT has been suspended.");
            this.raiseJournalFileTableStateChangeAdvisory(JournalFileTableStateChangeAdvisory.JFTState.SUSPENDED, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMalformedDataTriggerOrSuspend(String currentRowText, Object[] data, int rowInSize, Exception exception) {
        try {
            this.session.setAutoCommit(false);
            try {
                this.fileTable.fireMalformedDataTrigger(this.session, currentRowText, data, exception);
                this.session.commit(true);
            }
            finally {
                this.session.setAutoCommit(true);
            }
        }
        catch (Exception exception1) {
            this.session.rollback(true);
            this.fileTableCollection.logError("Failed to fire malformed data trigger for line \n" + currentRowText + "\nCause: " + Utils.formatExceptionWithUnrepeatedCauses(exception1));
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception1, true);
            }
            this.suspend(rowInSize, exception);
        }
        finally {
            this.session.setAutoCommit(true);
        }
    }

    private void logException(Exception exception, String currentRowText) {
        if (currentRowText == null) {
            if (this.statistics.lastException == null || !Objects.equals(this.statistics.lastException.getMessage(), exception.getMessage())) {
                this.logFile(Trace.Level.ERROR, ": exception caught: " + Utils.formatExceptionWithUnrepeatedCauses(exception), new Object[0]);
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logException(this, exception, true);
                }
            }
        } else if (this.statistics.lastExceptionRowText == null || !this.statistics.lastExceptionRowText.equals(currentRowText) || this.statistics.lastException == null || !Objects.equals(this.statistics.lastException.getMessage(), exception.getMessage())) {
            this.logFile(Trace.Level.ERROR, ": error while processing line \n" + currentRowText + "\nException: " + Utils.formatExceptionWithUnrepeatedCauses(exception), new Object[0]);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
        }
    }

    private void truncateReplication() {
    }

    private void clearCacheAndResetPosition() {
        this.statistics.currentPosition = 0L;
        this.statistics.malformedLinesCount = 0L;
        if (this.store != null) {
            this.store.removeAll();
        }
        if (this.store.getCache() != null) {
            this.store.getCache().clear();
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
            super.join(1000L);
        }
        finally {
            if (this.statistics.startedAt != 0L) {
                this.statistics.stoppedAt = System.currentTimeMillis();
            }
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
    }

    public Statistics getStatistics() {
        Statistics result = new Statistics(this.statistics);
        try {
            result.fileLength = this.ioManager.getFileLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void logFile(Trace.Level level, String message, Object ... args) {
        this.fileTableCollection.log(level, "Source file '" + this.fileTable.getDataSource() + "'" + message);
    }

    public void resume() {
        if (this.statistics.suspendTime != 0L) {
            this.fileTableCollection.logInfo("JFT has been resumed.");
            this.raiseJournalFileTableStateChangeAdvisory(JournalFileTableStateChangeAdvisory.JFTState.RESUMED, null);
        }
        this.statistics.suspendTime = 0L;
    }

    protected void raiseJournalFileTableStateChangeAdvisory(JournalFileTableStateChangeAdvisory.JFTState state, Exception exception) {
        if (this.fileTableCollection instanceof JournalFileTableCollection) {
            ((JournalFileTableCollection)this.fileTableCollection).raiseJournalFileTableStateChangeAdvisory(state, exception);
        }
    }

    public void truncateLock() {
        this.truncateLock.lock();
    }

    public void truncateUnlock() {
        this.truncateLock.unlock();
    }

    public static class Statistics {
        private long startedAt = 0L;
        private long stoppedAt = 0L;
        private Exception lastException = null;
        private long lastExceptionAt = 0L;
        private String lastExceptionRowText = null;
        private boolean fileNotFound = false;
        private long fileNotFoundSince = 0L;
        private long fileFoundSince = 0L;
        private long fileTruncatedAt = 0L;
        private long lastRowReadAt = 0L;
        private long lastRowIndexedAt = 0L;
        private long lastContinuousBlockReadSince = 0L;
        private long malformedLinesCount = 0L;
        private long checkInterval = 0L;
        private long currentPosition = 0L;
        private long fileLength = -1L;
        private long skipSize = 0L;
        private boolean suspendOnFail = false;
        public long suspendTime = 0L;

        public Statistics() {
        }

        public Statistics(Statistics statistics) {
            this.startedAt = statistics.startedAt;
            this.stoppedAt = statistics.stoppedAt;
            this.lastException = statistics.lastException;
            this.lastExceptionAt = statistics.lastExceptionAt;
            this.lastExceptionRowText = statistics.lastExceptionRowText;
            this.fileNotFound = statistics.fileNotFound;
            this.fileNotFoundSince = statistics.fileNotFoundSince;
            this.fileFoundSince = statistics.fileFoundSince;
            this.fileTruncatedAt = statistics.fileTruncatedAt;
            this.lastRowReadAt = statistics.lastRowReadAt;
            this.lastContinuousBlockReadSince = statistics.lastContinuousBlockReadSince;
            this.malformedLinesCount = statistics.malformedLinesCount;
            this.lastRowIndexedAt = statistics.lastRowIndexedAt;
            this.checkInterval = statistics.checkInterval;
            this.currentPosition = statistics.currentPosition;
            this.fileLength = statistics.fileLength;
            this.skipSize = statistics.skipSize;
            this.suspendOnFail = statistics.suspendOnFail;
            this.suspendTime = statistics.suspendTime;
        }

        public long getStartedAt() {
            return this.startedAt;
        }

        public long getStoppedAt() {
            return this.stoppedAt;
        }

        public Exception getLastException() {
            return this.lastException;
        }

        public long getLastExceptionAt() {
            return this.lastExceptionAt;
        }

        public String getLastExceptionRowText() {
            return this.lastExceptionRowText;
        }

        public boolean isFileNotFound() {
            return this.fileNotFound;
        }

        public long getFileNotFoundSince() {
            return this.fileNotFoundSince;
        }

        public long getFileFoundSince() {
            return this.fileFoundSince;
        }

        public long getFileTruncatedAt() {
            return this.fileTruncatedAt;
        }

        public long getLastRowReadAt() {
            return this.lastRowReadAt;
        }

        public long getLastContinuousBlockReadSince() {
            return this.lastContinuousBlockReadSince;
        }

        public long getCheckInterval() {
            return this.checkInterval;
        }

        public long getCurrentPosition() {
            return this.currentPosition;
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public long getMalformedLinesCount() {
            return this.malformedLinesCount;
        }

        public long getLastRowIndexedAt() {
            return this.lastRowIndexedAt;
        }

        public long getSkipSize() {
            return this.skipSize;
        }

        public boolean isSuspendOnFail() {
            return this.suspendOnFail;
        }

        public long getSuspendTime() {
            return this.suspendTime;
        }
    }

    public static interface AppendableFileTableReaderReplicationListener {
        public void onJftAppend(Session var1, Object[] var2, Long var3);

        public void onJftTruncate(Session var1);

        public void onBeforeCommit(Session var1);

        public void onAfterCommit(Session var1);

        public void onAfterCommitConfirm(Session var1);
    }
}

