/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server.web;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.mf.DataspaceMFSession;
import com.streamscape.ds.schema.server.AbstractVirtualClientServerObject;
import com.streamscape.ds.schema.server.ServerRole;
import com.streamscape.ds.schema.server.web.HTTPRequestRepositoryUtils;
import com.streamscape.ds.schema.server.web.WebServerLexiconProcessor;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.http.client.HTTPConnection;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SemanticLexiconProcessor;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WebServerObject
extends AbstractVirtualClientServerObject
implements SLCallable {
    private final String serverTypeSpecified;

    public WebServerObject(DataspaceStore store, NameManager.ObjectName name, String serverType) {
        super(store, name, ServerRole.WEB);
        this.serverTypeSpecified = serverType != null ? serverType : WebServerTypePredefined.HTTP.getName();
        HTTPRequestRepositoryUtils.moveRequestsFromOldNamespace(name.schema.name, name.name);
    }

    @Override
    protected void doInitServerType() {
        this.serverType = this.serverTypeSpecified;
        if (this.clientFactory != null && this.clientFactory.getProperty("ServerType") != null) {
            this.serverType = this.clientFactory.getProperty("ServerType");
        }
    }

    @Override
    protected SemanticLexiconProcessor doCreateLexiconProcessor() {
        return new WebServerLexiconProcessor(DataspaceStore.getContext(), this);
    }

    public Object executeRequest(Session session, Object request, long timeout, Map<String, String> parametersMap) {
        HTTPConnection localClientConnection;
        if (request instanceof String) {
            try {
                request = HTTPRequestRepositoryUtils.lookupHttpRequest(this.getObjectName(), request.toString());
            }
            catch (ObjectConfigurationException exception) {
                throw new DataspaceException("Failed to get HTTP request object.", exception);
            }
        }
        if (request == null) {
            throw new DataspaceException("Specified HTTP request doesn't exist.");
        }
        HTTPRequest httpRequest = (HTTPRequest)request;
        if (timeout != 0L && (httpRequest.getTimeout() == 0 || timeout < (long)httpRequest.getTimeout())) {
            httpRequest.setTimeout((int)(timeout / 1000L - 2L));
        }
        if ((localClientConnection = (HTTPConnection)this.getClientConnection()) == null) {
            throw new DataspaceException("Server is not running or in not valid state.");
        }
        try {
            if (parametersMap != null) {
                httpRequest.setParameterValues(parametersMap);
            }
            httpRequest = httpRequest.customize();
            return localClientConnection.execute(httpRequest);
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed to execute HTTP request.", exception);
        }
    }

    @Override
    public void checkBeforeDrop(Session session, boolean cascade) {
        block3: {
            try {
                if (HTTPRequestRepositoryUtils.listHttpRequests(this.getObjectName()).size() <= 0) break block3;
                if (cascade) {
                    HTTPRequestRepositoryUtils.removeContext(this.getObjectName());
                    break block3;
                }
                throw new DataspaceException("Cannot remove WEB server while HTTP requests exist under this server. Remove requests manually or use cascade option.");
            }
            catch (ObjectConfigurationException objectConfigurationException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return session instanceof DataspaceMFSession;
    }

    public static enum WebServerTypePredefined {
        HTTP("HTTP"),
        OAPI("OAPI"),
        JIRA("JIRA");

        private final String name;

        private WebServerTypePredefined(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static WebServerTypePredefined fromName(String name) {
            for (WebServerTypePredefined value : WebServerTypePredefined.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            throw new DataspaceException("Invalid server type '" + name + "' specified. Allowed values: " + Stream.of(WebServerTypePredefined.values()).map(v -> v.name()).collect(Collectors.joining(",")));
        }
    }
}

