/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.ds.schema.server.web.HTTPRequestRepositoryUtils;
import com.streamscape.ds.schema.server.web.WebServerDSLProvider;
import com.streamscape.ds.schema.server.web.WebServerObject;
import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.operation.AtModifier;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoFromXsdXmlOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoOperation;
import com.streamscape.runtime.mf.operation.factory.DescribeConnectionFactoryOperation;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.network.http.server.swagger.clientgen.ApiListingReferenceLocal;
import com.streamscape.sef.network.http.server.swagger.clientgen.ResourceListingLocal;
import com.streamscape.sef.network.http.server.swagger.clientgen.SwaggerOldVersionConverter;
import com.streamscape.sef.network.http.server.swagger.importer.SwaggerImporter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.slang.SLSession;
import io.swagger.models.HttpMethod;
import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class WebServerOapiOperations {
    private static String fromOapiParametersDescription() {
        return "   from oapi catalog {at | @} <http request name> - HTTP request that returns oapi schema\n     [(<name> = '<value>',... )]                  - HTTP request parameters\n     [path '<path>']                              - particular path for the resource listing\n";
    }

    private static String withSdoParametersDescription(boolean withSdo) {
        return (withSdo ? "   [with sdo]                              - import SDOs related to imported operations\n" : "") + (withSdo ? "  " : "") + "   [name prefix '<prefix>']              - name prefix for imported SDOs\n" + (withSdo ? "  " : "") + "   [name postfix '<postfix>']            - name prefix for imported SDOs\n" + (withSdo ? "  " : "") + "   [name aliases ('<name>' '<alias>',..)]- aliases for imported SDOs\n" + (withSdo ? "  " : "") + "   ns <namespace>                        - java package for imported SDOs\n" + (withSdo ? "  " : "") + "   {add | replace} archive <ArchiveName> - archive for imported SDOs\n" + (withSdo ? "  " : "") + "   {add | replace} package <PackageName> - package for imported SDOs\n";
    }

    private static void setNamespaceArchiveAndModelProperties(AbstractDSLOperation operation, DSLStatement statement, SwaggerImporter swaggerImporter, boolean namespaceIsRequired) throws Exception {
        AbstractCreateSdoOperation.CreateSdoAfterBodyParameters params = AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.parseAfterBodyModifiers(operation, statement, namespaceIsRequired);
        swaggerImporter.setNamespace(params.namespace);
        swaggerImporter.setArchive(params.archiveName, params.addArchive);
        swaggerImporter.setPackage(params.packageName, params.addPackage);
        swaggerImporter.setWithSdo(statement.existsModifier("WITH SDO"));
        if (statement.existsParameter("prefix")) {
            swaggerImporter.getRewriter().setPrefix(statement.getParameter("prefix").getValue());
        }
        if (statement.existsParameter("postfix")) {
            swaggerImporter.getRewriter().setPostfix(statement.getParameter("postfix").getValue());
        }
        swaggerImporter.getRewriter().setAliases(WebServerDSLProvider.nameValueSetToMap(statement, "typenamealiases", new HashMap<String, String>(), "type name", "type alias"));
    }

    private static void setWebServerAndDataspaceNames(WebServerObject callable, DSLStatement statement, SwaggerImporter swaggerImporter) throws Exception {
        if (statement.existsParameter("WebServerName")) {
            String dataspaceName;
            String dataspaceType;
            swaggerImporter.setWebServerName(statement.getParameter("WebServerName").getValue());
            if (statement.existsParameter("DataspaceType")) {
                dataspaceType = statement.getParameter("DataspaceType").getValue();
                dataspaceName = statement.getParameter("DataspaceName").getValue();
            } else if (statement.existsParameter("DataspaceName")) {
                dataspaceName = statement.getParameter("DataspaceName").getValue();
                DataspaceComponent dataspaceComponent = callable.getDataspace().getStore().lookup(dataspaceName);
                if (dataspaceComponent == null) {
                    throw new Exception("Dataspace with name '" + dataspaceName + "' doesn't exist.");
                }
                dataspaceType = dataspaceComponent.getDataspaceType().toString();
            } else {
                dataspaceType = callable.getDataspace().getDataspaceType().toString();
                dataspaceName = callable.getDataspace().getName();
            }
            swaggerImporter.setDataspaceFullName(dataspaceType + "." + dataspaceName);
            swaggerImporter.buildWebServerDefinition();
        }
    }

    private static HTTPRequest getHttpRequest(WebServerObject callable, DSLStatement statement) throws Exception {
        return WebServerOapiOperations.getHttpRequest(callable, statement.getParameter("requestName").getValue());
    }

    private static HTTPRequest getHttpRequest(WebServerObject callable, String requestName) throws Exception {
        try {
            HTTPRequest httpRequest = HTTPRequestRepositoryUtils.lookupHttpRequest(callable.getObjectName(), requestName);
            if (httpRequest == null) {
                throw new Exception("HTTP request with specified name doesn't exist.");
            }
            return httpRequest;
        }
        catch (ObjectConfigurationException exception) {
            throw new Exception("Failed to get HTTP request object.", exception);
        }
    }

    private static String getSwaggerJson(WebServerObject callable, DSLStatement statement, long timeout) throws Exception {
        HTTPRequest httpRequest = WebServerOapiOperations.getHttpRequest(callable, statement);
        if (statement.existsParameter("path")) {
            httpRequest.setUri(httpRequest.getUri() + statement.getParameter("path").getValue());
        }
        return WebServerOapiOperations.getSwaggerJson(callable, httpRequest, WebServerDSLProvider.nameValueSetToMap(statement, "PARAMETERSSET", null), timeout);
    }

    private static String getSwaggerJson(WebServerObject callable, HTTPRequest request, Map<String, String> parametersMap, long timeout) throws Exception {
        HTTPResponse response = (HTTPResponse)callable.executeRequest(null, request, timeout, parametersMap);
        if (response.getStatusCode() != 200) {
            throw new Exception("Failed to get Swagger definition. Status code: " + response.getStatusCode() + ". Data: " + response.getDataString());
        }
        if (response.getData() == null) {
            throw new Exception("Failed to get Swagger definition. Returned data is null.");
        }
        return response.getDataString();
    }

    public static Pair<String, Object> convertSwaggerJsonToSchema(String jsonString) throws Exception {
        JsonNode jsonTree = Json.mapper().readTree(jsonString);
        if (jsonTree.has("swaggerVersion")) {
            SwaggerOldVersionConverter converter;
            Class<?> converterClass;
            try {
                converterClass = WebServerOapiOperations.loadSwaggerOldVersionConverterImpl();
            }
            catch (Throwable exception) {
                throw new Exception("Provided swagger definition is of old version. To convert it to version 2.0 additional library is required. Please add stswagger-client-gen.jar as ext archive.");
            }
            try {
                converter = (SwaggerOldVersionConverter)converterClass.newInstance();
            }
            catch (Exception exception) {
                throw new Exception("Failed to create instance of '" + String.valueOf(converterClass) + "'.");
            }
            return new Pair<String, Object>(jsonTree.get("swaggerVersion").asText(), converter.convert(jsonString, jsonTree));
        }
        Swagger swagger = Json.mapper().readValue(jsonString, Swagger.class);
        return new Pair<String, Swagger>(swagger.getSwagger(), swagger);
    }

    private static Class<?> loadSwaggerOldVersionConverterImpl() throws ClassNotFoundException {
        return RuntimeContext.getInstance().getPackageLoaderRegistry().getSystemClassLoaderChain().loadClass("com.streamscape.swagger.client.gen.SwaggerOldVersionConverterImpl");
    }

    public static class WebServerImportModelFromOapiOperation
    extends AbstractWebServerOapiCatalogOperation {
        public static final String NAME = "import model";

        public WebServerImportModelFromOapiOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("IMPORT MODEL");
            this.syntax.addModifier(new CompoundModifier("ModelChoiceCompound").addModifier((AbstractModifier)new ChoiceModifier("ModelChoice").addPossibleValue("all").addModifier(new CompoundModifier("NameAsCompound").addModifier((AbstractModifier)new Modifier("NAME").addParameter(new StringParameter("name"))).addModifier((AbstractModifier)((Modifier)new Modifier("AS").addParameter(new StringParameter("alias"))).setRequired(false)))).addModifier((AbstractModifier)new ModelPropertiesModifier().setRequired(false)));
            this.syntax.addModifier(new FromOapiModifier());
            this.syntax.addModifier((AbstractModifier)new Modifier("BUILD").setRequired(false));
            this.syntax.setDescription("Reads OAPI schema from specified locations and generates the slang script with the following commands:\n    - create SDOs which correspond to OAPI models\n\nTo execute script automatically specify 'build' option.\n\nParameters:\n\n   { all | * }                             - import all models\n   name '<name>'                           - import only model with specified name\n     [as '<alias>']                        - name of imported SDO\n" + WebServerOapiOperations.withSdoParametersDescription(false) + WebServerOapiOperations.fromOapiParametersDescription() + "   [build]                                 - execute generated slang operations");
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, final long timeout) throws Exception {
            return new FeedbackOperationInvoker(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected SLResponse onInvoke(SLStatement definition, MFSession session) throws Exception {
                    DSLStatement statement = ((Definition)definition).statement;
                    Pair<String, Object> schemaPair = WebServerOapiOperations.convertSwaggerJsonToSchema(WebServerOapiOperations.getSwaggerJson((WebServerObject)callable, statement, timeout));
                    if (!(schemaPair.second instanceof Swagger)) {
                        throw new Exception("Provides schema is not an Swagger schema and doesn't contain models.");
                    }
                    SwaggerImporter swaggerImporter = new SwaggerImporter((Swagger)schemaPair.second);
                    WebServerOapiOperations.setNamespaceArchiveAndModelProperties(this, statement, swaggerImporter, true);
                    if (statement.existsModifier("all")) {
                        swaggerImporter.importModels();
                    } else {
                        String name = statement.getParameter("name").getValue();
                        if (statement.existsParameter("alias")) {
                            swaggerImporter.getRewriter().addAlias(name, statement.getParameter("alias").getValue());
                        }
                        if (!swaggerImporter.importModel(name)) {
                            throw new Exception("Model '" + name + "' doesn't exist.");
                        }
                    }
                    this.addFeedback("Commands successfully generated.");
                    if (statement.existsModifier("BUILD")) {
                        FabricConnection connection = new FabricConnectionFactory().createConnection();
                        SLSession slSession = null;
                        try {
                            connection.open();
                            slSession = connection.createSLSession();
                            this.addFeedback("// creating SDOs\n");
                            for (String edl : swaggerImporter.getSemanticTypesCreateCommands().values()) {
                                this.addFeedback(edl);
                                this.addFeedback("...");
                                SLResponse slResponse = slSession.slangRequest(edl, 30000L);
                                if (!slResponse.isOK()) {
                                    SLResponse sLResponse = slResponse;
                                    return sLResponse;
                                }
                                this.addFeedback("OK\n");
                            }
                        }
                        finally {
                            if (slSession != null) {
                                slSession.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                        }
                    } else {
                        StringBuilder builder = new StringBuilder();
                        builder.append("set delimiter $$\n");
                        builder.append("// creating SDOs\n");
                        for (String edl : swaggerImporter.getSemanticTypesCreateCommands().values()) {
                            builder.append(edl);
                            builder.append("$$\n\n");
                        }
                        builder.append("set delimiter\n");
                        this.addFeedback("\n" + builder.toString());
                    }
                    return new SLResponse();
                }
            }.invoke(definition, session);
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerImportModelFromOapiOperation.NAME);
                this.statement = statement;
            }
        }
    }

    public static class WebServerListModelsFromOapiOperation
    extends AbstractWebServerOapiCatalogOperation {
        public static final String NAME = "list models";

        public WebServerListModelsFromOapiOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("LIST MODELS");
            this.syntax.addModifier((AbstractModifier)new FromOapiModifier().setSyntaxHint(SyntaxHint.SPACE));
            this.syntax.setDescription("Lists models from OAPI catalog schema located at specified location.");
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            DSLStatement statement = ((Definition)definition).statement;
            Pair<String, Object> schemaPair = WebServerOapiOperations.convertSwaggerJsonToSchema(WebServerOapiOperations.getSwaggerJson((WebServerObject)this.callable, statement, timeout));
            if (!(schemaPair.second instanceof Swagger)) {
                throw new Exception("Provides schema is not an Swagger schema and doesn't contain models.");
            }
            RowSet result = new RowSet(WebServerListModelsFromOapiOperation.createResultDescriptorModel());
            Swagger swagger = (Swagger)schemaPair.second;
            for (String model : swagger.getDefinitions().keySet()) {
                result.addToRowSet(new Object[]{model});
            }
            return new SLResponse(result);
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        private static RowMetaData createResultDescriptorModel() {
            RowMetaData result = new RowMetaData(10);
            AbstractDSLOperation.addColumn(result, "Model");
            return result;
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerListModelsFromOapiOperation.NAME);
                this.statement = statement;
            }
        }
    }

    public static class WebServerImportOperationFromOapiOperation
    extends AbstractWebServerOapiCatalogOperation {
        public static final String NAME = "import operation";

        public WebServerImportOperationFromOapiOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("IMPORT OPERATION");
            this.syntax.addModifier((AbstractModifier)new ChoiceModifier("OperationChoice").addPossibleValue("all").addModifier(new CompoundModifier("OperationPathMethodCompound").addModifier((AbstractModifier)new Modifier("RESOURCE").addParameter((SyntaxParameter)new StringParameter("resource").setName("OperationResource"))).addModifier((AbstractModifier)new Modifier("METHOD").addParameter((SyntaxParameter)((EnumParameter)new WebServerDSLProvider.HttpMethodEnum("method").setName("OperationMethod")).setRequired(true))).addModifier((AbstractModifier)((Modifier)new Modifier("AS").addParameter((SyntaxParameter)new IdentifierParameter("name").setName("OperationName"))).setRequired(false))));
            this.syntax.addModifier(new FromOapiModifier());
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO").addParameter(new WebServerNameParameter())).setRequired(true));
            this.syntax.addModifier((AbstractModifier)new WithSdoModifier().setRequired(false));
            this.syntax.addModifier((AbstractModifier)new Modifier("BUILD").setRequired(false));
            this.syntax.setDescription("Reads OAPI schema from specified locations and generates the slang script with the following commands:\n    - create HTTP requests which correspond to OAPI operations\n    - create SDOs which correspond to OAPI models(if 'with sdo' option is specified)\n\nTo execute script automatically specify 'build' option.\n\nParameters:\n\n   { all | * }                             - import all operations\n   resource '<resource>' method <method>   - import only operation on specified resource with specified method\n     [as <name>]                           - HTTP request name for specified operation with specified name\n" + WebServerOapiOperations.fromOapiParametersDescription() + "   to [<DataspaceType>.][<DataspaceName>.]<WebServerName> - WEB server where generated http request should be stored\n" + WebServerOapiOperations.withSdoParametersDescription(true) + "   [build]                                 - execute generated slang operations");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, final long timeout) throws Exception {
            return new FeedbackOperationInvoker(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected SLResponse onInvoke(SLStatement definition, MFSession session) throws Exception {
                    DSLStatement statement = ((Definition)definition).statement;
                    Pair<String, Object> schemaPair = WebServerOapiOperations.convertSwaggerJsonToSchema(WebServerOapiOperations.getSwaggerJson((WebServerObject)callable, statement, timeout));
                    if (!(schemaPair.second instanceof Swagger)) {
                        throw new Exception("Provided catalog is not a Swagger schema and doesn't contain operations.");
                    }
                    SwaggerImporter swaggerImporter = new SwaggerImporter((Swagger)schemaPair.second);
                    swaggerImporter.setWithSdo(statement.existsModifier("WITH SDO"));
                    WebServerOapiOperations.setNamespaceArchiveAndModelProperties(this, statement, swaggerImporter, swaggerImporter.getWithSdo());
                    if (statement.existsParameter("OperationResource")) {
                        swaggerImporter.addImportOperationInfo(new SwaggerImporter.ImportOperationInfo(statement.getParameter("OperationResource").getValue(), statement.getParameter("OperationMethod").getValue(), statement.getParameter("OperationName").getValue(), swaggerImporter.getWithSdo()));
                    }
                    swaggerImporter.buildHttpRequests();
                    WebServerOapiOperations.setWebServerAndDataspaceNames((WebServerObject)callable, statement, swaggerImporter);
                    this.addFeedback("Commands successfully generated.");
                    if (statement.existsModifier("BUILD")) {
                        FabricConnection connection = new FabricConnectionFactory().createConnection();
                        SLSession slSession = null;
                        try {
                            connection.open();
                            slSession = connection.createSLSession();
                            this.addFeedback("// use dataspace");
                            this.addFeedback("use " + swaggerImporter.getDataspaceFullName());
                            this.addFeedback("...");
                            SLResponse slResponse = slSession.slangRequest("use " + swaggerImporter.getDataspaceFullName(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            this.addFeedback("// use web server");
                            this.addFeedback("use server " + swaggerImporter.getWebServerName());
                            this.addFeedback("...");
                            slResponse = slSession.slangRequest("use server " + swaggerImporter.getWebServerName(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            this.addFeedback("// creating http requests\n");
                            for (String edl : swaggerImporter.getHttpRequestsCreateCommands()) {
                                this.addFeedback(edl);
                                this.addFeedback("...");
                                slResponse = slSession.slangRequest(edl, 30000L);
                                if (!slResponse.isOK()) {
                                    SLResponse sLResponse = slResponse;
                                    return sLResponse;
                                }
                                this.addFeedback("OK\n");
                            }
                            slSession.slangRequest("use ..", 30000L);
                            slSession.slangRequest("use ..", 30000L);
                            this.addFeedback("// creating SDOs\n");
                            for (String edl : swaggerImporter.getSemanticTypesCreateCommands().values()) {
                                this.addFeedback(edl);
                                this.addFeedback("...");
                                slResponse = slSession.slangRequest(edl, 30000L);
                                if (!slResponse.isOK()) {
                                    SLResponse sLResponse = slResponse;
                                    return sLResponse;
                                }
                                this.addFeedback("OK\n");
                            }
                        }
                        finally {
                            if (slSession != null) {
                                slSession.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                        }
                    } else {
                        StringBuilder builder = new StringBuilder();
                        builder.append("set delimiter $$\n");
                        builder.append("// use dataspace\n");
                        builder.append("use ").append(swaggerImporter.getDataspaceFullName());
                        builder.append(" $$");
                        builder.append("\n\n");
                        builder.append("// use web server\n");
                        builder.append("use server ").append(swaggerImporter.getWebServerName());
                        builder.append(" $$");
                        builder.append("\n\n");
                        builder.append("// creating http requests\n");
                        for (String edl : swaggerImporter.getHttpRequestsCreateCommands()) {
                            builder.append(edl);
                            builder.append("$$\n\n");
                        }
                        builder.append("use ..\n");
                        builder.append("use ..\n\n");
                        builder.append("// creating SDOs\n");
                        for (String edl : swaggerImporter.getSemanticTypesCreateCommands().values()) {
                            builder.append(edl);
                            builder.append("\n$$\n\n");
                        }
                        builder.append("set delimiter\n");
                        this.addFeedback("\n" + builder.toString());
                    }
                    return new SLResponse();
                }
            }.invoke(statement, session);
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerImportOperationFromOapiOperation.NAME);
                this.statement = statement;
            }
        }
    }

    public static class WebServerDescribeOapiOperationOperation
    extends AbstractWebServerOapiCatalogOperation {
        public static final String NAME = "describe operation";

        public WebServerDescribeOapiOperationOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("DESCRIBE OPERATION");
            ((DSLStatementSyntax)this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("RESOURCE").addParameter((SyntaxParameter)new StringParameter("resource").setName("OperationResource"))).setSyntaxHint(SyntaxHint.SPACE))).addModifier((AbstractModifier)((Modifier)new Modifier("METHOD").addParameter((SyntaxParameter)((EnumParameter)new WebServerDSLProvider.HttpMethodEnum("method").setName("OperationMethod")).setRequired(true))).setSyntaxHint(SyntaxHint.SPACE));
            this.syntax.addModifier(new FromOapiModifier());
            this.syntax.addModifier((AbstractModifier)new AsJsonModifier().setRequired(false));
            this.syntax.setDescription("Describes operation with specified resource and method from OAPI catalog schema located at specified location.\n\nParameters:\n\n   resource '<resource>'        - operation resource\n   method <method>              - operation method\n" + WebServerOapiOperations.fromOapiParametersDescription() + "   as json                      - display operation in json format\n   as json in version 2.0       - display operation transformed to version 2.0 in json format");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            JsonNode jsonTree;
            DSLStatement statement = ((Definition)definition).statement;
            String resource = statement.getParameter("OperationResource").getValue();
            String method = statement.getParameter("OperationMethod").getValue().toUpperCase();
            String json = WebServerOapiOperations.getSwaggerJson((WebServerObject)this.callable, statement, timeout);
            if (statement.existsModifier("asjson") && !statement.existsModifier("inversion2.0") && (jsonTree = Json.mapper().readTree(json)).has("swaggerVersion") && (jsonTree = jsonTree.get("apis")) != null) {
                boolean pathFound = false;
                for (int i = 0; i < jsonTree.size(); ++i) {
                    JsonNode path = jsonTree.get(i);
                    if (path.get("path") == null || !resource.equalsIgnoreCase(path.get("path").asText())) continue;
                    pathFound = true;
                    JsonNode operations = path.get("operations");
                    for (int j = 0; j < operations.size(); ++j) {
                        JsonNode operation = operations.get(j);
                        if (operation.get("method") == null || !method.equalsIgnoreCase(operation.get("method").asText())) continue;
                        return new SLResponse(Json.mapper().writer().withDefaultPrettyPrinter().writeValueAsString(operation));
                    }
                }
                if (pathFound) {
                    throw new Exception("Operation with specified resource and method doesn't exist.");
                }
                throw new Exception("Operation with specified resource doesn't exist.");
            }
            Pair<String, Object> schemaPair = WebServerOapiOperations.convertSwaggerJsonToSchema(json);
            if (!(schemaPair.second instanceof Swagger)) {
                throw new Exception("Provided catalog is not a Swagger schema and doesn't contain operations.");
            }
            Swagger swagger = (Swagger)schemaPair.second;
            Path path = swagger.getPath(resource);
            if (path == null) {
                throw new Exception("Operation with specified resource doesn't exist.");
            }
            Operation operation = (Operation)path.getOperationMap().get(HttpMethod.valueOf((String)method));
            if (operation == null) {
                throw new Exception("Operation with specified resource and method doesn't exist.");
            }
            if (statement.existsModifier("asjson")) {
                return new SLResponse(Json.mapper().writer().withDefaultPrettyPrinter().writeValueAsString(operation));
            }
            RowSet result = new RowSet(WebServerDSLProvider.createResultDescriptorPropertyValue());
            result.addToRowSet(new Object[]{"Path", resource});
            result.addToRowSet(new Object[]{"Method", method});
            result.addToRowSet(new Object[]{"Summary", operation.getSummary()});
            result.addToRowSet(new Object[]{"Description", operation.getDescription()});
            result.addToRowSet(new Object[]{"Operation Id", operation.getOperationId()});
            result.addToRowSet(new Object[]{"Produces", operation.getProduces()});
            result.addToRowSet(new Object[]{"Consumes", operation.getConsumes()});
            result.addToRowSet(new Object[]{"Parameters", operation.getParameters() != null ? operation.getParameters().stream().map(p -> p.getName() + "(" + p.getIn() + ")").collect(Collectors.joining(", ")) : ""});
            result.addToRowSet(new Object[]{"Responses", operation.getResponses() != null ? operation.getResponses().entrySet().stream().map(e -> (String)e.getKey() + " - " + (((Response)e.getValue()).getSchema() != null ? ((Response)e.getValue()).getSchema().getType() : "unknown")).collect(Collectors.joining(", ")) : ""});
            result.addToRowSet(new Object[]{"Tags", operation.getTags()});
            return new SLResponse(result);
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerDescribeOapiOperationOperation.NAME);
                this.statement = statement;
            }
        }
    }

    public static class WebServerImportHttpConnectionFactoryFromOapiOperation
    extends AbstractWebServerOapiCatalogOperation {
        public static final String NAME = "import http connection factory";

        public WebServerImportHttpConnectionFactoryFromOapiOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("IMPORT HTTP CONNECTION FACTORY").addActionParameter(new DescribeConnectionFactoryOperation.ConnectionFactoryTypeNameParameter());
            this.syntax.addModifier(new FromOapiModifier());
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("CREATE WEB SERVER").addParameter(new WebServerNameParameter())).setRequired(false));
            this.syntax.addModifier((AbstractModifier)new Modifier("BUILD").setRequired(false));
            this.syntax.setDescription("Reads OAPI schema from specified location and generates the slang script with the following commands:\n    - create http factory pointed to OAPI host\n    - create web server based on created http factory(if 'create web server option is specified)\n\nTo execute script automatically specify 'build' option.\n\nParameters:\n\n" + WebServerOapiOperations.fromOapiParametersDescription() + "   [create web server [<DataspaceType>.][<DataspaceName>.]<WebServerName>] - generate 'create web server' operation\n   [build]                                 - execute generated slang operations");
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, final long timeout) throws Exception {
            return new FeedbackOperationInvoker(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                protected SLResponse onInvoke(SLStatement definition, MFSession session) throws Exception {
                    DSLStatement statement = ((Definition)definition).statement;
                    Pair<String, Object> schemaPair = WebServerOapiOperations.convertSwaggerJsonToSchema(WebServerOapiOperations.getSwaggerJson((WebServerObject)callable, statement, timeout));
                    if (!(schemaPair.second instanceof Swagger)) {
                        throw new Exception("Provided catalog is not a Swagger schema and doesn't contain host information.");
                    }
                    SwaggerImporter swaggerImporter = new SwaggerImporter((Swagger)schemaPair.second);
                    swaggerImporter.setHttpFactoryFullName(statement.getParameter("FactoryType").getValue() + "." + statement.getParameter("FactoryName").getValue());
                    swaggerImporter.buildHttpFactoryDefinition();
                    WebServerOapiOperations.setWebServerAndDataspaceNames((WebServerObject)callable, statement, swaggerImporter);
                    this.addFeedback("Commands successfully generated.");
                    if (statement.existsModifier("BUILD")) {
                        FabricConnection connection = new FabricConnectionFactory().createConnection();
                        SLSession slSession = null;
                        try {
                            connection.open();
                            slSession = connection.createSLSession();
                            this.addFeedback("\n\n// creating http connection factory");
                            this.addFeedback(swaggerImporter.getHttpFactoryCreateCommand());
                            this.addFeedback("...");
                            SLResponse slResponse = slSession.slangRequest(swaggerImporter.getHttpFactoryCreateCommand(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            if (swaggerImporter.getDataspaceFullName() == null) return new SLResponse();
                            this.addFeedback("// use dataspace");
                            this.addFeedback("use " + swaggerImporter.getDataspaceFullName());
                            this.addFeedback("...");
                            slResponse = slSession.slangRequest("use " + swaggerImporter.getDataspaceFullName(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            this.addFeedback("// creating virtual web server");
                            this.addFeedback(swaggerImporter.getWebServerCreateCommand());
                            this.addFeedback("...");
                            slResponse = slSession.slangRequest(swaggerImporter.getWebServerCreateCommand(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            return new SLResponse();
                        }
                        finally {
                            if (slSession != null) {
                                slSession.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                        }
                    } else {
                        StringBuilder builder = new StringBuilder();
                        builder.append("set delimiter $$\n");
                        builder.append("// creating http connection factory\n");
                        builder.append(swaggerImporter.getHttpFactoryCreateCommand());
                        builder.append("\n$$");
                        builder.append("\n\n");
                        if (swaggerImporter.getDataspaceFullName() != null) {
                            builder.append("// use dataspace\n");
                            builder.append("use ").append(swaggerImporter.getDataspaceFullName());
                            builder.append(" $$");
                            builder.append("\n\n");
                            builder.append("// creating virtual web server\n");
                            builder.append(swaggerImporter.getWebServerCreateCommand());
                            builder.append(" $$");
                            builder.append("\n\n");
                        }
                        builder.append("set delimiter\n");
                        this.addFeedback("\n" + builder.toString());
                    }
                    return new SLResponse();
                }
            }.invoke(definition, session);
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerImportHttpConnectionFactoryFromOapiOperation.NAME);
                this.statement = statement;
            }
        }
    }

    public static class WebServerListResourcesFromOapiOperation
    extends AbstractWebServerOapiCatalogOperation {
        public static final String NAME = "list resources";

        public WebServerListResourcesFromOapiOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("LIST RESOURCES");
            this.syntax.addModifier((AbstractModifier)new FromOapiModifier().setSyntaxHint(SyntaxHint.SPACE));
            this.syntax.setDescription("Lists resources from OAPI catalog schema located on the specified location.");
            this.syntax.setDescription("Lists resources from OAPI catalog schema located at specified location.\n\nThere can be two different OAPI catalog schemas:\n   - swagger resource listing(old versions 1.x)\n   - swagger schema definition(versions from 1.0)\n\nIf 'resource listing' is specified then list of resources in this listing will be displayed.\nTo get information about particular resource 'path <resource path>' option should be specified.\n\nIf swagger schema is specified then list resources from this schema will be displayed.\n\nParameters:\n\n" + WebServerOapiOperations.fromOapiParametersDescription());
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            RowSet result;
            block4: {
                Pair<String, Object> schemaPair;
                block3: {
                    DSLStatement statement = ((Definition)definition).statement;
                    schemaPair = WebServerOapiOperations.convertSwaggerJsonToSchema(WebServerOapiOperations.getSwaggerJson((WebServerObject)this.callable, statement, timeout));
                    if (!(schemaPair.second instanceof ResourceListingLocal)) break block3;
                    result = new RowSet(WebServerListResourcesFromOapiOperation.createResultDescriptorResource());
                    ResourceListingLocal listingLocal = (ResourceListingLocal)schemaPair.second;
                    if (listingLocal.getApis() == null) break block4;
                    for (ApiListingReferenceLocal api : listingLocal.getApis()) {
                        result.addToRowSet(new Object[]{api.getPath(), WebServerDSLProvider.valueOr(api.getDescription(), "")});
                    }
                    break block4;
                }
                result = new RowSet(WebServerListResourcesFromOapiOperation.createResultDescriptorOperation());
                Swagger swagger = (Swagger)schemaPair.second;
                for (Map.Entry pathEntry : swagger.getPaths().entrySet()) {
                    for (Map.Entry operationEntry : ((Path)pathEntry.getValue()).getOperationMap().entrySet()) {
                        result.addToRowSet(new Object[]{pathEntry.getKey(), ((HttpMethod)operationEntry.getKey()).toString(), ((Operation)operationEntry.getValue()).getSummary()});
                    }
                }
            }
            return new SLResponse(result);
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        private static RowMetaData createResultDescriptorResource() {
            RowMetaData result = new RowMetaData(10);
            AbstractDSLOperation.addColumn(result, "Path");
            AbstractDSLOperation.addColumn(result, "Description");
            return result;
        }

        private static RowMetaData createResultDescriptorOperation() {
            RowMetaData result = new RowMetaData(10);
            AbstractDSLOperation.addColumn(result, "Resource");
            AbstractDSLOperation.addColumn(result, "Method");
            AbstractDSLOperation.addColumn(result, "Summary");
            return result;
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerListResourcesFromOapiOperation.NAME);
                this.statement = statement;
            }
        }
    }

    public static class WebServerDescribeOapiCatalogOperation
    extends AbstractWebServerOapiCatalogOperation {
        public static final String NAME = "describe oapi catalog";

        public WebServerDescribeOapiCatalogOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("DESCRIBE OAPI CATALOG");
            this.syntax.addModifier((AbstractModifier)new AtHttpRequestPathModifier().setSyntaxHint(SyntaxHint.SPACE));
            this.syntax.addModifier((AbstractModifier)new AsJsonModifier().setRequired(false));
            this.syntax.setDescription("Describes OAPI catalog schema located at specified location.\n\nThere can be two different OAPI catalog schemas:\n   - swagger resource listing(old versions 1.x)\n     this listing contains of paths to particular swagger schemas\n   - swagger schema definition(versions from 1.0)\n\nIf 'resource listing' is specified then 'path <resource path>' option can be specified to get information about particular resource.\n\nSwagger schemas are different between version 1.x and 2.x. We only work with 2.0.\nSo if schema of version prior 2.0 is specified it will be transformed to version 2.0 at first.\n\nParameters:\n\n   {at | @} <http request name> - http request that returns schema\n    [('<name>' '<value>',... )] - http request parameters\n   [path '<path>']              - particular path for the resource listing\n   as json                      - display schema in json format\n   as json in version 2.0       - display schema transformed to version 2.0 in json format");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            DSLStatement statement = ((Definition)definition).statement;
            String json = WebServerOapiOperations.getSwaggerJson((WebServerObject)this.callable, statement, timeout);
            if (statement.existsModifier("asjson")) {
                if (statement.existsModifier("inversion2.0")) {
                    Pair<String, Object> schemaPair = WebServerOapiOperations.convertSwaggerJsonToSchema(json);
                    if (schemaPair.second instanceof Swagger && !"2.0".equals(schemaPair.first)) {
                        json = Json.mapper().writer().withDefaultPrettyPrinter().writeValueAsString(schemaPair.second);
                    }
                }
                return new SLResponse(json);
            }
            Pair<String, Object> schemaPair = WebServerOapiOperations.convertSwaggerJsonToSchema(json);
            RowSet result = new RowSet(WebServerDSLProvider.createResultDescriptorPropertyValue());
            if (schemaPair.second instanceof ResourceListingLocal) {
                ResourceListingLocal listingLocal = (ResourceListingLocal)schemaPair.second;
                result.addToRowSet(new Object[]{"Type", "Resource Listing"});
                result.addToRowSet(new Object[]{"Swagger Version", schemaPair.first});
                this.describeSwaggerInfo(result, listingLocal.getInfo());
            } else {
                Swagger swagger = (Swagger)schemaPair.second;
                result.addToRowSet(new Object[]{"Type", "Swagger"});
                result.addToRowSet(new Object[]{"Swagger Version", schemaPair.first});
                this.describeSwaggerInfo(result, swagger.getInfo());
                result.addToRowSet(new Object[]{"Host", swagger.getHost()});
                result.addToRowSet(new Object[]{"Base Path", swagger.getBasePath()});
            }
            return new SLResponse(result);
        }

        private void describeSwaggerInfo(RowSet result, Info info) throws SQLException {
            result.addToRowSet(new Object[]{"API Version", WebServerDSLProvider.valueOr(info.getVersion(), "none")});
            result.addToRowSet(new Object[]{"Title", WebServerDSLProvider.valueOr(info.getTitle(), "none")});
            result.addToRowSet(new Object[]{"Description", WebServerDSLProvider.valueOr(info.getDescription(), "none")});
            result.addToRowSet(new Object[]{"Terms Of Service", WebServerDSLProvider.valueOr(info.getTermsOfService(), "none")});
            result.addToRowSet(new Object[]{"Contact Name", info.getContact() != null ? WebServerDSLProvider.valueOr(info.getContact().getName(), "none") : "none"});
            result.addToRowSet(new Object[]{"Contact Email", info.getContact() != null ? WebServerDSLProvider.valueOr(info.getContact().getEmail(), "none") : "none"});
            result.addToRowSet(new Object[]{"Contact URL", info.getContact() != null ? WebServerDSLProvider.valueOr(info.getContact().getUrl(), "none") : "none"});
            result.addToRowSet(new Object[]{"Licence Name", info.getLicense() != null ? WebServerDSLProvider.valueOr(info.getLicense().getName(), "none") : "none"});
            result.addToRowSet(new Object[]{"Licence URL", info.getLicense() != null ? WebServerDSLProvider.valueOr(info.getLicense().getUrl(), "none") : "none"});
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerDescribeOapiCatalogOperation.NAME);
                this.statement = statement;
            }
        }
    }

    public static class WebServerImportSwaggerDefinitionOperation
    extends AbstractWebServerOapiCatalogOperation {
        public static final String NAME = "import swagger definition";

        public WebServerImportSwaggerDefinitionOperation() {
            this.createDSLSyntax(NAME);
            ((DSLStatementSyntax)((DSLStatementSyntax)((DSLStatementSyntax)this.syntax.setAction("IMPORT SWAGGER DEFINITION").addModifier((AbstractModifier)new Modifier("FROM REQUEST").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("http request name").setName("requestName")).setCompletionAdviser(new WebServerDSLProvider.HTTPRequestCompletionAdviser())))).addModifier(WebServerDSLProvider.createNameValueSet("PARAMETERS", "PARAMETERSSET"))).addModifier((AbstractModifier)((Modifier)new Modifier("HTTP FACTORY NAME").addParameter(new DescribeConnectionFactoryOperation.ConnectionFactoryTypeNameParameter())).setRequired(false))).addModifier((AbstractModifier)((Modifier)new Modifier("WEB SERVER").addParameter(new WebServerNameParameter())).setRequired(false));
            AbstractCreateSdoFromXsdXmlOperation.appendSaveBuildModifier(this.syntax);
            this.syntax.addModifier((AbstractModifier)new WithSdoModifier().setRequired(false));
            this.syntax.setDescription("Reads OAPI schema from specified locations and generates the slang script with the following commands:\n    - create http factory pointed to OAPI host\n    - create web server based on created http factory\n    - create HTTP requests which correspond to OAPI operations\n    - create SDOs which correspond to OAPI models\n\nTo execute script automatically specify 'build' option.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, final long timeout) throws Exception {
            return new FeedbackOperationInvoker(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected SLResponse onInvoke(SLStatement definition, MFSession session) throws Exception {
                    DSLStatement statement = ((Definition)definition).statement;
                    Swagger swagger = (Swagger)WebServerOapiOperations.convertSwaggerJsonToSchema((String)WebServerOapiOperations.getSwaggerJson((WebServerObject)((WebServerObject)((WebServerImportSwaggerDefinitionOperation)this).callable), (DSLStatement)statement, (long)timeout)).second;
                    this.addFeedback("Swagger schema successfully parsed.");
                    SwaggerImporter swaggerImporter = new SwaggerImporter(swagger);
                    if (statement.existsParameter("FactoryType")) {
                        swaggerImporter.setHttpFactoryFullName(statement.getParameter("FactoryType").getValue() + "." + statement.getParameter("FactoryName").getValue());
                    }
                    WebServerOapiOperations.setWebServerAndDataspaceNames((WebServerObject)callable, statement, swaggerImporter);
                    WebServerOapiOperations.setNamespaceArchiveAndModelProperties(this, statement, swaggerImporter, true);
                    swaggerImporter.buildDefinitions();
                    this.addFeedback("Commands successfully generated.");
                    if (statement.existsModifier("build")) {
                        if (swaggerImporter.getDataspaceFullName() == null) {
                            throw new Exception("To build commands dataspace name should be set.");
                        }
                        FabricConnection connection = new FabricConnectionFactory().createConnection();
                        SLSession slSession = null;
                        try {
                            connection.open();
                            slSession = connection.createSLSession();
                            this.addFeedback("\n\n// creating http connection factory");
                            this.addFeedback(swaggerImporter.getHttpFactoryCreateCommand());
                            this.addFeedback("...");
                            SLResponse slResponse = slSession.slangRequest(swaggerImporter.getHttpFactoryCreateCommand(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            this.addFeedback("// use dataspace");
                            this.addFeedback("use " + swaggerImporter.getDataspaceFullName());
                            this.addFeedback("...");
                            slResponse = slSession.slangRequest("use " + swaggerImporter.getDataspaceFullName(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            this.addFeedback("// creating virtual web server");
                            this.addFeedback(swaggerImporter.getWebServerCreateCommand());
                            this.addFeedback("...");
                            slResponse = slSession.slangRequest(swaggerImporter.getWebServerCreateCommand(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            this.addFeedback("// use web server");
                            this.addFeedback("use server " + swaggerImporter.getWebServerName());
                            this.addFeedback("...");
                            slResponse = slSession.slangRequest("use server " + swaggerImporter.getWebServerName(), 30000L);
                            if (!slResponse.isOK()) {
                                SLResponse sLResponse = slResponse;
                                return sLResponse;
                            }
                            this.addFeedback("OK\n\n");
                            this.addFeedback("// creating http requests\n");
                            for (String edl : swaggerImporter.getHttpRequestsCreateCommands()) {
                                this.addFeedback(edl);
                                this.addFeedback("...");
                                slResponse = slSession.slangRequest(edl, 30000L);
                                if (!slResponse.isOK()) {
                                    SLResponse sLResponse = slResponse;
                                    return sLResponse;
                                }
                                this.addFeedback("OK\n");
                            }
                            slSession.slangRequest("use ..", 30000L);
                            slSession.slangRequest("use ..", 30000L);
                            this.addFeedback("// creating SDOs\n");
                            for (String edl : swaggerImporter.getSemanticTypesCreateCommands().values()) {
                                this.addFeedback(edl);
                                this.addFeedback("...");
                                slResponse = slSession.slangRequest(edl, 30000L);
                                if (!slResponse.isOK()) {
                                    SLResponse sLResponse = slResponse;
                                    return sLResponse;
                                }
                                this.addFeedback("OK\n");
                            }
                        }
                        finally {
                            if (slSession != null) {
                                slSession.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                        }
                    } else if (statement.existsParameter("edlFile")) {
                        this.addFeedback("Saving generated commands to file...");
                    }
                    this.createOutputEdlFile(session, statement, swaggerImporter);
                    return new SLResponse();
                }

                protected void createOutputEdlFile(MFSession session, DSLStatement statement, SwaggerImporter swaggerImporter) throws Exception {
                    String outputEdlFileName = statement.existsParameter("edlFile") ? statement.getParameter("edlFile").getValue() : null;
                    StringBuilder builder = new StringBuilder();
                    builder.append("// creating http connection factory\n");
                    builder.append(swaggerImporter.getHttpFactoryCreateCommand());
                    builder.append("\n$$");
                    builder.append("\n\n");
                    builder.append("// use dataspace\n");
                    builder.append("use ").append(swaggerImporter.getDataspaceFullName());
                    builder.append("$$");
                    builder.append("\n\n");
                    builder.append("// creating virtual web server\n");
                    builder.append(swaggerImporter.getWebServerCreateCommand());
                    builder.append("$$");
                    builder.append("\n\n");
                    builder.append("// use web server\n");
                    builder.append("use server ").append(swaggerImporter.getWebServerName());
                    builder.append("$$");
                    builder.append("\n\n");
                    builder.append("// creating http requests\n");
                    for (String edl : swaggerImporter.getHttpRequestsCreateCommands()) {
                        builder.append(edl);
                        builder.append("$$\n\n");
                    }
                    builder.append("// creating SDOs\n");
                    for (String edl : swaggerImporter.getSemanticTypesCreateCommands().values()) {
                        builder.append(edl);
                        builder.append("$$\n\n");
                    }
                    if (outputEdlFileName != null) {
                        try {
                            ((SLFileUtils)new SLFileUtilsFactory().create(session, outputEdlFileName)).createFile(builder.toString().getBytes(), false);
                        }
                        catch (IOException exception) {
                            throw new Exception("Failed to write output edl file '" + outputEdlFileName + "'. Cause: " + exception.toString());
                        }
                        this.addFeedback("EDL output file created.");
                    } else if (!statement.existsModifier("build")) {
                        this.addFeedback("\n" + builder.toString());
                    }
                }
            }.invoke(definition, session);
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerImportSwaggerDefinitionOperation.NAME);
                this.statement = statement;
            }
        }
    }

    static abstract class AbstractWebServerOapiCatalogOperation
    extends WebServerDSLProvider.AbstractWebServerOperation {
        @Override
        public boolean isVisible(MFSession session) {
            return WebServerObject.WebServerTypePredefined.OAPI.getName().equals(((WebServerObject)this.callable).getServerType());
        }
    }

    static class FromOapiModifier
    extends CompoundModifier {
        public FromOapiModifier() {
            super("FromOapiCompound");
            this.addModifier(new Modifier("FROM OAPI CATALOG"));
            this.addModifier(new AtHttpRequestPathModifier());
        }
    }

    public static class WebServerNameParameter
    extends CompoundParameter {
        public WebServerNameParameter() {
            super("WebServerNameParameter");
            this.setParametersDelimiter('.');
            this.addParameter((AbstractParameter)new IdentifierParameter("DataspaceType").setRequired(false));
            this.addParameter((AbstractParameter)new IdentifierParameter("DataspaceName").setRequired(false));
            this.addParameter((AbstractParameter)new IdentifierParameter("WebServerName").setRequired(true));
        }
    }

    static class AsJsonModifier
    extends CompoundModifier {
        public AsJsonModifier() {
            super("AsJsonModifierCompound");
            this.addModifier((AbstractModifier)new Modifier("AS JSON").setName("asjson"));
            this.addModifier((AbstractModifier)((Modifier)new Modifier("IN VERSION 2.0").setName("inversion2.0")).setRequired(false));
        }
    }

    static class AtHttpRequestPathModifier
    extends CompoundModifier {
        public AtHttpRequestPathModifier() {
            super("AtHttpRequestPathModifierCompound");
            this.addModifier((AbstractModifier)((ChoiceModifier)new AtModifier("AtRequestNameModifier").setSyntaxHint(SyntaxHint.SPACE)).setRequired(true));
            WebServerDSLProvider.WebServerCallHttpRequestOperation.addHttpRequestWithParameters("requestName", this::addParameter);
            this.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("PATH").addParameter(new StringParameter("path"))).setSyntaxHint(SyntaxHint.SPACE)).setRequired(false));
        }
    }

    static class WithSdoModifier
    extends CompoundModifier {
        public WithSdoModifier() {
            super("WithSdoModifierCompound");
            this.addModifier(new Modifier("WITH SDO"));
            this.addModifier(new ModelPropertiesModifier());
        }
    }

    static class ModelPropertiesModifier
    extends CompoundModifier {
        public ModelPropertiesModifier() {
            super("ModelPropertiesModifierCompound");
            this.addModifier((AbstractModifier)((Modifier)new Modifier("NAME PREFIX").addParameter(new StringParameter("prefix"))).setRequired(false));
            this.addModifier((AbstractModifier)((Modifier)new Modifier("NAME POSTFIX").addParameter(new StringParameter("postfix"))).setRequired(false));
            this.addModifier((AbstractModifier)WebServerDSLProvider.createNameValueSet("NAME ALIASES", "typenamealiases", "type name", "type alias").setRequired(false));
            AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.addAfterBodyNamespaceArchivePackageModifiers(m -> this.addModifier((AbstractModifier)m.setSyntaxHint(new SyntaxHint("    ", true))));
        }
    }
}

