/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server.web;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.schema.server.web.HTTPRequestRepositoryUtils;
import com.streamscape.ds.schema.server.web.WebServerOapiOperations;
import com.streamscape.ds.schema.server.web.WebServerObject;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.Base64Encoder;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import com.streamscape.sdo.http.HTTPResponseSemanticTypes;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class WebServerDSLProvider
extends AbstractDSLProvider<WebServerObject> {
    protected WebServerDSLProvider(WebServerObject callable) {
        super("WebServerDSLProvider$" + callable.getObjectName().getSchemaQualifiedStatementName(), callable);
        this.registerOperation(new WebServerCreateHttpRequestOperation());
        this.registerOperation(new WebServerAlterHttpRequestOperation());
        this.registerOperation(new WebServerListHttpRequestsOperation());
        this.registerOperation(new WebServerDropHttpRequestOperation());
        this.registerOperation(new WebServerDescribeHttpRequestOperation());
        this.registerOperation(new WebServerDescribeServerOperation());
        this.registerOperation(new WebServerCallHttpRequestOperation());
        this.registerOperation(new WebServerOapiOperations.WebServerImportSwaggerDefinitionOperation());
        this.registerOperation(new WebServerOapiOperations.WebServerDescribeOapiCatalogOperation());
        this.registerOperation(new WebServerOapiOperations.WebServerListResourcesFromOapiOperation());
        this.registerOperation(new WebServerOapiOperations.WebServerImportHttpConnectionFactoryFromOapiOperation());
        this.registerOperation(new WebServerOapiOperations.WebServerImportOperationFromOapiOperation());
        this.registerOperation(new WebServerOapiOperations.WebServerListModelsFromOapiOperation());
        this.registerOperation(new WebServerOapiOperations.WebServerImportModelFromOapiOperation());
        this.registerOperation(new WebServerOapiOperations.WebServerDescribeOapiOperationOperation());
        this.activate(callable);
    }

    @Override
    protected RuntimeContext getRuntimeContext() {
        return DataspaceStoreManager.getRuntimeContext();
    }

    @Override
    protected String getTagsFilePrefix() {
        return "WebServer";
    }

    public static Modifier createNameValueSet(String modifier, String name) {
        return WebServerDSLProvider.createNameValueSet(modifier, name, "name", "value");
    }

    public static Modifier createNameValueSet(String modifier, String name, String firstName, String secondName) {
        return (Modifier)((Modifier)new Modifier(modifier).addParameter(new SetParameter(name).addParameter(new StringParameter(firstName)).addParameter(new StringParameter(secondName)))).setRequired(false);
    }

    public static Map<String, String> nameValueSetToMap(DSLStatement statement, String name, Map<String, String> defaultValue) {
        return WebServerDSLProvider.nameValueSetToMap(statement, name, defaultValue, "name", "value");
    }

    public static Map<String, String> nameValueSetToMap(StatementValueList statement, String name, Map<String, String> defaultValue, String firstName, String secondName) {
        StatementSetValue set = statement.getSet(name);
        if (set.isPresent()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (StatementValueList element : set.getElements()) {
                map.put(element.getParameter(firstName).getValue(), element.getParameter(secondName).getValue());
            }
            return map;
        }
        return defaultValue;
    }

    public static Modifier createNameSetNameValueSet(String modifier, String nameSet1, String firstName, String nameSet2, String secondName, String thirdName) {
        return (Modifier)((Modifier)new Modifier(modifier).addParameter(new SetParameter(nameSet1).addParameter(new StringParameter(firstName)).addParameter(new SetParameter(nameSet2).addParameter(new StringParameter(secondName)).addParameter(new StringParameter(thirdName))))).setRequired(false);
    }

    public static Map<String, Map<String, String>> nameSetNameValueSetToMap(DSLStatement statement, Map<String, Map<String, String>> defaultValue, String nameSet1, String firstName, String nameSet2, String secondName, String thirdName) {
        StatementSetValue set = statement.getSet(nameSet1);
        if (set.isPresent()) {
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            for (StatementValueList element : set.getElements()) {
                map.put(element.getParameter(firstName).getValue(), WebServerDSLProvider.nameValueSetToMap(element, nameSet2, new HashMap<String, String>(), secondName, thirdName));
            }
            return map;
        }
        return defaultValue;
    }

    public static Modifier createNameSetNameSet(String modifier, String nameSet1, String firstName, String nameSet2, String secondName) {
        return (Modifier)((Modifier)new Modifier(modifier).addParameter(new SetParameter(nameSet1).addParameter(new StringParameter(firstName)).addParameter((AbstractParameter)new SetParameter(nameSet2).addParameter(new StringParameter(secondName)).setRequired(false)))).setRequired(false);
    }

    public static Map<String, List<String>> nameSetNameSetToMapList(DSLStatement statement, Map<String, List<String>> defaultValue, String nameSet1, String firstName, String nameSet2, String secondName) {
        StatementSetValue set = statement.getSet(nameSet1);
        if (set.isPresent()) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (StatementValueList element : set.getElements()) {
                map.put(element.getParameter(firstName).getValue(), WebServerDSLProvider.nameSetToList(element, nameSet2, null, secondName));
            }
            return map;
        }
        return defaultValue;
    }

    public static Modifier createNameSet(String modifier, String name) {
        return WebServerDSLProvider.createNameSet(modifier, name, "name");
    }

    public static Modifier createNameSet(String modifier, String name, String firstName) {
        return (Modifier)((Modifier)new Modifier(modifier).addParameter(new SetParameter(name).addParameter(new StringParameter(firstName)))).setRequired(false);
    }

    public static List<String> nameSetToList(DSLStatement statement, String name, List<String> defaultValue) {
        return WebServerDSLProvider.nameSetToList(statement, name, defaultValue, "name");
    }

    public static List<String> nameSetToList(StatementValueList statement, String name, List<String> defaultValue, String firstName) {
        StatementSetValue set = statement.getSet(name);
        if (set.isPresent()) {
            return set.getElements().stream().map(e -> e.getParameter(firstName).getValue()).collect(Collectors.toList());
        }
        return defaultValue;
    }

    static RowMetaData createResultDescriptorPropertyValue() {
        RowMetaData result = new RowMetaData(10);
        AbstractDSLOperation.addColumn(result, "Property");
        AbstractDSLOperation.addColumn(result, "Value");
        return result;
    }

    static String valueOr(String value, String elseValue) {
        return value != null ? value : elseValue;
    }

    static class WebServerCreateHttpRequestOperation
    extends AbstractWebServerOperation {
        public static final String NAME = "create http request";

        public WebServerCreateHttpRequestOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("CREATE HTTP REQUEST").addActionParameter(new IdentifierParameter("name"));
            this.syntax.addModifier((AbstractModifier)new Modifier("METHOD").addParameter((SyntaxParameter)new HttpMethodEnum("method").setRequired(true)));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("URI").addParameter(new StringParameter("uri"))).setRequired(true));
            this.syntax.addModifier((AbstractModifier)new CompoundModifier("BodyDataCompound").addModifier((AbstractModifier)new Modifier("BODY DATA").addParameter(new StringParameter("data"))).addModifier((AbstractModifier)new Modifier("BASE64").setRequired(false)).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TIMEOUT").addParameter(new IntegerParameter("timeout"))).setRequired(false));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("QUERY PARAMETERS", "queryparamsset"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("FORM PARAMETERS", "formparamsset"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("HEADERS", "headersset"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("COOKIES", "cookiesset"));
            this.syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameSetNameValueSet("RESPONSE SEMANTIC TYPES", "semanticypesset", "statusCode", "semanticypesset1", "spath", "type").setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("REQUEST SEMANTIC TYPE").addParameter((SyntaxParameter)new StringParameter("semantic type").setName("requestSemanticType"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SERIALIZER PROPERTIES").addParameter((SyntaxParameter)new StringParameter("properties").setName("serializerProperties"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESERIALIZER PROPERTIES").addParameter((SyntaxParameter)new StringParameter("properties").setName("deserializerProperties"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("REQUEST CCSID").addParameter((SyntaxParameter)new StringParameter("ccsid").setName("requestCharsetName"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("RESPONSE CCSID").addParameter((SyntaxParameter)new StringParameter("ccsid").setName("responseCharsetName"))).setRequired(false));
            this.syntax.setDescription("Creates new HTTP request for executing a REST style query. HTTP Requests may be defined as\nstatic URL, HTTP queries or as a combination of URI fragments and parameters that may be \nsubstituted at request execution.\n\nHeader parameters may be passed into the requst as part of the definition or may be inherited\nfrom the HTTP Server as defined by a Connection Factory.\n\nBody Data can be passed in as part of a POST request and may optionally be encoded as Base64.\nThe request can also be configured to pass Form parameters mapped into the call from other\nfunctions or data flow, allowing for programmatic (robotic) form processing that mimics human\ninteractions.\n\nRequests and responses may be mapped to Semantic Types that are used as request or response\nobjects, allowing the requests and responses to be exposed as REST API endpoints in the data \nengine. It is assumed JSON format is used to serialize requests and responses.  Further tuning \nof serialization behavior can be controlled by passing parameters to serializer or deserializer.\n\nCharacter sets for requests and reposnes may be specified to override default behavior. \nWhen not specified, the default CCSID is UTF-8.\n\nSpecifying URI fragment variables can be done in the following way:\n\n\t'/mysite/{version}/data/{state}'\n\nThis mapping results in version and state variables being defined in the HTTP request and\nusers can then set the variables in the query object of an EXECUTE call from a function,\nactor, event trigger or DSQL query, like so:\n\n\tHTTPRequest req = my_HTTP_Server.lookupRequest('fetch_CountryHistory_All');\n\treq.setParameterValue('version', 'v1.2');\n\treq.setParameterValue('state', 'NY');\n\tHTTPResponse resp = my_HTTP_Server.execute(req);\n\t\nThe resulting URI will then be:\n\n\t/mysite/v1.2/data/NY\n\t\nThis can be very useful in situations where global changes, such as API versioning or\nregional settings need to be applied across a variety of extrnal HTTP requests.\n\nSpecifying Query parameters follows the basic HTTP format of ? separator and &parameters.\n\nURI, query parameters, body, headers and cookies support template variables with syntax\n\n\t{%%name%%}            - without default value\n\t{%%name:%%}           - with empty default value \n\t{%%name:some_value%%} - with default value \n\nDefinition samples:\n\n\tquery parameters( 'param1' '{%%param1name:optional_default_value%%}')\n\tquery parameters( 'returnUrl' '/return/url/{%%url_value%%}/')\n\nThen template variables can be set by name:\n\n\treq.setParameterValue('name', 'some value');\n\nCombinations of fragments and parameters may be used to construct dynamic URL's as\nwell as perform Form Data Entry and assemble HTTP query requests based on event  \nflows, human interactions or cognitive automation processes.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            DSLStatement statement = ((Definition)definition).statement;
            String name = statement.getParameter("name").getValue();
            if (HTTPRequestRepositoryUtils.existsHttpRequest(((WebServerObject)this.callable).getObjectName(), name)) {
                throw new Exception("Http request with specified name already exists.");
            }
            HTTPRequest request = new HTTPRequest();
            request.setMethod(statement.getParameter("method").getValue());
            request.setUri(statement.getParameter("uri").getValue());
            WebServerCreateHttpRequestOperation.setBodyData(statement, request);
            int t = statement.getParameter("timeout").getValue(0);
            if (t != 0) {
                request.setTimeout(t);
            }
            request.setQueryParameters(WebServerDSLProvider.nameValueSetToMap(statement, "queryparamsset", null));
            request.setFormParameters(WebServerDSLProvider.nameValueSetToMap(statement, "formparamsset", null));
            request.setHeaders(WebServerDSLProvider.nameValueSetToMap(statement, "headersset", null));
            request.setCookies(WebServerDSLProvider.nameValueSetToMap(statement, "cookiesset", null));
            for (Map.Entry<String, Map<String, String>> entry : WebServerDSLProvider.nameSetNameValueSetToMap(statement, new HashMap<String, Map<String, String>>(), "semanticypesset", "statusCode", "semanticypesset1", "spath", "type").entrySet()) {
                request.getResponseSemanticTypes().set(entry.getKey(), entry.getValue());
            }
            if (statement.existsParameter("requestSemanticType")) {
                request.setRequestSemanticType(statement.getParameter("requestSemanticType").getValue());
            }
            if (statement.existsParameter("serializerProperties")) {
                request.setSerializerProperties(statement.getParameter("serializerProperties").getValue());
            }
            if (statement.existsParameter("deserializerProperties")) {
                request.setDeserializerProperties(statement.getParameter("deserializerProperties").getValue());
            }
            if (statement.existsParameter("requestCharsetName")) {
                request.setRequestCharsetName(statement.getParameter("requestCharsetName").getValue());
            }
            if (statement.existsParameter("responseCharsetName")) {
                request.setResponseCharsetName(statement.getParameter("responseCharsetName").getValue());
            }
            HTTPRequestRepositoryUtils.saveHttpRequest(((WebServerObject)this.callable).getObjectName(), name, request);
            return new SLResponse();
        }

        static void setBodyData(DSLStatement statement, HTTPRequest request) {
            String data = statement.getParameter("data").getValue(null);
            if (data != null) {
                if (statement.existsModifier("BASE64")) {
                    request.setData(Base64.decode(data));
                } else {
                    request.setData(data);
                }
            }
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            Definition(DSLStatement statement) {
                super(WebServerCreateHttpRequestOperation.NAME);
                this.statement = statement;
            }
        }
    }

    static class WebServerAlterHttpRequestOperation
    extends AbstractWebServerOperation {
        public static final String NAME = "alter http request";

        public WebServerAlterHttpRequestOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("ALTER HTTP REQUEST").addActionParameter((SyntaxParameter)new IdentifierParameter("name").setCompletionAdviser(new HTTPRequestCompletionAdviser()));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET NAME").addParameter((SyntaxParameter)new IdentifierParameter("name").setName("newname"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET METHOD").addParameter(new EnumParameter("method").addPossibleValues("POST", "GET", "PUT", "PATCH", "DELETE", "HEAD", "OPTIONS").setCaseSensitive(false))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET URI").addParameter(new StringParameter("uri"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)new CompoundModifier("BodyDataCompound").addModifier((AbstractModifier)new Modifier("SET BODY DATA").addParameter(new StringParameter("data"))).addModifier((AbstractModifier)new Modifier("BASE64").setRequired(false)).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET TIMEOUT").addParameter(new IntegerParameter("timeout"))).setRequired(false));
            this.syntax.addModifier(WebServerDSLProvider.createNameSet("REMOVE QUERY PARAMETERS", "queryparamssetremove"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("ADD QUERY PARAMETERS", "queryparamssetadd"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("SET QUERY PARAMETERS", "queryparamssetset"));
            this.syntax.addModifier(WebServerDSLProvider.createNameSet("REMOVE FORM PARAMETERS", "formparamssetremove"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("ADD FORM PARAMETERS", "formparamssetadd"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("SET FORM PARAMETERS", "formparamssetset"));
            this.syntax.addModifier(WebServerDSLProvider.createNameSet("REMOVE HEADERS", "headerssetremove"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("ADD HEADERS", "headerssetadd"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("SET HEADERS", "headerssetset"));
            this.syntax.addModifier(WebServerDSLProvider.createNameSet("REMOVE COOKIES", "cookiessetremove"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("ADD COOKIES", "cookiessetadd"));
            this.syntax.addModifier(WebServerDSLProvider.createNameValueSet("SET COOKIES", "cookiessetset"));
            this.syntax.addModifier(WebServerDSLProvider.createNameSetNameSet("REMOVE RESPONSE SEMANTIC TYPES", "semantictypessetremove", "statusCode", "semantictypessetremove1", "spath"));
            this.syntax.addModifier(WebServerDSLProvider.createNameSetNameValueSet("ADD RESPONSE SEMANTIC TYPES", "semantictypessetadd", "statusCode", "semantictypessetadd1", "spath", "type"));
            this.syntax.addModifier(WebServerDSLProvider.createNameSetNameValueSet("SET RESPONSE SEMANTIC TYPES", "semantictypessetset", "statusCode", "semantictypessetset1", "spath", "type"));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET REQUEST SEMANTIC TYPE").addParameter((SyntaxParameter)new StringParameter("semantic type").setName("requestSemanticType"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET SERIALIZER PROPERTIES").addParameter((SyntaxParameter)new StringParameter("properties").setName("serializerProperties"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET DESERIALIZER PROPERTIES").addParameter((SyntaxParameter)new StringParameter("properties").setName("deserializerProperties"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET REQUEST CHARSET NAME").addParameter((SyntaxParameter)new StringParameter("charset name").setName("requestCharsetName"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET RESPONSE CHARSET NAME").addParameter((SyntaxParameter)new StringParameter("charset name").setName("responseCharsetName"))).setRequired(false));
            this.syntax.setDescription("Alters existing HTTP request object.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            String newname;
            int t;
            DSLStatement statement = ((Definition)definition).statement;
            String name = statement.getParameter("name").getValue();
            HTTPRequest request = HTTPRequestRepositoryUtils.lookupHttpRequest(((WebServerObject)this.callable).getObjectName(), name);
            if (request == null) {
                throw new Exception("HTTP request object with specified name doesn't exist.");
            }
            if (statement.getParameter("method").isPresent()) {
                request.setMethod(statement.getParameter("method").getValue());
            }
            if (statement.getParameter("uri").isPresent()) {
                request.setUri(statement.getParameter("uri").getValue());
            }
            WebServerCreateHttpRequestOperation.setBodyData(statement, request);
            if (statement.getParameter("timeout").isPresent() && (t = Integer.valueOf(statement.getParameter("timeout").getValue()).intValue()) != 0) {
                request.setTimeout(t);
            }
            request.setQueryParameters(this.removeAddAndSetMap(statement, request.getQueryParameters(), "queryparamssetremove", "queryparamssetadd", "queryparamssetset"));
            request.setFormParameters(this.removeAddAndSetMap(statement, request.getFormParameters(), "formparamssetremove", "formparamssetadd", "formparamssetset"));
            request.setHeaders(this.removeAddAndSetMap(statement, request.getHeaders(), "headerssetremove", "headerssetadd", "headerssetset"));
            request.setCookies(this.removeAddAndSetMap(statement, request.getCookies(), "cookiessetremove", "cookiessetadd", "cookiessetset"));
            HTTPResponseSemanticTypes responseSemanticTypes = request.getResponseSemanticTypes();
            Map<String, List<String>> map = WebServerDSLProvider.nameSetNameSetToMapList(statement, null, "semantictypessetremove", "statusCode", "semantictypessetremove1", "spath");
            if (map != null) {
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    if (entry.getValue() != null && entry.getValue().size() > 0) {
                        for (String spath : entry.getValue()) {
                            responseSemanticTypes.remove(entry.getKey(), spath);
                        }
                        continue;
                    }
                    responseSemanticTypes.remove(entry.getKey());
                }
            }
            for (Map.Entry entry : WebServerDSLProvider.nameSetNameValueSetToMap(statement, new HashMap<String, Map<String, String>>(), "semantictypessetadd", "statusCode", "semantictypessetadd1", "spath", "type").entrySet()) {
                for (Map.Entry<String, List<String>> entry2 : ((Map)entry.getValue()).entrySet()) {
                    request.getResponseSemanticTypes().set((String)entry.getKey(), entry2.getKey(), (String)((Object)entry2.getValue()));
                }
            }
            Map<String, Map<String, String>> setTypes = WebServerDSLProvider.nameSetNameValueSetToMap(statement, null, "semantictypessetset", "statusCode", "semantictypessetset1", "spath", "type");
            if (setTypes != null) {
                request.getResponseSemanticTypes().removeAll();
                for (Map.Entry<String, Map<String, String>> entry : setTypes.entrySet()) {
                    request.getResponseSemanticTypes().set(entry.getKey(), entry.getValue());
                }
            }
            if (statement.existsParameter("requestSemanticType")) {
                request.setRequestSemanticType(statement.getParameter("requestSemanticType").getValue());
            }
            if (statement.existsParameter("serializerProperties")) {
                request.setSerializerProperties(statement.getParameter("serializerProperties").getValue());
            }
            if (statement.existsParameter("deserializerProperties")) {
                request.setDeserializerProperties(statement.getParameter("deserializerProperties").getValue());
            }
            if (statement.existsParameter("requestCharsetName")) {
                request.setRequestCharsetName(statement.getParameter("requestCharsetName").getValue());
            }
            if (statement.existsParameter("responseCharsetName")) {
                request.setResponseCharsetName(statement.getParameter("responseCharsetName").getValue());
            }
            if ((newname = statement.getParameter("newname").getValue()) != null) {
                if (HTTPRequestRepositoryUtils.existsHttpRequest(((WebServerObject)this.callable).getObjectName(), newname)) {
                    throw new Exception("HTTP request with name '" + newname + "' already exists.");
                }
                HTTPRequestRepositoryUtils.saveHttpRequest(((WebServerObject)this.callable).getObjectName(), newname, request);
                HTTPRequestRepositoryUtils.removeHttpRequest(((WebServerObject)this.callable).getObjectName(), name);
            } else {
                HTTPRequestRepositoryUtils.saveHttpRequest(((WebServerObject)this.callable).getObjectName(), name, request);
            }
            return new SLResponse();
        }

        private Map<String, String> removeAddAndSetMap(DSLStatement statement, Map<String, String> parameters, String remove, String add, String set) {
            return this.removeAddAndSetMap(statement, parameters, remove, add, set, "name", "value");
        }

        private Map<String, String> removeAddAndSetMap(DSLStatement statement, Map<String, String> parameters, String remove, String add, String set, String firstName, String secondName) {
            Map<String, String> setParams;
            Map<String, String> addParams;
            List<String> removeNames = WebServerDSLProvider.nameSetToList(statement, remove, null, firstName);
            if (removeNames != null && parameters != null) {
                removeNames.forEach(parameters::remove);
            }
            if ((addParams = WebServerDSLProvider.nameValueSetToMap(statement, add, null, firstName, secondName)) != null) {
                if (parameters != null) {
                    parameters.putAll(addParams);
                } else {
                    parameters = addParams;
                }
            }
            if ((setParams = WebServerDSLProvider.nameValueSetToMap(statement, set, null, firstName, secondName)) != null) {
                parameters = setParams;
            }
            return parameters;
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            Definition(DSLStatement statement) {
                super(WebServerAlterHttpRequestOperation.NAME);
                this.statement = statement;
            }
        }
    }

    static class WebServerListHttpRequestsOperation
    extends AbstractWebServerOperation {
        public static final String NAME = "list http requests";

        public WebServerListHttpRequestsOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("LIST HTTP REQUESTS");
            this.syntax.setDescription("Lists HTTP request objects owned by this server.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            RowSet rowSet = new RowSet(WebServerListHttpRequestsOperation.createResultMetaData());
            List<String> requestNames = HTTPRequestRepositoryUtils.listHttpRequests(((WebServerObject)this.callable).getObjectName());
            for (String requestName : requestNames) {
                HTTPRequest request = HTTPRequestRepositoryUtils.lookupHttpRequest(((WebServerObject)this.callable).getObjectName(), requestName);
                rowSet.addToRowSet(new Object[]{requestName, request.getMethod(), request.getUri(), request.getTimeout()});
            }
            return new SLResponse(rowSet);
        }

        static RowMetaData createResultMetaData() {
            RowMetaData result = new RowMetaData(10);
            WebServerListHttpRequestsOperation.addColumn(result, "Name");
            WebServerListHttpRequestsOperation.addColumn(result, "Method");
            WebServerListHttpRequestsOperation.addColumn(result, "Uri");
            WebServerListHttpRequestsOperation.addColumn(result, "Timeout");
            return result;
        }

        static class Definition
        extends AbstractSLStatement {
            Definition() {
                super(WebServerListHttpRequestsOperation.NAME);
            }
        }
    }

    static class WebServerDropHttpRequestOperation
    extends AbstractWebServerOperation {
        public static final String NAME = "drop http request";

        public WebServerDropHttpRequestOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("DROP HTTP REQUEST").addActionParameter((SyntaxParameter)new IdentifierParameter("name").setCompletionAdviser(new HTTPRequestCompletionAdviser()));
            this.syntax.setDescription("Drops specified HTTP request object.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement.getParameter("name").getValue());
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            if (!HTTPRequestRepositoryUtils.removeHttpRequest(((WebServerObject)this.callable).getObjectName(), ((Definition)definition).name)) {
                throw new Exception("Specified HTTP request doesn't exist.");
            }
            return new SLResponse();
        }

        static class Definition
        extends AbstractSLStatement {
            String name;

            Definition(String name) {
                super(WebServerDropHttpRequestOperation.NAME);
                this.name = name;
            }
        }
    }

    static class WebServerDescribeHttpRequestOperation
    extends AbstractWebServerOperation {
        public static final String NAME = "describe http request";

        public WebServerDescribeHttpRequestOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("DESCRIBE HTTP REQUEST").addActionParameter((SyntaxParameter)new IdentifierParameter("name").setCompletionAdviser(new HTTPRequestCompletionAdviser()));
            this.syntax.addModifier((AbstractModifier)new ChoiceModifier("DescribeOptions").addPossibleValue("BODY DATA").addPossibleValue("QUERY PARAMETERS").addPossibleValue("FORM PARAMETERS").addPossibleValue("HEADERS").addPossibleValue("COOKIES").addPossibleValue("RESPONSE SEMANTIC TYPES").addPossibleValue("USER PARAMETERS").setRequired(false));
            this.syntax.setDescription("Describes specified HTTP request object.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            RowSet rowSet;
            DSLStatement statement = ((Definition)definition).statement;
            HTTPRequest request = HTTPRequestRepositoryUtils.lookupHttpRequest(((WebServerObject)this.callable).getObjectName(), statement.getParameter("name").getValue());
            if (request == null) {
                throw new Exception("Specified HTTP request doesn't exist.");
            }
            if (statement.existsModifier("BODY DATA")) {
                RowMetaData metaData = new RowMetaData();
                WebServerDescribeHttpRequestOperation.addColumn(metaData, "Body Data");
                rowSet = new RowSet(metaData);
                rowSet.addToRowSet(new Object[]{request.getData() == null ? "null" : (request.getData() instanceof String ? request.getDataString() : Base64.encodeBytes(request.getDataBytes()))});
            } else if (statement.existsModifier("QUERY PARAMETERS")) {
                rowSet = this.displayMap(request.getQueryParameters());
            } else if (statement.existsModifier("FORM PARAMETERS")) {
                rowSet = this.displayMap(request.getFormParameters());
            } else if (statement.existsModifier("HEADERS")) {
                rowSet = this.displayMap(request.getHeaders());
            } else if (statement.existsModifier("COOKIES")) {
                rowSet = this.displayMap(request.getCookies());
            } else if (statement.existsModifier("RESPONSE SEMANTIC TYPES")) {
                rowSet = this.displayMapMap(request.getResponseSemanticTypes().getMap(), "Status Code", "SPath", "Semantic Type");
            } else if (statement.existsModifier("USER PARAMETERS")) {
                RowMetaData metaData = new RowMetaData();
                WebServerDescribeHttpRequestOperation.addColumn(metaData, "Name");
                WebServerDescribeHttpRequestOperation.addColumn(metaData, "Context");
                WebServerDescribeHttpRequestOperation.addColumn(metaData, "Default Value");
                WebServerDescribeHttpRequestOperation.addColumn(metaData, "Required");
                rowSet = new RowSet(metaData);
                for (String parameterName : request.getTemplate().getTemplatesParameterNames()) {
                    Optional<String> defaultValue = request.getTemplate().getTemplateParameterDefaultValue(parameterName);
                    rowSet.addToRowSet(new Object[]{parameterName, request.getTemplate().getTemplateParameterContext(parameterName).toString(), defaultValue.orElse("n/a"), defaultValue.isPresent() ? "" : "x"});
                }
            } else {
                RowMetaData metaData = new RowMetaData();
                WebServerDescribeHttpRequestOperation.addColumn(metaData, "Name");
                WebServerDescribeHttpRequestOperation.addColumn(metaData, "Value");
                rowSet = new RowSet(metaData);
                rowSet.addToRowSet(new Object[]{"Method", request.getMethod()});
                rowSet.addToRowSet(new Object[]{"URI", request.getUri()});
                rowSet.addToRowSet(new Object[]{"Timeout", request.getTimeout()});
                rowSet.addToRowSet(new Object[]{"Body Data", request.getData() == null ? null : (request.getData() instanceof String ? request.getDataString() : Base64.encodeBytes(request.getDataBytes()))});
                rowSet.addToRowSet(new Object[]{"Query Parameters", request.getQueryParameters() != null ? request.getQueryParameters() : "{}"});
                rowSet.addToRowSet(new Object[]{"Form Parameters", request.getFormParameters() != null ? request.getFormParameters() : "{}"});
                rowSet.addToRowSet(new Object[]{"Headers", request.getHeaders() != null ? request.getHeaders() : "{}"});
                rowSet.addToRowSet(new Object[]{"Cookies", request.getCookies() != null ? request.getCookies() : "{}"});
                rowSet.addToRowSet(new Object[]{"User Parameters", request.getTemplate().getTemplatesParameterNames() != null ? request.getTemplate().getTemplatesParameterNames() : "{}"});
                rowSet.addToRowSet(new Object[]{"Request Semantic Type", request.getRequestSemanticType() != null ? request.getRequestSemanticType() : "None"});
                rowSet.addToRowSet(new Object[]{"Response Semantic Types", request.getResponseSemanticTypes() != null ? request.getResponseSemanticTypes().getMap() : "{}"});
                rowSet.addToRowSet(new Object[]{"Serializer Properties", request.getSerializerProperties()});
                rowSet.addToRowSet(new Object[]{"Deserializer Properties", request.getDeserializerProperties()});
                rowSet.addToRowSet(new Object[]{"Request Charset Name", request.getRequestCharsetName() != null ? request.getRequestCharsetName() : "None"});
                rowSet.addToRowSet(new Object[]{"Response Charset Name", request.getResponseCharsetName() != null ? request.getResponseCharsetName() : "None"});
            }
            return new SLResponse(rowSet);
        }

        private RowSet displayMap(Map<String, String> map) throws SQLException {
            return this.displayMap(map, "Name", "Value");
        }

        private RowSet displayMap(Map<String, String> map, String firstName, String secondName) throws SQLException {
            RowMetaData metaData = new RowMetaData();
            WebServerDescribeHttpRequestOperation.addColumn(metaData, firstName);
            WebServerDescribeHttpRequestOperation.addColumn(metaData, secondName);
            RowSet rowSet = new RowSet(metaData);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    rowSet.addToRowSet(new Object[]{entry.getKey(), entry.getValue()});
                }
            }
            return rowSet;
        }

        private RowSet displayMapMap(Map<String, Map<String, String>> map, String firstName, String secondName, String thirdName) throws SQLException {
            RowMetaData metaData = new RowMetaData();
            WebServerDescribeHttpRequestOperation.addColumn(metaData, firstName);
            WebServerDescribeHttpRequestOperation.addColumn(metaData, secondName);
            WebServerDescribeHttpRequestOperation.addColumn(metaData, thirdName);
            RowSet rowSet = new RowSet(metaData);
            if (map != null) {
                for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                    for (Map.Entry<String, String> entry1 : entry.getValue().entrySet()) {
                        rowSet.addToRowSet(new Object[]{entry.getKey(), entry1.getKey(), entry1.getValue()});
                    }
                }
            }
            return rowSet;
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            Definition(DSLStatement statement) {
                super(WebServerDescribeHttpRequestOperation.NAME);
                this.statement = statement;
            }
        }
    }

    static class WebServerDescribeServerOperation
    extends AbstractWebServerOperation {
        public static final String NAME = "describe server";

        public WebServerDescribeServerOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("DESCRIBE SERVER");
            this.syntax.setDescription("Returns connected server info.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            RowSet result = new RowSet(WebServerDSLProvider.createResultDescriptorPropertyValue());
            result.addToRowSet(new Object[]{"Name", ((WebServerObject)this.callable).getObjectName().getSchemaQualifiedStatementName()});
            result.addToRowSet(new Object[]{"Factory Type", ((WebServerObject)this.callable).getFactoryType()});
            result.addToRowSet(new Object[]{"Factory Name", ((WebServerObject)this.callable).getFactoryName()});
            result.addToRowSet(new Object[]{"Server Role", ((WebServerObject)this.callable).getServerRole().toString()});
            result.addToRowSet(new Object[]{"Server Type", ((WebServerObject)this.callable).getServerType()});
            result.addToRowSet(new Object[]{"Server State", ((WebServerObject)this.callable).isRunning() ? "STARTED" : "STOPPED"});
            result.addToRowSet(new Object[]{"Connection State", ((WebServerObject)this.callable).getConnectionState().toString()});
            result.addToRowSet(new Object[]{"Invalid", ((WebServerObject)this.callable).isInvalid() ? "x" : ""});
            result.addToRowSet(new Object[]{"Last Error", ((WebServerObject)this.callable).getLastError() != null ? ((WebServerObject)this.callable).getLastError() : ""});
            result.addToRowSet(new Object[]{"Last Error Timestamp", ((WebServerObject)this.callable).getLastErrorTimeStamp() != 0L ? AbstractOperation.formatDate(((WebServerObject)this.callable).getLastErrorTimeStamp()) : ""});
            return new SLResponse(result);
        }

        static class Definition
        extends AbstractSLStatement {
            protected Definition() {
                super(WebServerDescribeServerOperation.NAME);
            }
        }
    }

    public static class WebServerCallHttpRequestOperation
    extends AbstractWebServerOperation {
        public static final String NAME = "call";

        public WebServerCallHttpRequestOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            WebServerCallHttpRequestOperation.addHttpRequestWithParameters("name", p -> this.syntax.addActionParameter((SyntaxParameter<?>)p));
            this.syntax.setDescription("Executes specified HTTP request.");
        }

        public static void addHttpRequestWithParameters(String name, Consumer<AbstractParameter> consumer) {
            consumer.accept((AbstractParameter)((IdentifierParameter)new IdentifierParameter("http request name").setName(name)).setCompletionAdviser(new HTTPRequestCompletionAdviser()));
            consumer.accept((AbstractParameter)new SetParameter("PARAMETERSSET").setDelimiter(new Modifier("=")).addParameter((AbstractParameter)new IdentifierParameter("parameter name").setName("name")).addParameter(new StringParameter("value")).setRequired(false));
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        @Override
        public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
            DSLStatement statement = ((Definition)definition).statement;
            Map<String, String> parametersMap = WebServerDSLProvider.nameValueSetToMap(statement, "PARAMETERSSET", null);
            HTTPResponse response = (HTTPResponse)((WebServerObject)this.callable).executeRequest(null, statement.getParameter("name").getValue(), timeout, parametersMap);
            RowSet result = new RowSet(WebServerDSLProvider.createResultDescriptorPropertyValue());
            result.addToRowSet(new Object[]{"Status Code", response.getStatusCode()});
            result.addToRowSet(new Object[]{"Reason Line", response.getReasonLine()});
            result.addToRowSet(new Object[]{"Version", response.getVersion()});
            result.addToRowSet(new Object[]{"Original URI", response.getOriginalUri()});
            result.addToRowSet(new Object[]{"Effective URI", response.getEffectiveUri()});
            String strData = null;
            if (response.getData() != null) {
                try {
                    strData = new String(response.getData());
                }
                catch (Exception exception) {
                    strData = new Base64Encoder().encode(response.getData());
                }
            }
            result.addToRowSet(new Object[]{"Data", strData});
            result.addToRowSet(new Object[]{"Headers", "----------"});
            if (response.getHeaders() != null) {
                for (Map.Entry<String, String> entry : response.getHeaders().entrySet()) {
                    result.addToRowSet(new Object[]{entry.getKey(), entry.getValue()});
                }
            }
            result.addToRowSet(new Object[]{"Trailers", "----------"});
            if (response.getTrailers() != null) {
                for (Map.Entry<String, String> entry : response.getTrailers().entrySet()) {
                    result.addToRowSet(new Object[]{entry.getKey(), entry.getValue()});
                }
            }
            return new SLResponse(result);
        }

        static class Definition
        extends AbstractSLStatement {
            private DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(WebServerCallHttpRequestOperation.NAME);
                this.statement = statement;
            }
        }
    }

    public static class HttpMethodEnum
    extends EnumParameter {
        public HttpMethodEnum(String token) {
            super(token);
            this.addPossibleValues("POST", "GET", "PUT", "PATCH", "DELETE", "HEAD", "OPTIONS").setCaseSensitive(false);
        }
    }

    public static abstract class AbstractWebServerOperation
    extends AbstractDSLOperation<WebServerObject> {
        @Override
        protected void createDSLSyntax(String name) {
            super.createDSLSyntax(name);
            this.syntax.addTag(OperationTag.dataspace);
        }
    }

    public static class HTTPRequestCompletionAdviser
    implements CompletionAdviser<WebServerObject> {
        @Override
        public List<String> getCompletions(String script, String processedScript, WebServerObject callable, MFSession session) {
            try {
                return HTTPRequestRepositoryUtils.listHttpRequests(callable.getObjectName());
            }
            catch (ObjectConfigurationException exception) {
                Trace.logException(this, exception, true);
                return new ArrayList<String>();
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }
}

