/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server.web;

import com.streamscape.Trace;
import com.streamscape.ds.NameManager;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sef.utils.RepositoryUtils;
import java.util.List;

public class HTTPRequestRepositoryUtils {
    public static String HTTP_REQUEST_OBJECTS_NAMESPACE = "/http/request";

    public static ReferenceContext getReferenceContext() throws ObjectConfigurationException {
        return SemanticObjectReferenceStore.lookupReferenceContext(HTTP_REQUEST_OBJECTS_NAMESPACE);
    }

    public static ReferenceContext getReferenceContext(String subdirectory) throws ObjectConfigurationException {
        return SemanticObjectReferenceStore.lookupReferenceContext(HTTP_REQUEST_OBJECTS_NAMESPACE + "/" + subdirectory);
    }

    public static ReferenceContext getReferenceContext(String dataspaceName, String serverName) throws ObjectConfigurationException {
        return SemanticObjectReferenceStore.lookupReferenceContext(HTTPRequestRepositoryUtils.namespace(dataspaceName, serverName));
    }

    public static List<String> listSubdirectories() throws ObjectConfigurationException {
        SemanticObjectReferenceStore.beginXact();
        try {
            SemanticObjectReferenceStore.setReferenceContext(HTTPRequestRepositoryUtils.getReferenceContext());
            List<String> list = SemanticObjectReferenceStore.listSubcontexts();
            return list;
        }
        finally {
            SemanticObjectReferenceStore.commitXact();
        }
    }

    public static List<String> listSubdirectories(String dataspaceName) throws ObjectConfigurationException {
        SemanticObjectReferenceStore.beginXact();
        try {
            SemanticObjectReferenceStore.setReferenceContext(HTTPRequestRepositoryUtils.getReferenceContext(dataspaceName));
            List<String> list = SemanticObjectReferenceStore.listSubcontexts();
            return list;
        }
        finally {
            SemanticObjectReferenceStore.commitXact();
        }
    }

    public static boolean existsHttpRequest(NameManager.ObjectName objectName, String name) throws ObjectConfigurationException {
        return HTTPRequestRepositoryUtils.existsHttpRequest(objectName.schema.getNameString(), objectName.getNameString(), name);
    }

    public static boolean existsHttpRequest(String dataspaceName, String serverName, String name) throws ObjectConfigurationException {
        return RepositoryUtils.existsObject(HTTPRequestRepositoryUtils.namespace(dataspaceName, serverName), name);
    }

    public static HTTPRequest lookupHttpRequest(NameManager.ObjectName objectName, String name) throws ObjectConfigurationException {
        return HTTPRequestRepositoryUtils.lookupHttpRequest(objectName.schema.getNameString(), objectName.getNameString(), name);
    }

    public static HTTPRequest lookupHttpRequest(String dataspaceName, String serverName, String name) throws ObjectConfigurationException {
        return (HTTPRequest)RepositoryUtils.lookupObject(HTTPRequestRepositoryUtils.namespace(dataspaceName, serverName), name);
    }

    public static void saveHttpRequest(NameManager.ObjectName objectName, String name, HTTPRequest request) throws ObjectConfigurationException {
        HTTPRequestRepositoryUtils.saveHttpRequest(objectName.schema.getNameString(), objectName.getNameString(), name, request);
    }

    public static void saveHttpRequest(String dataspaceName, String serverName, String name, HTTPRequest request) throws ObjectConfigurationException {
        RepositoryUtils.bindObject(HTTPRequestRepositoryUtils.namespace(dataspaceName, serverName), name, (Object)request);
    }

    public static boolean removeHttpRequest(NameManager.ObjectName objectName, String name) throws ObjectConfigurationException {
        return HTTPRequestRepositoryUtils.removeHttpRequest(objectName.schema.getNameString(), objectName.getNameString(), name);
    }

    public static boolean removeHttpRequest(String dataspaceName, String serverName, String name) throws ObjectConfigurationException {
        boolean result = RepositoryUtils.unbindObject(HTTPRequestRepositoryUtils.namespace(dataspaceName, serverName), name);
        try {
            boolean noMoreRequests = false;
            ReferenceContext context = RepositoryUtils.getReferenceContext(HTTPRequestRepositoryUtils.namespace(dataspaceName, serverName), true, true);
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(context);
            boolean bl = noMoreRequests = SemanticObjectReferenceStore.listBoundNames(null).size() == 0;
            if (noMoreRequests) {
                SemanticObjectReferenceStore.destroySubcontext(context);
            }
            SemanticObjectReferenceStore.commitXact();
            if (noMoreRequests) {
                context = HTTPRequestRepositoryUtils.getReferenceContext(dataspaceName);
                SemanticObjectReferenceStore.beginXact();
                SemanticObjectReferenceStore.setReferenceContext(context);
                if (SemanticObjectReferenceStore.listSubcontexts().size() == 0) {
                    SemanticObjectReferenceStore.destroySubcontext(context);
                }
                SemanticObjectReferenceStore.commitXact();
            }
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
        return result;
    }

    public static List<String> listHttpRequests(NameManager.ObjectName objectName) throws ObjectConfigurationException {
        return HTTPRequestRepositoryUtils.listHttpRequests(objectName.schema.getNameString(), objectName.getNameString());
    }

    public static List<String> listHttpRequests(String dataspaceName, String serverName) throws ObjectConfigurationException {
        return RepositoryUtils.listObjects(HTTPRequestRepositoryUtils.namespace(dataspaceName, serverName));
    }

    public static void removeContext(String dataspaceName, String serverName) throws ObjectConfigurationException {
        ReferenceContext context = HTTPRequestRepositoryUtils.getReferenceContext(dataspaceName, serverName);
        if (context != null) {
            RepositoryUtils.destroyReferenceContext(HTTPRequestRepositoryUtils.getReferenceContext(dataspaceName, serverName));
        }
    }

    public static void removeContext(NameManager.ObjectName objectName) throws ObjectConfigurationException {
        HTTPRequestRepositoryUtils.removeContext(objectName.schema.getNameString(), objectName.getNameString());
    }

    public static String namespace(String dataspaceName, String serverName) {
        return HTTP_REQUEST_OBJECTS_NAMESPACE + "/" + dataspaceName + "/" + serverName;
    }

    public static void moveRequestsFromOldNamespace(String dataspaceName, String serverName) {
        try {
            String oldNamespace = HTTP_REQUEST_OBJECTS_NAMESPACE + "/" + dataspaceName + "_" + serverName;
            for (String name : RepositoryUtils.listObjects(oldNamespace)) {
                Trace.logInfo(HTTPRequestRepositoryUtils.class, "Moving http request {}, from old namespace '{}' to new one '{}'.", name, oldNamespace, HTTPRequestRepositoryUtils.namespace(dataspaceName, serverName));
                HTTPRequest request = (HTTPRequest)RepositoryUtils.lookupObject(oldNamespace, name);
                HTTPRequestRepositoryUtils.saveHttpRequest(dataspaceName, serverName, name, request);
            }
            ReferenceContext context = SemanticObjectReferenceStore.lookupReferenceContext(oldNamespace);
            if (context != null) {
                Trace.logInfo(HTTPRequestRepositoryUtils.class, "Removing old namespace for http requests {}.", oldNamespace);
                RepositoryUtils.destroyReferenceContext(context);
            }
        }
        catch (Exception exception) {
            Trace.logError(HTTPRequestRepositoryUtils.class, "Failed to move http requests from old namespace to new one for dataspace {} and server {}.", dataspaceName, serverName);
            Trace.logException(HTTPRequestRepositoryUtils.class, exception, true);
        }
    }
}

