/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.server.QueryableServer;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.server.ServerRole;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionPoolException;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionsPool;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationFactory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.factory.connection.FactoryConnectionService;
import com.streamscape.sef.factory.connection.external.AbstractCompoundExecutionStatement;
import com.streamscape.sef.factory.connection.external.AbstractExternalParser;
import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalParser;
import com.streamscape.sef.pkg.PackageLoaderHelper;
import com.streamscape.sef.utils.Utils;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.parser.ParserException;
import com.streamscape.tools.parser.ParserExceptionBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class VirtualServerObject
extends ServerObject
implements QueryableServer {
    private Map<String, Expression> properties = null;
    private int connectionsPoolSize = 1;
    private JDBCFactory jdbcFactory = null;
    private DatabaseConnectionsPool connectionsPool = new DatabaseConnectionsPool();

    public VirtualServerObject(DataspaceStore store, NameManager.ObjectName name) {
        super(store, name, ServerRole.SQL);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        try {
            this.connectionsPool.setName("VirtualServer$" + this.getObjectName().name);
        }
        catch (DatabaseConnectionPoolException databaseConnectionPoolException) {
            // empty catch block
        }
        this.connectionsPool.setLogger(this);
        this.connectionsPool.setExceptionEventListener(exception -> {
            this.logError(exception.getMessage());
            this.setLastError(exception.getMessage());
        });
        this.connectionsPool.setStateNotificationEventListener(event -> {
            try {
                this.logInfo("Connection state changed to " + String.valueOf((Object)event.getState()) + ", connection name " + event.getConnectionName());
                event.setComponentName(this.dataspace.getType() + "." + this.dataspace.getName());
                this.dataspace.raiseSystemAdvisory(event);
                if (event.getState() == ConnectionState.CONNECTED) {
                    this.setLastError(null);
                    this.initServerType();
                }
            }
            catch (Exception exception) {
                this.logError("Failed to send advisory. Cause: " + exception.getMessage());
            }
            this.raiseVirtualServerStateChangeAdvisory(event.getState());
        });
        try {
            this.initJDBCFactory(session);
            this.setLastError(null);
        }
        catch (Exception exception2) {
            this.handleException(session, exception2);
        }
    }

    private void initServerType() {
        if (!this.connectionsPool.isRunning()) {
            return;
        }
        DatabaseConnection connection = null;
        try {
            connection = this.connectionsPool.get();
            this.serverType = connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException exception) {
            this.logError("Failed to initialize server type. Cause: " + VirtualServerObject.formatSQLExceptionMessage(connection, exception));
        }
        catch (Exception exception) {
            this.logError("Failed to initialize server type. Cause: " + exception.getMessage());
        }
        finally {
            try {
                if (connection != null) {
                    this.connectionsPool.release(connection);
                }
            }
            catch (DatabaseConnectionPoolException exception) {
                this.logError("Failed to release connection. Cause: " + exception.getMessage());
            }
        }
    }

    @Override
    protected void onStartServer(Session session) {
        try {
            this.startConnectionsPool(session);
            this.setLastError(null);
        }
        catch (Throwable exception) {
            this.handleException(session, exception);
        }
    }

    @Override
    protected void onStopServer(Session session) {
        try {
            this.stopConnectionsPool(session);
            this.setLastError(null);
        }
        catch (Throwable exception) {
            this.handleException(session, exception);
        }
    }

    private void handleException(Session session, Throwable exception) {
        this.logError(exception.getMessage());
        this.setLastError(exception.getMessage());
        if (session != null && !session.isProcessingRecoveryLog() && !session.isProcessingLog() && session.isInteractive()) {
            throw new DataspaceException(exception.getMessage());
        }
    }

    public DatabaseConnection getConnection() {
        if (!this.connectionsPool.isRunning()) {
            throw new DataspaceException("Virtual server '" + this.getObjectName().name + "' is not running.");
        }
        try {
            return this.connectionsPool.get();
        }
        catch (DatabaseConnectionPoolException e) {
            throw new DataspaceException(e.getMessage());
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void releaseConnection(DatabaseConnection connection) {
        if (!this.connectionsPool.isRunning()) {
            return;
        }
        try {
            this.connectionsPool.release(connection);
        }
        catch (DatabaseConnectionPoolException e) {
            throw new DataspaceException(e.getMessage());
        }
    }

    @Override
    public boolean isRunning() {
        return this.connectionsPool.isRunning();
    }

    public void setConnectionsPoolSize(int connectionsPoolSize) {
        this.connectionsPoolSize = connectionsPoolSize;
    }

    private void initJDBCFactory(Session session) throws Exception {
        if (this.dataspace == null) {
            throw new Exception("Dataspace component is not ready.");
        }
        try {
            AbstractFabricComponent component = this.dataspace;
            String packageName = PackageType.jdbc.toString() + "." + this.factoryType;
            try {
                if (!PackageLoaderHelper.loadPackageIfRegistered(component, packageName) && !PackageLoaderHelper.loadPackageIfRegistered(component = DataspaceStoreManager.getRuntimeContext(), packageName)) {
                    this.logInfo("WARNING: Package '" + packageName + "' is not registered in Runtime Manifest or Dataspace Manifest.");
                }
            }
            catch (Throwable exception) {
                this.logError("Loading package '" + packageName + "' failed. Cause: " + exception.getMessage());
            }
            this.jdbcFactory = JDBCConfigurationFactory.getJDBCFactory(component, this.factoryName, this.factoryType);
            if (!this.jdbcFactory.isReliableConnection()) {
                throw new Exception("Reliable connection are allowed only.");
            }
            if (this.jdbcFactory.getReconnectInterval() <= 0L) {
                throw new Exception("Reconnect interval should be greater then 0 for reliable connection.");
            }
            if (this.properties != null) {
                for (Map.Entry<String, Expression> prop : this.properties.entrySet()) {
                    this.jdbcFactory.setProperty(prop.getKey(), prop.getValue().getValue(session).toString());
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("Failed to initialize jdbc factory " + this.factoryType + "." + this.factoryName + ". " + exception.getMessage());
        }
    }

    private void startConnectionsPool(Session session) throws Exception {
        if (this.connectionsPool.isRunning()) {
            throw new Exception("Virtual server is running. Stop it before start.");
        }
        this.initJDBCFactory(session);
        this.connectionsPool.setFactory(this.jdbcFactory);
        this.connectionsPool.setPoolSize(this.connectionsPoolSize);
        this.connectionsPool.setName("VirtualServer$" + this.getObjectName().name);
        this.connectionsPool.start();
    }

    private void stopConnectionsPool(Session session) throws Exception {
        this.connectionsPool.stop();
    }

    @Override
    public ConnectionState getConnectionState() {
        ConnectionState state;
        ConnectionState connectionState = state = this.connectionsPool != null ? this.connectionsPool.getState() : ConnectionState.CLOSED;
        if (state == null) {
            state = ConnectionState.CLOSED;
        }
        return state;
    }

    public Map<String, Expression> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Expression> properties) {
        this.properties = properties;
    }

    @Override
    public void describeProperties(Session session, RowSetNavigatorClient navigator) {
        super.describeProperties(session, navigator);
        navigator.add(new Object[]{"Connection Pool Size", this.connectionsPoolSize});
        navigator.add(new Object[]{"Connection Pool Quorum", this.connectionsPool.getState()});
        navigator.add(new Object[]{"Connection Pool State", this.connectionsPool.getStatesMap()});
        if (this.getProperties() != null && this.getProperties().size() > 0) {
            navigator.add(new Object[]{"Properties", ""});
            for (Map.Entry<String, Expression> entry : this.getProperties().entrySet()) {
                navigator.add(new Object[]{"", entry.getKey() + " = " + entry.getValue().getSQL()});
            }
        }
    }

    @Override
    public String getSQL(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ');
        builder.append("VIRTUAL").append(' ');
        builder.append("SQL").append(' ');
        builder.append("SERVER").append(' ');
        builder.append(name).append(' ');
        builder.append(' ').append("USING").append(" ").append("[").append(this.factoryType).append('.').append(this.factoryName).append("]");
        if (this.properties != null) {
            boolean first = true;
            builder.append(' ').append("PROPERTIES").append("(");
            for (Map.Entry<String, Expression> param : this.properties.entrySet()) {
                if (!first) {
                    builder.append(",");
                } else {
                    first = false;
                }
                builder.append(param.getKey()).append("=").append(param.getValue().getSQL());
            }
            builder.append(")");
        }
        builder.append(' ').append("CONNECTIONS").append(' ').append("POOL").append(' ').append("SIZE").append(' ').append(this.connectionsPoolSize);
        return builder.toString();
    }

    @Override
    public ExternalParser getExternalParser() {
        return new AbstractExternalParser(){

            @Override
            protected ExecutionStatement onParse() throws ParserException {
                AbstractCompoundExecutionStatement statement = new AbstractCompoundExecutionStatement(){

                    @Override
                    public Class<?> resolveType(ExternalExecutionContext externalExecutionContext) {
                        return RowSet.class;
                    }

                    @Override
                    public Object execute(ExternalExecutionContext executionContext, Class<?> targetClass) throws Exception {
                        String query = this.buildQuery(executionContext);
                        List<Object> arguments = this.buildArguments(executionContext);
                        return VirtualServerObject.this.executeQuery(query, arguments);
                    }
                };
                try {
                    this.lexer.readToken();
                }
                catch (LexerException exception) {
                    throw ParserExceptionBuilder.parserException(this.lexer, exception.getMessage());
                }
                this.parsePartsCompoundQuery(statement);
                this.externalParserContext.setPosition(this.lexer.getCurrentTokenPosition());
                return statement;
            }

            @Override
            protected boolean supportsStatementParameters() {
                return true;
            }
        };
    }

    public RowSet executeQuery(String query, List<Object> arguments) {
        DatabaseConnection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
            boolean result = false;
            if (arguments.size() == 0) {
                stmt = connection.createStatement();
                if (VirtualServerObject.isSybaseSpCall(connection, query)) {
                    result = true;
                    stmt.executeQuery(query);
                } else {
                    result = stmt.execute(query);
                }
            } else {
                stmt = connection.prepareStatement(query);
                for (int i = 0; i < arguments.size(); ++i) {
                    Object a = OtherTypeWrapper.unwrap(arguments.get(i));
                    if (a instanceof BlobData) {
                        a = ((BlobData)a).getBytes();
                    }
                    ((PreparedStatement)stmt).setObject(i + 1, a);
                }
                result = ((PreparedStatement)stmt).execute();
            }
            if (result) {
                RowSet i = ((RowSetFactory)((RowSetFactory)new RowSetFactory().setWithBlobs(true)).setFetchSize(0)).createRowSet(stmt.getResultSet());
                return i;
            }
            RowMetaData meta = new RowMetaData(2);
            meta.addColumn("Update Count", SQLType.STRING);
            RowSet rowSet = new RowSet(meta);
            rowSet.addToRowSet(new Object[]{stmt.getUpdateCount()});
            RowSet rowSet2 = rowSet;
            return rowSet2;
        }
        catch (SQLException exception) {
            throw VirtualServerObject.sqlToDataspaceException(connection, exception);
        }
        catch (Exception exception) {
            throw new DataspaceException(exception.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException exception) {
                    Trace.logException(this, exception, true);
                }
            }
            if (connection != null) {
                this.releaseConnection(connection);
            }
        }
    }

    @Override
    public FactoryConnectionService getConnectionService() {
        return null;
    }

    public static boolean isSybaseSpCall(Connection connection, String query) {
        return VirtualServerObject.isSybaseConnection(connection) && query.trim().startsWith("sp_");
    }

    public static boolean isSybaseConnection(Connection connection) {
        return VirtualServerObject.isConnection(connection, "com.sybase.jdbc4");
    }

    public static boolean isMSSQLConnection(Connection connection) {
        return VirtualServerObject.isConnection(connection, "com.microsoft.sqlserver");
    }

    public static boolean isMSAccessConnection(Connection connection) {
        return VirtualServerObject.isConnection(connection, "com.streamscape.ms.jdbc");
    }

    public static boolean isMSAccessConnection(String driverClassName) {
        return VirtualServerObject.isConnection(driverClassName, "com.streamscape.ms.jdbc");
    }

    public static boolean isStreamscapeDataspaceConnection(Connection connection) {
        return VirtualServerObject.isConnection(connection, "com.streamscape.ds.jdbc");
    }

    public static boolean isMySQLConnection(String driverClassName) {
        return VirtualServerObject.isConnection(driverClassName, "com.mysql.jdbc");
    }

    private static boolean isConnection(Connection connection, String packageName) {
        return (connection = DatabaseConnection.getRawConnection(connection)) != null && connection.getClass().getName().startsWith(packageName);
    }

    private static boolean isConnection(String driverClassName, String packageName) {
        return driverClassName != null && driverClassName.startsWith(packageName);
    }

    public static String formatSQLExceptionMessage(Connection connection, SQLException exception) {
        String prefix = "";
        if ("08003".equals(exception.getSQLState()) && exception.getErrorCode() == -1) {
            prefix = "";
        } else if (VirtualServerObject.isSybaseConnection(connection)) {
            prefix = "[Sybase ASE] ";
        } else if (VirtualServerObject.isMSSQLConnection(connection)) {
            prefix = "[MSSQL] ";
        } else if (VirtualServerObject.isMSAccessConnection(connection)) {
            prefix = "[Microsoft Access] ";
        } else if (VirtualServerObject.isStreamscapeDataspaceConnection(connection)) {
            prefix = "[StreamScape Dataspace] ";
        }
        return prefix + "Error Code: " + exception.getErrorCode() + ", SQL State: " + exception.getSQLState() + ". " + Utils.formatExceptionWithUnrepeatedCauses(exception);
    }

    public static DataspaceException sqlToDataspaceException(Connection connection, SQLException exception) {
        return new DataspaceException(VirtualServerObject.formatSQLExceptionMessage(connection, exception), exception.getSQLState(), exception.getErrorCode());
    }

    public String getJDBCDriverClassName() {
        return this.jdbcFactory.getJDBCDriverClassName();
    }
}

