/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SysTableManager;
import com.streamscape.ds.SysTablesManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.session.Session;

public class SysServersManager
extends SysTableManager {
    private Statement createServerConfiguration;
    private Statement dropServerConfiguration;
    private Statement updateServerStateConfiguration;
    private Statement getServerStateConfiguration;
    private Statement existServerConfiguration;
    private Statement getServerTypeConfiguration;
    private Statement updateServerTypeConfiguration;

    public SysServersManager(SysTablesManager manager) {
        super(manager, "SYSSERVERS");
    }

    @Override
    public void initialize(Session session) {
        Result result;
        if (session.dataspaceStore.schemaManager.findSchemaObject(this.getTableName(), "SDS", 4) == null) {
            Result result2 = session.executeDirectStatement("create persistent table " + this.getFullTableName() + "(SCHEMA_NAME varchar(255), SERVER_NAME varchar(255), STARTED boolean, TYPE varchar(255), PRIMARY KEY(SCHEMA_NAME, SERVER_NAME))");
            if (result2.isError()) {
                throw new DataspaceException(result2);
            }
        } else if (!this.existsTypeColumn(session) && (result = session.executeDirectStatement("alter table " + this.getFullTableName() + " add TYPE varchar(255)")).isError()) {
            throw new DataspaceException(result);
        }
    }

    private void createServerConfiguration(Session session, NameManager.ObjectName objectName, boolean started, String type) {
        Result result;
        if (this.createServerConfiguration == null) {
            String SQL = "insert into " + this.getFullTableName() + "(  SCHEMA_NAME,   SERVER_NAME,   STARTED,  TYPE)values (?, ?, ?, ?)";
            this.createServerConfiguration = session.compileStatement(SQL);
        }
        if ((result = session.executeCompiledStatement(this.createServerConfiguration, new Object[]{objectName.schema.name, objectName.name, started, type})).isError()) {
            this.logError(result, "Unable to create server configuration.", objectName);
        }
    }

    public void dropServerConfiguration(Session session, final NameManager.ObjectName objectName) {
        this.execute(new SysTableManager.Executor(){

            @Override
            public void execute(Session session) {
                Result result;
                if (SysServersManager.this.dropServerConfiguration == null) {
                    String SQL = "delete from " + SysServersManager.this.getFullTableName() + " where SCHEMA_NAME = ? and SERVER_NAME = ?";
                    SysServersManager.this.dropServerConfiguration = session.compileStatement(SQL);
                }
                if ((result = session.executeCompiledStatement(SysServersManager.this.dropServerConfiguration, new Object[]{objectName.schema.name, objectName.name})).isError()) {
                    SysServersManager.this.logError(result, "Unable to drop server configuration.", objectName);
                }
            }
        }, session);
    }

    public void updateServerStateConfiguration(Session session, final NameManager.ObjectName objectName, final boolean started) {
        this.execute(new SysTableManager.Executor(){

            @Override
            public void execute(Session session) {
                if (SysServersManager.this.updateServerStateConfiguration == null) {
                    String SQL = "update " + SysServersManager.this.getFullTableName() + " set STARTED = ? where SCHEMA_NAME = ? and SERVER_NAME = ?";
                    SysServersManager.this.updateServerStateConfiguration = session.compileStatement(SQL);
                }
                if (SysServersManager.this.existServerConfiguration(session, objectName)) {
                    Result result = session.executeCompiledStatement(SysServersManager.this.updateServerStateConfiguration, new Object[]{started, objectName.schema.name, objectName.name});
                    if (result.isError()) {
                        SysServersManager.this.logError(result, "Unable to update virtual server state configuration to started " + started + ".", objectName);
                    }
                } else {
                    SysServersManager.this.createServerConfiguration(session, objectName, started, null);
                }
            }
        }, session);
    }

    private boolean existServerConfiguration(Session session, NameManager.ObjectName objectName) {
        Result result;
        if (this.existServerConfiguration == null) {
            String SQL = "select STARTED from  " + this.getFullTableName() + " where SCHEMA_NAME = ? and SERVER_NAME = ?";
            this.existServerConfiguration = session.compileStatement(SQL);
        }
        if ((result = session.executeCompiledStatement(this.existServerConfiguration, new Object[]{objectName.schema.name, objectName.name})).isError()) {
            this.logError(result, "Unable to check if exsist server state configuration.", objectName);
            return false;
        }
        return result.navigator.next();
    }

    public boolean getServerStateConfiguration(Session session, final NameManager.ObjectName objectName) {
        return this.execute(new SysTableManager.ExecutorWithReturn<Boolean>(){

            @Override
            public Boolean execute(Session session) {
                Result result;
                if (SysServersManager.this.getServerStateConfiguration == null) {
                    String SQL = "select STARTED from  " + SysServersManager.this.getFullTableName() + " where SCHEMA_NAME = ? and SERVER_NAME = ?";
                    SysServersManager.this.getServerStateConfiguration = session.compileStatement(SQL);
                }
                if ((result = session.executeCompiledStatement(SysServersManager.this.getServerStateConfiguration, new Object[]{objectName.schema.name, objectName.name})).isError()) {
                    SysServersManager.this.logError(result, "Unable to get server state configuration.", objectName);
                    return false;
                }
                if (result.navigator.next()) {
                    return (Boolean)result.navigator.getCurrent(0);
                }
                return false;
            }
        }, session);
    }

    public String getServerType(Session session, final NameManager.ObjectName objectName) {
        return this.execute(new SysTableManager.ExecutorWithReturn<String>(){

            @Override
            public String execute(Session session) {
                Result result;
                if (!SysServersManager.this.existsTypeColumn(session)) {
                    Trace.logError(this, "Failed to get server type for " + objectName.name + " TYPE column still doesn't exist.");
                    return null;
                }
                if (SysServersManager.this.getServerTypeConfiguration == null) {
                    String SQL = "select TYPE from  " + SysServersManager.this.getFullTableName() + " where SCHEMA_NAME = ? and SERVER_NAME = ?";
                    SysServersManager.this.getServerTypeConfiguration = session.compileStatement(SQL);
                }
                if ((result = session.executeCompiledStatement(SysServersManager.this.getServerTypeConfiguration, new Object[]{objectName.schema.name, objectName.name})).isError()) {
                    SysServersManager.this.logError(result, "Unable to get server type configuration.", objectName);
                    return null;
                }
                if (result.navigator.next()) {
                    return (String)result.navigator.getCurrent(0);
                }
                return null;
            }
        }, session);
    }

    public void updateServerType(Session session, final NameManager.ObjectName objectName, final String serverType) {
        this.execute(new SysTableManager.Executor(){

            @Override
            public void execute(Session session) {
                if (!SysServersManager.this.existsTypeColumn(session)) {
                    Trace.logError(this, "Failed to save server type for " + objectName.name + " TYPE column still doesn't exist.");
                    return;
                }
                if (SysServersManager.this.updateServerTypeConfiguration == null) {
                    String SQL = "update " + SysServersManager.this.getFullTableName() + " set TYPE = ? where SCHEMA_NAME = ? and SERVER_NAME = ?";
                    SysServersManager.this.updateServerTypeConfiguration = session.compileStatement(SQL);
                }
                if (SysServersManager.this.existServerConfiguration(session, objectName)) {
                    Result result = session.executeCompiledStatement(SysServersManager.this.updateServerTypeConfiguration, new Object[]{serverType, objectName.schema.name, objectName.name});
                    if (result.isError()) {
                        SysServersManager.this.logError(result, "Unable to update server type configuration to " + serverType + ".", objectName);
                    }
                } else {
                    SysServersManager.this.createServerConfiguration(session, objectName, false, serverType);
                }
            }
        }, session);
    }

    private boolean existsTypeColumn(Session session) {
        TableCollection sysServersTable = (TableCollection)session.dataspaceStore.schemaManager.findSchemaObject(this.getTableName(), "SDS", 4);
        if (sysServersTable != null) {
            OrderedHashSet columns = sysServersTable.getBaseTable().getColumnNameSet();
            for (int i = 0; i < columns.size(); ++i) {
                if (!((NameManager.ObjectName)columns.get((int)i)).name.equals("TYPE")) continue;
                return true;
            }
        }
        return false;
    }

    private void logError(Result result, String message, NameManager.ObjectName objectName) {
        Trace.logError(SysServersManager.class, message + " For server '" + objectName.schema.name + "." + objectName.name + "'.");
        Trace.logError(SysServersManager.class, result.getMainString());
    }
}

