/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server;

import com.streamscape.ds.DataspaceException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ServerRole {
    SQL("Virtual SQL Server"),
    FILE("File Server"),
    NOSQL("NOSQL Server"),
    WEB("Web Server"),
    MESSAGE("Message Server");

    private String roleName;

    private ServerRole(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public static ServerRole fromName(String name) {
        for (ServerRole value : ServerRole.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        throw new DataspaceException("Invalid server role '" + name + "' specified. Allowed values: " + Stream.of(ServerRole.values()).map(v -> v.name()).collect(Collectors.joining(",")));
    }
}

