/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.server.ServerRole;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.advisory.VirtualServerStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import java.util.HashMap;

public abstract class ServerObject
implements SchemaObject,
Logger,
SourceEventFlowData {
    protected DataspaceStore store = null;
    protected AbstractDataspace dataspace = null;
    protected NameManager.ObjectName name = null;
    protected ServerRole serverRole = null;
    protected String serverType = null;
    protected String factoryType = null;
    protected String factoryName = null;
    private String lastError = null;
    private long lastErrorTimeStamp = 0L;

    public ServerObject(DataspaceStore store, NameManager.ObjectName name, ServerRole role) {
        this.name = name;
        this.serverRole = role;
        this.store = store;
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(name.schema.name);
    }

    public AbstractDataspace getDataspace() {
        return this.dataspace;
    }

    public String getFactoryType() {
        return this.factoryType;
    }

    public void setFactoryType(String factoryType) {
        this.factoryType = factoryType;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public void destroy() {
        this.dataspace.unbindProducerFor("advisory.connection.StateChange", this);
        this.dataspace.unbindProducerFor("advisory.virtual.server.StateChange", this);
    }

    @Override
    public int getObjectType() {
        return 27;
    }

    public ServerRole getServerRole() {
        return this.serverRole;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.store.getCatalogName();
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet result = new OrderedHashSet();
        if (this.factoryType != null && this.factoryName != null) {
            result.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetConnectionFactoryObjectName(this.factoryType + "." + this.factoryName));
        }
        return result;
    }

    @Override
    public OrderedHashSet getComponents() {
        return new OrderedHashSet();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public abstract ConnectionState getConnectionState();

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        try {
            this.dataspace.bindProducerForSystem("advisory.virtual.server.StateChange", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        try {
            this.dataspace.bindProducerForSystem("advisory.connection.StateChange", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        this.serverType = session.dataspaceStore.getSysTablesManager().getSysServersManager().getServerType(session, this.getObjectName());
    }

    public void open(Session session) {
        if (session.dataspaceStore.getSysTablesManager().getSysServersManager().getServerStateConfiguration(session, this.getObjectName())) {
            this.onStartServer(session);
        }
    }

    public final synchronized void startServer(Session session) {
        this.logInfo("Starting server...");
        session.dataspaceStore.getSysTablesManager().getSysServersManager().updateServerStateConfiguration(session, this.getObjectName(), true);
        this.saveServerType(session);
        this.onStartServer(session);
        this.logInfo("Server started.");
    }

    public final synchronized void stopServer(Session session) {
        this.logInfo("Stopping server...");
        session.dataspaceStore.getSysTablesManager().getSysServersManager().updateServerStateConfiguration(session, this.getObjectName(), false);
        this.saveServerType(session);
        this.onStopServer(session);
        this.logInfo("Server stopped.");
    }

    public final synchronized void stopServerWithoutStateUpdate(Session session) {
        this.logInfo("Stopping server...");
        this.onStopServer(session);
        this.logInfo("Server stopped.");
    }

    protected void saveServerType(Session session) {
        if (this.serverType != null) {
            session.dataspaceStore.getSysTablesManager().getSysServersManager().updateServerType(session, this.getObjectName(), this.serverType);
        }
    }

    protected void setLastError(String message) {
        this.lastError = message;
        this.lastErrorTimeStamp = this.lastError != null ? System.currentTimeMillis() : 0L;
    }

    public String getLastError() {
        return this.lastError;
    }

    public long getLastErrorTimeStamp() {
        return this.lastErrorTimeStamp;
    }

    public String getServerType() {
        if (this.serverType == null) {
            return "Unknown";
        }
        return this.serverType;
    }

    protected abstract void onStartServer(Session var1);

    protected abstract void onStopServer(Session var1);

    public abstract boolean isRunning();

    public void checkBeforeDrop(Session session, boolean cascade) {
    }

    protected void raiseVirtualServerStateChangeAdvisory(ConnectionState connectionState) {
        try {
            VirtualServerStateChangeAdvisory e = new VirtualServerStateChangeAdvisory();
            e.setServerName(this.getObjectName().name);
            e.setComponentName(this.dataspace.getType() + "." + this.dataspace.getName());
            e.setFactoryName(this.factoryName);
            e.setFactoryType(this.factoryType);
            e.setStarted(this.isRunning());
            e.setConnectionState(connectionState);
            this.dataspace.raiseSystemAdvisory(e);
        }
        catch (Exception exception) {
            this.logError("Failed to send virtual server state change advisory");
            Trace.logException(this, exception, true);
        }
    }

    public void describeProperties(Session session, RowSetNavigatorClient navigator) {
        navigator.add(new Object[]{"Name", this.getObjectName().name});
        navigator.add(new Object[]{"Factory Type", this.getFactoryType()});
        navigator.add(new Object[]{"Factory Name", this.getFactoryName()});
        navigator.add(new Object[]{"Started", this.isRunning()});
        navigator.add(new Object[]{"Server Role", this.getServerRole().toString()});
        navigator.add(new Object[]{"Server Type", this.getServerType()});
        navigator.add(new Object[]{"Invalid", this.isInvalid() ? "x" : ""});
        navigator.add(new Object[]{"Last Error", this.getLastError() != null ? this.getLastError() : ""});
        navigator.add(new Object[]{"Last Error Timestamp", DataspaceDateTime.formatTimestampForResultSet(session, this.getLastErrorTimeStamp())});
    }

    public boolean isInvalid() {
        return this.getLastError() != null && this.getConnectionState() != ConnectionState.CONNECTED;
    }

    @Override
    public void logError(String message) {
        if (this.dataspace != null) {
            this.dataspace.logError(this.getServerEntity(), message);
        } else {
            Trace.logError(this, this.buildTraceMessage(message));
        }
    }

    @Override
    public void logDebug(String message) {
        if (this.dataspace != null) {
            this.dataspace.logDebug(this.getServerEntity(), message);
        } else {
            Trace.logDebug(this, this.buildTraceMessage(message));
        }
    }

    @Override
    public void logInfo(String message) {
        if (this.dataspace != null) {
            this.dataspace.logInfo(this.getServerEntity(), message);
        } else {
            Trace.logInfo(this, this.buildTraceMessage(message));
        }
    }

    private String buildTraceMessage(String message) {
        return "[" + String.valueOf((Object)this.getEntity()) + "] " + message;
    }

    private String getServerEntity() {
        return this.serverRole.getRoleName() + "/" + this.name.name;
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_SERVER;
    }

    @Override
    public String getEntityName() {
        return this.name.name;
    }

    @Override
    public EventScope getEntityScope() {
        return null;
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        return Utils.createMap("serverRole", this.serverRole.getRoleName());
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQLInSchema(String schemaName) {
        return this.getSQL(this.getObjectName().getSchemaQualifiedStatementName(schemaName));
    }
}

