/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.schema.server.AbstractVirtualClientServerObject;
import com.streamscape.ds.schema.server.ServerRole;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NoSqlServerObject
extends AbstractVirtualClientServerObject {
    private NoSqlServerType serverTypeEnum;

    public NoSqlServerObject(DataspaceStore store, NameManager.ObjectName name, NoSqlServerType serverTypeEnum) {
        this(store, name, ServerRole.NOSQL);
        this.serverTypeEnum = serverTypeEnum;
    }

    protected NoSqlServerObject(DataspaceStore store, NameManager.ObjectName name, ServerRole serverRole) {
        super(store, name, serverRole);
    }

    @Override
    protected void doInitServerType() {
        if (this.clientFactory != null) {
            String className = this.clientFactory.getConnectionClassName();
            if (className != null) {
                this.doInitServerType(className.substring(className.lastIndexOf(".")));
                if (this.serverType == null) {
                    this.logError("Unknown connection class name '" + className + "' for factory " + this.clientFactory.getFactoryType() + "." + this.clientFactory.getFactoryName());
                }
            } else {
                this.logError("Connection class is null for factory " + this.clientFactory.getFactoryType() + "." + this.clientFactory.getFactoryName());
            }
        }
    }

    protected void doInitServerType(String className) {
        NoSqlServerType serverTypeEnumFromConnection = null;
        if (className != null) {
            if (className.startsWith(".Mongo")) {
                serverTypeEnumFromConnection = NoSqlServerType.MONGO;
            } else if (className.startsWith(".SF")) {
                serverTypeEnumFromConnection = NoSqlServerType.SALESFORCE;
            } else if (className.startsWith(".Aws")) {
                serverTypeEnumFromConnection = NoSqlServerType.AWS;
            } else {
                throw new DataspaceException("Invalid connection factory specified for server. Should be Mongo, Salesforce or AWS.");
            }
            if (this.serverTypeEnum != null && (this.serverTypeEnum != NoSqlServerType.DYNAMODB && this.serverTypeEnum != serverTypeEnumFromConnection || this.serverTypeEnum == NoSqlServerType.DYNAMODB && NoSqlServerType.AWS != serverTypeEnumFromConnection)) {
                throw new DataspaceException("Invalid connection factory specified for server. Type of the service specified on creation is '" + this.serverTypeEnum.name() + "', but connection factory is of type '" + serverTypeEnumFromConnection.name());
            }
        }
        if (this.serverTypeEnum == NoSqlServerType.DYNAMODB) {
            this.serverType = this.serverTypeEnum.getName();
        } else if (serverTypeEnumFromConnection != null) {
            this.serverType = serverTypeEnumFromConnection.getName();
        }
    }

    public static enum NoSqlServerType {
        MONGO("Mongo"),
        SALESFORCE("Salesforce"),
        AWS("AWS"),
        DYNAMODB("DynamoDB");

        private final String name;

        private NoSqlServerType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static NoSqlServerType fromName(String name) {
            for (NoSqlServerType value : NoSqlServerType.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            throw new DataspaceException("Invalid server type '" + name + "' specified. Allowed values: " + Stream.of(NoSqlServerType.values()).map(v -> v.name()).collect(Collectors.joining(",")));
        }
    }
}

