/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.schema.server.NoSqlServerObject;
import com.streamscape.ds.schema.server.ServerRole;
import com.streamscape.ds.session.Session;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MessageServerObject
extends NoSqlServerObject {
    private MessageServerType serverTypeEnum;

    public MessageServerObject(DataspaceStore store, NameManager.ObjectName name, MessageServerType serverTypeEnum) {
        super(store, name, ServerRole.MESSAGE);
        this.serverTypeEnum = serverTypeEnum;
    }

    @Override
    protected void doInitServerType(String className) {
        if (className != null) {
            if (className.startsWith(".Kafka")) {
                this.serverType = "Kafka";
            } else {
                throw new DataspaceException("Invalid connection factory specified for server. Should be Kafka.");
            }
        }
    }

    @Override
    public void checkBeforeDrop(Session session, boolean cascade) {
        if (this.connectionService != null) {
            this.connectionService.onServerDrop(this);
        }
    }

    @Override
    protected String doGetSQLServerTypeRole() {
        return "MESSAGE";
    }

    public static enum MessageServerType {
        KAFKA("Kafka");

        private final String name;

        private MessageServerType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static MessageServerType fromName(String name) {
            for (MessageServerType value : MessageServerType.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            throw new DataspaceException("Invalid server type '" + name + "' specified. Allowed values: " + Stream.of(MessageServerType.values()).map(v -> v.name()).collect(Collectors.joining(",")));
        }
    }
}

