/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.server.ServerRole;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.fs.client.dropbox.DropBoxFileSystemClientConnection;
import com.streamscape.lib.fs.client.local.LocalFileSystemClientConnection;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationException;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.pkg.PackageLoaderHelper;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ClientFactoryConfigurationException;
import com.streamscape.service.osf.globals.GlobalVariablesResolverImpl;
import com.streamscape.service.osf.globals.ResolutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileServerObject
extends ServerObject {
    private ClientFactory clientFactory = null;
    private int connectionCounter = 0;
    private boolean isStarted = false;
    private ClientConnection monitoringConnection = null;
    private FileServerType fileServerType = null;

    public FileServerObject(DataspaceStore store, NameManager.ObjectName name, FileServerType fileServerType) {
        super(store, name, ServerRole.FILE);
        this.fileServerType = fileServerType;
    }

    public ClientConnection createConnection(String name) {
        ClientConnection connection;
        if (!this.isStarted) {
            throw new DataspaceException("File server '" + this.getObjectName().name + "' is not running.");
        }
        if (this.clientFactory != null) {
            try {
                String connectionFullName = "FileServerConnection" + ++this.connectionCounter + "$" + this.getFactoryType() + "." + this.getFactoryName() + "$" + name;
                connection = this.clientFactory.createConnection(connectionFullName, this.clientFactory.getDefaultUser(), this.clientFactory.getDefaultPassword());
            }
            catch (Exception error) {
                this.logError("Unable to create new connection. " + error.getMessage());
                throw new DataspaceException(error.getMessage());
            }
        } else if (this.fileServerType == FileServerType.FS) {
            try {
                connection = new LocalFileSystemClientConnection();
            }
            catch (Exception error) {
                this.logError("Unable to get an access to fs. " + error.getMessage());
                throw new DataspaceException(error.getMessage());
            }
        } else if (this.fileServerType == FileServerType.DROPBOX) {
            try {
                connection = new DropBoxFileSystemClientConnection();
            }
            catch (Exception error) {
                this.logError("Unable to get an access to fs. " + error.getMessage());
                throw new DataspaceException(error.getMessage());
            }
        } else {
            if (this.fileServerType == FileServerType.NVFS) {
                throw new DataspaceException("Repository file connection is not supported yet.");
            }
            throw new DataspaceException("Unable to create connection due to incorrectly initialized client factory.");
        }
        connection.setServiceLogger(this);
        connection.setExceptionEventListener(e -> {
            this.logError("Connection error: " + e.getMessage());
            this.setLastError("Error on connection " + e.getConnectionName() + ": " + e.getMessage());
        });
        connection.setStateNotificationEventListener(e -> {
            try {
                this.logInfo("Connection state changed to " + String.valueOf((Object)e.getState()) + ", connection name " + e.getConnectionName());
                e.setComponentName(this.dataspace.getType() + "." + this.dataspace.getName());
                this.dataspace.raiseSystemAdvisory(e);
            }
            catch (Exception exception) {
                this.logError("Failed to send advisory. Cause: " + exception.getMessage());
            }
        });
        return connection;
    }

    public void removeConnection(ClientConnection connection) {
        try {
            if (this.clientFactory != null) {
                this.clientFactory.removeConnection(connection.getName());
            }
        }
        catch (ClientFactoryConfigurationException exception) {
            this.logError("Failed to remove connection '" + connection.getName() + "'. Cause: " + exception.getMessage());
        }
    }

    public boolean hasConnection() {
        return this.clientFactory != null;
    }

    public FileServerType getFileServerType() {
        return this.fileServerType;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        this.initServerType();
    }

    @Override
    public void destroy() {
        try {
            this.destroyClientFactory();
        }
        catch (Throwable exception) {
            this.handleException(null, exception);
        }
    }

    private ClientFactory loadClientFactory() throws ClientConfigurationException, RepositoryException, ResolutionException {
        AbstractFabricComponent component = this.dataspace;
        String packageName = PackageType.client.toString() + "." + this.factoryType;
        try {
            if (!PackageLoaderHelper.loadPackageIfRegistered(component, packageName) && !PackageLoaderHelper.loadPackageIfRegistered(component = DataspaceStoreManager.getRuntimeContext(), packageName)) {
                this.logDebug("Package '" + packageName + "' not registered in runtime or dataspace.");
            }
        }
        catch (Exception exception) {
            this.logError("Loading package '" + packageName + "' failed. Cause: " + exception.getMessage());
        }
        ClientFactory factory = ClientConfigurationFactory.loadFactoryObject(component, this.factoryName, this.factoryType, false);
        factory = new GlobalVariablesResolverImpl(VariableFactory.getGlobalVariables()).resolveVariables(factory);
        return factory;
    }

    private void initClientFactory(Session session) throws Exception {
        if (this.dataspace != null) {
            if (this.factoryType != null && this.factoryName != null) {
                try {
                    this.clientFactory = this.loadClientFactory();
                    try {
                        this.monitoringConnection = this.clientFactory.createConnection("sys$MonitoringConnection", this.clientFactory.getDefaultUser(), this.clientFactory.getDefaultPassword());
                        this.monitoringConnection.setExceptionEventListener(e -> {
                            this.logError("Error on monitoring connection " + e.getConnectionName() + ": " + e.getMessage());
                            this.setLastError("Error on monitoring connection " + e.getConnectionName() + ": " + e.getMessage());
                        });
                        this.monitoringConnection.setStateNotificationEventListener(e -> {
                            try {
                                String lastError;
                                this.logInfo("Connection state changed to " + String.valueOf((Object)e.getState()) + ", connection name: " + e.getConnectionName());
                                if (e.getState() == ConnectionState.CONNECTED && (lastError = this.getLastError()) != null && lastError.startsWith("Error on monitoring connection")) {
                                    this.setLastError(null);
                                }
                                this.raiseVirtualServerStateChangeAdvisory(e.getState());
                            }
                            catch (Exception exception) {
                                this.logError("Failed to send advisory. Cause: " + exception.getMessage());
                            }
                        });
                        this.connectConnection(this.monitoringConnection);
                    }
                    catch (Exception exception) {
                        if (this.monitoringConnection != null) {
                            this.removeConnection(this.monitoringConnection);
                        }
                        this.logError("Failed to create monitoring connection.");
                        Trace.logException(this, exception, true);
                        this.raiseVirtualServerStateChangeAdvisory(ConnectionState.CLOSED);
                    }
                }
                catch (Exception error) {
                    this.logError("Failed to create client factory.");
                    Trace.logException(this, error, true);
                    throw new DataspaceException(error.getMessage());
                }
            } else if (this.fileServerType == FileServerType.FS) {
                this.monitoringConnection = new LocalFileSystemClientConnection();
                this.monitoringConnection.connect();
            } else if (this.fileServerType == FileServerType.DROPBOX) {
                this.monitoringConnection = new DropBoxFileSystemClientConnection();
                this.monitoringConnection.connect();
            } else if (this.fileServerType != FileServerType.NVFS) {
                this.logError("Unable to compile file server object because client factory is not specified.");
                throw new DataspaceException("Unable to compile file server object");
            }
            this.initServerType();
            if (!session.isProcessingLog() && !session.isProcessingRecoveryLog()) {
                this.saveServerType(session);
            }
        } else {
            this.logError("Unable to compile file server object because dataspace component is not ready.");
            throw new DataspaceException("Unable to compile file server object");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectConnection(ClientConnection connection) throws ClientException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader systemClassLoaderChain = this.getDataspace().getPackageManifestManager().getManifestClassLoader();
        Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
        try {
            connection.connect();
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    private void destroyClientFactory() throws Exception {
        try {
            if (this.monitoringConnection != null) {
                this.monitoringConnection.disconnect();
                this.monitoringConnection = null;
            }
        }
        finally {
            try {
                if (this.clientFactory != null) {
                    this.clientFactory.destroyAll();
                }
            }
            catch (Throwable exception) {
                this.logError("Failed to destroy client factory.");
                Trace.logException(this, exception, true);
                throw new DataspaceException(exception.getMessage());
            }
            finally {
                this.clientFactory = null;
            }
        }
    }

    @Override
    protected void onStartServer(Session session) {
        if (this.isStarted) {
            return;
        }
        try {
            try {
                this.destroyClientFactory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.initClientFactory(session);
            this.setLastError(null);
            this.isStarted = true;
        }
        catch (Throwable exception) {
            this.isStarted = false;
            this.handleException(session, exception);
            try {
                this.destroyClientFactory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.raiseVirtualServerStateChangeAdvisory(this.getConnectionState());
    }

    @Override
    protected void onStopServer(Session session) {
        try {
            this.destroyClientFactory();
            this.setLastError(null);
            this.isStarted = false;
        }
        catch (Throwable exception) {
            this.handleException(session, exception);
        }
        this.raiseVirtualServerStateChangeAdvisory(this.getConnectionState());
    }

    private void initServerType() {
        ClientFactory factory = this.clientFactory;
        if (factory == null && this.factoryType != null && this.factoryName != null) {
            try {
                factory = this.loadClientFactory();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverType = this.fileServerType.getName();
        if (factory != null) {
            String className = factory.getConnectionClassName();
            if (className != null) {
                if (!(className = className.substring(className.lastIndexOf("."))).startsWith(".Hadoop") && !className.startsWith(".AwsClientConnection")) {
                    this.logError("Unknown connection class name '" + className + "' for factory " + factory.getFactoryType() + "." + factory.getFactoryName());
                }
            } else {
                this.logError("Connection class is null for factory " + factory.getFactoryType() + "." + factory.getFactoryName());
            }
        }
    }

    @Override
    public ConnectionState getConnectionState() {
        ConnectionState state;
        ConnectionState connectionState = state = this.monitoringConnection != null ? this.monitoringConnection.getState() : ConnectionState.CLOSED;
        if (state == null) {
            state = ConnectionState.CLOSED;
        }
        return state;
    }

    private void handleException(Session session, Throwable exception) {
        this.logError(exception.getMessage());
        this.setLastError(exception.getMessage());
        if (session != null && !session.isProcessingRecoveryLog() && !session.isProcessingLog() && session.isInteractive()) {
            throw new DataspaceException(exception.getMessage());
        }
    }

    @Override
    public void describeProperties(Session session, RowSetNavigatorClient navigator) {
        super.describeProperties(session, navigator);
        navigator.add(new Object[]{"Connection State", this.getConnectionState().toString()});
        if (this.clientFactory != null) {
            navigator.add(new Object[]{"URL", this.clientFactory.getUrl()});
            navigator.add(new Object[]{"Is Reliable", this.clientFactory.isReliable()});
            navigator.add(new Object[]{"Connection Check Interval(ms)", this.clientFactory.getCheckInterval()});
        }
        navigator.add(new Object[]{"Is Local Connection", this.getFileServerType() == FileServerType.FS});
        navigator.add(new Object[]{"Is DropBox Connection", this.getFileServerType() == FileServerType.DROPBOX});
        navigator.add(new Object[]{"Is Repository Connection", this.getFileServerType() == FileServerType.NVFS});
    }

    @Override
    public String getSQL(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ').append("FILE").append(' ').append("SERVER").append(' ');
        builder.append(name).append(' ');
        builder.append("TYPE(").append(this.fileServerType.getName()).append(')').append(' ');
        if (this.factoryType != null && this.factoryName != null) {
            builder.append(' ').append("USING").append(" ").append(this.factoryType).append('.').append(this.factoryName);
        }
        return builder.toString();
    }

    @Override
    public boolean isRunning() {
        return this.isStarted;
    }

    public static enum FileServerType {
        FS("FS"),
        DROPBOX("DROPBOX"),
        NVFS("NVFS"),
        HDFS("HDFS"),
        S3("S3");

        private final String name;

        private FileServerType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static FileServerType fromName(String name) {
            for (FileServerType value : FileServerType.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            throw new DataspaceException("Invalid server type '" + name + "' specified. Allowed values: " + Stream.of(FileServerType.values()).map(v -> v.name()).collect(Collectors.joining(",")));
        }
    }
}

