/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.server;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExternalExecutionExpression;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.server.NoSqlServerObject;
import com.streamscape.ds.schema.server.QueryableServer;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.server.ServerRole;
import com.streamscape.ds.session.Session;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.factory.connection.FactoryConnectionService;
import com.streamscape.sef.factory.connection.UsableClientConnection;
import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalParser;
import com.streamscape.sef.factory.connection.external.ExternalParserContext;
import com.streamscape.sef.pkg.PackageLoaderHelper;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.globals.GlobalVariablesResolverImpl;
import com.streamscape.slex.SemanticLexiconProcessor;
import com.streamscape.tools.parser.ParserException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractVirtualClientServerObject
extends ServerObject
implements QueryableServer {
    protected Map<String, Expression> properties;
    protected ClientFactory clientFactory;
    protected ClientConnection clientConnection;
    protected final ReentrantLock clientConnectionLock = new ReentrantLock();
    protected FactoryConnectionService connectionService;
    protected boolean isStarted = false;
    protected String namePrefix;
    protected SemanticLexiconProcessor lexiconProcessor;

    protected AbstractVirtualClientServerObject(DataspaceStore store, NameManager.ObjectName name, ServerRole serverRole) {
        super(store, name, serverRole);
        if (serverRole == ServerRole.NOSQL) {
            this.namePrefix = "NoSql";
        } else if (serverRole == ServerRole.MESSAGE) {
            this.namePrefix = "Message";
        } else if (serverRole == ServerRole.WEB) {
            this.namePrefix = "Web";
        } else {
            throw new DataspaceException("Invalid server role " + String.valueOf((Object)serverRole));
        }
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        try {
            try {
                this.destroyClientFactory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.initClientFactory(session);
            this.setLastError(null);
        }
        catch (Throwable exception) {
            this.handleException(session, exception);
            try {
                this.destroyClientFactory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void destroy() {
        try {
            this.destroyClientFactory();
        }
        catch (Throwable exception) {
            this.handleException(null, exception);
        }
    }

    @Override
    public ExternalParser getExternalParser() {
        return this.connectionService != null ? this.connectionService.getExternalParser() : null;
    }

    @Override
    public FactoryConnectionService getConnectionService() {
        return this.connectionService;
    }

    @Override
    protected void onStartServer(Session session) {
        if (this.isStarted) {
            throw new DataspaceException("Server already started.");
        }
        try {
            try {
                this.destroyClientFactory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.initClientFactory(session);
            this.isStarted = true;
            if (this.connectionService != null) {
                this.connectionService.init(this.dataspace, this);
            }
            this.setLastError(null);
        }
        catch (Throwable exception) {
            try {
                this.destroyClientFactory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.isStarted = false;
            this.handleException(session, exception);
        }
        this.raiseVirtualServerStateChangeAdvisory(this.getConnectionState());
    }

    @Override
    protected void onStopServer(Session session) {
        if (this.isStarted) {
            try {
                this.destroyClientFactory();
                this.setLastError(null);
                this.isStarted = false;
            }
            catch (Throwable exception) {
                this.handleException(session, exception);
            }
            this.raiseVirtualServerStateChangeAdvisory(this.getConnectionState());
        }
    }

    private void handleException(Session session, Throwable exception) {
        this.logError(exception.getMessage());
        this.setLastError(exception.getMessage());
        if (session != null && !session.isProcessingRecoveryLog() && !session.isProcessingLog() && session.isInteractive()) {
            throw new DataspaceException(exception);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClientFactory(Session session) throws Exception {
        if (this.dataspace == null) {
            throw new Exception("Dataspace component is not ready.");
        }
        try {
            AbstractFabricComponent component = this.dataspace;
            String packageName = PackageType.client.toString() + "." + this.factoryType;
            try {
                if (!PackageLoaderHelper.loadPackageIfRegistered(component, packageName) && !PackageLoaderHelper.loadPackageIfRegistered(component = DataspaceStoreManager.getRuntimeContext(), packageName)) {
                    this.logInfo("WARNING: Package '" + packageName + "' is not registered in Runtime Manifest or Dataspace Manifest.");
                }
            }
            catch (Throwable exception2) {
                this.logError("Loading package '" + packageName + "' failed. Cause: " + exception2.getMessage());
            }
            this.clientFactory = ClientConfigurationFactory.loadFactoryObject(component, this.factoryName, this.factoryType, false);
            if (this.properties != null) {
                for (Map.Entry<String, Expression> entry : this.properties.entrySet()) {
                    Result result = entry.getValue().getResult(session);
                    RowSetNavigator navigator = result.getNavigator();
                    if (!navigator.next()) {
                        throw new DataspaceException("Property expression does not return value.");
                    }
                    if (navigator.getCurrent().length != 1) {
                        throw new DataspaceException("Property expression does not return single value.");
                    }
                    Object value = navigator.getCurrent(0);
                    this.logInfo("Overriding property '" + entry.getKey() + "' with value '" + String.valueOf(value) + "'.");
                    this.clientFactory.setProperty(entry.getKey(), String.valueOf(value));
                }
            }
            this.clientFactory = new GlobalVariablesResolverImpl(VariableFactory.getGlobalVariables()).resolveVariables(this.clientFactory);
            this.doInitServerType();
            if (!session.isProcessingLog() && !session.isProcessingRecoveryLog()) {
                this.saveServerType(session);
            }
            this.clientConnectionLock.lock();
            try {
                this.clientConnection = this.clientFactory.createConnection(this.namePrefix + "ClientConnection$" + this.getFactoryType() + "." + this.getFactoryName(), this.clientFactory.getDefaultUser(), this.clientFactory.getDefaultPassword());
                this.clientConnection.setServiceLogger(this);
                if (!(this.clientConnection instanceof UsableClientConnection)) {
                    throw new Exception("Invalid client factory " + this.factoryType + "." + this.factoryName + ". Should be usable.");
                }
                this.connectionService = ((UsableClientConnection)((Object)this.clientConnection)).createConnectionService();
                this.clientConnection.setExceptionEventListener(exception -> {
                    this.logError("Connection error: " + exception.getMessage());
                    this.setLastError(exception.getMessage());
                });
                this.clientConnection.setStateNotificationEventListener(event -> {
                    try {
                        this.logInfo("Connection state changed to " + String.valueOf((Object)event.getState()) + " for connection '" + event.getConnectionName() + "'.");
                        event.setComponentName(this.dataspace.getType() + "." + this.dataspace.getName());
                        this.dataspace.raiseSystemAdvisory(event);
                        if (event.getState() == ConnectionState.CONNECTED) {
                            this.setLastError(null);
                        }
                    }
                    catch (Exception exception) {
                        this.logError("Raising state change advisory failed. Cause: " + exception.getMessage());
                    }
                    this.raiseVirtualServerStateChangeAdvisory(event.getState());
                });
            }
            finally {
                this.clientConnectionLock.unlock();
            }
        }
        catch (Throwable exception3) {
            Trace.logException(this, exception3, true);
            throw new DataspaceException(exception3);
        }
    }

    protected ClientConnection getClientConnection() {
        this.clientConnectionLock.lock();
        try {
            ClientConnection clientConnection = this.clientConnection;
            return clientConnection;
        }
        finally {
            this.clientConnectionLock.unlock();
        }
    }

    private void destroyClientFactory() throws Exception {
        try {
            if (this.connectionService != null) {
                this.connectionService.destroy();
                this.connectionService = null;
            }
            if (this.clientConnection != null) {
                this.clientConnection.disconnect();
                this.clientConnection = null;
            }
        }
        finally {
            try {
                if (this.clientFactory != null) {
                    this.clientFactory.destroyAll();
                }
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
                throw new DataspaceException(exception);
            }
            finally {
                this.clientFactory = null;
            }
        }
    }

    protected abstract void doInitServerType();

    @Override
    public ConnectionState getConnectionState() {
        ConnectionState state;
        ConnectionState connectionState = state = this.clientConnection != null ? this.clientConnection.getState() : ConnectionState.CLOSED;
        if (state == null) {
            state = ConnectionState.CLOSED;
        }
        return state;
    }

    public Map<String, Expression> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Expression> properties) {
        this.properties = properties;
    }

    @Override
    public void describeProperties(Session session, RowSetNavigatorClient navigator) {
        super.describeProperties(session, navigator);
        navigator.add(new Object[]{"Connection State", this.getConnectionState().toString()});
        if (this.getProperties() != null && this.getProperties().size() > 0) {
            navigator.add(new Object[]{"Properties", ""});
            for (Map.Entry<String, Expression> entry : this.getProperties().entrySet()) {
                navigator.add(new Object[]{"", entry.getKey() + " = " + entry.getValue().getSQL()});
            }
        }
    }

    @Override
    public String getSQL(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ');
        builder.append("VIRTUAL").append(' ');
        builder.append(this.doGetSQLServerTypeRole()).append(' ');
        builder.append("SERVER").append(' ');
        builder.append(name).append(' ');
        if (this.serverRole == ServerRole.WEB && this.serverType != null || NoSqlServerObject.NoSqlServerType.DYNAMODB.name().equalsIgnoreCase(this.serverType)) {
            builder.append("TYPE(").append(this.serverType).append(")").append(' ');
        }
        builder.append(' ').append("USING").append(" ").append(this.factoryType).append('.').append(this.factoryName);
        if (this.properties != null) {
            boolean first = true;
            builder.append(' ').append("PROPERTIES").append("(");
            for (Map.Entry<String, Expression> param : this.properties.entrySet()) {
                if (!first) {
                    builder.append(",");
                } else {
                    first = false;
                }
                builder.append(param.getKey()).append("=").append(param.getValue().getSQL());
            }
            builder.append(")");
        }
        return builder.toString();
    }

    protected String doGetSQLServerTypeRole() {
        return this.serverRole.name();
    }

    public Object executeQuery(Session session, String query, Class<?> targetClass) {
        try {
            ParserCommand parserCommand = new ParserCommand(session, new Scanner(query));
            ExternalParserContext<Expression> externalParserContext = parserCommand.createExternalParserContext(0);
            ExecutionStatement statement = this.getExternalParser().parse(query, externalParserContext);
            return statement.execute(new ExternalExecutionExpression.ExternalExecutionContextImpl(session, this), targetClass);
        }
        catch (ParserException exception) {
            throw new DataspaceException(exception);
        }
        catch (Exception exception) {
            throw new DataspaceException(exception);
        }
    }

    public SemanticLexiconProcessor getLexiconProcessor() {
        if (this.lexiconProcessor == null) {
            this.lexiconProcessor = this.doCreateLexiconProcessor();
        }
        return this.lexiconProcessor;
    }

    protected SemanticLexiconProcessor doCreateLexiconProcessor() {
        return this.connectionService.getLexiconProcessor();
    }
}

