/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.sequence;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberSequence
implements SchemaObject {
    public static final NumberSequence[] emptyArray = new NumberSequence[0];
    private NameManager.ObjectName name;
    private long currValue;
    private long lastValue;
    private boolean limitReached;
    private long startValue;
    private long minValue;
    private long maxValue;
    private long increment;
    private Type dataType;
    private boolean isCycle;
    private boolean isAlways;
    private boolean restartValueDefault;
    private String comment;
    private boolean commentWasChanged;

    public NumberSequence() {
        try {
            this.setDefaults(null, Type.SQL_BIGINT);
        }
        catch (DataspaceException dataspaceException) {
            // empty catch block
        }
    }

    public NumberSequence(NameManager.ObjectName name, Type type) {
        this.setDefaults(name, type);
    }

    public void setDefaults(NameManager.ObjectName name, Type type) {
        long max;
        this.name = name;
        this.dataType = type;
        this.name = name;
        this.minValue = switch (this.dataType.typeCode) {
            case -6 -> {
                max = 127L;
                yield -128L;
            }
            case 5 -> {
                max = 32767L;
                yield -32768L;
            }
            case 4 -> {
                max = Integer.MAX_VALUE;
                yield Integer.MIN_VALUE;
            }
            case 1117 -> {
                max = Long.MAX_VALUE;
                yield Long.MIN_VALUE;
            }
            case 2, 3, 25 -> {
                if (type.scale == 0) {
                    max = Long.MAX_VALUE;
                    yield Long.MIN_VALUE;
                }
            }
            default -> throw Error.error(5563);
        };
        this.maxValue = max;
        this.increment = 1L;
    }

    public NumberSequence(NameManager.ObjectName name, long value, long increment, Type type) {
        this(name, type);
        this.setStartValue(value);
        this.setIncrement(increment);
    }

    @Override
    public int getObjectType() {
        return 8;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        return this.getSQL(name, this.getSchemaName().name);
    }

    public String getSQL(String name, String schemaName) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ');
        sb.append("SEQUENCE").append(' ');
        sb.append(name).append(' ');
        sb.append("AS").append(' ');
        sb.append(this.getDataType().getNameString()).append(' ');
        sb.append("START").append(' ');
        sb.append("WITH").append(' ');
        sb.append(this.startValue);
        if (this.getIncrement() != 1L) {
            sb.append(' ').append("INCREMENT").append(' ');
            sb.append("BY").append(' ');
            sb.append(this.getIncrement());
        }
        if (!this.hasDefaultMinMax()) {
            sb.append(' ').append("MINVALUE").append(' ');
            sb.append(this.getMinValue());
            sb.append(' ').append("MAXVALUE").append(' ');
            sb.append(this.getMaxValue());
        }
        if (this.isCycle()) {
            sb.append(' ').append("CYCLE");
        }
        if (this.comment != null) {
            sb.append(' ').append("COMMENT").append(" '").append(this.comment != null ? this.comment.replace("'", "''") : "").append("'");
        }
        this.commentWasChanged = false;
        if (name == null) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String getSQLColumnDefinition() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("GENERATED").append(' ');
        if (this.name == null) {
            if (this.isAlways()) {
                sb.append("ALWAYS");
            } else {
                sb.append("BY").append(' ').append("DEFAULT");
            }
            sb.append(' ').append("AS").append(' ').append("IDENTITY").append("(");
            sb.append("START").append(' ');
            sb.append("WITH").append(' ');
            sb.append(this.startValue);
            if (this.getIncrement() != 1L) {
                sb.append(' ').append("INCREMENT").append(' ');
                sb.append("BY").append(' ');
                sb.append(this.getIncrement());
            }
            if (!this.hasDefaultMinMax()) {
                sb.append(' ').append("MINVALUE").append(' ');
                sb.append(this.getMinValue());
                sb.append(' ').append("MAXVALUE").append(' ');
                sb.append(this.getMaxValue());
            }
            if (this.isCycle()) {
                sb.append(' ').append("CYCLE");
            }
            if (this.name == null) {
                sb.append(")");
            }
        } else {
            sb.append("BY").append(' ').append("DEFAULT");
            sb.append(' ').append("AS").append(' ');
            sb.append("SEQUENCE").append(' ');
            sb.append(this.getObjectName().getSchemaQualifiedStatementName());
        }
        this.commentWasChanged = false;
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getRestartSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("ALTER").append(' ');
        sb.append("SEQUENCE");
        sb.append(' ').append(this.name.getSchemaQualifiedStatementName());
        sb.append(' ').append("RESTART");
        sb.append(' ').append("WITH").append(' ').append(this.peek());
        if (this.commentWasChanged) {
            sb.append(' ').append("COMMENT").append(" '").append(this.comment != null ? this.comment.replace("'", "''") : "").append("'");
        }
        this.commentWasChanged = false;
        return sb.toString();
    }

    public static String getRestartSQL(Table t) {
        return NumberSequence.getRestartSQL(t, t.getObjectName().getSchemaQualifiedStatementName());
    }

    public static String getRestartSQL(Table t, String objectName) {
        String colname = t.getColumn((int)t.identityColumn).getObjectName().statementName;
        NumberSequence seq = t.identitySequence;
        StringBuffer sb = new StringBuffer(128);
        sb.append("ALTER").append(' ').append("COLLECTION");
        sb.append(' ').append(objectName);
        sb.append(' ').append("ALTER").append(' ');
        sb.append("TUPLE");
        sb.append(' ').append(colname);
        sb.append(' ').append("RESTART");
        sb.append(' ').append("WITH").append(' ').append(seq.peek());
        return sb.toString();
    }

    public Type getDataType() {
        return this.dataType;
    }

    public long getIncrement() {
        return this.increment;
    }

    public synchronized long getStartValue() {
        return this.startValue;
    }

    public synchronized long getMinValue() {
        return this.minValue;
    }

    public synchronized long getMaxValue() {
        return this.maxValue;
    }

    public synchronized boolean isCycle() {
        return this.isCycle;
    }

    public synchronized boolean isAlways() {
        return this.isAlways;
    }

    public synchronized boolean hasDefaultMinMax() {
        long max;
        return this.minValue == (switch (this.dataType.typeCode) {
            case -6 -> {
                max = 127L;
                yield -128L;
            }
            case 5 -> {
                max = 32767L;
                yield -32768L;
            }
            case 4 -> {
                max = Integer.MAX_VALUE;
                yield Integer.MIN_VALUE;
            }
            case 1117 -> {
                max = Long.MAX_VALUE;
                yield Long.MIN_VALUE;
            }
            case 2, 3, 25 -> {
                max = Long.MAX_VALUE;
                yield Long.MIN_VALUE;
            }
            default -> throw Error.runtimeError(201, "NumberSequence");
        }) && this.maxValue == max;
    }

    synchronized void setStartValue(long value) {
        if (value < this.minValue || value > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = (this.startValue = value);
    }

    synchronized void setMinValue(long value) {
        this.checkInTypeRange(value);
        if (value >= this.maxValue || this.currValue < value) {
            throw Error.error(5597);
        }
        this.minValue = value;
    }

    public synchronized void setDefaultMinValue() {
        this.minValue = this.getDefaultMinOrMax(false);
    }

    synchronized void setMaxValue(long value) {
        this.checkInTypeRange(value);
        if (value <= this.minValue || this.currValue > value) {
            throw Error.error(5597);
        }
        this.maxValue = value;
    }

    public synchronized void setDefaultMaxValue() {
        this.maxValue = this.getDefaultMinOrMax(true);
    }

    public synchronized void setIncrement(long value) {
        if (value < -16384L || value > 16383L) {
            throw Error.error(5597);
        }
        this.increment = value;
    }

    public synchronized void setCurrentValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.currValue = this.lastValue = value;
    }

    public synchronized void setStartValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.currValue = this.lastValue = (this.startValue = value);
    }

    public synchronized void setStartValueDefault() {
        this.restartValueDefault = true;
    }

    public synchronized void setMinValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.minValue = value;
    }

    public synchronized void setMaxValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.maxValue = value;
    }

    public synchronized void setCycle(boolean value) {
        this.isCycle = value;
    }

    public synchronized void setAlways(boolean value) {
        this.isAlways = value;
    }

    private long getDefaultMinOrMax(boolean isMax) {
        long max;
        return isMax ? max : (switch (this.dataType.typeCode) {
            case -6 -> {
                max = 127L;
                yield -128L;
            }
            case 5 -> {
                max = 32767L;
                yield -32768L;
            }
            case 4 -> {
                max = Integer.MAX_VALUE;
                yield Integer.MIN_VALUE;
            }
            case 1117 -> {
                max = Long.MAX_VALUE;
                yield Long.MIN_VALUE;
            }
            case 2, 3, 25 -> {
                max = Long.MAX_VALUE;
                yield Long.MIN_VALUE;
            }
            default -> throw Error.runtimeError(201, "NumberSequence");
        });
    }

    private void checkInTypeRange(long value) {
        long max;
        if (value < (switch (this.dataType.typeCode) {
            case -6 -> {
                max = 127L;
                yield -128L;
            }
            case 5 -> {
                max = 32767L;
                yield -32768L;
            }
            case 4 -> {
                max = Integer.MAX_VALUE;
                yield Integer.MIN_VALUE;
            }
            case 1117 -> {
                max = Long.MAX_VALUE;
                yield Long.MIN_VALUE;
            }
            case 2, 3, 25 -> {
                max = Long.MAX_VALUE;
                yield Long.MIN_VALUE;
            }
            default -> throw Error.runtimeError(201, "NumberSequence");
        }) || value > max) {
            throw Error.error(5597);
        }
    }

    public synchronized void checkValues() {
        if (this.restartValueDefault) {
            this.currValue = this.lastValue = this.startValue;
            this.restartValueDefault = false;
        }
        if (this.minValue >= this.maxValue || this.startValue < this.minValue || this.startValue > this.maxValue || this.currValue < this.minValue || this.currValue > this.maxValue) {
            throw Error.error(5597);
        }
    }

    public synchronized NumberSequence duplicate() {
        NumberSequence copy = new NumberSequence();
        copy.name = this.name;
        copy.startValue = this.startValue;
        copy.currValue = this.currValue;
        copy.lastValue = this.lastValue;
        copy.increment = this.increment;
        copy.dataType = this.dataType;
        copy.minValue = this.minValue;
        copy.maxValue = this.maxValue;
        copy.isCycle = this.isCycle;
        copy.isAlways = this.isAlways;
        copy.comment = this.comment;
        copy.commentWasChanged = this.commentWasChanged;
        return copy;
    }

    public synchronized void reset(NumberSequence other) {
        this.name = other.name;
        this.startValue = other.startValue;
        this.currValue = other.currValue;
        this.lastValue = other.lastValue;
        this.increment = other.increment;
        this.dataType = other.dataType;
        this.minValue = other.minValue;
        this.maxValue = other.maxValue;
        this.isCycle = other.isCycle;
        this.isAlways = other.isAlways;
        this.comment = other.comment;
        this.commentWasChanged = other.commentWasChanged;
    }

    public synchronized long userUpdate(long value) {
        if (value == this.currValue) {
            this.currValue += this.increment;
            return value;
        }
        if (this.increment > 0L) {
            if (value > this.currValue) {
                this.currValue += (value - this.currValue + this.increment) / this.increment * this.increment;
            }
        } else if (value < this.currValue) {
            this.currValue += (value - this.currValue + this.increment) / this.increment * this.increment;
        }
        return value;
    }

    public synchronized long systemUpdate(long value) {
        if (value == this.currValue) {
            this.currValue += this.increment;
            return value;
        }
        if (this.increment > 0L) {
            if (value > this.currValue) {
                this.currValue = value + this.increment;
            }
        } else if (value < this.currValue) {
            this.currValue = value + this.increment;
        }
        return value;
    }

    public synchronized Object getValueObject() {
        long value = this.getValue();
        return switch (this.dataType.typeCode) {
            default -> ValuePool.getInt((int)value);
            case 1117 -> ValuePool.getLong(value);
            case 25 -> ValuePool.getBigInteger(new BigInteger(Long.toString(value)));
            case 2, 3 -> ValuePool.getBigDecimal(new BigDecimal(value));
        };
    }

    public synchronized long getValue() {
        long nextValue;
        if (this.limitReached) {
            throw Error.error(3416);
        }
        if (this.increment > 0L) {
            if (this.currValue > this.maxValue - this.increment) {
                if (this.isCycle) {
                    nextValue = this.minValue;
                } else {
                    this.limitReached = true;
                    nextValue = this.minValue;
                }
            } else {
                nextValue = this.currValue + this.increment;
            }
        } else if (this.currValue < this.minValue - this.increment) {
            if (this.isCycle) {
                nextValue = this.maxValue;
            } else {
                this.limitReached = true;
                nextValue = this.minValue;
            }
        } else {
            nextValue = this.currValue + this.increment;
        }
        if (this.limitReached) {
            throw Error.error(3416);
        }
        long result = this.currValue;
        this.currValue = nextValue;
        this.lastValue = result;
        return result;
    }

    public synchronized void reset() {
        this.lastValue = this.currValue = this.startValue;
        this.limitReached = false;
    }

    public synchronized long peek() {
        return this.currValue;
    }

    public synchronized long getLastValue() {
        return this.lastValue;
    }

    synchronized boolean resetWasUsed() {
        boolean result = this.lastValue != this.currValue;
        this.lastValue = this.currValue;
        return result;
    }

    public synchronized void reset(long value) {
        if (value < this.minValue || value > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = value;
        this.startValue = this.lastValue;
        this.limitReached = false;
    }

    public synchronized boolean isLimitReached() {
        return this.limitReached;
    }

    public synchronized String getComment() {
        return this.comment;
    }

    public synchronized void setComment(String comment) {
        this.comment = comment;
        this.commentWasChanged = true;
    }

    @Override
    public String getSQLInSchema(String schemaName) {
        return this.getSQL(this.getObjectName().statementName, schemaName);
    }
}

