/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure.phonetic;

import com.streamscape.ds.schema.procedure.phonetic.Comparator;
import com.streamscape.ds.schema.procedure.phonetic.ComparatorException;
import java.util.HashSet;
import java.util.Set;

public class QGram
implements Comparator {
    public static String NAME = "qgram";
    private Formula formula = Formula.OVERLAP;
    private Tokenizer tokenizer = Tokenizer.BASIC;
    private int q = 2;

    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public double compare(String s1, String s2) {
        if (s1.equals(s2)) {
            return 1.0;
        }
        Set<String> q1 = this.qgrams(s1);
        Set<String> q2 = this.qgrams(s2);
        if (q1.isEmpty() || q2.isEmpty()) {
            return 0.0;
        }
        int common = 0;
        for (String gram : q1) {
            if (!q2.contains(gram)) continue;
            ++common;
        }
        switch (this.formula.ordinal()) {
            case 0: {
                return QGram.overlap(common, q1, q2);
            }
            case 1: {
                return QGram.dice(common, q1, q2);
            }
            case 2: {
                return QGram.jaccard(common, q1, q2);
            }
        }
        throw new ComparatorException("Invalid strategy hint: " + String.valueOf((Object)this.formula));
    }

    public void setQ(int q) {
        this.q = q;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public Set<String> qgrams(String s) {
        switch (this.tokenizer.ordinal()) {
            case 0: {
                return QGram.basicTokens(s, this.q);
            }
            case 1: {
                return QGram.positionalTokens(s, this.q);
            }
            case 2: {
                return QGram.endsTokens(s, this.q);
            }
        }
        throw new ComparatorException("Invalid tokenizer type: " + String.valueOf((Object)this.tokenizer));
    }

    public static Set<String> basicTokens(String s, int q) {
        HashSet<String> grams = new HashSet<String>();
        for (int ix = 0; ix < s.length() - q + 1; ++ix) {
            grams.add(s.substring(ix, ix + q));
        }
        return grams;
    }

    public static Set<String> positionalTokens(String s, int q) {
        HashSet<String> grams = new HashSet<String>();
        for (int ix = 0; ix < s.length() - q + 1; ++ix) {
            grams.add(s.substring(ix, ix + q) + ix);
        }
        return grams;
    }

    public static Set<String> endsTokens(String s, int q) {
        int ix;
        HashSet<String> grams = new HashSet<String>();
        for (ix = 1; ix < q; ++ix) {
            grams.add(QGram.pad(s.substring(0, ix), q, true));
        }
        for (ix = 0; ix < s.length() - q + 1; ++ix) {
            grams.add(s.substring(ix, ix + q));
        }
        for (ix = 1; ix < q; ++ix) {
            grams.add(QGram.pad(s.substring(s.length() - ix), q, false));
        }
        return grams;
    }

    private static String pad(String s, int q, boolean front) {
        StringBuffer buf = new StringBuffer(q);
        if (!front) {
            buf.append(s);
        }
        for (int ix = 0; ix < q - s.length(); ++ix) {
            buf.append('.');
        }
        if (front) {
            buf.append(s);
        }
        return buf.toString();
    }

    public static double overlap(int common, Set<String> q1, Set<String> q2) {
        return (double)common / Math.min((double)q1.size(), (double)q2.size());
    }

    public static double dice(int common, Set<String> q1, Set<String> q2) {
        return (double)common / (double)(q1.size() + q2.size() - common);
    }

    public static double jaccard(int common, Set<String> q1, Set<String> q2) {
        return 2.0 * (double)common / (double)(q1.size() + q2.size());
    }

    public static enum Formula {
        OVERLAP,
        DICE,
        JACCARD;

    }

    public static enum Tokenizer {
        BASIC,
        POSITIONAL,
        ENDS;

    }
}

