/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure.phonetic;

public class LevenshteinPercent {
    public double compare(String s1, String s2) {
        double retval = 0.0;
        int n = s1.length();
        int m = s2.length();
        retval = 0 == n ? (double)m : (0 == m ? (double)n : 1.0 - this.compare(s1, n, s2, m) / (double)Math.max(n, m));
        return retval;
    }

    private double compare(String s1, int n, String s2, int m) {
        int i;
        int[][] matrix = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            matrix[i][0] = i;
        }
        for (i = 0; i <= m; ++i) {
            matrix[0][i] = i;
        }
        for (i = 1; i <= n; ++i) {
            int s1i = s1.codePointAt(i - 1);
            for (int j = 1; j <= m; ++j) {
                int s2j = s2.codePointAt(j - 1);
                int cost = s1i == s2j ? 0 : 1;
                matrix[i][j] = this.min3(matrix[i - 1][j] + 1, matrix[i][j - 1] + 1, matrix[i - 1][j - 1] + cost);
            }
        }
        return matrix[n][m];
    }

    private int min3(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }
}

