/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure.phonetic;

import com.streamscape.ds.schema.procedure.phonetic.Comparator;

public class LevenshteinAlt
implements Comparator {
    @Override
    public double compare(String s1, String s2) {
        int maxlen;
        int len = Math.min(s1.length(), s2.length());
        if ((double)len / (double)(maxlen = Math.max(s1.length(), s2.length())) <= 0.5) {
            return 0.0;
        }
        if (len == maxlen && s1.equals(s2)) {
            return 1.0;
        }
        int dist = Math.min(LevenshteinAlt.distance(s1, s2, maxlen), len);
        return 1.0 - (double)dist / (double)len;
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    public static double distance(String s1, String s2, WeightEstimator weight) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int s1len = s1.length();
        double[] matrix = new double[(s1len + 1) * (s2.length() + 1)];
        for (int col = 0; col <= s2.length(); ++col) {
            matrix[col * s1len] = col;
        }
        for (int row = 0; row <= s1len; ++row) {
            matrix[row] = row;
        }
        for (int ix1 = 0; ix1 < s1len; ++ix1) {
            char ch1 = s1.charAt(ix1);
            for (int ix2 = 0; ix2 < s2.length(); ++ix2) {
                double cost = ch1 == s2.charAt(ix2) ? 0.0 : weight.substitute(ch1, s2.charAt(ix2));
                double left = matrix[ix1 + (ix2 + 1) * s1len] + weight.delete(ch1);
                double above = matrix[ix1 + 1 + ix2 * s1len] + weight.insert(ch1);
                double aboveleft = matrix[ix1 + ix2 * s1len] + cost;
                matrix[ix1 + 1 + (ix2 + 1) * s1len] = Math.min(left, Math.min(above, aboveleft));
            }
        }
        return matrix[s1len + s2.length() * s1len];
    }

    public static int distance(String s1, String s2, int maxlen) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int maxdist = Math.min(s1.length(), s2.length()) / 2;
        int s1len = s1.length();
        int[] matrix = new int[(s1len + 1) * (s2.length() + 1)];
        for (int col = 0; col <= s2.length(); ++col) {
            matrix[col * s1len] = col;
        }
        for (int row = 0; row <= s1len; ++row) {
            matrix[row] = row;
        }
        for (int ix1 = 0; ix1 < s1len; ++ix1) {
            char ch1 = s1.charAt(ix1);
            for (int ix2 = 0; ix2 < s2.length(); ++ix2) {
                int cost = ch1 == s2.charAt(ix2) ? 0 : 1;
                int left = matrix[ix1 + (ix2 + 1) * s1len] + 1;
                int above = matrix[ix1 + 1 + ix2 * s1len] + 1;
                int aboveleft = matrix[ix1 + ix2 * s1len] + cost;
                int distance = Math.min(left, Math.min(above, aboveleft));
                if (ix1 == ix2 && distance > maxdist) {
                    return distance;
                }
                matrix[ix1 + 1 + (ix2 + 1) * s1len] = distance;
            }
        }
        return matrix[s1len + s2.length() * s1len];
    }

    public class WeightEstimator {
        public WeightEstimator(LevenshteinAlt this$0) {
        }

        public double substitute(char ch1, char ch2) {
            return this.insert(ch1);
        }

        public double delete(char ch) {
            return this.insert(ch);
        }

        public double insert(char ch) {
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                return 1.0;
            }
            if (ch >= '0' && ch <= '9') {
                return 2.0;
            }
            if (ch == ' ' || ch == '\'' || ch == ',' || ch == '-') {
                return 0.1;
            }
            return 1.0;
        }
    }
}

