/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure.phonetic;

import com.streamscape.ds.schema.procedure.phonetic.Comparator;

public class Levenshtein
implements Comparator {
    public static String NAME = "levenshtein";

    @Override
    public double compare(String s1, String s2) {
        int maxlen;
        int len = Math.min(s1.length(), s2.length());
        if ((double)len / (double)(maxlen = Math.max(s1.length(), s2.length())) <= 0.5) {
            return 0.0;
        }
        if (len == maxlen && s1.equals(s2)) {
            return 1.0;
        }
        int dist = Math.min(Levenshtein.distance(s1, s2), len);
        return 1.0 - (double)dist / (double)len;
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    public static int distance(String s1, String s2) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int s1len = s1.length();
        int[] matrix = new int[(s1len + 1) * (s2.length() + 1)];
        for (int col = 0; col <= s2.length(); ++col) {
            matrix[col * s1len] = col;
        }
        for (int row = 0; row <= s1len; ++row) {
            matrix[row] = row;
        }
        for (int ix1 = 0; ix1 < s1len; ++ix1) {
            char ch1 = s1.charAt(ix1);
            for (int ix2 = 0; ix2 < s2.length(); ++ix2) {
                int cost = ch1 == s2.charAt(ix2) ? 0 : 1;
                int left = matrix[ix1 + (ix2 + 1) * s1len] + 1;
                int above = matrix[ix1 + 1 + ix2 * s1len] + 1;
                int aboveleft = matrix[ix1 + ix2 * s1len] + cost;
                matrix[ix1 + 1 + (ix2 + 1) * s1len] = Math.min(left, Math.min(above, aboveleft));
            }
        }
        return matrix[s1len + s2.length() * s1len];
    }

    public static int cutoffDistance(String s1, String s2) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int maxdist = Math.min(s1.length(), s2.length()) / 2;
        int s1len = s1.length();
        int[] matrix = new int[(s1len + 1) * (s2.length() + 1)];
        for (int col = 0; col <= s2.length(); ++col) {
            matrix[col * s1len] = col;
        }
        for (int row = 0; row <= s1len; ++row) {
            matrix[row] = row;
        }
        for (int ix1 = 0; ix1 < s1len; ++ix1) {
            char ch1 = s1.charAt(ix1);
            for (int ix2 = 0; ix2 < s2.length(); ++ix2) {
                int cost = ch1 == s2.charAt(ix2) ? 0 : 1;
                int left = matrix[ix1 + (ix2 + 1) * s1len] + 1;
                int above = matrix[ix1 + 1 + ix2 * s1len] + 1;
                int aboveleft = matrix[ix1 + ix2 * s1len] + cost;
                int distance = Math.min(left, Math.min(above, aboveleft));
                if (ix1 == ix2 && distance > maxdist) {
                    return distance;
                }
                matrix[ix1 + 1 + (ix2 + 1) * s1len] = distance;
            }
        }
        return matrix[s1len + s2.length() * s1len];
    }

    public static int recursiveDistance(String s1, String s2) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int[] matrix = new int[(s1.length() + 1) * (s2.length() + 1)];
        for (int ix = 1; ix < matrix.length; ++ix) {
            matrix[ix] = -1;
        }
        return Levenshtein.computeRecursively(matrix, s1, s2, s1.length(), s2.length());
    }

    private static int computeRecursively(int[] matrix, String s1, String s2, int ix1, int ix2) {
        int distance;
        if (ix1 == 0) {
            return ix2;
        }
        if (ix2 == 0) {
            return ix1;
        }
        int pos = ix1 + ix2 * s1.length();
        if (matrix[pos] != -1) {
            return matrix[pos];
        }
        int lowest = Math.abs(ix1 - ix2);
        int smallest = Math.min(ix1, ix2);
        int cost_smallest = matrix[smallest + smallest * s1.length()];
        if (cost_smallest != -1) {
            lowest += cost_smallest;
        }
        int cost = s1.charAt(ix1 - 1) == s2.charAt(ix2 - 1) ? 0 : 1;
        int aboveleft = Levenshtein.computeRecursively(matrix, s1, s2, ix1 - 1, ix2 - 1);
        if (aboveleft == lowest) {
            matrix[pos] = lowest + cost;
            return lowest + cost;
        }
        int above = Levenshtein.computeRecursively(matrix, s1, s2, ix1, ix2 - 1);
        int left = above > lowest ? Levenshtein.computeRecursively(matrix, s1, s2, ix1 - 1, ix2) : above;
        matrix[pos] = distance = Math.min(left, Math.min(above, aboveleft)) + cost;
        return distance;
    }

    public static int compactDistance(String s1, String s2) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int maxdist = Math.min(s1.length(), s2.length()) / 2;
        int s1len = s1.length();
        int[] column = new int[s1len + 1];
        int ix2 = 0;
        char ch2 = s2.charAt(ix2);
        column[0] = 1;
        for (int ix1 = 1; ix1 <= s1len; ++ix1) {
            int cost = s1.charAt(ix1 - 1) == ch2 ? 0 : 1;
            column[ix1] = Math.min(column[ix1 - 1], ix1 - 1) + cost;
        }
        int above = 0;
        for (ix2 = 1; ix2 < s2.length(); ++ix2) {
            ch2 = s2.charAt(ix2);
            above = ix2 + 1;
            int smallest = s1len * 2;
            for (int ix1 = 1; ix1 <= s1len; ++ix1) {
                int cost = s1.charAt(ix1 - 1) == ch2 ? 0 : 1;
                int value = Math.min(Math.min(above, column[ix1 - 1]), column[ix1]) + cost;
                column[ix1 - 1] = above;
                above = value;
                smallest = Math.min(smallest, value);
            }
            column[s1len] = above;
            if (smallest <= maxdist) continue;
            return smallest;
        }
        return above;
    }
}

