/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure.phonetic;

import com.streamscape.Trace;
import com.streamscape.ds.schema.procedure.phonetic.Comparator;
import com.streamscape.ds.schema.procedure.phonetic.EntityName;
import com.streamscape.ds.schema.procedure.phonetic.JaroWinkler;
import com.streamscape.ds.schema.procedure.phonetic.Levenshtein;
import com.streamscape.ds.schema.procedure.phonetic.Metaphone;
import com.streamscape.ds.schema.procedure.phonetic.QGram;
import com.streamscape.ds.schema.procedure.phonetic.WeightedLevenshtein;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ComparatorFactory {
    private static Map<String, Class<?>> comparators = new HashMap();

    private static void addComparator(String name, Class<?> clazz) {
        comparators.put(name.toLowerCase(), clazz);
    }

    public static Comparator createComparator(String name) {
        Class<?> clazz = comparators.get(name.toLowerCase());
        if (clazz == null) {
            return null;
        }
        try {
            return (Comparator)clazz.newInstance();
        }
        catch (Exception exception) {
            Trace.logError(ComparatorFactory.class, exception.toString());
            return null;
        }
    }

    public static Set<String> getCompratorNames() {
        return comparators.keySet();
    }

    static {
        ComparatorFactory.addComparator("entity_name", EntityName.class);
        ComparatorFactory.addComparator("jaro_winkler", JaroWinkler.class);
        ComparatorFactory.addComparator("levenshtein", Levenshtein.class);
        ComparatorFactory.addComparator("metaphone", Metaphone.class);
        ComparatorFactory.addComparator("qgram", QGram.class);
        ComparatorFactory.addComparator("weighted_levenshtein", WeightedLevenshtein.class);
    }
}

