/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure;

import com.streamscape.ds.mf.OperationVisibleCondition;
import com.streamscape.ds.parser.Tokens;
import com.streamscape.ds.types.Type;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.slex.lang.completion.MethodSuggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SQLFunctionsMetaData {
    private Map<String, SQLFunctionMetaData> functionNameToMetaData = new HashMap<String, SQLFunctionMetaData>();
    private Map<Integer, SQLFunctionMetaData> functionIdToMetaData = new HashMap<Integer, SQLFunctionMetaData>();

    public SQLFunctionMetaData.Builder add(String name, int id, Type resultType) throws Exception {
        SQLFunctionMetaData metadata = new SQLFunctionMetaData(name, id, resultType);
        if (this.functionNameToMetaData.containsKey(metadata.getName())) {
            throw new Exception("Function with name '" + metadata.getName() + "' already defined.");
        }
        this.functionNameToMetaData.put(metadata.getName(), metadata);
        this.functionIdToMetaData.put(id, metadata);
        return new SQLFunctionMetaData.Builder(metadata);
    }

    public void compile() throws Exception {
        ArrayList<SQLFunctionMetaData> list = new ArrayList<SQLFunctionMetaData>();
        for (SQLFunctionMetaData metadata : this.functionNameToMetaData.values()) {
            if (metadata.getAliases() == null || metadata.getAliases().size() <= 0) continue;
            for (String alias : metadata.getAliases()) {
                SQLFunctionMetaData metadata1 = (SQLFunctionMetaData)metadata.clone();
                metadata1.aliases.remove(alias);
                metadata1.aliases.add(metadata1.name);
                metadata1.name = alias;
                list.add(metadata1);
            }
        }
        for (SQLFunctionMetaData metadata : list) {
            if (this.functionNameToMetaData.containsKey(metadata.getName())) {
                throw new Exception("Function with alias '" + metadata.getName() + "' already defined.");
            }
            this.functionNameToMetaData.put(metadata.getName(), metadata);
        }
    }

    public Set<String> listFunctionNames() {
        return Collections.unmodifiableSet(this.functionNameToMetaData.keySet());
    }

    public SQLFunctionMetaData lookupFunction(String name) {
        return this.functionNameToMetaData.get(name);
    }

    public SQLFunctionMetaData lookupFunction(int id) {
        return this.functionIdToMetaData.get(id);
    }

    public static class SQLFunctionMetaData
    extends CloneableDataObject {
        private String name;
        private int id;
        private Type resultType;
        private List<Argument> arguments;
        private String description;
        private List<String> aliases;
        private boolean isImplemented = true;
        private Group group = Group.OTHER;
        private OperationVisibleCondition operationVisibleCondition;

        SQLFunctionMetaData(String name, int id, Type resultType) {
            this.name = name;
            this.id = id;
            this.resultType = resultType;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public String getDescription() {
            return this.description;
        }

        public OperationVisibleCondition getOperationVisibleCondition() {
            return this.operationVisibleCondition;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public boolean isImplemented() {
            return this.isImplemented;
        }

        public Group getGroup() {
            return this.group;
        }

        public int getArgumentsCount() {
            if (this.arguments == null) {
                return 0;
            }
            return this.arguments.size();
        }

        public Argument getArgument(int index) {
            return this.arguments.get(index);
        }

        @Override
        public Object clone() {
            SQLFunctionMetaData object = (SQLFunctionMetaData)super.clone();
            object.aliases = new ArrayList<String>(object.aliases);
            return object;
        }

        public String getSignature() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name).append("(");
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.size(); ++i) {
                    if (i > 0) {
                        if (this.arguments.get(i).getPrefixes() == null) {
                            builder.append(", ");
                        } else {
                            builder.append(" ");
                        }
                    }
                    builder.append(this.arguments.get(i).toString());
                }
            }
            builder.append(")");
            builder.append(" returns ").append(SQLFunctionMetaData.getTypeName(this.resultType));
            return builder.toString();
        }

        public String toString() {
            return this.getSignature();
        }

        public static String getTypeName(Type type) {
            if (type.typeCode == 0) {
                return "ANY TYPE";
            }
            return type.getFullNameString();
        }

        public MethodSuggestion buildFunctionSuggestion(boolean withDescription) {
            MethodSuggestion suggestion = new MethodSuggestion(this.getName(), SQLFunctionMetaData.getTypeName(this.getResultType()), SuggestionGroup.FUNCTION);
            if (withDescription) {
                suggestion.setDescription(this.getDescription());
            }
            if (this.getArgumentsCount() > 0) {
                for (int i = 0; i < this.getArgumentsCount(); ++i) {
                    Argument argument = this.getArgument(i);
                    String[] types = new String[]{};
                    if (argument.getTypes() != null) {
                        types = new String[argument.getTypes().length];
                        for (int ii = 0; ii < argument.getTypes().length; ++ii) {
                            types[ii] = SQLFunctionMetaData.getTypeName(argument.getTypes()[ii]);
                        }
                    }
                    MethodSuggestion.MethodArgument arg = new MethodSuggestion.MethodArgument(argument.getName(), types);
                    arg.setOptional(argument.isOptional());
                    suggestion.addArgument(arg);
                }
            }
            return suggestion;
        }

        public static enum Group {
            TEXT("Text"),
            ARITHMETIC("Arithmetic"),
            DATE("Date"),
            CONVERT("Convert"),
            FILE("File"),
            SYSTEM("System"),
            ARRAY("Array"),
            OBJECT("Object"),
            NATURAL_LANGUAGE("Language"),
            OTHER("Other");

            private String title;

            private Group(String title) {
                this.title = title;
            }

            public String getTitle() {
                return this.title;
            }

            public static List<String> getOrderedGroupList() {
                ArrayList<String> groups = new ArrayList<String>();
                groups.add(Group.ARITHMETIC.title);
                groups.add(Group.ARRAY.title);
                groups.add(Group.CONVERT.title);
                groups.add(Group.DATE.title);
                groups.add(Group.TEXT.title);
                groups.add(Group.FILE.title);
                groups.add(Group.NATURAL_LANGUAGE.title);
                groups.add(Group.OBJECT.title);
                groups.add(Group.OTHER.title);
                groups.add(Group.SYSTEM.title);
                return groups;
            }
        }

        public static class Argument {
            private String name;
            private int[] prefixes = null;
            private boolean isOptional = false;
            private Type[] types = null;
            private int[] keySet = null;

            public String getName() {
                return this.name;
            }

            public int[] getPrefixes() {
                return this.prefixes;
            }

            public boolean isOptional() {
                return this.isOptional;
            }

            public Type[] getTypes() {
                return this.types;
            }

            public int[] getKeySet() {
                return this.keySet;
            }

            public void toString(StringBuilder builder) {
                int i;
                if (this.isOptional) {
                    builder.append("[ ");
                }
                if (this.prefixes != null) {
                    for (i = 0; i < this.prefixes.length; ++i) {
                        builder.append(Tokens.getKeyword(this.prefixes[i])).append(" ");
                    }
                }
                if (this.keySet == null && this.types != null) {
                    builder.append("<").append(this.name).append("> ");
                }
                if (this.types != null) {
                    if (this.types.length > 1) {
                        builder.append("{ ");
                    }
                    for (i = 0; i < this.types.length; ++i) {
                        if (i > 0) {
                            builder.append(" | ");
                        }
                        builder.append(SQLFunctionMetaData.getTypeName(this.types[i]));
                    }
                    if (this.types.length > 1) {
                        builder.append(" }");
                    }
                }
                if (this.keySet != null) {
                    if (this.keySet.length > 1) {
                        builder.append("{ ");
                    }
                    for (i = 0; i < this.keySet.length; ++i) {
                        if (i > 0) {
                            builder.append(" | ");
                        }
                        builder.append(Tokens.getKeyword(this.keySet[i]));
                    }
                    if (this.keySet.length > 1) {
                        builder.append(" }");
                    }
                }
                if (this.isOptional) {
                    builder.append(" ]");
                }
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                this.toString(builder);
                return builder.toString();
            }
        }

        static class Builder {
            private SQLFunctionMetaData metadata;

            Builder(SQLFunctionMetaData metadata) {
                this.metadata = metadata;
            }

            public SQLFunctionMetaData complete() {
                return this.metadata;
            }

            public Builder argument(String name, Type ... types) {
                return this.addArgument(null, name, false, types, null);
            }

            public Builder argument(int prefix, String name, Type ... types) {
                return this.addArgument(new int[]{prefix}, name, false, types, null);
            }

            public Builder argument(int prefix1, int prefix2, String name, Type ... types) {
                return this.addArgument(new int[]{prefix1, prefix2}, name, false, types, null);
            }

            public Builder optional(String name, Type ... types) {
                return this.addArgument(null, name, true, types, null);
            }

            public Builder optional(int prefix, String name, Type ... types) {
                return this.addArgument(new int[]{prefix}, name, true, types, null);
            }

            public Builder optional(int prefix1, int prefix2, String name, Type ... types) {
                return this.addArgument(new int[]{prefix1, prefix2}, name, true, types, null);
            }

            public Builder optional(int prefix1, int prefix2, int prefix3, String name, Type ... types) {
                return this.addArgument(new int[]{prefix1, prefix2, prefix3}, name, true, types, null);
            }

            public Builder argument(String name, int ... keySet) {
                return this.addArgument(null, name, false, null, keySet);
            }

            public Builder argument(int prefix, String name, int ... keySet) {
                return this.addArgument(new int[]{prefix}, name, false, null, keySet);
            }

            public Builder argument(int prefix1, int prefix2, String name, int ... keySet) {
                return this.addArgument(new int[]{prefix1, prefix2}, name, false, null, keySet);
            }

            public Builder optional(String name, int ... keySet) {
                return this.addArgument(null, name, true, null, keySet);
            }

            public Builder optional(int prefix, String name, int ... keySet) {
                return this.addArgument(new int[]{prefix}, name, true, null, keySet);
            }

            public Builder optional(int prefix1, int prefix2, String name, int ... keySet) {
                return this.addArgument(new int[]{prefix1, prefix2}, name, true, null, keySet);
            }

            public Builder description(String description) {
                this.metadata.description = description;
                return this;
            }

            public Builder operationVisibleCondition(OperationVisibleCondition operationVisibleCondition) {
                this.metadata.operationVisibleCondition = operationVisibleCondition;
                return this;
            }

            public Builder group(Group group) {
                this.metadata.group = group;
                return this;
            }

            public Builder notImplemented() {
                this.metadata.isImplemented = false;
                return this;
            }

            public Builder alias(String ... aliases) {
                if (this.metadata.aliases == null) {
                    this.metadata.aliases = new ArrayList<String>();
                }
                for (String alias : aliases) {
                    this.metadata.aliases.add(alias);
                }
                return this;
            }

            private Builder addArgument(int[] prefixes, String name, boolean isOptional, Type[] types, int[] keySet) {
                Argument argument = new Argument();
                argument.name = name;
                argument.prefixes = prefixes;
                argument.isOptional = isOptional;
                argument.types = types;
                argument.keySet = keySet;
                if (this.metadata.arguments == null) {
                    this.metadata.arguments = new ArrayList<Argument>();
                }
                this.metadata.arguments.add(argument);
                return this;
            }
        }
    }
}

