/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.BitMap;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.ParserDDL;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCompound;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionContext;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.RowType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.ds.utils.SourceEventFlowDataImpl;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.service.osf.config.ActiveEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RplScript
implements SchemaObject,
Cloneable,
RplSchemaObject {
    public RoutineSchema routineSchema;
    private NameManager.ObjectName name;
    private NameManager.ObjectName specificName;
    Type[] parameterTypes;
    int typeGroups;
    Type returnType;
    Type[] tableType;
    public Collection returnCollection;
    final int routineType;
    boolean isDeterministic;
    boolean isNewSavepointLevel = true;
    public int maxDynamicResults = 0;
    public boolean isRecursive;
    public boolean returnsCollection;
    public Statement statement;
    public List<String> eventIds = null;
    boolean isAggregate;
    HashMappedList parameterList = new HashMappedList();
    public HashMappedList scopeVariables = new HashMappedList();
    RangeVariable[] ranges = RangeVariable.emptyArray;
    public int variableCount;
    OrderedHashSet references;
    AbstractDataspace dataspace = null;
    public Table triggerTable;
    DataspaceStateHolder stateHolder = new DataspaceStateHolder();
    private String rpl = null;
    private ReadWriteLock transientVariablesLock = new ReentrantReadWriteLock();
    private Lock readTransientVariablesLock = this.transientVariablesLock.readLock();
    private Lock writeTransientVariablesLock = this.transientVariablesLock.writeLock();
    private HashMappedList scopeTransientVariables = new HashMappedList();
    private Object[] transientVariables = new Object[0];
    public static final RplScript[] emptyArray = new RplScript[0];
    public static final String INDENT = "    ";

    public RplScript(DataspaceStore store, NameManager.ObjectName name, int type) {
        this.name = name;
        this.routineType = type;
        this.returnType = Type.SQL_ALL_TYPES;
        this.ranges = new RangeVariable[]{new RangeVariable(this.parameterList, null, false, 3), new RangeVariable(this.scopeTransientVariables, null, false, 5)};
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(name.schema.name);
    }

    public RplScript(DataspaceStore store, NameManager.ObjectName name, Table table, RangeVariable[] ranges) {
        this.name = name;
        this.routineType = 9;
        this.returnType = Type.SQL_ALL_TYPES;
        this.triggerTable = table;
        RangeVariable[] temp = Arrays.copyOf(ranges, ranges.length + 1);
        temp[temp.length - 1] = new RangeVariable(this.scopeTransientVariables, null, false, 5);
        this.ranges = temp;
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(name.schema.name);
    }

    public RplScript(DataspaceStore store, NameManager.ObjectName name, RangeVariable[] ranges) {
        this.name = name;
        this.routineType = 32;
        this.returnType = Type.SQL_ALL_TYPES;
        RangeVariable[] temp = Arrays.copyOf(ranges, ranges.length + 1);
        temp[temp.length - 1] = new RangeVariable(this.scopeTransientVariables, null, false, 5);
        this.ranges = temp;
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(name.schema.name);
    }

    public Object getTransientVariable(int index) {
        this.readTransientVariablesLock.lock();
        try {
            if (index >= 0 && index < this.transientVariables.length) {
                Object object = this.transientVariables[index];
                return object;
            }
            throw new DataspaceException("Unable to retrieve transient variable.");
        }
        finally {
            this.readTransientVariablesLock.unlock();
        }
    }

    public void setTransientVariable(int index, Object value) {
        block4: {
            this.writeTransientVariablesLock.lock();
            try {
                if (index >= 0 && index < this.transientVariables.length) {
                    this.transientVariables[index] = value;
                    break block4;
                }
                throw new DataspaceException("Unable to set transient variable.");
            }
            finally {
                this.writeTransientVariablesLock.unlock();
            }
        }
    }

    public int getNumberOfTransientVariables() {
        this.readTransientVariablesLock.lock();
        try {
            int n = this.transientVariables.length;
            return n;
        }
        finally {
            this.readTransientVariablesLock.unlock();
        }
    }

    public boolean hasTransientVariable(String name) {
        this.readTransientVariablesLock.lock();
        try {
            boolean bl = this.scopeTransientVariables.containsKey(name);
            return bl;
        }
        finally {
            this.readTransientVariablesLock.unlock();
        }
    }

    public HashMappedList getTransientVariables() {
        this.readTransientVariablesLock.lock();
        try {
            HashMappedList hashMappedList = this.scopeTransientVariables;
            return hashMappedList;
        }
        finally {
            this.readTransientVariablesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransientVariable(String name, ColumnSchema var) {
        this.writeTransientVariablesLock.lock();
        try {
            this.scopeTransientVariables.put(name, var);
            Object[] temp = new Object[this.transientVariables.length + 1];
            System.arraycopy(this.transientVariables, 0, temp, 0, this.transientVariables.length);
            temp[this.transientVariables.length] = null;
            this.transientVariables = temp;
        }
        finally {
            this.writeTransientVariablesLock.unlock();
        }
    }

    @Override
    public int getObjectType() {
        return this.routineType;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        if (this.routineType == 9) {
            return this.triggerTable.getSchemaName();
        }
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        ParserDDL p = new ParserDDL(session, new Scanner(this.statement.getSQL()));
        p.read();
        this.scopeVariables.clear();
        Statement statement = p.compileSQLProcedureStatementOrNull(this, null);
        this.setProcedure(statement);
        statement.resolve(session);
        this.setReferences();
    }

    @Override
    public String getSQL() {
        return this.getDefinitionSQL(true);
    }

    @Override
    public String getSQL(String name) {
        return this.getDefinitionSQL(name, true);
    }

    public String getSQLAlter() {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER").append(' ').append("FUNCTION");
        sb.append(' ');
        sb.append(this.specificName.getSchemaQualifiedStatementName());
        sb.append(' ').append("AS");
        sb.append(' ').append(this.statement.getSQL());
        return sb.toString();
    }

    public String getSQLAlter(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER").append(' ').append("FUNCTION");
        sb.append(' ');
        sb.append(name);
        sb.append(' ').append("as");
        sb.append(' ').append(this.statement != null ? this.statement.getSQL() : this.rpl);
        return sb.toString();
    }

    public String getSQLDeclaration() {
        return this.getDefinitionSQL(false);
    }

    public String getSQLDeclaration(String name) {
        return this.getDefinitionSQL(name, false);
    }

    private String getDefinitionSQL(boolean withBody) {
        return this.getDefinitionSQL(this.name.getSchemaQualifiedStatementName(), withBody);
    }

    private String getDefinitionSQL(String name, boolean withBody) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        if (this.isAggregate) {
            sb.append("AGGREGATE").append(' ');
        }
        if (this.routineType == 18) {
            sb.append("PROCEDURE");
        } else {
            sb.append("FUNCTION");
        }
        sb.append(' ');
        sb.append(name);
        sb.append('(');
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            ColumnSchema param = (ColumnSchema)this.parameterList.get(i);
            sb.append(param.getSQL());
        }
        sb.append(')');
        sb.append(' ');
        if (this.routineType == 17) {
            sb.append("RETURNS");
            sb.append(' ');
            if (this.returnsCollection) {
                switch (this.returnCollection.getCollectionType()) {
                    case TABLE: {
                        sb.append("TABLE");
                        sb.append(this.returnCollection.getBaseTable().getColumnListWithTypeSQL());
                        break;
                    }
                    case BLOCKING_QUEUE: {
                        sb.append("QUEUE");
                        sb.append("(");
                        sb.append(((BlockingQueueCollection)this.returnCollection).getDataType().getTypeDefinition());
                        sb.append(")");
                        break;
                    }
                    case MAP: {
                        sb.append("MAP");
                        sb.append("(");
                        sb.append(this.returnCollection.getBaseTable().getColumn(0).getDataType().getTypeDefinition());
                        sb.append(",");
                        sb.append(this.returnCollection.getBaseTable().getColumn(1).getDataType().getTypeDefinition());
                        sb.append(")");
                    }
                }
            } else {
                sb.append(this.returnType.getTypeDefinition());
            }
            sb.append(' ');
        }
        if (this.specificName != null) {
            sb.append("SPECIFIC");
            sb.append(' ');
            sb.append(this.specificName.getStatementName());
            sb.append(' ');
        }
        sb.append(' ');
        if (!this.isDeterministic) {
            sb.append("NOT");
            sb.append(' ');
        }
        sb.append("DETERMINISTIC");
        sb.append(' ');
        if (this.routineType != 17) {
            if (this.isNewSavepointLevel) {
                sb.append("NEW");
            } else {
                sb.append("OLD");
            }
            sb.append(' ').append("SAVEPOINT").append(' ');
            sb.append("LEVEL").append(' ');
            if (this.maxDynamicResults != 0) {
                sb.append(' ').append("DYNAMIC").append(' ');
                sb.append("RESULT").append(' ').append("SETS");
                sb.append(' ').append(this.maxDynamicResults).append(' ');
            }
        }
        if (withBody) {
            if (this.statement != null) {
                sb.append(' ').append("AS").append(' ');
                sb.append(this.statement.getSQL());
            } else {
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rpl);
            }
        } else {
            sb.append("THROW").append(' ');
            sb.append("EXCEPTION").append(' ');
            sb.append("SQLSTATE").append(' ');
            sb.append('\'').append("45000").append('\'');
        }
        return sb.toString();
    }

    public String getPrettyPrintSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        if (this.isAggregate) {
            sb.append("AGGREGATE").append(' ');
        }
        if (this.routineType == 18) {
            sb.append("PROCEDURE");
        } else {
            sb.append("FUNCTION");
        }
        sb.append(' ');
        sb.append(this.name.getNameString());
        sb.append('(');
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            ColumnSchema param = (ColumnSchema)this.parameterList.get(i);
            sb.append(param.getSQL());
        }
        sb.append(')');
        if (this.routineType == 17) {
            sb.append('\n');
            sb.append(INDENT);
            sb.append("RETURNS");
            sb.append(' ');
            if (this.returnsCollection) {
                switch (this.returnCollection.getCollectionType()) {
                    case TABLE: {
                        sb.append("TABLE");
                        sb.append(this.returnCollection.getBaseTable().getColumnListWithTypeSQL());
                        break;
                    }
                    case BLOCKING_QUEUE: {
                        sb.append("QUEUE");
                        sb.append("(");
                        sb.append(((BlockingQueueCollection)this.returnCollection).getDataType().getTypeDefinition());
                        sb.append(")");
                        break;
                    }
                    case MAP: {
                        sb.append("MAP");
                        sb.append("(");
                        sb.append(this.returnCollection.getBaseTable().getColumn(0).getDataType().getTypeDefinition());
                        sb.append(",");
                        sb.append(this.returnCollection.getBaseTable().getColumn(1).getDataType().getTypeDefinition());
                        sb.append(")");
                    }
                }
            } else {
                sb.append(this.returnType.getTypeDefinition());
            }
            sb.append(' ');
        }
        if (this.specificName != null) {
            sb.append('\n');
            sb.append(INDENT);
            sb.append("SPECIFIC");
            sb.append(' ');
            sb.append(this.specificName.getStatementName());
            sb.append(' ');
        }
        sb.append('\n');
        sb.append(INDENT);
        if (!this.isDeterministic) {
            sb.append("NOT");
            sb.append(' ');
        }
        sb.append("DETERMINISTIC");
        sb.append(' ');
        if (this.routineType != 17) {
            if (this.isNewSavepointLevel) {
                sb.append("NEW");
            } else {
                sb.append("OLD");
            }
            sb.append(' ').append("SAVEPOINT").append(' ');
            sb.append("LEVEL").append(' ');
            if (this.maxDynamicResults != 0) {
                sb.append(' ').append("DYNAMIC").append(' ');
                sb.append("RESULT").append(' ').append("SETS");
                sb.append(' ').append(this.maxDynamicResults).append(' ');
            }
        }
        sb.append('\n');
        sb.append(INDENT).append("AS").append(' ');
        sb.append('\n');
        if (this.statement instanceof StatementCompound) {
            sb.append('\n');
            this.printCompoundStatement(sb, INDENT, (StatementCompound)this.statement);
        } else {
            sb.append(INDENT).append(INDENT).append(this.statement.getSQL());
        }
        return sb.toString();
    }

    private void printCompoundStatement(StringBuffer sb, String indention, StatementCompound stat) {
        sb.append('\n');
        sb.append(indention).append("BEGIN").append(" ").append("TRANSACTION").append('\n');
        for (Statement temp : stat.getStatements()) {
            if (temp instanceof StatementCompound) {
                this.printCompoundStatement(sb, INDENT + indention, (StatementCompound)temp);
                continue;
            }
            sb.append(INDENT + indention).append(temp.getSQL()).append(';').append('\n');
        }
        sb.append(indention).append("END").append('\n');
    }

    public String getSQLBodyDefinition() {
        return this.statement.getSQL();
    }

    public String getExternalName() {
        return null;
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public void addParameter(ColumnSchema param) {
        NameManager.ObjectName name = param.getObjectName();
        String paramName = name == null ? NameManager.getAutoNoNameColumnString(this.parameterList.size()) : name.name;
        this.parameterList.add(paramName, param);
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setTableType(Type[] types) {
        this.tableType = types;
    }

    public Type[] getTableType() {
        return this.tableType;
    }

    public Table getTable() {
        return this.returnCollection.getBaseTable();
    }

    public void setProcedure(Statement statement) {
        if (statement != null) {
            this.stateHolder = new DataspaceStateHolder();
        }
        this.statement = statement;
    }

    public Statement getProcedure() {
        return this.statement;
    }

    public void setSpecificName(NameManager.ObjectName name) {
        this.specificName = name;
    }

    public int getMaxDynamicResults() {
        return this.maxDynamicResults;
    }

    public void setName(NameManager.ObjectName name) {
        this.name = name;
    }

    public NameManager.ObjectName getSpecificName() {
        return this.specificName;
    }

    public void setDeterministic(boolean value) {
        this.isDeterministic = value;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public void setNewSavepointLevel(boolean value) {
        this.isNewSavepointLevel = value;
    }

    public void setMaxDynamicResults(int value) {
        this.maxDynamicResults = value;
    }

    public void setReturnCollection(Collection collection) {
        this.returnCollection = collection;
        this.returnsCollection = true;
        Type[] types = collection.getBaseTable().getColumnTypes();
        this.returnType = new RowType(types, collection.getCollectionType());
    }

    public boolean returnsCollection() {
        return this.returnsCollection;
    }

    public void setAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public void setRpl(String rpl) {
        this.rpl = rpl;
    }

    public void resolve(Session session) {
        ColumnSchema param;
        this.parameterTypes = new Type[this.parameterList.size()];
        this.typeGroups = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            param = (ColumnSchema)this.parameterList.get(i);
            this.parameterTypes[i] = param.dataType;
            if (i >= 4) continue;
            BitMap.setByte(this.typeGroups, (byte)param.dataType.typeComparisonGroup, i * 8);
        }
        if (this.isAggregate) {
            if (this.parameterTypes.length != 4) {
                throw Error.error(5610);
            }
            boolean check = this.parameterTypes[1].typeCode == 16;
            param = (ColumnSchema)this.parameterList.get(0);
            check &= param.getParameterMode() == 1;
            param = (ColumnSchema)this.parameterList.get(1);
            check &= param.getParameterMode() == 1;
            param = (ColumnSchema)this.parameterList.get(2);
            check &= param.getParameterMode() == 2;
            param = (ColumnSchema)this.parameterList.get(3);
            if (!(check &= param.getParameterMode() == 2)) {
                throw Error.error(5610);
            }
        }
        this.resolveReferences(session);
    }

    public void resolveReferences(Session session) {
        session.sessionContext.raisedEventIds = new ArrayList<String>();
        if (this.statement != null) {
            this.statement.resolve(session);
            this.checkSQLData(session);
        }
        this.setReferences();
        if (session.sessionContext.raisedEventIds.size() > 0) {
            this.eventIds = session.sessionContext.raisedEventIds;
        }
        session.sessionContext.raisedEventIds = null;
    }

    private void setReferences() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                ColumnSchema param = (ColumnSchema)this.parameterList.get(i);
                set.addAll(param.getReferences());
            }
        }
        if (this.statement != null) {
            set.addAll(this.statement.getReferences());
        }
        this.isRecursive = false;
        if (set.contains(this.getSpecificName())) {
            set.remove(this.getSpecificName());
            this.isRecursive = true;
        }
        if (set.contains(this.getObjectName())) {
            set.remove(this.getObjectName());
            this.isRecursive = true;
        }
        this.references = set;
    }

    void checkSQLData(Session session) {
        OrderedHashSet set = this.statement.getReferences();
        for (int i = 0; i < set.size(); ++i) {
            NameManager.ObjectName name = (NameManager.ObjectName)set.get(i);
            if (name.type != 25) continue;
            session.dataspaceStore.schemaManager.getSchemaObject(name);
        }
    }

    public boolean isTrigger() {
        return this.routineType == 9;
    }

    public boolean isProcedure() {
        return this.routineType == 18;
    }

    public boolean isFunction() {
        return this.routineType == 17;
    }

    public ColumnSchema getParameter(int i) {
        return (ColumnSchema)this.parameterList.get(i);
    }

    Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    int getParameterSignature() {
        return this.typeGroups;
    }

    public int getParameterCount() {
        return this.parameterList != null ? this.parameterList.size() : 0;
    }

    public int getParameterCount(int type) {
        int count = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            ColumnSchema col = (ColumnSchema)this.parameterList.get(i);
            if (col.getParameterMode() != type) continue;
            ++count;
        }
        return count;
    }

    public int getParameterIndex(String name) {
        return this.parameterList.getIndex(name);
    }

    public RangeVariable[] getParameterRangeVariables() {
        return this.ranges;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public NameManager.ObjectName[] getTableNamesForRead() {
        if (this.statement == null) {
            return NameManager.ObjectName.emptyArray;
        }
        return this.statement.getTableNamesForRead();
    }

    public NameManager.ObjectName[] getTableNamesForWrite() {
        if (this.statement == null) {
            return NameManager.ObjectName.emptyArray;
        }
        return this.statement.getTableNamesForWrite();
    }

    public void setAsAlteredRoutine(RplScript routine) {
        this.isDeterministic = routine.isDeterministic;
        this.maxDynamicResults = routine.maxDynamicResults;
        this.isRecursive = routine.isRecursive;
        this.statement = routine.statement;
        this.references = routine.references;
        this.variableCount = routine.variableCount;
        this.ranges = routine.ranges;
        this.stateHolder = routine.stateHolder;
        this.eventIds = routine.eventIds;
        this.rpl = routine.rpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Session session, Object[] data, Object[] aggregateData, boolean push) {
        Result result;
        if (this.stateHolder.isSuspectState()) {
            return Result.newErrorResult(new IllegalStateException("RPL routine is invalid. Please check the last error."));
        }
        if (push) {
            session.sessionContext.push();
            session.sessionContext.pushRoutineCollections(new HashMappedList());
        }
        NameManager.ObjectName currentDataspace = session.currentDataspace;
        RplSchemaObject rplObject = session.sessionContext.rplObject;
        try {
            session.currentDataspace = this.getObjectName().schema;
            session.sessionContext.rplObject = this;
            session.sessionContext.rplArguments = data;
            session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
            if (this.variableCount > 0) {
                session.sessionContext.routineVariables = new Object[this.variableCount];
            }
            result = this.statement.execute(session);
            session.sessionContext.closeRoutineVariables();
            if (result.isError() && result.getException() != null) {
                this.stateHolder.setLastError(result.getException().getMessage());
            } else if (!result.isError()) {
                this.stateHolder.setLastError("");
            }
            if (aggregateData != null) {
                for (int i = 0; i < aggregateData.length; ++i) {
                    aggregateData[i] = data[i + 1];
                }
            }
        }
        catch (Throwable e) {
            this.stateHolder.setLastError(e.getMessage());
            result = Result.newErrorResult(e);
        }
        finally {
            session.sessionContext.rplObject = rplObject;
            session.currentDataspace = currentDataspace;
            if (push) {
                session.sessionContext.popRoutineCollections();
                session.sessionContext.pop();
            }
        }
        return result;
    }

    public List<ActiveEvent> getEvents() {
        return this.getEvents(this.getObjectName().name, this.dataspace.getEventScope());
    }

    public List<ActiveEvent> getEvents(String objectName, EventScope scope) {
        ArrayList<ActiveEvent> result = new ArrayList<ActiveEvent>();
        if (this.eventIds != null) {
            for (String eventId : this.eventIds) {
                ActiveEvent event = new ActiveEvent(eventId);
                event.setType(ActiveEvent.ActiveEventType.Source);
                event.setEventScope(scope);
                event.setEventModel(SqlUtils.resolveEventModel(DataspaceStoreManager.getRuntimeContext(), eventId));
                result.add(event);
            }
        }
        return result;
    }

    @Override
    public void invalidate(String lastError) {
        this.stateHolder.setSuspectState(DataspaceStateHolder.invalid, lastError);
    }

    @Override
    public DataspaceStateHolder getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public DataspaceStateHolder aggregateStateHolder() {
        DataspaceStateHolder state = (DataspaceStateHolder)this.getStateHolder().clone();
        if (this.dataspace != null) {
            DataspaceStateHolder.aggregateState(state, this.getReferences(), this.dataspace.getStore().schemaManager);
        } else {
            state.setRecoveryFailedState();
        }
        return state;
    }

    @Override
    public String getStateName(DataspaceStoreState state) {
        return state.toString();
    }

    public boolean isEventCapable() {
        return this.eventIds != null && this.eventIds.size() > 0;
    }

    public boolean isTableCapable() {
        return this.returnsCollection();
    }

    public void open(Session session) {
        this.open(session, this.getSourceEventFlowData());
    }

    public void open(Session session, SourceEventFlowData flowData) {
        try {
            if (this.eventIds != null) {
                for (String eventId : this.eventIds) {
                    this.dataspace.bindProducerFor(eventId, flowData);
                }
            }
        }
        catch (FabricEventDispatcherException error) {
            Trace.logException(Actor.class, error, false);
        }
    }

    @Override
    public void disable() {
        throw new DataspaceException("Disable functionality is not supported in function.");
    }

    public void close() {
        this.close(this.getSourceEventFlowData());
    }

    public void close(SourceEventFlowData flowData) {
        this.writeTransientVariablesLock.lock();
        try {
            SessionContext.closeVariables(this.transientVariables);
        }
        finally {
            this.writeTransientVariablesLock.unlock();
        }
        if (this.eventIds != null) {
            for (String eventId : this.eventIds) {
                this.dataspace.unbindProducerFor(eventId, flowData);
            }
        }
    }

    private SourceEventFlowData getSourceEventFlowData() {
        if (this.routineSchema != null) {
            switch (this.routineSchema.getObjectType()) {
                case 32: {
                    return new SourceEventFlowDataImpl(EventFlowEntity.DATASPACE_ACTOR, this.routineSchema.getObjectName().name, null, null);
                }
                case 17: {
                    return new SourceEventFlowDataImpl(EventFlowEntity.DATASPACE_FUNCTION, this.routineSchema.getObjectName().name, null, null);
                }
            }
        }
        return null;
    }

    public RplScript duplicate() {
        try {
            RplScript script = (RplScript)super.clone();
            script.scopeTransientVariables = new HashMappedList();
            script.transientVariables = new Object[0];
            return script;
        }
        catch (CloneNotSupportedException e) {
            throw Error.runtimeError(201, "Type");
        }
    }

    public String getRpl() {
        return this.rpl;
    }
}

