/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.Utils;
import java.util.function.Function;

public class RoutineSchema
implements SchemaObject {
    public RplScript[] routines = RplScript.emptyArray;
    int routineType;
    private NameManager.ObjectName name;

    public RoutineSchema(int type, NameManager.ObjectName name) {
        this.routineType = type;
        this.name = name;
    }

    @Override
    public int getObjectType() {
        return this.routineType;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getReferences());
        }
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        OrderedHashSet set = new OrderedHashSet();
        set.addAll(this.routines);
        return set;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return null;
    }

    @Override
    public String getSQL(String name) {
        return null;
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String[] getSQLArray(String schemaName) {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.routines.length; ++i) {
            String routineName = this.routines[i].getObjectName().getSchemaQualifiedStatementName(schemaName);
            list.add(this.routines[i].getSQL(routineName));
        }
        return (String[])list.toArray(new String[list.size()]);
    }

    public String[] getSQLArray() {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.routines.length; ++i) {
            list.add(this.routines[i].getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public void addSpecificRoutine(DataspaceStore database, RplScript routine) {
        int signature = routine.getParameterSignature();
        Type[] types = routine.getParameterTypes();
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != types.length) continue;
            if (this.routineType == 18) {
                throw Error.error(5605);
            }
            if (this.routines[i].isAggregate() != routine.isAggregate()) {
                throw Error.error(5605);
            }
            boolean match = true;
            for (int j = 0; j < types.length; ++j) {
                if (this.routines[i].parameterTypes[j].equals(types[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            throw Error.error(5605);
        }
        if (routine.getSpecificName() == null) {
            NameManager.ObjectName specificName = database.nameManager.newSpecificRoutineName(this.name);
            routine.setSpecificName(specificName);
        } else {
            routine.getSpecificName().parent = this.name;
            routine.getSpecificName().schema = this.name.schema;
        }
        routine.setName(this.name);
        routine.routineSchema = this;
        this.routines = (RplScript[])ArrayUtil.resizeArray(this.routines, this.routines.length + 1);
        this.routines[this.routines.length - 1] = routine;
    }

    public void removeSpecificRoutine(RplScript routine) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i] != routine) continue;
            this.routines = (RplScript[])ArrayUtil.toAdjustedArray(this.routines, null, i, -1);
            break;
        }
    }

    public RplScript[] getSpecificRoutines() {
        return this.routines;
    }

    public RplScript getSpecificRoutine(Type[] types) {
        int matchIndex = -1;
        block0: for (int i = 0; i < this.routines.length; ++i) {
            int j;
            int newDiff;
            int oldDiff;
            int matchCount = 0;
            if (this.routines[i].isAggregate() && types.length == 1) {
                if (types[0] == null) {
                    return this.routines[i];
                }
                int typeDifference = types[0].precedenceDegree(this.routines[i].parameterTypes[0]);
                if (typeDifference < -128) {
                    if (matchIndex == -1 || (oldDiff = types[0].precedenceDegree(this.routines[matchIndex].parameterTypes[0])) == (newDiff = types[0].precedenceDegree(this.routines[i].parameterTypes[0])) || newDiff >= oldDiff) continue;
                    matchIndex = i;
                    continue;
                }
                if (typeDifference == 0) {
                    return this.routines[i];
                }
                matchIndex = i;
                continue;
            }
            if (this.routines[i].parameterTypes.length != types.length) continue;
            if (types.length == 0) {
                return this.routines[i];
            }
            for (j = 0; j < types.length; ++j) {
                if (types[j] == null) continue;
                int typeDifference = types[j].precedenceDegree(this.routines[i].parameterTypes[j]);
                if (typeDifference < -128) continue block0;
                if (typeDifference != 0 || matchCount != j) continue;
                matchCount = j + 1;
            }
            if (matchCount == types.length) {
                return this.routines[i];
            }
            if (matchIndex == -1) {
                matchIndex = i;
                continue;
            }
            for (j = 0; j < types.length; ++j) {
                if (types[j] == null || (oldDiff = types[j].precedenceDegree(this.routines[matchIndex].parameterTypes[j])) == (newDiff = types[j].precedenceDegree(this.routines[i].parameterTypes[j]))) continue;
                if (newDiff >= oldDiff) continue block0;
                matchIndex = i;
                continue block0;
            }
        }
        if (matchIndex < 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name.getSchemaQualifiedStatementName());
            sb.append("(");
            for (int i = 0; i < types.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                if (types[i] != null) {
                    sb.append(types[i].getNameString());
                    continue;
                }
                sb.append("null");
            }
            sb.append(")");
            throw Error.error(5609, sb.toString()).setLevel(1);
        }
        return this.routines[matchIndex];
    }

    public RplScript getSpecificRoutine(int paramCount) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != paramCount) continue;
            return this.routines[i];
        }
        throw Error.error(5501);
    }

    public boolean isAggregate() {
        return this.routines[0].isAggregate;
    }

    public void recompileFunction(Session session) {
        try {
            String sql = session.dataspaceStore.schemaManager.loadObjectDefinition(session, this);
            Statement newFunction = (Statement)RoutineSchema.executeInDataspace(session, this.getObjectName().schema, s -> {
                ParserCommand parser = new ParserCommand((Session)s, new Scanner(sql));
                return parser.compileStatement(0);
            });
            if (newFunction != null) {
                RplScript newRoutine = (RplScript)((StatementSchema)newFunction).arguments[0];
                RplScript oldRoutine = this.routines[0];
                oldRoutine.close();
                newRoutine.setName(oldRoutine.getObjectName());
                newRoutine.setSpecificName(oldRoutine.getSpecificName());
                newRoutine.resolveReferences(session);
                session.dataspaceStore.schemaManager.replaceReferences(oldRoutine, newRoutine);
                oldRoutine.setAsAlteredRoutine(newRoutine);
                oldRoutine.open(session);
            }
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to recompile function " + this.getObjectName().getSchemaQualifiedStatementName() + ". " + Utils.formatExceptionWithUnrepeatedCauses(error));
            this.routines[0].getStateHolder().setSuspectState(DataspaceStateHolder.syntax, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeInDataspace(Session session, NameManager.ObjectName schemaName, Function<Session, Object> function) {
        NameManager.ObjectName sessionDataspaceName = session.getCurrentDataspaceName();
        boolean sessionIsSDS = session.isSDSRuntimeSession();
        boolean isProcessingLog = session.isProcessingLog();
        boolean isProcessingRecoveryLog = session.isProcessingRecoveryLog();
        session.setCurrentDataspaceName(schemaName);
        session.setSDSRuntimeSession(false);
        session.isProcessingLog = false;
        session.isProcessingRecoveryLog = false;
        try {
            Object object = function.apply(session);
            return object;
        }
        finally {
            session.setSDSRuntimeSession(sessionIsSDS);
            session.setCurrentDataspaceName(sessionDataspaceName);
            session.isProcessingLog = isProcessingLog;
            session.isProcessingRecoveryLog = isProcessingRecoveryLog;
        }
    }
}

