/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.procedure.FunctionCustom;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.FunctionUnitEntry;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;

public class FunctionUnitCall
extends FunctionCustom {
    FunctionUnitEntry entry;

    public FunctionUnitCall(FunctionUnitEntry entry) {
        super(173);
        this.entry = entry;
        this.parseList = entry.getParameters();
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        Type type = this.entry.resolveReturnDataType(session, this.nodes);
        if (type != null) {
            this.dataType = type;
        }
    }

    @Override
    public Object getValue(Session session) {
        return this.dataType.convertJavaToSQL(session, this.entry.getResult(session, this, this.getArgs(session), this.nodes));
    }

    public Object[] getArgs(Session session) {
        Object[] args = new Object[this.nodes.length];
        try {
            int counter = -1;
            for (Expression expr : this.nodes) {
                if (expr == null) continue;
                args[++counter] = expr.getDataType() != null && !expr.getDataType().isArrayType() ? expr.getDataType().convertSQLToJava(session, expr.getValue(session)) : expr.getValue(session);
                args[counter] = OtherTypeWrapper.unwrap(args[counter]);
            }
        }
        catch (Exception ex) {
            Trace.logException(this, ex, false);
            throw new DataspaceException(ex);
        }
        return args;
    }

    @Override
    public String getSQL() {
        StringBuffer buffer = new StringBuffer(this.entry.getName());
        buffer.append('(');
        boolean first = true;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            if (!first) {
                buffer.append(",");
            } else {
                first = false;
            }
            buffer.append(this.nodes[i].getSQL());
        }
        buffer.append(')');
        return buffer.toString();
    }

    public FunctionUnitEntry getEntry() {
        return this.entry;
    }
}

