/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayListIdentity;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.procedure.FunctionCustom;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.Map;

public class FunctionSQLInvoked
extends Expression {
    RoutineSchema routineSchema;
    public RplScript routine;
    Expression condition = Expression.EXPR_TRUE;

    public FunctionSQLInvoked(RoutineSchema routineSchema) {
        super(routineSchema.isAggregate() ? 98 : 27);
        this.routineSchema = routineSchema;
    }

    public void setArguments(Expression[] newNodes) {
        this.nodes = newNodes;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        HsqlList conditionSet = this.condition.resolveColumnReferences(session, rangeVarArray, rangeCount, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (this.isSelfAggregate()) {
            if (unresolvedSet == null) {
                unresolvedSet = new ArrayListIdentity();
            }
            unresolvedSet.add(this);
            return unresolvedSet;
        }
        return super.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        int i;
        Type[] types = new Type[this.nodes.length];
        for (i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            e.resolveTypes(session, this);
            types[i] = e instanceof FunctionCustom && (((FunctionCustom)e).funcType == 106 || ((FunctionCustom)e).funcType == 231) ? null : e.dataType;
        }
        this.routine = this.routineSchema.getSpecificRoutine(types);
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].dataType != null) continue;
            this.nodes[i].dataType = this.routine.getParameterTypes()[i];
        }
        this.dataType = this.routine.getReturnType();
        this.condition.resolveTypes(session, null);
    }

    private Object getValueInternal(Session session, Object[] aggregateData) {
        boolean isValue = false;
        Object[] data = ValuePool.emptyObjectArray;
        boolean push = true;
        if (this.nodes.length > 0) {
            if (this.opType == 98) {
                data = new Object[this.routine.getParameterCount()];
                for (int i = 0; i < aggregateData.length; ++i) {
                    data[i + 1] = aggregateData[i];
                }
            } else {
                data = new Object[this.nodes.length];
            }
        }
        Type[] dataTypes = this.routine.getParameterTypes();
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            Object value = e.getValue(session, dataTypes[i]);
            if (value == null && !this.routine.getParameter(i).isNullable()) {
                return Result.newErrorResult(Error.error(4811));
            }
            data[i] = value;
        }
        Result result = this.routine.invoke(session, data, aggregateData, push);
        session.releaseInternalConnection();
        if (result.isError()) {
            throw result.getException();
        }
        if (isValue) {
            return result.valueData;
        }
        return result;
    }

    @Override
    public Object getValue(Session session) {
        if (this.opType == 5) {
            return session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
        }
        Object returnValue = this.getValueInternal(session, null);
        if (returnValue instanceof Result) {
            Result result = (Result)returnValue;
            if (result.isError()) {
                throw result.getException();
            }
            if (result.isSimpleValue()) {
                returnValue = result.valueType != null && result.valueType.typeCode != this.dataType.typeCode ? this.dataType.convertToType(session, result.getValueObject(), result.valueType) : result.getValueObject();
            } else if (result.isData()) {
                returnValue = result;
            } else {
                throw Error.error(4605, this.routine.getObjectName().name);
            }
            try {
                returnValue = this.dataType.convertToDefaultType(session, returnValue);
            }
            catch (Exception exception) {
                throw new DataspaceException("Incompatible function result types: Expected " + this.dataType.getNameString() + (String)(result.valueType != null ? " and got " + result.valueType.getNameString() : " and nothing returned") + ".");
            }
        }
        return returnValue;
    }

    @Override
    public Result getResult(Session session) {
        Object value = this.getValueInternal(session, null);
        if (value instanceof Result) {
            return (Result)value;
        }
        return Result.newPSMResult(value, this.dataType);
    }

    @Override
    public void collectObjectNames(Set set) {
        set.add(this.routine.getSpecificName());
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.routineSchema.getObjectName().getSchemaQualifiedStatementName());
        sb.append('(');
        int nodeCount = this.nodes.length;
        if (this.opType == 98) {
            nodeCount = 1;
        }
        for (int i = 0; i < nodeCount; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.nodes[i].getSQL());
        }
        sb.append(')');
        return sb.toString();
    }

    public String getSQLWithQuestions() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.routineSchema.getObjectName().getSchemaQualifiedStatementName());
        sb.append('(');
        int nodeCount = this.nodes.length;
        if (this.opType == 98) {
            nodeCount = 1;
        }
        for (int i = 0; i < nodeCount; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        return super.describeJson(session);
    }

    @Override
    public String describe(Session session, int blanks) {
        return super.describe(session, blanks);
    }

    @Override
    protected boolean isSelfAggregate() {
        return this.routineSchema.isAggregate();
    }

    public boolean isDeterministic() {
        return this.routine.isDeterministic();
    }

    @Override
    public boolean equals(Expression other) {
        if (!(other instanceof FunctionSQLInvoked)) {
            return false;
        }
        FunctionSQLInvoked o = (FunctionSQLInvoked)other;
        if (this.opType == other.opType && this.routineSchema == o.routineSchema && this.routine == o.routine && this.condition.equals(o.condition)) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public Object updateAggregatingValue(Session session, Object currValue) {
        if (!this.condition.testCondition(session)) {
            return currValue;
        }
        Object[] array = (Object[])currValue;
        if (array == null) {
            array = new Object[3];
        }
        array[0] = Boolean.FALSE;
        this.getValueInternal(session, array);
        return array;
    }

    @Override
    public Object getAggregatedValue(Session session, Object currValue) {
        Object[] array = (Object[])currValue;
        if (array == null) {
            array = new Object[3];
        }
        array[0] = Boolean.TRUE;
        Result result = (Result)this.getValueInternal(session, array);
        if (result.isError()) {
            throw result.getException();
        }
        return result.getValueObject();
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null && this.condition != Expression.EXPR_TRUE;
    }

    @Override
    public void setCondition(Expression e) {
        this.condition = e;
    }
}

