/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.IntValueHashMap;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.Tokens;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.procedure.SQLFunctionsMetaData;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.DTIType;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.SemanticType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FunctionSQL
extends Expression {
    protected static final int FUNC_POSITION_CHAR = 1;
    private static final int FUNC_POSITION_BINARY = 2;
    private static final int FUNC_OCCURENCES_REGEX = 3;
    private static final int FUNC_POSITION_REGEX = 4;
    protected static final int FUNC_EXTRACT = 5;
    protected static final int FUNC_BIT_LENGTH = 6;
    protected static final int FUNC_CHAR_LENGTH = 7;
    protected static final int FUNC_OCTET_LENGTH = 8;
    private static final int FUNC_CARDINALITY = 9;
    private static final int FUNC_MAX_CARDINALITY = 10;
    private static final int FUNC_TRIM_ARRAY = 11;
    private static final int FUNC_ABS = 12;
    private static final int FUNC_MOD = 13;
    protected static final int FUNC_LN = 14;
    private static final int FUNC_EXP = 15;
    private static final int FUNC_POWER = 16;
    private static final int FUNC_SQRT = 17;
    private static final int FUNC_FLOOR = 20;
    private static final int FUNC_CEILING = 21;
    private static final int FUNC_WIDTH_BUCKET = 22;
    protected static final int FUNC_SUBSTRING_CHAR = 23;
    private static final int FUNC_SUBSTRING_REG_EXPR = 24;
    protected static final int FUNC_FOLD_LOWER = 26;
    protected static final int FUNC_FOLD_UPPER = 27;
    private static final int FUNC_TRANSCODING = 28;
    private static final int FUNC_TRANSLITERATION = 29;
    private static final int FUNC_REGEX_TRANSLITERATION = 30;
    protected static final int FUNC_TRIM_CHAR = 31;
    static final int FUNC_OVERLAY_CHAR = 32;
    private static final int FUNC_CHAR_NORMALIZE = 33;
    private static final int FUNC_SUBSTRING_BINARY = 40;
    private static final int FUNC_TRIM_BINARY = 41;
    private static final int FUNC_OVERLAY_BINARY = 42;
    public static final int FUNC_CURRENT_DATE = 43;
    public static final int FUNC_CURRENT_TIME = 44;
    public static final int FUNC_CURRENT_TIMESTAMP = 50;
    public static final int FUNC_LOCALTIME = 51;
    public static final int FUNC_LOCALTIMESTAMP = 52;
    private static final int FUNC_CURRENT_CATALOG = 53;
    private static final int FUNC_CURRENT_DEFAULT_TRANSFORM_GROUP = 54;
    private static final int FUNC_CURRENT_PATH = 55;
    private static final int FUNC_CURRENT_ROLE = 56;
    private static final int FUNC_CURRENT_SCHEMA = 57;
    private static final int FUNC_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 58;
    private static final int FUNC_CURRENT_USER = 59;
    private static final int FUNC_SESSION_USER = 60;
    private static final int FUNC_SYSTEM_USER = 61;
    protected static final int FUNC_USER = 62;
    public static final int FUNC_VALUE = 63;
    public static final int FUNC_IS_TYPE = 64;
    public static final int FUNC_GET_DOMAIN_TYPE = 65;
    public static final int FUNC_GET_ASSIGNED_TYPE = 66;
    private static final int FUNC_GET_CURRENT_SESSION_ID = 67;
    static final short[] noParamList;
    static final short[] emptyParamList;
    static final short[] optionalNoParamList;
    static final short[] optionalSingleParamList;
    static final short[] singleParamList;
    static final short[] optionalIntegerParamList;
    static final short[] doubleParamList;
    static final short[] tripleParamList;
    static final short[] quadParamList;
    static IntValueHashMap valueFuncMap;
    static IntValueHashMap regularFuncMap;
    static OrderedIntHashSet nonDeterministicFuncSet;
    static List<String> functionNames;
    static SQLFunctionsMetaData functions;
    public int funcType;
    boolean isDeterministic;
    String name;
    public short[] parseList;
    public short[] parseListAlt;
    boolean isSQLValueFunction;

    protected static void checkAllFunctionsMetaDataInitialized(SQLFunctionsMetaData funcs, Collection<String> names) throws Exception {
        ArrayList<String> names1 = new ArrayList<String>(funcs.listFunctionNames());
        names1.removeAll(names);
        if (names1.size() > 0) {
            throw new Exception("The following functions have meta data, but not present in functionNames: " + ((Object)names1).toString());
        }
        ArrayList<String> functionNamesClone = new ArrayList<String>(names);
        functionNamesClone.removeAll(funcs.listFunctionNames());
        if (functionNamesClone.size() > 0) {
            throw new Exception("The following functions don't have meta data: " + ((Object)functionNamesClone).toString());
        }
    }

    protected static void compareFunctionsSignatures(SQLFunctionsMetaData.SQLFunctionMetaData metadata, FunctionSQL function, short[] parseList) throws Exception {
        if ((parseList == null || parseList.length == 0) && metadata.getArgumentsCount() != 0) {
            throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
        }
        FunctionSQL.compareFunctionsSignatures(metadata, function, parseList, -1, 0, parseList.length, false);
    }

    private static int compareFunctionsSignatures(SQLFunctionsMetaData.SQLFunctionMetaData metadata, FunctionSQL function, short[] parseList, int currentArgument, int index, int count, boolean isOptional) throws Exception {
        boolean inPrefix = false;
        block7: for (int i = index; i < index + count; ++i) {
            short exprType = parseList[i];
            switch (exprType) {
                case 788: 
                case 844: {
                    if (!inPrefix) {
                        ++currentArgument;
                    }
                    if (currentArgument >= metadata.getArgumentsCount()) {
                        throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                    }
                    if (!isOptional || metadata.getArgument(currentArgument).isOptional()) continue block7;
                    throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                }
                case 842: {
                    short optionalCount = parseList[++i];
                    currentArgument = FunctionSQL.compareFunctionsSignatures(metadata, function, parseList, currentArgument, ++i, optionalCount, true);
                    i += optionalCount - 1;
                    continue block7;
                }
                case 841: {
                    if (!inPrefix) {
                        ++currentArgument;
                    }
                    if (currentArgument >= metadata.getArgumentsCount()) {
                        throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                    }
                    int keySetCount = parseList[++i];
                    int[] keySet = metadata.getArgument(currentArgument).getKeySet();
                    if (keySet == null || keySet.length != keySetCount) {
                        throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                    }
                    ++i;
                    for (int j = 0; j < keySetCount; ++j) {
                        if (keySet[j] == parseList[i + j]) continue;
                        throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                    }
                    i += keySetCount - 1;
                    continue block7;
                }
                case 772: {
                    if (currentArgument == metadata.getArgumentsCount() - 1) continue block7;
                    throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                }
                case 774: 
                case 786: {
                    continue block7;
                }
                default: {
                    int j;
                    inPrefix = true;
                    if (++currentArgument >= metadata.getArgumentsCount()) {
                        throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                    }
                    int[] prefixes = metadata.getArgument(currentArgument).getPrefixes();
                    if (prefixes == null || prefixes.length == 0 || prefixes[0] != exprType) {
                        throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                    }
                    if (prefixes.length <= 1) continue block7;
                    for (j = 1; j < prefixes.length; ++j) {
                        if (i + j < index + count && parseList[i + j] == prefixes[j]) continue;
                        throw FunctionSQL.functionSignaturesDifferenException(metadata, function);
                    }
                    i += j - 1;
                }
            }
        }
        return currentArgument;
    }

    private static Exception functionSignaturesDifferenException(SQLFunctionsMetaData.SQLFunctionMetaData metadata, FunctionSQL function) {
        return new Exception("SQL Function has different signatures, in metadata: " + metadata.getSignature() + ", in parseList: " + function.getFunctionDefinition());
    }

    public static SQLFunctionsMetaData.SQLFunctionMetaData getFunctionMetaData(String functionName) {
        return functions.lookupFunction(functionName);
    }

    public static FunctionSQL newSQLFunction(String token, ParserDQL.CompileContext context) {
        int id = regularFuncMap.get((Object)token, -1);
        boolean isValueFunction = false;
        if (id == -1) {
            id = valueFuncMap.get((Object)token, -1);
            isValueFunction = true;
        }
        if (id == -1) {
            return null;
        }
        FunctionSQL function = new FunctionSQL(id);
        if (id == 63) {
            if (context != null) {
                if (context.currentDomain == null) {
                    return null;
                }
                function.dataType = context.currentDomain;
            }
        } else {
            function.isSQLValueFunction = isValueFunction;
        }
        return function;
    }

    protected FunctionSQL() {
        super(28);
        this.nodes = Expression.emptyArray;
    }

    public FunctionSQL(int id) {
        this();
        this.funcType = id;
        this.isDeterministic = !nonDeterministicFuncSet.contains(id);
        switch (id) {
            case 1: 
            case 2: {
                this.name = "position";
                this.parseList = new short[]{786, 788, 130, 788, 842, 5, 306, 841, 2, 355, 454, 772};
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                this.name = "extract";
                this.parseList = new short[]{786, 841, 17, 323, 173, 73, 127, 169, 250, 669, 763, 709, 670, 668, 763, 667, 700, 722, 283, 284, 115, 788, 772};
                break;
            }
            case 7: {
                this.name = "charLength";
                this.parseList = new short[]{786, 788, 772};
                break;
            }
            case 6: {
                this.name = "bitLength";
                this.parseList = singleParamList;
                break;
            }
            case 8: {
                this.name = "octetLength";
                this.parseList = singleParamList;
                break;
            }
            case 9: {
                this.name = "cardinality";
                this.parseList = singleParamList;
                break;
            }
            case 10: {
                this.name = "maxCardinality";
                this.parseList = singleParamList;
                break;
            }
            case 11: {
                this.name = "trimArray";
                this.parseList = doubleParamList;
                break;
            }
            case 12: {
                this.name = "abs";
                this.parseList = singleParamList;
                break;
            }
            case 13: {
                this.name = "mod";
                this.parseList = doubleParamList;
                break;
            }
            case 14: {
                this.name = "ln";
                this.parseList = singleParamList;
                break;
            }
            case 15: {
                this.name = "exp";
                this.parseList = singleParamList;
                break;
            }
            case 16: {
                this.name = "power";
                this.parseList = doubleParamList;
                break;
            }
            case 17: {
                this.name = "sqrt";
                this.parseList = singleParamList;
                break;
            }
            case 20: {
                this.name = "floor";
                this.parseList = singleParamList;
                break;
            }
            case 21: {
                this.name = "ceiling";
                this.parseList = singleParamList;
                break;
            }
            case 22: {
                this.name = "widthBucket";
                this.parseList = quadParamList;
                break;
            }
            case 23: 
            case 40: {
                this.name = id == 23 ? "substring" : "subbinary";
                this.parseList = new short[]{786, 788, 115, 788, 842, 2, 112, 788, 842, 5, 306, 841, 2, 355, 454, 772};
                this.parseListAlt = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 26: {
                this.name = "lower";
                this.parseList = singleParamList;
                break;
            }
            case 27: {
                this.name = "upper";
                this.parseList = singleParamList;
                break;
            }
            case 31: 
            case 41: {
                this.name = "trim";
                this.parseList = new short[]{786, 842, 11, 842, 5, 841, 3, 151, 286, 23, 842, 1, 788, 115, 788, 772};
                break;
            }
            case 32: 
            case 42: {
                this.name = "overlay";
                this.parseList = new short[]{786, 788, 473, 788, 115, 788, 842, 2, 112, 788, 842, 2, 306, 355, 772};
                break;
            }
            case 53: {
                this.name = "currentCatalog";
                this.parseList = noParamList;
                break;
            }
            case 56: {
                this.name = "currentRole";
                this.parseList = noParamList;
                break;
            }
            case 57: {
                this.name = "currentSchema";
                this.parseList = noParamList;
                break;
            }
            case 59: {
                this.name = "currentUser";
                this.parseList = noParamList;
                break;
            }
            case 67: {
                this.name = "getCurrentSessionId";
                this.parseList = noParamList;
                break;
            }
            case 60: {
                this.name = "sessionUser";
                this.parseList = noParamList;
                break;
            }
            case 61: {
                this.name = "systemUser";
                this.parseList = noParamList;
                break;
            }
            case 62: {
                this.name = "user";
                this.parseList = optionalNoParamList;
                break;
            }
            case 63: {
                this.name = "value";
                this.parseList = noParamList;
                break;
            }
            case 43: {
                this.name = "currentDate";
                this.parseList = noParamList;
                break;
            }
            case 44: {
                this.name = "currentTime";
                this.parseList = noParamList;
                break;
            }
            case 50: {
                this.name = "currentTimestamp";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 51: {
                this.name = "localtime";
                this.parseList = noParamList;
                break;
            }
            case 52: {
                this.name = "localtimestamp";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 64: {
                this.name = "isType";
                this.parseList = doubleParamList;
                break;
            }
            case 65: {
                this.name = "getDomainType";
                this.parseList = singleParamList;
                break;
            }
            case 66: {
                this.name = "getAssignedType";
                this.parseList = singleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL, id: " + id);
            }
        }
    }

    public void setArguments(Expression[] newNodes) {
        this.nodes = newNodes;
    }

    public Expression getFunctionExpression() {
        return this;
    }

    @Override
    public Object getValue(Session session) {
        Object[] data = new Object[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            if (e == null) continue;
            data[i] = e.getValue(session, e.dataType);
        }
        return this.getValue(session, data);
    }

    Object getValue(Session session, Object[] data) {
        switch (this.funcType) {
            case 1: {
                Object value;
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                long offset = 0L;
                if (this.nodes.length > 3 && this.nodes[3] != null && (offset = ((Number)(value = this.nodes[3].getValue(session))).longValue() - 1L) < 0L) {
                    offset = 0L;
                }
                long result = ((CharacterType)this.nodes[1].dataType).position(session, data[1], data[0], this.nodes[0].dataType, offset) + 1L;
                if (this.nodes[2] != null && ((Number)this.nodes[2].valueData).intValue() == 454) {
                    result *= 2L;
                }
                return ValuePool.getLong(result);
            }
            case 2: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                long result = ((BinaryType)this.nodes[1].dataType).position(session, (BlobData)data[1], (BlobData)data[0], this.nodes[0].dataType, 0L) + 1L;
                if (this.nodes[2] != null && ((Number)this.nodes[2].valueData).intValue() == 454) {
                    result *= 2L;
                }
                return ValuePool.getLong(result);
            }
            case 5: {
                if (data[1] == null) {
                    return null;
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                part = DTIType.getFieldNameTypeForToken(part);
                switch (part) {
                    case 106: {
                        return ((DTIType)this.nodes[1].dataType).getSecondPart(data[1]);
                    }
                    case 264: 
                    case 265: {
                        return ((DateTimeType)this.nodes[1].dataType).getPartString(session, data[1], part);
                    }
                }
                int value = ((DTIType)this.nodes[1].dataType).getPart(session, data[1], part);
                return ValuePool.getInt(value);
            }
            case 7: {
                if (data[0] == null) {
                    return null;
                }
                long result = ((CharacterType)this.nodes[0].dataType).size(session, data[0]);
                return ValuePool.getLong(result);
            }
            case 6: {
                if (data[0] == null) {
                    return null;
                }
                long result = this.nodes[0].dataType.isBinaryType() ? ((BlobData)data[0]).bitLength(session) : 16L * ((CharacterType)this.nodes[0].dataType).size(session, data[0]);
                return ValuePool.getLong(result);
            }
            case 8: {
                if (data[0] == null) {
                    return null;
                }
                long result = this.nodes[0].dataType.isBinaryType() ? ((BlobData)data[0]).length(session) : 2L * ((CharacterType)this.nodes[0].dataType).size(session, data[0]);
                return ValuePool.getLong(result);
            }
            case 9: {
                if (data[0] == null) {
                    return null;
                }
                int result = this.nodes[0].dataType.cardinality(session, data[0]);
                return ValuePool.getInt(result);
            }
            case 10: {
                if (data[0] == null) {
                    return null;
                }
                int result = this.nodes[0].dataType.arrayLimitCardinality();
                return ValuePool.getInt(result);
            }
            case 11: {
                if (data[0] == null) {
                    return null;
                }
                if (data[1] == null) {
                    return null;
                }
                Object[] array = (Object[])data[0];
                int length = ((Number)data[1]).intValue();
                if (length < 0 || length > array.length) {
                    throw Error.error(3490);
                }
                Object[] newArray = new Object[array.length - length];
                System.arraycopy(array, 0, newArray, 0, newArray.length);
                return newArray;
            }
            case 64: {
                Object objectForCheck = OtherTypeWrapper.unwrap(data[0]);
                if (objectForCheck == null) {
                    return true;
                }
                if (data[1] == null) {
                    return false;
                }
                String semanticType = data[1].toString();
                SemanticType type = DataspaceStoreManager.getContext().getSemanticTypeCache().lookupSemanticType(semanticType);
                try {
                    Class typeClass;
                    String className = semanticType;
                    if (type != null) {
                        className = type.getClassName();
                    }
                    if ((typeClass = ClassUtils.loadClass(className, DataspaceStoreManager.getContext().getSystemClassLoaderChain())).isAssignableFrom(objectForCheck.getClass()) || typeClass.getName().equals(objectForCheck.getClass().getName())) {
                        return true;
                    }
                    return false;
                }
                catch (Exception error) {
                    throw new DataspaceException(error);
                }
            }
            case 65: {
                Type dataType = this.nodes[0].getDataType();
                if (dataType == null) {
                    return "undefined";
                }
                String typeName = dataType.getTypeDefinition();
                if (typeName == null || typeName.equalsIgnoreCase("OTHER")) {
                    typeName = "object";
                }
                return typeName;
            }
            case 66: {
                Object objectForCheck = OtherTypeWrapper.unwrap(data[0]);
                Type dataType = this.nodes[0].getDataType();
                if (dataType != null) {
                    objectForCheck = dataType.convertSQLToJava(session, objectForCheck);
                }
                if (objectForCheck == null) {
                    return "unassigned";
                }
                return Type.resolveTypeName(session, objectForCheck);
            }
            case 12: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.absolute(data[0]);
            }
            case 13: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).modulo(data[0], data[1], this.nodes[0].dataType);
            }
            case 14: {
                if (data[0] == null) {
                    return null;
                }
                double d = ((Number)data[0]).doubleValue();
                if (d <= 0.0) {
                    throw Error.error(3444);
                }
                d = Math.log(d);
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 15: {
                if (data[0] == null) {
                    return null;
                }
                double val = Math.exp(((Number)data[0]).doubleValue());
                return ValuePool.getDouble(Double.doubleToLongBits(val));
            }
            case 16: {
                double val;
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                double base = ((Number)data[0]).doubleValue();
                double exponent = ((Number)data[1]).doubleValue();
                if (base == 0.0) {
                    if (exponent < 0.0) {
                        throw Error.error(3445);
                    }
                    val = exponent == 0.0 ? 1.0 : 0.0;
                } else {
                    val = Math.pow(base, exponent);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(val));
            }
            case 17: {
                if (data[0] == null) {
                    return null;
                }
                double val = Math.sqrt(((Number)data[0]).doubleValue());
                return ValuePool.getDouble(Double.doubleToLongBits(val));
            }
            case 20: {
                if (data[0] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).floor(data[0]);
            }
            case 21: {
                if (data[0] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).ceiling(data[0]);
            }
            case 22: {
                return null;
            }
            case 23: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object value = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].dataType);
                long offset = ((Number)value).longValue() - 1L;
                long length = 0L;
                if (this.nodes[2] != null) {
                    if (data[2] == null) {
                        return null;
                    }
                    value = Type.SQL_BIGINT.convertToType(session, data[2], this.nodes[2].dataType);
                    length = ((Number)value).longValue();
                }
                if (this.nodes.length <= 3 || this.nodes[3] == null || ((Number)this.nodes[2].valueData).intValue() == 454) {
                    // empty if block
                }
                return ((CharacterType)this.dataType).substring(session, data[0], offset, length, this.nodes[2] != null, false);
            }
            case 26: {
                if (data[0] == null) {
                    return null;
                }
                return ((CharacterType)this.dataType).lower(session, data[0]);
            }
            case 27: {
                if (data[0] == null) {
                    return null;
                }
                return ((CharacterType)this.dataType).upper(session, data[0]);
            }
            case 31: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                boolean leading = false;
                boolean trailing = false;
                switch (((Number)this.nodes[0].valueData).intValue()) {
                    case 23: {
                        trailing = true;
                        leading = true;
                        break;
                    }
                    case 151: {
                        leading = true;
                        break;
                    }
                    case 286: {
                        trailing = true;
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "FunctionSQL");
                    }
                }
                String string = (String)data[1];
                if (string.length() != 1) {
                    throw Error.error(3460);
                }
                char character = string.charAt(0);
                return ((CharacterType)this.dataType).trim(session, data[2], character, leading, trailing);
            }
            case 32: {
                if (data[0] == null || data[1] == null || data[2] == null) {
                    return null;
                }
                Object value = Type.SQL_BIGINT.convertToType(session, data[2], this.nodes[2].dataType);
                long offset = ((Number)value).longValue() - 1L;
                long length = 0L;
                if (this.nodes[3] != null) {
                    if (data[3] == null) {
                        return null;
                    }
                    value = Type.SQL_BIGINT.convertToType(session, data[3], this.nodes[3].dataType);
                    length = ((Number)value).longValue();
                }
                return ((CharacterType)this.dataType).overlay(null, data[0], data[1], offset, length, this.nodes[3] != null);
            }
            case 40: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object value = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].dataType);
                long offset = ((Number)value).longValue() - 1L;
                long length = 0L;
                if (this.nodes[2] != null) {
                    if (data[2] == null) {
                        return null;
                    }
                    value = Type.SQL_BIGINT.convertToType(session, data[2], this.nodes[2].dataType);
                    length = ((Number)value).intValue();
                }
                BlobData d = data[0] instanceof FlobData ? ((FlobData)data[0]).getBlobAdapter() : (BlobData)data[0];
                return ((BinaryType)this.dataType).substring(session, d, offset, length, this.nodes[2] != null);
            }
            case 41: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                boolean leading = false;
                boolean trailing = false;
                int spec = ((Number)this.nodes[0].valueData).intValue();
                switch (spec) {
                    case 23: {
                        trailing = true;
                        leading = true;
                        break;
                    }
                    case 151: {
                        leading = true;
                        break;
                    }
                    case 286: {
                        trailing = true;
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "FunctionSQL");
                    }
                }
                BlobData string = (BlobData)data[1];
                if (string.length(session) != 1L) {
                    throw Error.error(3460);
                }
                byte[] bytes = string.getBytes();
                return ((BinaryType)this.dataType).trim(session, (BlobData)data[2], bytes[0], leading, trailing);
            }
            case 42: {
                if (data[0] == null || data[1] == null || data[2] == null) {
                    return null;
                }
                Object value = Type.SQL_BIGINT.convertToType(session, data[2], this.nodes[2].dataType);
                long offset = ((Number)value).longValue() - 1L;
                long length = 0L;
                if (this.nodes[3] != null) {
                    if (data[3] == null) {
                        return null;
                    }
                    value = Type.SQL_BIGINT.convertToType(session, data[3], this.nodes[3].dataType);
                    length = ((Number)value).longValue();
                }
                return ((BinaryType)this.dataType).overlay(session, (BlobData)data[0], (BlobData)data[1], offset, length, this.nodes[3] != null);
            }
            case 53: {
                return session.dataspaceStore.getCatalogName().name;
            }
            case 56: {
                return session.getRole() == null ? null : session.getRole().getObjectName().getNameString();
            }
            case 57: {
                return session.getCurrentDataspaceName().name;
            }
            case 59: {
                return session.getUser().getObjectName().getNameString();
            }
            case 67: {
                return session.getId();
            }
            case 60: {
                return session.getUser().getObjectName().getNameString();
            }
            case 61: {
                return session.getUser().getObjectName().getNameString();
            }
            case 62: {
                return session.getUser().getObjectName().getNameString();
            }
            case 63: {
                return session.sessionData.currentValue;
            }
            case 43: {
                return session.getCurrentDate();
            }
            case 44: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTime(true));
            }
            case 50: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTimestamp(true));
            }
            case 51: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTime(false));
            }
            case 52: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTimestamp(false));
            }
        }
        throw Error.runtimeError(201, "FunctionSQL");
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            if (this.nodes[i].isDynamicParam()) {
                SQLFunctionsMetaData.SQLFunctionMetaData.Argument arg;
                SQLFunctionsMetaData.SQLFunctionMetaData meta = functions.lookupFunction(this.funcType);
                if (meta == null || (arg = meta.getArgument(i)) == null || arg.getTypes() == null || arg.getTypes().length <= 0) continue;
                this.nodes[i].setDataType(session, arg.getTypes()[0]);
                continue;
            }
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.funcType) {
            case 1: 
            case 2: {
                if (this.nodes[0].dataType == null) {
                    if (this.nodes[1].dataType == null) {
                        throw Error.error(5567);
                    }
                    this.nodes[0].dataType = this.nodes[1].dataType.typeCode == 40 || this.nodes[1].dataType.isBinaryType() ? this.nodes[1].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[0].dataType.isBinaryType() ? this.nodes[0].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType()) {
                    this.funcType = 1;
                } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType()) {
                    if (this.nodes[0].dataType.isBitType() || this.nodes[1].dataType.isBitType()) {
                        throw Error.error(5563);
                    }
                    this.funcType = 2;
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    if (this.nodes[3].isDynamicParam()) {
                        this.nodes[3].dataType = Type.SQL_BIGINT;
                    }
                    if (!this.nodes[3].dataType.isNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 5: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType() && !this.nodes[1].dataType.isIntervalType()) {
                    throw Error.error(5563);
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                DTIType type = (DTIType)this.nodes[1].dataType;
                part = DTIType.getFieldNameTypeForToken(part);
                this.dataType = type.getExtractType(part);
                break;
            }
            case 6: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_BIT_VARYING_MAX_LENGTH;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 7: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
            }
            case 8: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.LONG;
                break;
            }
            case 9: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 10: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 11: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 13: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = ((NumberType)this.nodes[0].dataType).getIntegralType();
                this.dataType = this.nodes[1].dataType = ((NumberType)this.nodes[1].dataType).getIntegralType();
                break;
            }
            case 16: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = Type.SQL_DOUBLE;
                this.nodes[1].dataType = Type.SQL_DOUBLE;
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = Type.SQL_DOUBLE;
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 12: {
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isIntervalType()) {
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
            }
            case 20: 
            case 21: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 3 && this.dataType.typeCode != 2 || this.dataType.scale <= 0) break;
                this.dataType = NumberType.getNumberType(this.dataType.typeCode, this.dataType.precision + 1L, 0);
                break;
            }
            case 22: {
                if (this.nodes[0].dataType == null || this.nodes[1].dataType == null || this.nodes[2].dataType == null || this.nodes[3].dataType == null) {
                    throw Error.error(5567);
                }
                if (!(this.nodes[0].dataType.isNumberType() && this.nodes[1].dataType.isNumberType() && this.nodes[2].dataType.isNumberType() && this.nodes[3].dataType.isIntegralType())) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[3].dataType;
                break;
            }
            case 23: 
            case 40: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_NUMERIC;
                    }
                    if (!this.nodes[2].dataType.isNumberType()) {
                        throw Error.error(5563);
                    }
                    this.nodes[2].dataType = ((NumberType)this.nodes[2].dataType).getIntegralType();
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType instanceof FlobType) {
                    this.dataType = this.funcType == 23 ? Type.STRING : Type.SQL_VARBINARY;
                } else if (this.dataType.isCharacterType()) {
                    this.funcType = 23;
                    if (this.dataType.typeCode == 1) {
                        this.dataType = CharacterType.getCharacterType(12, this.dataType.precision);
                    }
                } else if (this.dataType.isBinaryType()) {
                    this.funcType = 40;
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes.length <= 3 || this.nodes[3] == null) break;
                break;
            }
            case 26: 
            case 27: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType()) break;
                throw Error.error(5563);
            }
            case 31: 
            case 41: {
                if (this.nodes[0] == null) {
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(23), Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    throw Error.error(5567);
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.isCharacterType()) {
                    this.funcType = 31;
                    if (this.dataType.typeCode == 1) {
                        this.dataType = CharacterType.getCharacterType(12, this.dataType.precision);
                    }
                    if (this.nodes[1] != null) break;
                    this.nodes[1] = new ExpressionValue(" ", Type.SQL_CHAR);
                    break;
                }
                if (this.dataType.isBinaryType()) {
                    this.funcType = 41;
                    if (this.nodes[1] != null) break;
                    this.nodes[1] = new ExpressionValue(new BinaryData(new byte[]{0}, false), Type.SQL_BINARY);
                    break;
                }
                throw Error.error(5563);
            }
            case 32: 
            case 42: {
                if (this.nodes[0].dataType == null) {
                    if (this.nodes[1].dataType == null) {
                        throw Error.error(5567);
                    }
                    this.nodes[0].dataType = this.nodes[1].dataType.typeCode == 40 || this.nodes[1].dataType.isBinaryType() ? this.nodes[1].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[0].dataType.isBinaryType() ? this.nodes[0].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType()) {
                    this.funcType = 32;
                    this.dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[1].dataType.typeCode == 40 ? CharacterType.getCharacterType(40, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision) : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision);
                } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType()) {
                    this.funcType = 42;
                    this.dataType = this.nodes[0].dataType.typeCode == 30 || this.nodes[1].dataType.typeCode == 30 ? BinaryType.getBinaryType(30, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision) : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision);
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[2].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[2].dataType = ((NumberType)this.nodes[2].dataType).getIntegralType();
                if (this.nodes[3] == null) break;
                if (this.nodes[3].dataType == null) {
                    this.nodes[3].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[3].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[3].dataType = ((NumberType)this.nodes[3].dataType).getIntegralType();
                break;
            }
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.dataType = SqlInvariants.SQL_IDENTIFIER;
                break;
            }
            case 67: {
                this.dataType = Type.LONG;
                break;
            }
            case 63: {
                break;
            }
            case 43: {
                this.dataType = CharacterType.SQL_DATE;
                break;
            }
            case 44: {
                int precision = 0;
                this.dataType = DateTimeType.getDateTimeType(94, precision);
                break;
            }
            case 50: {
                int precision = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(95, precision);
                break;
            }
            case 51: {
                int precision = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(92, precision);
                break;
            }
            case 52: {
                int precision = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(93, precision);
                break;
            }
            case 64: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 65: 
            case 66: {
                this.dataType = Type.SQL_VARCHAR;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.funcType) {
            case 1: 
            case 2: {
                sb.append("position").append('(').append(this.nodes[0].getSQL()).append(' ').append("IN").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null && Boolean.TRUE.equals(this.nodes[2].valueData)) {
                    sb.append(' ').append("USING").append(' ').append("OCTETS");
                }
                sb.append(')');
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int type = (Integer)this.nodes[0].valueData;
                type = DTIType.getFieldNameTypeForToken(type);
                String token = DTIType.getFieldNameTokenForType(type);
                sb.append("extract").append('(').append(token).append(' ').append("FROM").append(' ').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 7: {
                sb.append("charLength").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 6: {
                sb.append("bitLength").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 8: {
                sb.append("octetLength").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 9: {
                sb.append("cardinality").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 10: {
                sb.append("maxCardinality").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 11: {
                sb.append("trimArray").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 12: {
                sb.append("abs").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 13: {
                sb.append("mod").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 14: {
                sb.append("ln").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 15: {
                sb.append("exp").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 16: {
                sb.append("power").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 17: {
                sb.append("sqrt").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 20: {
                sb.append("floor").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 21: {
                sb.append("ceiling").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 22: {
                sb.append("widthBucket").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(',').append(this.nodes[2].getSQL()).append(',').append(this.nodes[3].getSQL()).append(')');
                break;
            }
            case 23: 
            case 40: {
                sb.append(this.funcType == 23 ? "substring" : "subbinary").append('(').append(this.nodes[0].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(' ').append("FOR").append(' ').append(this.nodes[2].getSQL());
                }
                if (this.nodes.length > 3 && this.nodes[3] != null && Boolean.TRUE.equals(this.nodes[3].valueData)) {
                    sb.append(' ').append("USING").append(' ').append("OCTETS");
                }
                sb.append(')');
                break;
            }
            case 26: {
                sb.append("lower").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 27: {
                sb.append("upper").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 32: 
            case 42: {
                sb.append("overlay").append('(').append(this.nodes[0].getSQL()).append(' ').append("PLACING").append(' ').append(this.nodes[1].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL());
                if (this.nodes[3] != null) {
                    sb.append(' ').append("FOR").append(' ').append(this.nodes[3].getSQL());
                }
                if (this.nodes[4] != null && Boolean.TRUE.equals(this.nodes[4].valueData)) {
                    sb.append(' ').append("USING").append(' ').append("OCTETS");
                }
                sb.append(')');
                break;
            }
            case 31: 
            case 41: {
                String spec = null;
                switch (((Number)this.nodes[0].valueData).intValue()) {
                    case 23: {
                        spec = "BOTH";
                        break;
                    }
                    case 151: {
                        spec = "LEADING";
                        break;
                    }
                    case 286: {
                        spec = "TRAILING";
                    }
                }
                sb.append("trim").append('(').append(spec).append(' ').append(this.nodes[1].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL()).append(')');
                break;
            }
            case 43: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                return this.name;
            }
            case 44: 
            case 51: {
                int precision = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = ((Number)this.nodes[0].valueData).intValue();
                }
                if (precision == 0) {
                    return this.name;
                }
                sb.append(this.name).append("(").append(precision);
                sb.append(")");
                return sb.toString();
            }
            case 50: 
            case 52: {
                int precision = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = ((Number)this.nodes[0].valueData).intValue();
                }
                if (precision == 6) {
                    return this.name;
                }
                sb.append(this.name).append("(").append(precision);
                sb.append(")");
                return sb.toString();
            }
            case 64: {
                sb.append("isType").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL());
                sb.append(')');
                break;
            }
            case 65: {
                sb.append("getDomainType").append('(').append(this.nodes[0].getSQL());
                sb.append(')');
                break;
            }
            case 66: {
                sb.append("getAssignedType").append('(').append(this.nodes[0].getSQL());
                sb.append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Expression other) {
        if (other instanceof FunctionSQL && this.funcType == ((FunctionSQL)other).funcType) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.opType + this.funcType;
    }

    public static List<String> listFunctions() {
        return functionNames;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("opType", "FUNCTION");
        result.put("functionName", this.name);
        ArrayList<Map<String, Object>> argsExplained = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            argsExplained.add(this.nodes[i].describeJson(session));
        }
        result.put("args", argsExplained);
        result.put("returns", this.dataType.getNameString());
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("FUNCTION ").append("=[\n");
        sb.append(this.name).append("(");
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            sb.append("[").append(this.nodes[i].describe(session, blanks)).append("]");
        }
        sb.append(") returns ").append(this.dataType.getNameString());
        sb.append("]\n");
        return sb.toString();
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public boolean isValueFunction() {
        return this.isSQLValueFunction;
    }

    public String getFunctionDefinition() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        if (this.parseList != null) {
            this.appendFunctionParameters(builder, 0, this.parseList.length, false);
        }
        builder.append(" returns < ");
        if (this.dataType != null) {
            builder.append(this.dataType.getDefinition());
        } else {
            builder.append("Value");
        }
        builder.append(" >");
        return builder.toString();
    }

    private void appendFunctionParameters(StringBuilder builder, int start, int count, boolean inKeySet) {
        block6: for (int i = start; i < this.parseList.length && i < start + count; ++i) {
            short exprType = this.parseList[i];
            switch (exprType) {
                case 788: {
                    builder.append("< Value > ");
                    break;
                }
                case 844: {
                    builder.append("< INTEGER Value > ");
                    break;
                }
                case 842: {
                    builder.append("[ ");
                    short inOptionCount = this.parseList[++i];
                    this.appendFunctionParameters(builder, ++i, inOptionCount, false);
                    i += inOptionCount - 1;
                    builder.append("] ");
                    continue block6;
                }
                case 841: {
                    builder.append("{ ");
                    short inKeySetCount = this.parseList[++i];
                    this.appendFunctionParameters(builder, ++i, inKeySetCount, true);
                    i += inKeySetCount - 1;
                    builder.setLength(builder.length() - 2);
                    builder.append("} ");
                    continue block6;
                }
                default: {
                    builder.append(Tokens.getKeyword(exprType)).append(" ");
                }
            }
            if (!inKeySet) continue;
            builder.append("| ");
        }
    }

    @Override
    public void collectObjectNames(Set set) {
        if (this.funcType == 64) {
            if (this.nodes[0] != null) {
                this.nodes[0].collectObjectNames(set);
            }
            if (this.nodes[1] != null && this.nodes[1] instanceof ExpressionValue) {
                Object typeName = ((ExpressionValue)this.nodes[1]).valueData;
                if (typeName instanceof String) {
                    set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetSemanticTypeObjectName((String)typeName));
                }
            } else {
                this.nodes[1].collectObjectNames(set);
            }
        } else {
            super.collectObjectNames(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        Iterator<String> funcName;
        noParamList = new short[0];
        emptyParamList = new short[]{786, 772};
        optionalNoParamList = new short[]{842, 2, 786, 772};
        optionalSingleParamList = new short[]{786, 842, 1, 788, 772};
        singleParamList = new short[]{786, 788, 772};
        optionalIntegerParamList = new short[]{842, 3, 786, 844, 772};
        doubleParamList = new short[]{786, 788, 774, 788, 772};
        tripleParamList = new short[]{786, 788, 774, 788, 774, 788, 772};
        quadParamList = new short[]{786, 788, 774, 788, 774, 788, 774, 788, 772};
        valueFuncMap = new IntValueHashMap();
        regularFuncMap = new IntValueHashMap();
        nonDeterministicFuncSet = new OrderedIntHashSet();
        functionNames = new ArrayList<String>();
        functions = new SQLFunctionsMetaData();
        regularFuncMap.put("position", 1);
        regularFuncMap.put("positionRegex", 4);
        regularFuncMap.put("position_regex", 4);
        regularFuncMap.put("extract", 5);
        regularFuncMap.put("bitLength", 6);
        regularFuncMap.put("bit_length", 6);
        regularFuncMap.put("charLength", 7);
        regularFuncMap.put("char_length", 7);
        regularFuncMap.put("characterLength", 7);
        regularFuncMap.put("character_length", 7);
        regularFuncMap.put("octetLength", 8);
        regularFuncMap.put("octet_length", 8);
        regularFuncMap.put("cardinality", 9);
        regularFuncMap.put("maxCardinality", 10);
        regularFuncMap.put("max_cardinality", 10);
        regularFuncMap.put("trimArray", 11);
        regularFuncMap.put("trim_array", 11);
        regularFuncMap.put("array_trim", 11);
        regularFuncMap.put("abs", 12);
        regularFuncMap.put("mod", 13);
        regularFuncMap.put("ln", 14);
        regularFuncMap.put("exp", 15);
        regularFuncMap.put("power", 16);
        regularFuncMap.put("sqrt", 17);
        regularFuncMap.put("floor", 20);
        regularFuncMap.put("ceiling", 21);
        regularFuncMap.put("ceil", 21);
        regularFuncMap.put("widthBucket", 22);
        regularFuncMap.put("width_bucket", 22);
        regularFuncMap.put("substring", 23);
        regularFuncMap.put("subbinary", 40);
        regularFuncMap.put("lower", 26);
        regularFuncMap.put("upper", 27);
        regularFuncMap.put("trim", 31);
        regularFuncMap.put("overlay", 32);
        regularFuncMap.put("trim", 41);
        com.streamscape.ds.lib.Iterator iter = regularFuncMap.keySet().iterator();
        while (iter.hasNext()) {
            functionNames.add((String)iter.next());
        }
        iter = regularFuncMap.keySet().iterator();
        while (iter.hasNext()) {
            funcName = (String)iter.next();
            regularFuncMap.put(((String)((Object)funcName)).toUpperCase(), regularFuncMap.get(funcName));
        }
        valueFuncMap.put("currentDate", 43);
        valueFuncMap.put("current_date", 43);
        valueFuncMap.put("getCurrentDate", 43);
        valueFuncMap.put("currentTime", 44);
        valueFuncMap.put("current_time", 44);
        valueFuncMap.put("getCurrentTime", 44);
        valueFuncMap.put("currentTimestamp", 50);
        valueFuncMap.put("current_timestamp", 50);
        valueFuncMap.put("getCurrentTimestamp", 50);
        valueFuncMap.put("localtime", 51);
        valueFuncMap.put("getLocalTime", 51);
        valueFuncMap.put("localtimestamp", 52);
        valueFuncMap.put("getLocalTimestamp", 52);
        valueFuncMap.put("currentCatalog", 53);
        valueFuncMap.put("current_catalog", 53);
        valueFuncMap.put("getCurrentCatalog", 53);
        valueFuncMap.put("currentRole", 56);
        valueFuncMap.put("current_role", 56);
        valueFuncMap.put("getCurrentRole", 56);
        valueFuncMap.put("currentSchema", 57);
        valueFuncMap.put("current_schema", 57);
        valueFuncMap.put("getCurrentSchema", 57);
        valueFuncMap.put("currentUser", 59);
        valueFuncMap.put("current_user", 59);
        valueFuncMap.put("getCurrentUser", 59);
        valueFuncMap.put("sessionUser", 60);
        valueFuncMap.put("session_user", 60);
        valueFuncMap.put("getSessionUser", 60);
        valueFuncMap.put("systemUser", 61);
        valueFuncMap.put("system_user", 61);
        valueFuncMap.put("getSystemUser", 61);
        valueFuncMap.put("user", 62);
        valueFuncMap.put("value", 63);
        valueFuncMap.put("isType", 64);
        valueFuncMap.put("getDomainType", 65);
        valueFuncMap.put("getAssignedType", 66);
        valueFuncMap.put("getCurrentSessionId", 67);
        nonDeterministicFuncSet.addAll(valueFuncMap.values());
        iter = valueFuncMap.keySet().iterator();
        while (iter.hasNext()) {
            functionNames.add((String)iter.next());
        }
        iter = valueFuncMap.keySet().iterator();
        while (iter.hasNext()) {
            funcName = (String)iter.next();
            valueFuncMap.put(((String)((Object)funcName)).toUpperCase(), valueFuncMap.get(funcName));
        }
        funcName = functionNames;
        synchronized (funcName) {
            Collections.sort(functionNames);
        }
        try {
            functions.add("position", 1, Type.SQL_BIGINT).argument("value", Type.STRING, Type.SQL_CLOB, Type.SQL_BINARY).argument(130, "value", Type.STRING, Type.SQL_CLOB, Type.SQL_BINARY).optional(306, "unit", 355, 454).description("Search the value of the first argument for the first occurrence of the second argument.\nIf the search is successful, the position in the is returned as BIGINT, otherwise a 0 is returned.\nThis function has no equivalent camel-case syntax. It uses SQL Foundation predicate syntax.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
            functions.add("positionRegex", 4, Type.SQL_VARBINARY).alias("position_regex").notImplemented().description("Not implemented.");
            functions.add("extract", 5, Type.SQL_BIGINT).argument("part", 323, 173, 73, 127, 169, 250, 669, 763, 709, 670, 668, 763, 667, 700, 722, 283, 284).argument(115, "value", Type.SQL_DATE).description("It returns a field or element from the extract source parameter that is a DATETIME or its interval expression.\nThe return value type is BIGINT for most of the options and translates to equivalent Java type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
            functions.add("bitLength", 6, Type.SQL_BIGINT).alias("bit_length").argument("value", Type.STRING, Type.SQL_VARBINARY).description("Returns bits count.");
            functions.add("charLength", 7, Type.SQL_BIGINT).alias("char_length", "characterLength", "character_length").argument("value", Type.STRING, Type.SQL_VARBINARY).description("Returns chars count.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
            functions.add("octetLength", 8, Type.SQL_BIGINT).alias("octet_length").argument("value", Type.STRING, Type.SQL_VARBINARY).description("Returns octets count.");
            functions.add("cardinality", 9, Type.SQL_INTEGER).argument("array", Type.SQL_ARRAY_ALL_TYPES).description("Returns the element count for the given ARRAY argument.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
            functions.add("maxCardinality", 10, Type.SQL_INTEGER).alias("max_cardinality").argument("array", Type.SQL_ARRAY_ALL_TYPES).description("Returns the maximum allowed element count for the given ARRAY argument.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
            functions.add("trimArray", 11, Type.SQL_ARRAY_ALL_TYPES).alias("trim_array", "array_trim").argument("array", Type.SQL_ARRAY_ALL_TYPES).argument("count", Type.SQL_INTEGER).description("Returns a copy of an ARRAY with the specified number of elements removed from the end of the ARRAY.\nThe array value expression can be any expression that evaluates to an ARRAY.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
            functions.add("abs", 12, Type.SQL_INTEGER).argument("value", Type.SQL_INTEGER).description("Returns the absolute value of a NUMERIC argument as a value of the same type.\nUsers may also specify a function that returns the absolute value of a NUMERIC interval.\nIf the interval is negative, it is negated, otherwise the original value is returned.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
            functions.add("mod", 13, Type.SQL_INTEGER).argument("value", Type.SQL_INTEGER).argument("value", Type.SQL_INTEGER).description("Returns the remainder (modulus) of first argument divided by second argument.\nThe data type of the returned value is the same as the second argument.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
            functions.add("ln", 14, Type.SQL_DOUBLE).argument("value", Type.SQL_DOUBLE).description("Returns the natural logarithm of the argument, as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
            functions.add("exp", 15, Type.SQL_DOUBLE).argument("value", Type.SQL_DOUBLE).description("Returns the exponential value of the argument as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
            functions.add("power", 16, Type.SQL_DOUBLE).argument("value", Type.SQL_DOUBLE).argument("value", Type.SQL_DOUBLE).description("Returns the value of the first argument raised to the power of the second argument as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
            functions.add("sqrt", 17, Type.SQL_DOUBLE).argument("value", Type.SQL_DOUBLE).description("Returns the square root of the argument as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
            functions.add("floor", 20, Type.SQL_INTEGER).argument("value", Type.SQL_DOUBLE).description("Returns the largest integer that is less than or equal to the argument.nIf the argument is exact numeric (no decimals) then the result is an exact numeric with a scale of 0.\nIf the argument is approximate numeric, then the result is of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
            functions.add("ceiling", 21, Type.SQL_INTEGER).alias("ceil").argument("value", Type.SQL_DOUBLE).description("Returns the smallest integer greater than or equal to the argument.\nIf the argument is exact numeric then the result is exact numeric with a scale of 0.\nIf the argument is approximate numeric, then the result is of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
            functions.add("widthBucket", 22, Type.SQL_INTEGER).alias("width_bucket").argument("value", Type.SQL_INTEGER).argument("value", Type.SQL_INTEGER).argument("value", Type.SQL_INTEGER).argument("value", Type.SQL_INTEGER).notImplemented().description("Not implemented.");
            functions.add("substring", 23, Type.STRING).argument("value", Type.STRING, Type.FLOB, Type.SQL_CLOB, Type.SQL_BLOB, Type.SQL_BINARY).argument("offset", Type.SQL_INTEGER).optional("length", Type.SQL_INTEGER).description("Returns a CHAR string or VARBINARY depending on value type that consists of length characters/bytes from a supplied value starting at the offset position.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
            functions.add("subbinary", 40, Type.SQL_VARBINARY).argument("value", Type.FLOB, Type.SQL_BLOB, Type.SQL_BINARY).argument("offset", Type.SQL_INTEGER).optional("length", Type.SQL_INTEGER).description("Returns a VARBINARY that consists of length bytes from a supplied binary/flob/clob starting at the offset position.");
            functions.add("lower", 26, Type.STRING).argument("value", Type.STRING).description("Returns input string in lowercase.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
            functions.add("upper", 27, Type.STRING).argument("value", Type.STRING).description("Returns input string in uppercase.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
            functions.add("trim", 31, Type.STRING).argument("value", Type.SQL_CHAR, Type.SQL_BINARY).description("Returns a CHAR/BINARY string based on the argument with trailing and leading characters removed.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
            functions.add("overlay", 32, Type.STRING).argument("fistString", Type.STRING, Type.SQL_VARBINARY).argument(473, "secondString", Type.STRING, Type.SQL_VARBINARY).argument(115, "startPosition", Type.SQL_INTEGER).optional(112, "stringLength", Type.SQL_INTEGER).optional(306, 355, "usingCharacters", (Type[])null).description("The CHAR version of OVERLAY returns a CHAR string based on supplied string argument in which length characters have been removed from the start position and in their place, the whole secondary string is copied.\nThe BINARY version of OVERLAY returns a binary string formed in the same manner as the character version.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
            functions.add("currentDate", 43, Type.SQL_DATE).alias("current_date", "getCurrentDate").description("Returns current statement date.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
            functions.add("currentTime", 44, Type.SQL_TIME).alias("current_time", "getCurrentTime").description("Returns current statement time with timezone.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
            functions.add("currentTimestamp", 50, Type.SQL_TIMESTAMP).alias("current_timestamp", "getCurrentTimestamp").optional("timestampPrecision", Type.SQL_INTEGER).description("Returns current statement timestamp with timezone. Precision defines precision of fractional seconds, from 0 to 3.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
            functions.add("localtime", 51, Type.SQL_TIME).alias("getLocalTime").description("Returns local statement time without timezone.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
            functions.add("localtimestamp", 52, Type.SQL_TIMESTAMP).alias("getLocalTimestamp").optional("timestampPrecision", Type.SQL_INTEGER).description("Returns local statement timestamp without timezone. Precision defines precision of fractional seconds, from 0 to 3.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
            functions.add("currentCatalog", 53, SqlInvariants.SQL_IDENTIFIER).alias("current_catalog", "getCurrentCatalog").description("Returns the CURRENT_CATALOG of the runtime engine.");
            functions.add("currentRole", 56, SqlInvariants.SQL_IDENTIFIER).alias("current_role", "getCurrentRole").description("Returns the current role.");
            functions.add("currentSchema", 57, SqlInvariants.SQL_IDENTIFIER).alias("current_schema", "getCurrentSchema").description("Returns the current schema.");
            functions.add("currentUser", 59, SqlInvariants.SQL_IDENTIFIER).alias("current_user", "getCurrentUser").description("Returns the current user.");
            functions.add("getCurrentSessionId", 67, Type.LONG).description("Returns the current session ID.");
            functions.add("sessionUser", 60, SqlInvariants.SQL_IDENTIFIER).alias("session_user", "getSessionUser").description("Returns the session user.");
            functions.add("systemUser", 61, SqlInvariants.SQL_IDENTIFIER).alias("system_user", "getSystemUser").description("Returns the system user.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
            functions.add("user", 62, SqlInvariants.SQL_IDENTIFIER).description("Returns the session user.");
            functions.add("value", 63, SqlInvariants.SQL_IDENTIFIER).description("Returns the current value.");
            functions.add("isType", 64, Type.SQL_BOOLEAN).argument("object", Type.OTHER).argument("semanticTypeName", Type.STRING).description("Returns a TRUE if the specified OBJECT value or expression evaluates to an OBJECT that has been registered as a valid Semantic Type with the engine Runtime.\nThis function may be used in combination with DOMAIN type declarations to enforce type validation.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
            functions.add("getDomainType", 65, Type.STRING).argument("object", Type.SQL_ALL_TYPES).description("Shows the Domain Type name of an element (or tuple) as interpreted by the SQL Standard.\nTo get assigned type name of element value use function getAssignedType.\nDomain type and assigned type can be different if 'dtspace.typesafe' property is set to false or domain type is object.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
            functions.add("getAssignedType", 66, Type.STRING).argument("object", Type.SQL_ALL_TYPES).description("Returns a type name of assigned value to element.\nTo get Domain Type of element used during declaration use function getDomainType.\nDomain type and assigned type can be different if 'dtspace.typesafe' property is set to false or domain type is object.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
            functions.compile();
            FunctionSQL.checkAllFunctionsMetaDataInitialized(functions, functionNames);
            for (String name : functionNames) {
                SQLFunctionsMetaData.SQLFunctionMetaData metadata;
                if (name.equalsIgnoreCase("trim") || (metadata = functions.lookupFunction(name)) == null || !metadata.isImplemented()) continue;
                FunctionSQL function = FunctionSQL.newSQLFunction(name, null);
                try {
                    FunctionSQL.compareFunctionsSignatures(metadata, function, function.parseList);
                }
                catch (Exception exception) {
                    if (function.parseListAlt == null) throw exception;
                    FunctionSQL.compareFunctionsSignatures(metadata, function, function.parseListAlt);
                    continue;
                    return;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to initialize SQL Functions metadata. Cause: " + exception.getMessage());
            Trace.logException(FunctionSQL.class, exception, true);
            Trace.logError(FunctionSQL.class, "Failed to initialize SQL Functions metadata. Cause: " + exception.getMessage());
            throw new RuntimeException(exception);
        }
    }
}

