/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.procedure;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.future.FutureFunctionManager;
import com.streamscape.ds.info.HelpRegistry;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.IntValueHashMap;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.lib.store.BitMap;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.parser.Tokens;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionArithmetic;
import com.streamscape.ds.parser.expression.ExpressionArrayUnnest;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.parser.expression.SelectForNearestExpression;
import com.streamscape.ds.parser.expression.SelectForSimilarityExpression;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.persist.Crypto;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.ds.persist.FlobManager;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.collection.fspace.directory.DirectoryTableCollection;
import com.streamscape.ds.schema.procedure.FunctionSQL;
import com.streamscape.ds.schema.procedure.FunctionSQLInvoked;
import com.streamscape.ds.schema.procedure.LazyLinkFileFunctionExpression;
import com.streamscape.ds.schema.procedure.LazyReadFileFunctionExpression;
import com.streamscape.ds.schema.procedure.LazyToFlobFunctionExpression;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.procedure.SQLFunctionsMetaData;
import com.streamscape.ds.schema.procedure.phonetic.ComparatorFactory;
import com.streamscape.ds.schema.procedure.phonetic.QGram;
import com.streamscape.ds.schema.procedure.phonetic.WeightedLevenshtein;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.stable.table.DataFrame;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.FlobInfo;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.LobData;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.ds.utils.DomainRangeUtils;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.html.HTMLDocument;
import com.streamscape.lib.utils.html.HTMLType;
import com.streamscape.lib.utils.parser.FileParserUtil;
import com.streamscape.lib.utils.parser.ParseProcessor;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.omf.java.Utils;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonCustomization;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.omf.xml.xstream.io.xml.StaxDriver;
import com.streamscape.omf.xsd.XmlToMapDeserializer;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sdrpath.ReferencePathException;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.network.http.server.authentication.jwt.JWT;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTPayload;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithmType;
import com.streamscape.sef.network.http.server.servlet.AbstractRestResponse;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.lang.parameter.TimeUnitParameter;
import com.streamscape.tools.lexer.BufferUtils;
import com.streamscape.tools.lexer.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE", "LEVENSHTEIN", "ENTITY_NAME", "QGRAM", "METAPHONE", "JARO_WINKLER", "WEIGHTED_LEVENSHTEIN"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ASCII = 73;
    private static final int FUNC_ASIN = 74;
    private static final int FUNC_ATAN = 75;
    private static final int FUNC_ATAN2 = 76;
    private static final int FUNC_BITAND = 77;
    private static final int FUNC_BITANDNOT = 78;
    private static final int FUNC_BITNOT = 79;
    private static final int FUNC_BITOR = 80;
    private static final int FUNC_BITXOR = 81;
    private static final int FUNC_CHAR = 82;
    private static final int FUNC_CONCAT = 83;
    private static final int FUNC_COS = 84;
    private static final int FUNC_COT = 85;
    private static final int FUNC_CRYPT_KEY = 86;
    private static final int FUNC_DATASTORE = 87;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 88;
    private static final int FUNC_DATABASE_NAME = 89;
    private static final int FUNC_DATASPACE_TIMEZONE = 90;
    private static final int FUNC_DATABASE_VERSION = 91;
    private static final int FUNC_DATEADD = 92;
    private static final int FUNC_DATEDIFF = 93;
    private static final int FUNC_DAYS = 94;
    private static final int FUNC_DEGREES = 95;
    private static final int FUNC_DIAGNOSTICS = 96;
    private static final int FUNC_DIFFERENCE = 97;
    private static final int FUNC_HEXTORAW = 98;
    private static final int FUNC_IDENTITY = 99;
    private static final int FUNC_ISAUTOCOMMIT = 100;
    private static final int FUNC_ISOLATION_LEVEL = 101;
    private static final int FUNC_ISREADONLYDATABASE = 102;
    private static final int FUNC_ISREADONLYDATABASEFILES = 103;
    private static final int FUNC_ISREADONLYSESSION = 104;
    private static final int FUNC_LEFT = 105;
    public static final int FUNC_READ_FILE = 106;
    private static final int FUNC_LOB_ID = 107;
    private static final int FUNC_LOCATE = 108;
    private static final int FUNC_LOG10 = 109;
    private static final int FUNC_LPAD = 110;
    private static final int FUNC_LTRIM = 111;
    private static final int FUNC_PI = 112;
    private static final int FUNC_POSITION_ARRAY = 113;
    private static final int FUNC_RADIANS = 114;
    private static final int FUNC_RAND = 115;
    private static final int FUNC_RAWTOHEX = 116;
    private static final int FUNC_REGEXP_MATCHES = 117;
    private static final int FUNC_REGEXP_SUBSTRING = 118;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 119;
    private static final int FUNC_REPEAT = 120;
    private static final int FUNC_REPLACE = 121;
    private static final int FUNC_REVERSE = 122;
    private static final int FUNC_RIGHT = 123;
    private static final int FUNC_ROUND = 124;
    private static final int FUNC_ROUNDMAGIC = 125;
    private static final int FUNC_RPAD = 126;
    private static final int FUNC_RTRIM = 127;
    private static final int FUNC_SECONDS_MIDNIGHT = 128;
    private static final int FUNC_SEQUENCE_ARRAY = 129;
    private static final int FUNC_SESSION_ID = 130;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 131;
    private static final int FUNC_SESSION_TIMEZONE = 132;
    private static final int FUNC_SIGN = 133;
    private static final int FUNC_SIN = 134;
    private static final int FUNC_SOUNDEX = 135;
    private static final int FUNC_SORT_ARRAY = 136;
    private static final int FUNC_SPACE = 137;
    private static final int FUNC_SUBSTR = 138;
    private static final int FUNC_SYSDATE = 139;
    private static final int FUNC_TAN = 140;
    private static final int FUNC_TIMESTAMP = 141;
    private static final int FUNC_TIMESTAMPADD = 142;
    private static final int FUNC_TIMESTAMPDIFF = 143;
    private static final int FUNC_TIMEZONE = 144;
    private static final int FUNC_TO_CHAR = 145;
    private static final int FUNC_TO_DATE = 146;
    private static final int FUNC_TO_NUMBER = 147;
    private static final int FUNC_TO_TIMESTAMP = 148;
    private static final int FUNC_TRANSACTION_CONTROL = 149;
    private static final int FUNC_TRANSACTION_ID = 150;
    private static final int FUNC_TRANSACTION_SIZE = 151;
    private static final int FUNC_TRUNC = 152;
    private static final int FUNC_TRUNCATE = 153;
    private static final int FUNC_UUID = 154;
    private static final int FUNC_UNIX_TIMESTAMP = 155;
    private static final int FUNC_SPATH = 156;
    private static final int FUNC_TOKENIZE = 157;
    private static final int FUNC_WRITE_FILE = 158;
    public static final int FUNC_TO_XML = 159;
    public static final int FUNC_TO_JSON = 160;
    public static final int FUNC_FROM_XML = 161;
    public static final int FUNC_FROM_JSON = 162;
    private static final int FUNC_LEVENSHTEIN = 163;
    private static final int FUNC_ENTITY_NAME = 164;
    private static final int FUNC_QGRAM = 165;
    private static final int FUNC_METAPHONE = 166;
    private static final int FUNC_JARO_WINKLER = 167;
    private static final int FUNC_WEIGHTED_LEVENSHTEIN = 168;
    private static final int FUNC_CREATE_FILE = 169;
    private static final int FUNC_APPEND_FILE = 170;
    private static final int FUNC_GET_FILE = 171;
    private static final int FUNC_DELETE_FILE = 172;
    protected static final int FUNC_TRIGGER_UNIT_CALL = 173;
    private static final int FUNC_TO_BINARY = 174;
    private static final int FUNC_FROM_BINARY = 175;
    private static final int FUNC_TO_STRING = 176;
    private static final int FUNC_TO_DECIMAL = 177;
    private static final int FUNC_GUID = 178;
    private static final int FUNC_TO_CURRENCY = 179;
    private static final int FUNC_GET_CURRENT_DATETIME = 180;
    private static final int FUNC_FUTURE = 181;
    public static final int FUNC_LINK_FILE = 182;
    public static final int FUNC_TO_FLOB = 183;
    private static final int FUNC_TO_HTML = 184;
    private static final int FUNC_TO_URL = 185;
    private static final int FUNC_TO_DATA_FRAME = 186;
    private static final int FUNC_DATASPACE = 200;
    private static final int FUNC_ARRAY_POSITION = 201;
    private static final int FUNC_ARRAY_POSITIONS = 202;
    private static final int FUNC_ARRAY_SORT = 203;
    private static final int FUNC_ARRAY_NDIMS = 204;
    private static final int FUNC_ARRAY_DIMS = 205;
    private static final int FUNC_ARRAY_LENGTH = 206;
    private static final int FUNC_ARRAY_LOWER = 207;
    private static final int FUNC_ARRAY_UPPER = 208;
    private static final int FUNC_ARRAY_APPEND = 209;
    private static final int FUNC_ARRAY_PREPEND = 210;
    private static final int FUNC_ARRAY_CAT = 211;
    private static final int FUNC_ARRAY_REMOVE = 212;
    private static final int FUNC_ARRAY_REPLACE = 213;
    private static final int FUNC_ARRAY_TO_STRING = 214;
    private static final int FUNC_BASE64_DECODE = 215;
    private static final int FUNC_TO_TIME = 216;
    private static final int FUNC_TO_FLOB_INFO = 217;
    private static final int FUNC_TO_DROPBOX_URL = 218;
    private static final int FUNC_FIND_NEAREST = 219;
    private static final int FUNC_CALCULATE_SIMILARITY = 220;
    private static final int FUNC_HTML_TO_JSON = 221;
    private static final int FUNC_HTML_TO_DOCUMENT = 222;
    private static final int FUNC_HTML_FRAGMENT_TO_DOCUMENT = 223;
    private static final int FUNC_HTML_SELECT_FIRST = 224;
    private static final int FUNC_HTML_SELECT = 225;
    private static final int FUNC_HTML_TABLE_TO_ROW_SET = 226;
    private static final int FUNC_BASE64_ENCODE = 227;
    private static final int FUNC_EXTRACT_TEXT = 228;
    private static final int FUNC_RPATH = 229;
    private static final int FUNC_EXTRACT_TEXT_AS_JSON = 230;
    public static final int FUNC_READ_LINES = 231;
    private static final int FUNC_HAS_SPATH = 232;
    private static final int FUNC_HAS_RPATH = 233;
    private static final int FUNC_SLEEP = 234;
    private static final int FUNC_IN_DOMAIN = 235;
    private static final int FUNC_IN_RANGE = 236;
    private static final int FUNC_VALIDATE_FLOB = 237;
    private static final int FUNC_INVALIDATE_FLOB = 238;
    private static final int FUNC_IS_FLOB_VALID = 239;
    private static final int FUNC_NEXT_DAY = 240;
    private static final int FUNC_WEEK_DAY = 241;
    private SpathObjectFunction spathObjectFunction = null;
    static IntValueHashMap customRegularFuncMap = new IntValueHashMap();
    static IntValueHashMap customValueFuncMap = new IntValueHashMap();
    static SQLFunctionsMetaData customFunctions = new SQLFunctionsMetaData();
    private static XSerializer xSerializer = null;
    private static XSerializer xSerializerPrettyPrint = null;
    private static JSerializer jSerializer = null;
    private int extractSpec;
    private String matchPattern;
    private Pattern pattern;
    private ReferencePathManager sdrManager = null;
    private TypeAnalyzer typeAnalyzer = null;

    private static void addSystemEmbeddedFunctions(Collection<String> functions) {
        functions.add("eval");
        functions.add("coalesce");
        functions.add("convert");
        functions.add("decode");
        functions.add("greatest");
        functions.add("ifnull");
        functions.add("isnull");
        functions.add("least");
        functions.add("nullif");
        functions.add("nvl");
        functions.add("nvl2");
    }

    public static SQLFunctionsMetaData.SQLFunctionMetaData getFunctionMetaData(String functionName) {
        return customFunctions.lookupFunction(functionName);
    }

    public static FunctionSQL newCustomFunction(String token, int tokenType) {
        int id = customRegularFuncMap.get((Object)token, -1);
        if (id == -1) {
            id = customValueFuncMap.get((Object)token, -1);
        }
        if (id == -1) {
            return null;
        }
        if (tokenType == 847 && (tokenType = Tokens.getKeywordID(token.toUpperCase(), tokenType)) == 847) {
            tokenType = Tokens.getNonKeywordID(token.toUpperCase(), tokenType);
        }
        switch (tokenType) {
            case 431: 
            case 650: 
            case 690: 
            case 695: 
            case 706: 
            case 759: 
            case 961: {
                return new FunctionSQL(id);
            }
            case 659: 
            case 660: 
            case 705: 
            case 733: 
            case 734: 
            case 743: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = optionalNoParamList;
                return function;
            }
            case 732: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = tripleParamList;
                return function;
            }
        }
        FunctionCustom function = new FunctionCustom(id);
        if (id == 31) {
            switch (tokenType) {
                case 698: {
                    function.extractSpec = 151;
                    break;
                }
                case 720: {
                    function.extractSpec = 286;
                }
            }
        }
        if (id == 5) {
            switch (tokenType) {
                case 671: {
                    function.extractSpec = 667;
                    break;
                }
                case 701: {
                    function.extractSpec = 700;
                    break;
                }
                case 672: {
                    function.extractSpec = 668;
                    break;
                }
                case 673: {
                    function.extractSpec = 669;
                    break;
                }
                case 674: {
                    function.extractSpec = 670;
                    break;
                }
                case 762: {
                    function.extractSpec = 763;
                    break;
                }
                default: {
                    function.extractSpec = "year".equalsIgnoreCase(token) || "getYear".equalsIgnoreCase(token) ? 323 : ("month".equalsIgnoreCase(token) || "getMonth".equalsIgnoreCase(token) ? 173 : ("day".equalsIgnoreCase(token) || "getDay".equalsIgnoreCase(token) ? 73 : ("hour".equalsIgnoreCase(token) || "getHour".equalsIgnoreCase(token) ? 127 : ("minute".equalsIgnoreCase(token) || "getMinute".equalsIgnoreCase(token) ? 169 : ("second".equalsIgnoreCase(token) || "second".equalsIgnoreCase(token) ? 250 : ("dayName".equalsIgnoreCase(token) || "getDayName".equalsIgnoreCase(token) ? 671 : ("monthName".equalsIgnoreCase(token) || "getMonthName".equalsIgnoreCase(token) ? 701 : ("dayOfMonth".equalsIgnoreCase(token) || "getDayOfMonth".equalsIgnoreCase(token) ? 668 : ("dayOfWeek".equalsIgnoreCase(token) || "getDayOfWeek".equalsIgnoreCase(token) ? 669 : ("dayOfYear".equalsIgnoreCase(token) || "getDayOfYear".equalsIgnoreCase(token) ? 670 : ("quarter".equalsIgnoreCase(token) || "getQuarter".equalsIgnoreCase(token) ? 709 : ("week".equalsIgnoreCase(token) || "getWeek".equalsIgnoreCase(token) ? 762 : ("secondsSinceMidnight".equalsIgnoreCase(token) || "getSecondsSinceMidnight".equalsIgnoreCase(token) ? 722 : tokenType)))))))))))));
                }
            }
        }
        if (id == 156) {
            if (token.equals("getString")) {
                function.spathObjectFunction = SpathObjectFunction.getString;
                function.dataType = Type.SQL_VARCHAR;
            } else if (token.equals("getBoolean")) {
                function.spathObjectFunction = SpathObjectFunction.getBoolean;
                function.dataType = Type.SQL_BOOLEAN;
            } else if (token.equals("getInteger")) {
                function.spathObjectFunction = SpathObjectFunction.getInteger;
                function.dataType = Type.SQL_INTEGER;
            } else if (token.equals("getLong")) {
                function.spathObjectFunction = SpathObjectFunction.getLong;
                function.dataType = Type.LONG;
            } else if (token.equals("getDecimal")) {
                function.spathObjectFunction = SpathObjectFunction.getDecimal;
                function.dataType = Type.SQL_BIGINT;
            } else if (token.equals("getBigDecimal")) {
                function.spathObjectFunction = SpathObjectFunction.getBigDecimal;
                function.dataType = Type.SQL_DECIMAL;
            } else if (token.equals("getDouble")) {
                function.spathObjectFunction = SpathObjectFunction.getDouble;
                function.dataType = Type.SQL_DOUBLE;
            } else if (token.equals("getDate")) {
                function.spathObjectFunction = SpathObjectFunction.getDate;
                function.dataType = Type.SQL_DATE;
            } else if (token.equals("getTime")) {
                function.spathObjectFunction = SpathObjectFunction.getTime;
                function.dataType = Type.SQL_TIME;
            } else if (token.equals("getTimestamp")) {
                function.spathObjectFunction = SpathObjectFunction.getTimestamp;
                function.dataType = Type.SQL_TIMESTAMP;
            } else if (token.equals("getObject")) {
                function.spathObjectFunction = SpathObjectFunction.getObject;
                function.dataType = Type.OTHER;
            }
        }
        if (function.name == null) {
            function.name = token;
        }
        return function;
    }

    protected FunctionCustom(int id) {
        this.funcType = id;
        this.isDeterministic = !nonDeterministicFuncSet.contains(id);
        switch (id) {
            case 72: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 112: 
            case 130: 
            case 131: 
            case 132: 
            case 144: 
            case 149: 
            case 150: 
            case 151: 
            case 200: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 82: 
            case 84: 
            case 85: 
            case 94: 
            case 95: 
            case 98: 
            case 107: 
            case 109: 
            case 114: 
            case 116: 
            case 122: 
            case 125: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 140: 
            case 147: 
            case 215: 
            case 222: 
            case 223: 
            case 227: 
            case 234: 
            case 241: {
                this.parseList = singleParamList;
                break;
            }
            case 228: 
            case 230: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 97: 
            case 105: 
            case 118: 
            case 119: 
            case 120: 
            case 123: 
            case 145: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 224: 
            case 225: 
            case 235: 
            case 236: {
                this.parseList = doubleParamList;
                break;
            }
            case 146: 
            case 148: 
            case 216: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 93: 
            case 117: 
            case 240: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 165: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 14, 774, 841, 3, 890, 891, 892, 774, 841, 3, 893, 894, 895, 774, 844, 772};
                break;
            }
            case 168: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 8, 774, 788, 774, 788, 774, 788, 774, 788, 772};
                break;
            }
            case 92: 
            case 129: {
                this.parseList = tripleParamList;
                break;
            }
            case 201: 
            case 202: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 209: 
            case 210: 
            case 211: 
            case 212: {
                this.parseList = new short[]{786, 788, 774, 788, 772};
                break;
            }
            case 213: {
                this.parseList = new short[]{786, 788, 774, 788, 774, 788, 772};
                break;
            }
            case 214: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 204: 
            case 205: {
                this.parseList = new short[]{786, 788, 772};
                break;
            }
            case 206: 
            case 207: 
            case 208: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 203: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 1: 
            case 110: 
            case 121: 
            case 126: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 154: 
            case 155: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 99: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 96: {
                this.parseList = new short[]{786, 495, 772};
                break;
            }
            case 113: {
                this.parseList = new short[]{786, 788, 130, 788, 842, 2, 115, 788, 772};
                break;
            }
            case 136: {
                this.parseList = new short[]{786, 788, 842, 4, 841, 2, 338, 389, 842, 5, 451, 841, 2, 401, 430, 772};
                break;
            }
            case 142: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{786, 841, 10, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 774, 788, 774, 788, 772};
                break;
            }
            case 143: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{786, 841, 10, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 774, 788, 774, 788, 772};
                break;
            }
            case 106: {
                this.parseList = new short[]{786, 788, 842, 4, 774, 788, 774, 788, 842, 2, 774, 788, 772};
                this.parseListAlt = new short[]{786, 788, 842, 4, 774, 788, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 231: {
                this.parseList = new short[]{786, 788, 774, 788, 774, 788, 774, 788, 772};
                break;
            }
            case 182: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 183: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 124: 
            case 152: 
            case 153: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 158: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 169: {
                this.parseList = new short[]{786, 788, 774, 788, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 170: {
                this.parseList = new short[]{786, 788, 774, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 171: {
                this.parseList = new short[]{786, 788, 774, 788, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 172: {
                this.parseList = new short[]{786, 788, 774, 788, 772};
                break;
            }
            case 159: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                FunctionCustom.checkXSerializer();
                break;
            }
            case 161: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                FunctionCustom.checkXSerializer();
                break;
            }
            case 162: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 160: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 217: {
                this.parseList = new short[]{786, 788, 772};
                break;
            }
            case 237: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 238: {
                this.parseList = new short[]{786, 788, 772};
                break;
            }
            case 239: {
                this.parseList = new short[]{786, 788, 772};
                break;
            }
            case 175: {
                this.parseList = new short[]{786, 788, 772};
                FunctionCustom.checkJSerializer();
                break;
            }
            case 174: {
                this.parseList = new short[]{786, 788, 772};
                FunctionCustom.checkJSerializer();
                break;
            }
            case 184: 
            case 185: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 218: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 221: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                FunctionCustom.checkJSerializer();
                break;
            }
            case 226: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 219: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 220: {
                this.parseList = new short[]{786, 788, 774, 788, 774, 788, 772};
                break;
            }
            case 186: {
                this.parseList = new short[]{786, 788, 772};
                break;
            }
            case 176: {
                this.parseList = new short[]{786, 788, 772};
                break;
            }
            case 177: {
                this.parseList = new short[]{786, 788, 774, 788, 774, 788, 772};
                break;
            }
            case 115: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 156: 
            case 229: 
            case 232: 
            case 233: {
                this.sdrManager = DataspaceStoreManager.getContext().getSDRManagerFactory().createManager();
                this.typeAnalyzer = DataspaceStoreManager.getContext().getTypeAnalyzerFactory().createTypeAnalyzer();
                this.typeAnalyzer.setClassLoader(DataspaceStoreManager.getContext().getSystemClassLoaderChain());
                this.parseList = doubleParamList;
                break;
            }
            case 157: {
                this.parseList = doubleParamList;
                break;
            }
            case 181: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 178: 
            case 180: {
                this.parseList = emptyParamList;
                break;
            }
            case 179: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 173: {
                this.parseList = emptyParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom id: " + id);
            }
        }
    }

    @Override
    public void setArguments(Expression[] nodes) {
        switch (this.funcType) {
            case 1: {
                Expression[] newNodes = new Expression[4];
                newNodes[0] = nodes[0];
                newNodes[1] = nodes[1];
                newNodes[3] = nodes[2];
                nodes = newNodes;
                break;
            }
            case 32: {
                Expression start = nodes[1];
                Expression length = nodes[2];
                nodes[1] = nodes[3];
                nodes[2] = start;
                nodes[3] = length;
                break;
            }
            case 5: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), nodes[0]};
                nodes = newNodes;
                break;
            }
            case 31: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), nodes[0]};
                nodes = newNodes;
            }
        }
        super.setArguments(nodes);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 83: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    @Override
    public Object getValue(Session session) {
        switch (this.funcType) {
            case 181: {
                FutureFunctionManager manager = session.dataspaceStore.futureFunctionManager;
                return manager.scheduleFunction(session, this.nodes[0], this.nodes[1], this.nodes.length > 2 ? this.nodes[2] : null);
            }
        }
        return super.getValue(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Object getValue(Session session, Object[] data) {
        switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, data);
            }
            case 87: {
                return session.getDataspaceStore().getPath();
            }
            case 200: {
                return session.getCurrentDataspaceName().getNameString();
            }
            case 89: {
                return session.getDataspaceStore().getUniqueName();
            }
            case 100: {
                if (session.isAutoCommit()) {
                    v0 = Boolean.TRUE;
                    return v0;
                }
                v0 = Boolean.FALSE;
                return v0;
            }
            case 104: {
                if (session.isReadOnlyDefault()) {
                    v1 = Boolean.TRUE;
                    return v1;
                }
                v1 = Boolean.FALSE;
                return v1;
            }
            case 102: {
                if (session.getDataspaceStore().isReadOnly()) {
                    v2 = Boolean.TRUE;
                    return v2;
                }
                v2 = Boolean.FALSE;
                return v2;
            }
            case 103: {
                if (session.getDataspaceStore().isFilesReadOnly()) {
                    v3 = Boolean.TRUE;
                    return v3;
                }
                v3 = Boolean.FALSE;
                return v3;
            }
            case 101: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 131: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 88: {
                return Session.getIsolationString(session.dataspaceStore.defaultIsolationLevel);
            }
            case 149: {
                switch (session.dataspaceStore.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 144: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 132: {
                return new IntervalSecondData(session.sessionTimeZone.getOffset(System.currentTimeMillis()), 0);
            }
            case 90: {
                sec = session.getZoneSeconds();
                return new IntervalSecondData(sec, 0);
            }
            case 91: {
                return DataspaceStoreProperties.THIS_FULL_VERSION;
            }
            case 130: {
                return session.getId();
            }
            case 72: {
                return session.actionTimestamp;
            }
            case 150: {
                return session.transactionTimestamp;
            }
            case 151: {
                return (long)session.actionIndex;
            }
            case 107: {
                lob = (LobData)data[0];
                if (lob != null) return lob.getId();
                return null;
            }
            case 99: {
                id = session.getLastIdentity();
                if (id instanceof Long == false) return ValuePool.getLong(id.longValue());
                return id;
            }
            case 96: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 129: {
                for (i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                list = new HsqlArrayList();
                current = data[0];
                type = this.nodes[0].getDataType();
                ascending = type.compare(session, data[1], data[0]) >= 0;
                while (true) {
                    compare = type.compare(session, current, data[1]);
                    if (ascending != false ? compare > 0 : compare < 0) break;
                    list.add(current);
                    newValue = type.add(current, data[2], this.nodes[2].getDataType());
                    compare = type.compare(session, current, newValue);
                    if (ascending != false ? compare >= 0 : compare <= 0) break;
                    current = newValue;
                }
                return list.toArray();
            }
            case 201: 
            case 202: {
                if (data[0] == null) {
                    return null;
                }
                array = (Object[])data[0];
                arrayType = (ArrayType)this.nodes[0].dataType;
                elementType = arrayType.collectionBaseType();
                start = 1;
                if (data[2] != null) {
                    start = ((Number)Type.SQL_INTEGER.convertToType(session, data[2], this.nodes[2].dataType)).intValue();
                }
                if (start <= 0) {
                    throw Error.error(3403);
                }
                --start;
                if (this.funcType == 201) {
                    i = start;
                    break;
                }
                result = new ArrayList<Integer>();
                i = start;
                while (i < array.length) {
                    if (elementType.compare(session, data[1], array[i]) == 0) {
                        result.add(ValuePool.getInt(i + 1));
                    }
                    ++i;
                }
                return result.toArray(new Object[result.size()]);
            }
            case 209: {
                if (data[0] == null) {
                    return null;
                }
                array = (Object[])data[0];
                arrayType = (ArrayType)this.nodes[0].dataType;
                elementType = arrayType.collectionBaseType();
                newElement = elementType.convertToType(session, data[1], this.nodes[1].dataType);
                newArray = Arrays.copyOf(array, array.length + 1);
                newArray[array.length] = newElement;
                return newArray;
            }
            case 210: {
                if (data[0] == null) {
                    return null;
                }
                array = (Object[])data[1];
                arrayType = (ArrayType)this.nodes[1].dataType;
                elementType = arrayType.collectionBaseType();
                newElement = elementType.convertToType(session, data[0], this.nodes[0].dataType);
                newArray = new Object[array.length + 1];
                System.arraycopy(array, 0, newArray, 1, array.length);
                newArray[0] = newElement;
                return newArray;
            }
            case 211: {
                if (data[0] == null && data[1] == null) {
                    return null;
                }
                array1 = (Object[])data[0];
                array2 = (Object[])data[1];
                if (array1 == null) {
                    return Arrays.copyOf(array2, array2.length);
                }
                if (array2 == null) {
                    return Arrays.copyOf(array1, array1.length);
                }
                arrayType1 = (ArrayType)this.nodes[1].dataType;
                elementType1 = arrayType1.collectionBaseType();
                arrayType2 = (ArrayType)this.nodes[1].dataType;
                elementType2 = arrayType2.collectionBaseType();
                newArray = Arrays.copyOf(array1, array1.length + array2.length);
                i = 0;
                while (i < array2.length) {
                    newArray[array1.length + i] = newElement = elementType1.convertToType(session, array2[i], elementType2);
                    ++i;
                }
                return newArray;
            }
            case 212: {
                if (data[0] == null) {
                    return null;
                }
                array = (Object[])data[0];
                arrayType = (ArrayType)this.nodes[0].dataType;
                elementType = arrayType.collectionBaseType();
                j = 0;
                newArray = Arrays.copyOf(array, array.length);
                i = 0;
                while (true) {
                    if (i >= array.length) {
                        if (j == newArray.length) return newArray;
                        return Arrays.copyOf(newArray, j);
                    }
                    if (elementType.compare(session, data[1], array[i]) != 0) {
                        newArray[j++] = array[i];
                    }
                    ++i;
                }
            }
            case 213: {
                if (data[0] == null) {
                    return null;
                }
                array = (Object[])data[0];
                arrayType = (ArrayType)this.nodes[0].dataType;
                elementType = arrayType.collectionBaseType();
                newElement = elementType.convertToType(session, data[2], this.nodes[2].dataType);
                newArray = Arrays.copyOf(array, array.length);
                i = 0;
                while (i < newArray.length) {
                    if (elementType.compare(session, data[1], newArray[i]) == 0) {
                        newArray[i] = newElement;
                    }
                    ++i;
                }
                return newArray;
            }
            case 214: {
                if (data[0] == null) {
                    return null;
                }
                array = (Object[])data[0];
                arrayType = (ArrayType)this.nodes[0].dataType;
                elementType = arrayType.collectionBaseType();
                delimiter = this.nodes[1].dataType.convertToString(data[1]);
                nullString = "NULL";
                if (this.nodes[2] != null && data[2] != null) {
                    nullString = this.nodes[2].dataType.convertToString(data[2]);
                }
                builder = new StringBuilder();
                i = 0;
                while (i < array.length) {
                    if (i > 0) {
                        builder.append(delimiter);
                    }
                    if (array[i] == null) {
                        builder.append(nullString);
                    } else {
                        builder.append(elementType.convertToString(array[i]));
                    }
                    ++i;
                }
                return builder.toString();
            }
            case 204: {
                return 1;
            }
            case 205: {
                if (data[0] != null) return "[1:" + ((Object[])data[0]).length + "]";
                return null;
            }
            case 206: 
            case 207: 
            case 208: {
                if (data[0] == null) {
                    return null;
                }
                dimension = 1;
                if (data[1] != null) {
                    dimension = ((Number)Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].dataType)).intValue();
                }
                length = ((Object[])data[0]).length;
                if (this.funcType == 206) {
                    return length;
                }
                if (this.funcType == 207) {
                    if (length == 0) {
                        v4 = 0;
                        return v4;
                    }
                    v4 = 1;
                    return v4;
                }
                if (this.funcType == 208) {
                    if (length == 0) {
                        v5 = 0;
                        return v5;
                    }
                    v5 = length;
                    return v5;
                }
            }
            case 203: {
                if (data[0] == null) {
                    return null;
                }
                dt = (ArrayType)this.dataType;
                exprSort = new SortAndSlice();
                exprSort.prepareSingleColumn(1);
                exprSort.sortDescending[0] = (Boolean)data[1] == false;
                exprSort.sortNullsLast[0] = (Boolean)data[2] == false;
                array = ArrayUtil.duplicateArray(data[0]);
                dt.sort(session, array, exprSort);
                return array;
            }
            case 142: {
                if (data[1] == null) return null;
                if (data[2] == null) {
                    return null;
                }
                data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                part = ((Number)this.nodes[0].valueData).intValue();
                units = ((Number)data[1]).longValue();
                source = (TimestampData)data[2];
                switch (part) {
                    case 831: {
                        seconds = units / 1000000000L;
                        nanos = (int)(units % 1000000000L);
                        t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 832: {
                        seconds = units / 1000L;
                        nanos = (int)(units % 1000L) * 1000000;
                        t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 833: {
                        t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        o = IntervalSecondData.newIntervalSeconds(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 834: {
                        t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        o = IntervalSecondData.newIntervalMinute(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 835: {
                        t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        o = IntervalSecondData.newIntervalHour(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 836: {
                        t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        o = IntervalSecondData.newIntervalDay(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 837: {
                        t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        o = IntervalSecondData.newIntervalDay(units * 7L, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 838: {
                        t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        o = IntervalMonthData.newIntervalMonth(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 839: {
                        t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        o = IntervalMonthData.newIntervalMonth(units * 3L, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 840: {
                        t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        o = IntervalMonthData.newIntervalMonth(units * 12L, t);
                        return this.dataType.add(source, o, t);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 143: {
                if (data[1] == null) return null;
                if (data[2] == null) {
                    return null;
                }
                part = ((Number)this.nodes[0].valueData).intValue();
                a = (TimestampData)data[2];
                b = (TimestampData)data[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    a = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, a, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    b = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, b, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (part) {
                    case 831: {
                        t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        interval = (IntervalSecondData)t.subtract(a, b, null);
                        return new Long(1000000000L * interval.getSeconds() + (long)interval.getNanos());
                    }
                    case 832: {
                        t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        interval = (IntervalSecondData)t.subtract(a, b, null);
                        return new Long(1000L * interval.getSeconds() + (long)(interval.getNanos() / 1000000));
                    }
                    case 833: {
                        t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 834: {
                        t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 835: {
                        t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 836: {
                        t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 837: {
                        t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)) / 7L);
                    }
                    case 838: {
                        t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 839: {
                        t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)) / 3L);
                    }
                    case 840: {
                        t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 94: {
                if (data[0] == null) {
                    return null;
                }
                diff = (IntervalSecondData)Type.SQL_INTERVAL_DAY_MAX_PRECISION.subtract(data[0], DateTimeType.epochTimestamp, Type.SQL_DATE);
                return ValuePool.getInt((int)(diff.getSeconds() / 86400L + 1L));
            }
            case 124: 
            case 152: {
                interval = 103;
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    type = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (data[1] == null) {
                            return null;
                        }
                        interval = DataspaceDateTime.toStandardIntervalPart((String)data[1]);
                    }
                    if (interval < 0) {
                        throw Error.error(5566, (String)data[1]);
                    }
                    if (this.funcType == 124) {
                        v6 = type.round(data[0], interval);
                        return v6;
                    }
                    v6 = type.truncate(data[0], interval);
                    return v6;
                }
            }
            case 153: {
                offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                    offset = ((Number)data[1]).intValue();
                }
                if (this.funcType == 124) {
                    v7 = ((NumberType)this.dataType).round(data[0], offset);
                    return v7;
                }
                v7 = ((NumberType)this.dataType).truncate(data[0], offset);
                return v7;
            }
            case 145: {
                if (data[0] == null) return null;
                if (data[1] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    format = session.getSimpleDateFormatGMT();
                    date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, data[0]);
                    return DataspaceDateTime.toFormattedDate(date, (String)data[1], format);
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    decimalFormat = new DecimalFormat((String)data[1], new DecimalFormatSymbols(Locale.ENGLISH));
                    return decimalFormat.format(data[0]);
                }
            }
            case 147: {
                if (data[0] == null) {
                    return null;
                }
                try {
                    if (data[0] instanceof Number) {
                        return data[0];
                    }
                    dataValue = data[0] instanceof String != false ? (String)data[0] : String.valueOf(data[0]);
                    return new DecimalFormat("", new DecimalFormatSymbols(Locale.ENGLISH)).parse(dataValue);
                }
                catch (ParseException e) {
                    throw new DataspaceException(e);
                }
            }
            case 146: 
            case 148: 
            case 216: {
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
                }
                if (OtherTypeWrapper.unwrap(data[0]) instanceof Date) {
                    return this.dataType.convertToType(session, OtherTypeWrapper.unwrap(data[0]), this.nodes[0].dataType);
                }
                if (this.funcType == 148 && this.nodes[0].dataType.isNumberType()) {
                    millis = 0L;
                    if (data[0] instanceof BigDecimal) {
                        bd = (BigDecimal)data[0];
                        if (bd.precision() < 13) throw new DataspaceException("Invalid milliseconds format. Should be 13-16 digits.");
                        if (bd.precision() > 16) {
                            throw new DataspaceException("Invalid milliseconds format. Should be 13-16 digits.");
                        }
                        if (bd.scale() > 0) {
                            millis = bd.movePointRight(bd.scale()).longValue();
                        }
                    } else {
                        millis = ((Number)data[0]).longValue();
                    }
                    if (millis < 1000000000000L) throw new DataspaceException("Invalid milliseconds format. Should be 13-16 digits.");
                    if (millis >= 10000000000000000L) {
                        throw new DataspaceException("Invalid milliseconds format. Should be 13-16 digits.");
                    }
                    if (millis < 10000000000000L) {
                        millis *= 1000L;
                    } else if (millis < 100000000000000L) {
                        millis *= 100L;
                    } else if (millis < 1000000000000000L) {
                        millis *= 10L;
                    }
                    nanos = (int)(millis % 1000000L) * 1000;
                    millis = Math.floorDiv(millis, 1000000) * 1000L;
                    cal = session.getCalendar();
                    millis = DataspaceDateTime.convertMillisFromCalendar(cal, millis);
                    return new TimestampData(millis, nanos);
                }
                if (data[1] == null) {
                    throw new DataspaceException("Format is not specified.");
                }
                formatGMT = session.getSimpleDateFormatGMT();
                date = DataspaceDateTime.toDate((String)data[0], (String)data[1], formatGMT);
                millis = date.getTime();
                nanos = 0;
                if (this.funcType == 216) {
                    millis = DataspaceDateTime.convertToNormalisedTime(millis, formatGMT.getCalendar());
                    return new TimeData((int)millis / 1000, 0);
                }
                if (this.funcType == 146) {
                    millis = DataspaceDateTime.convertToNormalisedDate(millis, formatGMT.getCalendar());
                    return new TimestampData(millis, nanos);
                }
                nanos = (int)(millis % 1000L) * 1000000;
                return new TimestampData(millis, nanos);
            }
            case 112: {
                return new Double(3.141592653589793);
            }
            case 115: {
                if (this.nodes[0] == null) {
                    return new Double(session.random());
                }
                data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                seed = ((Number)data[0]).longValue();
                return new Double(session.random(seed));
            }
            case 154: {
                if (this.nodes[0] == null) {
                    uuid = UUID.randomUUID();
                    hi = uuid.getMostSignificantBits();
                    lo = uuid.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(hi, lo), false);
                }
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isBinaryType() == false) return StringConverter.toStringUUID(((BinaryData)data[0]).getBytes());
                return new BinaryData(StringConverter.toBinaryUUID((String)data[0]), false);
            }
            case 155: {
                if (this.nodes[0] == null) {
                    ts = session.getCurrentTimestamp(false);
                    return ts.getMilliseconds();
                }
                if (data[0] != null) return ((TimestampData)data[0]).getMilliseconds();
                return null;
            }
            case 71: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.acos(d));
            }
            case 74: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.asin(d));
            }
            case 75: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.atan(d));
            }
            case 84: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.cos(d));
            }
            case 85: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                c = 1.0 / Math.tan(d);
                return new Double(c);
            }
            case 95: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.toDegrees(d));
            }
            case 134: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.sin(d));
            }
            case 140: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.tan(d));
            }
            case 109: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.log10(d));
            }
            case 114: {
                if (data[0] == null) {
                    return null;
                }
                d = NumberType.toDouble(data[0]);
                return new Double(Math.toRadians(d));
            }
            case 133: {
                if (data[0] == null) {
                    return null;
                }
                val = ((NumberType)this.nodes[0].dataType).compareToZero(data[0]);
                return ValuePool.getInt(val);
            }
            case 76: {
                if (data[0] == null) {
                    return null;
                }
                a = NumberType.toDouble(data[0]);
                b = NumberType.toDouble(data[1]);
                return new Double(Math.atan2(a, b));
            }
            case 73: {
                if (data[0] == null) {
                    return null;
                }
                arg = this.nodes[0].dataType.isLobType() != false ? ((ClobData)data[0]).getSubString(session, 0L, 1) : (String)data[0];
                if (arg.length() != 0) return ValuePool.getInt(arg.charAt(0));
                return null;
            }
            case 82: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                arg = ((Number)data[0]).intValue();
                if (Character.isValidCodePoint(arg) == false) throw Error.error(3472);
                if (Character.isValidCodePoint((char)arg) == false) throw Error.error(3472);
                return String.valueOf((char)arg);
            }
            case 125: {
                offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length <= 1) return ((NumberType)this.dataType).round(data[0], offset);
                if (data[1] == null) {
                    return null;
                }
                offset = ((Number)data[1]).intValue();
                return ((NumberType)this.dataType).round(data[0], offset);
            }
            case 135: {
                if (data[0] == null) {
                    return null;
                }
                s = (String)data[0];
                return new String(FunctionCustom.soundex(s), 0, 4);
            }
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                comparator = ComparatorFactory.createComparator(this.name);
                if (comparator == null) {
                    names = new StringBuilder();
                    lo = ComparatorFactory.getCompratorNames().iterator();
                    while (true) {
                        if (!lo.hasNext()) {
                            names.setLength(names.length() - 2);
                            throw new DataspaceException("Unknown comparator name '" + (String)data[2] + "'. Supportable comparator's names: " + String.valueOf(names));
                        }
                        name = lo.next();
                        names.append(name).append(", ");
                    }
                }
                if (data.length <= 2) return comparator.compare((String)data[0], (String)data[1]);
                if (data[2] == null) return comparator.compare((String)data[0], (String)data[1]);
                if (this.funcType == 165) {
                    qgram = (QGram)comparator;
                    qgram.setFormula(QGram.Formula.valueOf(Tokens.getQGramString(((Number)data[2]).intValue())));
                    qgram.setTokenizer(QGram.Tokenizer.valueOf(Tokens.getQGramString(((Number)data[3]).intValue())));
                    qgram.setQ(((Number)data[4]).intValue());
                    return comparator.compare((String)data[0], (String)data[1]);
                }
                if (this.funcType != 168) return comparator.compare((String)data[0], (String)data[1]);
                weightedLevenshtein = (WeightedLevenshtein)comparator;
                estimator = new WeightedLevenshtein.DefaultWeightEstimator();
                estimator.setDigitWeight(((Number)data[2]).doubleValue());
                estimator.setLetterWeight(((Number)data[3]).doubleValue());
                estimator.setPunctuationWeight(((Number)data[4]).doubleValue());
                estimator.setOtherWeight(((Number)data[5]).doubleValue());
                estimator.recompute();
                weightedLevenshtein.setEstimator(estimator);
                return comparator.compare((String)data[0], (String)data[1]);
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                for (i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    v = 0L;
                    b = 0L;
                    data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                    a = ((Number)data[0]).longValue();
                    if (this.funcType != 79) {
                        data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                        b = ((Number)data[1]).longValue();
                    }
                    switch (this.funcType) {
                        case 77: {
                            v = a & b;
                            break;
                        }
                        case 78: {
                            v = a & (b ^ -1L);
                            break;
                        }
                        case 79: {
                            v = a ^ -1L;
                            break;
                        }
                        case 80: {
                            v = a | b;
                            break;
                        }
                        case 81: {
                            v = a ^ b;
                            break;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: 
                        case 25: {
                            return BigDecimal.valueOf(v);
                        }
                        case 1117: {
                            return ValuePool.getLong(v);
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return ValuePool.getInt((int)v);
                        }
                    }
                    throw Error.error(5561);
                }
                a = ((BinaryData)data[0]).getBytes();
                b = null;
                if (this.funcType != 79) {
                    b = ((BinaryData)data[1]).getBytes();
                }
                switch (this.funcType) {
                    case 77: {
                        v = BitMap.and(a, b);
                        return new BinaryData(v, this.dataType.precision);
                    }
                    case 78: {
                        b = BitMap.not(b);
                        v = BitMap.and(a, b);
                        return new BinaryData(v, this.dataType.precision);
                    }
                    case 79: {
                        v = BitMap.not(a);
                        return new BinaryData(v, this.dataType.precision);
                    }
                    case 80: {
                        v = BitMap.or(a, b);
                        return new BinaryData(v, this.dataType.precision);
                    }
                    case 81: {
                        v = BitMap.xor(a, b);
                        return new BinaryData(v, this.dataType.precision);
                    }
                }
                throw Error.error(5561);
            }
            case 97: {
                for (i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                s1 = FunctionCustom.soundex((String)data[0]);
                s2 = FunctionCustom.soundex((String)data[1]);
                e = 0;
                if (s1[0] == s2[0]) {
                    ++e;
                }
                if (e == 4) {
                    return ValuePool.getInt(e);
                }
                js = 1;
                i = 1;
                while (true) {
                    if (i >= 4) {
                        e = 0;
                        return ValuePool.getInt(e);
                    }
                    for (j = js; j < 4; ++j) {
                        if (s1[j] != s2[i]) continue;
                        ++e;
                        ++i;
                        ++js;
                    }
                    ++i;
                }
            }
            case 98: {
                if (data[0] != null) return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
                return null;
            }
            case 116: {
                if (data[0] == null) {
                    return null;
                }
                binary = (BlobData)data[0];
                bytes = binary.getBytes(session, 0L, (int)binary.length(session));
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 120: {
                for (i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                string = (String)data[0];
                i = ((Number)data[1]).intValue();
                sb = new StringBuffer(string.length() * i);
                while (i-- > 0) {
                    sb.append(string);
                }
                return sb.toString();
            }
            case 121: {
                for (i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                string = (String)data[0];
                find = (String)data[1];
                replace = (String)data[2];
                sb = new StringBuffer();
                start = 0;
                if (find.length() == 0) {
                    return string;
                }
                while (true) {
                    if ((i = string.indexOf(find, start)) == -1) {
                        sb.append(string.substring(start));
                        return sb.toString();
                    }
                    sb.append(string.substring(start, i));
                    sb.append(replace);
                    start = i + find.length();
                }
            }
            case 105: 
            case 123: {
                for (i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                count = ((Number)data[1]).intValue();
                v8 = (CharacterType)this.dataType;
                v9 = data[0];
                v10 = count;
                if (this.funcType == 123) {
                    v11 = true;
                    return v8.substring(session, v9, 0L, v10, true, v11);
                }
                v11 = false;
                return v8.substring(session, v9, 0L, v10, true, v11);
            }
            case 137: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                count = ((Number)data[0]).intValue();
                array = new char[count];
                ArrayUtil.fillArray(array, 0, ' ');
                return String.valueOf(array);
            }
            case 122: {
                if (data[0] == null) {
                    return null;
                }
                sb = new StringBuffer((String)data[0]);
                sb = sb.reverse();
                return sb.toString();
            }
            case 117: {
                rg = (String)data[0];
                mp = (String)data[1];
                replacements = null;
                if (this.nodes.length > 2 && data[2] != null) {
                    replacements = (Object[])data[2];
                }
                if (replacements != null) {
                    for (i = 0; i < replacements.length; mp = mp.replace("{$" + (i + 1) + "}", String.valueOf(replacements[i])), ++i) {
                    }
                }
                currentPattern = Pattern.compile(mp);
                return currentPattern.matcher(rg).matches();
            }
            case 118: 
            case 119: {
                if (data[0] == null) {
                    return null;
                }
                if (data[1] == null) {
                    return null;
                }
                currentPattern = this.pattern;
                if (currentPattern == null) {
                    matchPattern = (String)data[1];
                    currentPattern = Pattern.compile(matchPattern);
                }
                matcher = currentPattern.matcher((String)data[0]);
                switch (this.funcType) {
                    case 118: {
                        match = matcher.find();
                        if (match == false) return null;
                        return matcher.group();
                    }
                    case 119: {
                        list = new HsqlArrayList();
                        while (matcher.find() != false) {
                            list.add(matcher.group());
                        }
                        return list.toArray();
                    }
                }
            }
            case 156: {
                try {
                    resultValue = this.sdrManager.getValueAtPath((String)data[1], SqlUtils.convertSqlToJava(session, data[0], this.nodes[0].getDataType()));
                    resultSqlType = resultValue != null ? Types.getParameterSQLType(session, resultValue.getClass()) : Type.SQL_ALL_TYPES;
                    if (resultSqlType != null && resultSqlType.typeCode != this.dataType.typeCode && this.dataType.typeCode != 1111 && this.dataType.typeCode != 1113) {
                        return this.dataType.convertToType(session, SqlUtils.convertJavaToSql(session, resultValue, resultSqlType), resultSqlType);
                    }
                    if (this.spathObjectFunction == null) return SqlUtils.convertJavaToSql(session, resultValue, this.dataType);
                    switch (this.spathObjectFunction.ordinal()) {
                        case 0: {
                            if (resultValue == null) return resultValue;
                            if (resultValue instanceof String != false) return resultValue;
                            throw new DataspaceException("Incompatible data type in getString() function.");
                        }
                        case 1: {
                            if (resultValue == null) return resultValue;
                            if (resultValue instanceof Boolean != false) return resultValue;
                            throw new DataspaceException("Incompatible data type in getBoolean() function.");
                        }
                        case 2: {
                            if (resultValue == null) return resultValue;
                            if (resultValue instanceof Integer != false) return resultValue;
                            throw new DataspaceException("Incompatible data type in getInteger() function.");
                        }
                        case 6: {
                            if (resultValue == null) return resultValue;
                            if (resultValue instanceof Long != false) return resultValue;
                            throw new DataspaceException("Incompatible data type in getLong() function.");
                        }
                        case 4: {
                            if (resultValue == null) return resultValue;
                            if (resultValue instanceof BigInteger != false) return resultValue;
                            throw new DataspaceException("Incompatible data type in getDecimal() function.");
                        }
                        case 3: {
                            if (resultValue == null) return resultValue;
                            if (resultValue instanceof Double != false) return resultValue;
                            throw new DataspaceException("Incompatible data type in getDouble() function.");
                        }
                        case 5: {
                            if (resultValue == null) return resultValue;
                            if (resultValue instanceof BigDecimal != false) return resultValue;
                            throw new DataspaceException("Incompatible data type in getBigDecimal() function.");
                        }
                        case 7: {
                            if (resultValue == null) return SqlUtils.convertJavaToSql(session, resultValue, this.dataType);
                            if (resultValue instanceof java.sql.Date != false) return SqlUtils.convertJavaToSql(session, resultValue, this.dataType);
                            throw new DataspaceException("Incompatible data type in getDate() function.");
                        }
                        case 8: {
                            if (resultValue == null) return SqlUtils.convertJavaToSql(session, resultValue, this.dataType);
                            if (resultValue instanceof Time != false) return SqlUtils.convertJavaToSql(session, resultValue, this.dataType);
                            throw new DataspaceException("Incompatible data type in getTime() function.");
                        }
                        case 9: {
                            if (resultValue == null) return SqlUtils.convertJavaToSql(session, resultValue, this.dataType);
                            if (resultValue instanceof Timestamp != false) return SqlUtils.convertJavaToSql(session, resultValue, this.dataType);
                            throw new DataspaceException("Incompatible data type in getTimestamp() function.");
                        }
                        case 10: {
                            if (resultValue == null) return resultValue;
                            return new OtherTypeWrapper(resultValue);
                        }
                    }
                    return resultValue;
                }
                catch (ReferencePathException error) {
                    throw new DataspaceException(error);
                }
            }
            case 229: {
                try {
                    o = SqlUtils.convertSqlToJava(session, data[0], this.nodes[0].getDataType());
                    return SDOUtils.findSDOElements(o, (String)data[1], "", this.sdrManager, this.typeAnalyzer);
                }
                catch (TypeAnalyzerException e) {
                    throw new DataspaceException(e);
                }
            }
            case 233: {
                try {
                    o = SqlUtils.convertSqlToJava(session, data[0], this.nodes[0].getDataType());
                    if (!SDOUtils.findSDOElements(o, (String)data[1], "", this.sdrManager, this.typeAnalyzer).isEmpty()) {
                        v12 = true;
                        return v12;
                    }
                    v12 = false;
                    return v12;
                }
                catch (TypeAnalyzerException e) {
                    throw new DataspaceException(e);
                }
            }
            case 232: {
                try {
                    this.sdrManager.getValueAtPath((String)data[1], SqlUtils.convertSqlToJava(session, data[0], this.nodes[0].getDataType()));
                    return true;
                }
                catch (ReferencePathException e) {
                    if (e.getErrorCode() != ReferencePathException.ERROR_CODE_FIELD_NOT_FOUND) throw new DataspaceException(e);
                    return false;
                }
            }
            case 157: {
                result = new ArrayList<String>();
                tokenizer = new StringTokenizer((String)data[0], (String)data[1]);
                while (tokenizer.hasMoreTokens() != false) {
                    result.add(tokenizer.nextToken());
                }
                return result.toArray();
            }
            case 178: {
                return UUID.randomUUID().toString();
            }
            case 180: {
                return session.getCurrentSqlTimestamp();
            }
            case 179: {
                if (data.length > 1 && data[1] instanceof String) {
                    formatter = NumberFormat.getCurrencyInstance(Locale.forLanguageTag((String)data[1]));
                    return formatter.format(data[0]);
                }
                formatter = NumberFormat.getCurrencyInstance();
                return formatter.format(data[0]);
            }
            case 86: {
                bytes = Crypto.getNewKey((String)data[0], (String)data[1]);
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 182: {
                fileName = (String)data[0];
                charset = null;
                isManaged = false;
                ignore = false;
                fileName = BufferUtils.unslashPath(fileName);
                if (this.nodes.length > 1 && this.nodes[1] != null && data[1] != null) {
                    charset = (String)data[1];
                }
                if (this.nodes.length > 2 && this.nodes[2] != null && data[2] != null) {
                    isManaged = (Boolean)data[2];
                }
                if (this.nodes.length > 3 && this.nodes[3] != null && data[3] != null) {
                    ignore = (Boolean)data[3];
                }
                if (!(this.dataType instanceof FlobType)) {
                    throw new DataspaceException("linkFile can be assigned to FLOB variable or column only.");
                }
                if (((FlobType)this.dataType).getAutotag() != null && ((FlobType)this.dataType).getAutotag().booleanValue()) {
                    throw new DataspaceException("linkFile can be assigned to not autotag FLOB variable or column only.");
                }
                if (this.dataType instanceof FlobType == false) return session.sessionData.linkFlob(fileName, charset, this.dataType, isManaged, ignore);
                if (((FlobType)this.dataType).isLazy() == false) return session.sessionData.linkFlob(fileName, charset, this.dataType, isManaged, ignore);
                return new LazyLinkFileFunctionExpression(this, fileName, charset, isManaged, ignore);
            }
            case 183: {
                fileName = (String)data[0];
                charset = null;
                fileName = BufferUtils.unslashPath(fileName);
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    charset = (String)data[2];
                }
                if (!(this.dataType instanceof FlobType)) {
                    throw new DataspaceException("toFlob can be assigned to FLOB variable or column only.");
                }
                if (data[1] instanceof LazyReadFileFunctionExpression) {
                    ((LazyReadFileFunctionExpression)data[1]).setNewFilename(fileName);
                    ((LazyReadFileFunctionExpression)data[1]).setNewCharset(charset);
                    if (this.dataType instanceof FlobType == false) return ((LazyReadFileFunctionExpression)data[1]).getValue(session, this.dataType);
                    if (((FlobType)this.dataType).isLazy() == false) return ((LazyReadFileFunctionExpression)data[1]).getValue(session, this.dataType);
                    return data[1];
                }
                if (data[1] instanceof LazyToFlobFunctionExpression) {
                    ((LazyToFlobFunctionExpression)data[1]).setFilename(fileName);
                    ((LazyToFlobFunctionExpression)data[1]).setCharset(charset);
                    if (this.dataType instanceof FlobType == false) return ((LazyToFlobFunctionExpression)data[1]).getValue(session, this.dataType);
                    if (((FlobType)this.dataType).isLazy() == false) return ((LazyToFlobFunctionExpression)data[1]).getValue(session, this.dataType);
                    return data[1];
                }
                if (this.dataType instanceof FlobType == false) return session.sessionData.toFlob(fileName, data[1], charset, this.dataType);
                if (((FlobType)this.dataType).isLazy() == false) return session.sessionData.toFlob(fileName, data[1], charset, this.dataType);
                return new LazyToFlobFunctionExpression(this, fileName, data[1], charset);
            }
            case 106: 
            case 231: {
                charset = null;
                if (data[0] instanceof FlobData) {
                    fileName = ((FlobData)data[0]).getFilename();
                    if (((FlobData)data[0]).getAutotag().booleanValue()) {
                        fileName = session.dataspaceStore.flobManager.tagFilename(fileName, ((FlobData)data[0]).getId());
                    }
                    fileName = session.dataspaceStore.flobManager.getFlobFileManager().getAbsoluteFilePath(((FlobData)data[0]).getLocation(), fileName).toString();
                    charset = ((FlobData)data[0]).getCharset();
                } else {
                    fileName = (String)data[0];
                    fileName = BufferUtils.unslashPath(fileName);
                }
                if (fileName == null) {
                    throw new DataspaceException("filename is null.");
                }
                offset = 0;
                length = -1;
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    offset = (Number)Type.SQL_DECIMAL.convertToType(session, data[1], this.nodes[1].getDataType());
                }
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    length = (Number)Type.SQL_DECIMAL.convertToType(session, data[2], this.nodes[2].getDataType());
                }
                if (this.nodes.length > 3 && this.nodes[3] != null && "binary".equalsIgnoreCase(charset = (String)data[3])) {
                    charset = null;
                    if (this.dataType == null || !this.dataType.isFlobType() && !this.dataType.isBinaryType()) {
                        this.dataType = Type.SQL_VARBINARY;
                    }
                }
                if (this.funcType != 231) ** GOTO lbl969
                if (charset == null) {
                    charset = "UTF-8";
                }
                inputStream = SessionData.createFileInputStream(session, fileName, data[0] instanceof FlobData, true, null);
                try {
                    offsets = FileUtils.getLinesOffset(inputStream, offset.intValue(), length.intValue() > 0 ? offset.intValue() + length.intValue() - 1 : length.intValue(), Charset.forName(charset));
                    offset = offsets[0];
                    if (offsets[1] != -1L) {
                        length = offsets[1] - offsets[0];
                    }
                    ** GOTO lbl973
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new DataspaceException(e);
            }
lbl969:
            // 1 sources

            if (offset == null) {
                throw new DataspaceException("offset is null.");
            }
            if (length == null) {
                throw new DataspaceException("length is null.");
            }
lbl973:
            // 3 sources

            lazy = new LazyReadFileFunctionExpression(this, fileName, charset, offset.longValue(), length.longValue(), data[0] instanceof FlobData);
            if (this.nodes.length > 4 && this.nodes[4] != null && data[4] != null) {
                try {
                    lazy.setSLFileSessionContext(SLFileSessionContext.valueOf(((String)data[4]).toUpperCase()));
                }
                catch (Exception exception) {
                    throw new DataspaceException("Invalid context '" + (String)data[4] + "' specified.");
                }
            }
            if (this.dataType instanceof FlobType == false) return lazy.getValue(session, this.dataType);
            if (((FlobType)this.dataType).isLazy() == false) return lazy.getValue(session, this.dataType);
            return lazy;
            case 158: {
                fileName = (String)data[1];
                fileName = BufferUtils.unslashPath(fileName);
                if (fileName == null) {
                    return null;
                }
                append = false;
                if (data.length > 2 && data[2] != null) {
                    append = (Boolean)data[2];
                }
                charset = null;
                if (data.length > 3) {
                    charset = (String)data[3];
                }
                session.sessionData.writeFile(fileName, data[0], append, charset);
                return true;
            }
            case 228: {
                source = data[0];
                mimeType = (String)data[1];
                forceGrammar = false;
                if (data.length > 2 && data[2] != null) {
                    forceGrammar = (Boolean)data[2];
                }
                noError = false;
                if (data.length > 3 && data[3] != null) {
                    noError = (Boolean)data[3];
                }
                config = null;
                if (data.length > 4 && data[4] != null) {
                    config = (Map)OtherTypeWrapper.unwrap(data[4]);
                }
                if ((source = OtherTypeWrapper.unwrap(source)) == null) {
                    return null;
                }
                try {
                    inputStream = FileParserUtil.retrieveStreamFromSource(session, source);
                    try {
                        stdoc = ParseProcessor.parseToDoc(session, inputStream, null, true, forceGrammar, config);
                        nanos = stdoc.getWholeText("\n");
                        return nanos;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (IOException exception) {
                    throw new DataspaceException("Failed to parse source data.", exception);
                }
                catch (Exception exception) {
                    if (noError == false) throw new DataspaceException("Failed to parse.", exception);
                    return null;
                }
            }
            case 230: {
                source = data[0];
                preserveStructure = false;
                if (data.length > 1 && data[1] != null) {
                    preserveStructure = (Boolean)data[1];
                }
                forceGrammar = false;
                if (data.length > 2 && data[2] != null) {
                    forceGrammar = (Boolean)data[2];
                }
                noError = false;
                if (data.length > 3 && data[3] != null) {
                    noError = (Boolean)data[3];
                }
                config = null;
                if (data.length > 4 && data[4] != null) {
                    config = (Map)OtherTypeWrapper.unwrap(data[4]);
                }
                if ((source = OtherTypeWrapper.unwrap(source)) == null) {
                    return null;
                }
                try {
                    inputStream = FileParserUtil.retrieveStreamFromSource(session, source);
                    try {
                        serializer = FunctionCustom.getJsonSerializer(JsonNotation.TOP_ELEMENT, "none", true, "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", null, null, false);
                        stdoc = ParseProcessor.parseToDoc(session, inputStream, null, preserveStructure, forceGrammar, config);
                        var13_370 = serializer.serialize(stdoc.asMap());
                        return var13_370;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (IOException exception) {
                    throw new DataspaceException("Failed to parse source data.", exception);
                }
                catch (Exception exception) {
                    if (noError == false) throw new DataspaceException("Failed to parse: " + exception.getMessage(), exception);
                    return null;
                }
            }
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                directoryName = (String)data[0];
                filename = (String)data[1];
                overwrite = false;
                replication = null;
                blocksize = null;
                localfile = null;
                buffersize = session.getTransferBufferSize();
                filename = BufferUtils.unslashPath((String)filename);
                if (directoryName == null) {
                    throw new DataspaceException("Directory table name is null.");
                }
                if (filename == null) {
                    throw new DataspaceException("Filename is null.");
                }
                schemaName = session.currentDataspace.name;
                dotPos = directoryName.indexOf(".");
                if (dotPos != -1) {
                    schemaName = directoryName.substring(0, dotPos);
                    directoryName = directoryName.substring(dotPos + 1);
                }
                if ((directoryObject = session.dataspaceStore.schemaManager.getSchemaObject(directoryName, schemaName, 4)) == null) throw new DataspaceException("Invalid directory table specified.");
                if (!(directoryObject instanceof DirectoryTableCollection)) {
                    throw new DataspaceException("Invalid directory table specified.");
                }
                directoryTable = (DirectoryTableCollection)directoryObject;
                fileSystem = directoryTable.getFileSystem(session);
                if (!directoryTable.getPath().endsWith("" + File.separatorChar) && !directoryTable.getPath().endsWith("/")) {
                    filename = File.separatorChar + (String)filename;
                }
                filename = directoryTable.getPath() + (String)filename;
                outputStream = null;
                inputStream = null;
                result = true;
                try {
                    switch (this.funcType) {
                        case 169: {
                            overwrite = (Boolean)Type.SQL_BOOLEAN.convertToType(session, data[2], this.nodes[2].getDataType());
                            if (this.nodes.length > 3 && data[3] != null) {
                                replication = (Integer)Type.SQL_INTEGER.convertToType(session, data[3], this.nodes[3].getDataType());
                            }
                            if (this.nodes.length > 4 && data[4] != null) {
                                blocksize = (Long)Type.LONG.convertToType(session, data[4], this.nodes[4].getDataType());
                            }
                            if (overwrite == null) {
                                throw new DataspaceException("overwrite is null.");
                            }
                            if (this.nodes.length > 5 && this.nodes[5] != null && (localfile = (String)data[5]) == null) {
                                throw new DataspaceException("local file path is null.");
                            }
                            if (this.nodes.length > 6 && this.nodes[6] != null) {
                                buffersize = (Integer)Type.SQL_INTEGER.convertToType(session, data[6], this.nodes[6].getDataType());
                                if (buffersize == null) throw new DataspaceException("buffer size is invalid.");
                                if (buffersize <= 0) {
                                    throw new DataspaceException("buffer size is invalid.");
                                }
                            }
                            if (!overwrite.booleanValue() && fileSystem.exists((String)filename)) {
                                throw new DataspaceException("File '" + (String)filename + "' already exists.");
                            }
                            if (replication == null) {
                                replication = fileSystem.getDefaultReplication(directoryTable.getPath());
                            }
                            if (blocksize == null) {
                                blocksize = fileSystem.getDefaultBlockSize(directoryTable.getPath());
                            }
                            outputStream = fileSystem.create((String)filename, overwrite, null, buffersize, replication, blocksize);
                            break;
                        }
                        case 170: {
                            localfile = (String)data[2];
                            if (localfile == null) {
                                throw new DataspaceException("local file path is null.");
                            }
                            if (this.nodes.length > 3 && this.nodes[3] != null) {
                                buffersize = (Integer)Type.SQL_INTEGER.convertToType(session, data[3], this.nodes[3].getDataType());
                                if (buffersize == null) throw new DataspaceException("buffer size is invalid.");
                                if (buffersize <= 0) {
                                    throw new DataspaceException("buffer size is invalid.");
                                }
                            }
                            if (!fileSystem.exists((String)filename)) {
                                throw new DataspaceException("File '" + (String)filename + "' doesn't exists.");
                            }
                            outputStream = fileSystem.append((String)filename, buffersize);
                            break;
                        }
                        case 171: {
                            localfile = (String)data[2];
                            if (localfile == null) {
                                throw new DataspaceException("local file path is null.");
                            }
                            if (this.nodes.length > 3 && this.nodes[3] != null && (overwrite = (Boolean)Type.SQL_BOOLEAN.convertToType(session, data[3], this.nodes[3].getDataType())) == null) {
                                throw new DataspaceException("overwrite is null.");
                            }
                            if (this.nodes.length > 4 && this.nodes[4] != null) {
                                buffersize = (Integer)Type.SQL_INTEGER.convertToType(session, data[4], this.nodes[4].getDataType());
                                if (buffersize == null) throw new DataspaceException("buffer size is invalid.");
                                if (buffersize <= 0) {
                                    throw new DataspaceException("buffer size is invalid.");
                                }
                            }
                            Trace.logInfo(this, "Getting file, filename: " + (String)filename);
                            if (!fileSystem.exists((String)filename)) {
                                throw new DataspaceException("File '" + (String)filename + "' doesn't exists.");
                            }
                            inputStream = fileSystem.open((String)filename, buffersize);
                            outputStream = SessionData.createFileOutputStream(session, localfile, overwrite, false);
                            outputStream = new BufferedOutputStream(outputStream, session.getTransferBufferSize());
                            break;
                        }
                        case 172: {
                            result = fileSystem.delete((String)filename, false);
                            break;
                        }
                    }
                    if (localfile == null) return result;
                    if (inputStream == null) {
                        inputStream = SessionData.createFileInputStream(session, localfile, false, false, null);
                        inputStream = new BufferedInputStream(inputStream, session.getTransferBufferSize());
                    }
                    buffer = new byte[buffersize.intValue()];
                    while ((len = inputStream.read(buffer, 0, buffersize)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                    outputStream.flush();
                    return result;
                }
                catch (IOException exception) {
                    throw new DataspaceException("Failed to process file. Cause: " + exception.getMessage());
                }
                finally {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException exception) {
                        throw new DataspaceException("Failed write file. Cause: " + exception.getMessage());
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException exception) {
                            Trace.logException(this, exception, false);
                        }
                    }
                }
            }
            case 159: {
                serializer = null;
                prettyPrint = false;
                if (this.nodes[1] != null) {
                    prettyPrint = (Boolean)SqlUtils.convertSqlToJava(session, data[1], this.nodes[1].getDataType());
                }
                suppressHeader = false;
                if (this.nodes[2] != null) {
                    suppressHeader = (Boolean)SqlUtils.convertSqlToJava(session, data[2], this.nodes[2].getDataType());
                }
                object = SqlUtils.convertSqlToJava(session, data[0], this.nodes[0].getDataType());
                header = "";
                if (!suppressHeader) {
                    header = "<?xml version=\"1.0\"?>";
                    if (prettyPrint) {
                        header = (String)header + "\n";
                    }
                }
                serializer = prettyPrint != false ? FunctionCustom.xSerializerPrettyPrint : FunctionCustom.xSerializer;
                try {
                    xml = serializer.serializeAtRoot(object, "");
                    return (String)header + xml;
                }
                catch (Exception exception) {
                    throw new DataspaceException("Serialization of object failed. Cause: " + exception.getMessage());
                }
            }
            case 160: {
                prettyPrint = false;
                if (this.nodes[1] != null) {
                    prettyPrint = (Boolean)SqlUtils.convertSqlToJava(session, data[1], this.nodes[1].getDataType());
                }
                serializer = this.getJsonSerializerForFromToJson(session, data, prettyPrint);
                object = SqlUtils.convertSqlToJava(session, data[0], this.nodes[0].getDataType());
                if (object instanceof FlobDataID) {
                    object = FlobManager.convertFlobDataToFlobInfo(session, object, (FlobDataID)object);
                }
                try {
                    if (this.nodes[0] instanceof ExpressionArrayUnnest == false) return serializer.serialize(OtherTypeWrapper.unwrapWithArrays(object));
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING}, new String[]{"Value"});
                    navigator = new RowSetNavigatorData(session);
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    if (object instanceof Object[]) {
                        buffersize = (Object[])object;
                        schemaName = buffersize.length;
                        dotPos = 0;
                        while (dotPos < schemaName) {
                            o = buffersize[dotPos];
                            navigator.add(new Object[]{serializer.serialize(OtherTypeWrapper.unwrap(o))});
                            ++dotPos;
                        }
                        return result;
                    }
                    if (object instanceof Collection == false) return result;
                    iterator = ((Collection)object).iterator();
                    while (iterator.hasNext() != false) {
                        navigator.add(new Object[]{serializer.serialize(OtherTypeWrapper.unwrap(iterator.next()))});
                    }
                    return result;
                }
                catch (Exception exception) {
                    throw new DataspaceException("Serialization of object failed. Cause: " + exception.getMessage());
                }
            }
            case 217: {
                if (data[0] instanceof FlobDataID) {
                    flobData = (FlobDataID)session.dataspaceStore.flobManager.getFlobData(((FlobDataID)data[0]).getId());
                    return FlobManager.convertFlobDataToFlobInfo(session, data[0], flobData);
                }
                if (data[0] instanceof LazyReadFileFunctionExpression) {
                    flobData = (FlobDataID)((LazyReadFileFunctionExpression)data[0]).getLazyFlobData(session);
                    return FlobManager.convertFlobDataToFlobInfo(session, data[0], flobData);
                }
                if (data[0] instanceof LazyLinkFileFunctionExpression == false) throw new DataspaceException("Invalid argument in toFlobInfo function. Should be FLOB.");
                flobData = (FlobDataID)((LazyLinkFileFunctionExpression)data[0]).getLazyFlobData(session);
                return FlobManager.convertFlobDataToFlobInfo(session, data[0], flobData);
            }
            case 237: {
                if (!(data[0] instanceof FlobDataID)) {
                    throw new DataspaceException("Invalid argument in validateFlob function. Should be FLOB.");
                }
                notEmpty = false;
                if (data.length > 1 && data[1] != null && !(data[1] instanceof Boolean)) {
                    throw new DataspaceException("Invalid second argument in validateFlob function. Should be boolean.");
                }
                notEmpty = data.length > 1 && data[1] != null && (Boolean)data[1] == true;
                flobData = (FlobDataID)session.dataspaceStore.flobManager.validateFlob(((FlobDataID)data[0]).getId(), notEmpty);
                FlobManager.setFlobDataValid((FlobDataID)data[0], flobData.isValid());
                return flobData.isValid();
            }
            case 238: {
                if (!(data[0] instanceof FlobDataID)) {
                    throw new DataspaceException("Invalid argument in invalidateFlob function. Should be FLOB.");
                }
                session.dataspaceStore.flobManager.invalidateFlob(((FlobDataID)data[0]).getId());
                return false;
            }
            case 239: {
                if (!(data[0] instanceof FlobDataID)) {
                    throw new DataspaceException("Invalid argument in invalidateFlob function. Should be FLOB.");
                }
                flobData = (FlobDataID)session.dataspaceStore.flobManager.getFlobData(((FlobDataID)data[0]).getId());
                FlobManager.setFlobDataValid((FlobDataID)data[0], flobData.isValid());
                return flobData.isValid();
            }
            case 174: {
                serializer = FunctionCustom.jSerializer;
                object = SqlUtils.convertSqlToJava(session, data[0], this.nodes[0].getDataType());
                try {
                    bytes = serializer.serialize(object);
                    return new BinaryData(bytes, false);
                }
                catch (Exception exception) {
                    throw new DataspaceException("Serialization of object failed. Cause: " + exception.getMessage());
                }
            }
            case 161: 
            case 162: {
                try {
                    pair = SessionData.getBinaryOrString(session, data[0], this.nodes[0].dataType);
                    bytes = (byte[])pair.first;
                    string = (String)pair.second;
                    if (this.funcType == 162) {
                        semanticTypeName = null;
                        serializer = this.getJsonSerializerForFromToJson(session, data, false);
                        if (data.length > 1 && data[1] != null) {
                            if (((String)data[1]).length() > 0) {
                                semanticTypeName = (String)data[1];
                            }
                        } else if (this.dataType instanceof OtherType) {
                            dataTypeName = this.dataType.getTypeDefinition();
                            if (!dataTypeName.equalsIgnoreCase("other") && !dataTypeName.equalsIgnoreCase("object")) {
                                semanticTypeName = dataTypeName;
                            }
                        } else if (this.dataType instanceof ArrayType && this.dataType.collectionBaseType() instanceof OtherType && this.dataType.getInternalClass(session) != Object.class) {
                            semanticTypeName = this.dataType.collectionBaseType().getTypeDefinition() + "[]";
                        }
                        failOnUnknownProperties = true;
                        if (data.length > 8 && data[8] != null) {
                            failOnUnknownProperties = (Boolean)data[8];
                        }
                        try {
                            if (!failOnUnknownProperties) {
                                serializer.failOnUnknownElements(false);
                            }
                            if (semanticTypeName != null) {
                                object = bytes != null ? serializer.deserialize((String)semanticTypeName, bytes) : serializer.deserialize((String)semanticTypeName, string);
                                return new OtherTypeWrapper(object);
                            }
                            object = bytes != null ? serializer.deserialize(bytes) : serializer.deserialize(string);
                            return new OtherTypeWrapper(object);
                        }
                        finally {
                            if (!failOnUnknownProperties) {
                                serializer.failOnUnknownElements(true);
                            }
                        }
                    }
                    dataTypeName = null;
                    if (this.dataType instanceof OtherType) {
                        dataTypeName = this.dataType.getTypeDefinition();
                    }
                    typesMap = null;
                    if (data.length > 1 && data[1] != null) {
                        typesMap = (Map)OtherTypeWrapper.unwrap(data[1]);
                    }
                    if (dataTypeName != null && dataTypeName.equalsIgnoreCase("map")) {
                        object = new XmlToMapDeserializer().deserialize(new ByteArrayInputStream(bytes != null ? bytes : string.getBytes()), (Map<String, String>)typesMap, null);
                        return new OtherTypeWrapper(object);
                    }
                    if (typesMap != null) {
                        throw new DataspaceException("Types map can be only specified when deserialize to map.");
                    }
                    object = bytes != null ? FunctionCustom.xSerializerPrettyPrint.deserialize(bytes) : FunctionCustom.xSerializerPrettyPrint.deserialize(string);
                    return new OtherTypeWrapper(object);
                }
                catch (Exception exception) {
                    throw new DataspaceException("Deserialization failed. Cause: " + exception.getMessage());
                }
            }
            case 175: {
                serializer = FunctionCustom.jSerializer;
                try {
                    d = data[0];
                    if (d instanceof OtherTypeWrapper) {
                        d = ((OtherTypeWrapper)d).getObject();
                    }
                    if (d instanceof BinaryData) {
                        bytes = ((BinaryData)d).getBytes();
                        return new OtherTypeWrapper(serializer.deserialize(bytes));
                    }
                    if (d instanceof byte[]) {
                        bytes = (byte[])d;
                        return new OtherTypeWrapper(serializer.deserialize(bytes));
                    }
                    if (d instanceof String) {
                        bytes = ((String)d).getBytes();
                        return new OtherTypeWrapper(serializer.deserialize(bytes));
                    }
                    if (d instanceof BlobDataID) {
                        bytes = SqlUtils.extractBlob(session, (BlobDataID)d);
                        return new OtherTypeWrapper(serializer.deserialize(bytes));
                    }
                    if (data[0] != null) throw new DataspaceException("Incompatible value type. Binary types are allowed only.");
                    return null;
                }
                catch (Exception exception) {
                    throw new DataspaceException("Deserialization failed. Cause: " + exception.getMessage());
                }
            }
            case 184: {
                object = OtherTypeWrapper.unwrap(data[0]);
                includeCssContent = false;
                if (data.length > 1 && data[1] != null) {
                    includeCssContent = (Boolean)data[1];
                }
                css = null;
                if (data.length > 2 && data[2] != null) {
                    css = (String)data[2];
                }
                try {
                    if (!includeCssContent) {
                        v13 = true;
                        return AbstractRestResponse.objectToHtml(object, v13, css, false, new StringBuilder()).toString();
                    }
                    v13 = false;
                    return AbstractRestResponse.objectToHtml(object, v13, css, false, new StringBuilder()).toString();
                }
                catch (IOException exception) {
                    throw new DataspaceException("Failed to format object to HTML.", exception);
                }
            }
            case 218: {
                dropBoxPath = String.valueOf(OtherTypeWrapper.unwrap(data[0]));
                acceptorName = null;
                if (data.length > 1 && data[1] != null) {
                    acceptorName = String.valueOf(data[1]);
                }
                cryptoAlg = null;
                if (data.length > 2 && data[2] != null) {
                    cryptoAlg = JWTAlgorithmType.valueOf(((String)data[2]).toUpperCase());
                }
                keyName = null;
                if (data.length > 3 && data[3] != null) {
                    keyName = (String)data[3];
                }
                expiresAt = null;
                if (data.length > 4 && data[4] != null) {
                    expiresAt = data[4] instanceof TimestampData != false ? Long.valueOf(((TimestampData)data[4]).getMilliseconds() / 1000L) : Long.valueOf(DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), DataspaceDateTime.getSqlTimestampMilliseconds((String)data[4], session.getTimeZone().toString())) / 1000L);
                }
                if (data.length > 5 && data[5] != null) {
                    if (expiresAt != null) {
                        throw new DataspaceException("Only one parameter expiresAt or expiresIn can be specified.");
                    }
                    expiresIn = (String)data[5];
                    parts = expiresIn.trim().split(" ");
                    if (parts.length != 2) {
                        throw new DataspaceException("Invalid expiresIn format. Should be: <value> {sec | min | hr | days} ");
                    }
                    expiresAt = System.currentTimeMillis() / 1000L + TimeUnitParameter.parseValue(parts[1]).toSeconds(Long.valueOf(parts[0]));
                }
                notBefore = null;
                if (data.length > 6 && data[6] != null) {
                    notBefore = data[6] instanceof TimestampData != false ? Long.valueOf(((TimestampData)data[6]).getMilliseconds() / 1000L) : Long.valueOf(DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), DataspaceDateTime.getSqlTimestampMilliseconds((String)data[6], session.getTimeZone().toString())) / 1000L);
                }
                if (cryptoAlg != null) {
                    if (keyName == null) {
                        throw new DataspaceException("Security key alias is not specified.");
                    }
                    if (expiresAt == null) {
                        throw new DataspaceException("Expiration time is not specified.");
                    }
                }
                if (notBefore != null && expiresAt != null && expiresAt < notBefore) {
                    throw new DataspaceException("Expiration time is before 'not before' time.");
                }
                url = DropBoxUtils.getDropBoxHTTPDownloadURL(dropBoxPath);
                if (cryptoAlg == null) return DropBoxUtils.getURLForAcceptor(DataspaceStore.getContext(), acceptorName, (String)url);
                jwt = JWT.builder().setJwtAlgorithmType(cryptoAlg).setContext(DataspaceStore.getContext()).setKeyName(keyName).setPayload(new JWTPayload().setExpiresAt(expiresAt).setNotBefore(notBefore).setResources(Arrays.asList(new JWTPayload.JWTResource[]{new JWTPayload.JWTResource("GET", (String)url)}))).buildToken(session);
                url = (String)url + "?x-resource-token=" + jwt;
                return DropBoxUtils.getURLForAcceptor(DataspaceStore.getContext(), acceptorName, (String)url);
            }
            case 221: {
                try {
                    html = String.valueOf(data[0]);
                    htmlType = HTMLType.TABLE;
                    if (this.nodes[1] != null && data[1] != null) {
                        htmlType = (HTMLType)SqlUtils.convertSqlToJava(session, data[1], this.nodes[1].getDataType());
                    }
                    if (!htmlType.equals((Object)HTMLType.TABLE)) {
                        throw new DataspaceException("Table HTML Type supported only.");
                    }
                    nullable = false;
                    if (data.length > 2 && data[2] != null) {
                        nullable = (Boolean)data[2];
                    }
                    topElement = null;
                    if (data.length > 3 && data[3] != null) {
                        topElement = (String)data[3];
                    }
                    prettyPrint = true;
                    if (data.length > 4 && data[4] != null) {
                        prettyPrint = (Boolean)data[4];
                    }
                    columnNames = null;
                    if (data.length > 5 && data[5] != null) {
                        columnNames = Arrays.stream((Object[])data[5]).map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getValue$0(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)()).collect(Collectors.toList());
                    }
                    matches = false;
                    if (data.length <= 6) return new HTMLDocument(html).toJSON(htmlType, nullable, topElement, prettyPrint, columnNames, matches);
                    if (data[6] == null) return new HTMLDocument(html).toJSON(htmlType, nullable, topElement, prettyPrint, columnNames, matches);
                    matches = (Boolean)data[6];
                    return new HTMLDocument(html).toJSON(htmlType, nullable, topElement, prettyPrint, columnNames, matches);
                }
                catch (Exception exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            case 222: {
                try {
                    html = String.valueOf(data[0]);
                    return new HTMLDocument(html).toDocument();
                }
                catch (Exception exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            case 223: {
                try {
                    html = String.valueOf(data[0]);
                    return new HTMLDocument(html, true).toDocument();
                }
                catch (Exception exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            case 226: {
                try {
                    html = String.valueOf(data[0]);
                    nullable = false;
                    if (data.length > 1 && data[1] != null) {
                        nullable = (Boolean)data[1];
                    }
                    columnNames = null;
                    if (data.length > 2 && data[2] != null) {
                        columnNames = Arrays.stream((Object[])data[2]).map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getValue$1(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)()).collect(Collectors.toList());
                    }
                    matches = false;
                    if (data.length <= 3) return new HTMLDocument(html).toRowSet(HTMLType.TABLE, nullable, columnNames, matches);
                    if (data[3] == null) return new HTMLDocument(html).toRowSet(HTMLType.TABLE, nullable, columnNames, matches);
                    matches = (Boolean)data[3];
                    return new HTMLDocument(html).toRowSet(HTMLType.TABLE, nullable, columnNames, matches);
                }
                catch (Exception exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            case 224: {
                try {
                    html = String.valueOf(data[0]);
                    selector = String.valueOf(data[1]);
                    return new HTMLDocument(html).selectFirst(selector);
                }
                catch (Exception exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            case 225: {
                try {
                    html = String.valueOf(data[0]);
                    selector = String.valueOf(data[1]);
                    return new HTMLDocument(html).select(selector);
                }
                catch (Exception exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            case 219: {
                term = String.valueOf(OtherTypeWrapper.unwrap(data[0]));
                tableName = String.valueOf(OtherTypeWrapper.unwrap(data[1]));
                limit = data.length > 2 && data[2] != null ? (Integer)data[2] : 0;
                minScore = data.length > 3 && data[3] != null ? ((Number)data[3]).doubleValue() : 4.9E-324;
                try {
                    rowSet = SelectForNearestExpression.execute(session, term, tableName, limit, minScore);
                    result = new Object[rowSet.getRowCount()];
                    i = 0;
                    while (rowSet.next() != false) {
                        result[i++] = rowSet.getString(1);
                    }
                    return result;
                }
                catch (FabricComponentAccessorException exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
                catch (DataspaceException exception) {
                    return new Object[0];
                }
                catch (SQLException exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            case 220: {
                term1 = String.valueOf(OtherTypeWrapper.unwrap(data[0]));
                term2 = String.valueOf(OtherTypeWrapper.unwrap(data[1]));
                tableName = String.valueOf(OtherTypeWrapper.unwrap(data[2]));
                try {
                    rowSet = SelectForSimilarityExpression.execute(session, term1, term2, tableName);
                    rowSet.next();
                    return rowSet.getDouble(1);
                }
                catch (FabricComponentAccessorException exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
                catch (DataspaceException exception) {
                    return 0.0;
                }
                catch (SQLException exception) {
                    throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            case 110: 
            case 126: {
                if (data[0] == null) return null;
                if (data[1] == null) {
                    return null;
                }
                value = this.nodes[0].dataType.isCharacterType() != false && this.nodes[0].dataType.isLobType() == false ? (String)data[0] : this.nodes[0].dataType.convertToString(data[0]);
                length = (Integer)Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].dataType);
                pad = " ";
                if (this.nodes[2] != null && (pad = this.nodes[2].dataType.convertToString(data[2])).length() == 0) {
                    pad = " ";
                }
                value = (String)Type.SQL_VARCHAR.trim(session, value, 32, true, true);
                value = StringUtil.toPaddedString(value, length, pad, this.funcType == 126);
                if (this.dataType.isLobType() == false) return value;
                return this.dataType.convertToType(session, value, Type.SQL_VARCHAR);
            }
            case 113: {
                if (data[1] == null) {
                    return null;
                }
                if (data[2] == null) {
                    return null;
                }
                array = (Object[])data[1];
                dt = (ArrayType)this.nodes[1].dataType;
                elementType = dt.collectionBaseType();
                start = ((Number)Type.SQL_INTEGER.convertToType(session, data[2], this.nodes[2].dataType)).intValue();
                if (start <= 0) {
                    throw Error.error(3403);
                }
                i = --start;
                while (i < array.length) {
                    if (elementType.compare(session, data[0], array[i]) == 0) {
                        return ValuePool.getInt(i + 1);
                    }
                    ++i;
                }
                return ValuePool.INTEGER_0;
            }
            case 136: {
                if (data[0] == null) {
                    return null;
                }
                dt = (ArrayType)this.dataType;
                exprSort = new SortAndSlice();
                exprSort.prepareSingleColumn(1);
                exprSort.sortDescending[0] = ((Number)data[1]).intValue() == 389;
                exprSort.sortNullsLast[0] = ((Number)data[2]).intValue() == 430;
                array = ArrayUtil.duplicateArray(data[0]);
                dt.sort(session, array, exprSort);
                return array;
            }
            case 176: {
                return this.dataType.castToType(session, data[0], this.nodes[0].getDataType());
            }
            case 235: {
                return DomainRangeUtils.matchesDomain(session, (String)data[0], data[1]);
            }
            case 236: {
                d = data[1];
                if (d instanceof OtherTypeWrapper == false) return DomainRangeUtils.matchesRange(session, (String)data[0], d);
                d = ((OtherTypeWrapper)d).getObject();
                return DomainRangeUtils.matchesRange(session, (String)data[0], d);
            }
            case 177: {
                return this.dataType.castToType(session, data[0], this.nodes[0].getDataType());
            }
            case 215: {
                if (data[0] == null) {
                    return null;
                }
                bt = Base64.decode((String)data[0], session.getSessionCCSID().name());
                return new BinaryData(bt, false);
            }
            case 227: {
                if (data[0] == null) {
                    return null;
                }
                pair = SessionData.getBinaryOrString(session, data[0], this.nodes[0].dataType);
                if (pair.second != null) {
                    pair.first = (TFirst)((String)pair.second).getBytes();
                }
                if (pair.first != null) return Base64.encodeBytes((byte[])pair.first);
                return null;
            }
            case 234: {
                intervalValue = 0;
                intervalValue = data[0] instanceof BigInteger != false ? ((BigInteger)data[0]).intValue() : ((Integer)data[0]).intValue();
                Utils.sleep(intervalValue);
                return true;
            }
            case 240: {
                td = (TimestampData)data[0];
                weekDay = (String)data[1];
                isArr = false;
                if (data[2] == null) {
                    data[2] = 1;
                }
                if (data[2] instanceof Object[]) {
                    periods = (Object[])data[2];
                    isArr = true;
                } else {
                    periods = new Object[]{data[2]};
                }
                tss = new Object[periods.length];
                weekDayObj = DayOfWeek.valueOf(weekDay.toUpperCase());
                dt = Instant.ofEpochMilli(td.getMilliseconds()).atZone(ZoneId.of("UTC")).toLocalDate();
                for (periodIdx = 0; periodIdx < periods.length; ++periodIdx) {
                    period = (Integer)periods[periodIdx];
                    dtLocal = dt;
                    for (i = 0; i < period; dtLocal = dtLocal.with(TemporalAdjusters.next(weekDayObj)), ++i) {
                    }
                    shifted = dtLocal.atStartOfDay(ZoneId.of("UTC")).toEpochSecond() * 1000L;
                    tss[periodIdx] = new TimestampData(shifted);
                }
                if (isArr) {
                    v14 /* !! */  = tss;
                    return v14 /* !! */ ;
                }
                v14 /* !! */  = tss[0];
                return v14 /* !! */ ;
            }
            case 241: {
                weekDays = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
                day = (Integer)data[0];
                if (day < 1) throw new DataspaceException("Wrong day index.");
                if (day <= 7) return weekDays[day - 1];
                throw new DataspaceException("Wrong day index.");
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
        while (i < array.length) {
            if (elementType.compare(session, data[1], array[i]) == 0) {
                return ValuePool.getInt(i + 1);
            }
            ++i;
        }
        return ValuePool.INTEGER_0;
    }

    private JSONSerializer getJsonSerializerForFromToJson(Session session, Object[] data, boolean prettyPrint) {
        String sqlTimeFormat;
        JsonNotation jsonNotation = JsonNotation.TOP_ELEMENT;
        if (this.nodes[2] != null && data[2] != null) {
            jsonNotation = (JsonNotation)((Object)SqlUtils.convertSqlToJava(session, data[2], this.nodes[2].getDataType()));
        }
        String jsonNotationLevel = null;
        if (this.nodes[3] != null) {
            jsonNotationLevel = (String)data[3];
        }
        String dateFormat = this.nodes[4] != null ? (String)data[4] : null;
        String sqlTimestampFormat = this.nodes[5] != null ? (String)data[5] : null;
        String sqlDateFormat = this.nodes[6] != null ? (String)data[6] : null;
        String string = sqlTimeFormat = this.nodes[7] != null ? (String)data[7] : null;
        if (dateFormat == null) {
            dateFormat = session.dataspaceStore.getProperties().getStringProperty("dtspace.serializer.date_format");
        }
        if (sqlTimestampFormat == null) {
            sqlTimestampFormat = session.dataspaceStore.getProperties().getStringProperty("dtspace.serializer.sqltimestamp_format");
        }
        if (sqlDateFormat == null) {
            sqlDateFormat = session.dataspaceStore.getProperties().getStringProperty("dtspace.serializer.sqldate_format");
        }
        if (sqlTimeFormat == null) {
            sqlTimeFormat = session.dataspaceStore.getProperties().getStringProperty("dtspace.serializer.sqltime_format");
        }
        if ("millis".equals(dateFormat)) {
            dateFormat = null;
        }
        if ("millis".equals(sqlTimestampFormat)) {
            sqlTimestampFormat = null;
        }
        JSONSerializer serializer = FunctionCustom.getJsonSerializer(jsonNotation, jsonNotationLevel, prettyPrint, dateFormat, sqlTimestampFormat, sqlDateFormat, sqlTimeFormat, true);
        return serializer;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resolveTypes(Session session, Expression parent) {
        void var3_4;
        boolean bl = false;
        while (var3_4 < this.nodes.length) {
            if (this.nodes[var3_4] != null) {
                if (this.nodes[var3_4].isDynamicParam()) {
                    SQLFunctionsMetaData.SQLFunctionMetaData.Argument arg;
                    SQLFunctionsMetaData.SQLFunctionMetaData meta = customFunctions.lookupFunction(this.funcType);
                    if (meta != null && (arg = meta.getArgument((int)var3_4)) != null && arg.getTypes() != null && arg.getTypes().length > 0) {
                        this.nodes[var3_4].setDataType(session, arg.getTypes()[0]);
                    }
                } else {
                    this.nodes[var3_4].resolveTypes(session, this);
                }
            }
            ++var3_4;
        }
        switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, parent);
                return;
            }
            case 87: 
            case 200: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 232: 
            case 233: 
            case 234: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 88: 
            case 91: 
            case 101: 
            case 131: 
            case 149: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 90: 
            case 132: 
            case 144: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 99: 
            case 107: 
            case 130: 
            case 150: 
            case 151: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 96: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 129: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5561);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), Integer.MAX_VALUE);
                return;
            }
            case 201: 
            case 202: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = ((ArrayType)this.nodes[0].dataType).collectionBaseType();
                }
                if (((ArrayType)this.nodes[0].dataType).collectionBaseType().typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[2].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                if (this.funcType == 201) {
                    this.dataType = Type.SQL_INTEGER;
                    return;
                }
                this.dataType = new ArrayType(Type.SQL_NUMERIC, -1);
                return;
            }
            case 209: 
            case 212: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = ((ArrayType)this.nodes[0].dataType).collectionBaseType();
                }
                if (((ArrayType)this.nodes[0].dataType).collectionBaseType().typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 213: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = ((ArrayType)this.nodes[0].dataType).collectionBaseType();
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = ((ArrayType)this.nodes[0].dataType).collectionBaseType();
                }
                if (((ArrayType)this.nodes[0].dataType).collectionBaseType().typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup || ((ArrayType)this.nodes[0].dataType).collectionBaseType().typeComparisonGroup != this.nodes[2].dataType.typeComparisonGroup) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 214: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.STRING;
                return;
            }
            case 210: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = ((ArrayType)this.nodes[1].dataType).collectionBaseType();
                }
                if (((ArrayType)this.nodes[1].dataType).collectionBaseType().typeComparisonGroup != this.nodes[0].dataType.typeComparisonGroup) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[1].dataType;
                return;
            }
            case 211: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (((ArrayType)this.nodes[0].dataType).collectionBaseType().typeComparisonGroup != ((ArrayType)this.nodes[1].dataType).collectionBaseType().typeComparisonGroup) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 204: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 205: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.STRING;
                return;
            }
            case 206: 
            case 207: 
            case 208: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue((Object)1, Type.SQL_INTEGER);
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 203: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(true, Type.SQL_BOOLEAN);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(true, Type.SQL_BOOLEAN);
                }
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 92: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                int n = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 142;
            }
            case 142: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode != 91 && this.nodes[2].dataType.typeCode != 93 && this.nodes[2].dataType.typeCode != 95) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 93: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = this.nodes[0];
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(836), Type.SQL_INTEGER);
                } else {
                    if (!this.nodes[0].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    int n = this.getTSIToken((String)this.nodes[0].valueData);
                    this.nodes[0].valueData = ValuePool.getInt(n);
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                this.funcType = 143;
            }
            case 143: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                block93 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode == 92 || this.nodes[2].dataType.typeCode == 94) {
                            throw Error.error(5563);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 836: 
                            case 837: 
                            case 838: 
                            case 839: 
                            case 840: {
                                break block93;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode != 92 && this.nodes[2].dataType.typeCode != 94) break;
                        throw Error.error(5563);
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 94: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 91: 
                    case 93: 
                    case 95: {
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 124: 
            case 152: {
                boolean bl2;
                boolean bl3 = bl2 = this.nodes.length == 1 || this.nodes[1] == null;
                if (this.nodes[0].dataType == null) {
                    if (bl2) {
                        this.nodes[0].dataType = Type.SQL_DECIMAL;
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (!bl2 && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    return;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 153: {
                void var3_11;
                Object var3_8 = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    Integer n = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        Number number = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (var3_11 == null) return;
                int scale = var3_11.intValue();
                if (scale < 0) {
                    scale = 0;
                } else if (scale > this.dataType.scale) {
                    scale = this.dataType.scale;
                }
                if (this.dataType.typeCode != 3 && this.dataType.typeCode != 2 || scale == this.dataType.scale) return;
                this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)scale, scale);
                return;
            }
            case 145: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[0].dataType.isDateTimeType() && !this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 147: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 146: 
            case 148: 
            case 216: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] != null && this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isDateTimeType() && !this.nodes[0].dataType.isNumberType() && !this.nodes[0].dataType.isObjectType() || this.nodes[1] != null && !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = this.funcType == 146 ? Type.SQL_DATE : (this.funcType == 216 ? Type.SQL_TIME : Type.SQL_TIMESTAMP);
                return;
            }
            case 112: {
                this.dataType = Type.SQL_DOUBLE;
                return;
            }
            case 154: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_BINARY_16;
                    return;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_BINARY_16;
                    return;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_BINARY_16;
                    return;
                }
                if (!this.nodes[0].dataType.isBinaryType() || this.nodes[0].dataType.isLobType()) throw Error.error(5563);
                this.dataType = Type.SQL_CHAR_16;
                return;
            }
            case 155: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 115: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                return;
            }
            case 71: 
            case 74: 
            case 75: 
            case 84: 
            case 85: 
            case 95: 
            case 109: 
            case 114: 
            case 125: 
            case 134: 
            case 140: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                return;
            }
            case 133: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 76: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                return;
            }
            case 135: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                return;
            }
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                void var3_13;
                boolean bl4 = false;
                while (var3_13 < 2) {
                    if (this.nodes[var3_13].dataType == null) {
                        this.nodes[var3_13].dataType = Type.SQL_VARCHAR;
                    } else if (!this.nodes[var3_13].dataType.isCharacterType()) {
                        throw new DataspaceException("Incompatible data type. String type for parameter with index " + (int)(var3_13 + true) + " are allowed only.");
                    }
                    ++var3_13;
                }
                if (this.funcType != 165 && this.funcType == 168) {
                    void var3_15;
                    int n = 2;
                    while (var3_15 < 6 && var3_15 < this.nodes.length && this.nodes[var3_15] != null) {
                        if (this.nodes[var3_15].dataType == null) {
                            this.nodes[var3_15].dataType = Type.SQL_DOUBLE;
                        } else if (!this.nodes[var3_15].dataType.isNumberType()) {
                            throw new DataspaceException("Incompatible data type. Numeric type for parameter with index " + (int)(var3_15 + true) + " are allowed only.");
                        }
                        ++var3_15;
                    }
                }
                this.dataType = NumberType.getNumberType(8, 0L, 0);
                return;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.funcType == 79) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType;
                } else {
                    void var3_17;
                    this.dataType = this.nodes[0].dataType;
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = this.nodes[0].dataType;
                    }
                    boolean bl5 = false;
                    while (var3_17 < this.nodes.length) {
                        if (this.nodes[var3_17].dataType == null) {
                            this.nodes[var3_17].dataType = Type.SQL_INTEGER;
                        }
                        ++var3_17;
                    }
                    this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                }
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: 
                    case 1117: {
                        return;
                    }
                    case 14: 
                    case 15: {
                        return;
                    }
                }
                throw Error.error(5561);
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 82: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                return;
            }
            case 97: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 98: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                return;
            }
            case 116: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                return;
            }
            case 229: {
                this.dataType = Type.OTHER;
                return;
            }
            case 156: {
                try {
                    Class<?> objectClass;
                    void var3_19;
                    boolean bl6 = false;
                    while (var3_19 < this.nodes.length) {
                        if (this.nodes[var3_19] != null) {
                            this.nodes[var3_19].resolveTypes(session, this);
                        }
                        ++var3_19;
                    }
                    if (this.dataType != null) return;
                    Type type = this.nodes[0].getDataType();
                    if (!type.isObjectType()) {
                        objectClass = type.getJDBCClass();
                    } else {
                        if (!(type instanceof OtherType)) throw new DataspaceException("Unable to resolve spath function parameter data type.");
                        if (type.getObjectName() != null) {
                            String objectSemanticType = type.getObjectName().name;
                            objectClass = this.typeAnalyzer.getClassBySemanticType(objectSemanticType);
                        } else {
                            if (((OtherType)type).getInternalClass(session) == null) throw new DataspaceException("Unable to resolve spath function parameter data type.");
                            objectClass = ((OtherType)type).getInternalClass(session);
                        }
                    }
                    if (objectClass == null) {
                        throw new DataspaceException("Unable to resolve class for '" + type.getTypeDefinition() + "' type.");
                    }
                    Class fieldClass = null;
                    try {
                        fieldClass = this.typeAnalyzer.getFieldClass(objectClass, (String)this.nodes[1].valueData);
                        if (fieldClass == null) {
                            throw new DataspaceException("Unable to resolve class for the provided SDS path '" + (String)this.nodes[1].valueData + "' of the '" + type.getTypeDefinition() + "' type.");
                        }
                    }
                    catch (Exception exception) {
                        fieldClass = Object.class;
                    }
                    this.dataType = Types.getParameterSQLType(session, fieldClass);
                    if (this.dataType != null) return;
                    throw new DataspaceException("Unable to resolve data type for the provided SDS path '" + (String)this.nodes[1].valueData + "' class '" + fieldClass.getSimpleName() + "'.");
                }
                catch (TypeAnalyzerException typeAnalyzerException) {
                    throw new DataspaceException(typeAnalyzerException);
                }
            }
            case 157: {
                void var3_23;
                boolean bl7 = false;
                while (var3_23 < this.nodes.length) {
                    if (this.nodes[var3_23] != null) {
                        this.nodes[var3_23].resolveTypes(session, this);
                    }
                    ++var3_23;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARBINARY;
                }
                this.dataType = Type.getDefaultArrayType(12);
                return;
            }
            case 120: {
                boolean bl8;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!(bl8 = this.nodes[0].dataType.isCharacterType()) && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = bl8 ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                return;
            }
            case 121: {
                void var3_26;
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
                boolean bl9 = false;
                while (var3_26 < this.nodes.length) {
                    if (this.nodes[var3_26].dataType == null) {
                        this.nodes[var3_26].dataType = Type.SQL_VARCHAR;
                    } else if (!this.nodes[var3_26].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                    ++var3_26;
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 105: 
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                return;
            }
            case 137: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 122: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) return;
                throw Error.error(5561);
            }
            case 117: 
            case 118: 
            case 119: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String string = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(string);
                }
                switch (this.funcType) {
                    case 117: {
                        this.dataType = Type.SQL_BOOLEAN;
                        return;
                    }
                    case 118: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        return;
                    }
                    case 119: {
                        this.dataType = Type.getDefaultArrayType(12);
                    }
                }
                return;
            }
            case 86: {
                void var3_29;
                boolean bl10 = false;
                while (var3_29 < this.nodes.length) {
                    if (this.nodes[var3_29].dataType == null) {
                        this.nodes[var3_29].dataType = Type.SQL_VARCHAR;
                    } else if (!this.nodes[var3_29].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                    ++var3_29;
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 106: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !(this.nodes[0].dataType instanceof FlobType)) {
                    throw Error.error(5561, "Expected flob or file name.");
                }
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_DECIMAL;
                    }
                    if (!this.nodes[1].dataType.isExactNumberType()) {
                        throw new DataspaceException("Failed to parse offset parameter.");
                    }
                }
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_DECIMAL;
                    }
                    if (!this.nodes[2].dataType.isExactNumberType()) {
                        throw new DataspaceException("Failed to parse length parameter.");
                    }
                }
                this.dataType = Type.STRING;
                return;
            }
            case 231: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !(this.nodes[0].dataType instanceof FlobType)) {
                    throw Error.error(5561, "Expected flob or file name.");
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DECIMAL;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw new DataspaceException("Failed to parse startLine parameter.");
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_DECIMAL;
                }
                if (!this.nodes[2].dataType.isExactNumberType()) {
                    throw new DataspaceException("Failed to parse endLine parameter.");
                }
                this.dataType = Type.STRING;
                return;
            }
            case 182: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561, "Expected filename for first argument.");
                }
                if (this.nodes.length > 1 && this.nodes[1] != null && this.nodes[1].dataType != null && !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes.length > 2 && this.nodes[2] != null && this.nodes[2].dataType != null && !this.nodes[2].dataType.isBooleanType()) {
                    throw Error.error(5561);
                }
                if (this.nodes.length > 3 && this.nodes[3] != null && this.nodes[3].dataType != null && !this.nodes[3].dataType.isBooleanType()) {
                    throw Error.error(5561);
                }
                this.dataType = null;
                return;
            }
            case 183: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561, "Expected filename for first argument.");
                }
                if (this.nodes[1] instanceof FunctionCustom && (((FunctionCustom)this.nodes[1]).funcType == 106 || ((FunctionCustom)this.nodes[1]).funcType == 183 || ((FunctionCustom)this.nodes[1]).funcType == 231)) {
                    FlobType flobType = new FlobType();
                    flobType.setLazy(true);
                    flobType.setVariable(false);
                    ((FunctionCustom)this.nodes[1]).dataType = flobType;
                }
                if (this.nodes.length > 2 && this.nodes[2] != null && this.nodes[2].dataType != null && !this.nodes[2].dataType.isCharacterType()) {
                    throw Error.error(5561, "Charset should be of type string.");
                }
                this.dataType = null;
                return;
            }
            case 158: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes.length > 3 && this.nodes[3] != null && (this.nodes[0].dataType.equals(Type.SQL_BLOB) || this.nodes[0].dataType.isBinaryType())) {
                    throw new DataspaceException("Incompatible data type. Charset specification allowed for CLOB or Character types only.");
                }
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                void var3_32;
                boolean bl11 = false;
                while (var3_32 < 2) {
                    if (this.nodes[var3_32].dataType == null) {
                        this.nodes[var3_32].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[var3_32].dataType.isCharacterType()) {
                        throw new DataspaceException("Failed to parse " + (var3_32 == false ? "directory table" : "filename") + " parameter.");
                    }
                    ++var3_32;
                }
                switch (this.funcType) {
                    case 169: {
                        if (this.nodes[2].dataType == null) {
                            this.nodes[2].dataType = Type.SQL_BOOLEAN;
                        }
                        if (!this.nodes[2].dataType.isBooleanType()) {
                            throw new DataspaceException("Failed to parse overwrite parameter.");
                        }
                        if (this.nodes.length > 3 && this.nodes[3] != null) {
                            if (this.nodes[3].dataType == null) {
                                this.nodes[3].dataType = Type.SQL_INTEGER;
                            }
                            if (!this.nodes[3].dataType.isExactNumberType()) {
                                throw new DataspaceException("Failed to parse replication parameter.");
                            }
                        }
                        if (this.nodes.length > 4 && this.nodes[4] != null) {
                            if (this.nodes[4].dataType == null) {
                                this.nodes[4].dataType = Type.LONG;
                            }
                            if (!this.nodes[4].dataType.isExactNumberType()) {
                                throw new DataspaceException("Failed to parse blocksize parameter.");
                            }
                        }
                        if (this.nodes.length > 5 && this.nodes[5] != null) {
                            if (this.nodes[5].dataType == null) {
                                this.nodes[5].dataType = Type.SQL_VARCHAR;
                            }
                            if (!this.nodes[5].dataType.isCharacterType()) {
                                throw new DataspaceException("Failed to parse local file path parameter.");
                            }
                        }
                        if (this.nodes.length <= 6 || this.nodes[6] == null) break;
                        if (this.nodes[6].dataType == null) {
                            this.nodes[6].dataType = Type.SQL_INTEGER;
                        }
                        if (this.nodes[6].dataType.isExactNumberType()) break;
                        throw new DataspaceException("Failed to parse buffer size parameter.");
                    }
                    case 170: {
                        if (this.nodes[2].dataType == null) {
                            this.nodes[2].dataType = Type.SQL_VARCHAR;
                        }
                        if (!this.nodes[2].dataType.isCharacterType()) {
                            throw new DataspaceException("Failed to parse local file path parameter.");
                        }
                        if (this.nodes.length <= 3 || this.nodes[3] == null) break;
                        if (this.nodes[3].dataType == null) {
                            this.nodes[3].dataType = Type.SQL_INTEGER;
                        }
                        if (this.nodes[3].dataType.isExactNumberType()) break;
                        throw new DataspaceException("Failed to parse buffer size parameter.");
                    }
                    case 171: {
                        if (this.nodes[2].dataType == null) {
                            this.nodes[2].dataType = Type.SQL_VARCHAR;
                        }
                        if (!this.nodes[2].dataType.isCharacterType()) {
                            throw new DataspaceException("Failed to parse local file path parameter.");
                        }
                        if (this.nodes.length > 3 && this.nodes[3] != null) {
                            if (this.nodes[3].dataType == null) {
                                this.nodes[3].dataType = Type.SQL_BOOLEAN;
                            }
                            if (!this.nodes[3].dataType.isBooleanType()) {
                                throw new DataspaceException("Failed to parse overwrite parameter.");
                            }
                        }
                        if (this.nodes.length <= 4 || this.nodes[4] == null) break;
                        if (this.nodes[4].dataType == null) {
                            this.nodes[4].dataType = Type.SQL_INTEGER;
                        }
                        if (this.nodes[4].dataType.isExactNumberType()) break;
                        throw new DataspaceException("Failed to parse buffer size parameter.");
                    }
                }
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 159: 
            case 160: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.STRING;
                return;
            }
            case 217: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = new OtherType("FlobInfo", FlobInfo.class);
                return;
            }
            case 237: {
                this.nodes[0].resolveTypes(session, this);
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    this.nodes[1].resolveTypes(session, this);
                }
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 238: 
            case 239: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 184: {
                this.nodes[0].resolveTypes(session, this);
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    this.nodes[1].resolveTypes(session, this);
                    if (this.nodes[1].getDataType() != null && !this.nodes[1].getDataType().isBooleanType()) {
                        throw new DataspaceException("Incompatible data type. Boolean type allowed only for second argument.");
                    }
                }
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    this.nodes[2].resolveTypes(session, this);
                    if (this.nodes[2].getDataType() != null && !this.nodes[2].getDataType().isCharacterType()) {
                        throw new DataspaceException("Incompatible data type. String typee allowed only for third argument.");
                    }
                }
                this.dataType = Type.STRING;
                return;
            }
            case 218: {
                this.nodes[0].resolveTypes(session, this);
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    this.nodes[1].resolveTypes(session, this);
                    if (this.nodes[1].getDataType() != null && !this.nodes[2].getDataType().isCharacterType()) {
                        throw new DataspaceException("Incompatible data type. String type allowed only for third argument.");
                    }
                }
                this.dataType = Type.STRING;
                return;
            }
            case 221: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.STRING;
                return;
            }
            case 222: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.OTHER;
                return;
            }
            case 226: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.OTHER;
                return;
            }
            case 223: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.OTHER;
                return;
            }
            case 224: {
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = Type.OTHER;
                return;
            }
            case 225: {
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = Type.OTHER;
                return;
            }
            case 219: {
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    this.nodes[2].resolveTypes(session, this);
                    if (this.nodes[2].getDataType() != null && !this.nodes[2].getDataType().isNumberType()) {
                        throw new DataspaceException("Incompatible data type. Integer type allowed only for third argument.");
                    }
                }
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    this.nodes[3].resolveTypes(session, this);
                    if (this.nodes[3].getDataType() != null && !this.nodes[3].getDataType().isNumberType()) {
                        throw new DataspaceException("Incompatible data type. Double type allowed only for fourth argument.");
                    }
                }
                this.dataType = Type.SQL_ARRAY_ALL_TYPES;
                return;
            }
            case 220: {
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.nodes[2].resolveTypes(session, this);
                this.dataType = Type.SQL_DOUBLE;
                return;
            }
            case 161: 
            case 162: {
                this.nodes[0].resolveTypes(session, this);
                if (!(this.nodes[0].getDataType() == null || this.nodes[0].getDataType().isCharacterType() || this.nodes[0].getDataType().isBinaryType() || this.nodes[0].getDataType().isFlobType())) {
                    throw new DataspaceException("Incompatible data type. Character or binary types are allowed only.");
                }
                if (this.nodes[0] instanceof FunctionCustom && (((FunctionCustom)this.nodes[0]).funcType == 106 || ((FunctionCustom)this.nodes[0]).funcType == 231)) {
                    if (((FunctionCustom)this.nodes[0]).dataType == Type.SQL_BLOB) {
                        ((FunctionCustom)this.nodes[0]).dataType = Type.SQL_VARBINARY;
                    } else if (((FunctionCustom)this.nodes[0]).dataType == Type.SQL_CLOB) {
                        ((FunctionCustom)this.nodes[0]).dataType = Type.STRING;
                    }
                }
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    this.nodes[1].resolveTypes(session, this);
                    if (this.funcType == 162 && this.nodes[1].getDataType() != null && !this.nodes[1].getDataType().isCharacterType()) {
                        throw new DataspaceException("Incompatible data type. Character type allowed only for semantic type.");
                    }
                }
                this.dataType = Type.OTHER;
                if (parent == null) return;
                if (parent instanceof FunctionSQLInvoked) {
                    Type parentDataType;
                    RplScript rplScript;
                    int n;
                    int n2 = -1;
                    if (parent.nodes != null) {
                        for (int i = 0; i < this.nodes.length; ++i) {
                            if (parent.nodes[i] != this) continue;
                            n = i;
                            break;
                        }
                    }
                    if (n == -1 || ((FunctionSQLInvoked)parent).routineSchema == null || ((FunctionSQLInvoked)parent).routineSchema.routines == null || ((FunctionSQLInvoked)parent).routineSchema.routines.length <= 0 || (rplScript = ((FunctionSQLInvoked)parent).routineSchema.routines[0]) == null || rplScript.parameterTypes == null || rplScript.parameterTypes.length <= n || !((parentDataType = rplScript.parameterTypes[n]) instanceof OtherType) && !(parentDataType instanceof ArrayType)) return;
                    this.dataType = parentDataType;
                    return;
                }
                Type type = parent.getDataType();
                if (!(type instanceof OtherType)) return;
                this.dataType = type;
                return;
            }
            case 175: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.OTHER;
                return;
            }
            case 174: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.SQL_VARBINARY;
                return;
            }
            case 176: {
                this.nodes[0].resolveTypes(session, this);
                this.dataType = Type.STRING;
                return;
            }
            case 177: {
                this.nodes[0].resolveTypes(session, this);
                if (!(this.nodes[1].valueData instanceof Number) || !(this.nodes[2].valueData instanceof Number)) {
                    throw new DataspaceException("Invalid parameters are passed to 'toDecimal' function.");
                }
                int n = ((Number)this.nodes[1].valueData).intValue();
                int scale = ((Number)this.nodes[2].valueData).intValue();
                this.dataType = Type.getType(3, null, null, n, scale);
                return;
            }
            case 110: 
            case 126: {
                Number number;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (number = (Number)this.nodes[1].getValue(session)) == null) return;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(number.longValue());
                return;
            }
            case 113: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = ((ArrayType)this.nodes[1].dataType).collectionBaseType();
                }
                if (((ArrayType)this.nodes[1].dataType).collectionBaseType().typeComparisonGroup != this.nodes[0].dataType.typeComparisonGroup) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[2].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 136: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(338), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(401), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 179: {
                this.nodes[0].resolveTypes(session, this);
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    this.nodes[1].resolveTypes(session, this);
                }
                this.dataType = Type.STRING;
                return;
            }
            case 178: 
            case 241: {
                this.dataType = Type.STRING;
                return;
            }
            case 181: 
            case 235: 
            case 236: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 180: {
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 215: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARBINARY;
                return;
            }
            case 227: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = Type.STRING;
                if (this.dataType.isCharacterType() || this.dataType.isBinaryType()) return;
                throw Error.error(5561);
            }
            case 228: 
            case 230: {
                this.dataType = Type.STRING;
                return;
            }
            case 240: {
                if (this.nodes[2] == null || this.nodes[2].dataType.isNumberType()) {
                    this.dataType = Type.SQL_DATE;
                    return;
                }
                this.dataType = new ArrayType(Type.SQL_DATE, -1);
                return;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuffer sb = new StringBuffer("locate").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 110: 
            case 126: {
                StringBuffer sb = new StringBuffer(this.name);
                sb.append("(").append(this.nodes[0].getSQL());
                sb.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(",").append(this.nodes[2].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 113: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL()).append(' ').append("IN");
                sb.append(' ').append(this.nodes[1].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    sb.append(' ').append("FROM");
                    sb.append(' ').append(this.nodes[2].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 136: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    sb.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 430) {
                    sb.append(' ').append("NULLS").append(' ');
                    sb.append("LAST");
                }
                sb.append(')');
                return sb.toString();
            }
            case 72: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 112: 
            case 130: 
            case 131: 
            case 132: 
            case 144: 
            case 149: 
            case 150: 
            case 151: 
            case 178: 
            case 180: 
            case 200: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 142: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("timestampAdd").append("(").append(token).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 143: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("timestampDiff").append("(").append(token).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 115: 
            case 154: 
            case 155: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                if (this.nodes[0] != null) {
                    sb.append(this.nodes[0].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 106: 
            case 231: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (this.nodes[1] != null) {
                    sb.append(',').append(this.nodes[1].getSQL());
                }
                if (this.nodes[2] != null) {
                    sb.append(',').append(this.nodes[2].getSQL());
                }
                if (this.nodes[3] != null) {
                    sb.append(',').append(this.nodes[3].getSQL());
                }
                if (this.nodes.length > 4 && this.nodes[4] != null) {
                    sb.append(',').append(this.nodes[4].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 182: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (this.nodes[1] != null) {
                    sb.append(',').append(this.nodes[1].getSQL());
                }
                if (this.nodes[2] != null) {
                    sb.append(',').append(this.nodes[2].getSQL());
                }
                if (this.nodes[3] != null) {
                    sb.append(',').append(this.nodes[3].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 183: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                sb.append(',').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(',').append(this.nodes[2].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 124: 
            case 147: 
            case 152: 
            case 153: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 179: 
            case 184: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    sb.append(',').append(this.nodes[1].getSQL());
                }
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    sb.append(',').append(this.nodes[2].getSQL());
                }
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    sb.append(',').append(this.nodes[3].getSQL());
                }
                if (this.nodes.length > 4 && this.nodes[4] != null) {
                    sb.append(',').append(this.nodes[4].getSQL());
                }
                if (this.nodes.length > 5 && this.nodes[5] != null) {
                    sb.append(',').append(this.nodes[5].getSQL());
                }
                if (this.nodes.length > 6 && this.nodes[6] != null) {
                    sb.append(',').append(this.nodes[6].getSQL());
                }
                if (this.nodes.length > 7 && this.nodes[7] != null) {
                    sb.append(',').append(this.nodes[7].getSQL());
                }
                if (this.nodes.length > 8 && this.nodes[8] != null) {
                    sb.append(',').append(this.nodes[8].getSQL());
                }
                if (this.nodes.length > 9 && this.nodes[9] != null) {
                    sb.append(',').append(this.nodes[9].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 169: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL()).append(",");
                sb.append(this.nodes[1].getSQL()).append(",");
                sb.append(this.nodes[2].getSQL());
                if (this.nodes[3] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                } else {
                    sb.append(",").append("null");
                }
                if (this.nodes[4] != null) {
                    sb.append(",").append(this.nodes[4].getSQL());
                } else {
                    sb.append(",").append("null");
                }
                if (this.nodes[5] != null) {
                    sb.append(",").append(this.nodes[5].getSQL());
                }
                if (this.nodes[6] != null) {
                    sb.append(",").append(this.nodes[6].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 170: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL()).append(",");
                sb.append(this.nodes[1].getSQL()).append(",");
                sb.append(this.nodes[2].getSQL());
                if (this.nodes[3] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 171: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL()).append(",");
                sb.append(this.nodes[1].getSQL()).append(",");
                sb.append(this.nodes[2].getSQL());
                if (this.nodes[3] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                }
                if (this.nodes[4] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 172: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL()).append(",");
                sb.append(this.nodes[1].getSQL());
                sb.append(')');
                return sb.toString();
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 82: 
            case 84: 
            case 85: 
            case 94: 
            case 95: 
            case 98: 
            case 107: 
            case 109: 
            case 114: 
            case 116: 
            case 122: 
            case 125: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 140: 
            case 215: 
            case 227: 
            case 234: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 97: 
            case 105: 
            case 117: 
            case 120: 
            case 123: 
            case 145: 
            case 156: 
            case 157: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 181: 
            case 229: 
            case 232: 
            case 233: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append((String)(this.nodes.length > 2 && this.nodes[2] != null ? "," + this.nodes[2].getSQL() : "")).append(')').toString();
            }
            case 146: 
            case 148: 
            case 216: {
                StringBuffer sb = new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL());
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    sb.append(",").append(this.nodes[1].getSQL()).append(')').toString();
                }
                return sb.toString();
            }
            case 118: 
            case 119: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 96: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append("ROW_COUNT");
                sb.append(')');
                return sb.toString();
            }
            case 121: 
            case 129: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(')').toString();
            }
            case 201: 
            case 202: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: {
                StringBuilder builder = new StringBuilder();
                builder.append(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    builder.append(",").append(this.nodes[2].getSQL());
                }
                builder.append(')');
                return builder.toString();
            }
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 228: 
            case 230: {
                StringBuilder builder = new StringBuilder();
                builder.append(this.name).append('(').append(this.nodes[0].getSQL());
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    builder.append(",").append(this.nodes[1].getSQL());
                }
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    builder.append(",").append(this.nodes[2].getSQL());
                }
                builder.append(')');
                return builder.toString();
            }
            case 165: 
            case 168: {
                StringBuffer buffer = new StringBuffer(this.name);
                buffer.append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 2 && this.nodes[2] != null) {
                    if (this.funcType == 165) {
                        buffer.append(Tokens.getQGramString(((Number)this.nodes[2].valueData).intValue())).append(",");
                        buffer.append(Tokens.getQGramString(((Number)this.nodes[3].valueData).intValue())).append(",");
                        buffer.append(this.nodes[4].getSQL());
                    } else {
                        for (int i = 2; i < this.nodes.length; ++i) {
                            buffer.append(",").append(this.nodes[i].getSQL());
                        }
                    }
                }
                buffer.append(')');
                return buffer.toString();
            }
        }
        return super.getSQL();
    }

    public static char[] soundex(String s) {
        if (s == null) {
            return null;
        }
        s = s.toUpperCase(Locale.ENGLISH);
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return b;
    }

    int getTSIToken(String string) {
        int part;
        if ("yy".equalsIgnoreCase(string) || "year".equalsIgnoreCase(string)) {
            part = 840;
        } else if ("mm".equalsIgnoreCase(string) || "month".equalsIgnoreCase(string)) {
            part = 838;
        } else if ("dd".equalsIgnoreCase(string) || "day".equalsIgnoreCase(string)) {
            part = 836;
        } else if ("hh".equalsIgnoreCase(string) || "hour".equalsIgnoreCase(string)) {
            part = 835;
        } else if ("mi".equalsIgnoreCase(string) || "minute".equalsIgnoreCase(string)) {
            part = 834;
        } else if ("ss".equalsIgnoreCase(string) || "second".equalsIgnoreCase(string)) {
            part = 833;
        } else if ("ms".equalsIgnoreCase(string) || "millisecond".equalsIgnoreCase(string)) {
            part = 832;
        } else {
            throw Error.error(5566, string);
        }
        return part;
    }

    public static void unloadSerializers() {
        xSerializer = null;
        xSerializerPrettyPrint = null;
        jSerializer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkXSerializer() {
        if (xSerializer != null) return;
        Class<FunctionCustom> clazz = FunctionCustom.class;
        synchronized (FunctionCustom.class) {
            if (xSerializer != null) return;
            try {
                FabricContext context = DataspaceStoreManager.getContext();
                XSerializerFactory xFactory = context.getXSerializerFactory();
                ObjectMediationAliasManager aliasMgr = (ObjectMediationAliasManager)context.getSemanticAliasManager();
                xSerializer = xFactory.createSerializer("ToFromXmlFunctionSerializer", null, new StaxDriver(), context.getSystemClassLoaderChain(), aliasMgr);
                xSerializerPrettyPrint = xFactory.createSerializer("ToFromXmlFunctionSerializerPretty");
                xSerializer.mapAttribute("SemanticType", "class");
                xSerializerPrettyPrint.mapAttribute("SemanticType", "class");
            }
            catch (Exception error) {
                throw new DataspaceException("Unable to initialize XML serializer. " + error.getMessage());
            }
            return;
        }
    }

    private static JSONSerializer getJsonSerializer(JsonNotation notation, String jsonNotationLevel, boolean prettyPrint, String dateFormat, String sqlTimestampFormat, String sqlDateFormat, String sqlTimeFormat, boolean escapeHtmlCharacters) {
        JsonCustomization.Builder builder = JsonCustomization.builder().fromMap(Collections.singletonMap("level", jsonNotationLevel != null ? jsonNotationLevel.replace('+', ',') : null)).setNotation(notation).setPrettyPrint(prettyPrint).setEscapeHtmlCharacters(escapeHtmlCharacters);
        if (dateFormat != null) {
            builder.setParameter("json.date_format", dateFormat);
        }
        if (sqlTimestampFormat != null) {
            builder.setParameter("json.sqltimestamp_format", sqlTimestampFormat);
        }
        if (sqlDateFormat != null) {
            builder.setParameter("json.sqldate_format", sqlDateFormat);
        }
        if (sqlTimeFormat != null) {
            builder.setParameter("json.sqltime_format", sqlTimeFormat);
        }
        return HTTPUtils.getJsonSerializerForRest((FabricContext)DataspaceStore.getContext(), builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkJSerializer() {
        if (jSerializer != null) return;
        Class<FunctionCustom> clazz = FunctionCustom.class;
        synchronized (FunctionCustom.class) {
            if (jSerializer != null) return;
            try {
                FabricContext context = DataspaceStoreManager.getContext();
                JSerializerFactory jFactory = context.getJSerializerFactory();
                jSerializer = jFactory.createSerializer("ToFromBinaryFunctionSerializer");
            }
            catch (Exception error) {
                throw new DataspaceException("Unable to initialize binary serializer. " + error.getMessage());
            }
            return;
        }
    }

    private static /* synthetic */ String lambda$getValue$1(Object o) {
        return (String)o;
    }

    private static /* synthetic */ String lambda$getValue$0(Object o) {
        return (String)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            Object funcName;
            nonDeterministicFuncSet.add(72);
            nonDeterministicFuncSet.add(86);
            nonDeterministicFuncSet.add(87);
            nonDeterministicFuncSet.add(200);
            nonDeterministicFuncSet.add(88);
            nonDeterministicFuncSet.add(90);
            nonDeterministicFuncSet.add(99);
            nonDeterministicFuncSet.add(100);
            nonDeterministicFuncSet.add(104);
            nonDeterministicFuncSet.add(102);
            nonDeterministicFuncSet.add(103);
            nonDeterministicFuncSet.add(101);
            nonDeterministicFuncSet.add(130);
            nonDeterministicFuncSet.add(131);
            nonDeterministicFuncSet.add(132);
            nonDeterministicFuncSet.add(148);
            nonDeterministicFuncSet.add(144);
            nonDeterministicFuncSet.add(149);
            nonDeterministicFuncSet.add(150);
            nonDeterministicFuncSet.add(151);
            nonDeterministicFuncSet.add(154);
            nonDeterministicFuncSet.add(155);
            customRegularFuncMap.put("length", 7);
            customRegularFuncMap.put("bitLength", 6);
            customRegularFuncMap.put("octetLength", 8);
            customRegularFuncMap.put("lcase", 26);
            customRegularFuncMap.put("ucase", 27);
            customRegularFuncMap.put("log", 14);
            customRegularFuncMap.put("substr", 23);
            customRegularFuncMap.put("substringRegex", 118);
            customRegularFuncMap.put("substring_regex", 118);
            customRegularFuncMap.put("cryptKey", 86);
            customRegularFuncMap.put("year", 5);
            customRegularFuncMap.put("getYear", 5);
            customRegularFuncMap.put("month", 5);
            customRegularFuncMap.put("getMonth", 5);
            customRegularFuncMap.put("day", 5);
            customRegularFuncMap.put("getDay", 5);
            customRegularFuncMap.put("hour", 5);
            customRegularFuncMap.put("getHour", 5);
            customRegularFuncMap.put("minute", 5);
            customRegularFuncMap.put("getMinute", 5);
            customRegularFuncMap.put("second", 5);
            customRegularFuncMap.put("getSecond", 5);
            customRegularFuncMap.put("dayName", 5);
            customRegularFuncMap.put("getDayName", 5);
            customRegularFuncMap.put("monthName", 5);
            customRegularFuncMap.put("getMonthName", 5);
            customRegularFuncMap.put("dayOfMonth", 5);
            customRegularFuncMap.put("getDayOfMonth", 5);
            customRegularFuncMap.put("dayOfWeek", 5);
            customRegularFuncMap.put("getDayOfWeek", 5);
            customRegularFuncMap.put("dayOfYear", 5);
            customRegularFuncMap.put("getDayOfYear", 5);
            customRegularFuncMap.put("quarter", 5);
            customRegularFuncMap.put("getQuarter", 5);
            customRegularFuncMap.put("week", 5);
            customRegularFuncMap.put("getWeek", 5);
            customRegularFuncMap.put("secondsSinceMidnight", 5);
            customRegularFuncMap.put("getSecondsSinceMidnight", 5);
            customRegularFuncMap.put("ltrim", 31);
            customRegularFuncMap.put("rtrim", 31);
            customRegularFuncMap.put("left", 105);
            customRegularFuncMap.put("identity", 99);
            customRegularFuncMap.put("timestampAdd", 142);
            customRegularFuncMap.put("timestampDiff", 143);
            customRegularFuncMap.put("trunc", 152);
            customRegularFuncMap.put("truncate", 153);
            customRegularFuncMap.put("toChar", 145);
            customRegularFuncMap.put("toDateString", 145);
            customRegularFuncMap.put("toFormatString", 145);
            customRegularFuncMap.put("toNumber", 147);
            customRegularFuncMap.put("toDate", 146);
            customRegularFuncMap.put("date", 146);
            customRegularFuncMap.put("sqldate", 146);
            customRegularFuncMap.put("toTimestamp", 148);
            customRegularFuncMap.put("timestamp", 148);
            customRegularFuncMap.put("sqltimestamp", 148);
            customRegularFuncMap.put("toTime", 216);
            customRegularFuncMap.put("time", 216);
            customRegularFuncMap.put("sqltime", 216);
            customRegularFuncMap.put("locate", 1);
            customRegularFuncMap.put("insert", 32);
            customRegularFuncMap.put("reverse", 122);
            customRegularFuncMap.put("dataspace", 200);
            customRegularFuncMap.put("datastore", 87);
            customRegularFuncMap.put("isAutocommit", 100);
            customRegularFuncMap.put("isReadonlySession", 104);
            customRegularFuncMap.put("isReadonlyDataspace", 102);
            customRegularFuncMap.put("isReadonlyDataspaceFiles", 103);
            customRegularFuncMap.put("isolationLevel", 101);
            customRegularFuncMap.put("isolation_level", 101);
            customRegularFuncMap.put("sessionIsolationLevel", 131);
            customRegularFuncMap.put("getSessionIsolationLevel", 131);
            customRegularFuncMap.put("session_isolation_level", 131);
            customRegularFuncMap.put("dataspaceIsolationLevel", 88);
            customRegularFuncMap.put("getDataspaceIsolationLevel", 88);
            customRegularFuncMap.put("transactionControl", 149);
            customRegularFuncMap.put("database_isolation_level", 88);
            customRegularFuncMap.put("getTransactionControl", 149);
            customRegularFuncMap.put("timezone", 144);
            customRegularFuncMap.put("getTimeZone", 144);
            customRegularFuncMap.put("sessionTimezone", 132);
            customRegularFuncMap.put("getSessionTimeZone", 132);
            customRegularFuncMap.put("dataspaceTimezone", 90);
            customRegularFuncMap.put("getDataspaceTimezone", 90);
            customRegularFuncMap.put("dataspaceVersion", 91);
            customRegularFuncMap.put("getDataspaceVersion", 91);
            customRegularFuncMap.put("database_version", 91);
            customRegularFuncMap.put("lobId", 107);
            customRegularFuncMap.put("getLobId", 107);
            customRegularFuncMap.put("actionId", 72);
            customRegularFuncMap.put("getActionId", 72);
            customRegularFuncMap.put("transactionId", 150);
            customRegularFuncMap.put("getTransactionId", 150);
            customRegularFuncMap.put("transactionSize", 151);
            customRegularFuncMap.put("unixTimestamp", 155);
            customRegularFuncMap.put("sequenceArray", 129);
            customRegularFuncMap.put("array_sequence", 129);
            customRegularFuncMap.put("sessionId", 130);
            customRegularFuncMap.put("getSessionId", 130);
            customRegularFuncMap.put("array_position", 201);
            customRegularFuncMap.put("array_positions", 202);
            customRegularFuncMap.put("array_sort", 203);
            customRegularFuncMap.put("array_ndims", 204);
            customRegularFuncMap.put("array_dims", 205);
            customRegularFuncMap.put("array_length", 206);
            customRegularFuncMap.put("array_lower", 207);
            customRegularFuncMap.put("array_upper", 208);
            customRegularFuncMap.put("array_append", 209);
            customRegularFuncMap.put("array_prepend", 210);
            customRegularFuncMap.put("array_cat", 211);
            customRegularFuncMap.put("array_remove", 212);
            customRegularFuncMap.put("array_replace", 213);
            customRegularFuncMap.put("array_to_string", 214);
            customRegularFuncMap.put("acos", 71);
            customRegularFuncMap.put("asin", 74);
            customRegularFuncMap.put("atan", 75);
            customRegularFuncMap.put("atan2", 76);
            customRegularFuncMap.put("cos", 84);
            customRegularFuncMap.put("cot", 85);
            customRegularFuncMap.put("degrees", 95);
            customRegularFuncMap.put("log10", 109);
            customRegularFuncMap.put("pi", 112);
            customRegularFuncMap.put("radians", 114);
            customRegularFuncMap.put("rand", 115);
            customRegularFuncMap.put("round", 124);
            customRegularFuncMap.put("matches", 117);
            customRegularFuncMap.put("sign", 133);
            customRegularFuncMap.put("sin", 134);
            customRegularFuncMap.put("tan", 140);
            customRegularFuncMap.put("bitand", 77);
            customRegularFuncMap.put("bitor", 80);
            customRegularFuncMap.put("bitxor", 81);
            customRegularFuncMap.put("roundMagic", 125);
            customRegularFuncMap.put("ascii", 73);
            customRegularFuncMap.put("char", 82);
            customRegularFuncMap.put("chr", 82);
            customRegularFuncMap.put("concat", 83);
            customRegularFuncMap.put("difference", 97);
            customRegularFuncMap.put("hexToRaw", 98);
            customRegularFuncMap.put("rawToHex", 116);
            customRegularFuncMap.put("repeat", 120);
            customRegularFuncMap.put("replace", 121);
            customRegularFuncMap.put("right", 123);
            customRegularFuncMap.put("soundex", 135);
            customRegularFuncMap.put("space", 137);
            customRegularFuncMap.put("dateAdd", 92);
            customRegularFuncMap.put("dateDiff", 93);
            customRegularFuncMap.put("diagnostics", 96);
            customRegularFuncMap.put("days", 94);
            customRegularFuncMap.put("lpad", 110);
            customRegularFuncMap.put("rpad", 126);
            customRegularFuncMap.put("uuid", 154);
            customRegularFuncMap.put("readFile", 106);
            customRegularFuncMap.put("read_file", 106);
            customRegularFuncMap.put("readLines", 231);
            customRegularFuncMap.put("read_lines", 231);
            customRegularFuncMap.put("writeFile", 158);
            customRegularFuncMap.put("write_file", 158);
            customRegularFuncMap.put("linkFile", 182);
            customRegularFuncMap.put("toFlob", 183);
            customRegularFuncMap.put("createFile", 169);
            customRegularFuncMap.put("appendFile", 170);
            customRegularFuncMap.put("getFile", 171);
            customRegularFuncMap.put("deleteFile", 172);
            customRegularFuncMap.put("create_file", 169);
            customRegularFuncMap.put("append_file", 170);
            customRegularFuncMap.put("get_file", 171);
            customRegularFuncMap.put("delete_file", 172);
            customRegularFuncMap.put("toXML", 159);
            customRegularFuncMap.put("toJSON", 160);
            customRegularFuncMap.put("toBinary", 174);
            customRegularFuncMap.put("fromXML", 161);
            customRegularFuncMap.put("fromJSON", 162);
            customRegularFuncMap.put("fromBinary", 175);
            customRegularFuncMap.put("toHTML", 184);
            customRegularFuncMap.put("toUrl", 185);
            customRegularFuncMap.put("toDataFrame", 186);
            customRegularFuncMap.put("toFlobInfo", 217);
            customRegularFuncMap.put("validateFlob", 237);
            customRegularFuncMap.put("invalidateFlob", 238);
            customRegularFuncMap.put("isFlobValid", 239);
            customRegularFuncMap.put("toDropBoxUrl", 218);
            customRegularFuncMap.put("htmlToJSON", 221);
            customRegularFuncMap.put("htmlTableToRowSet", 226);
            customRegularFuncMap.put("htmlToDocument", 222);
            customRegularFuncMap.put("htmlFragmentToDocument", 223);
            customRegularFuncMap.put("htmlSelectFirst", 224);
            customRegularFuncMap.put("htmlSelect", 225);
            customRegularFuncMap.put("findNearest", 219);
            customRegularFuncMap.put("find_nearest", 219);
            customRegularFuncMap.put("calculateSimilarity", 220);
            customRegularFuncMap.put("calculate_similarity", 220);
            customRegularFuncMap.put("levenshtein", 163);
            customRegularFuncMap.put("entity_name", 164);
            customRegularFuncMap.put("qgram", 165);
            customRegularFuncMap.put("metaphone", 166);
            customRegularFuncMap.put("jaro_winkler", 167);
            customRegularFuncMap.put("weighted_levenshtein", 168);
            customRegularFuncMap.put("spath", 156);
            customRegularFuncMap.put("rpath", 229);
            customRegularFuncMap.put("has_spath", 232);
            customRegularFuncMap.put("has_rpath", 233);
            customRegularFuncMap.put("hasSpath", 232);
            customRegularFuncMap.put("hasRpath", 233);
            customRegularFuncMap.put("getBoolean", 156);
            customRegularFuncMap.put("getString", 156);
            customRegularFuncMap.put("getObject", 156);
            customRegularFuncMap.put("getInteger", 156);
            customRegularFuncMap.put("getBigDecimal", 156);
            customRegularFuncMap.put("getDecimal", 156);
            customRegularFuncMap.put("getDouble", 156);
            customRegularFuncMap.put("getLong", 156);
            customRegularFuncMap.put("getTime", 156);
            customRegularFuncMap.put("getDate", 156);
            customRegularFuncMap.put("getTimestamp", 156);
            customRegularFuncMap.put("tokenize", 157);
            customRegularFuncMap.put("guid", 178);
            customRegularFuncMap.put("toCurrency", 179);
            customRegularFuncMap.put("getCurrentDatetime", 180);
            customRegularFuncMap.put("currentDatetime", 180);
            customRegularFuncMap.put("current_datetime", 180);
            customRegularFuncMap.put("nextDay", 240);
            customRegularFuncMap.put("weekDay", 241);
            customRegularFuncMap.put("next_day", 240);
            customRegularFuncMap.put("week_day", 241);
            customRegularFuncMap.put("future", 181);
            customRegularFuncMap.put("sleep", 234);
            customRegularFuncMap.put("toString", 176);
            customRegularFuncMap.put("toDecimal", 177);
            customRegularFuncMap.put("base64decode", 215);
            customRegularFuncMap.put("base64encode", 227);
            customRegularFuncMap.put("extractText", 228);
            customRegularFuncMap.put("extractTextAsJSON", 230);
            customRegularFuncMap.put("inDomain", 235);
            customRegularFuncMap.put("inRange", 236);
            customRegularFuncMap.put("today", 43);
            customRegularFuncMap.put("curtime", 51);
            customValueFuncMap.put("curdate", 43);
            customValueFuncMap.put("sysDate", 52);
            customValueFuncMap.put("now", 52);
            Iterator iter = customRegularFuncMap.keySet().iterator();
            while (iter.hasNext()) {
                functionNames.add((String)iter.next());
            }
            iter = customRegularFuncMap.keySet().iterator();
            while (iter.hasNext()) {
                funcName = (String)iter.next();
                customRegularFuncMap.put(((String)funcName).toUpperCase(), customRegularFuncMap.get(funcName));
            }
            iter = customValueFuncMap.keySet().iterator();
            while (iter.hasNext()) {
                functionNames.add((String)iter.next());
            }
            FunctionCustom.addSystemEmbeddedFunctions(functionNames);
            iter = customValueFuncMap.keySet().iterator();
            while (iter.hasNext()) {
                funcName = (String)iter.next();
                customValueFuncMap.put(((String)funcName).toUpperCase(), customValueFuncMap.get(funcName));
            }
            funcName = functionNames;
            synchronized (funcName) {
                Collections.sort(functionNames);
            }
            try {
                String name;
                customFunctions.add("length", 7, Type.SQL_BIGINT).argument("value", Type.STRING, Type.SQL_VARBINARY).description("Returns chars count.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("bitLength", 6, Type.SQL_BIGINT).argument("value", Type.STRING, Type.SQL_VARBINARY).description("Returns bits count.");
                customFunctions.add("octetLength", 8, Type.SQL_BIGINT).argument("value", Type.STRING, Type.SQL_VARBINARY).description("Returns octets count.");
                customFunctions.add("lcase", 26, Type.STRING).argument("value", Type.STRING).description("Returns input string in lowercase.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("ucase", 27, Type.STRING).argument("value", Type.STRING).description("Returns input string in uppercase.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("log", 14, Type.SQL_DOUBLE).argument("value", Type.SQL_DOUBLE).description("Returns the natural logarithm of the argument, as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("substr", 23, Type.STRING).argument("value", Type.STRING).argument("offset", Type.SQL_INTEGER).optional("length", Type.SQL_INTEGER).description("Returns a CHAR string that consists of length characters from a supplied string starting at the offset position.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("substringRegex", 118, Type.STRING).alias("substring_regex").argument("value", Type.STRING).argument("regexp", Type.STRING).description("Returns first subsequence in specified value that matches to specified regexp. Returns null if no  matches found.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("cryptKey", 86, Type.STRING).argument("algorithm", Type.STRING).argument("provider", Type.STRING).description("Returns hex sevret key generated with specified algorithm and provider.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                String extractDescription = "It returns a field or element from the extract source parameter that is a DATETIME or its interval expression.\nThe return value type is BIGINT for most of the options and translates to equivalent Java type.";
                customFunctions.add("year", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getYear", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("month", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getMonth", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("day", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getDay", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("hour", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getHour", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("minute", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getMinute", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("second", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getSecond", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("dayName", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getDayName", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("monthName", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getMonthName", 5, Type.STRING).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("dayOfMonth", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getDayOfMonth", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("dayOfWeek", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getDayOfWeek", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("dayOfYear", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getDayOfYear", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("quarter", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getQuarter", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("week", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getWeek", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("secondsSinceMidnight", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("getSecondsSinceMidnight", 5, Type.SQL_BIGINT).argument("value", Type.SQL_DATE).description(extractDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("ltrim", 31, Type.STRING).argument("value", Type.STRING).description("Returns a CHAR string based on the string argument with leading space characters removed.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("rtrim", 31, Type.STRING).argument("value", Type.STRING).description("Returns a CHAR string based on the string argument with trailing space characters removed.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("left", 105, Type.STRING).optional("str", Type.STRING).optional("count", Type.SQL_INTEGER).description("Returns a substring of input str as leading 'count' characters.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("right", 123, Type.STRING).optional("str", Type.STRING).optional("count", Type.SQL_INTEGER).description("Returns a substring of input str as trailing 'count' characters.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("identity", 99, Type.SQL_BIGINT).description("Returns the last IDENTITY value inserted into a row by the current session.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("timestampAdd", 142, Type.SQL_DATE).argument("unit", 831, 832, 833, 834, 835, 836, 837, 838, 839, 840).argument("interval", Type.SQL_BIGINT).argument("date", Type.SQL_DATE).description("Adds specified interval in specified units to the input date. New date is returned.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("timestampDiff", 143, Type.SQL_BIGINT).argument("unit", 831, 832, 833, 834, 835, 836, 837, 838, 839, 840).argument("timestamp1", Type.SQL_TIMESTAMP).argument("timestamp2", Type.SQL_TIMESTAMP).description("Returns diff between specified timestamp in specified units.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("trunc", 152, Type.SQL_DECIMAL).argument("value", Type.SQL_DECIMAL, Type.SQL_DATE).optional("interval", Type.SQL_DECIMAL, Type.STRING).description("Returns a value in the same type as first numeric argument but may reduce the scale of DECIMAL and NUMERIC values.\nThe value is rounded by replacing digits with zeros from second INTEGER argument places right of the decimal point to the end.\nIf second argument is negative, ABS( NUMERIC ) digits to left of the decimal point and all digits to the right of the decimal points are replaced with zeros.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("truncate", 153, Type.SQL_DECIMAL).argument("value", Type.SQL_DECIMAL).optional("interval", Type.SQL_DECIMAL).description("Returns a value in the same type as first numeric argument but may reduce the scale of DECIMAL and NUMERIC values.\nThe value is rounded by replacing digits with zeros from second INTEGER argument places right of the decimal point to the end.\nIf second argument is negative, ABS( NUMERIC ) digits to left of the decimal point and all digits to the right of the decimal points are replaced with zeros.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                String toDateFormatDescription = "Mask Patterns\n\n   AM | A.M       Instructs the date processor to recognize AM/PM designations in strings\n   PM | P.M.\n   BC | B.C. |    Instructs date processor to handle AD for common era and BC for before common era\n   AD | A.D.\n   RRRR           4-digit year\n   YYYY           4-digit year\n   IYYY           4-digit year, corresponding to ISO week of the year.\n                  The reported year for the last few days of the calendar year may be the next year.\n   YY             2 digit year\n   IY             2 digit year, corresponding to ISO week of the year\n   MM             Month (01-12)\n   MON            Short three-letter name of month\n   MONTH          Name of month\n   WW             Week of year (1-53) where week 1 starts on the first day of the year and \n                  continues to the seventh day of the year (not a calendar week).\n   W              Week of month (1-5) where week 1 starts on the first day of the month and ends on the seventh\n                  (not a calendar week)\n   IW             Week of year (1-52 or 1-53) based on the ISO standard. Week starts on Monday.\n                  The first week may start near the end of previous year.\n   DAY            Name of day.\n   DD             Day of month (01-31).\n   DDD            Day of year (1-366).\n   DY             Short three-letter name of day.\n   HH             Hour of day (01-12).\n   HH12           Hour of day (00-11).\n   HH24           Hour of day (00-23).\n   MI             Minute (00-59).\n   SS             Second (00-59).\n   FF             Fractional seconds.\n\nDefault dataspace formats:\n\n  SQLDATE         'YYYY-MM-DD'\n  SQLTIME         'HH:MI:SS'\n  SQLTIMESTAMP    'YYYY-MM-DD HH:MI:SS.FFF'\n  SQLTIMESTAMP    'YYYY-MM-DD\"T\"HH:MI:SS'\n";
                String dateFunctionGenericDoc = "This function translates SQLDATE, SQLTIME, SQLTIMESTAMP, DATE or a formatted string representing \na date and/or time in the first argument into the appropriate resulting type as indicated by the \nRETURNS parameter.\n\nThe second argument provides a mask format that describes the source date in the first argument.\nThe format string can contain pattern elements as described below, as well as punctuation and \nspace characters.\n\nPatterns should contain all the necessary fields to construct the resulting type, including, year, \nmonth, day of month, hour, minute, etc.\n\nThe returned results can be cast into SQL and non-SQL types such as SQLDATE, SQLTIME, DATE\nor SQLTIMSTAMP using in-line casting operators.  For example:\n\ndate dt = (date) toDate(now());\n\ndate dt = (date)  sqltimestamp('2020-12-12 12:03:04 PM', 'YYYY-MM-DD HH:MI:SS PM') \n\nDate patterns are particularly useful when converting string representations of dates.  Since\nthere is a variety of input formats that may not conform to SQL types, such as ISO Date Format\ntypically found in JSON and object databases, XML, DOM, Unix dates or the implicit DATE type\nthat is based on Java dates; format masks may be used to easily parse any date string into a\nusable structured format.\n\nThe implicit DATE is based on the Java Date and may be used to perform Calendar computations\nor Formatter operations useful for displaying complex, human-readable date formats.  SQL types\nare useful for performing date arithmetic, range searches on indexed dates and Scalar Function\noperations on collections and Snapshot Tables.\n\n" + toDateFormatDescription + "\n\nNote that SQLTIMESTAMP types will not automatically process AM/PM directives\nunless specified by the mask.  Hence 1:00 PM will be seen as 1:00 AM by default\nand 13:00 will be processed as 1:00 PM.\n\nAlso Unix milliseconds timestamps are supported. They should be 13-16 digits: xxxxxxxxxx.xxxxxx or xxxxxxxxxxxxxxxx\n\n    select toTimestamp(1424219014.726414)\n    select toTimestamp(1424219014.726)\n    select toTimestamp(1424219014726)\n    select toTimestamp(1424219014726414)";
                customFunctions.add("toChar", 145, Type.STRING).alias("toFormatString").argument("value", Type.SQL_DATE, Type.SQL_TIME, Type.SQL_TIMESTAMP, Type.SQL_NUMERIC).argument("format", Type.STRING).description("This function formats a DATE, SQLDATE, SQLTIME or SQLTIMESTAMP or NUMERIC value to the format\ngiven in the second argument.\n\nThe format string can contain pattern elements from the list given below, including punctuation and\nspace characters.\n\nNumber Format Pattern\n\n  Symbol  Location            Localized?  Meaning\n  0       Number              Yes         Prints a digit if provided, 0 otherwise\n  #       Number              Yes         Prints a digit if provided, nothing otherwise\n  .       Number              Yes         Indicates where  to put decimal separator\n  -       Number              Yes         Minus sign\n  ,       Number              Yes         Indicates where to put group separator\n  E       Number              Yes         Separates mantissa and exponent in scientific notation. Need not be quoted in prefix or suffix.\n  ;       Subpattern boundary Yes         Separates positive and negative subpatterns\n  %       Prefix or suffix    Yes         Multiply by 100 and show as percentage\n \\u2030  Prefix or suffix    Yes         Multiply by 1000 and show as per mille value\n \\u00A4  Prefix or suffix    No          Currency sign, replaced by currency symbol. If doubled, replaced by international currency symbol. If present in a\n                                          pattern, the monetary decimal separator is used instead of the decimal separator.\n  '       Prefix or suffix    No          Used to quote special characters in a prefix or suffix, for example, \"'#'#\" formats 123 to \"#123\". To create a\n                                          single quote itself, use two in a row: \"# o''clock\".\nSample patterns:\n\n  #.##\n  0.00\n  #,###.#\n  #,###\n  00.#######E0\n  ##0.######E0\n\n" + toDateFormatDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("toDateString", 145, Type.STRING).argument("value", Type.SQL_DATE, Type.SQL_TIME, Type.SQL_TIMESTAMP).argument("format", Type.STRING).description("This function formats a DATE, SQLDATE, SQLTIME or SQLTIMESTAMP value to the format\ngiven in the second argument.\n\nThe format string can contain pattern elements from the list given below, including punctuation and\nspace characters.\n\n" + toDateFormatDescription).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("toNumber", 147, Type.SQL_DECIMAL).argument("value", Type.STRING).description("Converts specified string to number.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("toDate", 146, Type.SQL_DATE).alias("date", "sqldate").argument("value", Type.STRING, Type.SQL_DATE, Type.SQL_TIMESTAMP, new OtherType("DATE", Date.class)).optional("format", Type.STRING).description(dateFunctionGenericDoc).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("toTimestamp", 148, Type.SQL_TIMESTAMP).alias("timestamp", "sqltimestamp").argument("value", Type.STRING, Type.SQL_TIMESTAMP, Type.SQL_NUMERIC, new OtherType("DATE", Date.class)).optional("format", Type.STRING).description(dateFunctionGenericDoc).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("toTime", 216, Type.SQL_TIME).alias("time", "sqltime").argument("value", Type.STRING, Type.SQL_TIMESTAMP, Type.SQL_TIME, new OtherType("DATE", Date.class)).optional("format", Type.STRING).description(dateFunctionGenericDoc).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("locate", 1, Type.SQL_DECIMAL).argument("substr", Type.STRING, Type.SQL_CLOB, Type.SQL_BINARY).argument("str", Type.STRING, Type.SQL_CLOB, Type.SQL_BINARY).optional("offset", Type.SQL_DECIMAL).description("Analyzes the second string an returns as BIGINT location of the starting position for the first occurrence of the first string (if exists).\nIf offset is specified, the search begins at that position.\nIf locate is not successful a 0 is returned.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("insert", 32, Type.STRING).argument("firstString", Type.STRING, Type.SQL_VARBINARY).argument("offset", Type.SQL_INTEGER).argument("length", Type.SQL_INTEGER).argument("secondString", Type.STRING, Type.SQL_VARBINARY).description("Inserts some characters at offset where a number of characters for specific length have been removed.\nReturns a character string based on character value in which length characters have been removed at the offset position and in their place, the second character value is copied.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("reverse", 122, Type.STRING).argument("str", Type.STRING).description("Returns a CHAR string that is in reverse order of the string supplied.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("dataspace", 200, Type.STRING).description("Returns current database path.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("datastore", 87, Type.STRING).description("Returns current dataspace path.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("isAutocommit", 100, Type.SQL_BOOLEAN).description("Returns TRUE if the session is in autocommit mode.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("isReadonlySession", 104, Type.SQL_BOOLEAN).description("Returns TRUE if the session is in read only mode.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("isReadonlyDataspace", 102, Type.SQL_BOOLEAN).description("Returns TRUE if the database is in read only mode.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("isReadonlyDataspaceFiles", 103, Type.SQL_BOOLEAN).description("Returns TRUE if the database files is in read only mode.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("isolationLevel", 101, Type.STRING).alias("isolation_level").description("Returns the current transaction isolation level for the session.\nReturns levels such as READ COMMITTED, REPEATABLE READ or SERIALIZABLE as a STRING.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("sessionIsolationLevel", 131, Type.STRING).alias("getSessionIsolationLevel", "session_isolation_level").description("Returns the default transaction isolation level for the current session.\nReturns values such as READ COMMITTED or SERIALIZABLE as a STRING.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("dataspaceIsolationLevel", 88, Type.STRING).alias("getDataspaceIsolationLevel", "database_isolation_level").description("Returns the default transaction isolation level for the current database.\nReturns values such as READ COMMITTED or SERIALIZABLE as a STRING.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("transactionControl", 149, Type.STRING).alias("getTransactionControl").description("Returns the current transaction model for the database. Returns LOCKS, MVLOCKS or MVCC as a string.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("timezone", 144, Type.SQL_INTERVAL_HOUR_TO_MINUTE).alias("getTimeZone").description("Returns the current time zone for the session. Returns an INTERVAL HOUR TO MINUTE value.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("sessionTimezone", 132, Type.SQL_INTERVAL_HOUR_TO_MINUTE).alias("getSessionTimeZone").description("Returns the default time zone for the current session. Returns an INTERVAL HOUR TO MINUTE value.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("dataspaceTimezone", 90, Type.SQL_INTERVAL_HOUR_TO_MINUTE).alias("getDataspaceTimezone").description("Returns the default time zone for the current dataspace. Returns an INTERVAL HOUR TO MINUTE value.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("dataspaceVersion", 91, Type.STRING).alias("getDataspaceVersion", "database_version").description("Returns a full version string for the service engine database.");
                customFunctions.add("lobId", 107, Type.SQL_BIGINT).alias("getLobId").argument("value", Type.SQL_CLOB, Type.SQL_BLOB).description("Returns lob ID.");
                customFunctions.add("actionId", 72, Type.SQL_BIGINT).alias("getActionId").description("Returns the current action ID for the session as a BIGINT value.\nThe database maintains a global incremental id which is allocated to new transactions and new actions (statement executions) in different sessions.\nThis value is unique to the current action.");
                customFunctions.add("transactionId", 150, Type.SQL_BIGINT).alias("getTransactionId").description("Returns the current transaction ID for the session as a BIGINT value.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("transactionSize", 151, Type.SQL_BIGINT).description("Returns the row change count for the current transaction.\nEach row change represents a row INSERT or a row DELETE operation.\nThere will be a pair of row change operations for each row that is updated.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("unixTimestamp", 155, Type.SQL_BIGINT).optional("value", Type.SQL_DATE, Type.SQL_TIMESTAMP).description("This function returns a BIGINT value. With no parameter, it returns the number of seconds since 1970-01-01.\nWith a DATE or TIMESTAMP parameter, it converts the argument into number of seconds since 1970-01-01.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("sequenceArray", 129, new ArrayType(Type.SQL_NUMERIC, -1)).alias("array_sequence").argument("lowerBound", Type.SQL_INTEGER).argument("upperBound", Type.SQL_INTEGER).argument("increment", Type.SQL_NUMERIC).description("Returns a new ARRAY that contains a sequence of values. The first argument is the lower bound of the range.\nThe second argument is the upper bound of the range. The third value is the increment.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_position", 201, Type.SQL_INTEGER).argument("array", Type.SQL_ARRAY_ALL_TYPES).argument("element", Type.SQL_ALL_TYPES).optional("increment", Type.SQL_NUMERIC).description("Returns the index of the first occurrence of the specified element in the array, starting at the element indicated by the third argument or at the first element (array must be one-dimensional). If not found 0 is returned.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_positions", 202, new ArrayType(Type.SQL_INTEGER, -1)).argument("array", Type.SQL_ARRAY_ALL_TYPES).argument("element", Type.SQL_ALL_TYPES).optional("increment", Type.SQL_NUMERIC).description("Returns an array of positions of all occurrences of the specified element in the array, starting at the element indicated by the third argument or at the first element (array must be one-dimensional).").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_sort", 203, Type.SQL_ARRAY_ALL_TYPES).argument("array", Type.SQL_ARRAY_ALL_TYPES).optional("asc", Type.SQL_BOOLEAN).optional("nullsFirst", Type.SQL_BOOLEAN).description("Returns a sorted copy of the array. By default, sort is performed in ascending order and NULL elements are sorted first.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_ndims", 204, Type.SQL_INTEGER).argument("array", Type.SQL_ARRAY_ALL_TYPES).description("Returns the number of dimensions of the array.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_dims", 205, Type.STRING).argument("array", Type.SQL_ARRAY_ALL_TYPES).description("Returns a text representation of array's dimensions.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_length", 206, Type.SQL_INTEGER).argument("array", Type.SQL_ARRAY_ALL_TYPES).optional("dimension", Type.SQL_INTEGER).description("Returns the length of the requested array dimension. By default length of the first dimension is returned.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_lower", 207, Type.SQL_INTEGER).argument("array", Type.SQL_ARRAY_ALL_TYPES).optional("dimension", Type.SQL_INTEGER).description("Returns lower bound of the requested array dimension. By default dimension is 1.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_upper", 208, Type.SQL_INTEGER).argument("array", Type.SQL_ARRAY_ALL_TYPES).optional("dimension", Type.SQL_INTEGER).description("Returns upper bound of the requested array dimension. By default dimension is 1.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_append", 209, Type.SQL_ARRAY_ALL_TYPES).argument("array", Type.SQL_ARRAY_ALL_TYPES).argument("element", Type.SQL_ALL_TYPES).description("Appends an element to the end of an array and returns new array. Original array becomes unchanged.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_prepend", 210, Type.SQL_ARRAY_ALL_TYPES).argument("element", Type.SQL_ALL_TYPES).argument("array", Type.SQL_ARRAY_ALL_TYPES).description("Appends an element to thebeginning of an array and returns the new one. Original array becomes unchanged.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_cat", 211, Type.SQL_ARRAY_ALL_TYPES).argument("array1", Type.SQL_ARRAY_ALL_TYPES).argument("array2", Type.SQL_ARRAY_ALL_TYPES).description("Concatenates two arrays and returns the new one. Original arrays become unchanged.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_remove", 212, Type.SQL_ARRAY_ALL_TYPES).argument("array", Type.SQL_ARRAY_ALL_TYPES).argument("element", Type.SQL_ALL_TYPES).description("Removes all elements equal to the given value from the array (array must be one-dimensional) and returns new one. Original array becomes unchanged.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_replace", 213, Type.SQL_ARRAY_ALL_TYPES).argument("array", Type.SQL_ARRAY_ALL_TYPES).argument("oldElement", Type.SQL_ALL_TYPES).argument("newElement", Type.SQL_ALL_TYPES).description("Replace each array element equal to the given value with a new value and returns new one. Original array becomes unchanged.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("array_to_string", 214, Type.STRING).argument("array", Type.SQL_ARRAY_ALL_TYPES).argument("delimiter", Type.STRING).optional("nullString", Type.STRING).description("Concatenates array elements using supplied delimiter and optional null.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARRAY);
                customFunctions.add("sessionId", 130, Type.SQL_BIGINT).alias("getSessionId").description("Returns the id of the session as a BIGINT value.\nSESSION ID are unique during the operational lifetime of a runtime. ID are restarted after shutdown or restart.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.SYSTEM);
                customFunctions.add("acos", 71, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Returns the arc-cosine of the argument in radians as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("asin", 74, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Returns the arc-sine of the argument in radians as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("atan", 75, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Returns the arc-tangent of the argument in radians as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("atan2", 76, Type.SQL_DOUBLE).argument("x", Type.SQL_NUMERIC).argument("y", Type.SQL_NUMERIC).description("The first and second numeric values express the x and y coordinates of a point respectively.\nThe function returns the angle, in radians, representing the angle coordinate of the point in polar coordinates, as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("cos", 84, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Returns the cosine of the argument (an angle expressed in radians) as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("cot", 85, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Returns the cotangent of the argument as a value of DOUBLE type. The numeric parameter represents an angle expressed in radians.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("degrees", 95, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Converts the argument (an angle expressed in radians) into degrees and returns the value in the DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("log10", 109, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Returns the base 10 logarithm of the argument as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("pi", 112, Type.SQL_DOUBLE).description("Returns the constant pi as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("radians", 114, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Converts the argument (an angle expressed in degrees) into radians and returns the value in the DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("rand", 115, Type.SQL_DOUBLE).optional("value", Type.SQL_INTEGER).description("Returns a random value in the DOUBLE type. The optional INTEGER is used as seed value.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("round", 124, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).optional("value", Type.SQL_NUMERIC).description("The parameters may be of the DOUBLE type or DECIMAL type.\nThe function returns a DOUBLE or DECIMAL value which is the value of the argument rounded to the second parameter\u2019s decimal places to the right of the decimal point.\nIf the second parameter INTEGER is negative, the first argument is rounded to INTEGER places to the left of the decimal point.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("matches", 117, Type.SQL_BOOLEAN).argument("value", Type.STRING).argument("regexp", Type.STRING).optional("replacement", Type.SQL_ARRAY_ALL_TYPES).description("Returns TRUE if the CHAR string matches the Regular Expression based on \nstandard REGEX rules. The third, optional parameter is an array of values \nthat may be used to dynamically construct a Regular Expression based on \npositional variable substitution value syntax like {$1}, {$2} and so forth.\n\nExamples: \nmatches('110123.5AC2.ZIP', '^\\w+\\.5AC2\\.ZIP$')\nmatches('110123.5AC2.ZIP', '^{$1}\\.{$2}AC2\\.ZIP$', array['110123', '5'])").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("sign", 133, Type.SQL_INTEGER).argument("value", Type.SQL_NUMERIC).description("Returns an INTEGER, indicating the sign of the argument.\nIf the argument is negative then -1 is returned. If it is equal to zero then 0 is returned. If the argument is positive then 1 is returned.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("sin", 134, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Returns the sine of the argument (an angle expressed in radians) as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("tan", 140, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("Returns the tangent of the argument (an angle expressed in radians) as a value of DOUBLE type.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("bitand", 77, Type.SQL_NUMERIC).argument("value1", Type.SQL_NUMERIC, Type.SQL_BIT_VARYING).argument("value2", Type.SQL_NUMERIC, Type.SQL_BIT_VARYING).description("Perform the bit operations AND on two values comparing them for equality.The values are either INTEGER values, or BIT strings.\nThe result is an INTEGER value of the same type as the arguments, or a BIT string of the same length as the argument. Each bit of the result is formed by performing the operation on corresponding bits of the arguments.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("bitor", 80, Type.SQL_NUMERIC).argument("value1", Type.SQL_NUMERIC, Type.SQL_BIT_VARYING).argument("value2", Type.SQL_NUMERIC, Type.SQL_BIT_VARYING).description("Perform the bit operations OR on two values comparing them for equality.The values are either INTEGER values, or BIT strings.\nThe result is an INTEGER value of the same type as the arguments, or a BIT string of the same length as the argument. Each bit of the result is formed by performing the operation on corresponding bits of the arguments.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("bitxor", 81, Type.SQL_NUMERIC).argument("value1", Type.SQL_NUMERIC, Type.SQL_BIT_VARYING).argument("value2", Type.SQL_NUMERIC, Type.SQL_BIT_VARYING).description("Perform the bit operations XOR on two values comparing them for equality.The values are either INTEGER values, or BIT strings.\nThe result is an INTEGER value of the same type as the arguments, or a BIT string of the same length as the argument. Each bit of the result is formed by performing the operation on corresponding bits of the arguments.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("roundMagic", 125, Type.SQL_DOUBLE).argument("value", Type.SQL_NUMERIC).description("The parameters may be of the DOUBLE type or DECIMAL type. The function returns a DOUBLE or DECIMAL value which is the value of the argument rounded to the second parameter\u2019s decimal places to the right of the decimal point.\nIf the second parameter INTEGER is negative, the first argument is rounded to INTEGER places to the left of the decimal point.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("ascii", 73, Type.SQL_INTEGER).argument("value", Type.SQL_CHAR).description("Returns an INTEGER equal to the ASCII code of the first byte of the CHAR value or expression.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.ARITHMETIC);
                customFunctions.add("char", 82, Type.SQL_CHAR).alias("chr").argument("code", Type.SQL_NUMERIC).description("Returns a single character that has the specified UNICODE, which is an integer.\nThe argument is an INTEGER. ASCII codes are a subset of the allowed values for UNICODE.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("concat", 83, Type.STRING).argument("value1", Type.STRING, Type.SQL_VARBINARY).argument("value2", Type.STRING, Type.SQL_VARBINARY).description("Returns a string formed by concatenation of the arguments. The arguments are character strings or binary strings.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("difference", 97, Type.SQL_INTEGER).argument("value1", Type.STRING).argument("value2", Type.STRING).description("Compares SOUNDEX codes of two strings, and returns an INTEGER between 0-4 which indicates how similar the two SOUNDEX value are.\nThe arguments are character strings or CHAR types. If the values are the same, it returns 4, if the values have no similarity, it returns 0. In-between values are returned for partial similarity.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("hexToRaw", 98, Type.SQL_VARBINARY).argument("value", Type.STRING).description("Returns a BINARY string formed by interpretation of supplied CHAR string as hexadecimal digits.\nEach byte of the parameter must be a valid hexadecimal value: a digit or a letter in the {A, B, C, D, E, F} set.\nEach byte of the returned binary string is formed by translating two hex digits into one byte.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("rawToHex", 116, Type.STRING).argument("value", Type.SQL_VARBINARY).description("Returns a CHAR string composed of hexadecimal digits representing the BINARY value bytes. Each byte of the BINARY value is translated into two hex digits.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("repeat", 120, Type.STRING).argument("value", Type.STRING).argument("count", Type.SQL_INTEGER).description("Returns a CHAR string based on the supplied parameter, repeated count times.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("replace", 121, Type.STRING).argument("str", Type.STRING).argument("findValue", Type.STRING).optional("replaceValue", Type.STRING).description("Replace a sub-string within a string with another value.\nReturns a CHAR string based on the first string with each occurrence of second string being replaced by the content of the third.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("soundex", 135, Type.STRING).argument("value", Type.STRING).description("Returns a four character code representing the sound of a supplied string parameter.\nThe US Census algorithm is used. For example the soundex value for Washington is W252.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("space", 137, Type.STRING).argument("value", Type.SQL_INTEGER).description("Returns a CHAR string consisting of count spaces.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("dateAdd", 92, Type.SQL_DATE).argument("option", Type.STRING).argument("value", Type.SQL_INTEGER).argument("date", Type.SQL_DATE).description("The DATEADD function is alternatives to TIMESTAMPADD, with fewer available options.\nThe options are specified as quoted strings, rather than keywords. The fields translate to YEAR, MONTH, DAY, HOUR, MINUTE, SECOND and MILLISECOND.\nOptions: { 'yy' | 'mm' | 'dd' | 'hh' | 'mi' | 'ss' | 'ms' }").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("dateDiff", 93, Type.SQL_NUMERIC).argument("option", Type.STRING).argument("date1", Type.SQL_DATE).optional("date2", Type.SQL_DATE).description("The DATEDIFF function is alternatives to TIMESTAMPDIFF, with fewer available options. The options are specified as quoted strings, rather than keywords. The fields translate to YEAR, MONTH, DAY, HOUR, MINUTE, SECOND and MILLISECOND.\nOptions: { 'yy' | 'mm' | 'dd' | 'hh' | 'mi' | 'ss' | 'ms' }").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("diagnostics", 96, Type.SQL_INTEGER).argument(495, "value", (Type[])null);
                customFunctions.add("days", 94, Type.SQL_INTEGER).argument("value", Type.SQL_DATE, Type.SQL_TIMESTAMP).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("lpad", 110, Type.STRING).argument("str1", Type.STRING).argument("length", Type.SQL_INTEGER).optional("str2", Type.STRING).description("Left padded string. Returns a CHAR string of a specified length.\nThe string contains characters of the first string padded to the left with spaces.\nIf length is smaller than the size of the argument, the argument is truncated. If the optional second string is specified, that string is used for padding, instead of spaces.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("rpad", 126, Type.STRING).argument("str1", Type.STRING).argument("length", Type.SQL_INTEGER).optional("str2", Type.STRING).description("Returns a CHAR string the size of length characters padded to the right with spaces.\nThe resulting string starts with characters of in the first string.\nIf length is smaller than the length of the string argument, the result is a truncated string. If the optional secondary string is specified, this string is used for padding, instead of spaces.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("uuid", 154, Type.SQL_VARBINARY).optional("value", Type.SQL_VARBINARY, Type.STRING).description("Without parameters, this function returns a new UUID value as a 16 byte binary value. With a UUID hexadecimal string argument, it returns the 16 byte binary value of the UUID.\nWith a 16 byte binary argument, it returns the formatted UUID character representation.");
                customFunctions.add("readFile", 106, Type.SQL_CLOB).alias("read_file").argument("filename", Type.STRING).optional("offset", Type.SQL_DECIMAL).optional("length", Type.SQL_DECIMAL).optional("charset", Type.STRING).description("Reads a file with specified name. This can be a relative path or full path if the File Setting of the data store allows full path access.\n\nNegative Offset means offset from the end of file. Length -1 means read till the end of file.\n\nIn RPL, the data type of returned value depends on left operand type. In assignment statement left operand can be one of type FLOB, STRING or VARBINARY.\nIn INSERT or UPDATE left operand can be one of type CLOB, BLOB, FLOB, STRING or VARBINARY. If there is no left operand it is supposed to be STRING, to make it BINARY charset parameter should be set to 'binary'.\nIf left operand type is CLOB or STRING and charset is not specified default session/datastore CCSID will be used. In case of FLOB assignment, file is not read during function call.\nFile will be read once the FLOB is used, for example when inserted into table or selected.\n\nFilename can specify absolute or relative path. Depending on SESSION CONTEXT set in current session the file will be read on server or client side.\nBy default all interactive sessions have session context set to CLIENT, and all internal session have session context set to SERVER.\n\n" + HelpRegistry.dropboxHelp("Filename")).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("readLines", 231, Type.SQL_CLOB).alias("read_lines").argument("filename", Type.STRING).argument("startLine", Type.SQL_DECIMAL).argument("lineCount", Type.SQL_DECIMAL).argument("charset", Type.STRING).description("Reads a file with specified name starting at startLine.This can be a relative path\nor full path if the File Setting of the data store allows full path access.\n\nLine count specifies how many lines to read in one function call. A -1 value means\nread till the end of file.\n\nIn RPL, the data type of returned value depends on left operand type. In assignment\nstatement left operand can be one of type FLOB, STRING, LIST or VARBINARY.\n\nIn INSERT or UPDATE left operand can be one of type CLOB, BLOB, FLOB, STRING,\nLIST or VARBINARY. If there is no left operand it is supposed to be STRING.\n \nIn case of FLOB assignment, the file is not read during a function call. File will be \nread once the FLOB is used, for example when inserted into table or selected.\n\nFilename can specify absolute or relative path. Depending on SESSION CONTEXT\nset in current session the file will be read on server or client side. By default all\ninteractive sessions have session context set to CLIENT, and all internal session\nhave session context set to SERVER.\n\n" + HelpRegistry.dropboxHelp("Filename")).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("linkFile", 182, Type.FLOB).argument("filename", Type.STRING).optional("charset", Type.STRING).optional("managed", Type.SQL_BOOLEAN).optional("ignore", Type.SQL_BOOLEAN).description("Links file with specified filename to FLOB column. File with specified name should be located in the location defined in target column definition.\n\nIf managed parameter set to true then flob file will be removed by the system when there is no more references to this file from flobs.\n\nIf ignore paramter set to true then file existance will not be checked.\n\nNOTE: linked file will not be removed when corresponding row removed from the table.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("toFlob", 183, Type.FLOB).argument("filename", Type.STRING).argument("data", Type.SQL_ALL_TYPES, Type.SQL_VARBINARY, Type.STRING, Type.SQL_CLOB, Type.SQL_BLOB).optional("charset", Type.STRING).description("Creates FLOB from specified filename, data and charset. FLOB data can be string, binary, clob, blob or readFile function.\nIf data is obtained from readFile function specified file will be read directly into FLOB with specified filename.\ntoFlob and readFile file functions will be executed only when its result will be inserted into table.\n" + HelpRegistry.dropboxHelp("Filename")).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("writeFile", 158, Type.SQL_BOOLEAN).alias("write_file").argument("data", Type.SQL_CLOB, Type.SQL_BLOB, Type.FLOB, Type.STRING, Type.SQL_VARBINARY).argument("filename", Type.STRING).optional("append", Type.SQL_BOOLEAN).optional("charsert", Type.STRING).description("Writes provided data to file with specified filename. If file doesn't exist new file will be created.\nIf append is true data will be appended to the file, if append is false file will be overwritten. Append option is false by default.\nIf charset is specified the data should be of CLOB or String type and file will be wrote in provided charset.\nFilename can specify absolute or relative path. Depending on session context set in current session file will be looked up on the server or client side.\nBy default all interractive sessions have session context set to CLIENT, all internal session have session context set to SERVER.\n" + HelpRegistry.dropboxHelp("Filename")).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("createFile", 169, Type.SQL_BOOLEAN).alias("create_file").argument("directory table name", Type.STRING).argument("filename", Type.STRING).argument("overwrite", Type.SQL_BOOLEAN).optional("replication", Type.SQL_INTEGER).optional("blocksize", Type.LONG).optional("local file path", Type.STRING).optional("buffer size", Type.SQL_INTEGER).description("Creates new empty file with name 'filename' in the specified directory table.\nIf 'local file path' parameter specified its content will be copied into the created file.\nParameters 'replication' and 'blocksize' are applicable for filesystems that suport replication only.\nSet these parameters to null to use default values.\nParameter 'buffer size' defines a size of buffer in bytes used to read/write data. Default value is 4Mb.\nIf function is called in SLANG session and session context set to CLIENT and session context set to CLIENT 'local file' will be read from SLANG file system, otherwise from local file system.\n" + HelpRegistry.dropboxHelp("Local file path")).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("appendFile", 170, Type.SQL_BOOLEAN).alias("append_file").argument("directory table name", Type.STRING).argument("filename", Type.STRING).argument("local file path", Type.STRING).optional("buffer size", Type.SQL_INTEGER).description("Appends 'local file' to the file 'filename' in the specified 'directory table'.\nParameter 'buffer size' defines a size of buffer in bytes used to read/write data. Default value is 4Mb.\nIf function is called in SLANG session 'local file' will be read from SLANG file system, otherwise from local file system.\n" + HelpRegistry.dropboxHelp("Local file path")).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("getFile", 171, Type.SQL_BOOLEAN).alias("get_file").argument("directory table name", Type.STRING).argument("filename", Type.STRING).argument("local file", Type.STRING).optional("overwrite", Type.SQL_BOOLEAN).optional("buffer size", Type.SQL_INTEGER).description("Gets file 'filename' from specified directory and saves it in specified 'local file'.\nIf overwrite not specified exception will be throws if 'local file' exists.\nParameter 'buffer size' defines a size of buffer in bytes used to read/write data. Default value is 4Mb.\nIf function is called in SLANG session and session context set to CLIENT 'local file' will be written to SLANG file system, otherwise to local file system.\n" + HelpRegistry.dropboxHelp("Local file")).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("deleteFile", 172, Type.SQL_BOOLEAN).alias("delete_file").argument("directory table name", Type.STRING).argument("filename", Type.STRING).description("Removes file with 'filename' from specified directory.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.FILE);
                customFunctions.add("toXML", 159, Type.STRING).argument("object", Type.OTHER).optional("prettyPrint", Type.SQL_BOOLEAN).optional("supressHeader", Type.SQL_BOOLEAN).description("Returns a XML representation OBJECT value . This function may be used in combination with DOMAIN and OBJECT types.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                String JAVA_DATE_FORMAT_SYNTAX = "Default formats for date/time serialization are configured in properties:\n     dtspace.serializer.date_format : yyyy-MM-dd'T'HH:mm:ss'Z'\n     dtspace.serializer.sqltimestamp_format : yyyy-MM-dd'T'HH:mm:ss.SSS'Z'\n     dtspace.serializer.sqldate_format : yyyy-MM-dd\n     dtspace.serializer.sqltime_format : yyyy-MM-dd HH:mm:ss.SSS\n\nDefault values can be overriden using java date format pattern in properties on function parameters:\nTimestamp format should be specified using Java date format syntax:\n\n  Letter   Date or Time Component            Presentation         Examples\n  G        Era designator                    Text                 AD\n  y        Year                              Year                 1996; 96\n  Y        Week year                         Year                 2009; 09\n  M        Month in year (context sensitive) Month                July; Jul; 07\n  L        Month in year (standalone form)   Month                July; Jul; 07\n  w        Week in year                      Number               27\n  W        Week in month                     Number               2\n  D        Day in year                       Number               189\n  d        Day in month                      Number               10\n  F        Day of week in month              Number               2\n  E        Day name in week                  Text                 Tuesday; Tue\n  u        Day number of week (1 = Monday, ) Number               1\n  a        Am/pm marker                      Text                 PM\n  H        Hour in day (0-23)                Number               0\n  k        Hour in day (1-24)                Number               24\n  K        Hour in am/pm (0-11)              Number               0\n  h        Hour in am/pm (1-12)              Number               12\n  m        Minute in hour                    Number               30\n  s        Second in minute                  Number               55\n  S        Millisecond                       Number               978\n  z        Time zone                         General time zone    Pacific Standard Time; PST; GMT-08:00\n  Z        Time zone                         RFC 822 time zone    -0800; +0800\n  X        Time zone                         ISO 8601 time zone   -08; +08; Z\n  XX       Time zone                         ISO 8601 time zone   -0800; +0800\n  XXX      Time zone                         ISO 8601 time zone   -08:00; +08:00\n\n\nBy default date and timestamp are serialized in local timezone. To append timezone name/value use z,Z or X placeholders.\nTo serialize date or timestamp in UTC timezone, append 'Z' placeholder to the end: yyyy-MM-dd'T'HH:mm:ss'Z'\n\nThe following date/timestamp formats are also used as default during date/timestamp deserialization:\n   yyyy-MM-dd'T'HH:mm:ss\n   yyyy-MM-dd'T'HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss.SSSX\n   yyyy-MM-dd'T'HH:mm:ssXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXX\n   yyyy-MM-dd'T'HH:mm:ssXXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXXX\n   yyyy-MM-dd'T'HH:mm:ss z\n   yyyy-MM-dd'T'HH:mm:ss.SSS z\n\nDefault Dataspace formats (used in dataspace queries, and displayed in console):\n   yyyy-MM-dd HH:mm:ss - date\n   MM-yyyy-dd - sqldate\n   ss:HH:mm - sqltime\n   MM-yyyy-dd HH:mm:ss.SSS - sqltimestamp\n\nOther formats:\n\n   MM/dd/yy HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss'Z'\n\nDate unit samples:\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSSXXX')\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS z')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSS''Z''')\n\n    date.fromString('2024-03-22T06:44:56.156Z')\n    date.fromString('2024-03-22T06:44:56.156+03')\n    date.fromString('2024-03-22T06:44:56.156 PST')\n\n";
                String JSON_FORMAT_DESCRIPTION = "See JsonNotation and JsonNotationLevel enumerated typed for valid values of  Json Notation and Compound JSON Directives.\n\nJsonNotation controls the way that the type meta information of the JSON objects is generated.\n\nHere are the type and their functions:\n\n  TOP_ELEMENT - type meta information is added as object wrapper, for example { MyObject : { field1: 1, field2 : 2 } }\n  TYPE        - type meta information is added as object field @type, for example { '@type' : 'MyObject', field1 : 1, field2 : 2}\n\nJsonNotationLevel determines an amount of type meta information. It defines which objects should be notated with type information. Levels can be\njoined together in any combinations. Some levels override another levels. But one level value cannot be decreased by another level.\nFor example the engine can treat inner objects of an Array or List as discrete elements such as [ {  'A': { 'a': 'hello' }, .. } ]\nbut this may not be useful in situations where an anonymous Map or Array is desired.  Using  the POLYMORPHIC_MAPS_AND_COLLECTIONS directive you\ncan tell the engine to generate element as [ { 'a': 'hello' }, { ..  } ] And you can add other directives to the string for additional\nprocessing specifics. For example ROOT+POLYMORPHIC_MAPS_AND_COLLECTIONS\n\nHere are the type and their functions:\n\n  NONE                                   - no type info for any object is added, any other level joined with this level overrides this level\n  ROOT_ELEMENT                           - type info is added for root complex object, cannot be overridden\n  ROOT_ENUM                              - type info is added for root enum, cannot be overridden\n  COMPLEX_OBJECTS                        - type info is added for any complex object(excluding root object, maps and collections), cannot be overridden\n  POLYMORPHIC_OBJECTS                    - type info is added for any polymorphic object (excluding root object, maps and collections),\n                                           can be overridden by COMPLEX_OBJECT level\n  POLYMORPHIC_MAPS_AND_COLLECTIONS       - type info is added for any polymorphic map, cannot be overridden\n  PRIMITIVE_OBJECTS                      - type info is added for any primitive object\n  POLYMORPHIC_PRIMITIVE_OBJECTS          - type info is added for any polymorphic primitive object, can be overridden by PRIMITIVE_OBJECTS level\n  ENUMS                                  - type info should be added for any enum (excluding root enum), cannot be overridden.\n  OLD_FABRIC_STYLE_DATE_AND_SQLTIMESTAMP - old style date and SQL timestamp serializers, used by JS fabric api only\n\nDefault serializer is TOP_ELEMENT notation and POLYMORPHIC_OBJECTS level\n\n" + JAVA_DATE_FORMAT_SYNTAX;
                customFunctions.add("toJSON", 160, Type.STRING).argument("object", Type.OTHER).optional("prettyPrint", Type.SQL_BOOLEAN).optional("JsonNotation", Type.SQL_ALL_TYPES).optional("Compound JSON Directives", Type.STRING).optional("date format", Type.STRING).optional("sqltimestamp format", Type.STRING).optional("sqldate format", Type.STRING).optional("sqltime format", Type.STRING).description("Returns a JSON representation of a Data Object value. This function may be used in combination with DOMAIN and OBJECT types.\n\n" + JSON_FORMAT_DESCRIPTION + "Examples:\n    select toJSON(o,true, JsonNotation.TOP_ELEMENT, 'none')\n    select toJSON(o,true, JsonNotation.TYPE, 'root_element+complex_objects')\n    select toJSON(o,true, null, null, 'yyyy-MM-dd''T''HH:mm:ssX')\n    select toJSON(o,true, null, null, 'yyyy-MM-dd''T''HH:mm:ss''Z''')\n").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("toFlobInfo", 217, new OtherType("FlobInfo", FlobInfo.class)).argument("flob", Type.FLOB).description("Returns an information about FLOB. FLOB info is extracted from system tables, so it needs some resources to be executed.\nBe careful when executing this function on FLOB column in table with many rows.\nExamples:\n    select toFlobInfo(f)").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OTHER);
                customFunctions.add("validateFlob", 237, Type.SQL_BOOLEAN).argument("flob", Type.FLOB).optional("notEmpty", Type.SQL_BOOLEAN).description("Validates specifid FLOB, and checks the following:\n\n   - location exists\n   - file exists\n   - file not empty (is notEmpty is true)\n\nIf one of the checks is failed then FLOB is marked as INVALID and false is returned, otherise FLOB is marked as VALID\nand true is returnedExamples:\n    validateFlob(f)").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OTHER);
                customFunctions.add("invalidateFlob", 238, Type.SQL_BOOLEAN).argument("flob", Type.FLOB).description("Sets FLOB status to INVALID.\n\nExamples:\n    invalidateFlob(f)").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OTHER);
                customFunctions.add("isFlobValid", 239, Type.SQL_BOOLEAN).argument("flob", Type.FLOB).description("Returns true if FLOB is valid.\n\nExamples:\n    isFlobValid(f)").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OTHER);
                customFunctions.add("toBinary", 174, Type.SQL_BINARY).argument("object", Type.OTHER).description("Returns a binary representation of OBJECT value. This function may be used in combination with DOMAIN and OBJECT types.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("fromXML", 161, Type.OTHER).argument("object", Type.STRING, Type.SQL_VARBINARY).optional("typesMap", Type.STRING, Type.SQL_VARBINARY).description("Returns an OBJECT deserialized from provided XML STRING value. This function may be used in combination with Character and Binary types.\nIf target object is MAP then typesMap for specified pathes can be specified.\n  typesMap.put('//some/element', 'list')\n  typesMap.put('//some/element', 'implicit-list')\n").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("fromJSON", 162, Type.OTHER).argument("object", Type.STRING, Type.SQL_VARBINARY).optional("semanticType", Type.STRING, Type.SQL_VARBINARY).optional("jsonNotation", Type.SQL_ALL_TYPES).optional("jsonNotationLevel", Type.STRING).optional("date format", Type.STRING).optional("sqltimestamp format", Type.STRING).optional("sqldate format", Type.STRING).optional("sqltime format", Type.STRING).optional("failOnUnknownProperties", Type.SQL_BOOLEAN).description("Returns an OBJECT deserialized from provided JSON STRING value. This function may be used in combination with Character and Binary types.\n\nIf semanticType is set to null or not specified then semantic type will be taken from the left variable if possible and type of variable is not an object.\nIf semanticType is set to empty string then semantic type will be resolved from entire JSON.\nIf semanticType is set to a concrete type name then this type will be used for deserialization.\n\n" + JSON_FORMAT_DESCRIPTION + "\nTo ignore any JSON elements that cannot be mapped to an existing SDO use failOnUnknownProperties option.\n\nExamples:\n    select fromJSON(o,'Employee', JsonNotation.TYPE, 'none')\n    Employee empl = fromJSON(o)\n    Employee empl = fromJSON(o, null, JsonNotation.TYPE, 'none')\n    Employee empl = fromJSON(o, null, JsonNotation.TYPE, 'none', null, null, null, null, true)\n").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("fromBinary", 175, Type.OTHER).argument("object", Type.SQL_BINARY, Type.SQL_VARBINARY).description("Returns an OBJECT deserialized from provided binary value. This function may be used in combination with Binary types.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("toHTML", 184, Type.STRING).argument("object", Type.OTHER).optional("includeCssContent", Type.SQL_BOOLEAN).optional("css", Type.STRING).description("Returns a HTML representation of specified object. Object cab be RowSet or any other object.\nIf includeCssContent set to true then CSS content instead of CSS link will be included into HTML.\nAlso user can provide own CSS using css parameter.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("toUrl", 185, Type.STRING).argument("link", Type.SQL_ALL_TYPES).optional("name", Type.SQL_ALL_TYPES).optional("type", Type.STRING).description("Converts a DSQL expression or a user-defined URL string into a formal URL \nthat can be displayed as HTML result.\n\nThis function can reference other queries that also return URL links as results, allowing users to navigate dataspace content like a Graph Database.\n\nSyntax:\n\n  toUrl((<i>link expression</i>) [, name expression] [, 'json' | 'xml' | html' | 'string'])\n    - first argument is select query or any string expression, can reference table\n      aliases from parent expression\n    - second parameter is optional and can defines link name. cane be select query\n      or any string expression and can reference table aliases from parent expression.\n      If select query is specified it should return a rowset with one row and one\n      column, otherwise a cardinality exception is thrown\n    - third parameter is optional and defines the response format\n\n  toUrl functions can be nested and may reference DSQL expression identifiers that are\n  dynamically resolved when the resulting URL is built.  The function can be applied \n  to binary types such as BLOB or FLOB to return binary content and trigger downloads \n  in browser applications.\n\nExamples:\n\n// example of query that returns link to all employees in XML format\nselect toUrl((select emp_name from employees), 'employee', 'xml') as URL;\n\n// query that returns link to all employees with link to all younger employees in HTML format, sample of nested toUrl\nselect toUrl(\n    (select name, age, toUrl((select * from employees where age < e1.age), '< ' + age) as younger from employees e1), 'link', 'html'\n) as URL;").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("toDropBoxUrl", 218, Type.STRING).argument("drop box path", Type.STRING).optional("acceptorName", Type.STRING).optional("crypto alg", Type.STRING).optional("key name", Type.STRING).optional("expiresOn", Type.SQL_TIMESTAMP).optional("expiresIn", Type.STRING).optional("validOn", Type.SQL_TIMESTAMP).description("Returns a HTTP/HTTPS download URL for specified objects in DropBox.\nIf signature sign alg and its parameters are specified, URL will contain x-resource-token for access without authentication.\n\nParameters:\n\n  - dropbox path - path to dropbox resource in format <dropboxname>/<path>/..\n  - acceptorName - name of acceptor, if null default acceptor will be used\n  - crypto alg   - name of algorithm used to sign the token, allowed values: rsa256, rsa384, rsa512, hmac256, hmac384, hmac512, ecdsa256, ecdsa384, ecdsa512\n  - key name     - security Key name used to sign the token, use 'list security keys' operation to get available keys\n  - expiresOn    - date when token expires in format yyyy-mm-dd hh:mm:ss.SSS\n  - expiresIn    - expiration interval since creation in format: <value> {sec|min|hr|days}\n  - valid on     - date on which Token becomes valid in format yyyy-mm-dd hh:mm:ss.SSS\n").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("htmlToJSON", 221, Type.STRING).argument("html", Type.STRING).optional("HTMLType", Type.SQL_ALL_TYPES).optional("nullable", Type.SQL_BOOLEAN).optional("topElement", Type.STRING).optional("prettyPrint", Type.SQL_BOOLEAN).optional("columnNames", Type.SQL_ARRAY_ALL_TYPES).optional("matchColNames", Type.SQL_BOOLEAN).description("Converts an HTML object to JSON based on HTML fragment type.\n  Currently only Tableis supported.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("htmlToDocument", 222, new OtherType("Document", Document.class)).argument("html", Type.STRING).description("Creates a Document from an HTML String.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("htmlTableToRowSet", 226, new OtherType("RowSet", RowSet.class)).argument("html", Type.STRING).optional("nullable", Type.SQL_BOOLEAN).optional("columnNames", Type.SQL_ARRAY_ALL_TYPES).optional("matchColNames", Type.SQL_BOOLEAN).description("Converts an HTML Table to RowSet.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("htmlFragmentToDocument", 223, new OtherType("Document", Document.class)).argument("html", Type.STRING).description("Creates a Document from a piece of HTML, an HTML Fragment String.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("htmlSelectFirst", 224, new OtherType("Element", Element.class)).argument("html", Type.STRING).argument("selector", Type.STRING).description("Selects the first fragment of an HTML string based on CSS Selector Syntax and returns an Element.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("htmlSelect", 225, new OtherType("Elements", Elements.class)).argument("html", Type.STRING).argument("selector", Type.STRING).description("Selects all fragments of an HTML string based on CSS Selector Syntax and returns Elements list.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("findNearest", 219, Type.SQL_ARRAY_ALL_TYPES).alias("find_nearest").argument("term", Type.STRING).argument("semagraph table", Type.STRING).optional("limit", Type.SQL_INTEGER).optional("score threshold", Type.SQL_DOUBLE).description("Returns array of nearest terms to specified term or expression.\n\nselect term, findNearest(term, 'MyDictionary', 100, 0.7) from terms\nselect term, unnest(findNearest(term, 'MyDictionary', 100, 0.8)) from terms\n\nParameters:\n\n  - term            - term to find for\n  - semagraph table - semagraph table exported from TXSemagraph service\n  - limit           - top limit of result terms\n  - score threshold - min similarity score for returned terms\n").operationVisibleCondition(HelpRegistry.semagraphOperationsVisibleChecker).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("calculateSimilarity", 220, Type.SQL_DOUBLE).alias("calculate_similarity").argument("term1", Type.STRING).argument("term2", Type.STRING).argument("semagraph table", Type.STRING).description("Calculates similarity between two terms or expressions.\n\ncall calculateSimilarity('clean', 'dirty', 'MyDictionary')\nselect t1.term as term1, t2.term as term2, calculateSimilarity(t1.term, t2.term, 'MyDictionary')  from terms t1 join terms t2 on t1.term != t2.term\n\nParameters:\n\n  - term1           - first term to calculate similarity\n  - term2           - second term to calculate similarity\n  - semagraph table - semagraph table exported from TXSemagraph service\n").operationVisibleCondition(HelpRegistry.semagraphOperationsVisibleChecker).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("toDataFrame", 186, new OtherType(DataFrame.class.getSimpleName(), DataFrame.class)).argument("rowSet", new OtherType(RowSet.class.getSimpleName(), RowSet.class)).description("Converts result set to DataFrame. Accepts RowSet, Snapshot and SELECT result sets.\nAll data values should be convertible to Double.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("levenshtein", 163, Type.SQL_DOUBLE).argument("str1", Type.STRING).argument("str2", Type.STRING).description("Compares two strings using the Levenshtein distance metric. Returns DOUBLE value in range 0.0 to 1.0 indicating the degree of similarity.\nIf strings are equal returns 1.0.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("entity_name", 164, Type.SQL_DOUBLE).argument("str1", Type.STRING).argument("str2", Type.STRING).description("Compares two names using Levenshtein distance. Returns DOUBLE value in range 0.0 to 1.0 indicating the degree of similarity.\nIf strings are equal returns 1.0.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("qgram", 165, Type.SQL_DOUBLE).argument("str1", Type.STRING).argument("str2", Type.STRING).optional("function", 890, 891, 892).optional("tokenizer", 893, 894, 895).optional("q", Type.SQL_INTEGER).description("Compares two strings using the q-grams comparison that can tokenize a few different ways, and also use a couple different formulas to compute the final score.\nThe default is using basic q-grams and q-gram overlap. Returns DOUBLE value in range 0.0 to 1.0 indicating the degree of similarity. If strings are equal returns 1.0.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("metaphone", 166, Type.SQL_DOUBLE).argument("str1", Type.STRING).argument("str2", Type.STRING).description("Compares two strings using the Metaphone algorithm. Returns DOUBLE value in range 0.0 to 1.0 indicating the degree of similarity.\nIf strings are equal returns 1.0. If Metaphone string values match returns 0.9. Otherwise returns 0.0.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("jaro_winkler", 167, Type.SQL_DOUBLE).argument("str1", Type.STRING).argument("str2", Type.STRING).description("An implementation of the Jaro-Winkler string similarity measure. \nReturns DOUBLE value in range 0.0 to 1.0 indicating the degree of similarity. If strings are equal returns 1.0.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("weighted_levenshtein", 168, Type.SQL_DOUBLE).argument("str1", Type.STRING).argument("str2", Type.STRING).optional("digitWight", Type.SQL_DOUBLE).optional("letterWeight", Type.SQL_DOUBLE).optional("punctuationWeight", Type.SQL_DOUBLE).optional("otherWeight", Type.SQL_DOUBLE).description("Compares two strings using the Levenshtein distance metric that uses weights, so that not all editing operations are considered equal.\nReturns DOUBLE value in range 0.0 to 1.0 indicating the degree of similarity. If strings are equal returns 1.0.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.NATURAL_LANGUAGE);
                customFunctions.add("spath", 156, Type.OTHER).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a OBJECT value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("has_spath", 232, Type.SQL_BOOLEAN).alias("hasSpath").argument("object", Type.OTHER).argument("spath", Type.STRING).description("\u0421hecks if an element with specified path exists in an object.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("has_rpath", 233, Type.SQL_BOOLEAN).alias("hasRpath").argument("object", Type.OTHER).argument("regex", Type.STRING).description("\u0421hecks if a path exists to an element whose value matches a regular expression.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("rpath", 229, Type.OTHER).argument("object", Type.OTHER).argument("regex", Type.STRING).description("The Relative Path function searches through a Data Object\u2019s values (not element names)\nand returns a MAP of Path/Value pairs that match a given regular expression.   This function\nis the opposite of a Sematic Path function which uses element Paths to retrieve values.\n\nPrimary use of this function is for exploring large data object structure for the purpose of \nData Mining and Meta-Mining.  The returned paths can be used in Semantic Mapper for\nmapping values using Paths.  They can be used to compare similarity of different data\nstructures for meta-analysis to determine, for example if two JSON or XML documents\nhave similar structure by comparing Paths relative to the values they store.\n\nThis function is also useful for sampling data streams to determine which elements to \nfilter based on values.  And may be critical in exploration of arbitrary data structures that\nfollow open schema, such as lists of maps or similar anonymous data collections.\n\nSee example below for searching anonymous collection Paths by value.\n\n\n{\n  \"awsSDO\" : {\n    \"id\" : \"9f50bb00-d59c-b962-3895-3b979ec4b971\",\n    \"account\" : \"332655232334\",\n    \"detail\" : {\n      \"userIdentity\" : {\n        \"accountId\" : \"332655232334\",\n        \"principalId\" : \"AIDAJTYXOHJBHZAWFP7GY\"\n      },\n      \"resources\" : [ {\n        \"map\" : {\n          \"type\" : \"AWS::S3::Object\",\n          \"ARNPrefix\" : \"arn:aws:s3:::streamscapebox\"\n        }\n      }, {\n        \"map\" : {\n          \"accountId\" : \"332655232334\",\n          \"type\" : \"AWS::S3::Bucket\",\n          \"ARN\" : \"arn:aws:s3:::streamscapebox\"\n        }\n      } ],\n      \"recipientAccountId\" : \"332655232334\"\n    }\n  }\n}\n\nCreate the Object: \n\nawsSDO  o = fromJSON( { \u2026 }, \u2018awsSDO\u2019, .. );\n\nSearch:\n\nrpath(o, '332655232334')\n\nResult:\n\n{\n  \"//account\" : \"332655232334\",\n  \"//detail/userIdentity/accountId\" : \"332655232334\",\n  \"//detail/resources[1]/[key=accountId]\" : \"332655232334\",\n  \"//detail/recipientAccountId\" : \"332655232334\"\n}\n\nRegular Expression Search:\n\nrpath(o, '9f50b.*')\n\nResult:\n\n{\n  \"//id\" : \"9f50bb00-d59c-b962-3895-3b979ec4b971\"\n}\n").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getBoolean", 156, Type.SQL_BOOLEAN).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a BOOLEAN value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getString", 156, Type.STRING).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a STRING value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getObject", 156, Type.OTHER).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a OBJECT value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getInteger", 156, Type.SQL_INTEGER).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a INTEGER value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getLong", 156, Type.LONG).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a LONG value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getBigDecimal", 156, Type.SQL_BIGINT).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a BIGDECIMAL value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getDecimal", 156, Type.SQL_DECIMAL).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a DECIMAL value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getDouble", 156, Type.SQL_DOUBLE).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a DOUBLE value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getTime", 156, Type.SQL_TIME).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a TIME value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getDate", 156, Type.SQL_DATE).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a DATE value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("getTimestamp", 156, Type.SQL_TIMESTAMP).argument("object", Type.OTHER).argument("spath", Type.STRING).description("Returns a TIMESTAMP value from the OBJECT parameter using the SPATH reference.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OBJECT);
                customFunctions.add("tokenize", 157, Type.SQL_ARRAY_ALL_TYPES).argument("str", Type.STRING).argument("delimiter", Type.STRING).description("Tokenizes input string with specified delimiter and returns array of tokens.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.TEXT);
                customFunctions.add("toString", 176, Type.STRING).argument("object", Type.SQL_ALL_TYPES).description("Returns a string representation of OBJECT value.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("toDecimal", 177, Type.SQL_DECIMAL).argument("object", Type.SQL_ALL_TYPES).argument("precision", Type.SQL_INTEGER).argument("scale", Type.SQL_INTEGER).description("Returns a decimal representation of OBJECT value (if conversion is possible).").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("guid", 178, Type.STRING).description("Returns generated unique identifier.");
                customFunctions.add("toCurrency", 179, Type.STRING).argument("amount", Type.SQL_DECIMAL).optional("locale", Type.STRING).description("Returns a formatted number which represents amount in the local currency.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("getCurrentDatetime", 180, Type.SQL_TIMESTAMP).alias("currentDatetime", "current_datetime").description("Returns current wall-clock timestamp.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("eval", -1, Type.SQL_ALL_TYPES).argument("expression", Type.SQL_BOOLEAN).argument("value1", Type.SQL_ALL_TYPES).argument("value2", Type.SQL_ALL_TYPES).description("If the <i>expression</i> is true, returns <i>value1</i> otherwise returns <i>value2</i>.");
                customFunctions.add("coalesce", -1, Type.SQL_ALL_TYPES).argument("value1", Type.SQL_ALL_TYPES).argument("value2", Type.SQL_ALL_TYPES).description("Returns <i>value1</i> if it is not null, otherwise returns <i>value2</i> if not null and so on... \nNumber of parameters is not limited to 2.");
                customFunctions.add("convert", -1, Type.SQL_ALL_TYPES).argument("value", Type.SQL_ALL_TYPES).argument("dataType", Type.SQL_ALL_TYPES).description("The CONVERT function is a JDBC escape function, equivalent to the SQL standard CAST expression. \nIt converts the <i>value</i> into the given <i>dataType</i> and returns the value.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("decode", -1, Type.SQL_ALL_TYPES).argument("value", Type.SQL_ALL_TYPES).argument("match", Type.SQL_ALL_TYPES).argument("result", Type.SQL_ALL_TYPES).optional("default", Type.SQL_ALL_TYPES).description("DECODE takes at least 3 arguments. The <i>value</i> is compared with <i>match</i>\nand if it matches, <i>result</i> is returned. If there are additional pairs of <i>match</i>\nand <i>result</i>, comparison is repeated until a match is found the result is returned. If no\nmatch is found, the <i>default</i> is returned if it is specified, otherwise NULL is returned. \nThe type of the return value is a combination of the types of the <i>result ... </i> arguments.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("greatest", -1, Type.SQL_ALL_TYPES).argument("value1", Type.SQL_ALL_TYPES).argument("value2", Type.SQL_ALL_TYPES).description("The GREATEST function takes one or more arguments. It compares the arguments with each \nother and returns the greatest argument. The return type is the combined type of the arguments.\nArguments can be of any type, so long as they are comparable. \nNumber of parameters is not limited.");
                customFunctions.add("least", -1, Type.SQL_ALL_TYPES).argument("value1", Type.SQL_ALL_TYPES).argument("value2", Type.SQL_ALL_TYPES).description("The GREATEST function takes one or more arguments. It compares the arguments with each \nother and returns the smallest argument. The return type is the combined type of the arguments.\nArguments can be of any type, so long as they are comparable. \nNumber of parameters is not limited.");
                customFunctions.add("ifnull", -1, Type.SQL_ALL_TYPES).argument("value1", Type.SQL_ALL_TYPES).argument("value2", Type.SQL_ALL_TYPES).alias("isnull").description("Returns <i>value1</i> if it is not null, otherwise returns <i>value2</i>. The type of the return value is\nthe type of <i>value1</i>. Almost equivalent to SQL Standard COALESCE(<i>value1</i>, <i>value2</i>) function,\nbut without type modification.");
                customFunctions.add("nullif", -1, Type.SQL_ALL_TYPES).argument("value1", Type.SQL_ALL_TYPES).argument("value2", Type.SQL_ALL_TYPES).description("Returns <i>value1</i> if it is not equal to <i>value2</i>, otherwise returns null. The type of both\narguments must be the same. This function is a shorthand for a specific EVAL expression.");
                customFunctions.add("nvl", -1, Type.SQL_ALL_TYPES).argument("value1", Type.SQL_ALL_TYPES).argument("value2", Type.SQL_ALL_TYPES).description("Returns <i>value1</i> if it is not null, otherwise returns <i>value2</i>. The type of the return value is\nthe type of <i>value1</i>. For example, if <i>value1</i> is an INTEGER column and <i>value2</i> is a DOUBLE constant,\nthe return type is cast into INTEGER. This function is similar to IFNULL.");
                customFunctions.add("nvl2", -1, Type.SQL_ALL_TYPES).argument("value1", Type.SQL_ALL_TYPES).argument("value2", Type.SQL_ALL_TYPES).argument("value3", Type.SQL_ALL_TYPES).description("If <i>value1</i> is not null, returns <i>value2</i>, otherwise returns <i>value3</i>. The type of\nthe return value is the type of <i>value2</i> unless it is null.");
                customFunctions.add("future", 181, Type.SQL_BOOLEAN).argument("expression", Type.SQL_ALL_TYPES).argument("interval", Type.SQL_INTERVAL_SECOND, Type.SQL_INTERVAL_MINUTE, Type.SQL_INTERVAL_HOUR, Type.SQL_NUMERIC).optional("userKey", Type.STRING).description("Schedules a function or DSQL expression for future execution as part of standard Future/Promise framework\nused in Reactive Programming.  When the function or expression executes in the future is determined\nby the interval parameter, which sets how long to wait before executing the future.\nInterval may be specified in seconds, minutes or hours. Abbreviated versions are also supported.\n\nThe function always returns false when there is no associate promise to catch the results.\nAt this time promises are not supported but users may raise events in the future function and catch them using Actors.\n\nSyntax:\n\n  future(<i>expression</i>, { interval <i>integer</i> { sec | min | hour } | <seconds expression> } [, <string userKey> ] )\n\nExample:\n\n  future(myFunction(), interval 10 sec)\n  future(myFunction(), @variableInSeconds)\n  future(myFunction(), @variableInSeconds, 'mykey')");
                customFunctions.add("sleep", 234, Type.SQL_BOOLEAN).argument("interval", Type.SQL_BIGINT).description("Pause the execution thread of a user's session for a specified number of Milliseconds.\nThis can be used to delay logic execution, pause between 'greedy' operations or simply force a session wait condition.\n\nSyntax:\n\n  sleep(<i>interval</i>)\n\nExample:\n\n  sleep(1000)");
                customFunctions.add("base64decode", 215, Type.SQL_BINARY).argument("str", Type.STRING).description("Decodes data encoded with MIME base64.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("base64encode", 227, Type.STRING).argument("data", Type.STRING, Type.SQL_VARBINARY).description("Encodes data with MIME base64.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT);
                customFunctions.add("extractText", 228, Type.STRING).argument("source", Type.SQL_BLOB, Type.FLOB, Type.SQL_VARBINARY).optional("mime type", Type.STRING).optional("force_grammar", Type.SQL_BOOLEAN).optional("no_error", Type.SQL_BOOLEAN).optional("config", Type.OTHER).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT).description("Extracts text from specified source.\n\nParameters:\n\n  - source       - a file represented as byte array\n  - mime type    - mime type of a document. If the parameter is not specified then mime type is detected automatically \n  - no_error     - whether or not to ignore text processor errors\n  - config                 - additional parsing configuration. Usage:\n                              esc.microsoft.ppt.item         <some symbol>\n                              esc.microsoft.ppt.table        <some symbol>\n                              esc.microsoft.ppt.table.row    <some symbol>  { ln | space | item }\n                              esc.microsoft.ppt.table.cell   <some symbol>  { ln | space | item }\n                              esc.microsoft.ppt.shape        <come symbol>  { ln | space | item }\n\n                              image.process                  enables image processing for all the file types\n                              image.process.<ext>            enables image processing for specified type\n                              image.ocreader                 service to process image represented as byte array. It's supposed to use OCReader service.\n\n                              image.parallel.degree          number of thread to process embedded images.\n\n                              Example:\n                              parser.esc.microsoft.ppt.table.cell           space\n                              If a cell contains \u2018hello\u2019 then the result will be ' hello '\n\n                              item = the definition listed in parser.esc.microsoft.ppt.item\n                              parser.esc.microsoft.ppt.item                 myItem-\n                              parser.esc.microsoft.ppt.table.cell           item\n                              'hello' will turn into 'myItem-hello'\n");
                customFunctions.add("extractTextAsJSON", 230, Type.STRING).argument("source", Type.SQL_BLOB, Type.FLOB, Type.SQL_VARBINARY).optional("preserve structure", Type.SQL_BOOLEAN).optional("force_grammar", Type.SQL_BOOLEAN).optional("no_error", Type.SQL_BOOLEAN).optional("config", Type.OTHER).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.CONVERT).description("Extracts file structure object as JSON.\n\nWhen handling word processor documents such as Microsoft Word or Adobe PDF, \nthe documents are converted into Outline form whenever possible.  The outline\u2019s \nheaders, sub-headers and sections are generated using incremental levels, and \nnumbered using HTML notation as h1, h2, h3.  Higher numbers indicate increasing \ndepth or header / sub-header combinations.\n\nThe lowest level of the outline text is a collection of Paragraph elements and \nmay be accessed thru an index, wild card or inclusion syntax such as:\n\n  Paragraph[1]\n  Paragraph[*]\n  Paragraph+\n\nWild card syntax of Paragraph[*] will include and number all paragraph texts. \nParagraph[<n>] will return a specific paragraph of text, allowing for template\nprocessing. Paragraph+ is an inclusion directive that will combine all paragraphs \ninto a single text element numbered [1] and return one element with all text at \nthe paragraph level between headings or sub-headings.\n\nSpecific directives may be passed in using an Array of Levels that can be cast \nto a LIST.  For example:\n\n  (list) array['0', '1', 'Paragraph[2]']\n\nIf levels are not specified then all paragraphs are listed. \n\nParameters:\n\n  - source                 - file represented as byte array\n  - preserve structure     - if true then newlines replaced by space and multiple space replaced by single space.\n  - no_error               - whether or not to ignore text processor errors\n  - config                 - additional parsing configuration. Usage:\n                              esc.microsoft.ppt.item         <some symbol>\n                              esc.microsoft.ppt.table        <some symbol>\n                              esc.microsoft.ppt.table.row    <some symbol>  { ln | space | item }\n                              esc.microsoft.ppt.table.cell   <some symbol>  { ln | space | item }\n                              esc.microsoft.ppt.shape        <come symbol>  { ln | space | item }\n                              file.name                      <string>\n                              json.excluded.fields           <list of field names> ['Field1', 'Field2',..]\n                              content.levels                 <string> [h1, h2,..., 'Paragraph[]']\n\n                              image.process                  enables image processing for all the file types\n                              image.process.<ext>            enables image processing for specified type\n                              image.ocreader                 service to process image represented as byte array. It's supposed to use OCReader service.\n                              image.parallel.degree          number of thread to process embedded images.\n\n                              Example:\n                              parser.esc.microsoft.ppt.table.cell           space\n                              If a cell contains \u2018hello\u2019 then the result will be ' hello '\n\n                              item = the definition listed in parser.esc.microsoft.ppt.item\n                              parser.esc.microsoft.ppt.item                 myItem-\n                              parser.esc.microsoft.ppt.table.cell           item\n                              'hello' will turn into 'myItem-hello'\n\nExample:\n\n  map config = new map;\n  config.put('content.levels', (list)array['h3','Paragraph[1]']);\n  config.put('json.excluded.fields', (list)array['Titles','Footers','Notes','Comments']);\n  byte[] bt = readFile('glossary.docx');\n  extractTextAsJSON(bt, true, false, false, config);");
                customFunctions.add("inDomain", 235, Type.SQL_BOOLEAN).argument("domain name", Type.STRING).argument("value", Type.SQL_ALL_TYPES).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OTHER).description("Checks if a domain constraint with the specified name contains the specified value.");
                customFunctions.add("inRange", 236, Type.SQL_BOOLEAN).argument("range name", Type.STRING).argument("value", Type.SQL_ALL_TYPES).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.OTHER).description("Checks if the range contains the specified value.");
                customFunctions.add("nextDay", 240, Type.OTHER).alias("next_day").argument("startDate", Type.SQL_DATE).argument("weekDay", Type.STRING).optional("precession", Type.SQL_INTEGER, Type.SQL_ARRAY_ALL_TYPES).description("Returns the date of the next week day starting from a specific date. For example, \ncalculates and returns the date of the first Wednesday after the date of 11/26/2008.\nPrecession may be specified to return the next <n> recurring Wednesday dates.\n\nParameters:\n\n  - startDate       - the date from which next day calculations start\n  - weekDay         - the name of the week day (ie. Wednesday)\n  - precession      - how many subsequent dates for the week day to return\n\nExamples:\n\n  nextDay(now(), 'monday')\n  nextDay(now(), 'monday', 1)\n  nextDay(now(), 'monday', [1,2,3])").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("weekDay", 241, Type.STRING).alias("week_day").argument("day", Type.SQL_INTEGER).description("Returns week day name.").group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("sysDate", 52, Type.SQL_TIMESTAMP).alias("now").description(FunctionSQL.functions.lookupFunction(52).getDescription()).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("curdate", 43, Type.SQL_DATE).alias("today").description(FunctionSQL.functions.lookupFunction(43).getDescription()).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.add("curtime", 51, Type.SQL_TIME).description(FunctionSQL.functions.lookupFunction(51).getDescription()).group(SQLFunctionsMetaData.SQLFunctionMetaData.Group.DATE);
                customFunctions.compile();
                HashSet<String> names = new HashSet<String>();
                iter = customRegularFuncMap.keySet().iterator();
                while (iter.hasNext()) {
                    name = (String)iter.next();
                    if (!functionNames.contains(name)) continue;
                    names.add(name);
                }
                iter = customValueFuncMap.keySet().iterator();
                while (iter.hasNext()) {
                    name = (String)iter.next();
                    if (!functionNames.contains(name)) continue;
                    names.add(name);
                }
                FunctionCustom.addSystemEmbeddedFunctions(names);
                FunctionCustom.checkAllFunctionsMetaDataInitialized(customFunctions, names);
                for (String name2 : customFunctions.listFunctionNames()) {
                    FunctionSQL function;
                    SQLFunctionsMetaData.SQLFunctionMetaData metadata = customFunctions.lookupFunction(name2);
                    if (metadata == null || !metadata.isImplemented() || metadata.getId() == -1 || (function = FunctionCustom.newCustomFunction(name2, Tokens.getNonKeywordID(metadata.getName().toUpperCase(), -1))) == null) continue;
                    try {
                        FunctionCustom.compareFunctionsSignatures(metadata, function, function.parseList);
                    }
                    catch (Exception exception) {
                        if (function.parseListAlt == null) throw exception;
                        FunctionCustom.compareFunctionsSignatures(metadata, function, function.parseListAlt);
                        continue;
                        return;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Failed to initialize Custom SQL Functions metadata. Cause: " + exception.getMessage());
                Trace.logException(FunctionSQL.class, exception, true);
                Trace.logError(FunctionSQL.class, "Failed to initialize Custom SQL Functions metadata. Cause: " + exception.getMessage());
                throw new RuntimeException(exception);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected static enum SpathObjectFunction {
        getString,
        getBoolean,
        getInteger,
        getDouble,
        getDecimal,
        getBigDecimal,
        getLong,
        getDate,
        getTime,
        getTimestamp,
        getObject;

    }
}

