/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.job;

import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.job.JobType;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.job.JobStatus;
import java.util.Date;
import java.util.Locale;

public abstract class JobObject
implements SchemaObject {
    protected DataspaceStore store = null;
    protected AbstractDataspace dataspace = null;
    protected NameManager.ObjectName name = null;
    protected JobType jobType = null;

    public JobObject(DataspaceStore store, NameManager.ObjectName name, JobType jobType) {
        this.name = name;
        this.store = store;
        this.jobType = jobType;
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(name.schema.name);
    }

    public void destroy() {
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    public abstract void startJob();

    public abstract void stopJob();

    public abstract JobStatus getJobStatus();

    public JobType getJobType() {
        return this.jobType;
    }

    @Override
    public int getObjectType() {
        return 31;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.store.getCatalogName();
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return new OrderedHashSet();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public void describeProperties(RowSetNavigatorClient navigator) {
        navigator.add(new Object[]{"Name", this.getObjectName().name});
        navigator.add(new Object[]{"Type", this.getJobType().getTypeName()});
        JobStatus jobStatus = this.getJobStatus();
        if (jobStatus != null) {
            navigator.add(new Object[]{"Status", jobStatus.getState().getStateName()});
            navigator.add(new Object[]{"JobId", jobStatus.getJobId() != null ? jobStatus.getJobId().toString() : "N/A"});
            navigator.add(new Object[]{"Progress", jobStatus.getProgress() != -1.0f ? String.format(Locale.ENGLISH, "%.0f%%", Float.valueOf(jobStatus.getProgress() * 100.0f)) : "N/A"});
            navigator.add(new Object[]{"User", jobStatus.getUser() != null && jobStatus.getUser().length() > 0 ? jobStatus.getUser() : "N/A"});
            navigator.add(new Object[]{"Start Time", jobStatus.getStartTime() != 0L ? new Date(jobStatus.getStartTime()).toString() : "N/A"});
            navigator.add(new Object[]{"Finish Time", jobStatus.getFinishTime() != 0L ? new Date(jobStatus.getFinishTime()).toString() : "N/A"});
            navigator.add(new Object[]{"Failure Info", jobStatus.getFailureInfo() != null ? jobStatus.getFailureInfo() : "N/A"});
        } else {
            navigator.add(new Object[]{"Status", JobStatus.State.NOT_RUNNING.getStateName()});
        }
    }
}

