/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.job;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.directory.DirectoryTableCollection;
import com.streamscape.ds.schema.job.JobObject;
import com.streamscape.ds.schema.job.JobType;
import com.streamscape.ds.schema.server.FileServerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.job.JobException;
import com.streamscape.lib.job.JobLauncher;
import com.streamscape.lib.job.JobProvider;
import com.streamscape.lib.job.JobProviderable;
import com.streamscape.lib.job.JobStatus;
import com.streamscape.lib.job.JobStatusListener;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractJobStatusRaiser;
import com.streamscape.service.osf.clients.ClientConnection;
import java.util.Map;
import java.util.Properties;

public class HadoopJobObject
extends JobObject {
    public static final String HADOOP_JOB_EVENT_ID = "event.ds.hdfs.job";
    private FileServerObject fileServerObject;
    private DirectoryTableCollection inputDirectory;
    private DirectoryTableCollection outputDirectory;
    private String fileDescriptorName;
    private String tlpClientFactoryName;
    private String tlpClientFactoryType;
    private String inputFilesPattern;
    private String runtimePath;
    private Properties properties;
    private boolean raiseJobEvent;
    private JobLauncher jobLauncher;
    private HadoopJobStatusUpdater jobStatusUpdater;

    public HadoopJobObject(DataspaceStore store, NameManager.ObjectName name) {
        super(store, name, JobType.HADOOP);
        this.jobStatusUpdater = new HadoopJobStatusUpdater(this.dataspace);
    }

    public void setFileServerObject(FileServerObject fileServerObject) {
        this.fileServerObject = fileServerObject;
    }

    public FileServerObject getFileServerObject() {
        return this.fileServerObject;
    }

    public DirectoryTableCollection getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(DirectoryTableCollection inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    public DirectoryTableCollection getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(DirectoryTableCollection outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getFileDescriptorName() {
        return this.fileDescriptorName;
    }

    public void setFileDescriptorName(String fileDescriptorName) {
        this.fileDescriptorName = fileDescriptorName;
    }

    public String getTlpClientFactoryName() {
        return this.tlpClientFactoryName;
    }

    public void setTlpClientFactoryName(String tlpClientFactoryName) {
        this.tlpClientFactoryName = tlpClientFactoryName;
    }

    public String getTlpClientFactoryType() {
        return this.tlpClientFactoryType;
    }

    public void setTlpClientFactoryType(String tlpClientFactoryType) {
        this.tlpClientFactoryType = tlpClientFactoryType;
    }

    public String getInputFilesPattern() {
        return this.inputFilesPattern;
    }

    public void setInputFilesPattern(String inputFilesPattern) {
        this.inputFilesPattern = inputFilesPattern;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getRuntimePath() {
        return this.runtimePath;
    }

    public void setRuntimePath(String runtimePath) {
        this.runtimePath = runtimePath;
    }

    public boolean isRaiseJobEvent() {
        return this.raiseJobEvent;
    }

    public void setRaiseJobEvent(boolean raiseJobEvent) {
        this.raiseJobEvent = raiseJobEvent;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        this.createJobLaucher();
    }

    @Override
    public synchronized void startJob() {
        try {
            JobStatus jobStatus = this.jobStatusUpdater.getJobStatus();
            if (jobStatus != null && jobStatus.isRunning()) {
                throw new DataspaceException("Failed to start the job, job already running.");
            }
            this.jobLauncher = this.createJobLaucher();
            this.jobLauncher.init(this.dataspace);
            this.jobLauncher.setJobStatusListener(this.jobStatusUpdater);
            this.jobLauncher.start(this);
        }
        catch (JobException exception) {
            JobStatus jobStatus = new JobStatus();
            jobStatus.setState(JobStatus.State.FAILED);
            jobStatus.setFailureInfo(exception.toString());
            this.jobStatusUpdater.onStatusUpdate(jobStatus);
            throw new DataspaceException("Failed to start the job. Cause: " + exception.toString());
        }
    }

    @Override
    public synchronized JobStatus getJobStatus() {
        return this.jobStatusUpdater.getJobStatus();
    }

    @Override
    public synchronized void stopJob() {
        try {
            if (this.jobLauncher != null) {
                this.jobStatusUpdater.onStatusUpdate(this.jobLauncher.stop());
            }
        }
        catch (JobException exception) {
            JobStatus jobStatus = new JobStatus();
            jobStatus.setState(JobStatus.State.FAILED);
            jobStatus.setFailureInfo(exception.toString());
            this.jobStatusUpdater.onStatusUpdate(jobStatus);
            throw new DataspaceException("Failed to stop the job. Cause: " + exception.toString());
        }
    }

    protected JobLauncher createJobLaucher() {
        ClientConnection connection = this.fileServerObject.createConnection("JobLauncherConnection$" + this.name.name);
        if (!(connection instanceof JobProviderable)) {
            throw new DataspaceException("Invalid file server connection, doesn't allow to run the jobs.");
        }
        JobProvider provider = ((JobProviderable)((Object)connection)).createJobProvider();
        try {
            JobLauncher jobLauncher = provider.createJobLauncher(this);
            return jobLauncher;
        }
        catch (JobException exception) {
            throw new DataspaceException("Failed to create job laucher for job '" + String.valueOf(this.getObjectName()) + "'. Cause: " + exception.getMessage());
        }
        finally {
            this.fileServerObject.removeConnection(connection);
        }
    }

    @Override
    public void describeProperties(RowSetNavigatorClient navigator) {
        super.describeProperties(navigator);
        navigator.add(new Object[]{"File Server", this.fileServerObject.getObjectName().name});
        navigator.add(new Object[]{"Input Directory Collection", this.inputDirectory.getObjectName().name});
        navigator.add(new Object[]{"Output Directory Collection", this.outputDirectory.getObjectName().name});
        navigator.add(new Object[]{"File Descriptor", this.fileDescriptorName});
        navigator.add(new Object[]{"Input File Names Pattern", this.inputFilesPattern != null ? this.inputFilesPattern : ""});
        navigator.add(new Object[]{"Runtime Path", this.runtimePath != null ? this.runtimePath : "$STROOT/platform/lib"});
        navigator.add(new Object[]{"TLP Client Factory", this.tlpClientFactoryType + "." + this.tlpClientFactoryName});
        navigator.add(new Object[]{"Properties", this.getPropertiesString()});
        navigator.add(new Object[]{"Raise Job Event", this.raiseJobEvent});
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        sb.append("HADOOP").append(' ');
        sb.append("JOB").append(' ');
        sb.append(name).append(' ');
        sb.append("AT").append(' ').append(this.fileServerObject.getObjectName().name).append(' ');
        sb.append("INPUT").append(' ').append("COLLECTION").append(' ').append(this.inputDirectory.getObjectName().name).append(' ');
        sb.append("OUTPUT").append(' ').append("COLLECTION").append(' ').append(this.outputDirectory.getObjectName().name).append(' ');
        sb.append("FILE").append(' ').append("DESCRIPTOR").append(' ').append(this.fileDescriptorName).append(' ');
        sb.append("TLP").append(' ').append("CLIENT").append(' ').append("FACTORY").append(' ').append(this.tlpClientFactoryType).append('.').append(this.tlpClientFactoryName).append(' ');
        if (this.inputFilesPattern != null) {
            sb.append("INPUT").append(' ').append("FILE").append(' ').append("MATCH").append(" '").append(this.inputFilesPattern).append("' ");
        }
        if (this.runtimePath != null) {
            sb.append("RUNTIME").append(' ').append("PATH").append(" '").append(this.runtimePath).append("' ");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("PROPERTIES").append(this.getPropertiesString()).append(' ');
        }
        if (this.raiseJobEvent) {
            sb.append("RAISE").append(' ').append("JOB").append(' ').append("EVENT").append(' ');
        }
        return sb.toString();
    }

    private String getPropertiesString() {
        if (this.properties == null || this.properties.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            sb.append(entry.getKey()).append("='").append(entry.getValue()).append("',");
        }
        sb.setLength(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        set.add(this.fileServerObject.getObjectName());
        set.add(this.inputDirectory.getObjectName());
        set.add(this.outputDirectory.getObjectName());
        return set;
    }

    private class HadoopJobStatusUpdater
    extends AbstractJobStatusRaiser
    implements JobStatusListener {
        private JobStatus jobStatus;
        private boolean firsttime;

        protected HadoopJobStatusUpdater(FabricComponent component) {
            super(component);
            this.firsttime = true;
            this.jobStatus = new JobStatus();
            this.jobStatus.setState(JobStatus.State.NOT_RUNNING);
        }

        public JobStatus getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public synchronized void onStatusUpdate(JobStatus jobStatus) {
            if (HadoopJobObject.this.raiseJobEvent && this.jobStatus.getState() != jobStatus.getState()) {
                this.raiseJobStatusEvent(jobStatus);
            }
            this.jobStatus = jobStatus;
        }

        private void raiseJobStatusEvent(JobStatus jobStatus) {
            try {
                if (this.firsttime) {
                    super.bindSystemEventId(HadoopJobObject.HADOOP_JOB_EVENT_ID);
                    this.firsttime = false;
                }
                MapEvent event = (MapEvent)EventDatagramFactory.getInstance().createEvent(HadoopJobObject.HADOOP_JOB_EVENT_ID);
                event.setEventStringProperty("clientFactory", HadoopJobObject.this.fileServerObject.getFactoryType() + HadoopJobObject.this.fileServerObject.getFactoryName());
                event.setEventStringProperty("jobName", HadoopJobObject.this.getObjectName().name);
                event.setEventStringProperty("jobState", jobStatus.getState().getStateName());
                event.setEventStringProperty("jobId", jobStatus.getJobId().getJobId());
                event.setEventLongProperty("startTime", jobStatus.getStartTime());
                Trace.logInfo(this, "raising event [event.ds.hdfs.job] " + event.toString());
                super.raiseSystemEvent(event);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Raising of 'event.ds.hdfs.job' event failed.");
            }
        }
    }
}

