/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.event;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementRplExec;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.FabricThreadPool;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.lib.timer.AbstractFabricTimerTask;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerState;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.service.osf.config.ActiveEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Actor
implements SchemaObject,
FabricEventListener,
RplSchemaObject,
SourceEventFlowData {
    public static final String ACTOR_TIMER = "ActorTimer";
    public static final int DEFAULT_ASYNC_QUEUE_DEPTH = 300000;
    private int maxQueueDepth = 300000;
    protected DataspaceStore store = null;
    protected AbstractDataspace dataspace = null;
    protected NameManager.ObjectName name = null;
    protected boolean shouldBeEnabled = false;
    protected boolean enabled = false;
    protected boolean async = true;
    protected EventSetType eventSetType = null;
    protected EventScope eventScope = EventScope.INHERITED;
    protected WindowType windowType = null;
    protected long windowSize = 0L;
    protected TimeUnit timeWindowUnit = null;
    protected ThreadPoolType workerPoolType = null;
    protected int workerPoolSize = -1;
    protected int workerNotifyThreshold = -1;
    protected FabricThreadPool threadPool = null;
    protected List<FabricThread<?>> executors = null;
    protected List<ActorEntry> events = null;
    protected RplScript routine = null;
    protected StatementRplExec stat = null;
    protected Expression[] arguments = null;
    protected FabricTimer timer = null;
    protected EventSet eventSet = null;
    protected List<EventConsumer> eventConsumers = new ArrayList<EventConsumer>();
    Map<String, EventQueueCollection> eventQueues = null;
    Map<String, Integer> eventIdToIndex = new HashMap<String, Integer>();
    protected boolean isAutoEnable = false;
    Object MUTEX = new Object();
    Session session = null;
    Queue<Session> sessions = null;
    Semaphore semaphore = null;
    String rpl = null;
    private DataspaceStateHolder stateHolder = new DataspaceStateHolder();

    public Actor(DataspaceStore store, NameManager.ObjectName name) {
        this.store = store;
        this.name = name;
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(name.schema.name);
    }

    public void setEventSetType(EventSetType eventSetType) {
        this.eventSetType = eventSetType;
    }

    public void setActorEntries(List<ActorEntry> entries) {
        this.events = entries;
        int index = -1;
        for (ActorEntry entry : this.events) {
            this.eventIdToIndex.put(entry.getEventId(), ++index);
        }
    }

    public void setRoutine(RplScript routine) {
        if (routine != null && this.isInvalid()) {
            this.stateHolder = new DataspaceStateHolder();
        }
        this.routine = routine;
    }

    public void setStatement(StatementRplExec stat) {
        this.stat = stat;
    }

    public StatementRplExec getStatement() {
        return this.stat;
    }

    public void setArguments(Expression[] arguments) {
        this.arguments = arguments;
    }

    public Map<String, EventQueueCollection> getEventQueues() {
        return this.eventQueues;
    }

    public void setAutoEnable(boolean value) {
        this.isAutoEnable = value;
    }

    public boolean isAutoEnable() {
        return this.isAutoEnable;
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public void setEventScope(EventScope eventScope) {
        this.eventScope = eventScope;
    }

    public void setWindow(WindowType type, long size, TimeUnit timeWindowUnit) {
        this.windowType = type;
        this.windowSize = size;
        this.timeWindowUnit = timeWindowUnit;
    }

    public void setParallelWorkers(ThreadPoolType poolType, int poolSize, int threshold) {
        this.workerPoolType = poolType;
        this.workerPoolSize = poolSize;
        this.workerNotifyThreshold = threshold;
    }

    public void setAsync(boolean value) {
        this.async = value;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setEventQueues(Map<String, EventQueueCollection> queues) {
        this.eventQueues = queues;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isInvalid() {
        return this.stateHolder.isSuspectState();
    }

    public List<ActorEntry> getActorEntries() {
        return this.events;
    }

    public StatementRplExec getRoutineStatement() {
        return this.stat;
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    public EventSetType getEventSetType() {
        return this.eventSetType;
    }

    public RplScript getRoutine() {
        return this.routine;
    }

    public void setRpl(String rpl) {
        this.rpl = rpl;
    }

    public void dropTempStructures(Session session) {
        if (this.eventQueues != null && this.eventQueues != null) {
            for (EventQueueCollection eventQueue : this.eventQueues.values()) {
                eventQueue.destroy(null);
                session.dataspaceStore.schemaManager.dropTableOrView(session, eventQueue.getBaseTable(), false, false);
            }
            this.eventQueues.clear();
        }
    }

    public void recompileActor(Session session) {
        this.recompileActorInternal(session);
        if (this.shouldBeEnabled || this.enabled) {
            if (this.enabled) {
                if (this.routine != null) {
                    this.routine.open(session, this);
                }
            } else {
                this.enableInternal(session);
            }
        }
    }

    public void recompileActorInternal(Session session) {
        try {
            String sql = session.dataspaceStore.schemaManager.loadObjectDefinition(session, this);
            Statement newActor = (Statement)RoutineSchema.executeInDataspace(session, this.getObjectName().schema, s -> {
                ParserCommand parser = new ParserCommand((Session)s, new Scanner(sql));
                return parser.compileStatement(0);
            });
            if (newActor != null) {
                Object[] arguments = ((StatementSchema)newActor).arguments;
                RplScript newRoutine = (RplScript)arguments[4];
                StatementRplExec stat = (StatementRplExec)arguments[5];
                Expression[] actorArguments = (Expression[])arguments[6];
                Map eventQueues = (Map)arguments[7];
                if (this.routine != null) {
                    this.routine.close();
                }
                if (newRoutine != null) {
                    newRoutine.resolveReferences(session);
                }
                this.setRoutine(newRoutine);
                this.setStatement(stat);
                this.setArguments(actorArguments);
                if (eventQueues != null) {
                    this.setEventQueues(eventQueues);
                }
                session.dataspaceStore.schemaManager.replaceReferences(this, this);
                this.stateHolder = new DataspaceStateHolder();
            }
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to recompile object. " + Utils.formatExceptionWithUnrepeatedCauses(error));
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, error);
            return;
        }
    }

    public void enable(Session session) {
        this.shouldBeEnabled = true;
        if (this.isInvalid()) {
            this.recompileActorInternal(session);
            if (this.stateHolder.isSuspectState()) {
                return;
            }
        } else if (this.enabled) {
            return;
        }
        this.enableInternal(session);
    }

    private void enableInternal(Session session) {
        if (this.routine == null) {
            return;
        }
        this.routine.open(session, this);
        if (this.workerPoolSize > 0) {
            this.threadPool = FabricThreadManager.getInstance().createThreadPool(this.workerPoolType, "DSYS:Event.Actor:EventSetProcessor", "Process completed event sets.", this.workerPoolSize);
            this.semaphore = new Semaphore(this.workerPoolSize);
            this.sessions = new LinkedList<Session>();
            for (int i = 0; i < this.workerPoolSize; ++i) {
                Session tempSession = this.dataspace.createSession();
                this.sessions.add(tempSession);
            }
        } else if (this.workerPoolSize == 0) {
            this.executors = new ArrayList();
        }
        this.initEventSet();
        int counter = 0;
        for (ActorEntry entry : this.events) {
            try {
                EventConsumer consumer;
                if (this.async) {
                    consumer = this.dataspace.createEventAsyncConsumer(this.name.name + "_LISTENER_" + ++counter, this, entry.eventId, entry.selector, this.eventScope, false);
                    consumer.setMaxDepth(this.maxQueueDepth);
                    ((EventAsyncConsumer)consumer).start();
                } else {
                    consumer = this.dataspace.createEventConsumer(this.name.name + "_LISTENER_" + ++counter, this, entry.eventId, entry.selector, this.eventScope, false);
                }
                this.dataspace.addSinkEventFlow(this.getEntity(), this.getEntityName(), consumer);
                this.eventConsumers.add(consumer);
            }
            catch (Exception error) {
                Trace.logError(this, "Unable to initialize consumer for '" + entry.eventId + "' event ID. " + error.getMessage());
                throw new DataspaceException("Unable to initialize consumer for '" + entry.eventId + "' event ID. " + error.getMessage());
            }
        }
        this.enabled = true;
    }

    @Override
    public void disable() {
        this.shouldBeEnabled = false;
        if (!this.enabled) {
            return;
        }
        this.disableInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableInternal() {
        Object object;
        for (EventConsumer consumer : this.eventConsumers) {
            try {
                if (consumer instanceof EventAsyncConsumer) {
                    consumer.close();
                }
                this.dataspace.dropConsumer(consumer.getName());
            }
            catch (Exception error) {
                Trace.logError(this, "Unable to drop consumer " + consumer.getName() + ". " + error.getMessage());
            }
        }
        if (this.timer != null) {
            FabricTimerManager manager = FabricTimerManager.getInstance();
            try {
                if (this.timer.getState() == FabricTimerState.STARTED) {
                    this.timer.cancel();
                }
                manager.dropTimer(this.timer.getGroup(), this.timer.getName());
            }
            catch (Exception ex) {
                Trace.logError(this, ex.getMessage());
            }
        }
        if (this.workerPoolSize > 0) {
            if (this.threadPool != null) {
                this.threadPool.stop();
            }
            if (this.sessions != null) {
                this.sessions.stream().filter(s -> s != null).forEach(Session::close);
                this.sessions.clear();
            }
        }
        if (this.executors != null) {
            this.executors.forEach(FabricThread::interrupt);
            this.executors.clear();
        }
        if (this.eventSet != null) {
            if (this.eventSet.eventSetSession != null) {
                object = this.eventSet.eventSetSession;
                synchronized (object) {
                    this.eventSet.eventSetSession.close();
                    this.eventSet.eventSetSession = null;
                }
            }
            this.eventSet = null;
        }
        if (this.session != null) {
            object = this.session;
            synchronized (object) {
                this.session.close();
                this.session = null;
            }
        }
        if (this.routine != null) {
            this.routine.close(this);
        }
        this.eventConsumers.clear();
        this.enabled = false;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    private void initEventSet() {
        if (this.eventSetType != null) {
            switch (this.eventSetType.ordinal()) {
                case 2: {
                    this.eventSet = new CompleteEventSet();
                    break;
                }
                case 1: {
                    this.eventSet = new LreEventSet(this);
                    break;
                }
                case 0: {
                    this.eventSet = new MreEventSet(this);
                }
            }
        } else {
            this.eventSet = new AnyEventSet(this);
        }
        this.eventSet.initSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(boolean timeout) {
        if (this.isInvalid()) {
            throw new DataspaceException("Actor '" + this.getObjectName().getSchemaQualifiedStatementName() + "' is invalid.");
        }
        final EventSet current = this.eventSet;
        Object object = this.MUTEX;
        synchronized (object) {
            if (this.windowType == null && !this.eventSet.isComplete()) {
                return;
            }
            if (this.windowType == WindowType.BATCH && this.eventSet.getSize() < this.windowSize) {
                return;
            }
            if (this.windowType == WindowType.TIME && !timeout) {
                if (current.getSize() == 1L) {
                    FabricTimerManager manager = FabricTimerManager.getInstance();
                    if (this.windowSize > 0L) {
                        try {
                            if (manager.existsTimer(ACTOR_TIMER, this.name.name + "TimeWindow")) {
                                manager.dropTimer(ACTOR_TIMER, this.name.name + "TimeWindow");
                            }
                            this.timer = manager.createTimer(ACTOR_TIMER, this.name.name + "TimeWindow", new TimeWindowTimerTask(), SqlUtils.getTimeIntervalInMillis(this.windowSize, this.timeWindowUnit), 1);
                            this.timer.start();
                        }
                        catch (Exception error) {
                            throw new DataspaceException("Unable to initialize timer for time window. " + error.getMessage());
                        }
                    }
                }
                return;
            }
            this.initEventSet();
        }
        Runnable eventSetProcessor = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Session eventSetSession = current.eventSetSession;
                try {
                    Session session = eventSetSession;
                    synchronized (session) {
                        ImmutableEventDatagram currentEvent = null;
                        for (int i = 0; i < Actor.this.events.size(); ++i) {
                            ActorEntry entry = Actor.this.events.get(i);
                            ImmutableEventDatagram temp = current.get(entry.eventId);
                            if (temp != null) {
                                currentEvent = temp;
                                Actor.this.arguments[i].valueData = new OtherTypeWrapper(temp);
                                continue;
                            }
                            Actor.this.arguments[i].valueData = null;
                        }
                        eventSetSession.sessionContext.rplObject = Actor.this;
                        eventSetSession.sessionContext.eventScope = Actor.this.eventScope;
                        eventSetSession.sessionContext.rplBlockCurrentEvent = currentEvent;
                        Result result = eventSetSession.executeCompiledStatement(Actor.this.stat, new Object[0]);
                        if (result.isError()) {
                            if (result.getException() != null) {
                                Actor.this.stateHolder.setLastError(result.getException().getMessage());
                            }
                        } else {
                            Actor.this.stateHolder.setLastError("");
                        }
                    }
                }
                catch (Throwable error) {
                    Actor.this.stateHolder.setLastError(error.getMessage());
                    Trace.logException(this, error, true);
                }
                finally {
                    eventSetSession.sessionContext.rplObject = null;
                    eventSetSession.sessionContext.rplBlockCurrentEvent = null;
                    eventSetSession.sessionContext.eventScope = null;
                    current.closeSession();
                }
            }
        };
        if (this.workerPoolSize < 0) {
            eventSetProcessor.run();
        } else if (this.workerPoolSize == 0) {
            FabricThread executor = FabricThreadManager.getInstance().createThread("DSYS:Event.Actor:EventSetProcessor", "Process completed event sets.", eventSetProcessor);
            executor.start();
        } else {
            if (this.workerNotifyThreshold != -1 && this.threadPool.getCurrentThreadsNumber() >= this.workerNotifyThreshold) {
                Trace.logInfo(this, "WARNING: parallel workers amount for '" + this.name.name + "' event actor reached threshold.");
            }
            this.threadPool.addTask(eventSetProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
        Object object = this.MUTEX;
        synchronized (object) {
            this.eventSet.add(event);
            this.invoke(false);
        }
    }

    @Override
    public int getObjectType() {
        return 32;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.store.getCatalogName();
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet references = this.routine != null ? this.routine.getReferences() : new OrderedHashSet();
        references.addAll(this.getReferencesOnlyActor());
        return references;
    }

    public OrderedHashSet getReferencesOnlyActor() {
        OrderedHashSet references = new OrderedHashSet();
        for (ActorEntry event : this.events) {
            references.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(event.eventId));
        }
        return references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return new OrderedHashSet();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public String getSQLInSchema(String schemaName) {
        return this.getSQL(this.name.getSchemaQualifiedStatementName(schemaName));
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE").append(' ');
        if (!this.async) {
            buffer.append("SYNC").append(' ');
        }
        buffer.append("ACTOR").append(' ');
        buffer.append(name).append(' ');
        buffer.append("ON").append(' ');
        boolean first = true;
        for (ActorEntry entry : this.events) {
            if (!first) {
                buffer.append(",");
            } else {
                first = false;
            }
            buffer.append("[").append(entry.eventId).append("]");
            buffer.append(' ').append("AS").append(' ');
            buffer.append("[").append(entry.alias.name).append("]");
            if (entry.selector == null) continue;
            buffer.append(' ').append("WHEN").append("(");
            buffer.append(entry.selector).append(")");
        }
        buffer.append(' ');
        if (this.eventSetType != null) {
            buffer.append("FOR").append(' ').append(this.eventSetType.name()).append(' ');
            buffer.append("EVENT").append(' ').append("SET");
            buffer.append(' ');
            if (this.windowType != null) {
                buffer.append(this.windowType.name()).append(' ').append("WINDOW").append(' ');
                buffer.append(this.windowSize);
                if (this.windowType == WindowType.TIME && this.timeWindowUnit != null) {
                    buffer.append(' ');
                    SqlUtils.timeUnitToString(buffer, this.timeWindowUnit);
                }
                buffer.append(' ');
            }
        } else {
            buffer.append("FOR").append(' ').append("ANY").append(' ').append("EVENT");
            buffer.append(' ');
        }
        if (this.eventScope != EventScope.INHERITED) {
            buffer.append("EVENT").append(' ').append("SCOPE").append(' ').append(this.eventScope.name());
            buffer.append(' ');
        }
        if (this.workerPoolSize >= 0) {
            if (this.workerPoolType != null) {
                buffer.append(this.workerPoolType.name()).append(' ');
            }
            buffer.append("PARALLEL").append(' ').append("WORKERS").append(' ');
            buffer.append(this.workerPoolSize).append(' ');
            if (this.workerNotifyThreshold > 0) {
                buffer.append("NOTIFY").append(' ').append("THRESHOLD").append(' ');
                buffer.append(this.workerNotifyThreshold).append(' ');
            }
        }
        if (this.maxQueueDepth != 300000) {
            buffer.append("DEPTH").append(' ').append(this.maxQueueDepth).append(' ');
        }
        if (this.routine != null && this.routine.statement != null) {
            buffer.append("AS").append(' ');
            buffer.append(this.routine.statement.getSQL());
        } else {
            buffer.append("AS").append(' ');
            buffer.append(this.rpl);
        }
        if (this.isAutoEnable() || this.shouldBeEnabled) {
            buffer.append(" ").append("ENABLE");
        }
        return buffer.toString();
    }

    public String getPrettyPrintedSQL() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE".toLowerCase()).append(' ');
        if (!this.async) {
            buffer.append("SYNC".toLowerCase()).append(' ');
        }
        buffer.append("ACTOR".toLowerCase()).append(' ');
        buffer.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        buffer.append("ON".toLowerCase()).append(' ');
        buffer.append('\n');
        boolean first = true;
        for (ActorEntry entry : this.events) {
            buffer.append("   ");
            if (!first) {
                buffer.append(",");
            } else {
                first = false;
            }
            buffer.append("[").append(entry.eventId).append("]");
            buffer.append(' ').append("AS".toLowerCase()).append(' ').append(entry.alias.name);
            if (entry.selector != null) {
                buffer.append(' ').append("WHEN".toLowerCase()).append("(");
                buffer.append(entry.selector).append(")");
            }
            buffer.append('\n');
        }
        buffer.append('\n');
        if (this.eventSetType != null) {
            buffer.append("      ");
            buffer.append("FOR".toLowerCase()).append(' ').append(this.eventSetType.name()).append(' ');
            buffer.append("EVENT".toLowerCase()).append(' ').append("SET".toLowerCase());
            buffer.append(' ');
            if (this.windowType != null) {
                buffer.append(this.windowType.name()).append(' ').append("WINDOW").append(' ');
                buffer.append(this.windowSize);
                if (this.timeWindowUnit != null) {
                    SqlUtils.timeUnitToString(buffer, this.timeWindowUnit);
                }
                buffer.append(' ');
            }
        } else {
            buffer.append("FOR").append(' ').append("ANY").append(' ').append("EVENT");
            buffer.append(' ');
        }
        buffer.append('\n');
        if (this.eventScope != EventScope.INHERITED) {
            buffer.append("         ");
            buffer.append("EVENT").append(' ').append("SCOPE").append(' ').append(this.eventScope.name());
            buffer.append('\n');
        }
        if (this.workerPoolType != null) {
            buffer.append("         ");
            buffer.append("PARALLEL").append(' ').append("WORKERS").append(' ');
            buffer.append(this.workerPoolSize).append(' ');
            if (this.workerNotifyThreshold > 0) {
                buffer.append("NOTIFY").append(' ').append("THRESHOLD").append(' ');
                buffer.append(this.workerNotifyThreshold).append(' ');
            }
            buffer.append('\n');
        }
        buffer.append("AS").append('\n');
        buffer.append(this.routine.statement.getSQL());
        return buffer.toString();
    }

    public Result getActorProperties(Session session) {
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result result = Result.newDataResult(metaData);
        result.setNavigator(navigator);
        navigator.add(new Object[]{"Name", this.name.name});
        navigator.add(new Object[]{"Event Scope", this.eventScope.name()});
        String header = "Events";
        for (ActorEntry entry : this.events) {
            Object eventInfo = StringUtils.wrapEventId(entry.eventId);
            if (entry.selector != null) {
                eventInfo = (String)eventInfo + " when (" + entry.selector + ")";
            }
            navigator.add(new Object[]{header, eventInfo});
            header = "";
        }
        if (this.eventSetType != null) {
            navigator.add(new Object[]{"Event Set Type", this.eventSetType});
        } else {
            navigator.add(new Object[]{"Event Set Type", "-"});
        }
        if (this.windowType != null) {
            navigator.add(new Object[]{"Window Type", this.windowType});
            Object windowSizeDef = Long.valueOf(this.windowSize).toString();
            if (this.windowType == WindowType.TIME && this.timeWindowUnit != null) {
                windowSizeDef = (String)windowSizeDef + " " + this.timeWindowUnit.name();
            }
            navigator.add(new Object[]{"Window Size", windowSizeDef});
        }
        if (this.workerPoolSize >= 0) {
            navigator.add(new Object[]{"Worker Pool Type", this.workerPoolType.name()});
            navigator.add(new Object[]{"Worker Pool Size", this.workerPoolSize});
            int activeWorkers = 0;
            if (this.threadPool != null) {
                activeWorkers = this.threadPool.getCurrentThreadsNumber();
            } else if (this.executors != null) {
                activeWorkers = this.executors.size();
            }
            navigator.add(new Object[]{"Active Workers", activeWorkers});
        }
        navigator.add(new Object[]{"Consumer Max Depth", this.getMaxQueueDepth()});
        navigator.add(new Object[]{"Enabled", this.enabled});
        navigator.add(new Object[]{"Comment", this.name.comment != null ? this.name.comment : "---"});
        this.aggregateStateHolder().exposeState(navigator, false, true, "State", new Class[0]);
        return result;
    }

    public List<ActiveEvent> getEvents() {
        ArrayList<ActiveEvent> result = new ArrayList<ActiveEvent>();
        for (ActorEntry entry : this.events) {
            ActiveEvent event = new ActiveEvent(entry.eventId);
            event.setType(ActiveEvent.ActiveEventType.Sink);
            if (entry.selector != null) {
                event.setSelector(entry.selector);
            }
            event.setEventScope(this.dataspace.getEventScope());
            event.setEventModel(SqlUtils.resolveEventModel(DataspaceStoreManager.getRuntimeContext(), entry.eventId));
            result.add(event);
        }
        if (this.routine != null) {
            result.addAll(this.routine.getEvents(this.getObjectName().name, this.dataspace.getEventScope()));
        }
        return result;
    }

    @Override
    public void invalidate(String lastError) {
        this.stateHolder.setSuspectState(DataspaceStateHolder.invalid, lastError);
    }

    @Override
    public DataspaceStateHolder getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public DataspaceStateHolder aggregateStateHolder() {
        DataspaceStateHolder state = (DataspaceStateHolder)this.getStateHolder().clone();
        if (this.dataspace != null) {
            DataspaceStateHolder.aggregateState(state, this.getReferences(), this.dataspace.getStore().schemaManager);
        } else {
            state.setRecoveryFailedState();
        }
        return state;
    }

    @Override
    public String getStateName(DataspaceStoreState state) {
        if (state == DataspaceStoreState.SUSPECT) {
            return state.toString();
        }
        if (this.isEnabled()) {
            return "ENABLED";
        }
        return "DISABLED";
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_ACTOR;
    }

    @Override
    public String getEntityName() {
        return this.getObjectName().name;
    }

    @Override
    public EventScope getEntityScope() {
        return this.eventScope;
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        return null;
    }

    public int getMaxQueueDepth() {
        return this.maxQueueDepth;
    }

    public void setMaxQueueDepth(int maxQueueDepth) {
        this.maxQueueDepth = maxQueueDepth;
    }

    public static enum EventSetType {
        MRE,
        LRE,
        COMPLETE;

    }

    public static enum WindowType {
        TIME,
        BATCH;

    }

    private abstract class EventSet {
        Session eventSetSession;

        private EventSet() {
        }

        abstract void add(ImmutableEventDatagram var1);

        abstract ImmutableEventDatagram get(String var1);

        boolean isComplete() {
            return true;
        }

        abstract long getSize();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void initSession() {
            if (Actor.this.semaphore != null) {
                try {
                    Actor.this.semaphore.acquire();
                }
                catch (InterruptedException error) {
                    return;
                }
            }
            if (Actor.this.workerPoolSize < 0) {
                if (Actor.this.session == null) {
                    Class<Actor> clazz = Actor.class;
                    // MONITORENTER : com.streamscape.ds.schema.event.Actor.class
                    if (Actor.this.session == null) {
                        Actor.this.session = Actor.this.dataspace.createSession();
                    }
                    // MONITOREXIT : clazz
                }
                this.eventSetSession = Actor.this.session;
                return;
            }
            if (Actor.this.workerPoolSize == 0) {
                this.eventSetSession = Actor.this.dataspace.createSession();
                return;
            }
            this.eventSetSession = Actor.this.sessions.remove();
        }

        void closeSession() {
            if (Actor.this.workerNotifyThreshold == 0) {
                this.eventSetSession.close();
                this.eventSetSession = null;
            } else if (Actor.this.workerPoolSize > 0) {
                Actor.this.sessions.add(this.eventSetSession);
                if (Actor.this.semaphore != null) {
                    Actor.this.semaphore.release();
                }
            }
        }
    }

    public static class ActorEntry {
        String eventId;
        String selector;
        NameManager.ObjectName alias;

        public ActorEntry(String eventId, String selector, NameManager.ObjectName alias) {
            this.eventId = eventId;
            this.selector = selector;
            this.alias = alias;
        }

        public String getEventId() {
            return this.eventId;
        }

        public NameManager.ObjectName getAlias() {
            return this.alias;
        }

        public String getSelector() {
            return this.selector;
        }
    }

    private class CompleteEventSet
    extends EventSet {
        long size = 0L;
        BitSet bitSet = new BitSet();

        CompleteEventSet() {
            for (int i = 0; i < Actor.this.events.size(); ++i) {
                this.bitSet.set(i);
            }
        }

        @Override
        void add(ImmutableEventDatagram event) {
            EventQueueCollection collection = Actor.this.eventQueues.get(event.getEventId());
            collection.add(this.eventSetSession, event);
            int index = Actor.this.eventIdToIndex.get(event.getEventId());
            this.bitSet.clear(index);
            ++this.size;
        }

        @Override
        ImmutableEventDatagram get(String eventId) {
            return null;
        }

        @Override
        boolean isComplete() {
            return this.bitSet.isEmpty();
        }

        @Override
        long getSize() {
            return this.size;
        }
    }

    private class LreEventSet
    extends CacheEventSet {
        private LreEventSet(Actor actor) {
        }

        @Override
        void add(ImmutableEventDatagram event) {
            if (!this.eventCache.containsKey(event.getEventId())) {
                this.eventCache.put(event.getEventId(), event);
            }
            ++this.size;
        }
    }

    private class MreEventSet
    extends CacheEventSet {
        private MreEventSet(Actor actor) {
        }

        @Override
        void add(ImmutableEventDatagram event) {
            this.eventCache.put(event.getEventId(), event);
            ++this.size;
        }
    }

    private class AnyEventSet
    extends EventSet {
        ImmutableEventDatagram event;

        private AnyEventSet(Actor actor) {
        }

        @Override
        void add(ImmutableEventDatagram event) {
            this.event = event;
        }

        @Override
        ImmutableEventDatagram get(String eventId) {
            try {
                if (this.event != null && FilterUtils.matches(this.event.getEventId(), eventId)) {
                    return this.event;
                }
            }
            catch (FilterFormatException filterFormatException) {
                // empty catch block
            }
            return null;
        }

        @Override
        long getSize() {
            return this.event != null ? 1L : 0L;
        }
    }

    class TimeWindowTimerTask
    extends AbstractFabricTimerTask {
        TimeWindowTimerTask() {
        }

        @Override
        public void execute(FabricTimer timer) {
            Actor.this.invoke(true);
        }
    }

    private abstract class CacheEventSet
    extends EventSet {
        long size = 0L;
        Map<String, ImmutableEventDatagram> eventCache = new HashMap<String, ImmutableEventDatagram>();

        private CacheEventSet() {
        }

        @Override
        ImmutableEventDatagram get(String eventId) {
            return this.eventCache.get(eventId);
        }

        @Override
        boolean isComplete() {
            return this.eventCache.size() == Actor.this.events.size();
        }

        @Override
        long getSize() {
            return this.size;
        }
    }
}

