/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.constraint;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.ExpressionLogicalAspect;
import com.streamscape.ds.parser.expression.ExpressionLogicalFacet;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.Type;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.sdrpath.ReferencePathException;

public class ReferenceLink
implements SchemaObject {
    private DataspaceStore dataspaceStore;
    private NameManager.ObjectName objectName;
    private ColumnSchema sourceColumn;
    private NameManager.ObjectName sourceColumnObjectName;
    private String sourceSpath;
    private NameManager.ObjectName targetColumnObjectName;
    private String targetSpath;
    private String description;
    private boolean nullable;
    private ExpressionLogicalFacet.FacetJoin facetsJoin;
    private ExpressionLogicalAspect.AspectJoin aspectsJoin;

    public ReferenceLink(DataspaceStore dataspaceStore, NameManager.ObjectName objectName, ColumnSchema sourceColumn, NameManager.ObjectName sourceColumnObjectName, String sourceSpath, NameManager.ObjectName targetColumnObjectName, String targetSpath, String description) {
        this.dataspaceStore = dataspaceStore;
        this.objectName = objectName;
        this.sourceColumn = sourceColumn;
        this.sourceColumnObjectName = sourceColumnObjectName;
        this.sourceSpath = sourceSpath;
        this.targetColumnObjectName = targetColumnObjectName;
        this.targetSpath = targetSpath;
        this.description = description;
        if (this.sourceSpath == null) {
            this.sourceSpath = "";
        }
        if (this.targetSpath == null) {
            this.targetSpath = "";
        }
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ColumnSchema getSourceColumn() {
        return this.sourceColumn;
    }

    public NameManager.ObjectName getSourceColumnObjectName() {
        return this.sourceColumnObjectName;
    }

    public NameManager.ObjectName getSourceColumnSchemaName() {
        return this.sourceColumnObjectName.schema != null ? this.sourceColumnObjectName.schema : this.objectName.schema;
    }

    public String getSourceSpath() {
        return this.sourceSpath;
    }

    public NameManager.ObjectName getTargetColumnObjectName() {
        return this.targetColumnObjectName;
    }

    public NameManager.ObjectName getTargetColumnSchemaName() {
        return this.targetColumnObjectName.schema != null ? this.targetColumnObjectName.schema : this.objectName.schema;
    }

    public String getTargetSpath() {
        return this.targetSpath;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ExpressionLogicalFacet.FacetJoin getFacetsJoin() {
        return this.facetsJoin;
    }

    public ExpressionLogicalAspect.AspectJoin getAspectsJoin() {
        return this.aspectsJoin;
    }

    public DataspaceStateHolder aggregateStateHolder() {
        DataspaceStateHolder state = (DataspaceStateHolder)this.getStateHolder().clone();
        if (this.dataspaceStore != null) {
            DataspaceStateHolder.aggregateState(state, this.getReferences(), this.dataspaceStore.schemaManager);
        } else {
            state.setRecoveryFailedState();
        }
        return state;
    }

    public DataspaceStateHolder getStateHolder() {
        DataspaceStateHolder stateHolder = new DataspaceStateHolder();
        String targetSchemaName = this.getTargetColumnSchemaName().name;
        SchemaObject collection = this.dataspaceStore.schemaManager.findSchemaObject(this.targetColumnObjectName.parent.name, targetSchemaName, 4);
        if (collection == null) {
            collection = this.dataspaceStore.schemaManager.findSchemaObject(this.targetColumnObjectName.parent.name, targetSchemaName, 3);
        }
        if (collection != null) {
            Table table = null;
            table = collection instanceof AbstractCollection ? ((AbstractCollection)collection).getBaseTable() : (Table)collection;
            ColumnSchema targetColumnSchema = table.getColumn(this.targetColumnObjectName.name);
            if (targetColumnSchema != null) {
                if (!(this.sourceSpath != null && this.sourceSpath.length() != 0 || this.targetSpath != null && this.targetSpath.length() != 0)) {
                    if (targetColumnSchema.getDataType().getJDBCTypeCode() != this.sourceColumn.getDataType().getJDBCTypeCode()) {
                        stateHolder.setSuspectState(DataspaceStateHolder.referenceLink(this.getObjectName()), "source and target column types are differ");
                    }
                } else if (this.validateSpath(stateHolder, this.sourceColumn, this.sourceSpath, "source")) {
                    this.validateSpath(stateHolder, targetColumnSchema, this.targetSpath, "target");
                }
            } else {
                stateHolder.setSuspectState(DataspaceStateHolder.referenceLink(this.getObjectName()), "target column doesn't exist");
            }
        } else {
            stateHolder.setSuspectState(DataspaceStateHolder.referenceLink(this.getObjectName()), "target table doesn't exist");
        }
        return stateHolder;
    }

    public void recompileReferenceLink(Session session) {
        Table table;
        ColumnSchema targetColumnSchema;
        String targetSchemaName = this.getTargetColumnSchemaName().name;
        SchemaObject collection = this.dataspaceStore.schemaManager.findSchemaObject(this.targetColumnObjectName.parent.name, targetSchemaName, 4);
        if (collection == null) {
            collection = this.dataspaceStore.schemaManager.findSchemaObject(this.targetColumnObjectName.parent.name, targetSchemaName, 3);
        }
        if (collection != null && (targetColumnSchema = (table = collection instanceof AbstractCollection ? ((AbstractCollection)collection).getBaseTable() : (Table)collection).getColumn(this.targetColumnObjectName.name)) != null) {
            boolean hasDataspaceName = this.targetColumnObjectName.schema != null;
            this.targetColumnObjectName = session.dataspaceStore.nameManager.newObjectName(targetColumnSchema.getObjectName().name, false, 10);
            this.targetColumnObjectName.parent = targetColumnSchema.getObjectName().parent;
            if (hasDataspaceName) {
                this.targetColumnObjectName.schema = targetColumnSchema.getObjectName().schema;
            }
        }
        this.aggregateStateHolder();
    }

    private boolean validateSpath(DataspaceStateHolder stateHolder, ColumnSchema columnSchema, String spath, String name) {
        if (spath != null && spath.length() > 0) {
            if (ReferenceLink.isSpathAllowedForColumn(columnSchema)) {
                try {
                    ReferenceLink.getTypeAtSpath(columnSchema, spath);
                    return true;
                }
                catch (ClassNotFoundException exception) {
                    stateHolder.setSuspectState(DataspaceStateHolder.referenceLink(this.getObjectName()), "failed to load type class for " + name + " column");
                }
                catch (ReferencePathException exception) {
                    stateHolder.setSuspectState(DataspaceStateHolder.referenceLink(this.getObjectName()), "spath doesn't exist for " + name + " column");
                }
            } else {
                stateHolder.setSuspectState(DataspaceStateHolder.referenceLink(this.getObjectName()), "spath is not allowed for " + name + " column");
                return false;
            }
        }
        return false;
    }

    public static String buildColumnName(NameManager.ObjectName objectName) {
        Object name = "";
        if (objectName.schema != null) {
            name = objectName.schema.statementName + ".";
        }
        name = (String)name + NameManager.quoteNameIfNeeded(objectName.parent.name) + "." + NameManager.quoteNameIfNeeded(objectName.name);
        return name;
    }

    @Override
    public int getObjectType() {
        return 37;
    }

    public void setObjectName(NameManager.ObjectName objectName) {
        this.objectName = objectName;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.objectName.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.objectName.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.objectName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet references = new OrderedHashSet();
        references.add(this.sourceColumn.getObjectName());
        references.add(this.sourceColumn.getObjectName().parent);
        return references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return new OrderedHashSet();
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.objectName.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ').append("REFERENCE").append(' ').append("LINK").append(' ').append(name).append(' ');
        if (this.facetsJoin != null || this.aspectsJoin != null) {
            builder.append("AS").append(' ');
            builder.append(this.facetsJoin != null ? "FACET" : "ASPECT").append(" JOIN ON ");
            builder.append(ReferenceLink.buildColumnName(this.sourceColumnObjectName));
            builder.append(", ").append(ReferenceLink.buildColumnName(this.targetColumnObjectName));
            builder.append(" ").append(this.facetsJoin != null ? this.facetsJoin.getSQL() : this.aspectsJoin.getSQL());
        } else {
            builder.append("SOURCE").append(' ');
            builder.append(ReferenceLink.buildColumnName(this.sourceColumnObjectName));
            if (this.sourceSpath != null && this.sourceSpath.length() > 0) {
                builder.append(' ').append("SPATH").append(" '").append(this.sourceSpath).append("'");
            }
            builder.append(' ').append("TARGET").append(' ');
            builder.append(ReferenceLink.buildColumnName(this.targetColumnObjectName));
            if (this.targetSpath != null && this.targetSpath.length() > 0) {
                builder.append(' ').append("SPATH").append(" '").append(this.targetSpath).append("'");
            }
            if (this.nullable) {
                builder.append(' ').append("NULLABLE");
            }
        }
        if (this.description != null) {
            builder.append(" description '").append(this.description).append("'");
        }
        return builder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public static boolean isSpathAllowedForColumn(ColumnSchema column) {
        return ReferenceLink.isSpathAllowedForType(column.getDataType());
    }

    public static boolean isSpathAllowedForType(Type type) {
        if (type == null) {
            return true;
        }
        switch (type.getJDBCTypeCode()) {
            case 1111: 
            case 1113: 
            case 2000: {
                return true;
            }
        }
        return false;
    }

    public static String getColumnTypeName(ColumnSchema column) {
        if (!ReferenceLink.isSpathAllowedForColumn(column) || column.getDataType() == null) {
            return null;
        }
        return column.getDataType().getNameString();
    }

    public static Class<?> getTypeAtSpath(ColumnSchema column, String spath) throws ClassNotFoundException, ReferencePathException {
        String typeName = ReferenceLink.getColumnTypeName(column);
        if (typeName != null && !typeName.equalsIgnoreCase("object") && !typeName.equalsIgnoreCase("other")) {
            SemanticType columnSemanticType = DataspaceStoreManager.getContext().getSemanticTypeCache().lookupSemanticType(typeName);
            Class<?> columnClazz = DataspaceStoreManager.getContext().getSystemClassLoaderChain().loadClass(columnSemanticType.getClassName());
            return DataspaceStoreManager.getContext().getSDRManagerFactory().createManager().getTypeAtPath(spath, columnClazz);
        }
        return null;
    }

    public void setFacetsJoin(ExpressionLogicalFacet.FacetJoin facetsJoin) {
        this.facetsJoin = facetsJoin;
    }

    public void setAspectsJoin(ExpressionLogicalAspect.AspectJoin aspectsJoin) {
        this.aspectsJoin = aspectsJoin;
    }
}

