/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.column;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumnAccessor;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import java.util.ArrayList;
import java.util.List;

public final class ColumnSchema
extends ColumnBase
implements SchemaObject {
    public static final ColumnSchema[] emptyArray = new ColumnSchema[0];
    private NameManager.ObjectName columnName;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    private Expression generatingExpression;
    private NumberSequence sequence;
    private OrderedHashSet references = new OrderedHashSet();
    private OrderedHashSet generatedColumnReferences;
    private List<ReferenceLink> referenceLinks = new ArrayList<ReferenceLink>();

    public ColumnSchema(NameManager.ObjectName name, Type type, boolean isNullable, boolean isPrimaryKey, Expression defaultExpression) {
        this.columnName = name;
        this.dataType = type;
        this.isPrimaryKey = isPrimaryKey;
        this.defaultExpression = defaultExpression;
        this.nullability = isNullable ? (byte)1 : 0;
        this.setReferences();
    }

    @Override
    public int getObjectType() {
        return this.columnName.type;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.columnName;
    }

    @Override
    public String getNameString() {
        return this.columnName.name;
    }

    @Override
    public String getTableNameString() {
        return this.columnName.parent == null ? null : this.columnName.parent.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.columnName.schema;
    }

    @Override
    public String getSchemaNameString() {
        return this.columnName.schema == null ? null : this.columnName.schema.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.columnName.schema == null ? null : this.columnName.schema.schema;
    }

    @Override
    public String getCatalogNameString() {
        return this.columnName.schema == null ? null : (this.columnName.schema.schema == null ? null : this.columnName.schema.schema.name);
    }

    @Override
    public Grantee getOwner() {
        return this.columnName.schema == null ? null : this.columnName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject table) {
        if (this.generatingExpression == null) {
            return;
        }
        this.generatingExpression.resetColumnReferences();
        this.generatingExpression.resolveCheckOrGenExpression(session, ((Table)table).defaultRanges, false);
        if (this.dataType.typeComparisonGroup != this.generatingExpression.getDataType().typeComparisonGroup) {
            throw Error.error(5561);
        }
        this.setReferences();
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.columnName != null ? this.columnName.statementName : null);
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        switch (this.parameterMode) {
            case 1: {
                sb.append("IN").append(' ');
                break;
            }
            case 4: {
                sb.append("OUT").append(' ');
                break;
            }
            case 2: {
                sb.append("INOUT").append(' ');
            }
        }
        if (name != null) {
            sb.append(name);
            sb.append(' ');
        }
        sb.append(this.dataType.getTypeDefinition());
        if (this.dataType.hasCollation()) {
            sb.append(' ').append("COLLATE").append(' ');
            sb.append(this.dataType.getCollationDefinition());
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public void setType(Type type) {
        this.dataType = type;
        this.setReferences();
    }

    public void setName(NameManager.ObjectName name) {
        this.columnName = name;
    }

    public void setIdentity(NumberSequence sequence) {
        this.sequence = sequence;
        this.isIdentity = sequence != null;
    }

    public void setType(ColumnSchema other) {
        this.nullability = other.nullability;
        this.dataType = other.dataType;
    }

    public NumberSequence getIdentitySequence() {
        return this.sequence;
    }

    @Override
    public boolean isNullable() {
        boolean isNullable = super.isNullable();
        if (isNullable && (this.dataType.isDomainType() || this.dataType.isDistinctType())) {
            return this.dataType.userTypeModifier.isNullable();
        }
        return isNullable;
    }

    @Override
    public byte getNullability() {
        return this.isPrimaryKey ? (byte)0 : super.getNullability();
    }

    public boolean isGenerated() {
        return this.generatingExpression != null;
    }

    public boolean hasDefault() {
        return this.getDefaultExpression() != null;
    }

    @Override
    public boolean isWriteable() {
        return !this.isGenerated();
    }

    @Override
    public void setWriteable(boolean value) {
        throw Error.runtimeError(201, "ColumnSchema");
    }

    @Override
    public boolean isSearchable() {
        return Types.isSearchable(this.dataType.typeCode);
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
    }

    public Object getDefaultValue(Session session) {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.dataType);
    }

    public Object getGeneratedValue(Session session) {
        return this.generatingExpression == null ? null : this.generatingExpression.getValue(session, this.dataType);
    }

    public String getDefaultSQL() {
        String ddl = null;
        ddl = this.defaultExpression == null ? null : this.defaultExpression.getSQL();
        return ddl;
    }

    public Expression getDefaultExpression() {
        if (this.defaultExpression == null) {
            if (this.dataType.isDomainType()) {
                return this.dataType.userTypeModifier.getDefaultClause();
            }
            return null;
        }
        return this.defaultExpression;
    }

    public void setDefaultExpression(Expression expr) {
        this.defaultExpression = expr;
    }

    public Expression getGeneratingExpression() {
        return this.generatingExpression;
    }

    public void setGeneratingExpression(Expression expr) {
        this.generatingExpression = expr;
    }

    public ColumnSchema duplicate() {
        ColumnSchema copy = new ColumnSchema(this.columnName, this.dataType, true, this.isPrimaryKey, this.defaultExpression);
        copy.setNullability(this.nullability);
        copy.setGeneratingExpression(this.generatingExpression);
        copy.setIdentity(this.sequence);
        return copy;
    }

    public Expression getAccessor() {
        ExpressionColumnAccessor expr = new ExpressionColumnAccessor(this);
        return expr;
    }

    public OrderedHashSet getGeneratedColumnReferences() {
        return this.generatedColumnReferences;
    }

    public void setReferences() {
        String eventId;
        this.references.clear();
        if (this.generatedColumnReferences != null) {
            this.generatedColumnReferences.clear();
        }
        if (this.dataType.isDomainType() || this.dataType.isDistinctType()) {
            NameManager.ObjectName name = this.dataType.getObjectName();
            this.references.add(name);
        }
        if (this.dataType instanceof EventType && (eventId = ((EventType)this.dataType).getEventId()) != null && eventId.length() > 0) {
            this.references.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(eventId));
        }
        if (this.generatingExpression != null) {
            this.generatingExpression.collectObjectNames(this.references);
            Iterator it = this.references.iterator();
            while (it.hasNext()) {
                NameManager.ObjectName name = (NameManager.ObjectName)it.next();
                if (name.type != 10 && name.type != 3) continue;
                it.remove();
                if (this.generatedColumnReferences == null) {
                    this.generatedColumnReferences = new OrderedHashSet();
                }
                if (name.type != 10) continue;
                this.generatedColumnReferences.add(name);
            }
        }
        this.referenceLinks.forEach(l -> this.references.add(l.getObjectName()));
    }

    public void addReferenceLink(ReferenceLink referenceLink) {
        this.referenceLinks.add(referenceLink);
    }
}

