/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.vtable;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.collection.tspace.vtable.VirtualTableProxy;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.Collation;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModel;
import com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModelGenerator;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.sql.DatabaseDescriptor;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.SQLTableName;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class VirtualTableCollection
extends TableCollection
implements VirtualTable.VirtualTableHelper {
    protected VirtualServerObject server = null;
    protected String externalName = null;
    protected String externalSchema = null;
    protected String externalQuery = null;
    protected String externalQuerySql = null;
    protected List<VColumnInfo> vtableColumns = null;
    protected List<String> externalQueryParams = null;
    protected List<Expression> initExprs = null;
    protected MemoryModel dataCacheModel = null;
    protected boolean materialized = false;
    protected String parameters = null;
    protected String columnNames = null;
    private List<JdbcModel.JdbcForeignKey> sourceForeignKeys = new ArrayList<JdbcModel.JdbcForeignKey>();
    private List<JdbcModel.JdbcForeignKey> targetForeignKeys = new ArrayList<JdbcModel.JdbcForeignKey>();
    private List<JdbcModel.JdbcIndex> indexes = new ArrayList<JdbcModel.JdbcIndex>();

    public VirtualTableCollection(DataspaceStore database, NameManager.ObjectName name) {
        super(database, name, CollectionType.VTABLE, MemoryModel.MEMORY);
    }

    @Override
    protected void doCreateTable(DataspaceStore database, NameManager.ObjectName tableName, int tableType) {
        this.table = TableUtil.newVirtualTable(this.store, tableName, this, this.dataCacheModel == null ? 2 : this.getInternalTableType(this.dataCacheModel));
    }

    public VirtualServerObject getServer() {
        return this.server;
    }

    public void setServer(VirtualServerObject server) {
        this.server = server;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public String getExternalSchema() {
        return this.externalSchema;
    }

    public void setExternalSchema(String externalSchema) {
        this.externalSchema = externalSchema;
    }

    public String getExternalQuery() {
        return this.externalQuery;
    }

    public MemoryModel getDataCacheModel() {
        return this.dataCacheModel;
    }

    public List<JdbcModel.JdbcForeignKey> getSourceForeignKeys() {
        return this.sourceForeignKeys;
    }

    public List<JdbcModel.JdbcForeignKey> getTargetForeignKeys() {
        return this.targetForeignKeys;
    }

    public List<JdbcModel.JdbcIndex> getIndexes() {
        return this.indexes;
    }

    public void setDataCacheModel(MemoryModel dataCacheModel) {
        this.dataCacheModel = dataCacheModel;
    }

    @Override
    public boolean hasParameter(String name) {
        if (this.externalQueryParams != null) {
            for (String param : this.externalQueryParams) {
                if (!param.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String getServerType(Session session) {
        if (this.getServer() != null) {
            return this.getServer().getServerType();
        }
        return null;
    }

    public void setExternalQuery(String externalQuery) {
        this.externalQuery = externalQuery;
        if (externalQuery == null || externalQuery.length() == 0) {
            return;
        }
        this.externalQuerySql = externalQuery;
        int index = 0;
        while ((index = this.externalQuerySql.indexOf("${")) != -1) {
            int index2 = this.externalQuerySql.indexOf(125, index);
            if (index2 == -1) continue;
            if (this.externalQueryParams == null) {
                this.externalQueryParams = new ArrayList<String>();
            }
            this.externalQueryParams.add(this.externalQuerySql.substring(index + 2, index2).trim());
            this.externalQuerySql = this.externalQuerySql.substring(0, index) + "?" + this.externalQuerySql.substring(index2 + 1);
        }
    }

    public void setInitExpressions(List<Expression> exprs) {
        if (this.externalQueryParams != null && exprs != null && this.externalQueryParams.size() != exprs.size()) {
            throw new DataspaceException("Number of external query parameters not match number of init values.");
        }
        this.initExprs = exprs;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        if (this.externalQuery != null && this.externalQueryParams != null && this.initExprs == null) {
            throw new DataspaceException("Init values are not specified for query parameters.");
        }
        if (this.table == null || this.table.columnList == null || this.table.columnList.size() == 0) {
            NameManager.ObjectName viewName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
            viewName.schema = this.name.schema;
            this.doCreateTable(this.store, viewName, this.dataCacheModel == null ? 2 : this.getInternalTableType(this.dataCacheModel));
            this.buildInternalTableFromRemote(session, this.table);
        } else {
            this.buildParametersAndColumnNames(this.table, null);
        }
        super.compile(session, parentObject);
    }

    @Override
    public void open(Session session) {
        super.open(session);
    }

    public Table newInternalTable(Session session) {
        NameManager.ObjectName tableName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        tableName.schema = this.name.schema;
        this.doCreateTable(this.store, tableName, this.dataCacheModel == null ? 2 : this.getInternalTableType(this.dataCacheModel));
        return TableUtil.newVirtualTable(this.store, tableName, this, this.dataCacheModel == null ? 2 : this.getInternalTableType(this.dataCacheModel));
    }

    public Table buildInternalTableFromRemote(Session session) {
        return this.buildInternalTableFromRemote(session, TableUtil.newVirtualTable(this.store, this.table.getObjectName(), this, this.table.getTableType()));
    }

    public Table buildInternalTableFromRemote(Session session, Table rebuiltTable) {
        if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
            return null;
        }
        if (!this.server.isRunning()) {
            throw new DataspaceException("Virtual server is not running.");
        }
        DatabaseConnection connection = this.server.getConnection();
        try {
            Object meta;
            int i;
            if (connection.getState() != ConnectionState.CONNECTED) {
                throw new DataspaceException("Virtual server not connected to remote server.");
            }
            List<Object> columns = new ArrayList();
            ArrayList primaryColumnNames = new ArrayList();
            if (this.externalQuery != null && (this.vtableColumns == null || this.vtableColumns.size() == 0)) {
                ArrayList<Object> externalQueryParamsValues = new ArrayList<Object>();
                if (this.externalQueryParams != null) {
                    for (i = 0; i < this.externalQueryParams.size(); ++i) {
                        Expression expr = this.initExprs.get(i);
                        if (expr != null) {
                            externalQueryParamsValues.add(expr.getValue(session));
                            continue;
                        }
                        externalQueryParamsValues.add(null);
                    }
                }
                columns = DatabaseDescriptor.getQueryColumns(this.externalQuerySql, connection, externalQueryParamsValues);
            } else if (this.externalName != null || this.externalQuery == null) {
                StringBuilder fullTableName = new StringBuilder();
                if (this.externalSchema != null) {
                    fullTableName.append('[').append(this.externalSchema).append("].");
                }
                if (this.externalName != null) {
                    fullTableName.append('[').append(this.externalName).append(']');
                } else {
                    fullTableName.append('[').append(this.name.name).append(']');
                }
                SQLTableName tableName = SQLTableName.parse(fullTableName.toString());
                Trace.logDebug(this, "Retrieving remote table meta information...");
                columns = DatabaseDescriptor.getTableColumns(tableName, connection, null, 1);
                String primaryKeyName = null;
                meta = connection.getMetaData();
                Trace.logDebug(this, "Retrieving remote table primary keys...");
                ResultSet result = meta.getPrimaryKeys(connection.getCatalog(), tableName.getSchema(), tableName.getTable());
                TreeMap<Short, String> keys = new TreeMap<Short, String>();
                while (result.next()) {
                    keys.put(result.getShort("KEY_SEQ"), result.getString("COLUMN_NAME"));
                    primaryKeyName = result.getString("PK_NAME");
                }
                primaryColumnNames.addAll(keys.values());
                Trace.logDebug(this, "Retrieving remote table foreign keys...");
                ResultSet importedKeys = meta.getImportedKeys(connection.getCatalog(), tableName.getSchema(), tableName.getTable());
                this.sourceForeignKeys = JdbcModelGenerator.extractForeignKeys((ResultSet)importedKeys);
                ResultSet exportedKeys = meta.getExportedKeys(connection.getCatalog(), tableName.getSchema(), tableName.getTable());
                this.targetForeignKeys = JdbcModelGenerator.extractForeignKeys((ResultSet)exportedKeys);
                Trace.logDebug(this, "Retrieving remote table indexes...");
                ResultSet resultSet = meta.getIndexInfo(connection.getCatalog(), tableName.getSchema(), tableName.getTable(), false, true);
                this.indexes = JdbcModelGenerator.extractIndexes((ResultSet)resultSet, (String)primaryKeyName, this.sourceForeignKeys);
            }
            ArrayList<VtableColumnsMetaData> columnsMeta = new ArrayList<VtableColumnsMetaData>();
            if (this.vtableColumns != null && this.vtableColumns.size() > 0) {
                JdbcModel.JdbcForeignKey key;
                List vtableColumnsRemoteNames = this.vtableColumns.stream().map(c -> c.getRemoteColumnName()).collect(Collectors.toList());
                if (!vtableColumnsRemoteNames.containsAll(primaryColumnNames)) {
                    primaryColumnNames.clear();
                }
                Iterator<JdbcModel.JdbcIndex> iterator = this.indexes.iterator();
                while (iterator.hasNext()) {
                    JdbcModel.JdbcIndex index = iterator.next();
                    if (vtableColumnsRemoteNames.containsAll(index.indexColumns.stream().map(c -> c.columnName).collect(Collectors.toList()))) continue;
                    iterator.remove();
                }
                iterator = this.sourceForeignKeys.iterator();
                while (iterator.hasNext()) {
                    key = (JdbcModel.JdbcForeignKey)iterator.next();
                    if (vtableColumnsRemoteNames.contains(key.pkColumnName)) continue;
                    iterator.remove();
                }
                iterator = this.targetForeignKeys.iterator();
                while (iterator.hasNext()) {
                    key = (JdbcModel.JdbcForeignKey)iterator.next();
                    if (vtableColumnsRemoteNames.contains(key.fkColumnName)) continue;
                    iterator.remove();
                }
                for (int i2 = 0; i2 < this.vtableColumns.size(); ++i2) {
                    VColumnInfo vColumnInfo = this.vtableColumns.get(i2);
                    String remoteColumnName = vColumnInfo.getRemoteColumnName();
                    SQLQueryParameter column = columns.stream().filter(c -> c.getName().equals(remoteColumnName)).findFirst().orElse(null);
                    VtableColumnsMetaData meta2 = new VtableColumnsMetaData();
                    meta2.columnName = vColumnInfo.vColumnName;
                    meta2.remoteColumnName = remoteColumnName;
                    meta2.definedType = vColumnInfo.type;
                    meta2.columnIndex = i2;
                    if (column == null) {
                        if (vColumnInfo.type == null) {
                            throw new DataspaceException("Vtable column '" + vColumnInfo.vColumnName + "' don't have type defined and '" + remoteColumnName + "' not found in remote table.");
                        }
                    } else {
                        meta2.type = column.getType();
                        meta2.precision = column.getPrecision();
                        meta2.scale = column.getScale();
                        meta2.primaryKeyIndex = primaryColumnNames.indexOf(remoteColumnName);
                        meta2.nullable = column.isNullable();
                    }
                    columnsMeta.add(meta2);
                }
            } else {
                i = 0;
                while (i < columns.size()) {
                    SQLQueryParameter column = (SQLQueryParameter)columns.get(i);
                    meta = new VtableColumnsMetaData();
                    ((VtableColumnsMetaData)meta).columnName = column.getName();
                    ((VtableColumnsMetaData)meta).remoteColumnName = column.getName();
                    ((VtableColumnsMetaData)meta).type = column.getType();
                    ((VtableColumnsMetaData)meta).precision = column.getPrecision();
                    ((VtableColumnsMetaData)meta).scale = column.getScale();
                    ((VtableColumnsMetaData)meta).columnIndex = i++;
                    ((VtableColumnsMetaData)meta).primaryKeyIndex = primaryColumnNames.indexOf(column.getName());
                    ((VtableColumnsMetaData)meta).nullable = column.isNullable();
                    columnsMeta.add((VtableColumnsMetaData)meta);
                }
            }
            this.buildTable(rebuiltTable, columnsMeta);
            Trace.logDebug(this, "Internal table structure built.");
        }
        catch (SQLException exception) {
            throw VirtualServerObject.sqlToDataspaceException(connection, exception);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            throw new DataspaceException(exception.getMessage());
        }
        finally {
            if (connection != null) {
                this.server.releaseConnection(connection);
            }
        }
        rebuiltTable.compile(session, null);
        this.buildParametersAndColumnNames(rebuiltTable, connection);
        return rebuiltTable;
    }

    private void buildTable(Table rebuiltTable, List<VtableColumnsMetaData> columnsMeta) {
        TreeMap<Integer, Integer> keys = new TreeMap<Integer, Integer>();
        for (int i = 0; i < columnsMeta.size(); ++i) {
            VtableColumnsMetaData columnMeta = columnsMeta.get(i);
            Trace.logDebug(this, "Creating new column '" + columnMeta.columnName + "', " + (columnMeta.definedType != null ? "type:" + columnMeta.definedType.getNameString() : "type code: " + columnMeta.type));
            Type type = columnMeta.definedType;
            if (type == null) {
                int metaType = columnMeta.type;
                long precision = columnMeta.precision;
                if (metaType == 2004 || metaType == -4 || metaType == 1119) {
                    metaType = -3;
                    precision = 0x1000000L;
                }
                if (metaType == 2005) {
                    metaType = 12;
                    precision = 0x1000000L;
                }
                type = Type.getType(metaType, null, null, precision, columnMeta.scale);
            }
            NameManager.ObjectName cn = NameManager.newInfoSchemaColumnName(columnMeta.columnName, rebuiltTable.getObjectName(), true);
            rebuiltTable.addColumn(new ColumnSchema(cn, type, columnMeta.nullable, columnMeta.primaryKeyIndex != -1, null));
            if (columnMeta.primaryKeyIndex == -1) continue;
            keys.put(columnMeta.primaryKeyIndex, i);
        }
        ArrayList primaryIndexes = new ArrayList(keys.values());
        int[] primaryIndexesArray = new int[primaryIndexes.size()];
        for (int i = 0; i < primaryIndexes.size(); ++i) {
            primaryIndexesArray[i] = (Integer)primaryIndexes.get(i);
        }
        NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(rebuiltTable.getObjectName().name, rebuiltTable.getObjectName().isNameQuoted, 21);
        rebuiltTable.createPrimaryKeyConstraint(internalTableIndexName, primaryIndexesArray, false);
        if (this.externalQuery != null && this.externalQuery.length() > 0 || this.vtableColumns != null && this.vtableColumns.size() > 0) {
            rebuiltTable.setDataReadOnly(true);
        } else {
            rebuiltTable.setDataReadOnly(false);
        }
    }

    private void buildParametersAndColumnNames(Table rebuiltTable, Connection connection) {
        StringBuilder params = new StringBuilder();
        StringBuilder names = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < rebuiltTable.columnList.size(); ++i) {
            if (!first) {
                params.append(',');
                names.append(',');
            } else {
                first = false;
            }
            params.append('?');
            String columnName = rebuiltTable.getColumn((int)i).getObjectName().name;
            if (this.vtableColumns != null && this.vtableColumns.size() > 0) {
                columnName = this.vtableColumns.get(i).getRemoteColumnName();
            }
            names.append(DatabaseDescriptor.quoteColumnName(columnName, this.server.getJDBCDriverClassName()));
        }
        this.parameters = params.toString();
        this.columnNames = names.toString();
    }

    public void replaceInternalTable(Session session, Table rebuiltTable) {
        this.table = rebuiltTable;
        this.invalidateCache();
    }

    @Override
    public void insertIntoExternal(Session session, Object[] data, int[] jdbcTypes) {
        this.checkServerAccess(session);
        DatabaseConnection connection = this.getVirtualConnectionForInsertUpdate(session);
        Statement statement = null;
        try {
            String sql = "insert into " + this.getExternalTableFullName(connection) + "(" + this.columnNames + ") values (" + this.parameters + ")";
            statement = connection.prepareStatement(sql);
            Object[] convertedData = new Object[data.length];
            for (int i = 1; i <= this.table.columnCount; ++i) {
                Object value = data[i - 1];
                if (value == null) {
                    statement.setNull(i, jdbcTypes[i - 1]);
                    continue;
                }
                value = this.table.colTypes[i - 1].convertSQLToJava(session, value);
                convertedData[i - 1] = value = this.convertInsertUpdateValue(connection, value);
                if (VirtualServerObject.isMSSQLConnection(connection) && value instanceof Timestamp) {
                    value = DataspaceDateTime.getSqlTimestampString((Timestamp)value, session.getTimeZone());
                    statement.setObject(i, value);
                    continue;
                }
                statement.setObject(i, value, jdbcTypes[i - 1]);
            }
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logDebug(this, "Executing insert:\n{}\n{}", sql, ReplicationTarget.printPreparedStatement(session, sql, convertedData));
            }
            statement.execute();
            Trace.logDebug(this, "Execution finished.");
        }
        catch (SQLException exception) {
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            throw VirtualServerObject.sqlToDataspaceException(connection, exception);
        }
        catch (Exception exception) {
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            throw new DataspaceException(exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                this.releaseVirtualConnectionForInsertUpdate(session, connection);
            }
        }
    }

    private Object convertInsertUpdateValue(DatabaseConnection connection, Object value) {
        if (VirtualServerObject.isSybaseConnection(connection) && value instanceof BigInteger) {
            value = new BigDecimal((BigInteger)value);
        }
        return value;
    }

    @Override
    public Result executeExternalUpdate(Session session, String sql, Object[] data, int[] jdbcTypes) {
        this.checkServerAccess(session);
        DatabaseConnection connection = this.getVirtualConnectionForInsertUpdate(session);
        Statement statement = null;
        int count = 0;
        try {
            Object tokenizer;
            if (data != null && data.length > 0) {
                String currentToken;
                tokenizer = new StringTokenizer(this.replaceWithExternalTableName(sql, connection), "=");
                StringBuilder result = new StringBuilder();
                boolean whereClause = false;
                boolean[] nullParams = new boolean[data.length];
                Object[] convertedParams = new Object[data.length];
                int convertedParamsLength = 0;
                int currentParam = 0;
                if (((StringTokenizer)tokenizer).hasMoreTokens()) {
                    currentToken = ((StringTokenizer)tokenizer).nextToken();
                    if (currentToken.toLowerCase().matches(".*\\s+where\\s+.*")) {
                        whereClause = true;
                    }
                    result.append(currentToken);
                }
                while (((StringTokenizer)tokenizer).hasMoreTokens()) {
                    currentToken = ((StringTokenizer)tokenizer).nextToken();
                    if (!whereClause && currentToken.toLowerCase().matches(".*\\s+where\\s+.*")) {
                        result.append("=" + currentToken);
                        whereClause = true;
                        if (!currentToken.trim().startsWith("?")) continue;
                        convertedParams[convertedParamsLength++] = data[currentParam];
                        ++currentParam;
                        continue;
                    }
                    if (currentToken.trim().startsWith("?")) {
                        if (data[currentParam] == null && whereClause) {
                            nullParams[currentParam] = true;
                            int indexOfQuestion = currentToken.indexOf(63);
                            result.append(" is NULL " + currentToken.substring(indexOfQuestion + 1));
                        } else {
                            nullParams[currentParam] = false;
                            result.append("=" + currentToken);
                            convertedParams[convertedParamsLength++] = data[currentParam];
                        }
                        ++currentParam;
                        continue;
                    }
                    result.append("=" + currentToken);
                }
                sql = result.toString();
                statement = connection.prepareStatement(sql);
                convertedParams = Arrays.copyOf(convertedParams, convertedParamsLength);
                currentParam = 0;
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == null) {
                        if (nullParams[i]) continue;
                        ((PreparedStatement)statement).setNull(currentParam + 1, jdbcTypes[i]);
                        ++currentParam;
                        continue;
                    }
                    data[i] = this.convertInsertUpdateValue(connection, data[i]);
                    if (VirtualServerObject.isMSSQLConnection(connection) && data[i] instanceof Timestamp) {
                        data[i] = DataspaceDateTime.getSqlTimestampString((Timestamp)data[i], session.getTimeZone());
                        ((PreparedStatement)statement).setObject(currentParam + 1, data[i]);
                    } else {
                        ((PreparedStatement)statement).setObject(currentParam + 1, data[i], jdbcTypes[i]);
                    }
                    ++currentParam;
                }
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logDebug(this, "Executing update/delete:\n{}\n{}", sql, ReplicationTarget.printPreparedStatement(session, sql, convertedParams));
                }
                if (!((PreparedStatement)statement).execute()) {
                    count = statement.getUpdateCount();
                }
            } else {
                statement = connection.createStatement();
                sql = this.replaceWithExternalTableName(sql, connection);
                Trace.logDebug(this, "Executing update/delete {}", sql);
                count = statement.executeUpdate(this.replaceWithExternalTableName(sql, connection));
            }
            Trace.logDebug(this, "Update count result: {}", count);
            tokenizer = new Result(1, count);
            return tokenizer;
        }
        catch (SQLException exception) {
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            throw VirtualServerObject.sqlToDataspaceException(connection, exception);
        }
        catch (Exception exception) {
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            throw new DataspaceException(exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                this.releaseVirtualConnectionForInsertUpdate(session, connection);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void materialize(Session session) {
        this.checkServerAccess(session);
        if (this.dataCacheModel != null && this.materialized) {
            return;
        }
        this.table.getRowStore(session).removeAll();
        DatabaseConnection connection = this.server.getConnection();
        Statement statement = null;
        ResultSet result = null;
        try {
            if (this.externalQuery != null) {
                statement = connection.prepareStatement(this.externalQuerySql);
                if (this.externalQueryParams != null) {
                    for (int i = 1; i <= this.externalQueryParams.size(); ++i) {
                        Expression paramValue = session.sessionContext.getVtableParameter(this.getObjectName(), this.externalQueryParams.get(i - 1));
                        if (paramValue != null) {
                            ((PreparedStatement)statement).setObject(i, paramValue.getValue(session));
                            continue;
                        }
                        Trace.logError(this, "Table '" + this.name.name + "' parameter '" + this.externalQueryParams.get(i - 1) + "' is not set, defaults to NULL.");
                        ((PreparedStatement)statement).setNull(i, this.table.getColumn(i).getDataType().getJDBCTypeCode());
                    }
                }
                if (!((PreparedStatement)statement).execute()) throw new DataspaceException("Unable to retrieve data from virtual table source.");
                result = statement.getResultSet();
                if (result.getMetaData().getColumnCount() != this.table.columnCount) {
                    throw new DataspaceException("External query returned " + result.getMetaData().getColumnCount() + " columns, but expected " + this.table.columnCount + ".");
                }
            } else {
                statement = connection.createStatement();
                result = statement.executeQuery("select " + this.columnNames + " from " + this.getExternalTableFullName(connection));
            }
            while (result.next()) {
                Object[] temp = new Object[this.table.getColumnCount()];
                block21: for (int i = 1; i <= this.table.getColumnCount(); ++i) {
                    switch (this.table.colTypes[i - 1].typeCode) {
                        case 91: {
                            temp[i - 1] = this.table.colTypes[i - 1].convertJavaToSQL(session, result.getDate(i));
                            continue block21;
                        }
                        case 92: 
                        case 94: {
                            temp[i - 1] = this.table.colTypes[i - 1].convertJavaToSQL(session, result.getTime(i));
                            continue block21;
                        }
                        case 93: 
                        case 95: {
                            temp[i - 1] = this.table.colTypes[i - 1].convertJavaToSQL(session, result.getTimestamp(i));
                            continue block21;
                        }
                        default: {
                            temp[i - 1] = result.getObject(i);
                            if (!(temp[i - 1] instanceof byte[])) continue block21;
                            temp[i - 1] = new BinaryData((byte[])temp[i - 1], false);
                        }
                    }
                }
                this.table.insertNoCheckFromLog(session, temp);
            }
            this.materialized = true;
            return;
        }
        catch (SQLException exception) {
            throw VirtualServerObject.sqlToDataspaceException(connection, exception);
        }
        catch (Throwable error) {
            Trace.logException(this, error, true);
            throw new DataspaceException(error);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception error) {
                    Trace.logError(this, error.getMessage());
                }
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception error) {
                    Trace.logError(this, error.getMessage());
                }
            }
            if (connection != null) {
                this.server.releaseConnection(connection);
            }
        }
    }

    private String getExternalTableFullName(Connection connection) {
        StringBuilder fullTableName = new StringBuilder();
        if (this.externalSchema != null) {
            fullTableName.append(DatabaseDescriptor.quoteTableName(this.externalSchema, connection)).append(".");
        }
        if (this.externalName != null) {
            fullTableName.append(DatabaseDescriptor.quoteTableName(this.externalName, connection));
        } else {
            fullTableName.append(DatabaseDescriptor.quoteTableName(this.name.name, connection));
        }
        return fullTableName.toString();
    }

    private String replaceWithExternalTableName(String sql, Connection connection) {
        sql = sql.trim();
        String lowerSql = sql.toLowerCase();
        int index = 0;
        int endIndex = 0;
        if (lowerSql.startsWith("delete")) {
            index = this.skipSpaces(lowerSql, 6);
            if (index < lowerSql.length() && lowerSql.startsWith("from", index) && (index = this.skipSpaces(lowerSql, index + 4)) < lowerSql.length()) {
                endIndex = this.nextSpace(lowerSql, index);
            }
        } else if (lowerSql.startsWith("update") && (index = this.skipSpaces(lowerSql, 6)) < lowerSql.length()) {
            endIndex = this.nextSpace(lowerSql, index);
        }
        if (endIndex != 0 && index != 0) {
            String newSql = sql.substring(0, index) + " " + this.getExternalTableFullName(connection);
            if (endIndex < sql.length()) {
                newSql = newSql + " " + sql.substring(endIndex);
            }
            return newSql;
        }
        return sql;
    }

    private int skipSpaces(String s, int index) {
        while (index < s.length() && this.isSpace(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    private int nextSpace(String s, int index) {
        while (index < s.length() && !this.isSpace(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    private boolean isSpace(char c) {
        return " \n\r\t".indexOf(c) != -1;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new VirtualTableProxy();
    }

    @Override
    public Result getCollectionProperties(Session session) {
        boolean first;
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"Server", this.server.getObjectName().name});
        if (this.externalName != null) {
            result.navigator.add(new Object[]{"External Name", this.externalName});
        }
        if (this.externalSchema != null) {
            result.navigator.add(new Object[]{"External Schema", this.externalSchema});
        }
        if (this.externalQuery != null) {
            result.navigator.add(new Object[]{"External Query", this.externalQuery});
            if (this.externalQueryParams != null) {
                first = true;
                for (String string : this.externalQueryParams) {
                    if (first) {
                        result.navigator.add(new Object[]{"Query Parameters", string});
                        first = false;
                        continue;
                    }
                    result.navigator.add(new Object[]{"", string});
                }
            }
            if (this.initExprs != null) {
                first = true;
                for (Expression expression : this.initExprs) {
                    if (first) {
                        result.navigator.add(new Object[]{"Initial Values", expression.getSQL()});
                        first = false;
                        continue;
                    }
                    result.navigator.add(new Object[]{"", expression.getSQL()});
                }
            }
        }
        if (this.dataCacheModel != null) {
            result.navigator.add(new Object[]{"Data Cache", this.dataCacheModel.name()});
        } else {
            result.navigator.add(new Object[]{"Data Cache", "DISABLED"});
        }
        if (this.vtableColumns != null && this.vtableColumns.size() > 0) {
            first = true;
            for (VColumnInfo vColumnInfo : this.vtableColumns) {
                Object s = vColumnInfo.vColumnName;
                if (vColumnInfo.remoteColumnName != null) {
                    s = (String)s + " as [" + vColumnInfo.remoteColumnName + "]";
                }
                if (vColumnInfo.type != null) {
                    s = (String)s + " " + vColumnInfo.type.getNameString();
                }
                result.navigator.add(new Object[]{first ? "Columns" : "", s});
                first = false;
            }
        }
        return result;
    }

    @Override
    protected void onAggregateOthers(DataspaceStateHolder holder) {
        ConnectionState connectionState;
        if (this.server != null && (connectionState = this.server.getConnectionState()) != ConnectionState.OPEN && connectionState != ConnectionState.CONNECTED) {
            holder.setSuspectState(DataspaceStateHolder.serverConnection, "server state is '" + String.valueOf((Object)connectionState) + "'");
        }
    }

    public void invalidateCache() {
        this.materialized = false;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        set.add(this.server.getObjectName());
        return set;
    }

    @Override
    public String getSQL() {
        return this.getSQL(true);
    }

    public String getSQL(boolean forLog) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE").append(' ').append("VTABLE").append(' ');
        buffer.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        if (forLog) {
            buffer.append(this.getColumnsInfo());
        }
        buffer.append(' ');
        buffer.append("AT").append(' ').append(this.server.getObjectName().getSchemaQualifiedStatementName());
        if (this.vtableColumns != null && this.vtableColumns.size() > 0) {
            buffer.append(" ").append("COLUMNS").append("(");
            for (int i = 0; i < this.vtableColumns.size(); ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                VColumnInfo vtableColumn = this.vtableColumns.get(i);
                buffer.append(DatabaseDescriptor.quoteColumnName(vtableColumn.vColumnName));
                if (vtableColumn.remoteColumnName != null) {
                    buffer.append(" as ").append(DatabaseDescriptor.quoteColumnName(vtableColumn.remoteColumnName));
                }
                if (vtableColumn.type == null) continue;
                buffer.append(" ").append(vtableColumn.type.getTypeDefinition());
            }
            buffer.append(")");
        }
        if (this.externalName != null) {
            buffer.append(' ').append("EXTERNAL").append(' ').append("NAME").append(' ');
            buffer.append('\'').append(this.externalName).append('\'');
        }
        if (this.externalSchema != null) {
            buffer.append(' ').append("SCHEMA").append(' ');
            buffer.append('\'').append(this.externalSchema).append('\'');
        }
        if (this.externalQuery != null) {
            buffer.append(' ').append("AS").append(' ');
            buffer.append('\'').append(this.externalQuery).append('\'');
        }
        if (this.initExprs != null) {
            boolean first = true;
            buffer.append(' ').append("VALUES").append("(");
            for (Expression value : this.initExprs) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(value.getSQL());
            }
            buffer.append(")");
        }
        if (this.dataCacheModel != null) {
            buffer.append(' ').append("WITH").append(' ');
            buffer.append(this.dataCacheModel.name()).append(' ').append("CACHE");
        }
        return buffer.toString();
    }

    public String getColumnsInfo() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        int[] pk = this.table.getPrimaryKey();
        Constraint pkConst = this.table.getPrimaryConstraint();
        for (int j = 0; j < this.table.getColumnCount(); ++j) {
            String defaultString;
            Collation collation;
            ColumnSchema column = this.table.getColumn(j);
            String colname = column.getObjectName().statementName;
            Type type = column.getDataType();
            if (j > 0) {
                buffer.append(',');
            }
            buffer.append(colname);
            buffer.append(' ');
            buffer.append(type.getTypeDefinition());
            if (type.isCharacterType() && (collation = ((CharacterType)type).getCollation()).isObjectCollation()) {
                buffer.append(' ').append("COLLATE").append(' ');
                buffer.append(collation.getObjectName().statementName);
            }
            if ((defaultString = column.getDefaultSQL()) != null) {
                buffer.append(' ').append("DEFAULT").append(' ');
                buffer.append(defaultString);
            }
            if (column.isIdentity()) {
                buffer.append(' ').append(column.getIdentitySequence().getSQLColumnDefinition());
            }
            if (column.isGenerated()) {
                buffer.append(' ').append("GENERATED").append(' ');
                buffer.append("ALWAYS").append(' ').append("AS").append("(");
                buffer.append(column.getGeneratingExpression().getSQL());
                buffer.append(")");
            }
            if (!column.isNullable()) {
                Constraint c = this.table.getNotNullConstraintForColumn(j);
                if (c != null && !c.getObjectName().isReservedName()) {
                    buffer.append(' ').append("CONSTRAINT").append(' ').append(c.getObjectName().statementName);
                }
                buffer.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (pk.length != 1 || j != pk[0] || !pkConst.getObjectName().isReservedName()) continue;
            buffer.append(' ').append("PRIMARY").append(' ').append("KEY");
        }
        for (Constraint c : this.table.getConstraints()) {
            String d;
            if (c.isForward || (d = c.getSQL()).length() <= 0) continue;
            buffer.append(',');
            buffer.append(d);
        }
        buffer.append(')');
        return buffer.toString();
    }

    private DatabaseConnection getVirtualConnectionForInsertUpdate(Session session) {
        if (session.isAutoCommitVtables()) {
            return this.server.getConnection();
        }
        DatabaseConnection connection = session.getVirtualConnectionFor(this.server);
        if (connection == null) {
            connection = this.server.getConnection();
            boolean autocommit = true;
            try {
                autocommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            catch (SQLException exception) {
                this.server.releaseConnection(connection);
                throw VirtualServerObject.sqlToDataspaceException(connection, exception);
            }
            catch (Exception exception) {
                this.server.releaseConnection(connection);
                throw new DataspaceException(exception.getMessage());
            }
            session.putVirtualConnection(this.server, new Pair<DatabaseConnection, Boolean>(connection, autocommit));
        }
        return connection;
    }

    private void releaseVirtualConnectionForInsertUpdate(Session session, DatabaseConnection connection) {
        if (session.isAutoCommitVtables()) {
            this.server.releaseConnection(connection);
        }
    }

    protected void checkServerAccess(Session session) {
        try {
            session.getGrantee().checkUsage(this.server);
        }
        catch (Exception e) {
            throw new DataspaceException("User lacks privileges to the virtual server: " + this.server.getObjectName().name);
        }
    }

    public void setVtableColumns(List<VColumnInfo> vtableColumns) {
        this.vtableColumns = vtableColumns;
    }

    public static class VColumnInfo {
        public String vColumnName;
        public String remoteColumnName;
        public Type type;

        public String getRemoteColumnName() {
            return this.remoteColumnName != null ? this.remoteColumnName : this.vColumnName;
        }
    }

    protected static class VtableColumnsMetaData {
        String columnName;
        int type;
        long precision = 0L;
        int scale = 0;
        int columnIndex = 0;
        int primaryKeyIndex = -1;
        boolean nullable = false;
        Type definedType;
        String remoteColumnName;

        protected VtableColumnsMetaData() {
        }
    }
}

