/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.view;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.collection.tspace.view.ViewProxy;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.service.osf.config.ActiveEvent;
import java.util.List;

public class ViewCollection
extends TableCollection {
    public ViewCollection(DataspaceStore database, NameManager.ObjectName name, NameManager.ObjectName[] columnNames, int check) {
        super(database, name, CollectionType.VIEW, MemoryModel.MEMORY);
        NameManager.ObjectName viewName = database.nameManager.newObjectName(name.name, name.isNameQuoted, 5);
        viewName.schema = name.schema;
        this.table = new View(database, viewName, columnNames, check);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
    }

    public View getView() {
        return (View)this.table;
    }

    public final void setName(NameManager.ObjectName name) {
        this.name = name;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new ViewProxy();
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"Source DSQL Query", ((View)this.table).getStatement()});
        return result;
    }

    @Override
    public List<ActiveEvent> getEvents() {
        List<ActiveEvent> result = super.getEvents();
        return result;
    }

    @Override
    public OrderedHashSet getReferences() {
        if (this.table != null) {
            return this.table.getReferences();
        }
        return new OrderedHashSet();
    }

    @Override
    protected void onAggregateOthers(DataspaceStateHolder holder) {
        DataspaceStateHolder viewStateHolder = this.getView().aggregateStateHolder();
        if (viewStateHolder.isSuspectState()) {
            holder.setSuspectState(viewStateHolder);
        }
    }

    public void recompileView(Session session) {
        if (this.getView() != null) {
            this.getView().recompileView(session);
        }
        if (!this.aggregateStateHolder().isSuspectState()) {
            this.compileColumnNames();
        }
    }
}

